(function() {
	'use strict';

	// Get a reference to the reportsBuilder module
	var app = angular.module('reports');

	// Controller for "Add Data Set" modal

	app.controller('customIconCtrl', [ '$scope', 'customReportSvc', function($scope, customReportSvc) {

		$scope.customSVGText = '';

		if ($scope.customReport && $scope.customReport.customIcon) {
			if ($scope.customReport.customIcon.type == 'SVG') {
				$scope.customSVGText = $scope.customReport.customIcon.content;
			}
		}

		$scope.showPreview = false;

		$scope.errorMessage = '';

		$scope.svgTextChanged = function() {
			$scope.customSVGText = DOMPurify.sanitize($scope.customSVGText, {SAFE_FOR_JQUERY: true});
			var validation = $scope.isValidSVG($scope.customSVGText);
			$scope.showPreview = false;

			if (validation.valid) {
				$scope.errorMessage = '';

				$scope.showPreview = true;
				$('#icon-preview').html($scope.customSVGText);
				$('#icon-preview svg').attr('height', '60px');
				$('#icon-preview svg').attr('width', '60px');

			} else if (!$scope.customSVGText) { // No error message when the text is blank
				$scope.errorMessage = '';
			} else {
				$scope.errorMessage = validation.errorMsg;
			}
		};

		$scope.dismissModal = function() {
			$scope.$dismiss('cancel');
		};

		$scope.saveIcon = function() {
			if ($scope.customSVGText) {
				if ($scope.isValidSVG($scope.customSVGText).valid) { // If SVG is not valid, Error message is always present
					var customIcon = {
						type : 'SVG',
						content : $scope.customSVGText
					}
					$scope.$close(customIcon);
				}
			} else {
				$scope.$close(null);
			}
		};

		$scope.isValidSVG = function(svgString) {
			$('#svg-validation-element').html(svgString);
			var svgLen = $('#svg-validation-element').find('svg').length;

			if (svgLen == 1) {
				return {
					valid : true
				};
			} else if (svgLen == 0) {
				var res = {
					valid : false,
					errorMsg : localMsg.customReport.customIcon.enterValidSVG
				};
				return res;
			} else if (svgLen > 1) {
				var res = {
					valid : false,
					errorMsg : localMsg.customReport.customIcon.enterSingleSVG
				};
				return res;
			}
		};


		$scope.openAceEditor = function(editorContent,editorMode,callback,dataVariable) {
			$scope.openAceEditorWindow(editorContent,editorMode,dataVariable,$scope,function(modifiedContent) {
				callback();
			});
		}

	} ]);
})();
