// Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	// Controller for data set tree
	app
			.controller("leftPanelCtrl",
					[
							"$scope",
							"$compile",
							"$uibModal",
							"customReportSvc",
							"reportService",
							"$rootScope",
							function($scope, $compile, $modal, customReportSvc, reportService, $rootScope) {
								/** List of data set objects */

								// left panel resizability
								$('.panel-two').resizable({
									handles : {
										'e' : '.left-splitter'
									},
									minWidth : 160,
									maxWidth : 800,
									resizeHeight : false,
									resize : function(event, ui) {
										var leftMargin = $(".panel-one").width() + $(".panel-two").width();
										$("#centerCol").css("left", leftMargin - 14);
										$("#reportContentWrapper").css("left", leftMargin - 14);
									},
									stop : function(event, ui) {
										$(".panel-two").css("height", "100%");
										$rootScope.$broadcast("gridsterItemWidthChanged", true);
									}
								});
								$scope.dataSets;
								$scope.selectedNode = {};
								$scope.selectedDataSetIndex = 0;
								$scope.tileCategories = [];//"Configuration", "Client", "Capacity Planning", "Deduplication", "Indexing and Search", "Usage Profile","Job", "Scale Statistics"]

								$scope.$watch('page', function(page) {
									if (page) {
										$scope.dataSets = $scope.page.dataSets.dataSet; // 'Data to send'
										$scope.inputs = $scope.page.inputs;
										/** Currently selected data set */
										if ($scope.dataSets && $scope.dataSets.length > 0) {
											$scope.selectedNode.node = $scope.dataSets[0];
											$scope.selectedNode.type = "dataset";
										}
									}
								});

								//tracks the node collapse status
								$scope.collapsed = {
									"datasets" : false,
									"inputs" : false,
									"loacle" : false
								};

								/** Map of data types to keywords */
								$scope.dataTypes = {
									string : "string",
									boolean : "boolean",
									date : "date",
									double : "number",
									float : "number",
									integer : "number",
									long : "number",
									short : "number",
									time : "time",
									timestamp : "time",
									decimal : "number"
								}; // end object dataTypes
								$scope.dataTypesIcons = {
									string : "ico-Aa-let-icon",
									boolean : "ico-boolean-type",
									date : "ico-calendar-full",
									double : "ico-integer-icon",
									float : "ico-integer-icon",
									integer : "ico-integer-icon",
									long : "ico-integer-icon",
									short : "ico-integer-icon",
									time : "ico-clock-sm",
									timestamp : "ico-clock-sm",
									decimal : "ico-integer-icon"
								};

								if ($scope.isTileBuilder) {
									$scope.tileStatus = [];
									$scope.tileStatus.push({
										statusId : 2,
										statusName : 'Good'
									});
									$scope.tileStatus.push({
										statusId : 3,
										statusName : 'Warning'
									});
									$scope.tileStatus.push({
										statusId : 4,
										statusName : 'Critical'
									});
								}

								/**
								 * Set the "hidden" property to true in all children of the node
								 * 
								 * @param {Object}
								 *            node Node to collapse
								 */
								$scope.toggleCollapse = function(node) {
									node.hidden = !node.hidden;
								}; // end method toggleCollapse

								/**
								 * Mark a data set as selected
								 * 
								 * @param {Object}
								 *            dataSet Selected data set
								 */
								$scope.selectDataSet = function(dataSet, index) {
									$scope.selectedDataSetIndex = index;
									$scope.selectedNode.node = dataSet
									$scope.selectedNode.type = "dataset";
								}; // end method selectDataSet

								$scope.clearSelection = function() {
									$scope.selectedNode = {};
								};

								$scope.selectInput = function(input, index) {
									$scope.selectedNode.node = input;
									$scope.selectedNode.type = "input";
									$scope.selectedInputIndex = index;
								}; //

								/**
								 * Add a data set to the list of data sets
								 * 
								 * @param {Object}
								 *            dataSet Data set to append to list
								 */
								$scope.addDataSet = function(dataSet) {
									$scope.dataSets.push(dataSet);
								}; // end method addDataSet

								/**
								 * Delete the selected data set
								 */

								$scope.deleteNode = function() {
									if ($scope.selectedNode.type == "dataset") {
										$scope.deleteDataSet();
									} else {
										$scope.deleteInput($scope.selectedNode.node);
									}
								};

								$scope.deleteDataSet = function() {
									var ds = $scope.selectedNode.node;
									var modalInstance = $modal
											.open({
												templateUrl : "modal/views/confirmModal.html",
												controller : "confirmModalCtrl",
												backdrop : 'static',
												keyboard : false,
												resolve : {
													modalTitle : function() {
														return "Confirm";
													},
													modalMessage : function() {
														return "Deleting data set " + ds.dataSet.dataSetName +
																" will remove all the components associated to this dataset. Would you like to continue ?";
													}
												}

											});

									modalInstance.result.then(function() {
										$scope.deleteDataSetFromPage($scope.selectedNode.node);
										if ($scope.dataSets.length > 0) {
											$scope.selectDataSet($scope.dataSets[0]);
										} else {
											$scope.clearSelection();
										}
									});

								}; // end method deleteDataSet

								$scope.deleteInput = function(selectedInput) {
									$scope.inputs.splice($scope.inputs.indexOf($scope.selectedNode.node), 1);
									$scope.addRemoveTextLocalization(selectedInput,false);
									customReportSvc.triggerCallback("inputUpdated", {
										inputs:$scope.inputs
									});

									if ($scope.inputs.length > 0) {
										$scope.selectInput($scope.inputs[0]);
									} else {
										$scope.clearSelection();
									}
								}; // end method deleteInput
								/**
								 * Display a modal providing options to add a data set
								 */
								$scope.showAddDataSetModal = function(dataSet, mode) {
									// text to be shown in modal dialog heading
									$scope.mode = mode || "Add";
									if (dataSet) {
										dataSet.selected = true;
										$scope.dataSet = angular.copy(dataSet);
									} else {
										$scope.dataSet = undefined;
									}
									var modalInstance = $modal.open({
										templateUrl : "addDataSetModal/modal.jsp",
										size : "lg",
										controller : "addDataSetModalCtrl",
										backdrop : 'static',
										scope : $scope
									});

									modalInstance.result.then(function(dataSet) {
										if (dataSet) {
											var index = mode === "Edit" ? $scope.selectedDataSetIndex : -1;
											$scope.updateDataSets(dataSet, index);
											$scope.dataSet = undefined;
											$scope.selectedDataSetIndex = -1;
											$scope.selectedNode.node = undefined;// set selectedNode to undefined since we are clearing activeDataSet.
											//$scope.checkAndAddMetricsConfg(dataSet);
										}
									}, function() {
										$scope.dataSet = undefined;
									});

								}; // end method showAddDataSetModal

								$scope.showEditModal = function() {
									if ($scope.selectedNode.type == "dataset") {
										$scope.showAddDataSetModal($scope.selectedNode.node, "Edit");
									} else {
										$scope.showInputModal($scope.selectedNode.node);
									}
								};

								$scope.showEditDataSetModal = function(node) {
									//setting the active data set, so that it can be reused in the modal.js
									var activeDataSet = node;
									activeDataSet.selected = true;
									var modalInstance = $modal.open({
										templateUrl : "addDataSetModal/modal.jsp",
										size : "lg",
										controller : "addDataSetModalCtrl",
										backdrop : 'static',
										resolve : {
											page : function() {
												return $scope.page;
											},
											dataSets : function() {
												return $scope.page.dataSets;
											},
											dataSet : function() {
												return activeDataSet;
											},
											mode : function() {
												return 'edit';
											}
										}
									});

									modalInstance.result.then(function(datasets) {
										activeDataSet.selected = false;
										//$scope.checkAndAddMetricsConfg(activeDataSet);
										$scope.selectedNode.node = undefined;// set selectedNode to undefined since we are clearing activeDataSet.
									}, function() {
										activeDataSet.selected = false;
										$scope.selectedNode.node = undefined;
									});

								}; // end method showEditDataSetModal

								$scope.checkAndAddMetricsConfg = function(dataSet){

									if( dataSet.databaseName.toLowerCase() !== 'cvcloud'){
										return;
									}


									let connectionTypes = _.map(dataSet.dataSources,'connectionType');
									let isMetrics = connectionTypes.indexOf('METRICS') !== -1;
									let isCommCellConnectionType = connectionTypes.indexOf('COMMCELL') !== -1;
									let isCommCell = false;
									if(isCommCellConnectionType && dataSet.dataSources.length === 1 && dataSet.dataSources[0].commCell.commCellName === '$LocalCommCell$'){
										isCommCell = true;
									}

									if(isMetrics || isCommCell){
										$scope.addSystemTagsAndInputs();
									}
								}

								/**
								 * auto add System tag metrics so that the reports will be shown at commcell
								 * level and commcell group level behavior add inputs automatically for
								 * Metrics Dataset to control the the commcell and commcell group level
								 * behavior.
								 * 
								 */
								let defaultMetricsInputs = [{id:'commCellId',value:0},{id:'commcellGroupId',value:-1}];
								$scope.addSystemTagsAndInputs = function(){

									let inputIds = _.map($scope.page.inputs,'id');
									_.map(defaultMetricsInputs,function(defaultInput){
										if(inputIds.indexOf(defaultInput.id) === -1){
											$scope.page.inputs.push({
													"id":defaultInput.id,
													"displayName":"CommcellId",
													"defaultValue":defaultInput.value,
													"type":"String",
													"controlType":"Hidden",
													"required":false,
													"fromDataSet":false
												});
										}
									});

									if (!$scope.customReport.systemTags) {
										$scope.customReport.systemTags = [];
									}

									$scope.autoBindInputsToParameters();
								}

								//add inputs automatically for Metrics Dataset to control the the commcell and commcell group level behavior.
								$scope.autoBindInputsToParameters = function(){

								}

								$scope.getCustomIconLinkText = function() {
									if ($scope.customReport && $scope.customReport.customIcon ) {
										if ($scope.customReport.customIcon.type == 'SVG' && $scope.customReport.customIcon.content) {
											return localMsg.customReport.customIcon.custom;
										}
									}
									return localMsg.customReport.customIcon.none;
								};

								$scope.showEditIconDialog = function() {
									var modalInstance = $modal.open({
										templateUrl : 'leftPanel/modals/customIconDialog.jsp',
										size : 'md',
										controller : 'customIconCtrl',
										backdrop : 'static',
										scope : $scope,
										resolve : {
											customReport : $scope.customReport
										}
									});

									modalInstance.result.then(function(customIcon) {
										$scope.customReport.customIcon = customIcon;
									});
								};

								 $scope.moveInput = function(direction) {
	                                    var index = $scope.inputs.indexOf($scope.selectedNode.node);
	                                    if (direction == "UP") {
	                                        $scope.inputs.splice(index, 1);
	                                        $scope.inputs.splice(index - 1, 0, $scope.selectedNode.node);
	                                    } else {
	                                        $scope.inputs.splice(index, 1);
	                                        $scope.inputs.splice(index + 1, 0, $scope.selectedNode.node);
	                                    }
	                                    $scope.selectedInputIndex = $scope.inputs.indexOf($scope.selectedNode.node);
	                                	customReportSvc.triggerCallback("inputUpdated", {
											inputs:$scope.inputs
										});
	                            }

								$scope.showInputModal = function(node) {
									var modalInstance = $modal.open({
										templateUrl : "reportInputs/reportInputsModal.jsp",
										size : "lg",
										controller : "reportInputModalCtrl",
										backdrop : 'static',
										windowClass : 'input-modal-window',
										resolve : {
											page : function() {
												return $scope.page;
											},
											treeNode : function() {
												return node;
											},
											builderVersion : function(){
												return $scope.customReport.builderVersion;
											},
											mergedParams: function(){
												return $scope.mergedParams;
											},
											cacheId: function(){
												return $scope.cacheId;
											}
										}
									});

									modalInstance.result.then(function(inputs) {
										if (inputs) {
											$scope.inputs = inputs;
											if ($scope.selectedNode.type === 'input') {
												var selectedInput = undefined;
												angular.forEach($scope.inputs, function(input) {
													if ($scope.selectedNode.node && $scope.selectedNode.node.id === input.id) {
														selectedInput = input;
														return;
													}
												});
												if (selectedInput) {
													$scope.addRemoveTextLocalization(selectedInput,false);
													$scope.selectedNode.node = selectedInput;
												}
											}
											$scope.collapsed.inputs = false;
										}

									});
								}; // end method showEditDataSetModal

								$scope.addRemoveTextLocalization = function(input,isDelete){
									if(input.controlType == 'TextBox'){

										let key = "Enter "+input.displayName;
										let translation = _.find($scope.customReport.translations,{localeKey:key});
										if(!isDelete && !translation){
											$scope.customReport.translations.push({ locale: "default", localeKey: key, localeValue: key });
										}else{
											_.remove($scope.customReport.translations,{localeKey:key});
										}
										console.log(input);
										console.log($scope.customReport.translations);
									}
								}

								$scope.showLocaleModal = function() {
									$modal.open({
										templateUrl : "localization/modal.jsp",
										size : "lg",
										controller : "localizationModalCtrl",
										scope : $scope,
										backdrop : 'static'
									});
								}; //end method showLocaleModal

								//get the $scope.tags from the api all
								$scope.tags = [];
								var tagsLen = 0;
								var constructTags = function(array) {
									var result = [];
									for (var i = 0; i < array.length; i++) {
										var current = array[i].tagName;
										if(current === "Microsoft Reporting"){
											continue;
										}
										if (result.indexOf(current) < 0) {
											result.push(current);
										}
									}
									return result.sort();
								}
								var getTagsJson = function() {
									reportService.getReportsTags().then(function(data) {
										$scope.tags = constructTags(data.data);
										tagsLen = $scope.tags.length;
									},function(e) {
										console.error(e)
									});
								}
								getTagsJson();

								//add for the UI tags
								$scope.addCustomuiTags = function(event) {
									if (!$scope.customReport.uiTags) {
										$scope.customReport.uiTags = [];
									}
									$scope.customReport.uiTags.push("");
									event.stopPropagation();
								};

								$scope.deleteElement = function(array, index) {
									array.splice(index, 1);
								}

								//add for the system tags
								$scope.addSystemTags = function(event) {
									if (!$scope.customReport.systemTags) {
										$scope.customReport.systemTags = [];
									}
									$scope.customReport.systemTags.push("");
									event.stopPropagation();
								};

								$scope.systemPrevTags = [
										"SM_Report",
										"LM_Report",
										"Dashboard",
										"Admin_Console",
										"Endpoint",
										"VSA",
										"DBS",
										"EBS",
										"CloudApps",
										"SalesForce",
										"Exchange",
										"Archiving",
										"Sharepoint",
										"Compliance"
								];

								$scope.addThreshold = function() {
									if (!$scope.tileProperties.thresholds) {
										$scope.tileProperties.thresholds = [];
									}

									if ($scope.tileProperties.thresholds.length > 0) {
										var t = $scope.tileProperties.thresholds[$scope.tileProperties.thresholds.length - 1];

										if (!t.status || !t.value) {
											$scope.clearThresholdSelection();
											t.selected = true;
											return;
										}
									}
									$scope.tileProperties.thresholds.push({});

								}

								$scope.deleteThreshold = function() {
									var deleteIndex = -1;
									if ($scope.tileProperties.thresholds) {
										for (var thIndex = 0; thIndex < $scope.tileProperties.thresholds.length; thIndex++) {
											if ($scope.tileProperties.thresholds[thIndex].selected == true) {
												deleteIndex = thIndex
											}
										}
										$scope.tileProperties.thresholds.splice(index, 1);
									}
								}

								$scope.selectThreshold = function(index) {
									$scope.tileProperties.thresholds[index].selected = true;
								}

								$scope.clearThresholdSelection = function() {
									angular.forEach($scope.tileProperties.thresholds, function(th) {
										th.selected = false;
									});
								}
								$scope.initTileProperties = function() {
									var params = {
										dataSetName : "Tile Categories",
										action : "retrieveDataSetByGet.do",
										orderByClause : "CategoryName"
									}

									reportService.getRawData(params).then(function(data) {
										var response = data.data;
										angular.forEach(response.records, function(cat) {
											var category = {
												id : cat[2],
												name : cat[3]
											}
											$scope.tileCategories.push(category);
										});

										if (!$scope.tileProperties.category) {
											$scope.tileProperties.category = $scope.tileCategories[0];
										}

									}, function(xhr, ajaxOptions, thrownError) {
										if (thrownError != 'userAborted') {
											customReportSvc.errorToast(xhr.data.trim());
										}
									});
								}

								if ($scope.isTileBuilder) {
									$scope.initTileProperties();
								}

							} ]) // end controller dataSetCtrl

})();