var reportManager = {};
var cacheInterval;
var reportInterval;
var dbErrorText = false;
var associateAction = "new";
var reportsAlreadyAssocaited = false;
var rptSettingsLoaded = false;
window.alarmsLoaded = false;
window.dsContextsLoaded = false;

$(".prefList").click(function(e) {
	var divUrl = $(e.target).attr("data-div");
	$(".rightDivs").hide();
	$("#" + divUrl).show();
	$(".prefList li").removeClass("selected");
	$(e.target).addClass("selected");
	if (divUrl == 'advSettings') {
		setReportParams();
	}
});
$(".prefList li").hover(function() {
	$(this).addClass("hover");
}, function() {
	$(this).removeClass("hover");
});
var defaultPorts = {
	oracle : 1521,
	mysql : 3306,
	sqlserver : 0
};
/*
 * function validateDBForm(){ var success = true; var id =
 * $('input:radio[name=registrationType]:checked').val() == 'foreignCommcell' ? "foreignCommcell" :
 * "foreignDatabase"; $('#'+id +' input.required').each(function(i,val){ if($.trim($(this).val()) == ''){
 * success = false;
 * 
 * $('.dbError').empty().append(localMsg.requiredFieldsMsg); $('.dbError').css('visibility','visible'); } });
 * return success; }
 */

function setReportParams() {
	if (!rptSettingsLoaded) {
		cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + "/server/getReportSettings", {}, function(data) {
			cacheInterval = $(".cacheInterval").spinner({
				min : 10,
				max : 999
			});
			reportInterval = $(".timeOutInterval").spinner({
				min : 2,
				max : 30
			});
			cacheInterval.spinner("value", data.dataInterval);
			reportInterval.spinner("value", data.reportInterval);
			var hideDSchecked = $.trim(data.hideDScolumn) == "1" ? true : false;
			$('.hideDSColumn').prop('checked', hideDSchecked);
			rptSettingsLoaded = true;

		}, function(xhr, ajaxOptions, thrownError) {
			$("#content").unmask();
			cvUtil.errorToast($.trim(xhr.responseText), 30000);
			$("#queryName").val("");
			$(".saveQuery").dialog("destroy");
		});

	}
}

function validateAndReturnDBData() {
	var isForiegnCommcell = $('input:radio[name=registrationType]:checked').val() == 'foreignCommcell' ? true : false;
	if ($('input:radio[name=registrationType]').length == 0) {
		isForiegnCommcell = true;
	}
	var obj = new Object();
	obj.isForiegnCommcell = isForiegnCommcell;
	if (isForiegnCommcell) {
		obj.username = $("input[name='userName']").val();
		obj.password = Base64.encode($("#commcell-password").val());
		obj.host = $("input[name='commcell']").val();
		obj.databaseType = "sqlserver";
	} else {
		obj.connectionName = $("input[name='connectionName']").val();
		obj.databaseType = $("#dbType").val();
		obj.dbName = $("input[name='database']").val();
		if (obj.connectionName == '') {
			obj.connectionName = obj.dbName;
		}
		obj.instanceName = $("input[name='instance']").val();
		obj.host = $("input[name='host']").val();
		obj.hostId = $("input[name='hostId']").val();
		obj.port = $("input[name='port']").val();
		var user = $("input[name='username']").val();
		obj.username = user;
		obj.password = Base64.encode($("#datasource-password").val());
	}
	return obj;
}

function validateDBForm() {
	var success = true;
	var id = $('input:radio[name=registrationType]:checked').val() == 'foreignCommcell' ? "foreignCommcell"
			: "foreignDatabase";
	$('#' + id + ' input.required').each(function(i, val) {
		if ($.trim($(this).val()) == '') {
			success = false;
			$(this).addClass('formError');
			$('.dbError').addClass('formErrorContent');
			$('.dbError').empty().append(localMsg.requiredFieldsMsg);
			$('.dbError').css('visibility', 'visible');
		}
	});

	if ($("input[name='pwd']").val() == '**********') {
		success = false;
		$("input[name='pwd']").addClass('formError');
		$('.dbError').empty().append('Please enter the password to save changes.');
		$('.dbError').css('visibility', 'visible');
	}

	return success;
}

function connectAndSaveDB() {
	var isValid = validateDBForm();
	if (isValid) {
		resetDBError();
		$("#content").mask(localMsg.saveDataBaseDetailsMsg);
		var formData = validateAndReturnDBData();
		registerDataBase("/server/registerDataSource.do", formData);
	}
}

function registerDataBase(url, formData) {
	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + url, formData, function(data) {
		$("#content").unmask();
		cvUtil.toast(data, 30000);
		refreshContexts(true);
		resetFields();
		closeAddDataSourceForm();
		$("#content").unmask();
	}, function(xhr, ajaxOptions, thrownError) {
		$("#content").unmask();
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
		$("#queryName").val("");
		$(".saveQuery").dialog("destroy");
	});

}

function resetFields() {
	$(".dbFormInput").val("");
	$("#dbType").val('oracle');
	$('.dbFormInput[name="port"]').val('1521');
	$('.instance').addClass('hidden');
	$('.dbname').removeClass('hidden');
}
function saveReportSettings() {
	var dInterval = cacheInterval.spinner("value");
	var rInterval = reportInterval.spinner("value");
	var hideDsColumn = $('.hideDSColumn').is(':checked');
	var formData = {
		dataInterval : dInterval,
		reportInterval : rInterval,
		hideDsColumn : hideDsColumn
	};
	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + "/server/saveReportSettings", formData, function(data) {
		cvUtil.toast(localMsg.saveSettingsSuccessMsg);
	}, function(xhr, ajaxOptions, thrownError) {
		$("#content").unmask();
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
		$("#queryName").val("");
		$(".saveQuery").dialog("destroy");
	});

}

function showHostToReportAssociation(typeOfServer, isForiegnCommcell, hostId) {

	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + "/server/getCustomReportsForHost", {
		typeOfServer : typeOfServer,
		isForiegnCommcell : isForiegnCommcell,
		hostId : hostId
	}, function(data) {
		if (data.length > 0) {
			adddReportsToFrame(data);
		} else {
			cvUtil.toast(localMsg.noReportsAvailableToAsoociate + ' ' + typeOfServer);
		}
	}, function(xhr, ajaxOptions, thrownError) {
		$("#content").unmask();
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
		$("#queryName").val("");
		$(".saveQuery").dialog("destroy");
	});

}

function adddReportsToFrame(data) {
	$("#availableUserList li").remove();
	$("#selectedUserList li").remove();
	$.each(data, function(i, report) {
		var sourceLi = $("<li></li>", {
			text : report.reportName,
			class : "selectableuser",
			id : "selectable" + report.id,
			"data-reportName" : report.reportName,
			"data-id" : report.id,
			"data-associated" : report.associated
		});
		if (!report.associated) {
			$("#availableUserList").append(sourceLi);
		} else {
			reportsAlreadyAssocaited = true;
			$("#selectedUserList").append(sourceLi);
			$("#button-ok").button("enable");
		}
	});

	$('#search').keyup(function(event) {
		var search_text = $('#search').val();
		var rg = new RegExp(search_text, 'i');
		$("#availableUserList li").each(function(i) {
			if ($.trim($(this).html()).search(rg) == -1) {
				$(this).css('display', 'none');
			} else {
				$(this).css('display', '');
			}
		});
	});

	$(".selectableuser").click(function() {
		if ($(this).hasClass('selectedUser')) {
			$(this).removeClass('selectedUser');
		} else {
			$(this).addClass('selectedUser');
		}
	});

	$("#userAssociationframe").dialog('open');

}

function addToSelectedList(userid, type) {
	var element = removeFromSelectedList("#selectable" + type + userid);
	//element.removeClass('selectableuser');
	if (element.hasClass('selectedUser')) {
		element.removeClass('selectedUser');
	}
	$("#selectedUserList").append(element[0]);
	$("#button-ok").button("enable");
}

function resetDBError() {
	$('.dbFormInput.required').removeClass('formError');
	removeDbError();
}

function removeDbError() {
	$('.dbError').append(" ");
	$('.dbError').css('visibility', 'hidden');
}

function showAddDataSourceForm(action) {

	if (!$('#dbForm').is(':visible')) {
		$("#dbForm").toggle('Clip');
	}

	if (action == 'new' || action == '') {
		resetFields();
		$('input:radio[value=foreignCommcell]').trigger('click');
		$('.radioLabel[for=foreignCommcellRadio]').text(localMsg.addForeignCommcell);
		$('.radioLabel[for=foreignDatabaseRadio]').text(localMsg.addForeignDatabase);
	}

	if (action == 'edit') {
		$('.radioLabel[for=foreignCommcellRadio]').text(localMsg.editForeignCommcell);
		$('.radioLabel[for=foreignDatabaseRadio]').text(localMsg.editForeignDatabase);
	}
}

function updateDataSourceLayout(sourceType) {
	var list = $("li", $("#" + sourceType + " ul"));
	if (list.length == 0) {
		$("#" + sourceType).css('height', '40px');
		$("#" + sourceType + " ul").append('<li class="dsList emptyList">' + localMsg.noDataSources + '</li>');
	} else {
		$("#" + sourceType).css('height', 'auto');
		//fixed for data source overlap
		//$("#" + sourceType).css('max-height', '300px');
	}
}

function closeAddDataSourceForm() {
	$('.dbFormInput').val("");
	$("#dbForm").toggle('Clip');
}

function refreshContexts(refresh) {
	$("#settingsTabs").mask(localMsg.refreshDataSourceListMsg);

	var url = "/server/dsList.do"

	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + url, {
		refreshDataSources : refresh
	}, function(commcells) {
		window.dsContextsLoaded = true;
		commcells = JSON.parse(commcells);
		$('.dsList').remove();
		$.each(commcells, function(i, ds) {
			$("#content").unmask();

			if (ds.dbType === 'commcells' && ds.dbName !== "") {
				var ulRoot = $("#commcell ul");
				var cbtype = "commcellcb";
			} else if (ds.remote && ds.dbType === 'oracle') {
				ulRoot = $("#oracle ul");
				cbtype = "oraclecb";
			} else if (ds.remote && ds.dbType === 'sqlserver') {
				ulRoot = $("#sqlserver ul");
				cbtype = "sqlservercb";
			} else if (ds.remote && ds.dbType === 'mysql') {
				ulRoot = $("#mysql ul");
				cbtype = "mysqlcb";
			}

			if (ulRoot && cbtype && ds.id) {
				if (ds.isMaster == true || ds.podCommCell == true) {
					if (ds.isMaster == true) {
						ds.connectionName = "Local (" + ds.connectionName + ")";
					}

					ulRoot.append('<li class="dsList"><div id="' + ds.id + '" class="dsCheckBox unchecked ' + cbtype +
							'" data-podcommcell="' + ds.podCommCell + '" data-csguid="' + ds.csGuiId +
							'" data-password="' + ds.password + '" data-username="' + ds.username +
							'" data-ccClientId="' + ds.ccClientId + '" data-cbtype="' + cbtype + '" data-host="' +
							ds.host + '" data-dbName="' + ds.dbName + '" data-instance="' + ds.instance +
							'" data-id="' + ds.id + '" data-error="' + ds.error + '" data-type="' + ds.dbType +
							'" data-isremote="' + ds.remote + '" data-master="' + ds.isMaster +
							'" data-state="unchecked" data-connectionname="' + ds.connectionName +
							'"></div><span class="custom-cb-label" >' + ds.connectionName +
							'</span><span class="sprite icon-delete_icon inlineLink deletLink hide" title="' +
							localMsg.deleteDataSourceTitle +
							'"></span><a class="sprite icon-edit-disabled inlineLink editLink hide" title="' +
							localMsg.editDataSourceTitle + '"></a></li>');
				} else {
					ulRoot.append('<li class="dsList"><div id="' + ds.id + '" class="dsCheckBox unchecked ' + cbtype +
							'" data-podcommcell="' + ds.podCommCell + '" data-csguid="' + ds.csGuiId +
							'" data-password="' + ds.password + '" data-username="' + ds.username +
							'" data-ccClientId="' + ds.ccClientId + '" data-cbtype="' + cbtype + '" data-host="' +
							ds.host + '" data-dbName="' + ds.dbName + '" data-instance="' + ds.instance +
							'" data-id="' + ds.id + '" data-error="' + ds.error + '" data-port="' + ds.port +
							'"  data-type="' + ds.dbType + '" data-isremote="' + ds.remote + '" data-master="' +
							ds.isMaster + '" data-state="unchecked" data-connectionname="' + ds.connectionName +
							'"></div><span class="custom-cb-label" >' + ds.connectionName +
							'</span><a class="sprite icon-delete_icon inlineLink deletLink" title="' +
							localMsg.deleteDataSourceTitle +
							'"></a><a class="sprite icon-edit-disabled inlineLink editLink" title="' +
							localMsg.editDataSourceTitle + '"></a></li>');
				}
			}

		});

		$("#commcellList li.dsList div").each(function(i, val) {
			if ($(this).attr('id') == '1' || $(this).data('podcommcell') == true) {
				$(this).siblings('.editLink').hide();
			}
		});

		//$("#filterPanel").toggle();
		$(".headClass").on("click", function() {
			$("#filterPanel").toggle();
			$("#groupSelectionArrow").toggleClass("up");
		});

		updateDataSourceLayout("commcell");
		updateDataSourceLayout("mysql");
		updateDataSourceLayout("oracle");
		updateDataSourceLayout("sqlserver");

		$('a.deletLink').on('click', function(evt) {
			$('#dbForm').hide();
			showDisableHost($(this));
		});
		
		$('a.securityLink').on('click', function(evt) {
			var entityId = $($(this).siblings('div')).attr('id');
			var entityName = $($(this).siblings('div')).data('connectionname');
			var isRemoteDb = $($(this).siblings('div')).data('isremote');
			var entityType = isRemoteDb ? 128 : 1;
			angular.element("#reportManagerTable").scope().showSecurityModal({
     			entityType : entityType,
     			entityId : entityId,
     			entityName : entityName     			
     		});		
			
		});

		$('a.editLink').on('click', function(evt) {
			var isRemoteDb = $($(this).siblings('div')).data('isremote');
			var hostId = $($(this).siblings('div')).attr('id');
			var connectionname = $($(this).siblings('div')).data('connectionname');
			var host = $($(this).siblings('div')).data('host');
			var dbName = $($(this).siblings('div')).data('dbname');
			var dbType = $($(this).siblings('div')).data('type');
			var instance = $($(this).siblings('div')).data('instance');
			var port = $($(this).siblings('div')).data('port');
			var username = $($(this).siblings('div')).data('username');
			var password = $($(this).siblings('div')).data('password');
			associateAction = "edit";
			$("#foreignDatabaseRadio").hide();
			$("#foreignCommcellRadio").hide();
			if (isRemoteDb) {
				$($("#dbForm ul li")[0]).hide();
				$($("#dbForm ul li")[1]).show();
				$('input:radio[value=foreignDatabase]').trigger('click');
				$('#dbType').val(dbType);
				$('#dbType').change();
				$('.dbFormInput[name="connectionName"]').val(connectionname);
				$('.dbFormInput[name="host"]').val(host);
				$('.dbFormInput[name="database"]').val(dbName);
				$('.dbFormInput[name="instance"]').val(instance);
				$('.dbFormInput[name="hostId"]').val(hostId);
				$('.dbFormInput[name="port"]').val(port);
				$('.dbFormInput[name="username"]').val(username); //dont show username on edit
				//$('.dbFormInput[name="pwd"]').val(password); //dont show password on edit

			} else {
				$($("#dbForm ul li")[1]).hide();
				$($("#dbForm ul li")[0]).show();
				$('.clientEntity').show();
				$('.dbFormInput[name="clientName"]').val(connectionname);
				$('.dbFormInput[name="commcell"]').val(host);
				$('input:radio[value=foreignCommcell]').trigger('click');

			}
			showAddDataSourceForm('edit');

			//disableHost(hostId, isRemote,hostName);
		});

		$('a.associateLink').on('click',
				function(evt) {
					var dbType = $($(this).siblings('div')).data('type');
					var isRemote = $($(this).siblings('div')).data('isremote');
					var hostId = $($(this).siblings('div')).attr('id');
					$("#hostId").val(hostId);
					var hostName = $($(this).siblings('div')).data('connectionname');
					reportsAlreadyAssocaited = false;
					associateAction = "edit";
					$("#button-ok").button("disable");
					$("#userAssociationframe").dialog('option',
							'title',
							localMsg.associateDisassociateReportsToThisHost + ' "' + hostName + '"');
					showHostToReportAssociation(dbType, !isRemote, hostId);
				});
	}, function(xhr, ajaxOptions, thrownError) {
		$("#content").unmask();
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
	});
}

function clearCacheNow() {

	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + "/server/clearH2Cache.do", {}, function(data) {
		cvUtil.toast(localMsg.clearCacheSuccessMsg);
	}, function(xhr, ajaxOptions, thrownError) {
		$("#content").unmask();
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
	});
}

function updateHostToReportAssociation(reports, host) {
	$("#content").mask(localMsg.reportToHostAssocaitionMask);
	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + "/server/updateHostToReportAssociation", {
		reports : reports,
		host : host
	}, function(data) {
		if (associateAction == 'new') {
			cvUtil.toast(localMsg.reportsAssociatedSuccessMsg);
		} else if (associateAction == 'edit') {
			cvUtil.toast(localMsg.editassociateDisassociateMessage);
		}
		$("#content").unmask();
	}, function(xhr, ajaxOptions, thrownError) {
		$("#content").unmask();
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
	});
}

function disableHost(hostId, isRemote, connName, host, ccClientId, csguid) {
	$("#content").mask(localMsg.deletingDataSourceMessage);

	var url = "/server/disableDataSource.do";

	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + url, {
		hostId : hostId,
		isRemote : isRemote,
		connName : connName,
		host : host,
		ccClientId : ccClientId,
		csguid : csguid
	}, function(data) {
		refreshContexts(true);
		cvUtil.toast(data);
		$("#content").unmask();
	}, function(xhr, ajaxOptions, thrownError) {
		$("#content").unmask();
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
	});
}

function showDisableHost(selectedDiv) {
	$(".disableHost").dialog({
		width : 410,
		modal : true,
		title : localMsg.confirm,
		resizable : false,
		buttons : [ {
			id : "button-cancel",
			text : localMsg.No,
			click : function() {
				$(this).dialog("close");
				$("#content").unmask();
			}
		}, {
			id : "button-ok",
			text : localMsg.Yes,
			click : function() {
				var hostId = $(selectedDiv.siblings('div')).attr('id');
				var connName = $(selectedDiv.siblings('div')).data('connectionname');
				var isRemote = $(selectedDiv.siblings('div')).data('isremote');
				var host = $(selectedDiv.siblings('div')).data('host');
				var ccClientId = $(selectedDiv.siblings('div')).data('ccclientid');
				var csguid = $(selectedDiv.siblings('div')).data('csguid');
				disableHost(hostId, isRemote, connName, host, ccClientId, csguid);
				$(this).dialog("close");
			}
		} ],
		close : function() {
		}

	});
}

reportManager.saveSLADays = function() {
	if ($(".slaDays").length <= 0) {
		return;
	}
	var days = $('.slaDays').val();
	var data = {};
	data.slaDays = days;

	cvUtil.mask("#content");
	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + "/reports/saveSLADays.do", data, function(resp) {
		cvUtil.unmask("#content");
		if (resp.errorCode == 0) {
			slaDays = days;
		} else {
			cvUtil.toast(resp.errorMsg);
		}
	}, function(xhr, ajaxOptions, thrownError) {
		cvUtil.unmask("#content");
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
	});
}

reportManager.getSLADays = function() {
	if ($(".slaDays").length <= 0) {
		return 30;
	}
	var data = {};
	cvUtil.mask("#content");
	cvUtil.loadPageWithSessionCheck(cvUtil.getContextPath() + "/reports/getSLADays.do", data, function(resp) {
		cvUtil.unmask("#content");
		if (resp) {
			if (resp.noSLAData) {
				$(".slaDays").prop("disabled", true);
				$(".slaDaysLabel").css("color", "#8b8b8b");
				$("#saveSLA").addClass("disabled");
			} else {
				$(".slaSettings").removeClass("hide");
				$(".slaDays option[value='" + resp.days + "']").attr('selected', 'selected');
				$(".slaDays").siblings("#saveSettingsButton").show().addClass("disabled");
			}

		} else {
			cvUtil.toast('Unable to get SLA days.');
		}
	}, function(xhr, ajaxOptions, thrownError) {
		cvUtil.unmask("#content");
		cvUtil.errorToast($.trim(xhr.responseText), 30000);
	});
}

$(document).ready(function() {
	$($(".prefList li")[0]).trigger("click");

	$("#reportSettingsLi a").click(function() {
		reportManager.getSLADays();
		//setReportParams();
	});
	if ($("#advSettings").is(":visible")) {
		reportManager.getSLADays();
		//setReportParams();
	}

	$("#alarmsLi a").click(function() {
		//window.location.hash = "#alarmsSettings";
		if (!window.alarmsLoaded) {
			loadCommCellsAndCallback();
		}
	});
	if ($("#alarmsSettings").is(":visible")) {
		//window.location.hash = "#alarmsSettings";
		if (!window.alarmsLoaded) {
			loadCommCellsAndCallback();
		}
	}

	/*
	 * $(".settingHeaderLi > a").click(function(){ var hash = $(this).parent().data("div");
	 * window.location.hash = "" + hash; });
	 */

	$('#dbForm').tabs();
	$('#dbForm').css('background', '#f6f6f6');
	$('#dbForm .ui-widget-header').css('background', '#f6f6f6');
	$('#dbForm .ui-state-active ').css('background', '#f6f6f6');
	$('#dbForm .ui-state-default').css('background', '#f6f6f6');
	$('#dbForm .ui-state-default').css('border', 'none');

	$('input[name=registrationType]').click(function() {
		resetDBError();
		$('#dbForm').tabs('select', $(this).val());
		var port = defaultPorts[$("#dbType").val()];
		$('.dbFormInput[name="port"]').val(port);
	});

	$('.dbFormInput[name="connectionName"]').bind('keypress', function(e) {
		console.log(e.which);
		if (e.which == 60 || e.which == 62 || e.which == 47 || e.which == 92) {//
			e.preventDefault();
		}
	});

	$('input.required').focus(function() {
		$(this).removeClass('formError');

		if (!$('.required').hasClass('formError') && !dbErrorText) {
			removeDbError();
		}
	});

	$(".closeDBForm").insertAfter($("#dbForm ul li")[1]);

	$('#dbType').on('change', function(evt) {
		var port = defaultPorts[$("#dbType").val()];
		$('.dbFormInput[name="port"]').val(port);
		if ($(this).val() == 'sqlserver') {
			$('.instance').removeClass('hidden');
			$('.dbname').addClass('hidden');
		} else {
			$('.instance').addClass('hidden');
			$('.dbname').removeClass('hidden');

		}
		if ($(this).val() == 'oracle') {
			$('.dbFormInput[name="database"]').addClass('required');
		} else {
			$('.dbFormInput[name="database"]').removeClass('required');
			$('.dbFormInput[name="database"]').removeClass('formError');
		}

	});

	$('#submitButton').on('click', function(evt) {
		connectAndSaveDB();
	});
	$(".slaDays.dbFormInput").change(function() {
		$(".slaDays").siblings("#saveSettingsButton").removeClass("disabled");
	});

	$('#saveSLA').on('click', function(evt) {
		//saveReportSettings();
		reportManager.saveSLADays();
	});

	$(".closeDBForm").on("click", function(evt) {
		closeAddDataSourceForm();
	});

	$(".addDatasource a").on("click", function(evt) {
		$("#foreignDatabaseRadio").show();
		$("#foreignCommcellRadio").show();
		$($("#dbForm ul li")[0]).show();
		$($("#dbForm ul li")[1]).show();
		$('.clientEntity').hide();
		associateAction = "new";
		showAddDataSourceForm('new');

	});

	$("#generalLi a").click(function() {
		if (!window.dsContextsLoaded) {
			refreshContexts(false);
		}
	});
	if ($("#managedDataSources").is(":visible")) {
		if (!window.dsContextsLoaded) {
			refreshContexts(false);
		}
	}
	$('#clearCacheNow').on('click', function(evt) {
		clearCacheNow();
	});

	$("#userAssociationframe").dialog({
		autoOpen : false,
		width : 790,
		resizable : false,
		modal : true,
		buttons : [ {
			id : "button-ok",
			text : "Ok",
			click : function() {
				var reports = "";
				$.each($("#selectedUserList li"), function(i, li) {
					reports = reports + $(li).data('id') + "#";
				});

				reports = reports.substring(0, reports.length - 1);
				updateHostToReportAssociation(reports, $("#hostId").val());

				$(this).dialog("close");
			}
		}, {
			id : "button-cancel",
			text : "Skip",
			click : function() {
				$(this).dialog("close");
				$("#content").unmask();
			}
		} ],
		close : function() {
		}
	});
	$("#button-ok").button("disable");
	$("#moveRight").click(function() {
		$("#availableUserList .selectedUser").each(function() {
			$(this).removeClass("selectedUser");
			$(this).appendTo("#selectedUserList");
		});

		if ($("#selectedUserList li").length > 0) {
			$("#button-ok").button("enable");
		}
	});
	$("#moveLeft").click(function() {
		$("#selectedUserList .selectedUser").each(function() {
			$(this).removeClass("selectedUser");
			$(this).appendTo("#availableUserList");
		});

		if ($("#selectedUserList li").length == 0 && !reportsAlreadyAssocaited) {
			$("#button-ok").button("disable");
		}
	});

	$("#moveAllRight").click(function() {
		$("#availableUserList li").each(function() {
			$(this).removeClass("selectedUser");
			$(this).appendTo("#selectedUserList");
			$("#button-ok").button("enable");
		});
	});
	$("#moveAllLeft").click(function() {
		$("#selectedUserList li").each(function() {
			$(this).removeClass("selectedUser");
			$(this).appendTo("#availableUserList");
			if (!reportsAlreadyAssocaited) {
				$("#button-ok").button("disable");
			}
		});
	});

	$('.cacheInterval').keyup(function() {
		this.value = this.value.replace(/[^0-9\.]/g, '');
	});

	$('.timeOutInterval').keyup(function() {
		this.value = this.value.replace(/[^0-9\.]/g, '');
	});

});