var reportExportUtility = (function() {
	"use strict";
	var reportExportUtility = {};
	reportExportUtility.columns={};
	reportExportUtility.rowStyleExpression={};
	reportExportUtility.dataResp= {};
	reportExportUtility.allCellExpression = {};
	reportExportUtility.isAlarm = false;

	reportExportUtility.init = function(tableId, dataResp, columns, rowStyleExpression, allCellExpression, isAlarm){
		reportExportUtility.columns = columns ;
		reportExportUtility.rowStyleExpression = rowStyleExpression;
		reportExportUtility.dataResp  = dataResp;
		reportExportUtility.allCellExpression = allCellExpression;
		if (isAlarm) {
			reportExportUtility.isAlarm = true;
		}
		return createTableObject(tableId);
	}


	 function createTableObject(tableId) {
		//ask for this check if ($scope.dataSet.endpoint !== 'DATACUBE' || $scope.useCREApiForSolr)
		var data = [];
		var row = {};
		var records = reportExportUtility.dataResp.records;
		var columns = reportExportUtility.dataResp.columns;
		for (var i = 0; i < records.length; i++) {
			var resultRow = records[i];
			var resultDataSet = {};
			var rowIndex = i;
			for (var j = 0; j < columns.length; j++) {
				var col = columns[j];
				var id = getIdforTheColumn(col.name);
				resultDataSet[id] = resultRow[j] === 0 || resultRow[j] === false ? "" + resultRow[j] : resultRow[j];
				row[id] = resultRow[j]; // first prepare the row object so that row[columId] needs to be evaluated. This will have the raw data value
			}
			/* if (!$scope.avoidClientScripts) */// ask the use case of this check
			try{
				applyCellExpr(resultDataSet, row, rowIndex);
			}catch(e){
				console.error("Error rendering in Nashorn Engine. Skipping rendering");
				console.error(e);
			}
			data.push(resultDataSet);
		}
		return JSON.stringify(data);
	}
	 function getIdforTheColumn(id) {
		var columnId = id;
		var columns = reportExportUtility.columns;
		for (var i = 0; i < columns.length; i++) {
			if (columns[i].dataField == id) {
				columnId = columns[i].id;
				break;
			}
		}
		return columnId;
	};

	 function applyCellExpr(resultData, row, rowIndex) {
		var rowStyleExpression = reportExportUtility.rowStyleExpression;
		var dataTableObject;
		if (rowStyleExpression)
			resultData['rowStyle'] = evalExpression(rowStyleExpression,row, rowIndex);

		var isMetrics=false;
		if(reportExportUtility.columns[0] && typeof reportExportUtility.columns[0].metricsColumn != 'undefined' ){
			isMetrics=true;
		}
		if(isMetrics==true){
			dataTableObject = createMockDataTableObject(reportExportUtility.columns, resultData);
		}

		for (var j = 0; j < reportExportUtility.columns.length; j++) {
			var col = reportExportUtility.columns[j];
			var cellExpression = col.cellExpression || reportExportUtility.allCellExpression;
			var tagAttributes = col.cellAttributes;
			var cellData = resultData[col.id];
			var columnIndex = j;
			var renderedVal = null ;

			var containsMatch=/<[^>]*>/g;
			if(isMetrics==true){

				var renderingTypes=String(col.id).match(containsMatch);
				//().forEach(function(element){ //Loop through Each Rendering <TYPE>

				if(col.rendererType){
					try{
						renderedVal = getMetricsFormattedValue(resultData[col.id], col.rendererType, col, columnIndex, rowIndex, dataTableObject);
					}catch(e){
						console.error("getMetricsFormattedValue: Error rendering in Nashorn Engine. Skipping rendering");
						console.error(e);
					}

					if(renderedVal!=null){
						resultData[col.id] = renderedVal.toString() ;
					}
				}
				if(renderingTypes!=null){
					for(var i=0;i<renderingTypes.length;i++){
						var element = renderingTypes[i];
						element=element.replace('<','').replace('>','');
						if(element == col.rendererType){ // Not Do same rendering twice
							continue;
						}
						renderedVal = null ;
						try{
							renderedVal = getMetricsFormattedValue(resultData[col.id], element, col, columnIndex, rowIndex, dataTableObject);
						}catch(e){
							console.error("getMetricsFormattedValue: Error rendering in Nashorn Engine. Skipping rendering");
							console.error(e);
						}

						if(renderedVal!=null){
							resultData[col.id] = renderedVal.toString() ;
						}
					}
				}
			}
			if(col.components && col.components.length > 0){
				if(!tagAttributes){
					tagAttributes = {};
				}
				tagAttributes['cv-column-actions']="true";
			}
			if(!cellExpression && (col.type === "TimeStamp" || col.type === "DateTime")){
				cellExpression = "=rpt.formatDateByColType(cellData,col)";
			}
			if (cellExpression){
				try{
					var formattedValue = getFormattedValue(cellData,
						cellExpression,
						row,
						rowIndex,
						columnIndex,
						col);
					if (formattedValue != undefined && formattedValue != null) { // empty strings and other values as accepted.
						resultData[col.id+"_formatted"] = "" + formattedValue;  // making sure it is treated as a string.
					} else {
						resultData[col.id+"_formatted"] = formattedValue;
					}
				}catch(e){
					console.error("cellExpression: Error rendering in Nashorn Engine. Skipping rendering");
					console.error(e);
				}

			}
			if (tagAttributes && !reportExportUtility.isAlarm) {
				for ( var key in tagAttributes) {
					var objKey = col.id + "tagAttributes";
					if (!resultData[objKey])
						resultData[objKey] = {};
					if (tagAttributes[key]) {
						try{
							resultData[objKey][key] = evalExpression(tagAttributes[key],
									row,
									col,
									rowIndex,
									cellData,
									columnIndex);
						}catch(e){
							console.error("tagAttributes: Error rendering in Nashorn Engine. Skipping rendering");
							console.error(e);
						}
					}
				}
			}

			if (col.hasOwnProperty("splitByCharacter") && col.splitByCharacter != "") {
				if (cellData == null) {
					resultData[col.id] = resultData[col.id];
				} else {
					cellData = resultData[col.id].toString();
					if (cellData.indexOf(col.splitByCharacter) != -1) {
						resultData[col.id] = cellData.split(col.splitByCharacter)
								.join("<br/>");
					} else {
						resultData[col.id] = cellData;
					}
				}
			}
			//Making the content "String" as all the rendering is finished
			if(typeof resultData[col.id] != 'undefined' ){
				if(resultData[col.id]==null){
					resultData[col.id] ="";
				}
				else{
					resultData[col.id]=removeLinks(resultData[col.id].toString());
				}
			}
//			if(typeof resultData[col.id+"_formatted"] != 'undefined' && resultData[col.id+"_formatted"]!=null ){
//				resultData[col.id+"_formatted"]=removeLinks(resultData[col.id+"_formatted"].toString());
//			}
		}
	}

	function removeLinks(data){
		var regex=/<\s*\/?\s*(a)\b[^>]*?>/g;
		data = data.replace(regex,"");
		return data;
	}

	function evalExpression(expression, row, col, rowIndex, cellData,
			columnIndex) {

		/*
		 * For alarm data we'll skip rendering for custom formatter
		 */
		if (reportExportUtility.isAlarm) {
			if(typeof expression == 'string') {
				return cellData;
			}
		}

		var args = {
			expression : expression,
			row : row,
			col : col,
			rowIndex : rowIndex,
			cellData : cellData,
			columnIndex : columnIndex
		};
		return rpt.evalExpression(args);
	}

	 function getFormattedValue(value, formatter, row, rowIndex,
			columnIndex, col) {
		var returnVal = value;
		var label = value;
		var cellData = value;
		if (formatter === undefined || formatter === "") {
			return returnVal;
		} else if (typeof formatter === 'string') {
			return evalExpression(formatter,
					row,
					col,
					rowIndex,
					value,
					columnIndex);
		} else {
			//var renderer = $.extend(true, {}, formatter); // WHY WE ARE CREATING A COPY OF FORMATTER
			var renderer = extend({}, formatter);
			if (renderer.type === 'number') {
				if (renderer.fmt == 'string') {
					renderer.type = "numberToString";
				}
			} else if (renderer.type === 'size') {
				renderer.fmt = renderer.target;
			}
			if (renderer.type === 'link') {
				var args = {};
				args["cellData"] = value;
				args["row"] = row;
				args["rowIndex"] = rowIndex;
				args["colIndex"] = columnIndex;
				if (typeof renderer.linkString === "string") {
					args["expression"] = renderer.linkString;
					renderer.linkString = rpt.evalExpression(args); // running through rpt.evalExpression() to support the {{}}

					if (!row) {
						row = {};
						row['value'] = value;
					}
					row['cellData'] = value;
					return cvFormatters.getDisplayValue(value, renderer, undefined, row);
				}else {
					return rpt.getColumCompHtml(renderer.link, args);
				}
			}
			return cvFormatters.getDisplayValue(value, renderer);
		}
	}

	function extend(a, b){
	    for(var key in b)
	        if(b.hasOwnProperty(key))
	            a[key] = b[key];
	    return a;
	}
	return reportExportUtility;
})();

function initializeCustomReportsObject (customReportsObject){
	window.customReports = JSON.parse(customReportsObject);
}
function getRenderedData(tableId, dataResp, tableMetaData, isAlarm) {
	tableMetaData = JSON.parse(tableMetaData);
	return reportExportUtility.init(tableId, JSON.parse(dataResp), tableMetaData.columns, tableMetaData.rowStyleExpression, tableMetaData.allCellExpression, isAlarm);
	//JSON.parse(dataResp).totalRecordCount + "";
}
/*var console = console || {};
console.error = function(err_msg){
	print(err_msg);
};*/