(function() {
	'use strict';
	if (!String.prototype.format) {
		String.prototype.format = function() {
			var args = arguments[0];

			return this.replace(/\{(\d+)\}/g, function() {
				var val = args[arguments[1]];
				if (typeof val !== "undefined" && val != null) {
					return val;
				} else {
					return "";
				}
			});
		};
	}
}());

(function(global) {
	'use strict';
	global.rpt = (function() {
		var isLocaleCaseSensitive = true;
		var currentLocaleStrings = {};

		function escapeRegExp(string) {
			return string.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, '\\$&');
		}

		// Private Functions

		//this function will find all occurencess of {{/}} and evaluate the expression between {{ }} and replace them with the processed value. Keeping it private as it is
		//only called by evaluateExpression function in this file.
		function extractAndProcessExpressions(expression) {
			var start = expression.indexOf("{{");
			var end = expression.indexOf("}}");

			if (start == -1 || end == -1) {
				return expression; // means done evaluating and replacing all {{/}}
			}

			expression = expression.substring(0, start) + eval(expression.substring(start + "{{".length, end)) +
					expression.substring(end + "}}".length);

			return extractAndProcessExpressions(expression);
		}

		// Public Functions
		return {
			isLocaleCaseSensitive : isLocaleCaseSensitive,
			currentLocaleStrings : currentLocaleStrings,
			input : {},
			clearCache : function() {
				var domElement = angular.element('#reportArea');
				if (typeof domElement !== "undefined" && domElement != null) {
					var $scope = domElement.scope();
					if (typeof $scope !== "undefined" && $scope != null && typeof $scope.clearCache === "function") {
						$scope.clearCache();
					}
				}
			},

			reload : function(componentId, type) {
				if (typeof componentId === "string" && componentId != null) {
					var componentSearchId = "#" + componentId
					var domElement = angular.element(componentSearchId);
					if (typeof domElement !== "undefined" && domElement != null) {
						var $scope = domElement.scope();
						if (typeof $scope !== "undefined" && $scope != null) {
							if (type === undefined) {
								$scope.reloadComponent();
							} else if (type === 'input') {
								$scope.reloadInput($scope.input, $scope.index);
							}
						}
					}
				} else {
					var reportArea = angular.element('#reportViewerArea')
					if (typeof reportArea !== "undefined" && reportArea != null) {
						var $scope = reportArea.scope();
						if (typeof $scope !== "undefined" && $scope != null &&
								typeof $scope.reportComponents !== "undefined" && $scope.reportComponents != null) {
							$scope.reloadAllComponents(true);
						}
					}
				}
			},

			translate : function() {
				var localeKey = arguments[0];
				if (typeof localeKey !== "undefined" && localeKey != null) {
					if (!rpt.isLocaleCaseSensitive) {
						localeKey = localeKey.toUpperCase();
					}
					var localeValue = rpt.currentLocaleStrings[localeKey];
					if (typeof localeValue !== "undefined" && localeValue != null) {
						//Localization is available for the given key, check if parameters are passed.
						if (arguments.length > 1 && typeof arguments[0] === "string") {
							[].shift.apply(arguments);
							localeValue = localeValue.format(arguments);
						}
					} else {
						//Localization is NOT available for the given key , then return the string as is.
						if (localeKey !== "RPT_TITLE" && localeKey !== "RPT_DESCRIPTION") {
							localeValue = arguments[0];// + localeKey;
						} else {
							localeValue = "";
						}

					}
					return localeValue;
				} else {
					return "";
				}
			},
			evaluate : function(expr, argsObj) {
				var evalExpr = "";
				for ( var prop in argsObj) {
					evalExpr = evalExpr + "var " + prop + " =  " + JSON.stringify(argsObj[prop]) + ";";
				}
				evalExpr = evalExpr + expr + ";";
				return eval(evalExpr);
			},
			evalExpression : function() {
				var argsObj = arguments[0];
				var varExpression = "";
				var expression = argsObj['expression'];
				delete argsObj['expression'];
				var retunVal = expression;
				if (typeof expression === "string" && expression.substring(0, 1) === "=") {
					try {
						retunVal = rpt.evaluate(expression.substring(1), argsObj);
					} catch (exception) {
						retunVal = "";
						console.error(exception.message)
					}
				} else if (typeof expression === "string" && expression.substring(0, 2) === ":=") {
					try {
						var expr = "(function() {" + expression.substring(2) + " }) ();";
						retunVal = rpt.evaluate(expr, argsObj);
					} catch (exception) {
						retunVal = "";
						console.error(exception.message)
					}
				} else {
					//expression = expression.replace(/\s+/g," ").replace(/{ {/g,"}}").replace(/} }/g,"}}");
					var expressions = expression.match(/{{([^}]+)}}/g); // this will get array of strings to be evaluated and replaced.
					var evaluatedExpressions, expr, currentExpression;
					var copiedExpression = expression;
					if (expressions && expressions.length > 0) {
						evaluatedExpressions = {}; // map of the expressions and evaluated strings
						for (var i = 0; i < expressions.length; i++) {
							expr = expressions[i];
							if (expr) {
								currentExpression = expr.trim().substring(2, expr.length - 2); // each expression to evaluate extract the strings between {{ ===> }}
								if (currentExpression.indexOf("=") !== 0 && currentExpression.indexOf(":=") !== 0) {
									currentExpression = '=' + currentExpression;// if the expression does not begin with = , or := then wrap it with single line expression , so  that this expression can be evaluated
								}
								argsObj['expression'] = currentExpression;
								evaluatedExpressions[expr] = rpt.evalExpression(argsObj); // use the evalExpression recursively so that the final string can be evaluated.
							}
						}
						expression = copiedExpression; // expression at global is being rest to the current expression in the loop
						for ( var evaluatedExpression in evaluatedExpressions) {
							expression = expression.replace(new RegExp(escapeRegExp(evaluatedExpression), "g"),
									evaluatedExpressions[evaluatedExpression]); // for each of the key in map replace the final string with the evaluated value.
						}
						retunVal = expression;
					}
				}
				return retunVal;
			},

			checkExpressionToLocalize : function(expression) {
				if (expression && typeof expression === "string" && expression.substring(0, 1) !== "=" &&
						expression.substring(0, 2) !== ":=") {
					expression = expression.replace(/'/g, "\\'"); // escape single quotes in a string.
					expression = "=rpt.translate('" + expression + "')";
				}
				return expression;
			},

			resetSelectedRows : function(componentId) {
				if (typeof componentId === "string" && componentId != null) {
					var componentSearchId = "#" + componentId
					var domElement = angular.element(componentSearchId);
					if (typeof domElement !== "undefined" && domElement != null) {
						var $scope = domElement.scope();
						if (typeof $scope !== "undefined" && $scope != null) {
							$scope.resetSelectedRows();
							$scope.$apply();
						}
					}
				}
			},
			
			extend : function(obj1, obj2) {
				var obj3 = {};
				for ( var attrname in obj1) {
					obj3[attrname] = obj1[attrname];
				}
				for ( var attrname in obj2) {
					obj3[attrname] = obj2[attrname];
				}
				return obj3;
			},
			
			getActionHtml : function(comp, params) {
				var evalExpr = function(expr) {
					return rpt.evalExpression(rpt.extend({
						expression : expr
					}, params));
				}
				return rpt.getButtonExpression(comp.events.onClick, evalExpr);
			},

			getColumCompHtml : function(comp, params) {
				var avoidJsStyle = false;
				if (comp.events.onClick.action === 'Link' ||
						(comp.type === 'link' && comp.events.onClick.action === 'Report')) {
					comp.events.onClick.avoidJSStyle = avoidJsStyle = true;
				}

				var clickExpression = rpt.getActionHtml(comp, params);
				if (clickExpression) {
					clickExpression = clickExpression.replace(/"/g, '\'');
				}

				var evaluatedTiltle = rpt.evalExpression(rpt.extend({
					expression : this.checkExpressionToLocalize(comp.title.text)
				}, params));

				var isVisible = comp.visible === "custom" ? rpt.evalExpression(rpt.extend({
					expression : comp.visibleExpression
				}, params)) : true;
				if (!isVisible) {
					return "";
				}

				var isEnabled = comp.enable === "custom" ? rpt.evalExpression(rpt.extend({
					expression : comp.enableExpression
				}, params)) : true;

				var ttip = comp.toolTip || evaluatedTiltle;
				if (comp.type === 'link' || comp.type === 'MenuItem') {
					var start = '<a class="';
					if (!isEnabled) {
						start = start + "action-disabled ";
					}
					if (comp.events.onClick.action === "ShowPreview") {
						if (typeof Base64 != 'undefined') {
							return start + 'column-link previewLinkCol" title="' + ttip + '" data-formatter="' +
									Base64.encode(JSON.stringify(comp.events.onClick)) + '" data-row-index="' +
									params.rowIndex + '">' + evaluatedTiltle + '</a>';
						}
					}
					if (avoidJsStyle) {
						var tgt = "_self";
						if (comp.events.onClick.openInNewTab) {
							tgt = "_blank";
						}

						return start + 'column-link" target="' + tgt + '" href="' + clickExpression + '" title="' +
								ttip + '" data-colindex="' + params.columnIndex + '" data-celldata="' +
								params.cellData + '">' + evaluatedTiltle + '</a>'
					} else {
						return start + 'column-action-component" title="' + ttip + '" data-colindex="' +
								params.columnIndex + '" data-celldata="' + params.cellData + '"  data-action="' +
								clickExpression + '">' + evaluatedTiltle + '</a>'
					}

				} else if (comp.type === 'button') {
					var start = '<button';
					if (!isEnabled) {
						start = start + " disabled ";
					}
					if (comp.imageType && comp.imageType === "custom") {
						evaluatedTiltle = '<span class="col-custom-icon">' + comp.imageValue + '</span><span>' +
								evaluatedTiltle + '</span>';
					}

					if (comp.imageType && comp.imageType === "url") {
						evaluatedTiltle = '<span class="col-custom-icon"><img src="' + comp.imageValue +
								'"></span><span>' + evaluatedTiltle + '</span>';
					}

					return start + ' class="btn default-button column-action-component" title="' + ttip +
							'" data-colindex="' + params.columnIndex + '" data-celldata="' + params.cellData +
							'"  data-action="' + clickExpression + '">' + evaluatedTiltle + '</button>';
				} else if (comp.type === 'image') {
					if (comp.imageType === 'custom') {
						var start = '<div class="';
						if (!isEnabled) {
							start = start + "action-disabled ";
						}
						return start + 'customIcon column-action-component"  data-colindex="' + params.columnIndex +
								'" data-celldata="' + params.cellData + '"  data-action="' + clickExpression + '">' +
								comp.imageValue + '</div>';
					} else {
						var start = '<img class="';
						if (!isEnabled) {
							start = start + "action-disabled ";
						}
						return start + 'column-action-component" src="' + comp.imageValue + '" data-colindex="' +
								params.columnIndex + '" data-celldata="' + params.cellData + '"  data-action="' +
								clickExpression + '">';
					}
				} else if (comp.type === 'menu') {
					var menuHtml = '<button class="page-action-button menu" data-toggle="dropdown-selector"><span>...</span></button><ul class="dropdown-selector-menu hide">';
					for (var m = 0; m < comp.items.length; m++) {
						var retHtml = this.getColumCompHtml(comp.items[m], params);
						if (retHtml) {
							menuHtml = menuHtml + "<li class='dropdown-selector-menu-item column-action-component' >" +
									retHtml + "</li>";
						}
					}
					menuHtml = menuHtml + "</ul>";
					return menuHtml;
				}
			},

			getButtonExpression : function(clickConfig, evalExpression) {
				var generatedExpression;
				var getInputs = function(inputs) {
					var values = [];
					angular.forEach(inputs, function(input) {
						var val = input.value;
						if (val) {
							if (val.indexOf("=selectedRow[") === 0) {
								val = convertSelectedRowExpression(input.isMulti, val);
								if (input.isMulti) {
									val = evalExpression(val);
								} else {
									val = "'" + evalExpression(val) + "'";
								}
							} else {
								val = "'" + evalExpression(val) + "'"; // backward compatibility
							}
							values.push("'" + input.id + "':" + val);
						}
					})
					if (values.length > 0) {
						return values.join(',');
					} else {
						return;
					}
				}

				var convertSelectedRowExpression = function(isMulti, value) {
					if (value.indexOf("=selectedRow[") === 0) {
						var prop = value.substring(value.indexOf('[') + 1, value.length - 1);
						if (isMulti) {
							value = "=JSON.stringify(_.map(selectedRows," + prop + "))";
						} else {
							value = "=selectedRows[0][" + prop + "]";
						}
					}
					return value;
				}

				var getReportInputValue = function(isMulti, value) {
					value = convertSelectedRowExpression(isMulti, value);
					value = evalExpression(value);
					if (isMulti && value.toLowerCase() !== 'all') {
						if (!value.startsWith("[")) {
							value = '["' + value + '"]'; // convert row value into arrray format.
						}

						value = escape(value); // since we are writing to DOM we need to escape.
					}
					return value;
				}

				if (clickConfig.action === "Custom") {
					generatedExpression = clickConfig.customExpression;
				} else if (clickConfig.action === "Link") {
					if (clickConfig.avoidJSStyle) {
						generatedExpression = evalExpression(clickConfig.URL);
					} else {
						generatedExpression = "=document.location.href='" + evalExpression(clickConfig.URL) + "'";
					}
				} else if (clickConfig.action === "Workflow") {
					generatedExpression = "=openForm({'workflowName':'" + clickConfig.name + "'";
					var inputString = getInputs(clickConfig.inputs);
					if (inputString) {
						generatedExpression += ", inputs:{" + inputString + "}";
					}
					var autoSubmit = false;
					if (clickConfig.autoSubmit) {
						autoSubmit = clickConfig.autoSubmit;
					}

					var refresh = false;
					if (clickConfig.refreshOnSuccess) {
						refresh = clickConfig.refreshOnSuccess;
					}
					generatedExpression += ",_submit:" + autoSubmit + ",refreshOnSuccess:" + refresh;
					
					if (clickConfig.hideWorkflowSubmitMessage) {
						generatedExpression += ",showWarningMessage:" + !clickConfig.hideWorkflowSubmitMessage;
					}

					if (clickConfig.fullPage != undefined && clickConfig.fullPage === true) {
						generatedExpression += ", fullPage:true";
					}

					generatedExpression += ", targetElement:'#reportArea'";

					generatedExpression += "})";

				} else if (clickConfig.action === "Report") {

					var url = window.location.origin + customReports.contextPath;
					if (customReports.appName === 'adminconsole') {
						url = url + "/#/reportDetails?"
					} else {
						url = url + "/reportsplus/reportViewer.jsp?"
					}
					var urlParams = [];

					urlParams.push("reportId=" + encodeURIComponent(clickConfig.name));
					if (clickConfig.pageName) {
						urlParams.push("pageName=" + encodeURIComponent(clickConfig.pageName));
					}
					if (clickConfig.inputs.length !== 0) {
						for (var i = 0; i < clickConfig.inputs.length; i++) {
							if (clickConfig.inputs[i].value) {
								urlParams
										.push("input." +
												clickConfig.inputs[i].id +
												"=" +
												getReportInputValue(clickConfig.inputs[i].isMulti,
														clickConfig.inputs[i].value));
							}
						}
					}
					for (var i = 0; i < urlParams.length; i++) {
						url += urlParams[i] + "&";
					}
					url = url.substring(0, url.length - 1);
					if (clickConfig.avoidJSStyle) {
						generatedExpression = url;
					} else {
						if (clickConfig.openInNewTab) {
							generatedExpression = "=window.open(\'" + url + "\',\'_blank\')";
						} else {
							generatedExpression = "=document.location.href=\'" + url + "\'";
						}
					}

				} else if (clickConfig.action === "EditTableRecords") {
					generatedExpression = "=openTableForm({'tableId':'" + clickConfig.tableId + "', 'sysRowId':'"
					generatedExpression += evalExpression(clickConfig.rowId) + "'";

					if (clickConfig.fullPage != undefined && clickConfig.fullPage === true) {
						generatedExpression += ", fullPage:true";
					} else {
						if (clickConfig.pageMode != undefined) {
							if (clickConfig.pageMode === "POPUP"){generatedExpression += ", fullPage:false";}else if (clickConfig.pageMode === "FULL_PAGE"){generatedExpression += ", fullPage:true";}
						}
					}

					if (clickConfig.tableFormId != undefined && clickConfig.tableFormId != "") {
						generatedExpression += " ,formId:'" + clickConfig.tableFormId + "'";
					}

					generatedExpression += ", targetElement:'#reportArea'});";

				} else if (clickConfig.action === "AddTableRecord") {
					generatedExpression = "=openTableForm({'tableId':'" + clickConfig.tableId + "'"
					var inputString = getInputs(clickConfig.inputs);
					if (inputString) {
						generatedExpression += ", inputs:{" + inputString + "}";
					}

					if (clickConfig.fullPage != undefined && clickConfig.fullPage === true) {
						generatedExpression += ", fullPage:true";
					} else {
						if (clickConfig.pageMode != undefined) {
							if (clickConfig.pageMode === "POPUP"){generatedExpression += ", fullPage:false";}else if (clickConfig.pageMode === "FULL_PAGE"){generatedExpression += ", fullPage:true";}
						}
					}

					if (clickConfig.tableFormId != undefined && clickConfig.tableFormId != "") {
						generatedExpression += " ,formId:'" + clickConfig.tableFormId + "'";
					}

					generatedExpression += ", targetElement:'#reportArea'});";
				}
				return generatedExpression;
			},

			_getReportScope : function() {
				var reportArea = angular.element('#reportViewerArea');
				if (typeof reportArea !== "undefined" && reportArea != null) {
					var $scope = reportArea.scope();
					if (typeof $scope !== "undefined" && $scope != null) {
						return $scope;
					}
				}
				return null;
			},

			_getAdminconsoleReportScope : function() {
				var reportArea = angular.element('#report-include-area');
				if (typeof reportArea !== "undefined" && reportArea != null) {
					var $scope = reportArea.scope();
					if (typeof $scope !== "undefined" && $scope != null) {
						return $scope;
					}
				}
				return null;
			},

			toaster : {
				errorToast : function(msg, delay) {
					var $scope = rpt._getReportScope();
					if ($scope) {
						$scope.errorToast(msg, delay);
					}
				},

				toast : function(msg, delay) {
					var $scope = rpt._getReportScope();
					if ($scope) {
						$scope.toast(msg, delay);
					}
				}
			},
			addBreadcrumbs : function(crumbs) {
				if (crumbs && crumbs.length > 0) {
					var breadCrumbs = convertObj(crumbs);
					if (customReports.appName === 'adminconsole') {
						var $scope = rpt._getAdminconsoleReportScope();
						if ($scope && $scope.addBreadCrumbs) {
							$scope.addBreadCrumbs(breadCrumbs);
						}
					} else {
						if (typeof window.addBreadCrumbs == 'function') {
							window.addBreadCrumbs(breadCrumbs);
						}
					}
				}

				function convertObj(crumbs) {
					var finalData = [];
					crumbs.forEach(function(crumb) {
						var el = {
							title : crumb.title || '',
							link : convertParams(crumb.params)
						}
						finalData.push(el);
					});

					return finalData;

					function convertParams(params) {
						if (!params) {
							return '';
						}
						if (customReports.appName === 'adminconsole') {
							return '#reportDetails?' + params + '&app=ADMIN_CONSOLE';
						} else {
							return cvUtil.getContextPath() + '/reportsplus/reportViewer.jsp?' + params;
						}
					}
				}

			},
			getLocale : function() {
				return customReports.prefLocale;
			},
			formatDateAndTime : function(data, format) {
				var locale = rpt.getLocale();
				if (locale === "zh") {
					locale = "zh-cn";
				}
				return customReports.honorLocaleDate && locale !== "en" ? moment(data).locale(locale).format(format) : data;
			},
			formatDateTime : function(data) {
				return rpt.formatDateAndTime(data, 'll LTS');
			},
			formatDate : function(data) {
				return rpt.formatDateAndTime(data, 'll');
			},
			formatDateByColType : function(data, col) {
				if (!data) {
					return ""; // when the date is blank , it returns Invalid date.
				}
				return col.type === "Date" ? rpt.formatDate(data) : rpt.formatDateTime(data);
			},
			getParameterByNameSafeForUrl : function(key,defaultValue){
				var value = cvUtil.getParameter(key,defaultValue);
				return encodeURIComponent(value);
			}
		}
	}());
	// register as an AMD module
	if (typeof define === 'function' && define.amd) {
		define([], function() {
			return rpt;
		});
	} else {
		// set global
		if (!global.rpt) {
			global.rpt = rpt;
		}
	}

	if (!global.openTable) {
		global.openTable = function(component) {
			if (angular.element('.open-report-table').length >= 1) {
				angular.element('.open-report-table').scope().openTableComponent(component);
			}
		}
	}
}(window));