(function() {
	var app = angular.module("reports");
	app.service("crUtilSvc", [ '$timeout', function($timeout) {
		this.readCookie = function(name) {
			var nameEQ = name + "=";
			var ca = document.cookie.split(';');
			for (var i = 0; i < ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0) == ' ') {
					c = c.substring(1, c.length);
				}
				if (c.indexOf(nameEQ) == 0) {
					return c.substring(nameEQ.length, c.length);
				}
			}
			return null;
		};
	} ]);

	if (customReports.appName === 'webconsole') {
		app.factory('cvToaster', [ function() {
			var toaster = {};

			toaster.showErrorMessageWithDetails = function(ops) {
				cvUtil.errorWithDetailsToast(ops.intialText.trim(), ops.endText.trim(), ops.more, ops.less, true);
			};

			toaster.showInfoMessageWithDetails = function(ops) {
				cvUtil.infoToastWithDetails(ops.intialText.trim(), ops.endText.trim(), ops.more, ops.less, true);
			};

			toaster.showWarnMessage = function(ops) {
				cvUtil.toast(ops.message, ops.delay);
			};

			toaster.showErrorMessage = function(ops) {
				cvUtil.errorToast(ops.message, ops.delay);
			};

			toaster.showInfoMessage = function(ops) {
				cvUtil.toast(ops.message, ops.delay);
			};

			toaster.showSuccessMessage = function(ops) {
				cvUtil.toast(ops.message, ops.delay);
			};

			return toaster;
		} ]);
	}
}());