import { exportConstants } from './constants';
// Closure to isolate scope, as per best practices
(function() {

    "use strict";

    // Get a reference to the reportsBuilder module
    var app = angular.module("reports");
    var builderVersion = 2; // the variable represents the builder version and is used for only upgrading the schema from previous version to the latest schema or to make runtime decisions based on the schema difference.
    // Common controller for report builder and viewer
    var defaultParams= ["reportId","reportName","pageName", "app"];
    var Permissions = {
			EDIT_REPORT: 130,
			DELETE_REPORT: 131,
			EXECUTE_REPORT: 132,
			CHANGE_SECURITY: 107
	};

    app.controller("reportsCtrl", ["$scope", "customReportSvc", "reportService", "tileBuilderSvc","$uibModal","$interval", "$timeout","rptUrlService", '$rootScope', function($scope, customReportSvc, reportService, tileBuilderSvc, $uibModal,$interval, $timeout, rptUrlService, $rootScope) {
        if(typeof cv !== "undefined") {
            $scope.cv = cv;
        }
        /* begin gridster configuration */
        $scope.gridsterOpts = {};
        $scope.gridsterOpts.draggable = { enabled: true};
        // $scope.gridsterOpts.rowHeight = 'match';
        $scope.gridsterOpts.rowHeight = 50;
        $scope.gridsterOpts.colWidth = 'auto';
        $scope.defaultTileHeight = 400;
        $scope.defaultNumberOfRows = Math.ceil($scope.defaultTileHeight / $scope.gridsterOpts.rowHeight);
        $scope.deviceType = "desktop";
        $scope.isLayoutAvailable = true;
        $scope.gridsterOpts.columns = 12;
        $scope.gridsterOpts.pushing = false;
        $scope.gridsterOpts.floating = true;
        $scope.gridsterOpts.swapping = false;
        $scope.gridsterOpts.allowOverlapping = false;
        $scope.gridsterOpts.sparse = true;
        $scope.gridsterOpts.maxRows = 999999;
        $scope.gridsterOpts.saveGridItemCalculatedHeightInMobile = true;
        $scope.gridsterOpts.mobileModeEnabled = false;
        $scope.globalCacheKey;
        $scope.historyUpdated = false;
        /* end gridster configuration */

        $scope.appName = customReports.appName;
        $scope.subAppName = customReports.subAppName;
        $scope.reportId = 0;
		customReports.honorLocaleDate = _.get(cv, 'additionalSettings.Console.honorLocaleDateInReport', false);
        $scope.resetCache = function(cacheKey,refreshCache){
             var cacheObj = localStorage.getItem(cacheKey);
             if(cacheObj){
                 cacheObj = JSON.parse(cacheObj);
                 if(refreshCache){
                     reportService.clearCache(cacheObj.cacheId);  //need to clear the cache for the previous cache if it exists
                     localStorage.removeItem(cacheKey); // remove the cache Obj stored locally
                     cacheObj = undefined;
                 }else{
                     cacheObj.lastAccessed = Date.now();
                     localStorage.setItem(cacheKey,JSON.stringify(cacheObj));
                 }
             }

             if(!cacheObj){
                 cacheObj = {cacheId:customReportSvc.generateUUID(),lastAccessed:Date.now()};
                 localStorage.setItem(cacheKey,JSON.stringify(cacheObj));
             }
             return cacheObj.cacheId;
        }

        $scope.getCacheKey = function(reportId,reportName){
            var cacheKey = "ReportsCache"+SESSION_ID+reportId+"reportName"+reportName;
            if($scope.globalCacheKey){
                cacheKey = $scope.globalCacheKey;
            }
            return cacheKey;
        }

        $scope.getCacheId = function(refreshCache){
            refreshCache = $scope.globalCacheKey ? false : refreshCache;
            var cacheKey =  $scope.getCacheKey($scope.reportId,$scope.reportName);
            return $scope.resetCache(cacheKey,refreshCache);
        }



        $scope.clearAndResetCacheId = function() {
            $scope.cacheId = $scope.getCacheId(true);
        }

        $scope.clearReportCache = function(reportId) {
             var cacheKey = "ReportsCache"+SESSION_ID+reportId+"reportName"+$scope.reportName;
             return $scope.resetCache(cacheKey,true);
        }

        $scope.errorToast = function(msg, delay) {
        	customReportSvc.errorToast(msg, delay);
		},

		$scope.toast = function(msg, delay) {
			customReportSvc.toast(msg, delay);
		}


          /*
             * angular.element(window).on('keydown',function(e){ //save info somewhere e = e ||
             * window.event; if (e.keyCode == 116) { $scope.clearAndResetCacheId(); } });
             */



        // every 10 min's check for and update clear the localStorage
        $interval(function() {
            for (var key in localStorage) {
                   if(key.indexOf("ReportsCache") === 0){
                       var cacheObj = JSON.parse(localStorage.getItem(key));
                       var diffInMs = Date.now() - parseInt(cacheObj.lastAccessed);
                       if(diffInMs > 600000){
                           localStorage.removeItem(key);
                       }
                   }
            }
        }, 600000);

        $scope.updateReportState = function(stateChanged){
        	if ($scope.pageName && $scope.customReport.pages && $scope.customReport.pages.length > 1) {
        		$scope.pageName = $scope.mergedParams["pageName"] || null;
        		if (stateChanged){
        			$scope.setActivePageByName($scope.pageName,undefined,true);
                	$scope.$apply();
        		} else {
        			$scope.setDefaultPageAsActive(true);
        			$scope.$apply();
        		}
            }else if($scope.page && $scope.page.inputs && $scope.page.inputs.length > 0){
            	customReportSvc.triggerCallback("redrawAllInputs", $scope.page);
            }else{
                customReportSvc.triggerCallback("redrawAllComponents");
            }

        }

        if (customReports.appName === 'adminconsole'){
	        $scope.$on('$locationChangeSuccess', function(event) {
	        	if($scope.historyUpdated){
	        		$scope.historyUpdated = false;
	        	}else{
                    var params =  rptUrlService.readUrlParams();
	        		if(!$.isEmptyObject(params)){
                         if(!$.isEmptyObject($scope.queryStringParms))
                            $.extend(params, $scope.queryStringParms);
	        			$scope.requestParms = params;
		                $scope.mergedParams = $scope.requestParms;
		                $scope.updateReportState(true);
	        		}
	        	}
	        });
        }else{
	        window.addEventListener("popstate", function(event) {
	            if (event.state){
	                $scope.requestParms = event.state;
	                $scope.mergedParams = $scope.requestParms;
	                $scope.updateReportState(true);
	            }

	        });
        }

        $scope.isCurPageForms = function(){
            return window.location.pathname === cvUtil.getContextPath() + "/forms/";
        }

        $scope.init = function(reportId, reportName, isBuilder, opts,queryString, filterAcrossReports = false) {
            customReportSvc.restCallbacks(); // resetting any previous call backs stored in the service.
            $scope.isPreview = customReportSvc.getParameterByName("isPreview", false);
            $scope.reportMode = isBuilder === true ? "builder" : "viewer";
            $scope.isDashboard = customReportSvc.getParameterByName("isDashboard");
            $scope.isBuilder = isBuilder;
            $scope.isTileBuilder = customReportSvc.getParameterByName("tile", false) == 'true' ? true : false;
            $scope.reportId = reportId || customReportSvc.getParameterByName('reportId', 0);
            $scope.reportName = reportName || customReportSvc.getParameterByName('reportName', "");
            $scope.avoidClientScripts = customReportSvc.getParameterByName('avoidClientScripts', false);
            $scope.exportType = customReportSvc.getParameterByName("exportType", undefined);
            $scope.isReadme = customReportSvc.getParameterByName("readme", false);
            $scope.maskEle = $scope.isBuilder ? "container" : "content";
			$scope.updatePageTitle = true;
            var isDashboard = customReportSvc.getParameterByName("isDashboard");
            $scope.dashboardMode = customReports.isDashboard;
            $scope.globalCacheKey = opts && opts.cacheKey || undefined;
            $scope.filterAcrossReports = filterAcrossReports;

            if(isDashboard){
            	$scope.globalCacheKey = customReportSvc.getParameterByName("cacheKey");
            }

            if (opts) {
                if (opts.subAppName) {
                    customReports.subAppName = opts.subAppName;
                }
                if (opts.maskEle) {
                    $scope.maskEle = opts.maskEle;
                }
                if (opts.noTitleUpdate && opts.noTitleUpdate !== "false") {
                    $scope.updatePageTitle =false;
                }

                if (opts.healtTileViewer){
                    $scope.healtTileViewer = opts.healtTileViewer;
                }
            }


            if (($scope.exportType === 'PRINT' || $scope.exportType.toLowerCase() === 'html' || $scope.exportType.toLowerCase() === 'pdf') && $scope.isReadme !== "true") {
                $('body').css("width","1200px");
                 $('body').css("margin","0 auto");
            }
            //if ($scope.reportMode === 'builder') {
                $scope.$on('gridster-loaded', function(gridster) {
                    $scope.gridsterOpts.draggable.handle = '.reportstabletitle';
                    if ($scope.reportMode === 'builder') {
                    	$scope.gridsterOpts.draggable.enabled = true;
                    } else if (!customReports.isDashboard) {
                    	$scope.gridsterOpts.draggable.enabled = false;
                    }

                });
            //}

            $scope.includeDrafts = isBuilder || customReportSvc.getParameterByName("includeDrafts") || false;

            $scope.requestParms = customReportSvc.getUrlParams();
             // Switching reports clears the URL. In case we need to filter across reports, save the current request params.
             if ($scope.filterAcrossReports) {
                 $scope.requestParamsOrig = $scope.requestParms;
            }

			//App studio params must not be part of request params.
			if(window.location.hash.indexOf("#/my-app")!=-1)
			{
				delete $scope.requestParms["rowId"];
				delete $scope.requestParms["formId"];
				delete $scope.requestParms["tableId"];
			}

            if ($scope.requestParms['reset'] == 'true') {
            	$scope.clearAndResetCacheId();
            	delete $scope.requestParms['reset'];
            }
            if(queryString){
                 $scope.queryStringParms = customReportSvc.getUrlParams(queryString);
                 $scope.requestParms = $.extend({}, $scope.requestParms, $scope.queryStringParms);
            }
            $scope.mergedParams = $scope.requestParms;
            $scope.viewParams = {};
            var version = customReportSvc.getParameterByName("version", 0);
            $scope.cacheId = $scope.getCacheId();
            customReportSvc.setEnableEditModeActions(false);
            var params = { reportId: $scope.reportId, includeDrafts: $scope.includeDrafts, reportName: $scope.reportName, version: version, isPreview: $scope.isPreview, isTileReport:$scope.isTileBuilder  };
            $scope.params = params;
            $scope.customReport;
            $scope.page;
            $scope.pageName = customReportSvc.getParameterByName("pageName") || null;
            $scope.selectedPage = { pageName: null };
            $scope.leftCollapsed = false;
            $scope.rightCollapsed = false;
            $scope.isFullScreen = false;
            if ($scope.reportMode === 'viewer') {
                $scope.gridsterOpts.pushing = true;
                $scope.gridsterOpts.allowOverlapping = false;
                $scope.gridsterOpts.mobileBreakPoint = 1080;
                $scope.gridsterOpts.mobileModeEnabled = true;
            }

            $scope.componentsCategories = {
                "CHART" : "chart",
                "PIVOT_TABLE" : "table",
                "TABLE" : "table",
                "HTML" : "other",
                "CUSTOM" : "other",
                "TAG_CLOUD" : "other",
                "HEAT_MAP" : "other",
                "SCATTER" : "chart",
                "SEARCH_BAR" : "form",
                "DATE_RANGE" : "form",
                "HITS" : "form",
            };
            $scope.minReleaseIDs = [{ value: 16, label: "11" },
                                { value: 17, label: "12" }];

            $scope.maxReleaseIDs = [{ value: 100, label: "" },
                                    { value: 16, label: "11" },
                                    { value: 17, label: "12" }];

            $scope.minSPValues=[];
            for(var valueSP=0;valueSP<100;valueSP++){
                if(valueSP==0){
                    $scope.minSPValues.push({ value: valueSP, label: "" });
                }
                else{
                    $scope.minSPValues.push({ value: valueSP, label: valueSP.toString() });
                }
            }

            $scope.maxSPValues = [{ value: 99, label: "" },
                                 { value: 1, label: "1" },
                                 { value: 2, label: "2" },
                                 { value: 3, label: "3" },
                                 { value: 4, label: "4" },
                                 { value: 5, label: "5" },
                                 { value: 6, label: "6" },
                                 { value: 7, label: "7" },
                                 { value: 8, label: "8" },
                                 { value: 9, label: "9" },
                                 { value: 10, label: "10" },
                                 { value: 11, label: "11" },
                                 { value: 12, label: "12" },
                                 { value: 13, label: "13" },
                                 { value: 14, label: "14" },
                                 { value: 15, label: "15" },
                                 { value: 16, label: "16" },
                                 { value: 17, label: "17" },
                                 { value: 18, label: "18" },
                                 { value: 19, label: "19" },
                                 { value: 20, label: "20" } ];
            var endpoint = customReportSvc.getParameterByName('endpoint', '');
            if(!customReports.subAppName || (customReports.subAppName && customReports.subAppName !== 'forms')){
                customReportSvc.mask($scope.maskEle,true,"Loading report ...");
            }
            reportService.getCustomReport(params).then(function(cr) {

                if(!(!customReports.subAppName || (customReports.subAppName && customReports.subAppName !== 'forms'))) {
                    $(".wfActionsLoader").remove(); //only workflows page has this loader.So nothing else would be affected.
                }


                if (!$scope.isPreview){
                    cr = cr.data;
                }
                $scope.loadCustomReport(cr, endpoint);
            }, function(error) {
                customReportSvc.unMask($scope.maskEle,true);
                if (error != undefined && error != null && error.data) {
                    if (error.data.indexOf("PERMISSION_DENIED") != -1) {
                        customReportSvc.errorToast("You do not have permission to access this report.");
                        return;
                    }
                }

                if (!isDashboard) {
                    customReportSvc.errorToast($.trim("Report does not exist or you do not have permissions to view it."), 30000);
                } else {
                    angular.element('#dashboardError').append("Report does not exist or you do not have permissions to view it");
                }
            });

            if (!customReports.isDashboard && !$scope.isBuilder) {
                $scope.gridsterOpts.draggable = {};
                $scope.gridsterOpts.resizable = {};
                $scope.gridsterOpts.draggable.enabled = false;
                $scope.gridsterOpts.resizable.enabled = false;
            }

            // Adding scope for newcomponent
            $scope.newcomponent = { row: 0, col: 0, size: { x: 2, y: $scope.defaultNumberOfRows } };

            if (window.performance && performance.navigation.type === 1) {
                $scope.clearAndResetCacheId();
            }else if (!window.performance){
                $scope.clearAndResetCacheId();
            }
            //check the urlParams and getAlarmDetails.
            if(!$scope.requestParms){
                $scope.requestParms = customReportSvc.getUrlParams();
            }

            if($scope.requestParms.alarmId && $scope.requestParms.alarmId > 0){
                var param = {};
                param.alarmId = $scope.requestParms.alarmId;
                var alarmDetails ;
                reportService.getAlarmDetails(param).then(function (data) {
                        if (data && data.length) {
                            alarmDetails = data[0];
                            if(alarmDetails.error){
                                var errorMessage = "Unable to find alert details for alarmId ["+alarmDetails.alarmId+"], Error Message :" + alarmDetails.error;
                                console.error(errorMessage);
                                $scope.alarmDetails = {};
                                $scope.alarmDetails.error = errorMessage;
                                customReportSvc.errorToast(alarmDetails.error);
                            }else{
                                var alarmURL = decodeURIComponent(alarmDetails.alarmURL);
                                var alarmDataSetName = customReportSvc.getParameter("alarmDataSetName", alarmURL);
                                var componentName = customReportSvc.getParameter("componentName", alarmURL);
                                alarmDataSetName = parseInt(alarmDataSetName,0);
                                alarmDetails.alarmDataSetName = alarmDataSetName;
                                alarmDetails.componentName = componentName;
                                alarmDetails.editCriteriaSet = true;
                                $scope.alarmDetails = alarmDetails;
                            }
                        }

                    },function(e){
                        var errorMessage = "Unable to find alert details for alarmId ["+param.alarmId+"], Error Message :" + e;
                        console.error(errorMessage);
                        $scope.alarmDetails = {};
                        $scope.alarmDetails.error = errorMessage;
                        customReportSvc.errorToast(e);
                    });
            }
        }


        $scope.isDateType = function(dataSet, fieldName) {
            var dateTypes = [ 'TimeStamp', 'Date' ], isDateRange = false;
            angular.forEach(dataSet.fields, function(field, index) {
                if (field.fieldName === fieldName && dateTypes.indexOf(field.type) !== -1) {
                    isDateRange = true;
                    return;
                }
            });
            return isDateRange;
        }

        $scope.isCustomGroupApplied = function(component, fieldName, dataSetName) {
            if(component.type === 'FACET') {
                const filterMode = component.filterMode || "viewer";
                if(component.filterDataField && component.filterDataField[filterMode] &&
                    component.filterDataField[filterMode][dataSetName] &&
                    !$.isEmptyObject(component.filterDataField[filterMode][dataSetName].fields))
                {

                    var fieldsArr = component.filterDataField[filterMode][dataSetName].fields
                    for(var i = 0; i< fieldsArr.length; i++)
                    {
                        if(fieldsArr[i].column === fieldName)
                        {
                            return fieldsArr[i].customGroupsAvailable;
                        }
                    }
                }
            } else {
                return (component.dimensionDataField && component.dimensionDataField.length > 0
                && component.dimensionDataField[0].column === fieldName && !$.isEmptyObject(component.dimensionDataField[0].groups));
            }
        }

        $scope.getVisibleStringColumns = function(component) {
            let visibleColumns =[];
            const solrStringTypes = ['string', 'filePath','lowercase', 'cvlowercase', 'string_ci', 'text_general', 'text_general_rev', 'text_rev'];
            angular.forEach(component.columns,function(col) {
                if(!col.hidden && (col.visible !== false) &&  solrStringTypes.indexOf(col.origType) !== -1) {
                    visibleColumns.push({
                        column : col.dataField,
                        type : col.origType
                    });
                }
            });
            return visibleColumns;
        }

        $scope.addBookmarkFilter = function(reportComponents, filterParam, filterVal, componentId, dataSets, selectionType,isSelectFilter) {
            var reportComponent = {};
            var customGroup=undefined;
            let filterDataField;
            angular.forEach(reportComponents, function(component) {
                if (component.id == componentId) {
                    reportComponent = component;
                    if (component.type === 'CHART') {
                        customGroup = customReportSvc.getSelectedCustomGroupObject(component.dimensionDataField[0], filterVal, $scope.customInputs);
                    } else if(component.type === 'FACET') {
                         angular.forEach(reportComponent.filterDataField.viewer, function (obj, dsName) {
                            for(var j = 0; j < obj.fields.length ; j ++ ) {
                                var field = obj.fields[j];
                                if(field.showEmptyValues && filterVal === field.emptyValueLabel) {
                                    filterVal = qb.rv.getQueryForEmptyVal();
                                }
                                const selectedGroup = customReportSvc.getSelectedCustomGroupObject(field, filterVal, $scope.customInputs);
                                if(selectedGroup) {
                                    customGroup = selectedGroup;
                                }
                            }
                        });
                    }
                    return;
                }
            });
            if (!$.isEmptyObject(reportComponent)) {
                var dataSetName = undefined;
                if (reportComponent.type === 'FACET' && !$.isEmptyObject(reportComponent.filterDataField)) {
                    angular.forEach(reportComponent.filterDataField.viewer, function (obj, dsName) {
                        angular.forEach(obj.fields, function(field, index) {
                            if (field.column === filterParam) {
                                dataSetName = dsName;
                                filterDataField = field;
                                return;
                            }
                        });
                        if (!dataSetName) {
                            return;
                        }
                    });
                } else {
                    dataSetName = reportComponent.dataSet.dataSetName;
                }
                var dataSet = undefined;
                angular.forEach(dataSets, function(dataSet1, index) {
                    if (dataSet1.dataSet.dataSetName == dataSetName) {
                        dataSet = dataSet1;
                        return;
                    }
                });

                let isStringType;
                if(reportComponent.type === 'TABLE') {
                    let filterType,param
                    if(filterParam !== "*" && isSelectFilter) {
                        let filterField = customReportSvc.getDataSetField(dataSet,filterParam);
                        isStringType = filterField.type === "String";
                    }

                    filterType = isSelectFilter ? ".select." : ".filter.",
                    param = reportComponent.id + filterType + filterParam;
                    if(isStringType) {
                        if($.isEmptyObject($scope.requestParms[param]))
                            $scope.requestParms[param] = [filterVal];
                        else
                            $scope.requestParms[param].push(filterVal);
                    } else {
                         $scope.requestParms[param] = filterVal;
                    }
                } else if(reportComponent.type === 'DATE_RANGE' || ((reportComponent.type === 'FACET' || reportComponent.chartType === 'TimeSeries') &&
                    $scope.isDateType(dataSet, filterParam)  && !$scope.isCustomGroupApplied(reportComponent, filterParam, dataSetName))) {
                    $scope.requestParms[reportComponent.id + ".filter." + filterParam] = filterVal;
                }
                else
                {
                    if(filterDataField && filterDataField.showRadioButtons) {
                        //for radio button filter field it will be always single value
                        $scope.requestParms[reportComponent.id + ".filter." + selectionType + "." + filterParam]= [filterVal];
                    } else {
                        if ($.isEmptyObject($scope.requestParms[reportComponent.id + ".filter." + selectionType + "." + filterParam])) {
                            $scope.requestParms[reportComponent.id + ".filter." + selectionType + "." + filterParam] = [];
                        }
                        $scope.requestParms[reportComponent.id + ".filter." + selectionType + "." + filterParam].push(filterVal);
                    }

                }

                if (filterVal != "") {

                    var currentFilter;
                    var currentFilterParam = "";
                    if ($.isEmptyObject(currentFilter = $scope.page.body.filters["viewer"][dataSetName])) {
                        currentFilter = $scope.page.body.filters["viewer"][dataSetName]= {};

                    }
                    if(filterParam === "*") {
                        currentFilterParam = currentFilter["globalSearch"] = { "columns" : [] };
                    } else if ($.isEmptyObject(currentFilterParam = currentFilter[filterParam])) {
                        currentFilterParam = currentFilter[filterParam] = { "include": [], "exclude": []};
                    }
                    if (reportComponent.type === 'TABLE') {
                        //For global serach
                        if(filterParam === "*") {
                            currentFilterParam.filterValue = filterVal;
                            currentFilterParam.columns = $scope.getVisibleStringColumns(reportComponent);
                        } else {
                            if ($.isEmptyObject(currentFilterParam['tableFilters'])) {
                                currentFilterParam['tableFilters'] = {
                                    advancedFilters : [],
                                    include : []
                                }
                            }
                            //The new table select filters we are always pushing to url with compId.select.columnId key.
                            // And we are storing filters in either currentFilterParam.tableFilters.include or currentFilterParam.tableFilters.daternage
                            //only the table filters with type filter(old way of table filters) are getting stored under currentFilterParam.tableFilters.advancedFilters.
                            if(!isSelectFilter) {
                                let advancedFilters = customReportSvc.getDefaultAdvancedFilter(filterParam, filterVal);
                                 currentFilterParam.tableFilters['advancedFilters'] = [advancedFilters];
                            } else if($scope.isDateType(dataSet, filterParam)) {
                                try {
                                    currentFilterParam.tableFilters['daterange'] = JSON.parse(filterVal);
                                } catch (e) {
                                    currentFilterParam.tableFilters['daterange'] = filterVal;
                                }
                            } else {
                                if(isStringType) {
                                    if($.isEmptyObject(currentFilterParam.tableFilters.include))
                                        currentFilterParam.tableFilters['include'] = [];
                                    if($.inArray(filterVal,currentFilterParam.tableFilters.include) === -1)
                                        currentFilterParam.tableFilters.include.push(filterVal);
                                } else
                                    currentFilterParam.tableFilters['include'] = filterVal;

                            }
                        }


                    } else if (reportComponent.type === 'DATE_RANGE' || ((reportComponent.type === 'FACET' || reportComponent.chartType === 'TimeSeries') && $scope.isDateType(dataSet, filterParam) && $.isEmptyObject(customGroup))) {
                        try {
                            var value = JSON.parse(filterVal);
                            filterVal = value;
                            if (reportComponent.type !== 'FACET' && reportComponent.chartType !== 'TimeSeries') {
                                reportComponent.rangeType = 'absolute';
                                reportComponent.dateRange.absolute = filterVal;
                                reportComponent.dateRange.relative = "";
                            }
                        } catch (e) {
                            if (reportComponent.type !== 'FACET' && reportComponent.chartType !== 'TimeSeries') {
                                reportComponent.rangeType = 'relative';
                                reportComponent.dateRange.relative = filterVal;
                                reportComponent.dateRange.absolute = {"from" : "", "to" : ""};
                            }
                        }
                        currentFilterParam['daterange'] = filterVal;
                    } else if(reportComponent.type === 'FACET' && filterDataField && filterDataField.showRadioButtons) {
                        //for facet field with radio button replace the old value with new one
                        currentFilterParam[selectionType] = [filterVal];
                    } else if (currentFilterParam[selectionType].findIndex(currFilter => (currFilter.groupName || currFilter) === filterVal) === -1) {
                        if (!$.isEmptyObject(customGroup)) {    // TODO: check if additional checks needed
                            filterVal = customGroup;
                        }
                        currentFilterParam[selectionType].push(filterVal);
                    }
                }
            }
        };
        $scope.loadCustomReport = function(cr, endpoint) {
            $scope.customReport = customReportSvc.deserializePagesAndSetCrObject(cr);
            $scope.loadTranslations($scope.customReport.translations, false);
            customReport.reportId = $scope.customReport.report.customReportId;
            customReport.reportName = $scope.customReport.report.customReportName;
            rpt.reportName = $scope.customReport.report.customReportName;
            rpt.reportId = $scope.customReport.userReportId;

            if ($scope.isTileBuilder) {
                $scope.tileProperties={};
                $scope.tileProperties.detailType="1";
                $scope.tileDSProps = {};
                if (!customReport.reportId) {
                    $scope.tileProperties.height = "FULL";
                    tileBuilderSvc.initTile($scope.customReport);
                 } else {
                    if ($scope.customReport.tileProperties) {
                        $scope.tileProperties = JSON.parse($scope.customReport.tileProperties);
                        if ($scope.tileProperties.statusDataSet) {
                            angular.forEach($scope.customReport.pages[0].dataSets.dataSet, function(dataset) {
                                if (dataset.guid === $scope.tileProperties.statusDataSet) {
                                    $scope.tileDSProps.tileStatusDataSet = dataset;
                                }
                            })
                        }
                    }
                 }
            }


            $scope.initCommonActions();
        }


        $scope.translate = function(expression){
            var retunVal = expression;
            if(typeof expression === "string" && expression.substring(0, 1) === "=") {
                try {
                    retunVal = eval(expression.substring(1));
                } catch (exception) {
                    console.error(exception.message)
                }
            } else if(typeof expression === "string" && expression.substring(0, 2) === ":=") {
                try {
                    var expr = "(function() {" + expression.substring(2) + " }) ();";
                    retunVal = eval(expr);
                } catch (exception) {
                    console.error(exception.message)
                }
            }
            return retunVal;
        }

        $scope.clearCache = function() {
            $scope.clearAndResetCacheId();
        };

        $scope.closeProperties = function() {
            $("#rightCol").css("display", "none");
            $("#rightCol>.colHeader>.compButtons").css("display","none");
        };
        $scope.toggleLeftPanel = function(panel, isFullScreen, event) {
            if (panel) {
                $scope.displayProperties.selectedPanel=panel;
            }
            if (typeof isFullScreen === 'undefined'){$scope.leftCollapsed = !$scope.leftCollapsed;}
            // TODO: minimize jquery usage
            if (!isFullScreen&&!panel&&$scope.leftCollapsed) {
                // $(".panel-two").toggle('slide',{'direction': 'left'}, 200);
                 $scope.leftPanelWidth = $("#leftCol").width();
                $(".panel-two").hide();
                $("#centerCol").css("left", "45px");
                $("#reportContentWrapper").css("left", "44px");
                $("#leftCol").css("width","0px");
            }
            else if (isFullScreen || !$scope.leftCollapsed){
                $("#leftCol").css("width",$scope.leftPanelWidth);
                var leftMargin = $(".panel-one").width() + $(".panel-two").width();
                $("#centerCol").css("left", leftMargin-14);
                $("#reportContentWrapper").css("left", leftMargin-14);
                $(".panel-two").show();
            }
            if (event) {
                event.stopImmediatePropagation();
                event.preventDefault();
            }
            $scope.$broadcast("gridsterItemWidthChanged",true);
        };
        $scope.toggleRightPanel = function(panel, isFullScreen, event) {
            if (panel) {
                $scope.displayProperties.selectedRightPanel=panel;
            }
            if (typeof isFullScreen === 'undefined'){$scope.rightCollapsed = !$scope.rightCollapsed;}
            if (!isFullScreen&&!panel&&$scope.rightCollapsed) {
                // $(".panel-two").toggle('slide',{'direction': 'left'}, 200);
                // TODO: minimize jquery usage
                $("#rightCol").hide();
                $(".right-panel-toggle").show();
                $(".right-panel-toggle").css("width", "53px");
                $("#centerCol").css("right", "54px");
                $("#reportContentWrapper").css("right", "39px");
                // $(".right-panel-toggle").css("left",$(".right-panel").width()-46);
            }
            else if (isFullScreen || !$scope.rightCollapsed){
                $("#rightCol").css("right",0);
                $(".right-panel-toggle").hide();
                $("#rightCol").show();
                $("#centerCol").css("right", $("#rightCol").width());
                $("#reportContentWrapper").css("right", $("#rightCol").width());
                // $(".panel-two").toggle('slide',{'direction': 'right'}, 200);
            }
            if (event) {
                event.stopImmediatePropagation();
                event.preventDefault();
            }
            $scope.$broadcast("gridsterItemWidthChanged",true);
        };


        $scope.initCommonActions = function() {
            $scope.isDcubeEnabledInCustomReports = isDcubeEnabledInCustomReports;
            if ($scope.reportId != 0 || $scope.reportName != "" || $scope.isPreview){
                customReportSvc.setEnableEditModeActions(true);
            }

            angular.element("#editLink").on("click", function(evt) {
                window.location.assign(customReportSvc.getContextPath() + "/reportsplus/index.jsp" + window.location.search);
            });

            angular.element("#sectionTitle input").on("keypress keyup keydown", function(evt) {
                // $scope.customReport.report.customReportName = $(this).val();
                $(this).removeClass('border-red');
            });

            angular.element('#refreshButton').on("click", function() {
                $scope.clearAndResetCacheId();
                customReportSvc.triggerCallback("redrawAllInputs", $scope.page);
                customReportSvc.triggerCallback("redrawAllComponents");
            });

            if ($scope.reportMode === 'builder') {
                $scope.initBuilderActions();
            } else {
                $scope.initViewerActions();
            }

            $scope.updateReportName = function(reportName) {
                if (!reportName) {
                   reportName ="";
                }

                if($scope.reportMode !== 'builder'){
                    angular.element("#sectionTitle").text(reportName);
                }
                //this will remove the any htlm content form the title of the page and hover over text of the report name.
                var removeHtmlRegex = /((<style>)[^]*(<\/style>))+|((<script>)[^]*(<\/script>))+|<\/?[^>]+>/ig;
                var title = reportName.replace(removeHtmlRegex, '');
                angular.element("#sectionTitle").prop('title', title);
                if($scope.updatePageTitle && (!customReports.subAppName || (customReports.subAppName && customReports.subAppName !== 'store'))){
                    angular.element("title").html(title);
                    if(!$scope.isPreview){
                    	cvUtil.logToReportsUsage(title);
                    }
                }
            }

            $scope.updateReportDescription = function(reportDescription) {
                if (reportDescription) {
                	reportDescription = DOMPurify.sanitize(reportDescription,{SAFE_FOR_JQUERY: true});
                    angular.element("#crdescription").html(reportDescription);
                    angular.element("#crdescription").prop("title", reportDescription);
                }
            }
            if ($scope.customReport) {
                var reportTitle = rpt.translate("RPT_TITLE");
                var reportDescription = rpt.translate("RPT_DESCRIPTION");
                if ($scope.isPreview && $scope.customReport.translations === undefined) {
                    reportTitle = $scope.customReport.report.customReportName;
                    reportDescription = $scope.customReport.reportDescription;
                }

                if($scope.isPreview){
                    reportTitle = "PREVIEW - " + reportTitle;
                }

                $scope.updateReportName(reportTitle);
                $scope.updateReportDescription(reportDescription);
                if ($scope.customReport.pages) {
                    if ($scope.pageName){$scope.setActivePageByName($scope.pageName);} else {$scope.setDefaultPageAsActive();}
                }
            }

            if ($scope.exportType) {
                var userAgent = window.navigator.userAgent.toLowerCase();
                angular.element("body").addClass("exportfriendly");
                if ($scope.exportType == 'PRINT') {
                    if (customReportSvc.isSafari(userAgent)) {
                        angular.element("body").addClass("safari");
                    } else if (window.navigator.userAgent.indexOf('MSIE') != -1) {
                        angular.element("body").addClass("msie");
                    }
                }

                var date = new Date();
                angular.element("#generatedOnSpan").html(moment.utc(date.valueOf() - (date.getTimezoneOffset() * 60 * 1000)).format("MMM DD, YYYY hh:mm A"));
                angular.element("#generatedOnText").show();

                window.pageTabs =[];
                $.each($scope.customReport.pages, function(index, pageTab){
                    if($scope.page.pageName != pageTab.pageName){window.pageTabs.push(pageTab.pageName);}
                });
            }

            $scope.updateTranslation = function(update){
                var found = false;
                if (typeof $scope.customReport.translations !== "undefined" && $scope.customReport.translations.length > 0) {
                    for (var index in $scope.customReport.translations) {
                        var translation = $scope.customReport.translations[index];
                        if (translation.locale === update.locale && translation.localeKey === update.localeKey) {
                            translation.localeValue = update.localeValue;
                            found = true;
                            break;
                        }
                    }
                }

                if (!found) {
                    $scope.customReport.translations.push(update);
                    $scope.loadTranslations($scope.customReport.translations, false);
                }
            }

            $scope.getCustomReportObjectToSave = function(reportDef) {

                if (!reportDef.guid){reportDef.guid = customReportSvc.generateUUID();}
                var cr = angular.copy(reportDef, {});


                for (var i = 0; i < cr.pages.length; i++) {
                    var page = cr.pages[i];
                    //save the defaultParamsUrl
                    if(page.defaultUrlEnabled){
                    var pageParams = customReportSvc.getUrlParams()
                    for(var x in defaultParams){
                        delete pageParams[defaultParams[x]];
                    }
                    var url = dataSetUtility.requestToUrl(pageParams);
                    page.defaultUrlParams = url;
                    }else{
                        page.defaultUrlParams = undefined;
                    }
//                    if(page.headerComponents && page.headerComponents.length > 0) {
//                     page.headerComponents = JSON.stringify(page.headerComponents);
//                    }
                    if (page.body) {
                        var components = page.body.reportComponents || [];
                        for (var j = 0; j < components.length; j++) {
                            delete components[j]["isSelected"];
                            delete components[j]["isComponentLoading"];
                            delete components[j]["selectedValues"];
                            if (components[j].type == "TABLE") {
                                var columns = components[j].columns || [];
                                angular.forEach(columns, function(val) {
                                    delete val["headerCellTemplate"];
                                    delete val["cellTemplate"];
                                    delete val["componentId"];
                                    delete components[j]["isSelected"];
                                });

                            } else if (components[j].type == "CHART") {
                                delete components[j]["currDataSeries"];
                                delete components[j]["isChartExist"];
                                delete components[j]["isTimeGrouping"];
                            } else if (components[j].type == "HEAT_MAP" || components[j].type == "SCATTER") {
                                delete components[j]["currDataSeries"];
                                delete components[j]["isChartExist"];
                            } else if (components[j].type === "FACET") {
                                angular.forEach(components[j].filterDataField, function(filterObj, filterMode) {
                                    delete components[j].filterMode;
                                    angular.forEach(filterObj, function(dataSetObj, dataSetName) {
                                        angular.forEach(dataSetObj["fields"], function(fieldObj, fieldName) {
                                            delete fieldObj.advancedFilters;
                                            delete fieldObj.selectAll;

                                        });
                                    });
                                });
                            }
                            if((components[j].type === "TABLE" || components[j].type === "KENDO_GRID" || components[j].type === "KENDO_TREEGRID") && (components[j].rowFormatter))
                                delete components[j].rowFormatter.rowIndex;
                            var icon = "vertical-bar.png";
                            //set report icon logic , this is moved java handler to avoid further processing and JSON parsing
                            if(j === 0 ){
                                var compType = components[j].type;
                                if(compType === "TABLE"){
                                    icon = "data-table.png";
                                }else if(compType === "PIVOT_TABLE"){
                                    icon = "pivot-table.png";
                                } else if (compType === "CHART") {
                                    var chart =  components[j];
                                    if(chart.chartType === "Pie"){
                                        icon = "pie-chart.png";
                                    }else if(chart.chartType === "Line"){
                                        icon = "line-chart.png";
                                    }else if(chart.chartType === "TimeSeries"){
                                        icon = "timeline-chart.png";
                                    }else{
                                        if(chart.chartType === "HorizontalBar"){
                                            icon = "horizontal-bar.png";
                                            if(chart.measureDataField.length > 1 || chart.dimensionDataField.length > 1 ){
                                                if(chart.isGrouped){icon = "horizontal-groupbar.png";} else {icon = "horizontal-stackbar.png";}
                                            }
                                        }else{
                                            icon = "vertical-bar.png";
                                            if(chart.measureDataField.length > 1 || chart.dimensionDataField.length > 1 ){
                                                if(chart.isGrouped){icon = "vertical-groupbar.png";} else {icon = "vertical-stackbar.png";}
                                            }
                                        }
                                    }

                                }
                            }
                            cr.icon = icon;

                        }
                        if (page.dataSets) {
                            var dataSets = page.dataSets.dataSet || [];
                            angular.forEach(dataSets, function(dataSet, index) {
                                if (dataSet.endpoint === 'DATACUBE' && !dataSet.staticDataSetFields) {
                                    dataSet.fields = [];
                                }
                            });
                        }
                        page.body = JSON.stringify(page.body, undefined, 4);
                    }
                }

                delete cr["dynamicStyle"];
                return cr;
            }
            function getDatacubeHandlersList(customReport) {
                // get data cube datasources across all pages to share along with report
                var dataCubeHandlerList = []
                angular.forEach((customReport.pages || []), function(page, pIndex) {
                    if (page.dataSets) {
                        angular.forEach((page.dataSets.dataSet || []), function(dataSet, dIndex){
                            if (dataSet.endpoint == 'DATACUBE' && dataSet.dCubeDataSet) {
                                var dCubeDataSet = dataSet.dCubeDataSet;
                                if (dCubeDataSet.dsHandler && dCubeDataSet.dsHandler.handlerId) {
                                    dataCubeHandlerList.push(dCubeDataSet.dsHandler.handlerId);
                                }
                            }
                        });
                    }
                });
                return dataCubeHandlerList;
            }

            $scope.openModal = function(entity) {
                $uibModal.open({
                   templateUrl:  customReportSvc.getContextPath() +"/reportsplus/security/showSecurityModal.jsp",
                   controller: "showSecurityModalCtrl",
                     resolve: {
                         entity: entity
                     }
                });
            };

            $scope.showSecurityModal = function(entity) {
                var customReport = $scope.customReport;
                if (customReport && customReport.report && customReport.userReportId === 'Reports Manager') {
                    // in case we got the request from reportManager
                    entity.dataCubeHandlerList = []
                    reportService.getReportHandlers(entity.entityId).then(function(data) {
                        if (data && data.data) {
                            entity.dataCubeHandlerList = data.data;
                        }
                        $scope.openModal(entity);
                    });
                } else {
                    entity.dataCubeHandlerList = getDatacubeHandlersList(customReport);
                    $scope.openModal(entity);
                }

            };

            angular.element("#securityButton").on("click",function(evt) {
                var entity = {
                    entityType : 131,
                    entityId : $scope.customReport.report.customReportId,
                    entityName : $scope.customReport.report.customReportName,
                    entitySubType : customReports.isDashboard ? 'CustomDashboards' : 'Report',
                }
                $scope.showSecurityModal(entity);
            });
        }

        $scope.initViewerActions = function() {

/*
 * angular.element(".exportatserver").on("click", function(evt) { $scope.saveReportAs($(this)); });
 */

            if ($scope.isPreview) {
                angular.element("#actionsButton").hide();
                angular.element("#reportButton").hide();
            }

            if(!$scope.customReport.builderVersion){
                $scope.customReport.builderVersion = 1;
            }

            $scope.exportCsv = function(directDownload) {
                var subscriptionID = window.sessionStorage.getItem('export_subscriptionID');
                var comps = $scope.page.body.reportComponents;
                 var showComponents = customReportSvc.getParameterByName("showComponents");
                 var comps=[];
                 if (showComponents) {
                     var componentIds = window.decodeURIComponent(showComponents).split(",");
                     angular.forEach($scope.page.body.reportComponents, function(component, index) {
                         if (componentIds.indexOf(component.id) !== -1){
                            comps.push(component);
                         }
                     });
                 }else{
                    comps = $scope.page.body.reportComponents;
                 }
                 //logic to derive the component from the layout for the csv to be written
                 var rows = {};
                 angular.forEach(comps, function(comp, index) {
                     var key = $scope.page.body.reportLayout[comp.id][$scope.deviceType].position[0];
                     var value = $scope.page.body.reportLayout[comp.id][$scope.deviceType].position[1];
                     if(!rows[key]){
                         rows[key] = [];
                     }
                     if(rows[key].length > 0 && value < rows[key][rows[key].length -1].order){
                         rows[key].splice(rows[key].length -1, 0, {order: value , id:comp});
                     }else{
                         rows[key].push({order: value , id:comp});
                     }
                 });
                 var expComponents = [];
                 for(var key in rows){
                     var arr = rows[key];
                     for(var j=0;j<arr.length;j++){
                        var obj =  arr[j];
                        expComponents.push(obj['id']);
                     }
                 }
                 $scope.mergedParams = $.extend({}, $scope.requestParms, $scope.page.viewParams);
                var dataSetsToExport = customReportSvc.getDataSetstoExport(expComponents, $scope.page, $scope.customReport.report.customReportName, $scope.mergedParams,null,$scope.customReport.builderVersion,comps);
                var filePrefix = customReportSvc.getParameterByName('exportedFileName') || $scope.customReport.report.customReportName;
                if (!directDownload && !subscriptionID) {
                    angular.element("#content").mask("Generating csv");
                }

                var params = {
                        dataSets:JSON.stringify(dataSetsToExport),
                        exportedFileName:filePrefix,
                        exportType : 'csv',
                        reportName:$scope.customReport.report.customReportName,
                        cacheId:$scope.cacheId,
                        subscriptionID : subscriptionID
                };

                reportService.retrieveCsvData(params).then(function(data) {
                    console.log("CSV export succeeded with the file name : " + data.data);
                    window.csvFileDownloaded = true;
                    if (!directDownload && !subscriptionID) {
                        angular.element("#content").unmask();
                        var data1 = data.data;
                        dataSetUtility.downloadReportFile(data1);
                    }
                }, function(xhr, ajaxOptions, thrownError) {
                    if (thrownError != 'userAborted') {
                        customReportSvc.errorToast(xhr.data.trim()); //cvUtil.handleError(xhr, ajaxOptions, thrownError);
                    }
                });
            };

                $scope.dashboardAction = function(action,reportName,callback){
                    var tempUrl = action === "Delete" ? "dashboards/dashboardAction.jsp" : "dashboards/newdashboard.jsp";
                    var modalInstance = $uibModal
                    .open({
                        templateUrl : tempUrl,
                        size : "md",
                        backdrop : 'static',
                        resolve: {
                            db: function() {
                                var db = {};
                                if(action === "Rename" || action === 'Delete'){
                                    db.name = $scope.customReport.report.customReportName;
                                    db.description = $scope.customReport.reportDescription;
                                    db.refreshEnabled = $scope.customReport.pages[0].body.autoRefresh;
                                    db.refreshEvery = $scope.customReport.pages[0].body.autoRefreshTime;
                                }
                                return db;
                            }
                        },
                        controller:[
                            "$scope","db",
                            function($scope,db) {
                                $scope.action = action;
                                $scope.dashboardName = reportName ? reportName : "";
                                $scope.dashboard = db;
                                $scope.done = function(){
                                    $scope.$close($scope.dashboard);
                                }
                            }],
                        keyboard : false
                    });

                    modalInstance.result.then(function(db) {
                        if(db && db.name){
                            var dashboard;
                            if(action === 'New') {
                                var bodyString = { "reportComponents": [], "filters": { "builder": {}, "viewer": {} }, "reportLayout": { "gridsterOpts": { "columns": 12 } } };
                                if(db.refreshEnabled){
                                    bodyString.autoRefresh = db.refreshEnabled;
                                    bodyString.autoRefreshTime = db.refreshEvery;
                                    bodyString.isAutoRefreshShow = true;
                                }else{
                                    bodyString.isAutoRefreshShow = false;
                                }
                                var dashboard = {
                                        "report": {
                                            "customReportId": 0,
                                            "customReportName": ""
                                        },
                                        "pages": [{
                                            "pageName": "Page0",
                                            "isDefault": true,
                                            "pageTitle": {
                                                "text": "Page0"
                                            },
                                            "dataSets": {},
                                            "inputs": [],
                                            "body": bodyString,
                                            "userFilters": [],
                                            "view": []
                                        }],
                                        "userReportId": ""
                                    }
                                //dashboard = JSON.parse(reportString);

                            } else if(action === 'Rename') {
                                dashboard = $scope.customReport;
                            } else if(action === 'Delete') {
                                reportService.deleteReport({
                                    reportId : $scope.reportId,
                                    reportName : encodeURIComponent($scope.reportName)
                                }).then(function(data) {
                                    customReportSvc.toast(data.data, null, null, true);
                                    window.location.assign(customReportSvc.getContextPath() + "/reports/reports.jsp?page=CustomDashboards");
                                })
                            }

                            if(action === 'New' || action === 'Rename'){
                                dashboard.report.customReportName = db.name;
                                dashboard.reportDescription = db.description;
                                $scope.updateTranslation({ locale: "default", localeKey: "RPT_TITLE", localeValue: db.name });
                                $scope.updateTranslation({ locale: "default", localeKey: "RPT_DESCRIPTION", localeValue: db.description });
                                if(action === 'New'){
                                    dashboard.userReportId = db.name;
                                }
                                dashboard.type = "DASHBOARD";
                                return $scope.saveDashboard(dashboard,false,callback);
                            }

                        }
                    });
                }


				angular.element('#saveButton').on("click", function() {
				  $scope.saveDashboard($scope.customReport,true);
				});


                $scope.saveDashboard = function(dashboard,update,callback){
                    dashboard = $scope.getCustomReportObjectToSave(dashboard);
                    reportService.saveReport(dashboard).then(function(data) {
                        dashboard = data.data;
                    reportService.deployReport(dashboard.report.customReportId).then(function(data) {
                        if(!callback){
                            if(!update){
                                customReportSvc.toast("Dashboard " + dashboard.report.customReportName + " created and deployed successfully.", null, null, true);
                                window.location.assign(customReportSvc.getContextPath() + "/reportsplus/dashboards/dashboardViewer.jsp?reportId=" + dashboard.report.customReportId);
                            }else{
                                customReportSvc.toast("Dashboard " + dashboard.report.customReportName + " updated successfully.", null, null, true);
                            }
                        }else{
                            callback(dashboard)
                        }
                        return dashboard;
                    }, function(error) {
                        customReportSvc.triggerCallback("closeLoadingCallbacks");
                        alert(error.data);
                    });
                }, function(error) {
                    customReportSvc.triggerCallback("closeLoadingCallbacks");
                    alert(error.data);
                });
                }

                $scope.addNewDashboard = function() {
                    $scope.dashboardAction('New');
                }

                $scope.renameDashboard = function() {
                    $scope.dashboardAction('Rename',$scope.customReport.report.customReportName);
                }

                $scope.deleteDashboard = function() {
                    $scope.dashboardAction('Delete',$scope.customReport.report.customReportName);
                }

            $scope.saveAsView =function(mode){
                $scope.viewMode = mode;
                $scope.tableMode = false;
                $uibModal.open({
                    templateUrl: customReports.contextPath + "/reportsplus/views/viewModal.jsp",
                    controller: 'viewModalCtrl',
                    backdrop: 'static',
                    windowClass:'small-size',
                    scope:$scope
                });
            };


            $scope.saveReportAs = function(exportType) {
                var subscriptionID = window.sessionStorage.getItem('export_subscriptionID');
                var maxWidth = 1200;
                var url = document.URL;
                if (exportType){exportType = exportType.toLowerCase();}

                url = url + "&exportType=" + exportType + "&allDataSets=true&pageSize=-1&cacheId=" + globalVar.cacheId;
                var directDownLoad = exportType == "csv";
                if (exportType === 'csv') {
                    $scope.exportCsv(false);
                    return;
                }
                var filePrefix = $scope.customReport.report.customReportName;
                var widthParam = "&width=" + maxWidth;
                customReportSvc.DEFAULT_TIMEOUT = 300000;

                var saveAsUrl = customReportSvc.getContextPath() + '/reports/exp.do?orientation=landscape' + widthParam + '&exportType=' + exportType + '&viewportWidth=1600';
                var params = {
                    url: url,
                    filePrefix: filePrefix,
                    directDownload: false,
                    type: 'report',
                    subscriptionID : subscriptionID
                };
                var exportajaxRequest = reportService.saveAs(saveAsUrl, params);

                exportajaxRequest.then(function(data) {},
                    function(error) {
                        angular.element("#content").unmask();
                        if (error != 'userAborted') {
                            customReportSvc.errorToast(error); //cvUtil.handleError(xhr, ajaxOptions, thrownError);
                        }
                    });

            };

            var exportHandlersAttached = false;

            $scope.attachExportHandlers = function(){
                if (customReports.appName !== 'adminconsole' && customReports.subAppName !== 'forms' && !exportHandlersAttached) {
                	exportHandlersAttached = true;
                     var exportComponents=[];
                     angular.forEach($scope.page.body.reportComponents, function(component) {
                        var label = component.title && component.title.text ? component.title.text : component.id;
                        exportComponents.push({id:component.id,label:label});
                      });


                     var hasDataCubeDataSets = _.find($scope.customReport.pages, function(page) {
                    	 return !!_.find(page.dataSets.dataSet, function(o) { return o.endpoint === 'DATACUBE'; })
                     });

                    attachEmailHandler({
                        exportFileNamePrefix: $scope.customReport.report.customReportName,
						reportId : customReport.reportId,
                        exportComponents:exportComponents,
                        hasDataCubeDataSets: hasDataCubeDataSets
                    });
                    reportsUtil.scheduleReport({
                        exportFileNamePrefix: $scope.customReport.report.customReportName,
						reportId : customReport.reportId,
                        exportComponents:exportComponents,
                        hasDataCubeDataSets: hasDataCubeDataSets
                    });
                }
            }


        }
        $scope.initBuilderActions = function() {

            customReportSvc.checkBrowserCompatability(window.navigator.userAgent.toLowerCase(), $scope.isBuilder);
            angular.element('#deployButton').on("click", function() {
                $scope.deployReport();
            });

            $scope.customReport.builderVersion = builderVersion;


            if(!$scope.customReport.translations){$scope.customReport.translations = [];}

            $scope.displayProperties = {
                'selectedPanel' : 'report',
                'selectedRightPanel': 'visualization'
            };
            $scope.disableDeployButton = function() {
                $("#deployButton").addClass('disabled');
            }

            $scope.enableDeployButton = function() {
                $("#deployButton").removeClass('disabled');
            }

            if ($scope.reportId) {
                angular.element(".custom-report-version").text("Report Version: " + $scope.customReport.reportVersion);
                var deployVersion = $scope.customReport.deployedVersion == undefined ? 0 : $scope.customReport.deployedVersion;
                //angular.element(".custom-report-deployed-version").text("Deployed Version: " + deployVersion);
                if ($scope.customReport.deployedVersion < $scope.customReport.reportVersion){$scope.enableDeployButton();} else {$scope.disableDeployButton();}
            }

            $scope.exportTemplate = function(){
                if($scope.customReport.deployedVersion < $scope.customReport.reportVersion){
                    if (!confirm("The latest version of this report has not been deployed. Do you want to export the deployed version of this report?")) {
                        return;
                    }
                }
                $("#exportCRReportId1").val($scope.customReport.report.customReportId);
                $("#exportCustomReportForm").submit();

            }


            $scope.deployReport = function() {
                var cr = $scope.getCustomReportObjectToSave($scope.customReport);
                $scope.showLoading('Deploying the report')
                reportService.deployReport($scope.reportId).then(function(data) {
                    $scope.disableDeployButton();
                    var response = data.data;
                    customReportSvc.triggerCallback("closeLoadingCallbacks");
                    if (response.errorCode && response.errorCode != 0){customReportSvc.toast('Failed to deploy report ' + $scope.customReport.report.customReportName);}else {
                        customReportSvc.toast(data.data);
                        //if succesfully deployed the reportVersion will be equal to deployed version.
                        angular.element(".custom-report-deployed-version").text("Deployed Version: " + $scope.customReport.reportVersion);
                        $scope.customReport.deployedVersion = $scope.customReport.reportVersion;
                    }

                }, function(error) {
                    customReportSvc.triggerCallback("closeLoadingCallbacks");
                    alert(error.data);
                });
            }

            angular.element('#saveButton').on("click", function() {
                if ($scope.customReport.report.customReportName) {
                    //converting the body to string object before saving

                    var currentVersion = customReportSvc.getParameterByName('version');
                    if (currentVersion) {
                        currentVersion = parseInt(currentVersion);
                        var savedVersion = $scope.customReport.reportVersion;
                        if (currentVersion === savedVersion) {
                            if (!confirm("This report will be saved as current version")) {
                                return;
                            } else {
                                $scope.addParameterToUrl('version', undefined); // need to remove the version parameter from the url before saving.
                                $scope.saveReport(false);
                            }
                        }
                    } else {
                        $scope.saveReport(false);
                    }
                } else {
                    angular.element("#sectionTitle input").focus().addClass('border-red');
                    alert("Report name is invalid.");
                }
            });

            angular.element('#previewButton').on("click", function(event) {
                if (!$scope.customReport.report.customReportName) {
                    angular.element("#sectionTitle input").focus().addClass('border-red');
                    customReportSvc.errorToast("Report name is invalid.");
                    return;
                }

                var formAction = cvUtil.getContextPath() + "/reportsplus/reportViewer.jsp?&isPreview=true";
                if ($scope.page.isDefault === false) {
                    formAction += "&pageName=" + $scope.page.pageName;
                }
                var cr = $scope.getCustomReportObjectToSave($scope.customReport);
                localStorage.setItem("previewCustomReport", JSON.stringify(cr));
                window.open(formAction, 'Preview Window');
                event.preventDefault();
                event.stopPropagation();
            });

            angular.element('#openReportButton').on("click", function() {
                var reportId = $scope.customReport.report.customReportId;
                if (isNaN(reportId) || isNaN($scope.customReport.deployedVersion) || $scope.customReport.deployedVersion == 0) {
                    customReportSvc.errorToast("Please save and deploy the report before trying to view the latest deployed version");
                    return;
                }
                window.open(cvUtil.getContextPath() + "/reportsplus/reportViewer.jsp?reportId=" + reportId,$scope.customReport.report.customReportName);
                return;
            });
            if(isCloudSurvey){
                angular.element("#submitButton").on("click", function() {
                    if (!$scope.customReport.report.customReportName) {
                        angular.element("#sectionTitle input").focus().addClass('border-red');
                        customReportSvc.errorToast("Report name is invalid.");
                        return;
                    }
                    var cr = $scope.getCustomReportObjectToSave($scope.customReport);
                    reportService.saveReport(cr).then(function(data) {
                        var reportId = data.data.report.customReportId;
                        var reportName = data.data.report.customReportName;
                        $scope.addParameterToUrl('reportId', reportId);
                        var reportURL = document.URL;
                        customReportSvc.toast('Report ' + reportName + ' saved, submitting...')
                        //document.URL
                        reportService.submitMetricsReport(reportId, reportName, reportURL).then(function(data) {
                            customReportSvc.toast('Report ' + reportName + ' submitted. Your RequestID is ' + data.data.reqId + '.');
                            //redirect to reports page with delay 3sec
                            setTimeout(function(){
                                window.location.replace(cvUtil.getContextPath() +'/reports/')
                            }, 3000);
                        }, function(error) {
                            customReportSvc.triggerCallback("closeLoadingCallbacks");
                            customReportSvc.errorToast(error.data);
                        });
                    }, function(error) {
                        customReportSvc.triggerCallback("closeLoadingCallbacks");
                        customReportSvc.errorToast(error.data);
                    });
                });

                angular.element('#surveyCloudDeployButton').on("click", function() {
                    $scope.showLoading('Submitting report for cloud deployment.');
                    var reportId = $scope.customReport.report.customReportId;
                    var reportName = $scope.customReport.report.customReportName;
                    var host = window.location.origin;
                    if(!host){
                        host = window.location.protocol+'://'+window.location.host;
                    }
                    var reportURL = host+customReports.contextPath +'/reportsplus/reportViewer.jsp?reportId='+reportId;
                    reportService.deployMetricsReport(reportId).then(function(data) {
                        reportService.finalDeployMetricsReport(reportId, reportName, reportURL).then(function(data) {
                            customReportSvc.toast('Report successfully submitted for cloud deployment.');
                            //redirect to reports page with delay 3sec
                            setTimeout(function(){
                                window.location.replace(customReports.contextPath +'/reports/')
                            }, 3000);
                        }, function(error) {
                            customReportSvc.triggerCallback("closeLoadingCallbacks");
                            customReportSvc.errorToast(error.data);
                        });
                    }, function(error) {
                        customReportSvc.triggerCallback("closeLoadingCallbacks");
                        customReportSvc.errorToast(error.data);
                    });
                });

                if($scope.customReport.report.customReportId > 0){
                    $scope.getCustomDCReportStatus = function() {
                        var reportId = $scope.customReport.report.customReportId;
                        var reportName = $scope.customReport.report.customReportName;
                        reportService.getCustomDCReportStatus(reportId, reportName).then(function(data) {
                            $scope.customDCReportStatus = data.data.repDCStatus;
                        }, function(error) {
                            customReportSvc.triggerCallback("closeLoadingCallbacks");
                            customReportSvc.errorToast(error.data);
                        });
                    }
                    $scope.getCustomDCReportStatus();
                }
            }

            $scope.disableDeployButton = function() {
                $("#deployButton").addClass('disabled');
            }

            $scope.enableDeployButton = function() {
                $("#deployButton").removeClass('disabled');
            }



            $scope.saveReport = function() {
                // Perform validation steps
                // Check to make sure page names are unique
                var validReport = true;
                var duplicatePages = customReportSvc.checkForDuplicateIDsInObject($scope.customReport.pages, 'pageName');
                if (duplicatePages) {
                    validReport = false;
                    customReportSvc.errorToast("Multiple pages have the same name. Unable to save the report");
                }

                var emptyPageName = customReportSvc.checkForEmptyIDsInObject($scope.customReport.pages, 'pageName');
                if (emptyPageName) {
                    validReport = false;
                    customReportSvc.errorToast("At least one page has an empty Page Name. Unable to save the report");
                }
                var emptyPageDisplayName = customReportSvc.checkForEmptyIDsInObject($scope.customReport.pages, 'pageTitle.text');
                if (emptyPageDisplayName) {
                    validReport = false;
                    customReportSvc.errorToast("At least one page has an empty Page Display Name. Unable to save the report");
                }

                angular.forEach($scope.customReport.pages, function(page, index) {
                    var componentId = customReportSvc.checkForEmptyIDsInObject(page.body.reportComponents, 'id')
                    if(componentId){
                        validReport = false;
                        customReportSvc.errorToast("At least one component has an empty id in the page " +page.pageTitle.text +". Unable to save the report");
                        return;
                    }

                   var duplicateIdsInComponent = customReportSvc.checkForDuplicateIDsInObject(page.body.reportComponents, 'id');
                   if (duplicateIdsInComponent) {
                       validReport = false;
                       customReportSvc.errorToast("Multiple components have the same id in the page " + page.pageTitle.text +". Unable to save the report");
                       return;
                   }

                   var spacesInComponentIds = customReportSvc.checkForSpaceInIDs(page.body.reportComponents, 'id');
                   if (spacesInComponentIds) {
                       validReport = false;
                       customReportSvc.errorToast("At least one component in the page " + page.pageTitle.text +" has spaces with in its id. Unable to save the report");
                       return;
                   }

                   //MR 277778: Column name should not contain square brackets
                    angular.forEach(page.body.reportComponents, function(reportComponent, index) {
                        var squareBracketsInColumnNames = customReportSvc.checkForSquareBracketsInColumnNames(reportComponent, 'displayName');
                        if (squareBracketsInColumnNames) {
                            validReport = false;
                            customReportSvc.errorToast("At least one column in the component '" + reportComponent.title.text +"' has square brackets with in its id. Unable to save the report");
                            return;
                        }
                   });

                   if ($scope.isTileBuilder && !$scope.tileDSProps.tileStatusDataSet) {
                       validReport = false;
                       customReportSvc.errorToast("Please select a dataset for tile status.");
                       return;
                   }

                   if ($scope.isTileBuilder ) {
                       if (!$scope.tileDSProps.tileStatusDataSet)  {
                           validReport = false;
                           customReportSvc.errorToast("Please select a dataset for tile status.");
                           return;
                       }

                       if (!$scope.tileProperties.outcomeColumn )  {
                           validReport = false;
                           customReportSvc.errorToast("Please select column for chart.");
                           return;
                       }

                       if (!$scope.tileProperties.remarksColumn)  {
                           validReport = false;
                           customReportSvc.errorToast("Please select column for remarks.");
                           return;
                       }


                   }

                });

                if (validReport) {
                    // Continue with saving the report
                    var cr = $scope.getCustomReportObjectToSave($scope.customReport);
                    //For now save the fields irrepsecitve of using CRE/Data Cube APIs as any report that is created must be able to run with any of these APIs.So commenting the below code.
                    /*
					 * if (!$.isEmptyObject(cr.pages[0].dataSets.dataSet)) { var dataSet =
					 * cr.pages[0].dataSets.dataSet[0]; if (dataSet.endpoint === 'DATACUBE' &&
					 * !$scope.useCREApiForSolr) { // if endpoint is datacube remove fields info
					 * cr.pages[0].dataSets.dataSet[0].fields = []; } }
					 */
                    cr.builderVersion = builderVersion;
                    if ($scope.isTileBuilder) {
                        //cleanup the objects
                        var category = $scope.tileProperties.category;
                        var formattedDS = {};
                        var formattedCat = {};

                        //initialize dataset GUID on new dataset
                        angular.forEach(cr.pages[0].dataSets.dataSet, function(dataset, index) {
                            if (!dataset.guid) {
                                dataset.guid= dataset.dataSet.dataSetGuid;
                            }
                        });

                        if ($scope.tileDSProps.tileStatusDataSet) {
                            if (!$scope.tileDSProps.tileStatusDataSet.guid) { // in case of newly created dataset, set guid to entity guid
                                var dsGuid = $scope.tileDSProps.tileStatusDataSet.dataSet.dataSetGuid;
                                $scope.tileDSProps.tileStatusDataSet.guid = dsGuid;
                            }
                            $scope.tileProperties.statusDataSet =  $scope.tileDSProps.tileStatusDataSet.guid;
                        }
                        $scope.tileProperties.statusDataSet =  $scope.tileDSProps.tileStatusDataSet.guid;

                        if (category) {
                            formattedCat.id = category.id;
                            formattedCat.name = category.name
                        }


                        $scope.tileProperties.category = formattedCat;
                        cr.tileProperties = JSON.stringify($scope.tileProperties);
                        cr.type = "TILE";
                    }

                    $scope.showLoading('Saving the report');
                    reportService.saveReport(cr).then(function(data) {
                        customReportSvc.triggerCallback("closeLoadingCallbacks");
                        if (customReportSvc.getParameterByName('reportId') == undefined || customReportSvc.getParameterByName('reportId') == "" || customReportSvc.getParameterByName('reportId') == "0") {
                            if (!$.isEmptyObject(data.data.pages) && !$.isEmptyObject(data.data.pages[0].dataSets.dataSet)) {
                                var dataSet = data.data.pages[0].dataSets.dataSet[0];
                                if (dataSet.endpoint === 'DATACUBE') {
                                    var searchViewData = {};
                                    searchViewData.dsId = dataSet.dCubeDataSet.dsId;
                                    searchViewData.searchViewName = data.data.report.customReportName;
                                    searchViewData.handlerId = dataSet.dCubeDataSet.dsHandler.handlerId;
                                    searchViewData.viewInfo = data.data.report.customReportId;
                                    reportService.saveReportView(searchViewData);
                                }
                            }
                            $scope.addParameterToUrl('reportId', data.data.report.customReportId);
                            $scope.reportId = data.data.report.customReportId;
                            $scope.customReport.report.customReportId = data.data.report.customReportId;
                            customReport.reportId = data.data.report.customReportId; // this is being used out side of controllers in the share report js.
                            $scope.reportName = data.data.report.customReportName;
                            //customReportSvc.setCustomReportObject(data.data,true);
                            customReportSvc.setEnableEditModeActions(true);
                        }
                        if(!$scope.reportName) {
                            $scope.reportName = data.data.report.customReportName;
                        }
                        $scope.customReport.reportVersion = data.data.reportVersion; //updating the report version
                        //angular.element(".custom-report-version").text("Report Version: " + data.data.reportVersion);
                        customReportSvc.toast('Report ' + data.data.report.customReportName + ' saved successfully. Version: ' + data.data.reportVersion);
                        $scope.enableDeployButton();

                        if (!isCloudSurvey && ($scope.customReport.reportVersion == 1 || ($scope.customReport.reportVersion - $scope.customReport.deployedVersion > 4))) {
                            $scope.showDeployDialog();
                        }

                    }, function(error) {
                        customReportSvc.triggerCallback("closeLoadingCallbacks");
                        alert(error.data);
                    });

                }
            };

            $scope.showContinueEditModal = function(data) {
                var modalInstance = $uibModal.open({
                    templateUrl: "modal/views/confirmModal.html",
                    controller: "confirmModalCtrl",
                    size: "sm",
                    backdrop: 'static',
                    keyboard: false,
                    resolve: {
                        modalTitle: function() {
                            return "Report Saved";
                        },
                        modalMessage: function() {
                            return "Continue editing?";
                        }
                    }

                });

                modalInstance.result.then(function() {
                    window.location.assign(customReportSvc.getContextPath() + "/reportsplus/index.jsp?reportId=" + data.reportId);
                }, function() {
                    window.location.assign(customReportSvc.getContextPath() + "/reports");
                });
            };

            $scope.showDeployDialog = function(data) {
                /*
				 * if(customReports.isCloudSurvey && scope.devSurveyGroup == 'false') { return; }
				 */
                var modalInstance = $uibModal.open({
                    templateUrl: "modal/views/confirmModal.html",
                    controller: "confirmModalCtrl",
                    backdrop: 'static',
                    keyboard: false,
                    windowClass: 'previewDialog',
                    resolve: {
                        modalTitle: function() {
                            return "Report Saved";
                        },
                        modalMessage: function() {
                            return "Report currently saved as draft. Do you wish to deploy the report ? ";
                        }
                    }

                });

                modalInstance.result.then(function() {
                    $scope.deployReport();
                });
            };

            $scope.showExportWarning = function(data) {
                var modalInstance = $uibModal.open({
                    templateUrl: "modal/views/confirmModal.html",
                    controller: "confirmModalCtrl",
                    backdrop: 'static',
                    keyboard: false,
                    windowClass: 'previewDialog',
                    resolve: {
                        modalTitle: function() {
                            return "Deploy Report ?";
                        },
                        modalMessage: function() {
                            return "Do you want to deploy the draft version before exporting the template ?";
                        }
                    }

                });

                modalInstance.result.then(function() {
                    $scope.deployReport();
                });
            };

            $scope.showLoading = function(message) {
                var modalInstance = $uibModal.open({
                    templateUrl: "modal/views/loadingModal.html",
                    controller: "loadingModalCtrl",
                    backdrop: 'static',
                    keyboard: false,
                    size: "sm",
                    windowClass: 'loading-modal-window',
                    resolve: {
                        modalMessage: function() {
                            return message;
                        }
                    }
                });

            };



            // Watch for changes in report name
            $scope.$watch('customReport.report.customReportName', function() {
                $scope.updateReportName($scope.customReport.report.customReportName);
                if ($scope.customReport && $scope.customReport.report.customReportName) {
                    $scope.updateTranslation({ locale: "default", localeKey: "RPT_TITLE", localeValue: $scope.customReport.report.customReportName });
                }
            });

            // Watch for changes in report description
            $scope.$watch('customReport.reportDescription', function() {
                if ($scope.customReport && $scope.customReport.reportDescription !== undefined) {
                    $scope.updateTranslation({ locale: "default", localeKey: "RPT_DESCRIPTION", localeValue: $scope.customReport.reportDescription });
                }
            });

            // right panel resizability
            $('#rightCol').resizable({
                handles: {'w': $('.right-splitter')},
                minWidth: 215,
                maxWidth: 700,
                resizeHeight: false,
                resize : function(event, ui) {
                    var rightMargin = $("#rightCol").width();
                    $("#centerCol").css("right",rightMargin-14);
                    $("#reportContentWrapper").css("right",rightMargin-14);
                    ui.position.right = ui.originalPosition.right;
                },
                stop : function(event, ui) {
                    $("#rightCol").css("height","100%");
                    $scope.$broadcast("gridsterItemWidthChanged",true);
                }
            });
            $scope.showVisualizationPanel = function(event) {
                if (!$.isEmptyObject(event) && !$.isEmptyObject(event.originalEvent) && ($(event.originalEvent.srcElement || '').hasClass(
                        'gridster') || $(event.originalEvent.srcElement || '').is('#lowerPaddingDiv'))) {
                    $scope.displayProperties.selectedRightPanel = 'visualization';
                }
            }

            if ($scope.isTileBuilder) {
                 $scope.toggleLeftPanel('report');
            }
        }

        $scope.loadTranslations = function(translations, isCaseSensitive) {
            rpt.isLocaleCaseSensitive = isCaseSensitive !== undefined && isCaseSensitive != null && isCaseSensitive;
            if (typeof translations !== "undefined" && translations !== null && translations.length > 0) {
                for (var index = 0; index < translations.length; index++) {
                    if ($scope.isBuilder) {
                        // If its builder we must only load the default locale in the map
                        if (translations[index].locale !== 'default') {
                            continue;
                        }
                    }
                    if (rpt.isLocaleCaseSensitive) {
                        rpt.currentLocaleStrings[translations[index].localeKey] = translations[index].localeValue;
                    } else {
                        rpt.currentLocaleStrings[translations[index].localeKey.toUpperCase()] = translations[index].localeValue;
                    }
                }
            }
        }
            $scope.isDataCubeDataSetExist = function() {
                var flag = false;
                var dataSets = $scope.page.dataSets.dataSet;
                if(dataSets && dataSets.length > 0){
                    angular.forEach(dataSets, function(eachDS, index) {
                        if (eachDS.endpoint === 'DATACUBE')
                        {
                            flag = true;
                            return;
                        }
                    });
                }
                return flag;
            }

            $scope.getDatacubeUrlParams = function(init) {
                var hashPath = window.location.hash, parameters, parameterList = [];
                if(hashPath.indexOf("?") > -1)
                    parameters = hashPath.substring(hashPath.indexOf("?")+1);
                if(parameters)
                {
                    parameterList = parameters.split("&");
                }
                if (!$scope.requestParms) {
                    $scope.requestParms = {};
                }
                angular.forEach(parameterList, function(parameter) {
                    var keyValue = decodeURIComponent(parameter).split("=");
                    var key = keyValue[0], value;
                    try {
                        value = JSON.parse(keyValue[1]);
                    } catch(e) {
                        value = keyValue[1];
                    }
                    if (!$scope.requestParms[key] && (init || key.indexOf(".filter.") ==-1 )) {
                        $scope.requestParms[key] = value;
                    }
                });
                return $scope.requestParms;
            }
            $scope.pushToUrl = function(requestParams) {
                var hashPath = window.location.hash, hashValue;
                if(hashPath.indexOf("?") > -1)
                    hashValue = hashPath.substring(0,hashPath.indexOf("?")+1);
                else
                    hashValue = hashPath + "?";
                var urls = []
                angular.forEach(requestParams, function(value, key) {
                    var value1 = value;
                    try {
                        value1 = JSON.parse(value);
                        if(typeof value1 === 'object' || $.isArray(value)) //we don't want to parse the objects
                            value1 = value;
                    } catch(ex) {
                        value1= value;
                    }
                    if (Array.isArray(value1)) {
                        angular.forEach(value1, function(filterVal,index) {
                            urls.push(key + "-" + index + "=" +  encodeURIComponent(filterVal));
                        });
                    } else {
                        urls.push(key + "=" +  encodeURIComponent(value1));
                    }
                });
                $scope.historyUpdated = true;
                if ($scope.filterAcrossReports) {
                    // If we need to filter acorss reports, query params need to be prefixed with report name
                    $rootScope.$broadcast('pushToUrlWithReportName', requestParams, document.title, hashValue, urls, $scope.reportName);
                } else {
                    history.pushState(requestParams, document.title, hashValue + urls.join("&"));
                }
            };

        $scope.addParameterToUrl = function(name, value, addMultiple,removeParam , doNotUpdateUrl,replaceState) {

            if ($scope.filterAcrossReports && removeParam && name.indexOf('.filter.') !== -1) {
                // In case filter is from another report, we need to match without the component id using the filter type and value combination
                Object.keys($scope.requestParms).forEach(key => {
                    if (key.substring(key.indexOf('.') + 1) === name.substring(name.indexOf('.') + 1)) {
                        if (value === '' || (Array.isArray($scope.requestParms[key]) && !_.isUndefined($scope.requestParms[key].find(val => val === value)))) {
                            name = key;
                            return;
                        }
                    }
                });
            }
            if (addMultiple) {
                if($.isEmptyObject($scope.requestParms[name])){$scope.requestParms[name] = [];}
                var valIndex = $scope.requestParms[name].indexOf(value);
                if(valIndex==-1 && !removeParam) {
                    $scope.requestParms[name].push(value);
                } else if(removeParam) {
                    $scope.requestParms[name].splice(valIndex,1);
                }
            } else {
                if (typeof value !== "undefined" && value !== ""){
                    $scope.requestParms[name] = value;
                } else {
                    delete $scope.requestParms[name];
                }
            }
            if(doNotUpdateUrl){
                return;
            }
                if ($scope.isDataCubeDataSetExist()) {
                    $scope.pushToUrl($scope.requestParms);
                    return;
                }
                if (customReports.subAppName === 'forms') {
                    return;
                }

            var url = dataSetUtility.requestToUrl($scope.requestParms);
            var hashValue = "?";
            if(customReports.appName === 'adminconsole'){
                var hashPath = window.location.hash;
                if(hashPath.indexOf("?") > -1)
                    hashValue = hashPath.substring(0,hashPath.indexOf("?")+1);
                else
                    hashValue = hashPath + "?";
            }
            if(!replaceState){
            	 $scope.historyUpdated = true;
            	rptUrlService.updateUrl($scope.requestParms,url);
            	//history.pushState($scope.requestParms, document.title, hashValue + url);
            }else{
            	history.replaceState($scope.requestParms, document.title, hashValue + url);
            }
        };

        $scope.showLoading = function(message) {
            var modalInstance = $uibModal.open({
                templateUrl: "modal/views/loadingModal.html",
                controller: "loadingModalCtrl",
                backdrop: 'static',
                keyboard: false,
                size: "sm",
                windowClass: 'loading-modal-window',
                resolve: {
                    modalMessage: function() {
                        return message;
                    }
                }
            });

        };

        $scope.activeComponent = undefined;
        $scope.setActiveComponent = function(component, subcomp,event) {
            if ($scope.isBuilder && component.id !== "PreviewTable") {
                if (component) { // check if the click event is triggered from properties panel , then stop the event.
                    if ($scope.activeComponent){
                        $scope.activeComponent.isSelected = false;
                    }
                    $scope.activeComponent = component;
                    $scope.activeComponent.isSelected = true;
                    if (subcomp === 'reportName' || component.type === 'button') {
                        $("#rightCol>.colHeader>.compButtons").css("display","block");
                        // $("#rightCol").css("display","block");
                    } else if (subcomp === 'page') {
                        if(component.pageName !== $scope.selectedPage.pageName){
                            $scope.selectedPage.pageName = component.pageName;
                            $scope.setActivePageByName(component.pageName,'page');
                        }
                        $("#rightCol>.colHeader>.compButtons").css("display","block");
                        // $("#rightCol").css("display","block");
                    } else if ($scope.isTileBuilder) {
                        $scope.displayProperties.selectedPanel='report';
                    } else {
                        $scope.displayProperties.selectedPanel='dataset';
                    }
                    $scope.displayProperties.selectedRightPanel='properties';
                    if (component.dataField !== undefined) {
                        $timeout(function() {
                            $scope.$digest();
                        }, 1)
                    }
                }

                if(!component.componentId){
                    angular.element("table td").removeClass('selectedCol'); //remove the selectedCol class for the current selection of the column.
                }
                $(".gridster li").each(function() {
                    var componentId = $(this).attr('comp');
                    if (component.id !== componentId) {
                        $(this).css('z-index','2');
                    } else {
                        $(this).css('z-index','3');
                    }
                });

                if(event && !$(event.target).parents().hasClass("highcharts-tooltip")){
                    event.stopPropagation();
                }
            }
        }

        $scope.resetRequestParams = function(resetInputs){
            angular.forEach($scope.requestParms, function(value, key) {
                if(key.indexOf(".select.") !== -1 || key.indexOf(".filter.") !== -1 || key.indexOf(".sort.") !== -1 || key.indexOf("view") !== -1 || (resetInputs && key.indexOf("input.") !== -1)){
                    delete $scope.requestParms[key];
                }
            });
        }

        $scope.setActivePageByName = function(pageName,resetRequestParams,replaceState) {
            var foundPage = false;
            rpt.pageName = pageName;
            angular.forEach($scope.customReport.pages, function(pageDetails, index) {
                if (pageName.toLowerCase() == pageDetails.pageName.toLowerCase()) {
                    $scope.page = $scope.customReport.pages[index];
                    $scope.page.originalPageName = $scope.page.pageName;
                    if(resetRequestParams){
                        $scope.resetRequestParams(false);
                    }
                    if(!replaceState){
	                    if(!pageDetails.isDefault) {
	                        $scope.addParameterToUrl('pageName', $scope.page.pageName);
	                    }else{
	                    	//$scope.addParameterToUrl(key, value, false, false, doNotUpdateUrl, !$scope.initialLoad);
	                        $scope.addParameterToUrl('pageName', undefined,false, false, false,replaceState); // remove pageName from URL when default page is active
	                    }
                    }
                    foundPage = true;
                }
            });
            if (!foundPage) {
                customReportSvc.errorToast("Page [" + _.escape(pageName) + "] does not exist");
                $scope.setDefaultPageAsActive();
            }
        }

        $scope.setDefaultPageAsActive = function(update) {
            var foundDefaultPage = false;
            angular.forEach($scope.customReport.pages, function(pageDetails, index) {
                if (pageDetails.isDefault === true) {
                    foundDefaultPage = true;
                    $scope.page = $scope.customReport.pages[index];
                }
            });
            if (foundDefaultPage === false) {
                // We did not find any page set as the default, so set pages[0] as default
                $scope.customReport.pages[0].isDefault = true;
                $scope.customReport.pages[0].pageName = "Page0";
                $scope.customReport.pages[0].pageTitle = { text: "Page0" };
                $scope.page = $scope.customReport.pages[0];
            }

            $scope.page.originalPageName = $scope.page.pageName;
            rpt.pageName = $scope.page.pageName;
            if (update){
            	$scope.setActivePageByName($scope.page.pageName,undefined,true);
            	$scope.$apply();
            }

        }

        $scope.addPage = function() {
            var newpagenum = $scope.customReport.pages.length;
            while ($scope.doesPageNameExist('Page' + newpagenum, 0) === true) {
                newpagenum++;
            }
            $scope.customReport.pages.push({ pageName: 'Page' + newpagenum, header: {}, pageTitle: { text: 'Page' + newpagenum }, body: { reportComponents: [] }, footer: {}, dataSets: { dataSet: [] }, inputs: [], isDefault: false });
            // $scope.setActivePageByName('Page' + newpagenum);
            $scope.setActiveComponent($scope.customReport.pages[newpagenum],'page');
            customReportSvc.toast('Successfully created new page [Page' + newpagenum + ']');
        }

        $scope.setCurrentPageAsDefault = function() {
            // If the current page is default, we have nothing to do here
            if ($scope.page.isDefault === false) {
                angular.forEach($scope.customReport.pages, function(pageDetails, index) {
                    if (pageDetails.isDefault === true){
                        $scope.customReport.pages[index]['isDefault'] = false;
                    }
                });
                $scope.page.isDefault = true;
            }
        }

        $scope.deleteCurrentPage = function() {
            if (!$scope.page) {
                customReportSvc.errorToast('Unable to delete current page');
            } else if ($scope.page.isDefault === true) {
                customReportSvc.errorToast('The current page is marked as default and cannot be deleted');
            } else {
                angular.forEach($scope.customReport.pages, function(pageDetails, index) {
                    if ($scope.page.pageName.toLowerCase() == pageDetails.pageName.toLowerCase()) {
                        $scope.customReport.pages.splice(index, 1);
                        customReportSvc.toast('Successfully deleted page [' + pageDetails.pageName + ']');
                        $scope.setDefaultPageAsActive();
                        // break is not supported with angular.forEach .....
                        // consider switching to native for loop for performance reasons if necessary??
                    }
                });
            }
        }

        $scope.validatePageName = function() {
            if ($scope.doesPageNameExist()) {
                customReportSvc.errorToast('Multiple pages have the same name [' + $scope.page.pageName + ']. Please change the name of at least one page before saving the report');
            }

            if ($.trim($scope.page.pageName) == "") {
                customReportSvc.errorToast('Page name cannot be empty');
                $scope.page.pageName = $scope.page.originalPageName;
            }

        }

        $scope.validatePageDisplayName = function() {
            if ($.trim($scope.page.pageTitle.text) == "") {
                customReportSvc.errorToast('Page display name cannot be empty');
            }
        }


        $scope.doesPageNameExist = function(pageName, threshold) {
            if (pageName === undefined){
                pageName = $scope.page.pageName;
            }
            if (customReportSvc.checkForDuplicateIDsInObject($scope.customReport.pages, 'pageName', pageName, threshold)) {
                return true;
            } else {
                return false;
            }
        };

        $scope.refreshGridLayout = function() {
            $scope.gridsterOpts.columns = $scope.page.body.reportLayout['gridsterOpts'].columns;
        };;
        $scope.$watch('page.pageName', function(page) {
            if (page) {
                // remove all callbacks only in case of page switch
                customReportSvc.restCallbacks();
                $scope.selectedPage.pageName = $scope.page.pageName;
                if ($scope.page.isDefault === false && $scope.requestParms['pageName'] !== $scope.page.pageName){
                    $scope.addParameterToUrl('pageName', $scope.page.pageName);
                }
            }
        });

        $scope.openAceEditorWindow = function(editorContent,editorMode,dataVariable,scope,inputVariables,callback) {
            var modalInstance = $uibModal.open({
               templateUrl:  customReportSvc.getContextPath() +"/reportsplus/modal/views/aceEditorModal.jsp",
               controller: "aceEditorCtrl",
               windowClass: 'aceEditorModalWindow reportModal',
               backdrop  : 'static',
               resolve: {
                    modalTitle : function() {
                        return localMsg.CodeEditor;
                    },
                    editorOptions : function() {
                        return  {
                            mode: editorMode
                        }
                    },
                    editorContent : function() {
                        return editorContent
                    },
                    inputVariables : function() {
                        return inputVariables;
                    },
                    helpText : function() {
                        return "";
                    }
               }
            });

            modalInstance.result.then(function (modifiedContent) {
                if(dataVariable)
                    customReportSvc.assignValToStringVariable(scope,dataVariable,modifiedContent);
                if(callback)
                    callback(modifiedContent);
           });
        }


    }]);

    app.controller('pageController', ['$scope', '$window', 'customReportSvc', '$compile', 'reportService', 'tileBuilderSvc', '$timeout', '$q' , "dataSource","$uibModal","$interval", '$rootScope',
    function($scope, $window, customReportSvc, $compile, reportService, tileBuilderSvc, $timeout, $q, $dataSource,$uibModal,$interval, $rootScope) {
        $scope.dataSets;
        $scope.reportComponents;
        $scope.dataSetDeleted;
        $scope.isDcubeEnabledInCustomReports = isDcubeEnabledInCustomReports;
        $scope.pageViews=[];
        $scope.userView;
        $scope.selectedView = {};
        $scope.viewsInitialized = false;
        $scope.isUserFilter = function(selectedView){
            var userFilter = false;
            if(selectedView && selectedView.id){
                angular.forEach($scope.page.userFilters,function(view){
                    if(view.id === selectedView.id){
                        userFilter = true;
                    }
                });
            }
            return userFilter;
        }

        function getReportCapabilities(){
        	if($scope.cv && $scope.cv.isAdmin){
        		$scope.canEditReport = true;
        		$scope.canDeleteReport = true;
        	}else{
        		reportService.getReportCapabilities($scope.reportId).then(capabilitiesResponse => {
        			capabilitiesResponse = capabilitiesResponse.data;
        			var reportPermissions = [];
        			if(capabilitiesResponse.permissions && capabilitiesResponse.permissions.length >0) {
        				reportPermissions = capabilitiesResponse.permissions.map(function(permissionEntity){
        					return permissionEntity.permissionId;
        				});
        			}
        			$scope.canEditReport = checkReportPermission(reportPermissions, Permissions.EDIT_REPORT);
        			$scope.canDeleteReport = checkReportPermission(reportPermissions, Permissions.DELETE_REPORT);
        		}).catch(err => {
        			err = err.data;
        			console.log('Unable to fetch report permissions: '+err);
        		});
        	}
		}

		function checkReportPermission(reportPermissions, permission) {
			if(reportPermissions){
				return (reportPermissions.indexOf(permission) > -1);
			}
			return false;
		}

		getReportCapabilities();

        $scope.changeViewTodefault = function(){

        }

        $scope.buildViews = function(){
            $scope.pageViews=[];
            $scope.selectedView = {};
            var viewsEnabled = false;
            if($scope.page && $scope.page.systemFilters && $scope.page.systemFilters.length >0){
                angular.forEach($scope.page.systemFilters,function(view){
                    if ($scope.reportMode === 'builder') {
                        view.deleteEnabled=true;
                    }else{
                        view.deleteEnabled=false;
                    }
                    view.type = 'system';
                });


            $.merge($scope.pageViews, $scope.page.systemFilters);
            viewsEnabled = true;
            }

            if($scope.page && $scope.page.userFilters && $scope.page.userFilters.length>0){
                //$scope.pageViews.push({title:"User Views"});
                angular.forEach($scope.page.userFilters,function(view,index){
                    view.deleteEnabled=true;
                    view.index = index;
                    viewsEnabled = true;
                    view.type = 'user';
                });
                $.merge($scope.pageViews, $scope.page.userFilters);
            }

            if($scope.page && $scope.page.sharedFilters && $scope.page.sharedFilters.length >0){
                $.merge($scope.pageViews, $scope.page.sharedFilters);
            }

            if($scope.page && $scope.page.view && $scope.page.view.length > 0){
                viewsEnabled = true;
                $scope.userView = $scope.page.view[0]; // this is state of the page being saved as an object in the backend similar to user preference
                if(typeof $scope.userView.url === "string"){
                    $scope.userView.url = JSON.parse($scope.userView.url);
                }
                if($scope.userView.url && $scope.userView.url.viewOrder){
                    if($scope.userView.url && $scope.userView.url.viewOrder){
                        var reorderedViews = [];
                        var viewsOrder = $scope.userView.url.viewOrder.split(",");
                        var viewIds =  [];
                        for(var o in $scope.pageViews){
                            viewIds.push($scope.pageViews[o]['id']);
                        }
                        console.log(viewIds);
                        viewsOrder = _.union(viewsOrder,viewIds);
                        for(var i=0;i < viewsOrder.length;i++){
                            var index = -1;
                            for(var k=0; k < $scope.pageViews.length;k++){
                             if($scope.pageViews[k].id === viewsOrder[i]){
                                 reorderedViews.push($scope.pageViews[k]);
                                 continue;
                             }
                            }
                        }

                        $scope.pageViews = reorderedViews;
                    }
                }

            }else{
                $scope.userView = {
                    view:{
                        reportViewName: "viewFor"+$scope.customReport.report.customReportId
                    },
                    url:{},
                    pageName:$scope.page.pageName
                }
            }

            if(viewsEnabled){
            	var defaultView = $scope.requestParms['view'];
            	var applyDefaultView = true;
            	//check if the url has no view selected and over ridden url parameters , then we should  not apply default
            	for( var i in $scope.requestParms){
            		if(defaultParams.indexOf(i) === -1){
            			applyDefaultView = false;
            			break;
            		}
            	}
            	if(applyDefaultView && !defaultView){
            		defaultView = $scope.userView.url.defaultView;
            	}
                if(defaultView){
                    $scope.selectedView = _.find($scope.pageViews, function (obj) { return obj.id === defaultView; });
                }else{
                	// there can be system views which are marked default.
                    $scope.selectedView = _.find($scope.pageViews, function (obj) { return obj.isDefault });
                }
                if($scope.selectedView){
                	$scope.setSelectedView();
                }
            }
        }

        $scope.saveView =function(mode,tableMode,currentIndex,view,e ){
            $scope.viewMode = mode;
            $scope.tableMode = tableMode;
            $scope.currentIndex = currentIndex;
            $scope.currentView = view;
            $uibModal.open({
                templateUrl: customReports.contextPath + "/reportsplus/views/viewModal.jsp",
                controller: 'viewModalCtrl',
                backdrop: 'static',
                windowClass:'small-size',
                scope:$scope
            });
            if(e){
                e.preventDefault();
                e.stopPropagation();
            }
        };

        angular.element('body').on("click","#saveAsView", function() {
            $scope.saveView('Create',false);
        });

        $scope.endpoint = "DATACUBE";
        $scope.initPageLevelFilters = function() {
            if (!$.isEmptyObject($scope.page)
                && !$.isEmptyObject($scope.page.body)
                && $.isEmptyObject($scope.page.body.filters)) {
                $scope.page.body.filters = { 'builder' : {}, 'viewer' : {} };
            };
            $scope.pageFilters = $scope.page.body.filters;
        }
        $scope.updateEndpoint = function(newEndPoint){
            $scope.endpoint = newEndPoint;
            $scope.useCREApiForSolr = newEndPoint === "CRE" ? true : false;
            customReportSvc.triggerCallback("redrawAllComponents");
        }

        $scope.addSystemTag = function(systemTag) {
            if(!$scope.customReport.systemTags || $scope.customReport.systemTags.length === 0 ){$scope.customReport.systemTags = [];}

            if($scope.customReport.systemTags.indexOf(systemTag) == -1){
                $scope.customReport.systemTags.push(systemTag);
            }
        };

        $('.endpoint-dropdown li > a').click(function(e){
            $('.endpoint-text').text(this.innerHTML);
            $scope.useCREApiForSolr = this.innerHTML === "CRE" ? true : false;
            customReportSvc.triggerCallback("redrawAllComponents");

        });

        $scope.setSelectedView = function(){
            if(!$.isEmptyObject($scope.selectedView)){
                $scope.viewParams = customReportSvc.getUrlParams($scope.selectedView.url.replace("?",''));
                $scope.page.viewParams = customReportSvc.getUrlParams($scope.selectedView.url.replace("?",''));// temp fix to use in page level export.
                $scope.mergedParams = $.extend({},$scope.viewParams,$scope.requestParms);
                $scope.addParameterToUrl('view', $scope.selectedView.id);
            }else {
                $scope.changeView(undefined); // When no view is selected
            }
        }

        $scope.changeView = function(view){
            $scope.selectedView = view;
            $scope.resetRequestParams(true);
            if(view){
                $scope.addParameterToUrl('view', $scope.selectedView.id); // need to remove the version parameter from the url before saving.
                $scope.viewParams = customReportSvc.getUrlParams($scope.selectedView.url.replace("?",''));
            }else{
                $scope.addParameterToUrl('view', undefined); // need to remove the version parameter from the url before saving.
                $scope.viewParams = undefined;
            }
            $scope.mergedParams = {};
            $scope.mergedParams = $.extend({}, $scope.requestParms, $scope.viewParams);
            if($scope.page && $scope.page.inputs && $scope.page.inputs.length > 0){
            	customReportSvc.triggerCallback("redrawAllInputs", $scope.page);
            }else{
                customReportSvc.triggerCallback("redrawAllComponents");
            }

        }

        $scope.confirmDelete = function(view,e){
            $uibModal.open({
                templateUrl: customReports.contextPath + "/reportsplus/views/deleteView.jsp",
                scope:$scope,
                backdrop: 'static',
                windowClass:'small-size',
                controller:['$scope','reportService',function($scope,reportService){
                    $scope.$parent.viewToDelete = view;
                    $scope.deleteView = function(viewToDelete){
                           angular.forEach($scope.pageViews, function(pageView, index) {
                                if (pageView.id === viewToDelete.id){
                                    $scope.pageViews.splice(index, 1);
                                }
                           });

                          if(viewToDelete.type === 'system'){
                              $scope.page.systemFilters = _.without($scope.page.systemFilters, _.find($scope.page.systemFilters, {
                                    id : viewToDelete.id
                                }));
                          }else{
                              reportService.deleteView(viewToDelete.view.reportViewId);
                             // to rest the default view if the current deleted view is the default view.
                             if(viewToDelete.id === $scope.userView.url.defaultView){
                                 $scope.saveUserView('defaultView',undefined);
                             }
                          }
                         if($scope.selectedView && $scope.selectedView.id === viewToDelete.id){
                             $scope.$parent.selectedView = undefined;
                             $scope.setSelectedView();
                         }
                         $scope.$close();
                    }
                }]
            });
            e.stopPropagation();
            e.preventDefault();

        }

        $scope.reorderViews = function(){
            $scope.currentPageviews = angular.copy($scope.pageViews, []);
            $uibModal.open({
                templateUrl: customReports.contextPath + "/reportsplus/views/reorderViews.jsp",
                scope:$scope
            });
        }

        $scope.setDefaultView = function(view,e){
            $scope.saveUserView('defaultView',view.id);
            if(e){
                e.stopPropagation();
                e.preventDefault();
            }
        }

        $scope.applyOrder = function(){
            var viewOrder="";
            $scope.pageViews = angular.copy($scope.currentPageviews, []);
            angular.forEach($scope.pageViews,function(view){
                viewOrder = viewOrder+view.id+",";
            });
            if(viewOrder){
                viewOrder=viewOrder.substring(0,viewOrder.lastIndexOf(","));
            }
            $scope.saveUserView('viewOrder',viewOrder);
        }

        $scope.saveUserView = function(property,value){
            $scope.userView.url[property]=value;
            $scope.userView.url = JSON.stringify($scope.userView.url);
            reportService.saveView($scope.customReport.report.customReportId, $scope.userView, 'view').then(function(data) {
                $scope.userView=data.data;
                $scope.userView.url = JSON.parse($scope.userView.url);
            });
        }

        function comparePositions(component1, component2) {
            if (component1.position.x == component2.position.x) {
                return component1.position.y - component2.position.y;
            }
            return component1.position.x - component2.position.x;
        }

        $scope.resetComponents = function() {
            $scope.reportComponents = [];
        }

        $scope.setReportComponents = function() {
            var showComponents = customReportSvc.getParameterByName("showComponents");
            $scope.panelComponents = {};
            $scope.panelComponentsToIds = {};
            var comps=[];
            if (showComponents) {
                var componentIds = window.decodeURIComponent(showComponents).split(",");
                angular.forEach($scope.page.body.reportComponents, function(component, index) {
                    if (componentIds.indexOf(component.id) !== -1){
                        comps.push(component);
                    }
                });
                $scope.chartOptions = true
            }else{
                comps = $scope.page.body.reportComponents;
            }
            $scope.reportComponents = comps;
            if($scope.isDashboard){
                $scope.customClass="dashboard-mode";
            }
            if ($scope.page && $scope.page.body && $scope.page.body.reportLayout) {
                var layout = $scope.page.body.reportLayout;
                angular.forEach($scope.reportComponents, function(component,index) {
                   // with the new changes the components having special characters like % or space is failing to load. So stripping them.
                   //component.id =  component.id.replace(/[^a-zA-Z0-9]/g, '');

                   component.id = customReportSvc.getFormattedId(component.id);

                       component.position = {'x' : 0, 'y' : 0};
                       if (layout[component.id]
                            && layout[component.id][$scope.deviceType]
                            && ((typeof layout[component.id][$scope.deviceType].position != 'undefined'
                            	&& Object.keys(layout[component.id][$scope.deviceType].position)) || []).length ==2) {
                           component.position.x = layout[component.id][$scope.deviceType].position[0];
                           component.position.y = layout[component.id][$scope.deviceType].position[1];
                       }else if($scope.dashboardMode && !layout[component.id]){
                           var gridLayoutItemAttrs = $scope.updateReportComponentLayout(component.id,index,gridLayoutItemAttrs);
                           layout[component.id] = gridLayoutItemAttrs;
                       }

                       if(component.type === 'PANEL'){
                    	   var panelCompIds = _.map(component.panelComponents, function(o) {
								$scope.panelComponentsToIds[o.id] = component.id;
								return o.id;
							});
							$scope.panelComponents[component.id] = panelCompIds;
                       }
                });
                $scope.reportComponents.sort(comparePositions);
                angular.forEach($scope.reportComponents, function(component) {
                    delete component.position;
                });
            }
            $scope.startAutoRefreshTimer();
            if ($scope.reportMode == 'viewer' && !$scope.healtTileViewer){
                $scope.attachExportHandlers();
            }
        }

        $scope.reloadAllComponents = function(resetCache, isAutoRefresh){
            if(resetCache){
                $scope.clearAndResetCacheId(true);
            }
            customReportSvc.triggerCallback("redrawAllComponents",undefined,undefined,isAutoRefresh);
        };

        $scope.$on('fullRefresh', function(event, data) {
        	$scope.reloadAllComponents(data);

        });


        $scope.$on('saveAsView', function(event, data) {
			$scope.saveView('Create',false);
        });

        $scope.setAllInputsIntialized = function() {
            if ($scope.isDataCubeDataSetExist()) {
                var entityObj = customReportSvc.getSelectedCommcellEntity($scope.page.inputs);
                angular.forEach($scope.dataSets, function(eachDS, index) {
                    if (eachDS.endpoint === 'DATACUBE') //only data cube needs to fetch the schema dynamically
                    {
                        var params = customReportSvc.applyInputsToDataSet(eachDS, $scope.page.inputs);
                        customReportSvc.applyParamsToDCubeDataSet(eachDS, params);
                        var dCubeDataSet = eachDS.dCubeDataSet;
                        if (dCubeDataSet.dsHandler && dCubeDataSet.dsType === 'federated' && dCubeDataSet.dsId == -1) {
                            if (entityObj.hasOwnProperty("entityTypeId")) {
                                dCubeDataSet.dsHandler.entityTypeId = entityObj.entityTypeId;
                            }
                            if (entityObj.hasOwnProperty("entityId")){
                                dCubeDataSet.dsHandler.entityId = entityObj.entityId;
                            } else {
                                dCubeDataSet.dsHandler.entityId = -1; //no data to display when there is no input selected
                            }
                        }
                    }
                });
                $scope.inputsInitialized = true;
            } else {
                $scope.setReportComponents();
                $scope.setReportLayoutForAllComponents();
            }
        };

        $scope.updateReportComponentLayout = function(compId,index,previousAttr){
            var defaultNumberOfColsInGrid = $scope.reportLayout.gridsterOpts.columns/2;
            var y = index % 2 === 0 ? 0 : 6;
            var calcx = 0;
            if(index >= 2){
                calcx = 9;
            }else if(index > 2 && previousAttr){
                calcx = previousAttr['desktop'][position][0]
            }

            if(index > 1 && y === 0){
                calcx = calcx + 9;
            }

            calcx = calcx+9;
            var gridLayoutItemAttrs = {
                    mobile: {
                        size: {
                                x: 4,
                                y: 8
                        },
                        position: [ [ 2, 1 ], 0]
                    },
                    tablet: {
                        size: {
                                x: 4,
                                y: 8
                        },
                        position: [ [ 2, 1 ], 0]
                    },
                    desktop: {
                        size: {
                                x: 6,
                                y: 9
                        },
                        position: [calcx, y]
                    }
                };
            return gridLayoutItemAttrs;

        }

        $scope.setReportLayoutForAllComponents = function() {
            /* setting gridster position and size */
            if ($scope.isDcubeEnabledInCustomReports) {
                if ($.isEmptyObject($scope.page.body.reportLayout)) {
                    $scope.reportLayout = {};
                    $scope.reportLayout.gridsterOpts = { 'columns' : $scope.gridsterOpts.columns };
                        var defaultNumberOfColsInGrid = $scope.reportLayout.gridsterOpts.columns;
                    angular.forEach($scope.reportComponents, function(comp, index) {
                            var gridLayoutItemAttrs = {
                                mobile: {
                                    size: {
                                            x: defaultNumberOfColsInGrid,
                                        y: $scope.defaultNumberOfRows
                                    },
                                        position: [index ? $scope.defaultNumberOfRows*index : 0, 0]
                                },
                                tablet: {
                                    size: {
                                            x: defaultNumberOfColsInGrid,
                                        y: $scope.defaultNumberOfRows
                                    },
                                        position: [index ? $scope.defaultNumberOfRows*index : 0, 0]
                                },
                                desktop: {
                                    size: {
                                            x: defaultNumberOfColsInGrid,
                                        y: $scope.defaultNumberOfRows
                                    },
                                        position: [index ? $scope.defaultNumberOfRows*index : 0, 0]
                                }
                            };
                            comp.id = customReportSvc.getFormattedId(comp.id);
                            $scope.reportLayout[comp.id] = gridLayoutItemAttrs;
                    });
                     $scope.page.body.reportLayout = $scope.reportLayout;
                } else {
                    $scope.reportLayout = $.extend(true,{},$scope.page.body.reportLayout);  // deep copy
                    var defaultNumberOfColsInGrid = $scope.gridsterOpts.columns;
                    var existingNumberOfColsInGrid = 6;
                    if (!$scope.reportLayout.gridsterOpts) {
                        $scope.reportLayout.gridsterOpts = { 'columns' : $scope.gridsterOpts.columns };
                        var factorIncreased = defaultNumberOfColsInGrid / existingNumberOfColsInGrid;
                        for (var component in $scope.reportLayout) {
                            if (component!="gridsterOpts") {
                                var sizeX = $scope.reportLayout[component][$scope.deviceType].size.x;
                                var positionX = $scope.reportLayout[component][$scope.deviceType].position[1];
                                $scope.reportLayout[component][$scope.deviceType].size.x = Math.floor(sizeX * factorIncreased);
                                $scope.reportLayout[component][$scope.deviceType].position[1] = Math.floor(positionX * factorIncreased)
                            }
                        }
                         $scope.page.body.reportLayout = $scope.reportLayout;
                    }
                    else {
	                    $scope.reportLayout = $scope.page.body.reportLayout;
	                    // resetting the component height when exporting
	                    if ($scope.exportType) {
	                		angular.forEach($scope.reportComponents, function(reportComponent, index) {
	                            if (reportComponent.collapsed) {
	                            	reportComponent.collapsed = false;
	                            	$scope.reportLayout[reportComponent.id][$scope.deviceType].size.y = reportComponent.originalSizeY;
	                            }
	                        });
	                    }
                    }
                }

            }
            /* setting gridster position and size */
        };
        $scope.allComponents = [];
        $scope.setAllComponentsIntialized = function(comp) {
        	window.csvFileDownloaded = false;
            $scope.allComponents.push(comp);
            //changing === to >= as the tab component can have more components embedded in it.
            if ($scope.allComponents.length >= $scope.reportComponents.length) {
                $scope.isAlarm = customReportSvc.getParameterByName('isAlarm');
                if ($scope.isAlarm) {
                    var componentName = customReportSvc.getParameterByName('componentName');
                    var component = customReportSvc.getComponent(componentName, $scope.reportComponents);
                    $scope.mergedParams = $.extend({}, $scope.requestParms, $scope.viewParams);
                    var filePrefix = customReportSvc.getParameterByName('exportedFileName') || $scope.customReport.report.customReportName;
                    var dataSet = customReportSvc.getDataSet(component.dataSet.dataSetName, $scope.page.dataSets.dataSet);
                    var testCriteriaId = customReportSvc.getParameterByName('testCriteriaId');

                    var dataSetParams = {
							reportMode : 'viewer',
							componentName : component.title && component.title.text || component.id,
							dsId : null,
							operation : "data",
							builderVersion : $scope.customReport.builderVersion,
							isPreview : false,
							limit : -1,
							offset : 0,
							exportType : 'csv',
							rawData : false,
							cacheId : $scope.cacheId
						};

                    var params = dataSetUtility.getParams(component,dataSet,$scope.page,dataSetParams,$scope.mergedParams,false,false);

                    if(component.type == "PIVOT_TABLE"){
	                    var options = {};
	                    options.pivotGroupBy = params.pivotGroupby.split(",");
	                    options.pivotOrderby = params.pivotOrderby;
	    				options.pivotRow = params.pivotRow;
	    				options.pivotColumn = params.pivotColumn;
	    				options.pivotCell = params.pivotCell;
	    				options.pivotRowTitle = params.pivotRowTitle;
                    }

                    /*
                     * These additional optionals are used for formatting data in alerts.
                     */
                    var moreOptions = {
                    		reportId: $scope.reportId,
                    		pageName: $scope.page.pageName,
                    		componentId: component.id,
                    		jsFilesList: exportConstants.customReportJSFileList,
                    		testCriteriaId : testCriteriaId,
                    		isAlarm: true
                    };

                    var hiddenColumns = customReportSvc.getParameterByName(component.id+'.hide');
                    var shownColumns = customReportSvc.getParameterByName(component.id+'.show');

                    if(hiddenColumns) {
                    	moreOptions.hiddenColumns = decodeURIComponent(hiddenColumns);
                    }
                    if(shownColumns) {
                    	moreOptions.shownColumns = decodeURIComponent(shownColumns);
                    }

                    let columns = component.columns.filter(function(column){
                    	if(typeof column.components !== undefined && column.components && column.components.length > 0){
							return false;
						}else{
							return true;
						}
                    });
                    moreOptions.columnArray = JSON.stringify({"columns":columns});
                    moreOptions.cacheId = $scope.cacheId;
                    var pushToParentWindow = function() {
                    	var parentAngular = $window.parent.angular;
						var iframeScope = parentAngular.element($window.frameElement).scope();
						iframeScope.$emit.apply(iframeScope, arguments);
						iframeScope.$apply();
                    }
                    var fields=[],groupby = [];
                    if(typeof params.fields === "string"){
                    	fields = params.fields.split(",");
                    }

                    if(typeof params.groupby === "string"){
                    	groupby = params.groupby.split(",");
                    }

                    reportService.getDataForDataSet(dataSet.dataSet.dataSetId, undefined, fields , groupby, -1, 0,
                    	params.where , params.orderby, undefined, params.having, params.parametersList, 'csv', filePrefix,
                        undefined, options, undefined, params.filter, moreOptions).then(function(data) {
                        if (testCriteriaId) {
							pushToParentWindow(testCriteriaId, data.data);
                        } else {
                        	console.log("Alert generation succeeeded with the file name : " + data.data);
                        	window.csvFileDownloaded = true;
                        }
                    }, function(error) {
                    	if (testCriteriaId) {
							pushToParentWindow(testCriteriaId, null);
                        } else {
                        	console.log("Could not generate alert data : " + error);
                        	window.csvFileDownloaded = true;
                        }
                    });
                } else if ($scope.exportType && $scope.exportType.toLowerCase() == 'csv') {
                    $scope.exportCsv(true);
                } else if ($scope.exportType === 'PRINT') {
                    $timeout(function() {
                        window.print();
                    }, 1000);
                }
            }
        };


        $scope.initPageActions = function() {
            if($scope.page.defaultUrlParams){
                    var defaultPageParams = customReportSvc.getUrlParams($scope.page.defaultUrlParams);
                    $.extend($scope.requestParms,defaultPageParams);
            }
            //For data cube reports we are not initializing the component in input initialization.
            //If inputs are there then We waiting for inputs to get initialized and then initializing the component with below code
            if (!$scope.page.inputs || $scope.page.inputs.length === 0
                || customReportSvc.getParameterByName('endpoint', '') === 'datacube' || $scope.isDataCubeDataSetExist()) {
                $scope.reportLayout = $scope.page.body.reportLayout || {};
                $scope.setReportComponents();
                $scope.setReportLayoutForAllComponents();
            }


            if (typeof $scope.page.body.customStyle === "undefined" || $scope.page.body.customStyle == null) {
                var customStyleCode = "";
            } else {
                var customStyleCode = $scope.page.body.customStyle;
            }
            customReportSvc.writeCustomStyleToDOM(customStyleCode);
            if (typeof $scope.page.body.customJsCode === "undefined" || $scope.page.body.customJsCode == null) {
                var jsCustomCode = "";
            } else {
                var jsCustomCode =  $scope.page.body.customJsCode;
            }
            if (($scope.dataSets && $scope.dataSets.length > 0 && $scope.dataSets[0].endpoint === 'DATACUBE') || customReportSvc.getParameterByName('endpoint', '') === 'datacube') {
                $scope.addMoreComponents();
            }else{
                         $scope.components.push({ label: "Histogram", sprite : "ico-horizontal-bar",
                         componentType: "CHART", type: "Histogram", defaultTitle: "Untitled Chart", category:
                         "chart" });
                $scope.showFormComponents=true;
            }
            customReportSvc.writeCustomScriptToDOM(jsCustomCode);

            $scope.buildViews();

        };

        $scope.isPost = function(dataSet){
            return ($scope.reportMode === "builder" || $scope.reportMode === "preview" || $scope.isPreview || dataSet.preview) ? true : false;
        }

        $scope.getDSId = function(dataSet){
            var isPost = $scope.isPost(dataSet) ? encodeURIComponent(dataSet.dataSet.dataSetName) : !dataSet.guid ? dataSet.dataSet.dataSetId : dataSet.guid;
            if(!$scope.isPost(dataSet)) {
                 return typeof $scope.customReport.guid !== "undefined" ? $scope.customReport.guid + ":" + dataSet.guid : dataSet.guid ;
            } else {
                return isPost;
            }
        }


        $scope.isDataSetIsIncluded = function(sourceDataSet,dataSet){

            if($.isEmptyObject(dataSet.GetOperation.rDataSetListInfo) || $.isEmptyObject(dataSet.GetOperation.rDataSetListInfo.rDataSets))
            {
                return false;
            }

            var rDataSetsList = dataSet.GetOperation.rDataSetListInfo.rDataSets;
            var  curRDataSet;
            for(var i=0;i<rDataSetsList.length;i++){
                curRDataSet = rDataSetsList[i];

                if(curRDataSet.dataSet.dataSetGuid == sourceDataSet.dataSet.dataSetGuid){
                    return true;
                }
            }

            return false;
        };

        $scope.getFieldsForDataSet = function(dataSet){
            $scope.dataSetParams = {
                    reportMode : $scope.reportMode,
                    componentName : "Preview Table",
                    dsId : $scope.getDSId(dataSet),
                    operation : "fields",
                    builderVersion : $scope.customReport.builderVersion,
                    isPreview : $scope.isPreview,
                    limit : 2,
                    offset : 0,
                    exportType : null,
                    exportedFileName : null,
                    rawData : dataSet && dataSet.endpoint == "HTTP" ? true : false,
                    cacheId: dataSet.preview ? customReportSvc.generateUUID() : $scope.cacheId
                };
                var dataUrl = dataSetUtility.getUrlForDataComponent($scope.component,
                        dataSet,
                        $scope.page,
                        $scope.dataSetParams,
                        {});
                var datasets = dataSetUtility.getDataSets(dataSet, $scope.page);
                //TODO Python3: changed  for Python3
				if(dataSet.endpoint == "R"|| dataSet.endpoint == "PYTHON3"){
                    for(var i=0;i<$scope.dataSets.length;i++ ){
                        if($scope.dataSets[i].dataSet.dataSetGuid != dataSet.dataSet.dataSetGuid){
                            if($scope.isDataSetIsIncluded($scope.dataSets[i],dataSet)){
                                datasets.dataSet.push($scope.dataSets[i]);
                            }
                        }
                    }
                }

                 if($scope.isPost(dataSet)){
                     return reportService.postDataForDataSetViaProxy(dataUrl, datasets);
                 }else{
                     return reportService.getDataForDataSetViaProxy(dataUrl);
                 }
        }

        $scope.initLMPageActions = function() {
            if ($scope.reportMode === 'builder') {
                var searchParams = $scope.requestParms["input.searchParams"];//read input.searchParams
                var dataSetName = "AdHoc Search on " + new Date().toDateString();
                var dataSet = {
                        allColumns : false,
                        dataSet : {
                            dataSetName : dataSetName ,
                            originalDataSetName : "",
                            dataSetGuid : customReportSvc.generateUUID()
                        },
                        endpoint : "MONITORING_POLICY",
                        fields : [],
                        GetOperation : {
                            sqlText : "",
                            parameters : [],
                            timeout : 5
                        },
                        queryPlan : {
                            offline : false,
                            versions : [ "ALL" ],
                            retentionDays : 1
                        }
                };

                dataSet.lmDataSet = {};

                if(searchParams && searchParams !== '')
                {
                    dataSet.lmDataSet.dataSetType = "QUERY";
                    dataSet.lmDataSet.adHocQueryUrl = searchParams;
                }
                else if($scope.requestParms["input.searchId"] && $scope.requestParms["input.searchId"] !== '')
                {
                    dataSet.lmDataSet.dataSetType = "SAVED_SEARCH";
                    var searchInfo = {
                            "searchId" : $scope.requestParms["input.searchId"],
                            "searchName" : $scope.requestParms["input.searchName"]?$scope.requestParms["input.searchName"]:""
                        };
                    dataSet.lmDataSet.searchInfo = searchInfo;
                }

                var adHocQueryTag = "LM_REPORT";
                if($scope.requestParms["input.lmAppType"] && $scope.requestParms["input.lmAppType"] === "2")
                {
                    adHocQueryTag = "SM_REPORT";
                }

                $scope.addSystemTag(adHocQueryTag);

//              var parametersList = customReportSvc.applyInputsToDataSet(dataSet,
//                      $scope.page.inputs);
//
//              var requestParams = {};
//              requestParams.isPivot = false;
//              requestParams.parameters = parametersList;
//
                customReportSvc.mask("content",true,"Loading fields ...");
//              reportService.putFieldsForDataSet(dataSet, requestParams)
                $scope.getFieldsForDataSet(dataSet).then(function(data) {
                            customReportSvc.processFields(data.data.columns,dataSet);

                            if(!$scope.page){
                                $scope.page = {};
                            }

                            if(!$scope.page.dataSets){
                                $scope.page.dataSets = []
                            }

                            if(!$scope.page.dataSets.dataSet){
                                $scope.page.dataSet = []
                            }

                            $scope.page.dataSets.dataSet.push(dataSet);
                            $scope.displayProperties.selectedPanel='dataset';

                            customReportSvc.unMask("content",true);
                        }, function(error) {
                            customReportSvc.unMask("content",true);
                            console.log(error);
                        });
            }

        };

        $scope.initDataSetAndBookmarkFilters = function(dataSet) {
            dataSet.fieldMapping = $scope.page.body.fieldMapping;
            $dataSource.getDataSource(dataSet.endpoint).init(dataSet, undefined, false, $scope.page.inputs);
            var reportComponents = [];
            angular.forEach($scope.customReport.pages, function(page, index) {
                reportComponents = reportComponents.concat(page.body.reportComponents);
            });
            $scope.initBookmark($scope.dataSets, reportComponents);
            customReportSvc.triggerCallback('redrawAllComponents');
        }

        $scope.initDataCubeDataset = function(dataSet) {
            if(dataSet.staticDataSetFields) {
               dataSet.fields.forEach(field => {
                    field.origType = qb.base.getFieldTypeForSolr(field.type);
                    field.fieldName = field.name;
                });
               $scope.initDataSetAndBookmarkFilters(dataSet);
            } else {
                 customReportSvc.mask($scope.maskEle,true,"Applying Inputs ...");
                 reportService.getFieldsForDCubeDataSet(dataSet.dCubeDataSet).then(function(response) {
                    if (response && response.data && !$.isEmptyObject(response.data.error)) {
                        customReportSvc.unMask($scope.maskEle,true);
                        if (response.data.error.errorCode === 10616 || response.data.error.errorCode === 10627) {
                            customReportSvc.errorToast(localMsg["E" + response.data.error.errorCode]);
                            return;
                        } else if (response.data.error.errorCode !== 1003) { // 1003 Something went wrong
                           customReportSvc.errorToast(response.data.error.errLogMessage);
                           return;
                        } else {
                           customReportSvc.errorToast(dataSet.dataSet.dataSetName + "does not exists.");
                           return;
                        }
                    }
                    dataSet.fields = customReportSvc.getFieldsForCustomReport(response.data.schemaFields);
                    $scope.initDataSetAndBookmarkFilters(dataSet);
                    customReportSvc.unMask($scope.maskEle,true);
                },function(error) {
                    customReportSvc.unMask($scope.maskEle,true);
                });

            }
        };

        $scope.initPageActionsAndBookmark = () => {
             if(!customReports.subAppName || (customReports.subAppName && customReports.subAppName !== 'forms')) {
                customReportSvc.unMask($scope.maskEle,true);
            }
            $scope.initPageActions();
            var reportComponents = [];
            angular.forEach($scope.customReport.pages, function(page, index) {
                reportComponents = reportComponents.concat(page.body.reportComponents);
            });
            $scope.initBookmark($scope.dataSets, reportComponents);
        }
        $scope.initDataCubePageActions = function() {
            const isStaticSchema = !$.isEmptyObject($scope.dataSets) && $scope.dataSets[0].endpoint === 'DATACUBE' && $scope.dataSets[0].staticDataSetFields;
             if(isStaticSchema) {
                angular.forEach($scope.dataSets, function(dataSet, index) {
                    dataSet.fieldMapping = $scope.page.body.fieldMapping;
                    dataSet.fields.forEach(field => {
                        field.origType = qb.base.getFieldTypeForSolr(field.type);
                        field.fieldName = field.name;
                    });
                    $dataSource.getDataSource(dataSet.endpoint).init(dataSet, undefined, false, $scope.page.inputs);
                    $scope.addMoreComponents();
                });
                $scope.initPageActionsAndBookmark();
             } else {
                    customReportSvc.mask($scope.maskEle,true,"Retrieving fields information...");
                    var dsId = parseInt(customReportSvc.getParameterByName('id', 0));//id - dsId
                    function callback() {
                        var promises = [];
                        var dCubeDataSetIndexArr = []; //this is maintain the index of data cube data sources, so that we can update the fields from the ajax response
                        angular.forEach($scope.dataSets, function(eachDS, index) {
                            if (eachDS.endpoint === 'DATACUBE') //only data cube needs to fetch the schema dynamically
                            {
                                promises.push(reportService.getFieldsForDCubeDataSet(eachDS.dCubeDataSet));
                                dCubeDataSetIndexArr.push(index);
                            }
                        });
                        $q.all(promises).then(function(response) {
                            angular.forEach(response, function(eachDSSchema, index) {
                                var dataSet = $scope.dataSets[dCubeDataSetIndexArr[index]];
                                    if (eachDSSchema && eachDSSchema.data && !$.isEmptyObject(eachDSSchema.data.error)) {
                                        if (eachDSSchema.data.error.errorCode === 10616 || eachDSSchema.data.error.errorCode === 10627) { // 1003 Something went wrong
                                            customReportSvc.errorToast(localMsg["E" + eachDSSchema.data.error.errorCode]);
                                        } else if (eachDSSchema.data.error.errorCode !== 1003) { // 1003 Something went wrong
                                           customReportSvc.errorToast(eachDSSchema.data.error.errLogMessage);
                                        } else {
                                           customReportSvc.errorToast(dataSet.dataSet.dataSetName + "does not exists.");
                                        }
                                    }
                                dataSet.fields = customReportSvc.getFieldsForCustomReport(eachDSSchema.data.schemaFields);
                                dataSet.fieldMapping = $scope.page.body.fieldMapping;
                                $dataSource.getDataSource(dataSet.endpoint).init(dataSet, undefined, false, $scope.page.inputs);
                            });


                           $scope.initPageActionsAndBookmark();
                        }, function(error) {
                            console.log(error);
                            customReportSvc.unMask($scope.maskEle,true);
                        });
                        $scope.addMoreComponents();
                    }
                    if (typeof $scope.dataSets[0] === 'undefined') {
                        if (dsId !== 0) {
                            customReportSvc.getDCubeDataSetInfo(dsId, function(dataSet) {
                                dataSet.dCubeDataSet.dsHandler['handlerId'] = parseInt(customReportSvc.getParameterByName('hid', 0)); //hid - handlerId
                                dataSet.dCubeDataSet.dsHandler['handlerName'] = customReportSvc.getParameterByName('hn', 0); //hn- handlerName
                                dataSet.dCubeDataSet.dsType = customReportSvc.getParameterByName('type', ''); //type - dsType
                                $scope.page.dataSets.dataSet[0] = dataSet;
                                callback();
                            });
                        } else {
                            callback();
                        }
                    } else if ($scope.dataSets[0].dCubeDataSet && $scope.dataSets[0].dCubeDataSet.dsId === "@dsId") {
                        //DO NOTHING; taken care in setAllInputsIntialized
                    } else {
                        callback();
                    }

             }
        };
        $scope.initBookmark = async function(dataSets, reportComponents) {
            if ($scope.reportMode == 'viewer') {
                var filters;
                //TODO: In SP15, check if getUrlParams can handle JSON/array of values in URL
                //and get rid of getDatacubeUrlParams
                if ($scope.isDataCubeDataSetExist()) {
                    filters = $scope.getDatacubeUrlParams(true);
                }
                else {
                    filters = customReportSvc.getUrlParams();
                }
                const otherReports = [];
                const additionalComponents = [];
                for(var filterParam in filters) {
                    if (typeof filters[filterParam] === 'string' && (filterParam.indexOf(".filter.") !== -1 || filterParam.indexOf(".select.") !== -1)) {
                        var param = filterParam.split(".");

                        let reportName;
                        if (filterParam.indexOf('hidden.filter.') === -1 && $scope.filterAcrossReports) {
                            try {
                                reportName = param[0];
                                param = param.splice(1);
                                const compId = param[0];

                                // get other reports that are present in filters
                                if ($scope.reportName !== reportName) {
                                    let report = otherReports.find(rp => rp.report.customReportName === reportName);
                                    if (_.isUndefined(report)) {
                                        await reportService.getCustomReport({ reportId: 0, includeDrafts: $scope.includeDrafts, reportName, version: 0, isPreview: $scope.isPreview, isTileReport:$scope.isTileBuilder  }).then(function(cr) {
                                            const tempReport = customReportSvc.deserializePagesAndSetCrObject(cr.data);
                                            otherReports.push(tempReport);
                                            report = tempReport;
                                        });
                                    }
                                    const dataSet = _.get(report, 'pages[0].dataSets.dataSet[0]');
                                    if (!_.isUndefined(dataSet) && _.isUndefined(dataSets.find(ds => ds.dataSet.dataSetName === dataSet.dataSet.dataSetName))) {
                                        $scope.dataSets.push(dataSet);
                                    }
                                    angular.forEach(report.pages, function(page, index) {
                                        const component = page.body.reportComponents.find(comp => comp.id === compId);
                                        if (!_.isUndefined(component)) {
                                            reportComponents.push(component);

                                            component.reportName = reportName;
                                            if (_.isEmpty(component.dataSet)) {
                                                component.dataSet = dataSet.dataSet;
                                            }
                                            additionalComponents.push(component);
                                        }
                                    });
                                }
                            } catch (e) {
                                //
                            }
                        }

                        var fieldPart;
                        var selectionType = "include";
                        if ((param || []).length === 3) {
                            fieldPart = param[2];
                        } else if ((param || []).length === 4) {
                            selectionType = param[2];
                            fieldPart = param[3];
                        }
                        var componentId = param[0];
                        var field = fieldPart.indexOf("-") == -1 ? fieldPart : fieldPart.split("-")[0];
                        if (field.indexOf("tuples_") != -1) {
                            filters[filterParam] = JSON.parse(filters[filterParam]);
                        }
                        let isSelectFilter = filterParam.indexOf(".select.") !== -1;
                        $scope.addBookmarkFilter(reportComponents, field, filters[filterParam], componentId, dataSets, selectionType,isSelectFilter);
                        //after adding to requestParms as array, we can remove the *-0,*-1 params or reportname-*
                        if(fieldPart.indexOf("-") !== -1 || ($scope.filterAcrossReports && filterParam.includes(reportName)))
                            delete $scope.requestParms[filterParam];
                    }
                }
                if ($scope.filterAcrossReports) {
                    // Add all current report components and additional components from other reports that have a filter applied
                    reportComponents.forEach(comp => {
                        if (_.isEmpty(comp.dataSet)) {
                            comp.dataSet = _.get($scope.customReport, 'pages[0].dataSets.dataSet[0].dataSet');
                        }
                    });
                    $scope.customReport.pages[0].body.hiddenComponents = additionalComponents;
                    $rootScope.$broadcast('initReportComponents', reportComponents, $scope.dataSets);
                }
            }
            var dsMap = {};
            angular.forEach(dataSets, function(eachDS) {
                dsMap[eachDS.dataSet.dataSetName] = eachDS;
            });
            angular.forEach($scope.page.body.filters['viewer'], function(filterObj, dataSetName) {
                if (!$.isEmptyObject(filterObj))
                {
                    var dataSet = $scope.getDataSet(dataSetName, 'name');
                    if (!dataSet || dataSet.endpoint !== "DATACUBE") {
                        return;
                    }
                    var options = {
                        dataSet : dataSet,
                        filters : filterObj,
                        isExact : true,     // TODO: Need to check this
                        filterType: "page_viewer"
                    };
                    $dataSource.getDataSource(options.dataSet.endpoint).applyFilters(options, function(isSuccess) {
                        if ($scope.filterAcrossReports) {
                            $timeout(function() {
                                customReportSvc.triggerCallback('redrawAllComponents');
                            }, 100);
                        }
                    });
                }
            });
            angular.forEach($scope.page.body.filters['builder'], function(filterObj, dataSetName) {
                if (!$.isEmptyObject(filterObj))
                {
                    var dataSet = $scope.getDataSet(dataSetName, 'name');
                    if (!dataSet || dataSet.endpoint !== "DATACUBE") {
                        return;
                    }
                    var options = {
                        dataSet : dataSet,
                        filters : filterObj,
                        isExact : true,
                        filterType: "page_override"
                    };
                    $dataSource.getDataSource(options.dataSet.endpoint).applyFilters(options, function(isSuccess) {});
                }
            });
        }

        $scope.initPageVariables = (callback) => {
            var promises = [];  var pageVariablesIdx = {};
            var baseUrl =  window.location.pathname.substring(0, window.location.pathname.indexOf("/",2));
            let inputs = {};
            const reportInputs = $scope.page.inputs;
            $scope.dataSets.forEach(dataSet => {
                if(!$.isEmptyObject(dataSet.dCubeDataSet)) {
                    const {dsId,dsHandler,...remaining} = dataSet.dCubeDataSet;
                    inputs = {...inputs,dsId,...dsHandler};
                    if(reportInputs && reportInputs.length) {
                        reportInputs.forEach(input => {
                            if(!Object.keys(inputs).includes(input.id))
                                inputs[input.id] = input.value; 
                        });
                    } 
                }
            });
            angular.forEach($scope.page.body.pageVariables, function(pageVariable, index) {
                const restAPI = cvFormatters.formatString(pageVariable.variableRestApi, {...inputs , ...$scope.requestParms});
                promises.push(reportService.getRequest(baseUrl + restAPI));
                window[pageVariable.variableName] = {};
                pageVariablesIdx[index]=pageVariable.variableName;
            });

            $q.all(promises).then(function(response) {
                if(!$.isEmptyObject(response))
                {
                    angular.forEach(response, function(eachResponse, index) {
                        window[pageVariablesIdx[index]] = eachResponse.data;
                    });
                }
                callback();
            }, function(error) {
                callback();
            });
        }
        $scope.$watch('page', function(page) {

        	function callback() {
                if ($scope.filterAcrossReports) {
                    // If filtering across reports is enabled, and for whatever reason, report name is missing in the params, remove that param as it won't work anyways.
                    Object.keys($scope.requestParamsOrig).forEach((param) => {
                        let indx = param.indexOf('.select.');
                        if(param.indexOf('hidden.filter.') === -1 && (indx !== -1 || (indx =  param.indexOf('.filter.')) !== -1)) {
                            if((param.slice(0,indx) || '').split('.').length !== 2) {
                                delete $scope.requestParamsOrig[param];
                                delete $scope.requestParms[param];
                            }
                        }
                    });
                    $scope.pushToUrl(Object.assign($scope.requestParamsOrig, $scope.requestParms));
                }
                if(!$scope.page.inputs || $scope.page.inputs.length === 0 || $scope.inputsInitialized)
                    $scope.initDataCubePageActions();
                else {
                      //Waiting for setAllInputsIntialized function to get executed so that
                     //input placeholders will get replaced with actual report values in case of default reports
                    $scope.inputsInitInterval = $interval(function() {
                        if($scope.inputsInitialized) {
                            if($scope.inputsInitInterval) {
                                $interval.cancel($scope.inputsInitInterval);
                                $scope.inputsInitInterval = undefined;
                            }
                            $scope.initDataCubePageActions();
                        }

                    },500);
                }
            }
        	 if (page && typeof page === "object") {
                $scope.resetComponents();
                if ($.isEmptyObject($scope.page.dataSets)) {
                    $scope.page.dataSets = {'dataSet' : []};
                }
                if ($scope.reportMode === 'viewer') {
                	if ($scope.page.body.disableMobileMode) {
                		$scope.gridsterOpts.mobileModeEnabled = false;
                	} else {
                		$scope.gridsterOpts.mobileModeEnabled = true;
                	}
                }
                $scope.dataSets = $scope.page.dataSets.dataSet;
                $scope.initPageLevelFilters();
                if (customReportSvc.getParameterByName('endpoint', '') === 'datacube' || $scope.isDataCubeDataSetExist()) {
                    if (customReports.appName === 'adminconsole') {
                        //In AC, when the report is loaded, URL doesn't have all the parameters(if queryString is not passed)
                        //so get them during page init again
                        $scope.getDatacubeUrlParams(true);
                    }
                    $scope.initPageVariables(callback);
                }
                else
                {
                    if(!customReports.subAppName || (customReports.subAppName && (customReports.subAppName !== 'forms' && customReports.subAppName !== 'health'))) {
                        customReportSvc.unMask($scope.maskEle,true);
                    }
                    $scope.initPageActions();
                    if($scope.requestParms["endpoint"] !="" && $scope.requestParms["endpoint"] === 'monitoring'){
                        $scope.initLMPageActions();
                    }
                }
            }
        });

        $scope.addMoreComponents = function() {
            var isAdditionalComponents = false;
            angular.forEach($scope.components, function(component) {
                if (component.type === 'TagCloud'){
                    isAdditionalComponents = true;
                }
            });
            if (!isAdditionalComponents) {
                $scope.components = $scope.components.concat($scope.additionalComponents);
            }
            $scope.showFormComponents=true;
        };

        $scope.startAutoRefreshTimer = function(isReset) {
            if (!$scope.page.body.autoRefreshTime){
                $scope.page.body.autoRefreshTime = 10;
            }
            if ($scope.reportMode != 'builder') {
                if (!$scope.autoRefreshInterval && $scope.page.body.autoRefresh) {
                    $scope.autoRefreshInterval = setInterval(function() {
                        $scope.reloadAllComponents(true, true);
                                    }, $scope.page.body.autoRefreshTime*1000);
                } else if (!$scope.page.body.autoRefresh){
                    if ($scope.autoRefreshInterval){
                        clearInterval($scope.autoRefreshInterval);
                    }
                    $scope.autoRefreshInterval = 0;
                }
                if (isReset) {
                    clearInterval($scope.autoRefreshInterval);
                    setTimeout(function(){
                        $scope.autoRefreshInterval = setInterval(function() {
                            $scope.reloadAllComponents(true, true);
                                }, $scope.page.body.autoRefreshTime*1000);
                    },100);
                }
            }
        };

        $scope.$on('$destroy', () => {
            if($scope.autoRefreshInterval)
                clearInterval($scope.autoRefreshInterval);
        });

        $scope.toggleTimerOptionsVisibility = function() {
            $scope.showTimerOptions = ! $scope.showTimerOptions;
        }

        angular.element("html").on("click", function(e) {
            let target = angular.element(e.target);
            //hide the autorefresh timer option for outside click
			if (target.is(":visible") && !(target.closest("#autoRefreshOptions").length)) {
                $scope.showTimerOptions = false;
                const phase = $rootScope.$$phase;
                if(!(phase == '$apply' || phase == '$digest'))
                   $scope.$apply();
			}
        });

        $scope.getDataSet = function(parameter, type) {
            for (var i = 0; i < $scope.dataSets.length; i++) {
                var dataSet = $scope.dataSets[i];
                if (type === 'name' && dataSet.dataSet.dataSetName === parameter) {
                    return dataSet;
                } else if (type === 'id' && dataSet.dataSet.dataSetId === parameter) {
                    return dataSet;
                } else if (type === 'guid' && dataSet.dataSet.dataSetGuid === parameter) {
                    return dataSet;
                }
            }
        }

        $scope.getDataSetById = function(dataSetId) {
            for (var i = 0; i < $scope.dataSets.length; i++) {
                var dataSet = $scope.dataSets[i];
                if (dataSet.dCubeDataSet.dsId == dataSetId) {
                    return dataSet;
                }
            }
            return undefined;
        }

        $scope.dataSetUpdated;
        $scope.updateDataSets = function(dataSet, index) {
            if (index === -1) {
                $scope.dataSets.push(dataSet);
            } else {
                $scope.dataSets[index] = dataSet;
            }
            $scope.dataSetUpdated = dataSet;
        }

        $scope.deleteDataSetFromPage = function(dataSet) {
                if (dataSet) {
                    $scope.dataSets.splice($scope.dataSets.indexOf(dataSet), 1);
                    $scope.dataSetDeleted = dataSet.dataSet.dataSetName;
                }
            }
            /** List of control panel items and their sprite classes */
            // FIXME: Localize
        $scope.components = [{
                label: "Horizontal Bar",
                sprite : "ico-horizontal-bar",
                componentType: "CHART",
                type: "HorizontalBar",
                defaultTitle: "Untitled Chart",
                category: "chart"
            }, {
                label: "Vertical Bar",
                sprite : "ico-vertical-bar",
                componentType: "CHART",
                type: "VerticalBar",
                xAxisTitle: { "text": '' },
                defaultTitle: "Untitled Chart",
                category: "chart"
            }, {
                label: "Pie Chart",
                sprite: "ico-pie-chart",
                componentType: "CHART",
                type: "Pie",
                defaultTitle: "Untitled Chart",
                category: "chart"
            }, {
                label: "Donut",
                sprite: "ico-donut",
                componentType:"CHART",
                type:"Donut",
                defaultTitle: "Untitled Chart",
                category: "chart"
            }, {
                label: "Line Chart",
                sprite: "ico-line-chart",
                componentType: "CHART",
                type: "Line",
                defaultTitle: "Untitled Chart",
                category: "chart"
            }, {
                label: "Timeline Chart",
                sprite: "ico-time-line",
                componentType: "CHART",
                type: "TimeSeries",
                defaultTitle: "Untitled Chart",
                category: "chart"
            }, {
                label: "Data Table",
                sprite: "ico-data-table",
                componentType: "TABLE",
                type: "table",
                defaultTitle: "Untitled Table",
                category: "table"
            }, {
                label: "Pivot Table",
                sprite: "ico-pivot-table",
                componentType: "PIVOT_TABLE",
                type: "table",
                defaultTitle: "Untitled Pivot Table",
                category: "table"
            },{
                label: "Html",
                sprite: "ico-file-code",
                componentType: "CUSTOM",
                type: "HTML",
                defaultTitle: "Untitled Custom",
                category: "other"
            },
            {
                label: "Map",
                sprite: "ico-map-component",
                componentType: "MAP_v2",
                type: "MAP_v2",
                defaultTitle: "Untitled Map",
                category: "other"
            },
            {
                label: "Search Bar",
                sprite: "ico-magnifier",
                componentType: "SEARCH_BAR",
                type: "SearchBar",
                defaultTitle: "Untitled Search Bar",
                category: "form"
            },
            {
                label: "Date Range",
                sprite: "ico-calendar-insert",
                componentType: "DATE_RANGE",
                type: "DateRange",
                defaultTitle: "Untitled Date Range",
                category: "form"
            },
            {
                label: "Card Component",
                sprite: "ico-news",
                componentType: "HITS",
                type: "Hits",
                defaultTitle: "",
                category: "form"
            },{
                label: "Heat Map",
                sprite: "ico-heat-map",
                componentType: "HEAT_MAP",
                type: "heatmap",
                defaultTitle: "Untitled Heatmap",
                category: "other"
            },{
                label: "Scatter Plot",
                sprite: "ico-scatter_plot_icon",
                componentType: "SCATTER",
                type: "scatter",
                defaultTitle: "",
                category: "chart"
            },{
                label: "Panel",
                sprite: "ico-hdr_cmpnent_icon",
                componentType: "PANEL",
                type: "panel",
                defaultTitle: "Untitled Panel",
                category: "other"
            },{
                label: "Filter Panel",
                sprite: "ico-funnel",
                componentType: "FACET",
                type: "FACET",
                defaultTitle: "Untitled Filter Panel",
                category: "form"
            },/*
				 * { label: "Iframe", sprite: "ico-frame-icon", componentType: "IFRAME", type: "IFRAME",
				 * defaultTitle: "Untitled FRAME Panel", category: "other" } ,
				 */{
                label: "Chart Tile",
                sprite: "ico-graph-icon",
                componentType: "TILE_TEMPLATE",
                type: "chartTile",
                defaultTitle: "Chart Tile",
                category: "tileTemplate"
            },{
                label: "Text Tile",
                sprite: "ico-text-format-icon",
                componentType: "TILE_TEMPLATE",
                type: "textTile",
                defaultTitle: "Text Tile",
                category: "tileTemplate"
            },{
                label: "Tabs",
                sprite: "ico-tabbedpane-icon",
                componentType: "TABS",
                type: "TABS",
                defaultTitle: "Untitled Tabs Panel",
                category: "other"
            },{
                label: "Topology",
                sprite: "ico-line-chart",
                componentType: "TOPOLOGY",
                type: "TOPOLOGY",
                defaultTitle: "Untitled Topology",
                category: "chart"
            }, {
                label: "Status Chart",
                sprite: "ico-status-chart",
                componentType: "CHART",
                type: "TileStatusChart",
                defaultTitle: "Untitled Chart",
                category: "tileMultiChart"
            },
            {
                label: "Tree Map",
                sprite: "ico-heat-map",
                componentType: "CHART",
                type: "treemap",
                defaultTitle: "Untitled Tree map",
                category: "chart"
           }
        //    {
        //         label: "Legend",
        //         sprite: "ico-file-code",
        //         componentType: "LEGEND",
        //         type: "Legend",
        //         category: "other",
        //     }
            //,{
           //   label: "Panel Header",
            //    sprite: "ico-hdr_cmpnent_icon",
             //   componentType: "PANEL_HEADER",
              //  type: "panelheader",
               // defaultTitle: "Untitled Panel Header",
                //category: "other"
            //}

            //                    , {
            //                        label:  "Text Item",
            //                        sprite: "reports-builder-text",
            //                        componentType: "TEXT",
            //                        type:   "text"
            //                    }
        ];
        if ($scope.cv && !$.isEmptyObject($scope.cv.additionalSettings) && $scope.cv.additionalSettings.Console && $scope.cv.additionalSettings.Console.enableNewTable) {
            var newTableComp = {
                label: "New Data Table",
                sprite: "ico-data-table",
                componentType: "NEW_TABLE",
                type: "table",
                defaultTitle: "Untitled Table",
                category: "table"
            }
            $scope.components.push(newTableComp);
        }

        var rGGPlotComponent = {
                label: "R-Plot",
                sprite: "ico-heat-map",
                componentType: "R-GGPlot",
                type: "R-GGPlot",
                defaultTitle: "",
                        category: "other"
            }

        $scope.components.push(rGGPlotComponent);

        $scope.additionalComponents = [{
                label: "Word Cloud",
                sprite: "ico-word-cloud",
                componentType: "TAG_CLOUD",
                type: "TagCloud",
                defaultTitle: "Untitled Word Cloud",
                category: "other"
            },{
             label: "Data Grid",
             sprite: "ico-data-grid",
             componentType: "KENDO_GRID",
             type: "KENDO_GRID",
             defaultTitle: "Untitled data grid",
             category: "other"
        },{//Removed Filter Panel to have it shown to all types of dataset
            label: "Tree Grid",
            sprite: "ico-tree-grid-icon",
            componentType: "KENDO_TREEGRID",//why two types?
            type: "KENDO_TREEGRID",
            defaultTitle: "Untitled Tree grid",
            category: "other"
        }];
        $scope.calculateItemPosition = function(event) {
            // calculate row and column to place new item
            // get position of dragged item
            if(event){
                var srcTop = event.originalEvent.pageY - $(".gridster").offset().top;
                var srcLeft = event.originalEvent.pageX - $(".gridster").offset().left;
            }else{
                var srcTop = $(".gridster").offset().top;
                var srcLeft = $(".gridster").offset().left;
            }

            // get row height and col width of gridster item
            var rowHeight = $scope.gridsterOpts.rowHeight;
            var colWidth = $(".gridster").width()/$scope.gridsterOpts.columns;

            // calculate rows and cols
            var row = srcTop < rowHeight ? 0 : Math.floor(srcTop/rowHeight);
            var column = srcLeft < colWidth ? 0 : Math.floor(srcLeft/colWidth);
            return [row,column];
        }

        $scope.dropped = function(dragEl, dropEl, event) {
            // Because the handler jumps "outside" of angular, updates must be
            // made in an $applied scope
            var dest = document.getElementById(dropEl);
            var src = document.getElementById(dragEl);

            var drag = angular.element(src);
            var type = drag.data("type");
            var compType = drag.data("componenttype");
            var compDefaultTitle = drag.data("defaulttitle");
            var comp = {};
            comp.type = compType;
            comp.dataSet = {};
            comp.title = { text: "" };

            if (compType == "CHART") {
                comp.id = "Chart_" + (new Date()).getTime();
                comp.chartType = type;
                if (type == 'TimeSeries') {
                    comp.isDateTime = true;
                } else {
                    comp.isDateTime = false;
                }
                customReportSvc.setDefaultChartProperties(comp);
                if(type === 'Histogram'){
                    comp.binType = 'FIXEDBINCOUNT';
                    comp.binValues=[{value:"5",unit:""}];
                }
            } else if (compType == "TABLE") {
                comp.id = "Table" + (new Date()).getTime();
                comp.pageSize = 20;
                comp.columns = [];
                comp.allColumns = false;
                customReportSvc.setDefaultTableProperties(comp);
            } else if (compType == "NEW_TABLE") {
                comp.id = "NewTable" + (new Date()).getTime();
                comp.pageSize = 20;
                comp.columns = [];
                comp.allColumns = true;
                comp.showFilterByDefault = false;
                comp.group = [];
            } else if (compType == "PIVOT_TABLE") {
                comp.id = "PivotTable" + (new Date()).getTime();
                comp.pageSize = 20;
                comp.columns = [];
                comp.allColumns = true;
                customReportSvc.setDefaultTableProperties(comp);
            } else if(compType == "TAG_CLOUD") {
                comp.id = "TagCloud" + (new Date()).getTime();
            } else if(compType == 'SEARCH_BAR') {
                comp.id = "SearchBar" + (new Date()).getTime();
            } else if(compType == 'DATE_RANGE') {
                comp.id = "DateRange" + (new Date()).getTime();
            } else if(compType == 'HITS') {
                comp.id = "Hits" + (new Date()).getTime();
            }
            else if(compType == 'R-GGPlot'){
                comp.id = "RGGPlot" + (new Date()).getTime();
                comp.rDataSetList = {
                    rDataSets   : [],
                    rScript     : ""
                };
            }else if(compType == "HEAT_MAP") {
                comp.id = "HEATMAP_" + (new Date()).getTime();
                comp.chartType = type;
                customReportSvc.setDefaultChartProperties(comp);
            } else if(compType == "SCATTER") {
                comp.id = "SCATTER_" + (new Date()).getTime();
                comp.chartType = type;
                customReportSvc.setDefaultChartProperties(comp);
            } else if (compType === "CUSTOM") {
                comp.id = "CustomHtml" + (new Date()).getTime();
                comp.columns = [];
            }else if (compType === "LEGEND") {
                comp.id = "Legend" + (new Date()).getTime();
                comp.columns = [];
            } else if (compType === "MAP" || compType === "MAP_v2") {
                comp.id = "Map" + (new Date()).getTime();
                comp.columns = [];
            }else if (compType === "KENDO_GRID") {
                comp.id = "DataGrid_" + (new Date()).getTime();
                comp.pageSize = 20;
                comp.columns = [];
                comp.allColumns = true;
            } else if(compType == 'FACET') {
                comp.id = "Facet" + (new Date()).getTime();
                comp.allColumns = false;
            } else if (compType === "KENDO_TREEGRID") {
                comp.id = "TreeGrid_" + (new Date()).getTime();
                comp.columns = [];
            } else if (compType === "PANEL_HEADER"){
                comp.id = "PanelHeader" + (new Date()).getTime();
                comp.header = false;
                comp.panelHeaderComponents= [];
            } else if (compType === "PANEL"){
                comp.id = "PanelComponent" + (new Date()).getTime();
                comp.panelComponents= [];
            } else if (compType === "IFRAME"){
                comp.id = "Frame" + (new Date()).getTime();
            } else if (compType === "TABS"){
                comp.id = "Tabs" + (new Date()).getTime();
                comp.tabs=[{
                    id : "Tab" + (new Date()).getTime(),
                    title : {text:'New Tab'},
                    component:{
                        type :"PANEL",
                        id : "PanelComponent" + (new Date()).getTime(),
                        panelComponents:[]
                    }
                }];
            } else if (compType === 'TILE_TEMPLATE') {
                comp = tileBuilderSvc.getTileComponent(type);
                if (type == "chartTile") {
                    $scope.tileProperties.height = "FULL";
                } else {
                    $scope.tileProperties.height = "HALF";
                }
            } else if (compType === 'TOPOLOGY') {
                comp.id = "Topology" + (new Date()).getTime();
                comp.chartType = "topology";
                comp.data = {
                    edges: [],
                    nodes: []
                };
            } else {
                alert('Invalid Component type');
                return
            }

            if ($scope.isTileBuilder) {
                $scope.reportLayout[comp.id] =  tileBuilderSvc.getBodyLayout();
            } else  if ($scope.isDcubeEnabledInCustomReports) {
                /* setting default gridster size and position attributes */
                var gridLayoutItemAttrs = {};
                var position=$scope.calculateItemPosition(event);
                $scope.page.body.reportLayout = $scope.page.body.reportLayout || [];
                gridLayoutItemAttrs = {
                    mobile: {
                        size: {
                            x: 4,
                            y: $scope.defaultNumberOfRows
                        },
                        position: position
                    },
                    tablet: {
                        size: {
                            x: 4,
                            y: $scope.defaultNumberOfRows
                        },
                        position: position
                    },
                    desktop: {
                        size: {
                            x: 4,
                            y: $scope.defaultNumberOfRows
                        },
                        position: position
                    }
                };
                if ($.inArray(comp.type, ['TABLE', 'PIVOT_TABLE', 'KENDO_GRID', 'KENDO_TREEGRID', 'PANEL', 'MAP', 'MAP_v2', 'TABS', 'TOPOLOGY', 'NEW_TABLE']) > -1) {
                // if (comp.type === 'TABLE' || comp.type === 'PIVOT_TABLE' || comp.type === 'KENDO_GRID' || comp.type === 'KENDO_TREEGRID'|| comp.type === 'PANEL' || comp.type === 'MAP' || comp.type === 'TABS' || comp.type === 'TOPOLOGY') {
                    gridLayoutItemAttrs[$scope.deviceType].size.x = $scope.gridsterOpts.columns;
                } else if (comp.type === 'SEARCH_BAR') {
                    gridLayoutItemAttrs[$scope.deviceType].size.y = 2;
                } else if (comp.type === 'DATE_RANGE') {
                    gridLayoutItemAttrs[$scope.deviceType].size.x = 4;
                    gridLayoutItemAttrs[$scope.deviceType].size.y = 3;
                } else if (comp.type === 'HITS') {
                    gridLayoutItemAttrs[$scope.deviceType].size.x = 3;
                    gridLayoutItemAttrs[$scope.deviceType].size.y = 3;
                } else if (comp.type === 'HEAT_MAP') {
                    gridLayoutItemAttrs[$scope.deviceType].size.x = $scope.gridsterOpts.columns;
                } else if (comp.type === 'SCATTER') {
                    gridLayoutItemAttrs[$scope.deviceType].size.x = $scope.gridsterOpts.columns;
                } else if (comp.type === 'CHART') {
                    if (comp.chartType === 'Line' || comp.chartType === 'TimeSeries' || comp.chartType === 'treemap'){gridLayoutItemAttrs[$scope.deviceType].size.x = $scope.gridsterOpts.columns;}
                } else if (comp.type === 'LEGEND') {
                    gridLayoutItemAttrs[$scope.deviceType].size.x = 6;
                    gridLayoutItemAttrs[$scope.deviceType].size.y = 3;
                }

				if($scope.page.body.reportComponents.length === 0 && !$scope.reportLayout){
                	$scope.reportLayout = {}; // when there are required inputs , unable to drop the components.
                }

                // push component position details to reportLayout array
                $scope.reportLayout[comp.id] = gridLayoutItemAttrs;
                /** ********************** done ************************ */
            }
            $scope.reportComponents.push(comp);
            $scope.setActiveComponent(comp);
            $scope.$apply();
        };


        $scope.validateHeaderComponentExpression = function(selectedComponent, isEnable) {
            var retVal = false;
            var validateObject = isEnable ? selectedComponent.enable
                    : selectedComponent.visible;
            if (validateObject === "always") {
                retVal = true;
            } else {
                var args = {};
                args["expression"] = isEnable ? selectedComponent.enableExpression
                        : selectedComponent.visibleExpression
//              args["cellData"] = cellData
//              args["row"] = $scope.tableParams.data[rowIndexVal];
//              args["rowIndex"] = rowIndexVal;
                retVal = rpt.evalExpression(args);
            }
            return retVal;
        }


        $scope.evalHeaderComponentExpression = function(itemExpression, isURL) {
            if (itemExpression) {
                var args = {};
                if (typeof itemExpression === "string"
                        && itemExpression.substring(0, 2) !== ":=") {
                    if (!isURL) {
                        itemExpression = ":=" + itemExpression;
                    }
                }
                args["expression"] = itemExpression;
//              args["cellData"] = cellData
//
//              args["row"] = $scope.tableParams.data[rowIndexVal];
//              args["rowIndex"] = rowIndexVal;
                var value = rpt.evalExpression(args);
                return value;
            }

        }

        // handle page level filters and global filters in case of data set edit
        $scope.$watch('dataSetUpdated', function(dataSet) {
            $scope.modifyFiltersOnDataSetModify(dataSet, 'edit');
        });

        $scope.modifyFiltersOnDataSetModify = function(dataSet, operation) {
            var deletedDataSetName = operation === 'edit' ? undefined : dataSet;
            if (dataSet && $scope.page && $scope.page.body && $scope.page.body.filters) {
                var pageFilters = $scope.page.body.filters['viewer'];
                var globalFilters = $scope.page.body.filters['builder'];
                // page level filters data set edit change
                $scope.modifyFilters(pageFilters, dataSet, deletedDataSetName, operation);
                // global filters data set edit changes
                $scope.modifyFilters(globalFilters, dataSet, deletedDataSetName, operation);
            }
        };
        $scope.modifyFilters = function(filters, dataSet, deletedDataSetName, operation) {
            angular.forEach(filters, function(filterObj, dataSetName) {
                    //check for the name of the dataset. Data Set name might have changed, so check with old dataset name.
                if ((!deletedDataSetName && dataSet.dataSet.originalDataSetName === dataSetName)
                        || (deletedDataSetName === dataSetName)) {
                        // rename previous dataset to newly edited dataset
                    if (operation === 'edit') {
                        filters[dataSet.dataSet.dataSetName] = customReportSvc.getDeepCopy(filters[dataSetName]);
                    }
                    delete filters[dataSetName];
                    }
                });
        }
    }]);

    app.controller('ComponentsCtrl', ['$scope', 'reportService', function($scope, reportService) {
        $scope.dashboards = [];
    }]);

    app.controller('ComponentCtrl', ['$scope', 'customReportSvc', 'reportService', '$uibModal', '$timeout', "dataSource", "$rootScope", "$sanitize",
    	function($scope, customReportSvc, reportService, $uibModal, $timeout, $dataSource, $rootScope,$sanitize) {
        $scope.panelComponentIndex;
        $scope.tableMenuVisible = false;
        $scope.url="";
        $scope.component.hideComponent = false;
        $scope.component.blankComponent = false;
        if($scope.component.title && $scope.component.title.text){
        $scope.componentTitle = rpt.evalExpression({expression:$scope.component.title.text});
        }
        //Function to apply custom visibility of compononts if specified
        $scope.applyConditionalComponentVisibility = function() {
            if ($scope.reportMode != 'viewer' || !$scope.component.visible || $scope.component.visible.type != 'custom') {
                return;
            }
            var args = {
                expression: $scope.component.visible.expression,
                System: $scope.cv
            };
            $scope.component.hideComponent = !rpt.evalExpression(args); // should return true or false; toggle the state as we are doing opposite
            // Remove the component only if it is having full width, otherwise a blank component should be shown.
            if($scope.reportLayout[$scope.component.id][$scope.deviceType].size.x != $scope.reportLayout.gridsterOpts.columns){
                if($scope.component.hideComponent){
                    $scope.component.hideComponent = false;
                    $scope.component.blankComponent = true;
                }else{
                    //Reverting back to false, if the component is not to be hidden
                    if($scope.component.blankComponent){
                        $scope.component.blankComponent = false;
                    }
                }
            }
        };



        if($scope.reportMode === 'viewer' &&  $scope.cv && $scope.component && $scope.component.visible && $scope.component.visible.type && $scope.component.visible.type !== "all" ){
            if(!$scope.cv.isAdminOnCommcellLevel){
                if($scope.component.visible.type === "admin"){
                    $scope.component.hideComponent = true;
                }
                if($scope.component.visible.type === "tenantAdmin" && !$scope.cv.isTenantAdmin){
                    $scope.component.hideComponent = true;
                }
            }
        	$scope.applyConditionalComponentVisibility();
        }

        $scope.initComponentLevelFilters = function() {
            if (!$.isEmptyObject($scope.component)
                && $.isEmptyObject($scope.component.filters)) {
                $scope.component.filters = { 'builder' : {}, 'viewer' : {} };
                $scope.componentFilters = $scope.component.filters;
            };
        };


        $scope.addParameter = function(key,value,doNotUpdate){
        	var doNotUpdateUrl = (doNotUpdate || $scope.component.shared) ? true : false;
            $scope.addParameterToUrl(key, value,false,false,doNotUpdateUrl);
                    }
        $scope.applyInputsToCustomGroups = function(dimensionDataField) {
            if (!dimensionDataField) {
                return undefined;
            }
            let urlParams = customReportSvc.getUrlParams();
            $scope.customInputs = customReportSvc.getCustomInputs(urlParams,$scope.page.inputs);
            // get deep copy before replacing custom inputs
            var dimensionDataField = customReportSvc.getDeepCopy(dimensionDataField);

            // apply facet filter
            angular.forEach(dimensionDataField, function(dimension, index) {
                angular.forEach(dimension.groups || [], function(group, groupIndex) {
                    if (group.groupValues) {
                            group.groupValues = customReportSvc.processInputsFromGroupValues(group.groupValues, $scope.customInputs);
                        if (group.groupValues.substring(0,1) === "=") {
                            group.groupValues = eval(group.groupValues.substring(1));
                        }
                    }
                });
            });
            return dimensionDataField;
        };
        $scope.initComponentLevelFilters();

        if($scope.isDashboard){
            $scope.component.hideHeader = true;
            if ($.inArray($scope.component.type, ['TABLE', 'PIVOT_TABLE', 'KENDO_GRID', 'NEW_TABLE']) > -1) {
                $scope.component.pageSize = 10;
            }
        }

        if (!$scope.dataSet && $scope.component.dataSet && $scope.component.dataSet.dataSetName) {
            if($scope.component.shared){
                reportService.getDataSet($scope.component.dataSet.dataSetName,true).then(function(data){
                    $scope.dataSet = data.data;
                    $scope.dataSetId = $scope.dataSet.dataSet.dataSetId;
                });
            }else{
                $scope.dataSet = $scope.getDataSet($scope.component.dataSet.dataSetName, 'name');
                $scope.dataSetId = $scope.dataSet.dataSet.dataSetId;
            }
        }

        $scope.tempComponent = {};  // to store runtime variables (to be changed in child controllers) which are not going to be saved
        $scope.tempComponent.tooManyRecordsReturned = false;
        // when dataset modal is closed then the property is updated. We will need to update the dataset in local scope.
        $scope.$watch('dataSetDeleted', function(dataSetName) {
            if (dataSetName && dataSetName === $scope.component.dataSet.dataSetName) {
                $scope.deleteComponentByName($scope.component.id);
            } else if ($.isEmptyObject($scope.component.dataSet)) {    // filter panel is not associated with any dataset, so deleting individual entries
                if ($scope.component.filterDataField && $scope.component.filterDataField['viewer']) {
                    angular.forEach($scope.component.filterDataField['viewer'], function(dataSetObj, dataSetName) {
                        if (dataSetName === $scope.dataSetDeleted) {
                            delete $scope.component.filterDataField['viewer'][dataSetName];
                            return;
                        }
                    });
                }
            }
            // clear all the global filters in case of data set delete
            // component level filters will be removed with the component itself
            if(dataSetName){
                $scope.modifyFiltersOnDataSetModify(dataSetName, 'delete');
            }
        });


        $scope.$watch('dataSetUpdated', function(dataSet) {
            if($scope.component.id !== "PreviewTable" && $scope.component.type !== 'FACET') {
                if (dataSet && dataSet.dataSet.originalDataSetName === $scope.component.dataSet.dataSetName) {
                    $scope.dataSet = dataSet;
                    $scope.component.dataSet.dataSetName = dataSet.dataSet.dataSetName;
                    if ($scope.child && typeof $scope.child.updateComponentFields === 'function' ) {
                        $scope.child.updateComponentFields(dataSet);
                    }
                    $scope.updateDataSetForComponentFilters(dataSet);
                }
            }
            if (dataSet) {
                $scope.$broadcast('updateComponentFields' , dataSet);
				if ($scope.child && typeof $scope.child.updateComponentFields !== "undefined" && typeof $scope.child.updateComponentFields === "function"){
                	$scope.child.updateComponentFields(dataSet);
                }

            }
        });
        $scope.updateDataSetForComponentFilters = function(dataSet) {
            if ($scope.component.filters) {
                var filters = $scope.component.filters['builder'];
                angular.forEach(filters, function(filterObj, dataSetName) {
                    //check for the name of the dataset. Data Set name might have changed, so check with old dataset name.
                    if (dataSet.dataSet.originalDataSetName === dataSetName) {
                        // rename previous dataset to newly edited dataset
                        filters[dataSet.dataSet.dataSetName] = customReportSvc.getDeepCopy(filters[dataSetName]);
                        delete filters[dataSetName];
                    }
                });
            }
        }

        if ($scope.$index === 0) {
            $scope.setActiveComponent($scope.component);
        }

        $scope.child = {}; //will hold the child scope so that we can call the reload component method.
        $scope.setChildScope = function(childScope){
            $scope.child =  childScope;
        }

        $scope.pageSizes = [5, 10, 20, 50, 100, 200, 500];
        $scope.associateDataSetToComponent = function(dataSetEntity) {
            $scope.dataSet = $scope.getDataSet(dataSetEntity.dataSetName, 'name');
            $scope.component.dataSet = dataSetEntity;
            // customReportSvc.triggerCallback('comppnentDataSetUpdated', $scope.dataSet);
            $rootScope.$broadcast('comppnentDataSetUpdated', $scope.dataSet);
        }
        $scope.associateDataSetToTopology = function(dataSetEntity, nodes) {
            var elem;
            if (nodes) {
                elem = $scope.component.topologyProps.nodes;
            } else {
                elem = $scope.component.topologyProps.edges;
            }
            // elem.dataSet = $scope.getDataSet(dataSetEntity.dataSetName, 'name');
            elem.dataSet = dataSetEntity;
            $rootScope.$broadcast('comppnentDataSetUpdated', elem.dataSet);
        }
        $scope.masked = false;


        $scope.reloadComponent = function(refreshCache) {
            $scope.child.reloadComponent(refreshCache);
        }

        ///////////////////////////////////////////////////////////////////////////
        // Starting block for Event listeners for filter component getting used in properties panel //
        ///////////////////////////////////////////////////////////////////////////
        $scope.$on('loadingButton', function(e, component) {
            if (!e.defaultPrevented) {
                e.preventDefault();
                $scope.loadingButton(component);
            }
        });

        $scope.$on('addFilters', function(e, options) {
            if (!e.defaultPrevented) {
                e.preventDefault();
                $timeout(function() {
                    $scope.addFilters(options.filterParam, options.filterVal, options.component, options.isMultiple, options.isExact,
                                      options.selectedGroups, options.isAdvanced, options.filterMode, options.selectionType,
                                      options.isGlobal, options.dataSet, undefined, undefined, options.isDoFacetCall,undefined,options.isShowRadioButtons);
                });
            }
        });

        $scope.$on('clearComponentFilters', function(e, options) {
            if (!e.defaultPrevented) {
                e.preventDefault();
                $timeout(function() {
                    $scope.clearComponentFilters(options.filterMode, options.dimension, options.component, options.dataSet, options.type,
                                                 options.dataSet.endpoint !== "DATACUBE"?options.dimension.column:undefined, options.noRedraw,
                                                 options.isDelete, options.isClearAllFilters,options.selectionType);
                });
            }
        });

        $scope.$on("refreshTile", function(evt,data){
            if (!$scope.eventProcessed && data.tileId == $scope.reportId) {
                $scope.eventProcessed = true;
                 reportService.getCustomReport($scope.params).then(function(cr) {

                     customReportSvc.mask($scope.maskEle,true,"Loading report ...");
                     $scope.loadCustomReport(cr.data, "");
                     customReportSvc.unMask($scope.maskEle,true);
                 }, function(error) {
                     customReportSvc.unMask($scope.maskEle,true);
                     if (error != undefined && error != null && error.data) {
                         if (error.data.indexOf("PERMISSION_DENIED") != -1) {
                             customReportSvc.errorToast("You do not have permission to access this report.");
                             return;
                         }
                     }
                     customReportSvc.errorToast($.trim("Report does not exist or you do not have permissions to view it."), 30000);
                 });
            }
        });
        ///////////////////////////////////////////////////////////////////////////
        // Ending block for Event listeners for filter component getting used in properties panel //
        ///////////////////////////////////////////////////////////////////////////

        $scope.getCurrentFilterParameter = function (isGlobal,dataSetName,component,filterMode,currentFilter,filterParam) {
            var dataSetFilters;
            var currentParamFilter;
            if (isGlobal) {
                if ($.isEmptyObject(dataSetFilters = $scope.pageFilters[filterMode][dataSetName]))
                     dataSetFilters = $scope.pageFilters[filterMode][dataSetName] = {};

                if(filterParam === "globalSearch") {
                    currentParamFilter = dataSetFilters[filterParam] = { "columns" : [] };
                    return currentParamFilter;
                }
                if ($.isEmptyObject(currentParamFilter = dataSetFilters[filterParam]))
                    currentParamFilter = dataSetFilters[filterParam] = { "include": [], "exclude": [], "advancedFilters":[] };

                if(component.type === "TABLE") {
                    //store old table filters which are directly stored under currentParamFilter.tableFilters
                    if($.isEmptyObject(currentParamFilter.tableFilters) || (currentParamFilter.tableFilters
                        && !currentParamFilter.tableFilters.include &&  !currentParamFilter.tableFilters.advancedFilters)) {
                        let tableFilters = angular.copy(currentParamFilter.tableFilters);
                        currentParamFilter.tableFilters = {
                            advancedFilters : tableFilters ? tableFilters : [],
                            include : [],
                            exclude : []
                        };
                    }

                }

            }

            /*
			 * if isGlobal is false, then currentParamFilter will store
			 * component.filters[filterMode][dataSetName][filterParam]
			 */
            if (!isGlobal && $.isEmptyObject(currentFilter = component["filters"][filterMode][dataSetName])) {
                component["filters"][filterMode][dataSetName] = {};
                currentFilter = component["filters"][filterMode][dataSetName];
            }
            if (!isGlobal && $.isEmptyObject(currentParamFilter = currentFilter[filterParam])) {
                currentFilter[filterParam] = { "include": [], "exclude": [] };
                currentParamFilter = currentFilter[filterParam];
            }
            return currentParamFilter;
            }

        $scope.clearPageFilterObject  = function (currentParamFilter,component,filterMode,isGlobal,isAdvanced, isCustomGroup) {
            if(component.type === 'DATE_RANGE' || component.chartType === 'TimeSeries') {
                currentParamFilter['daterange'] = "";
                currentParamFilter["include"] = [];//For custom group
            } else {
                // currentParamFilter = { "include": [], "exclude": [] };
                //for custom group component, only clear custom groups. Do not clear normal values that can be from other component
                if(isCustomGroup)
                    currentParamFilter["include"] = (currentParamFilter["include"] || []).filter(value => typeof value !== 'object' && !value.groupName);
                else
                   currentParamFilter["include"] =  (currentParamFilter["include"] || []).filter(value => typeof value === 'object' && value.groupName);
                // clear exclude or advancedFilters only in case of filterComponent or for builder filter
                if (component.type === 'FACET' || filterMode === 'builder') {
                    currentParamFilter["exclude"] = [];
                    currentParamFilter["advancedFilters"] = [];
                }
                // clear tableFilters in case of table component only
                if (component.type === 'KENDO_GRID' || component.type === 'NEW_TABLE') {
                    currentParamFilter["tableFilters"] = [];
                }

                if(component.type === 'TABLE' && isGlobal) {
                    if(isAdvanced) {
                         currentParamFilter["tableFilters"]["advancedFilters"] = [];
                    } else {
                         currentParamFilter["tableFilters"]["include"] = [];
                         currentParamFilter["tableFilters"]["exclude"] = [];
                         currentParamFilter["tableFilters"]["daterange"] = "";
                    }
                }
            }
        }
        $scope.removeUrlParameters = function (dataSet,selectionTypeVal,filterParam,component,dataSetName,filterVal,isMultiple,isToRemove,isAdvanced) {
            //in facet panel, we allow both custom group and relative/absolute from date range picker
            //as we are not showing the selected values as checkboxes, for now,
            //custom group filter is pushed as {compID}.filter.include.{fieldName}-N={groupName} (isMultiple=true)
            //date range filter is pushed as {compID}.filter.{fieldName}={string|from,to object} (isMultiple=false)
            //so when clearing, we need to clear both URL params
            const isCustomGroupField = $scope.isCustomGroupApplied(component, filterParam, dataSetName);
            if($scope.isDateType(dataSet, filterParam) && isCustomGroupField && filterVal === "") {
                $scope.addParameterToUrl(component.id + ".filter.include." + filterParam, filterVal, isMultiple, isToRemove);
            }
            angular.forEach($scope.reportComponents, function(reportComponent, index) {
                if (reportComponent.type !== 'TABLE') {     // TODO: may need to add more checks for other components like searchbar, datagrid, daterange
                    const isCustomGroupComponent = $scope.isCustomGroupApplied(reportComponent, filterParam, dataSetName);
                    //Do not remove normal filter value from url when clear if for compoent which uses custom group. and vice versa
                    if((isCustomGroupComponent && isCustomGroupField) || (!isCustomGroupComponent && !isCustomGroupField))
                        $scope.addParameterToUrl(reportComponent.id + ".filter." + selectionTypeVal  + filterParam, filterVal, isMultiple, isToRemove);
                }
            });

            if(component.type === "TABLE") {
                let filterType = isAdvanced || filterParam === "*"? ".filter." : ".select.";
                $scope.addParameterToUrl(component.id + filterType + filterParam, filterVal, isMultiple, isToRemove);
            }
        }
        /**
		 * adding filters to global filters(page.body.filters) or component level filters
		 *
		 * @param {string}
		 *            filterParam field name
		 * @param {string}
		 *            filterVal filter value or values
		 * @param {Object}
		 *            component component object stores the corresponding component on which filter is getting
		 *            applied
		 * @param {Boolean}
		 *            isMultiple if there can be more than filters applied on a component this will be false
		 *            in case of table filter
		 * @param {Boolean}
		 *            isExact will be false for table filters otherwise will be true
		 * @param {Array}
		 *            selectedGroups to store selected groups (need to check if needed or not)
		 * @param {Boolean}
		 *            isAdvanced if filterVal stores advanced filters
		 * @param {string}
		 *            filterMode can be either builder or viewer
		 * @param {string}
		 *            selectionType can be either include or exclude
		 * @param {Boolean}
		 *            isGlobal if global filters are getting applied or local filters
		 * @param {Object}
		 *            dataSet dataset info i.e. dataSetName, dataSetId, dCubeDataSet info
		 * @param {Boolean}
		 *            noRedraw to control whether we need a redraw all components after filter selection
		 * @param {Boolean}
		 *            isDelete to delete field from filters instead of just clearing it
		 */
        $scope.addFilters = function(filterParam, filterVal, component, isMultiple, isExact, selectedGroups, isAdvanced, filterMode, selectionType, isGlobal, dataSet, noRedraw, isDelete, isDoFacetCall, isClearAllFilters,isShowRadioButtons) {
            var self = this;
            var isMultiple = isMultiple, isToRemove = false;
            var dataSet = dataSet ? dataSet : $scope.dataSet;   // check if dataSet is provided or use the current component scope dataset.
            var dataSetName = dataSet.dataSet && dataSet.dataSet.dataSetName;
            var isRedraw = dataSet.endpoint !== "DATACUBE" ? true : false;
            var filtersMode;
            var dataSetFilters;
            var currentFilter;
            var currentParamFilter;
            filterMode = filterMode || "viewer";
            var filterType = 'component_viewer';
            var isClear = false;    // if getting a clear request for a field
            var isDateRange = false;

            var getArrayOfValuesFromAdvancedFilter = function(advancedFilters) {
                var values = [];
                for (var i = 0; i < advancedFilters[0].filters.length; i ++) {
                    values.push(advancedFilters[0].filters[i].value);
                }
                return values;
            }
            /*
			 * Check if filters are getting applied from page properties or from filter component as both of
			 * these filters are going to affect global filters. Page properties filters will go to
			 * page.body.filters['builder'] object whereas Filter component filters will go to
			 * page.body.filters['viewer'] object. filterType distinction is needed for exclude tags for solr
			 * so that filters applied from page properties will always get enforced to the entire page.
			 */
            if (component.pageName) {
                filterType = 'page_override';
            } else if (isGlobal) {
                filterType = 'page_viewer';
            }
            selectionType = selectionType || "include";

            if (isClearAllFilters){
                var dataSetFilters;
                dataSetFilters = $scope.pageFilters[filterMode][dataSetName];
                angular.forEach(dataSetFilters,function(currentParamFilter) {
                    if(!$.isEmptyObject(currentParamFilter) && currentParamFilter.isfieldDroppedInFilterComp === true) {
                        self.clearPageFilterObject(currentParamFilter,component,filterMode);

                    }
                });

                    isRedraw = isToRemove = true;
                    isClear = true;


            } else {
                currentParamFilter = this.getCurrentFilterParameter(isGlobal,dataSetName,component,filterMode,currentFilter,filterParam);
                if(component.type !== 'FACET' && component.type !== 'TABLE'){currentParamFilter.isChartInteractivityFilter = true;}
                if (filterVal === undefined) {
                    return;
                }
                /*
				 * to check if value is containing date range object
				 */
                 if (typeof filterVal === 'object') {
                    if (filterVal.from && filterVal.to) {
                        isDateRange = true;
                    } else if(filterVal.from === "" && filterVal.to === "")
                        filterVal = "";
                 }
                /*
				 * check if this is clear action of previous filter as data table is calling this method for
				 * all the columns available and we are keep updating the URL which results in multiple
				 * history push TODO: need to change data table logic of calling filters for all the columns
				 */
                if (filterVal === "") {
                    //for globalSearch we always get the new empty object. so no need to clear anything
                   if(!$.isEmptyObject(currentParamFilter) && filterParam !== "globalSearch") {
                        const isCustomGroup = $scope.isCustomGroupApplied(component, filterParam, dataSetName);
                        self.clearPageFilterObject(currentParamFilter,component,filterMode,isGlobal,isAdvanced,isCustomGroup);
                        if((component.type === 'FACET' || filterMode === 'builder') &&
                            ($scope.isDateType(dataSet, filterParam)
                                && !(typeof filterVal === 'object' && filterVal.hasOwnProperty('groupName')))) {
                            currentParamFilter["daterange"] = "";
                        }

                    }
                    isMultiple = false;
                    isRedraw = isToRemove = true;
                    isClear = true;

                }

                /*
				 * if filterVal is storing string value check if the applied filter is already there or not in
				 * case already present then remove it else add it
				 */
                else if (component
                            && typeof component.type !== 'undefined'
                            && (component.type === 'DATE_RANGE' || isDateRange)
                            || ((component.type === 'FACET' || filterMode === 'builder') &&
                                ($scope.isDateType(dataSet, filterParam)
                                    && !(typeof filterVal === 'object' && filterVal.hasOwnProperty('groupName')))) ||
                                (isGlobal && component.type === "TABLE" && $scope.isDateType(dataSet, filterParam))) {
                    if(isGlobal && component.type === "TABLE")
                        currentParamFilter.tableFilters["daterange"] = filterVal;
                    else if(!isMultiple && (component.type === 'FACET' && (_.isEqual(currentParamFilter["daterange"], filterVal) || _.isEqual(JSON.stringify(currentParamFilter["daterange"]), filterVal)))) {
                        //if value is selected from daterange picker then on clear
                        //it should just clear daterange picker value and keep custom groups as
                        currentParamFilter["daterange"] = "";
                        isToRemove = true;
                        filterVal = "";
                    } else
                        currentParamFilter["daterange"] = filterVal;
                    isRedraw = true;
                    if (typeof filterVal === 'object' && filterVal.from === "") {
                        isToRemove = true;
                    }
                }
                else if (typeof filterVal !== 'object' && filterVal !== "") {

                    if(component.type === "TABLE" && isGlobal)   {
                        if(filterParam === "globalSearch") {
                            currentParamFilter.columns = $scope.getVisibleStringColumns(component);
                            currentParamFilter["filterValue"] = filterVal;
                        } else if(isMultiple) {
                            if(currentParamFilter.tableFilters[selectionType].indexOf(filterVal)==-1)
                                currentParamFilter.tableFilters[selectionType].push(filterVal);
                            else {
                                currentParamFilter.tableFilters[selectionType].splice(currentParamFilter.tableFilters[selectionType].indexOf(filterVal),1);
                                isToRemove = true;
                            }
                        } else
                            currentParamFilter.tableFilters[selectionType] = [filterVal];
                        isRedraw = true;
                    } else if (currentParamFilter[selectionType].indexOf(filterVal)==-1) {
                        if(isMultiple){
                            currentParamFilter[selectionType].push(filterVal);
                        } else {
                            currentParamFilter[selectionType] = [ filterVal ];
                        }
                        isRedraw = true; //TODO to put a watch on filters
                    }
                    else if(isMultiple) //Currently charts is sending the filter value for de-select too so we need this case
                    {
                        currentParamFilter[selectionType].splice(currentParamFilter[selectionType].indexOf(filterVal),1);
                        isRedraw = isToRemove = true;
                    }
                } else if (typeof filterVal === 'object') {
                    /*
					 * if filterVal is an Array of values (in case of chart interactivity where you can select
					 * multiple values by dragging) then iterate over all values and add or remove based on if
					 * value is already there or not adding values to the url as it will be always include and
					 * it will be always select (with range selection we can't de-select)
					 */
                    if (Array.isArray(filterVal) && !isAdvanced && $.isEmptyObject(selectedGroups)) {
                        if(isGlobal && component.type === 'TABLE') {
                            if($scope.reportMode == 'viewer' && dataSet.endpoint === "DATACUBE" && !$scope.useCREApiForSolr) {
                                $scope.removeUrlParameters(dataSet,undefined,filterParam,component,dataSetName,"",false,true);
                                angular.forEach(filterVal, function(value) {
                                    $scope.addParameterToUrl(component.id + ".select." + filterParam, value, isMultiple, isToRemove);
                                });
                            }
                            currentParamFilter.tableFilters[selectionType] = filterVal;

                        } else {
                            if(component.type === 'FACET' && isDoFacetCall === false) {
                                if ($scope.reportMode == 'viewer' && dataSet.endpoint === "DATACUBE" && !$scope.useCREApiForSolr)
                                    $scope.removeUrlParameters(dataSet,selectionType+".",filterParam,component,dataSetName,"",false,true);
                                currentParamFilter[selectionType] = [];
                            }
                            angular.forEach(filterVal, function(value) {
                                if (currentParamFilter[selectionType].indexOf(value)==-1) {
                                    if (isMultiple){
                                        currentParamFilter[selectionType].push(value);
                                    } else {
                                        currentParamFilter[selectionType] = [ value ];
                                    }
                                    if ($scope.reportMode == 'viewer' && dataSet.endpoint === "DATACUBE" && !$scope.useCREApiForSolr) {

                                        $scope.addParameterToUrl(component.id + ".filter." + selectionType + "." + filterParam, value, isMultiple, isToRemove);
                                    }
                                }
                            });
                        }

                    }

                    /*
					 * This code block is to handle tuple selection from heatmap for tuples filterParam will
					 * have a tuples_componentId in case of tuple filterVal will store an object({'dimension1' :
					 * value1, 'dimension2':value2})
					 */
                    else if (filterParam.indexOf("tuples_") != -1 && !isAdvanced) {
                        var isPresent = true;
                        var presentIndex = -1;
                        angular.forEach(currentParamFilter[selectionType], function(tuple, index) {
                            isPresent = true;
                            angular.forEach(tuple, function(value, dimension) {
                                if (typeof filterVal[dimension] != undefined && filterVal[dimension] !== value) {
                                    isPresent = false;
                                    return;
                                }
                            });
                            if (isPresent) {    // if already present, de-select
                                presentIndex=index;
                                return;
                            }
                        });
                        if (presentIndex  === -1) {
                            currentParamFilter[selectionType].push(filterVal);
                        } else {
                            currentParamFilter[selectionType].splice(presentIndex,1);
                        }
                    } else if (isAdvanced) {
                        /*
						 * to store advanced filters filterVal will store an object({ 'filters' : [{ 'field' :
						 * '', 'operator' : 'eq', 'value' : 'value' }], 'logic' : 'and/or' }) we are using
						 * advancedFilters for tableFilters as well. but we need a distinction here for easy
						 * handling of clear filter.
						 */
                        if (component && typeof component.type !== 'undefined' && (component.type === 'TABLE') && filterMode!='builder') { //TODO: add condition for data grid
                            currentParamFilter.tableFilters["advancedFilters"] = [ filterVal ];
                        } else {
                            currentParamFilter["advancedFilters"] = [ filterVal ];
                        }
                    } else {
                        var presentIndex = -1;
                        // to handle custom groups
                        filterVal = [];

                        /*
						 * in case of range selection from vertical bar or horizontal bar no need to remove
						 * existing selected values add the bookmarks in this existing for loop in case group
						 * is already present send value as empty in addParamter to url
						 */
                        var isRangeSelection = false;
                        if (selectedGroups.length > 1) {
                            isRangeSelection = true;
                        }
                        if(component.type === 'FACET' && isDoFacetCall === false) {
                            $scope.removeUrlParameters(dataSet,selectionType+".",filterParam,component,dataSetName,"",false,true);
                            currentParamFilter[selectionType] = [];
                        }
                        angular.forEach(selectedGroups, function(group, index) {
                            angular.forEach(currentParamFilter[selectionType], function(value, index) {
                                if (typeof value === 'object' && (value.groupName || "") === group.groupName ) {
                                    presentIndex = index;
                                    return;
                                }
                            });
                            var value = group.groupName;
                            if (presentIndex === -1) {
                                filterVal.push(group);
                            } else if (!isRangeSelection) {
                                currentParamFilter[selectionType].splice(presentIndex,1);
                            }
                            if ($scope.reportMode == 'viewer') {
                                //when selected group already present in URL, then isRemove = true
                                $scope.addParameterToUrl(component.id + ".filter." + selectionType + "." + filterParam, value, isMultiple, presentIndex === -1 ? false: true);
                            }
                        });
                        currentParamFilter[selectionType] = currentParamFilter[selectionType].concat(filterVal);
                    }

                    isRedraw = true;
                }
            }
            if(isRedraw)
            {
                /*
				 * Interactivity for data cube dataset.
				 */
                if(dataSet.endpoint === "DATACUBE" && !$scope.useCREApiForSolr)
                {
                    if (isGlobal) {
                        var selectionTypeVal = "";
                        // for table component we don't have include and exclude for now
                        if (component.type != "TABLE" && component.type != "NEW_TABLE" && component.type != "DATE_RANGE"
                            && (!$scope.isDateType(dataSet, filterParam) ||
                                     (typeof filterVal === 'object' && filterVal.hasOwnProperty('groupName')))) {
                            selectionTypeVal = selectionType + ".";
                        }
                        /*
						 * if filter is not advanced and the component is either table or report mode is
						 * viewer then push filter to the url as well for bookmarking
						 */
                        if ((isAdvanced && component.type === "TABLE" || component.type === "NEW_TABLE") || (!isAdvanced && $scope.reportMode === 'viewer')) {
                            if (isAdvanced && (component.type === 'TABLE' || component.type === 'NEW_TABLE')) {
                                filterVal = filterVal !== '' ? filterVal.filters[0].value : filterVal;
                                // filterVal = filterVal.filters[0].value;
                            }
                            /*
							 * in case of selection by drag, filterVal will be an array and we are handling
							 * this above as we have moved to global filters, filter applied from any
							 * component can get cleared from any other component including filter component
							 * we need to call addParameterToUrl for all the components(except table
							 * component) to clear filters applied.
							 */
                            if (!Array.isArray(filterVal)) {
                                let paramName = filterParam === "globalSearch" ? '*' : filterParam;
                                let urlParamVal = filterVal;
                                if(component.type === "FACET") {
                                    const field = component.filterDataField[filterMode][dataSetName].fields.find(field => {
                                        return field.column === filterParam;
                                    });
                                    if(field && field.showEmptyValues) {
                                        const emptyVal = qb.rv.getQueryForEmptyVal();
                                        if(emptyVal === filterVal)
                                            urlParamVal = field.emptyValueLabel;
                                    }
                                }

                                if (isToRemove) {
                                    if (isClearAllFilters) {
                                        angular.forEach(component.filterDataField[filterMode][dataSetName].fields,function(field) {
                                            var selType = "";
                                            if(!$scope.isDateType(dataSet, field.column) || (typeof urlParamVal === 'object' && urlParamVal.hasOwnProperty('groupName')))
                                                selType =  field.selectAll ? "exclude." : "include.";
                                            $scope.removeUrlParameters(dataSet,selType,field.column,component,dataSetName,urlParamVal,isMultiple,true);


                                        });
                                    } else
                                         $scope.removeUrlParameters(dataSet,selectionTypeVal,paramName,component,dataSetName,urlParamVal,isMultiple,isToRemove,isAdvanced);
                                } else {
                                    let filterType = (component.type === 'TABLE' && !isAdvanced && filterParam !== "globalSearch") ? ".select." : ".filter." + selectionTypeVal ;
                                    $scope.addParameterToUrl(component.id + filterType + paramName, typeof urlParamVal === 'object' ? JSON.stringify(urlParamVal) : urlParamVal, isMultiple, isToRemove);
                                }
                            }
                        }
                        var options = {
                            dataSet : dataSet,
                            filters : customReportSvc.getDeepCopy($scope.pageFilters[filterMode][dataSetName]),
                            isExact : isExact,
                            filterType : filterType,
                            fqAlias : component ? component.fqAlias : undefined
                        };
                        if(isDoFacetCall !== false) {
                            $dataSource.getDataSource(dataSet.endpoint).applyFilters(options, function(isSuccess) {
                                // TODO: put a error check in case of failure
                                if(isSuccess && !noRedraw) {
                                    customReportSvc.triggerCallback("redrawAllComponents", component ? component.id : undefined); // redraw all components in case of global filters
                                }
                            });
                        }
                        if (isClearAllFilters) {
                            var filterFields = $scope.pageFilters[filterMode][dataSetName];
                            angular.forEach(filterFields,function(filterField,filterParam) {
                                if(filterField.isfieldDroppedInFilterComp){delete filterFields[filterParam];}
                            });

                        } else if (isClear && !$.isEmptyObject($scope.pageFilters[filterMode][dataSetName])
                                && $scope.pageFilters[filterMode][dataSetName][filterParam]) {
                                const isCustomGroup = $scope.isCustomGroupApplied(component, filterParam , dataSetName);
                                const includeFilters = $scope.pageFilters[filterMode][dataSetName][filterParam].include || [];
                                const customGroupfilter = includeFilters.find(filterVal => typeof filterVal === object && filterVal.groupName);
                                //Do not remove normal filter value from url when clear if for compoent which uses custom group. and vice versa
                                if((isCustomGroup && customGroupfilter) || (!isCustomGroup && !customGroupfilter))
                                    delete $scope.pageFilters[filterMode][dataSetName][filterParam];
                        }
                    } else if (!noRedraw) {
                        if (isDelete && currentFilter && currentFilter.hasOwnProperty(filterParam)) {
                            delete currentFilter[filterParam];
                        }
                        customReportSvc.triggerCallback("refreshComponent", component.id, component.id); // redraw the individual component in case of component filters
                        customReportSvc.triggerCallback("refreshComponent", component.id, "filter_" + component.id); // redraw the individual component in case of component filters
                    }
                }
                else {
                    /*
					 * interactivity for datasets other than datacube
					 */
                    if(!selectionTypeVal){
                        selectionTypeVal = "";
                    }
                    var key = $scope.component.id + ".filter." + selectionTypeVal  + filterParam;
                    if(isMultiple){
                        var values = [];
                        if($scope.requestParms[key] && !isShowRadioButtons){
                            values = $scope.requestParms[key];
                            var found = false;
                            if(values){
                                values =  JSON.parse(values);
                                if(Array.isArray(filterVal)){
                                    values = _.union(filterVal, values);
                                }else{
                                    var idx = values.indexOf(filterVal);
                                    if(idx !== -1){
                                        values.splice(idx,1);
                                        found = true;
                                    }else{
                                        values.push(filterVal);
                                    }
                                }
                            }
                        } else {
                            if(Array.isArray(filterVal)){
                                values = filterVal;
                            } else {
                                values.push(filterVal);
                            }

                        }
                        if (values.length > 0) {
                            if (isAdvanced) {
                                filterVal = JSON.stringify(getArrayOfValuesFromAdvancedFilter(values));
                            } else {
                                filterVal = JSON.stringify(values);
                            }
                        } else {
                            filterVal = undefined;
                        }
                        isMultiple = false;
                    }

                    if(isShowRadioButtons)
                        $scope.addParameterToUrl(key, "", undefined, true);
                    $scope.addParameterToUrl(key, filterVal, isMultiple, isToRemove);
                   var comp = filterVal && !isShowRadioButtons ? $scope.component : undefined;
                    if ($scope.component.type !== "TABLE" && $scope.component.type !== "PIVOT_TABLE" && $scope.component.type !== 'NEW_TABLE'){ // reload all components.
                        if(comp){
                            comp.filterField = dataSetUtility.getFieldDefintion(filterParam,$scope.dataSet); // add the filter field so that it can be checked if exist on the data set and applied.
                        }
                        if($scope.panelComponentsToIds[$scope.component.id]){
                        	_.map($scope.panelComponents[$scope.panelComponentsToIds[$scope.component.id]],function(id){
                        				customReportSvc.triggerCallback("refreshComponent",id);
                        		});
                        }else{
                        	customReportSvc.triggerCallback("redrawAllComponents",comp);
                        }

                    }
                }
            }
        };

        $scope.loadingButton = function(component) {
            component = component || $scope.component;
            var selector = 'li[comp=' + component.id + '], div[comp=' + component.id + ']';
            if (!$scope.isReadme) {
            var progress = 0;
            $(selector).find(".loading-top").css("opacity","1");
            if (component.isComponentLoading){
                $(selector).find(".component").css("opacity","0.3");
            }
            if (!$scope.interval) {
                $scope.interval = setInterval(function() {
                if (component.isComponentLoading){
                    progress = Math.min(progress + Math.random() * 0.1, 0.8);
                } else {
                    progress = 1;
                }
                    $(selector).find(".loading-top").css('width', progress * 100 + "%");

                if (progress === 1) //=== means equal value and type
                {
                    clearInterval($scope.interval);
                    $scope.interval = undefined;
                    $timeout(function(){
                            $(selector).find(".loading-top").css("opacity","0");
                            $(selector).find(".component").css("opacity","1");
                        $timeout(function(){
                                $(selector).find(".loading-top").css("width","0");
                        });
                    },50);
                }
                }, 50);
                }
        }
    }

        $scope.getData = function(dataset, isTopologyNodes, ignoreLoading, component, isGrouped) {
            component = component || $scope.component;
            if (!ignoreLoading) {
                component.isComponentLoading = true;
                $scope.loadingButton();
            }
            if (dataset === undefined) {
            	let compDataSet = _.get(component,'dataSet.dataSetName');
	        	if ($scope.dataSet === undefined || (compDataSet && compDataSet != $scope.dataSet.dataSet.dataSetName)) {
	                $scope.dataSet = $scope.getDataSet(compDataSet, 'name');
	            }
                dataset = $scope.dataSet;
            }

            var dsId = 0;
            dsId = $scope.getDSId(dataset);
            var dataSetParams = {
                reportMode: $scope.reportMode,
                componentName: component.title && component.title.text || component.id,
                dsId: dsId,
                operation: (component.type == "R-GGPlot") ? "rImage" : ($scope.isPost(dataset) ? "select" :"data"),
                builderVersion: $scope.customReport.builderVersion,
                isPreview: $scope.isPreview,
                limit: component.pageSize,
                offset: $scope.child.tableParams && $scope.child.tableParams.pageOffSet || $scope.child.offset || 0, // inner grid offset is set at component level , outer grid component is set at scope level as we should not save it in the defintion.
                exportType: null,
                exportedFileName: null,
                rawData: dataset && dataset.endpoint == "HTTP" ? true : false,
                cacheId: dataset.preview ? customReportSvc.generateUUID() : $scope.cacheId,
        		panelComponents:$scope.panelComponents,
        		panelComponentsToIds:$scope.panelComponentsToIds
            };

			if (typeof component.pageOffset !== "undefined"){
            	dataSetParams.offset = component.pageOffset;
            }

            $scope.mergedParams = $.extend({}, $scope.requestParms, $scope.viewParams); // if common keys exist, the one in viewParams will be retained

            for (var key in $scope.requestParms) {
            	if ($scope.mergedParams.hasOwnProperty(key) && key.indexOf('.filter.')>-1) {
            		if($scope.mergedParams[key] !== $scope.requestParms[key]){
            			$scope.mergedParams[key] = $scope.mergedParams[key] + ' && ' + $scope.requestParms[key];
            		}
            	}
            }

            $scope.masked = true;
            var dataUrl = dataSetUtility.getUrlForDataComponent(component, dataset, $scope.page, dataSetParams, $scope.mergedParams, isTopologyNodes, isGrouped);
            $scope.dataSetParams = dataSetParams;
            if($scope.isPost(dataset)){
                var datasets;
                if(dataset.endpoint == "R"){
                    datasets = dataSetUtility.getDataSets(dataset, $scope.page);

                    for(var i=0;i<$scope.dataSets.length;i++){
                        if($scope.dataSets[i].dataSet.dataSetGuid != dataset.dataSet.dataSetGuid){
                            if($scope.isDataSetIsIncluded($scope.dataSets[i], dataset)){
                                datasets.dataSet.push($scope.dataSets[i]);
                            }
                        }
                    }

                    if(component.type == "R-GGPlot"){
                        var rScript =  dataset.GetOperation.rDataSetQuery;
                        rScript += "\n";
                        rScript += dataset.GetOperation.rPlotQuery;

                        dataset.GetOperation.rDataSetListInfo.rScript = rScript;

                        datasets = {
                                dataSets :    datasets,
                                rDataSetMetaInfo : dataset.GetOperation.rDataSetListInfo
                        }
                    }//ggplot

                }
                else{
                    datasets = dataSetUtility.getDataSets(dataset, $scope.page);
                }
                return reportService.postDataForDataSetViaProxy(dataUrl,datasets).catch($scope.errorFunc);
            } else {
                if(component.type == "R-GGPlot"){
                    dataUrl += "&reportId=" + $scope.reportId + "&pageName=" + $scope.page.pageName + "&componentId=" +component.id;
                }
                $scope.dataURL =  dataUrl;
                return reportService.getDataForDataSetViaProxy(dataUrl).catch($scope.errorFunc);
            }
        }

        $scope.showQuickAnalysis = function($event,columnData) {
            $scope.quickAnalysisMode = !$scope.quickAnalysisMode;
			$scope.columnData = columnData;
            if($scope.columnData){
            	$scope.quickAnalysisMode = true;
            }
            $scope.child.resizeGridComponent();
			//customReportSvc.triggerCallback("refreshComponent", $scope.component.id+"quickChart");
            //customReportSvc.triggerCallback("quickChartToggled", $scope.component.id);
           // $event.stopPropagation();
        }

        $scope.showTableMenu = function($event, id) {
            var menu = $('#table_menu_' + id);
            menu.toggle();
            $scope.tableMenuVisible = !$scope.tableMenuVisible;
            if ($("li[comp=" + $scope.component.id + "]").hasClass("visible-overflow")){$("li[comp=" + $scope.component.id + "]").removeClass("visible-overflow");} else {$("li[comp=" + $scope.component.id + "]").addClass("visible-overflow");}
            $('#col_menu_' + id + '.fadeOutSection').hide();
            $scope.child.colMenuVisible = false;
            $event.stopPropagation();
        };

        $scope.handleSuccess = function(response) {
            if(Object.keys(response.failures).length > 0){
                $scope.handleErrorsOrWarnings(response.failures);
            }
            return response;
        }

        $scope.handleErrorsOrWarnings = function(failures, warning) {
            //handling to show errors from the response
            var error = "";
            angular.forEach(failures, function(errorObj, key) {
                angular.forEach(errorObj, function(actualError, type) {
                    error = error + key + " : " + actualError + "<br>";

                });
            });

            if (error && !$scope.exportType) {
                if (error.length > 450) {
                    var intialText = error.substring(0, 450);
                    var endText = error.substring(450);
                    if (warning){customReportSvc.infoWithDetailsToast($.trim(intialText), $
                            .trim(endText), "More &gt;&gt;", "Less &lt;&lt;", true);} else {customReportSvc.errorWithDetailsToast($.trim(intialText), $
                            .trim(endText), "More &gt;&gt;", "Less &lt;&lt;", true);}
                } else {
                    if (warning){customReportSvc.toast(error);} else {customReportSvc.errorToast(error);}

                }
            }
        }

        $scope.getFieldDefintion = function(fieldName){
            if($scope.dataSet && $scope.dataSet.fields){
                for(var i=0;i<$scope.dataSet.fields.length;i++){
                    if(fieldName === $scope.dataSet.fields[i].name){
                        return $scope.dataSet.fields[i];
                    }
                }
            }
        }

        $scope.errorFunc = function(error, status){
            console.log('error', error, status);
            error = error.data || error;
            if(typeof error === "object" && error && error.errorMessage){
                error =  error.errorMessage;
            } else {
            	error = '';
            }
            $scope.masked = false;
            $scope.component.isComponentLoading = false;
            window.error = window.error || {};
            window.error[$scope.dataSet.guid] = window.error[$scope.dataSet.guid] || {};
            if(window.error[$scope.dataSet.guid][status]!=undefined ){
                return ;
            }else{
                window.error[$scope.dataSet.guid][status]=error;
            }


            if ($scope.isFilterRequest) {
                alert("Invalid Filter Criteria. Only =, !=, <, <=, >, >=, &&, || are supported. Refer to the documentation for usage.");
                $scope.isFilterRequest = false;
                return;
            }
            if (error.length > 450) {
                var intialText = error.substring(0, 450);
                var endText = error.substring(450);
                customReportSvc.errorWithDetailsToast($.trim(intialText),
                        $.trim(endText),
                        "More &gt;&gt;",
                        "Less &lt;&lt;",
                        true);
            } else {
                customReportSvc.errorToast(error);
            }

            if ($scope.reportMode == 'preview') {
                customReportSvc.triggerCallback("previewCompleted", []);
            }

            if($scope.component.type === 'TABLE' || $scope.component.type === 'PIVOT_TABLE' || $scope.component.type === 'NEW_TABLE'){
            	$scope.child.kendoGrid.element.find("div.k-loading-mask").remove();
            }
        };

        $scope.moveComponent = function(index, direction) {
            var comp = $scope.component;
            if (direction == "UP") {
                $scope.reportComponents.splice(index, 1);
                $scope.reportComponents.splice(index - 1, 0, comp);
            } else {
                $scope.reportComponents.splice(index, 1);
                $scope.reportComponents.splice(index + 1, 0, comp);
            }
        };

        $scope.deleteComponentByName = function(name) {
            angular.forEach($scope.reportComponents, function(component, key) {
                if (component.id == name) {
                    $scope.deleteComponent(key);
                }
            });
        };

        $scope.deleteComponent = function(index,panelComponentIndex,tabData) {
            var component = $scope.reportComponents[index];
            var components = $scope.reportComponents;
            var layout = $scope.reportLayout;
            if(!tabData && (panelComponentIndex || panelComponentIndex === 0)){
                component = $scope.reportComponents[panelComponentIndex];
                components = component.panelComponents;
                layout = component.layout;
            }

            if(tabData && tabData.tabId){
                var tab = dataSetUtility.getComponent(tabData.tabId,$scope.reportComponents,true);
                component = tab.component;
                components = component.panelComponents;
                layout = component.layout;
            }
            customReportSvc.unRegisterComponetCbs(component.id);
            /*
			 * clear all applied filters when component is getting deleted TODO: add support for filter panel,
			 * search bar, table. Revisit this logic as filters applied are not getting stored in a component
			 */
            if (component.type === 'CHART' || component.type === 'HEAT_MAP' || component.type === 'TAG_CLOUD') {
                if (component.dimensionDataField && component.dimensionDataField.length > 0) {
                    $scope.clearComponentFilters('viewer', undefined, component, undefined, 'component',component.dimensionDataField[0].column)
                }
            } else if (component.type === 'DATE_RANGE') {

                if (component.dateRangeField) {
                    $scope.clearComponentFilters('viewer', undefined, component, undefined, 'component',component.dateRangeField);
                }
            } else if (component.type === 'NEW_TABLE') {
                $scope.$broadcast('clearAppliedFilters', component.id )
            } else if (component.type == 'FACET') {
                if (component.filterDataField) {
                    $scope.$broadcast('clearAppliedFilters', component.id);
                }
            } else if (component.type == 'SEARCH_BAR') {
                // clear searchquery
                $scope.$broadcast('clearAppliedFilters', component.id);
            }
            delete layout[components[index].id]; // deleting layout information for this component
            components.splice(index, 1);
            if (components.length > 0) {
                if (index !== 0){
                    index--;
                }
                $scope.setActiveComponent(components[index]);
            } else {
                $scope.displayProperties.selectedRightPanel = 'visualization';  // in case all components are deleted switch to visualization panel
            }

            if (component.type === 'IFRAME') {
                $scope.saveDashboard($scope.customReport,true);
            }
        }

        // will open the alarm dialog by passing in the current columns.
        $scope.openAlarmsDialog = function() {
            //if we open up alarm dialog after modifying the existing alarm opened from alert manager page, resetting the alarmDetails, to avoid any other issues.
            $scope.alarmDetails = undefined;
            $uibModal.open({
                templateUrl: customReports.contextPath + "/reportsplus/alarms/alarmsModal.jsp",
                controller: 'alarmsCtrl',
                windowClass: 'reportsPlusAlarm',
                scope:$scope
            });
        };

        // toggles the component. Slide of the component.
        $scope.toggleComponentVisiblity = function($event) {
            $scope.component.collapsed = !$scope.component.collapsed;
            var body = $($event.target.parentElement).siblings('.component-body');
            if ($scope.isLayoutAvailable) {
            if(!$scope.component.collapsed) {
                    if (!$scope.component.originalSizeY){
                        $scope.component.originalSizeY = 8;
                    }
                    $scope.reportLayout[$scope.component.id][$scope.deviceType].size.y = $scope.component.originalSizeY;
            }
            else if ($scope.component.collapsed) {
                    $scope.component.originalSizeY = $scope.reportLayout[$scope.component.id][$scope.deviceType].size.y;
                    $scope.reportLayout[$scope.component.id][$scope.deviceType].size.y = 1;
            }
            }
            body.slideToggle();
            if($scope.component.type === "CHART"){
                $scope.child.reflowChart();
            } else if ($scope.component.type === "TABLE") {
                $scope.$broadcast("ngTableAfterReloadData",true);
            }

            $event.stopPropagation();
        };

        $scope.collapseComponent = function() {
            if ($scope.component.collapsed) {
                $scope.reportLayout[$scope.component.id][$scope.deviceType].size.y = 1;
            }
            return $scope.component.collapsed;
        };

        $scope.showRESTAPI = function(){
            $uibModal.open({
                templateUrl: customReports.contextPath + "/reportsplus/components/restapi/restApiModal.jsp",
                controller: 'restApiCtrl',
                windowClass: 'reportsPlusRestApi',
                scope:$scope
            });
        };

        //export all of the table data to csv.
        $scope.exportToCSV = function(e) {
            $scope.child.masked = true;
            if ($scope.dataSet.endpoint === 'DATACUBE') {
                $scope.exportToCSVDatacube();
            } else {
                $scope.mergedParams = $.extend({}, $scope.requestParms, $scope.viewParams);
                var dataSetsToExport = customReportSvc.getDataSetstoExport([$scope.component], $scope.page, $scope.customReport.report.customReportName, $scope.mergedParams, $scope.cacheId,$scope.customReport.builderVersion,$scope.reportComponents);

                var filePrefix = $scope.customReport.report.customReportName + "_";
                if ($scope.component.title && $scope.component.title.text && $scope.customReport.report.customReportName !== $scope.component.title.text){
                    filePrefix +=  customReportSvc.getLocalizedTitle($scope.component.title.text);
                }


                var params = {
                        dataSets:JSON.stringify(dataSetsToExport),
                        exportedFileName:filePrefix,
                        exportType : 'csv',
                        cacheId:$scope.cacheId
                };
                reportService.retrieveCsvData(params).then(function(data) {
                    var data1 = data.data;
                    $scope.child.masked = false;
                    if (!data1 || data1 == "" || data1 == 'null'){
                        alert(localMsg['ExportError']);
                    }else {
                        dataSetUtility.downloadReportFile(data1);
                    }
                }, function(error) {
                    alert(error.data);
                    $scope.child.masked = false;
                });
            }

            if(e){
                e.stopPropagation();
                e.preventDefault();
            }
        };

        /**
		 * export all of the table data to csv for data cube dataset
		 */
        $scope.exportToCSVDatacube = function(reqObj) {
            var dCubeDataSet = $scope.dataSet.dCubeDataSet;
            if (!dCubeDataSet) {
                return;
            }
            if(!reqObj)
                reqObj = JSON.parse($scope.tempComponent.latestSearchParams);

            // remove hidden columns and excludeFromCSV columns from reqObj
            var columnMapping = {};
            // create a column map for hidden and excluded columns from component.columns
            angular.forEach($scope.component.columns, function(column, index) {
                columnMapping[column.dataField] = false;
                if (column.hidden || column.visible === false || column.excludeFromCSVExport) {    // check for hidden columns (in case of includeAll column deletion is marking column as hidden) and excludedColumns
                    columnMapping[column.dataField] = true;
                }
            });
            var searchParamsCopy = [];
            angular.forEach(reqObj.searchParams, function(fieldObj, index) {
                if (fieldObj.key === 'fl') {    // check for fields only
                    if (!columnMapping[fieldObj.value]) {
                        searchParamsCopy.push(fieldObj);
                    }
                } else {
                    searchParamsCopy.push(fieldObj);
                }
            });

            reqObj.searchParams = searchParamsCopy;
            reportService.exportToCSVDatacube(dCubeDataSet, reqObj).then(function(resp) {
                if (resp.data && resp.data.error) {
                    var error = resp.data.error;
                    if (error.errLogMessage) {
                        customReportSvc.errorToast(localMsg.FailedCSVDownload);
                        console.log(error);
                    } else {
                        var token = error.customMap.name;
                        customReportSvc.toast(localMsg.StartingCSVDownload);
                        $scope.doExportCSVStatusPoll(dCubeDataSet, token);
                    }
                }
                $scope.child.masked = false;
            },function(resp, message) {
                customReportSvc.errorToast(message);
                $scope.child.masked = false;
            });
        }

        /**
         * do a polling for export csv for all of the table data and download when done
         *
         * @param {number}
         *            handlerId handlerId for the dataset
         * @param {string}
         *            token
         * @return
         */
        $scope.doExportCSVStatusPoll = function(dCubeDataSet, token) {
            reportService.getExportStatus(dCubeDataSet, token).then(function(resp) {
                    var statusObject = JSON.parse(resp.data.error.customMap.value);
                    if (statusObject.response.status == "running" ||
                            statusObject.response.status == "starting" || (!statusObject.response.status && statusObject.errorCode === 0)) {
                        setTimeout(function() {
                            $scope.doExportCSVStatusPoll(dCubeDataSet, token);
                        }, 3000);
                    } else if (statusObject.response.status == "finished") {
                        var downloadGuid = statusObject.response.downloadGuid;
                        customReportSvc.toast(localMsg.SuccessCSVDownload);
                        $("#pageDiv").append("<iframe style='display:none' src='" + cvUtil.getContextPath() +
                                "/server/doExportDownload.do?downloadGuid=" + downloadGuid + "'</iframe>");
                    } else {
                        customReportSvc.errorToast(localMsg.FailedCSVDownload);
                    }
                }, function(resp, message) {
                    customReportSvc.errorToast(message);
            });
        }

        /**
		 * check whether filter is applied for a component and show clear option based on that
		 *
		 * @param {string}
		 *            filterMode
		 * @param {Object}
		 *            dimension
		 * @param {Object}
		 *            component
		 * @param {Object}
		 *            dataSet
		 * @param {string}
		 *            type
		 * @return {boolean} returns true if clear is applicable otherwise false
		 */
        $scope.showFilterClearOption = function(filterMode, dimension, component, dataSet, type) {
            if($scope.dataSet && $scope.dataSet.endpoint !== "DATACUBE"){
                return false; // for cre reports it is handled at component level.
            }
            dataSet= dataSet || $scope.dataSet;
            if (!dataSet || !dimension) {
                return false;
            }
            var currentFilterMode;
            var currentFilter;
            var currentParamFilter;
            var isGlobal = typeof type === "string" && (type === "pageProperties" || type === 'component') ? true : false;
            if (isGlobal) {
                if ($.isEmptyObject($scope.pageFilters) || $.isEmptyObject(currentFilterMode=$scope.pageFilters[filterMode])) {
                    return false;
                }
            } else {
                if ($.isEmptyObject(component.filters) || $.isEmptyObject(currentFilterMode=component["filters"][filterMode])) {
                    return false;
                }
            }
            if ($.isEmptyObject(currentFilter=currentFilterMode[dataSet.dataSet.dataSetName])) {
               return false;
            }
            else if ($.isEmptyObject(currentParamFilter=currentFilter[dimension.column])
                        && ($.isEmptyObject(currentParamFilter=currentFilter["tuples_" + component.id])
                            || $.isEmptyObject(currentParamFilter["include"]))) {
                return false;
            }
            else if (component.type === 'SEARCH_BAR') {
                if (!currentParamFilter['searchQuery']) {
                    return false;
                } else {
                    return true;
                }
            }
            else if (($.isEmptyObject(currentParamFilter["include"]) &&
            ($.isEmptyObject(currentParamFilter["daterange"]) || !(currentParamFilter.daterange.from || currentParamFilter.daterange.to)))
                        || !$.isEmptyObject(currentParamFilter["exclude"])
                        || dimension.isAdvancedFilterApplied) {
                return false;
            } else if(currentParamFilter["include"].length &&
            ($.isEmptyObject(currentParamFilter["daterange"]) || (!currentParamFilter.daterange.from && !currentParamFilter.daterange.to))) {
                //Do not show clear if component is using custom groups and include array contains normal values. and vice versa.
                const isCustomGroup =  $scope.isCustomGroupApplied(component, dimension.column, dataSet.dataSet.dataSetName);
                const customGroupVals = currentParamFilter["include"].filter(val => typeof val === 'object' && val.groupName);
                const normalVals = currentParamFilter["include"].filter(val => typeof val !== 'object' && !val.groupName)
                return isCustomGroup ? customGroupVals.length !== 0 : normalVals.length !== 0;
            } else {
                return true;
            }
        };

        $scope.clearDateRange = function(component){
             component.dateRange = {
                     absolute: {
                         from: "",
                         to: ""
                     },
                     relative: ""
                 };
        }
        // clear component filters and redraw chart
        // clearComponentFilters is getting called for FilterPanel also which is not associated with any dataset
        $scope.clearComponentFilters = function(filterMode, dimension, component, dataSet, type,field, noRedraw, isDelete, isClearAllFilters,selectionType) {
            if (!$.isEmptyObject($scope.dataSet)) {
                if($scope.dataSet.endpoint !== "DATACUBE" || ($scope.dataSet.endpoint === "DATACUBE" && $scope.useCREApiForSolr)){
                    if(field){
                        $scope.addFilters(field,"",component,false,true,undefined,undefined,"viewer","include",true);
                    }
                    if (component.type === 'DATE_RANGE') {
                     $scope.clearDateRange(component);
                     customReportSvc.triggerCallback('clearDateRange', component.id);
                     }
                    return;
                }
            }
            var isDimensionDataField = false;
            if (!dataSet) {
                isDimensionDataField = true;
            }
            dataSet= dataSet || $scope.dataSet;
            var dataSetName = dataSet.dataSet.dataSetName;
            var isGlobal = typeof type === "string" && (type === 'component' || type === 'pageProperties') ? true : false;
            var filterMode = !filterMode ? (!isGlobal ? "builder" : "viewer") : filterMode;
            if (!dimension && !isClearAllFilters) {
                if (component.type === 'DATE_RANGE') {
                    $scope.clearDateRange(component);
                    customReportSvc.triggerCallback('clearDateRange', component.id);
                } else if (component.type === 'SEARCH_BAR') {
                    $scope.$broadcast('clearAppliedFilters', component.id);
                }
                else {
                    if (component.chartType === "TimeSeries")
                        $scope.$broadcast('clearAppliedFilters', component.id);
                    var filterFields = !isDimensionDataField ? component.filterDataField[filterMode][dataSetName] : component.dimensionDataField;
                    var filterParams = $.extend(true,[],filterFields);    // read only copy
                    if ($scope.pageFilters[filterMode][dataSetName] && !$.isEmptyObject($scope.pageFilters[filterMode][dataSetName]['tuples_' + component.id])) {
                        filterParams.push({'column' : 'tuples_' + component.id});
                    }
                    angular.forEach(filterParams, function(filterParam) {
                        $scope.child.addFilters(filterParam.column,"", component, undefined, undefined, undefined, undefined, filterMode, "include", isGlobal, dataSet, noRedraw, isDelete);
                    });
                }
            } else {

                var fieldName = dimension ? dimension.column : dimension;

                $scope.addFilters(fieldName,"", component, undefined, undefined, undefined, undefined, filterMode, selectionType, isGlobal, dataSet, noRedraw, isDelete, undefined, isClearAllFilters);
                if (dimension) {
                    dimension.isAdvancedFilterApplied = false;
                }

            }
        };

        $scope.showDataGridFilterClearOption = function() {
            if($scope.dataSet && $scope.dataSet.endpoint !== "DATACUBE"){
                return false;
            }
            var dataSet= $scope.dataSet;
            if (!dataSet || !$scope.component.columns || $scope.component.columns.length === 0) {
                return false;
            }
            var currentFilterMode;
            var currentFilter;
            var currentParamFilter;
            if ($.isEmptyObject($scope.pageFilters) || $.isEmptyObject(currentFilterMode=$scope.pageFilters['viewer'])) {
                return false;
            }
            if ($.isEmptyObject(currentFilter=currentFilterMode[dataSet.dataSet.dataSetName])) {
               return false;
            }
            var isShowClear = false;
            angular.forEach($scope.component.columns, function(column, index) {
                if (currentFilter[column.dataField] && !$.isEmptyObject(currentFilter[column.dataField].tableFilters)) {
                    isShowClear = true;
                }
            });
            return isShowClear;
        };

        $scope.clearDataGridComponentFilters = function() {
            if($scope.dataSet && $scope.dataSet.endpoint !== "DATACUBE"){
                return;
            }
            var dataSet= $scope.dataSet;
            if (!dataSet || !$scope.component.columns || $scope.component.columns.length === 0) {
                return;
            }
            var currentFilterMode;
            var currentFilter;
            var currentParamFilter;
            if ($.isEmptyObject($scope.pageFilters) || $.isEmptyObject(currentFilterMode=$scope.pageFilters['viewer'])) {
                return;
            }
            if ($.isEmptyObject(currentFilter=currentFilterMode[dataSet.dataSet.dataSetName])) {
               return;
            }
            angular.forEach($scope.component.columns, function(column, index) {
                var fieldName = column.dataField;
                $scope.addFilters(fieldName, "", $scope.component, false, false, undefined, true, 'viewer', undefined, true, undefined, true, false);
            });
            $scope.tempComponent.dataGridFilter = {'logic': 'and','filters': []};
            customReportSvc.triggerCallback("redrawAllComponents");
        };

        function closeOnEscape(e) {
            if (e.keyCode == 27) {
                if ($scope.component.id) {
                $scope.makeComponentFullScreen(e.data.e);
                } else {
                    customReportSvc.errorToast("Please enter a valid ID."); // TODO: localize
                }
            }
            e.stopImmediatePropagation();
        }

        $scope.makeComponentFullScreen = function(e) {
            if (!$scope.isFullScreen) {
                $('body').on('keypress keydown', {e: e},closeOnEscape);
                $(e.currentTarget).closest("li.grid-component-container>div.grid-component-ref").addClass("component-fullscreen");
                $(e.currentTarget).closest("li.grid-component-container").css("z-index", "10000000");
                $(e.currentTarget).closest("li.grid-component-container").css("overflow", "visible");   // for safari
                $("#container").addClass("hide-overflow");
                $(".component-body-gridster").addClass("fullscreen-overflow");
                if ($scope.reportMode === 'builder') {
                    $('.left-splitter').hide();
                    $('.right-splitter').hide();
                    $(".right-toggle-icon").addClass('visibility-hidden');
                    $(".left-toggle-icon").hide();
                    $('.component-fullscreen').css("left", $(".panel-one").width() + $(".panel-two").width() - 14);
                    $('.component-fullscreen').css("right", $("#rightCol").width());
                    $scope.toggleLeftPanel('dataset',true);
                    $scope.toggleRightPanel(undefined,true);
                    $("#colWrapper").css("position", "static");
                    if (!$scope.gridsterOpts.draggable){
                        $scope.gridsterOpts.draggable = {};
                    }
                    if (!$scope.gridsterOpts.resizable){
                        $scope.gridsterOpts.resizable = {};
                    }
                    $scope.gridsterOpts.draggable.enabled = false;
                    $scope.gridsterOpts.resizable.enabled = false;
                    $("#rightCol>.colHeader>.compButtons").css("display","none");
                    $("#rightCol").css("display","block");
                    $("#rightCol .visualization-title").addClass('fullscreen-visualization-margin');
                } else {
                    $('.component-fullscreen').css("left", "0");
                    if (customReports.appName === 'adminconsole') {
                        $('.component-fullscreen').css("top", "50px");
                    }
                    $("body").css("overflow","hidden");
                    $(e.currentTarget).closest("li.grid-component-container>div.grid-component-ref").addClass("viewer-component-fullscreen");
                }
            }
            else {
                $(".component-body-gridster").removeClass("fullscreen-overflow");
                $(e.currentTarget).closest("li.grid-component-container").css("overflow", "hidden");
                $('body').unbind('keypress keydown');
                $(e.currentTarget).closest("li.grid-component-container>div.grid-component-ref").removeClass("component-fullscreen");
                $(e.currentTarget).closest("li.grid-component-container").css("z-index", "5");
                $("#container").removeClass("hide-overflow");
                if ($scope.reportMode === 'builder') {
                    $('.left-splitter').show();
                    $('.right-splitter').show();
                    $scope.toggleLeftPanel(undefined,false);
                    $scope.toggleRightPanel(undefined,false);
                    $(".right-toggle-icon").removeClass('visibility-hidden');
                    $(".left-toggle-icon").show();
                    $("#colWrapper").css("position", "fixed");
                    $scope.gridsterOpts.draggable.enabled = true;
                    $scope.gridsterOpts.resizable.enabled = true;
                    $("#rightCol .visualization-title").removeClass('fullscreen-visualization-margin');
                    // $("#rightCol").css("display","none");
                } else {
                    $("body").css("overflow","auto");
                    $(e.currentTarget).closest("li.grid-component-container>div.grid-component-ref").removeClass("viewer-component-fullscreen");
                }
            }
            $scope.isFullScreen = !$scope.isFullScreen;
            $scope.$broadcast("gridsterItemWidthChanged",false, $scope.component.id);

            if($scope.activeComponent && $scope.activeComponent.componentId && $scope.activeComponent.componentId === $scope.component.id){
                e.preventDefault();
                e.stopPropagation();
            }
        };




     // Button Panel changes

        $scope.addButton = function() {
            if (!$scope.component.buttons) {
                $scope.component.buttons = [];
            }
            var i = $scope.component.buttons.length + 1;
            $scope.component.buttons.push({
                title : {text:"Button"+i},
                id : "button" + i,
                parentId: $scope.component.id,
                isHeaderButton: true,
                imageType:'none',
                enable:'always',
                events : [ {
                    onclick : {}
                } ]
            });
        }

        $scope.deleteButton = function(i){
            $scope.component.buttons.splice(i, 1);
        }

        $scope.upgradeButtons = function(){
            angular.forEach($scope.component.buttons,function(button,i){
                if(button.clickExpression && typeof button.clickExpression === 'string'){
                    if(button.clickExpression.substring(0, 2) !== ":="){
                        button.clickExpression = ":="+button.clickExpression;
                    }
                    var clickConfig = {
                            action: "Custom",
                            customExpression: button.clickExpression
                        };
                    button.clickExpression = clickConfig;
                }
            });
        }


        $scope.evalExpression = function(clickConfig,rowIndex,groupName) {
            if(clickConfig.action === "ShowPreview") {
                $scope.showPreview(clickConfig,rowIndex,groupName);
            } else {
                var selectedRows = $scope.cleanUpObject();
				var ctXObject = $scope.component.ctxObject;
				var evalExpr = function(expr) {
					return rpt.evalExpression({
						expression: expr,
						selectedRows: selectedRows,
						ctXObject : ctXObject
					})
				}

				if(clickConfig.callBackFn){
					//clear any url params of the shared component.
					if($scope.component.shared){
						for(var i in $scope.mergedParams){
							if(i.indexOf("Shared_") === 0){
								delete $scope.mergedParams[i]
							}
						}

						for(var j in $scope.requestParms){
							if(j.indexOf("Shared_") === 0){
								delete $scope.requestParms[i]
							}
						}
						customReportSvc.unRegisterComponetCbs($scope.component.id);
					}
					clickConfig.callBackFn(selectedRows,ctXObject);
					delete clickConfig.callBackFn;
				}


				var args = {
					expression: rpt.getButtonExpression(clickConfig, evalExpr),
					selectedRows: selectedRows,
					ctXObject : ctXObject
				}

				return rpt.evalExpression(args);
            }

        }


        $scope.evalButtonExpression=function(event, clickConfig){

            var clickType = event.type;

            if ((clickType === "dblclick" && $scope.reportMode === "viewer") || (clickType === "click" && $scope.reportMode === "builder") || clickConfig.action === "") {
                return;
            }

            if (typeof clickConfig === 'string') {
                if(clickConfig.substring(0, 2) !== ":="){
                     clickConfig = ":="+clickConfig;
                }
                clickConfig = {
                    action: "Custom",
                    customExpression: clickConfig
                };
            }


            return $scope.evalExpression(clickConfig);

        }

         $scope.cleanUpObject = function(){
            var rowsSelected = [];
            if($scope.child.selectedRows && Object.keys($scope.child.selectedRows).length > 0 ){
	            angular.forEach($scope.child.selectedRows,function(val,index){
	                /*for (var key in val) {
	                  if(key.indexOf('Attributes') !== -1 || key.indexOf('_formatted') !== -1 ){
	                      delete val[key];
	                  }
	                }*/
	                rowsSelected.push(val)
	            });
            }
            return rowsSelected;
        }

        $scope.evalButtonState = function(button){
            var retVal = false;
            if(button.enable === 'always'){
                retVal = true;
            }else if(button.enable === 'singleSelect' && $scope.child.selectedRows && Object.keys($scope.child.selectedRows).length === 1){
                retVal = true;
            }else if(button.enable === 'noRowSelected' && (typeof $scope.child.selectedRows === "undefined" || $scope.child.selectedRows && Object.keys($scope.child.selectedRows).length === 0) ){
                retVal = true;
            }else if(button.enable === 'multiSelect' && $scope.child.selectedRows && Object.keys($scope.child.selectedRows).length > 0 ){
                retVal = true;
            }else if(button.enable === 'custom'){
                var args = {};
                args["expression"] = button.disableExpression;
                args["selectedRows"] = $scope.cleanUpObject();
                retVal = rpt.evalExpression(args);
            }
            return retVal;
        }

        $scope.getTitlePlaceholder = function() {
            var component = $scope.component;
            if (component.type === 'CHART') {
                return "Untitled Chart";
            } else if (component.type === 'TABLE') {
                return "Untitled Table";
            } else if (component.type === 'PIVOT_TABLE') {
                return "Untitled Pivot Table";
            } else if (component.type === 'CUSTOM') {
                return "Untitled Custom";
            } else if (component.type === 'MAP') {
                return "Untitled Map";
            } else if (component.type === 'TAG_CLOUD') {
                return "Untitled Word Cloud";
            } else if (component.type === 'SEARCH_BAR') {
                return "Untitled Search";
            } if (component.type === 'DATE_RANGE') {
                return "Untitled Date Range";
            } if (component.type === 'HEAT_MAP') {
                return "Untitled Heat Map";
            } else if (component.type === 'SCATTER') {
                return "Untitled Scatter Plot";
            }  else if (component.type === 'KENDO_GRID') {
                return "Untitled Data Grid";
            } else if (component.type === 'FACET') {
                return "Untitled Filter Panel";
            }else if(component.type === "PANEL_HEADER") {
                return "Untitled Panel Header";
            }else if(component.type === "PANEL") {
                return "Untitled Panel";
            }
        };

        $scope.buttonStates = [];
        $scope.evalButtonStates = function(){
            angular.forEach($scope.component.buttons,function(button,i){
                $scope.buttonStates[i] = $scope.evalButtonState(button);
            });
        }

        customReportSvc.registerCallback("evalButtonsState",function(button) {
            angular.forEach($scope.component.buttons,function(val,i){
                if(val.id === button.id){
                    $scope.buttonStates[i] = $scope.evalButtonState(button);
                }
            });
        });

        customReportSvc.registerCallback("buttonRemoved",function(button) {
            angular.forEach($scope.component.buttons,function(val,i){
                if(val.id === button.id){
                    $scope.deleteButton(i);
                }
            });
            $scope.setActiveComponent($scope.component);
        });


        $scope.addToDashboard = function(data) {
            if($scope.dashboards.length === 0){
                reportService.getDataForDataSetViaProxy("reportsplusengine/datasets/4fe3336e-530e-407c-84d4-c0c4ac6d4d74/data/?fields=name,reportId,userReportId").then(function(data){
                    angular.forEach(data.data.records,function(record){
                        var db = {name:record[0],id:record[1]}
                        $scope.dashboards.push(db);
                    });
                    $scope.openDashboard();
                });
            }else{
                $scope.openDashboard();
            }
        };

        $scope.openDashboard = function(){
            $scope.cmp = {
                    "type": "IFRAME",
                    "frameType": "Report",
                    "url": dataSetUtility.requestToUrl($scope.mergedParams)+"&showComponents="+$scope.component.id,
                    "id": "Frame_"+ (new Date()).getTime(),
                    "title": {
                        "text": $scope.component.title.text
                    }
                }

            var modalInstance = $uibModal.open({
                templateUrl: customReports.contextPath + "/reportsplus/dashboards/addToDashboard.jsp",
                controller: ['$scope','dbs','component',function($scope,dbs,component){
                    $scope.dbs = dbs;

                    $scope.addCompToDb =  function(){
                        reportService.postDataForDataSetViaProxy("reportsplusengine/addToDashBoard",component).then(function(data) {
                            $scope.$close();
                                });
                    }

                    $scope.updatedashboardId = function(){
                        component.dashboardId = $scope.dashboardId;
                    }

                    $scope.callBack = function(dashboard){
                        $scope.dbs.push({name:dashboard.report.customReportName,id:dashboard.report.customReportId});
                        $scope.dashboardId = dashboard.report.customReportId;
                        component.dashboardId = $scope.dashboardId;
                    }

                    $scope.createDashboard = function(){
                        var dashboard = $scope.dashboardAction('New',undefined,$scope.callBack);
                    }
                }],
                size: "md",
                backdrop: 'static',
                keyboard: false,
                scope : $scope,
                resolve: {
                    dbs : function() {
                        return $scope.dashboards;
                    },
                    component : $scope.cmp
                }
            });
        }
        $scope.getPreviewData = function(options) {
            let formatter = options.formatter,
            rowData = options.rowData,
            columns = customReportSvc.getDeepCopy(options.columns),
            callBack = options.callBack,
            row = {},
            selCols,
            $previewHtml;
            selCols = columns;
            if(formatter.useRowData && formatter.selColumns) {
            	selCols = formatter.selColumns.filter(selCol => {
	                return columns.filter(col => {
	                    return selCol.id === col.id
	                }).length > 0;
	            });

            }

            angular.forEach(selCols,function(column) {
                let property = column.dataField;
                row[property] = rowData[column.id+'_formatted'] ?  rowData[column.id+'_formatted'] :
                (rowData[column.id] ? rowData[column.id] : (rowData[column.dataField] ? rowData[column.dataField] : ""));
            });

            if(formatter.useRestAPI) {
                let restAPI = customReportSvc.getDeepCopy(formatter.restAPI);
                if(restAPI.bodyParams) {
                    restAPI.bodyParams = rpt.evalExpression({
                         expression: restAPI.bodyParams,
                         row: row
                    });
                }

                restAPI.url = rpt.evalExpression({
                     expression:restAPI.url,
                     row: row
                });
                customReportSvc.executeRestAPI(restAPI,function(resp) {
                    $previewHtml = rpt.evalExpression({
                         expression: formatter.customHtml,
                         row: row,
                         response : resp
                    });
                    callBack($previewHtml);
                });
            } else {

                $previewHtml = rpt.evalExpression({
                    expression: formatter.customHtml,
                    row: row
                });
                callBack($previewHtml);
            }

        }

        $scope.isCustomHtmlCompPresent = function(compId) {
        	let $htmlComps =  $("li[data-component-type='CUSTOM']");
        	if($htmlComps.length > 0) {
            	let htmlCompIds = $htmlComps.map((index,$li) => {
													return $($li).attr("comp");
												});
            	return $.inArray(compId,htmlCompIds) !== -1;
            }
        	return false;
        }

        $scope.showPreview = function(rowFormatter,rowIndex,groupName) {
            let columns =  $scope.child.component.columns,
            previewCompId = rowFormatter.previewComponentId;
            if(!rowIndex)
             	rowIndex = 0;
            rowFormatter.rowIndex = rowIndex;
            if(!(previewCompId && $scope.isCustomHtmlCompPresent(previewCompId))) {
                 let modalInstance = $uibModal.open({
                    templateUrl: customReportSvc.getContextPath() + "/reportsplus/modal/views/previewModal.jsp",
                    controller: "previewModalCtrl",
                    backdrop  : 'static',
                    windowClass: (customReports.appName === 'adminconsole') ? 'previewModalWindow small-size' : 'previewModalWindow',
                    resolve: {
                        formatterOptions : function() {
                            return {
                                 columns : columns,
                                 formatter : rowFormatter
                            };
                        },
                        getPreviewData : function() {
                            return $scope.getPreviewData;
                        },
                        tableProperties :  function() {
                            let tableProperties = {};
                            if(!$.isEmptyObject($scope.child) &&  !$.isEmptyObject($scope.child.component)) {
                                if($scope.child.component.type === 'TABLE' && !$.isEmptyObject($scope.child.tableParams)) {
                                    tableProperties = $scope.child.tableParams;
                                    tableProperties.propertiesToMap = {
                                        totalPageCnt : "lastPageNo",
                                        pageSize : "count",
                                        tableData : "data"
                                    };

                                }  else if($scope.child.component.type === 'TABLE' && !$.isEmptyObject($scope.child.kendoGrid.dataSource)) {
                                	let groupDataSources = $scope.child.kendoGrid.dataSource.groupDataSources;
                                    tableProperties = groupName && !$.isEmptyObject(groupDataSources) ? groupDataSources[groupName] : $scope.child.kendoGrid.dataSource;
                                    tableProperties["propertiesToMap"] = {
                                        totalPageCnt : "totalPages",
                                        pageSize : "_pageSize",
                                        tableData : "_data"
                                    };

                                }else if(($scope.child.component.type === 'KENDO_GRID' || $scope.child.component.type === "KENDO_TREEGRID") && !$.isEmptyObject($scope.child.kendoDataSource)) {
                                	let groupDataSources = $scope.child.kendoDataSource.groupDataSources;
                                    tableProperties = groupName && !$.isEmptyObject(groupDataSources) ? groupDataSources[groupName] : $scope.child.kendoDataSource;
                                    tableProperties["propertiesToMap"] = {
                                        totalPageCnt : "totalPages",
                                        pageSize : "_pageSize",
                                        tableData : "_data"
                                    };

                                }
                            }
                            return tableProperties;

                        }
                    }
                });


           } else {

            let $custmHtmlWrapper = $("li[comp='"+previewCompId+"'] #"+previewCompId),
            padding=40,
            compBodyHeight = $("li[comp='"+previewCompId+"'] .component-body").height() - padding,
            data = {};

            if($scope.child.component.type === 'TABLE' && $scope.child.tableParams)
                 data = $scope.child.tableParams.data;
            else if($scope.child.component.type === 'TABLE' && !$.isEmptyObject($scope.child.kendoGrid.dataSource)) {
            	let groupDataSources = $scope.child.kendoGrid.dataSource.groupDataSources;
                data = groupName && !$.isEmptyObject(groupDataSources) ? groupDataSources[groupName]._data : $scope.child.kendoGrid.dataSource._data;
            }
            else if(($scope.child.component.type === 'KENDO_GRID' || $scope.child.component.type === "KENDO_TREEGRID") && !$.isEmptyObject($scope.child.kendoDataSource)) {
                let groupDataSources = $scope.child.kendoDataSource.groupDataSources;
                data = groupName && !$.isEmptyObject(groupDataSources) ? groupDataSources[groupName]._data : $scope.child.kendoDataSource._data;
             }



            let options =  {
                formatter : rowFormatter,
                rowData : data[rowIndex],
                columns : columns,
                callBack : callBack
            };
            $custmHtmlWrapper.addClass("previewCompStyle").height(compBodyHeight);
            $custmHtmlWrapper.html('<div class="loadingMsg"><span>'+localMsg.LoadingPreview+'</span></div>');
            $scope.getPreviewData(options);

            function callBack($previewHtml) {
               try {
                    $previewHtml = $sanitize($previewHtml);
                } catch(e) {
                    $previewHtml = $previewHtml;
                }
               $custmHtmlWrapper.html($previewHtml);
            }
         }

        }

        $scope.BindClickEventToPreviewLink = function(element){
			$(element).off("click","a.previewLinkCol").on("click","a.previewLinkCol",function($event) {
				$event.stopPropagation();
				let formatter = JSON.parse(Base64.decode($(this).data("formatter"))),
				rowIndex = $(this).data("rowIndex"),
				$groupingRow = $(this).parents(".groupingrow"),
				groupName;
				if($groupingRow.length !== 0)
				  groupName = $groupingRow.data("groupName");

				if($scope.component.type === "TABLE" && $scope.child.grouped && $scope.child.component.group[0].field){
					groupName = $scope.child.component.group[0].field;
				}
				$scope.showPreview(formatter,rowIndex,groupName);
			});
        }

        $scope.handleTableRowSelection = function($event,rowIndex,groupName,$selRow) {
        	let comp = $scope.child.component;
        	if(!comp.rowFormatter || $($event.target).hasClass("column-link"))
				return;
            $('li[comp="' + comp.id + '"] table tr').removeClass('selRowStyle');
            ($selRow || $($event.currentTarget)).addClass("selRowStyle");
            $scope.evalExpression(comp.rowFormatter,rowIndex,groupName);
        }

        customReportSvc.registerCallback("validateComponentVisibility",function(){
            $scope.applyConditionalComponentVisibility();
        },$scope.component.id);


        customReportSvc.registerCallback("redrawAllComponents", function (componentId) {
        	if($scope.component.title && $scope.component.title.text){
        		$scope.componentTitle = rpt.evalExpression({expression:$scope.component.title.text});
        	}
        });

    }]);



    // Filter to display whether a report is default or the current page
    // Used in report properties panel to choose which page to view
    app.filter('displayDefault', function() {
        return function(page, scope) {
            if (page.isDefault === true) {
                return page.pageTitle.text + " (Default Page)";
            } else if (page.pageName == scope.page.pageName) {
                return page.pageTitle.text + " (Current Page)";
            } else {
                return page.pageTitle.text;
            }
        }
    });
})();

//this is function that gets called from workflow to clear the cache of the report if needed.
window.clearCacheNow = function(){
    rpt.reload();
}

