<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
		<div data-ng-if="input.allowMultipleSelection" class="select-all-wrapper">
			<label data-ng-if="viewSelected && selected.options.length>0" class="selected-label"><fmt:message key="CustomReport.MultiSelect.Selected"/></label>
			<div class="pull-right" >
				<label for="{{input.id}}-all" ><fmt:message key="CustomReport.MultiSelect.SelectAll"/></label>
				<div id="{{input.id}}-all" class="cv-material-toggle cv-toggle" data-ng-class="{'enabled':(allSelected), 'isOff':(!allSelected)}" title="<fmt:message key="CustomReport.MultiSelect.SelectAllToolTip"/>">
					<div class="cv-material-toggle-bar" data-ng-click="handleSelectAll(true)" ></div>
					<div class="cv-material-toggle-round" data-ng-click="handleSelectAll(true)"></div>
					</div>
			</div>
		</div>
		<div class="select-options-wrapper">
			<div class="select-options multi-select" data-ng-if="input.allowMultipleSelection">
				<div data-ng-if="viewSelected && selected.options.length>0" class="multi-select-option-panel multi-selected" >
					<div class="multi-select-option selected" data-ng-repeat="option in selected.options" title="{{option['label']}}">
						<label for="{{input.id}}-cv-multi-option-selected-{{$index}}" class="multi-option-selected-label">{{option['label']}}</label>
						<span class="remove-selection" data-ng-click="removeSelection($event, option, false)" title="<fmt:message key="remove"/> {{option['label']}}">&times;</span>
					</div>
				</div>
				<div class="multi-select-option-panel" >
					<div class="multi-select-option-panel-right">
						<div class="multi-select-option" data-ng-repeat="option in options" title="{{option['label']}}">
							<input id="{{input.id}}-cv-multi-option-{{$index}}" type="checkbox" checklist-value="option" checklist-model="selected.options" data-ng-click="updateSelection(option,checked)"><label for="{{input.id}}-cv-multi-option-{{$index}}" class="multi-select-option-label">{{option['label']}}</label>
						</div>
					</div>
				</div>

			</div>
			<div class="select-options single-select" data-ng-if="!input.allowMultipleSelection">
				<ul class="radioInputs" data-ng-if="input.controlType === 'RadioButton'" >
						<li data-ng-click="updateSelection(option)" title="{{option['label']}}" data-ng-repeat="option in options"><input id="cv-radio-{{input.id}}-{{$index}}" type="radio" name="{{input.id}}" data-ng-model="input.value" value="{{option['value']}}" data-ng-change="reloadDependendentInputs(input.id)"><label for="cv-radio-{{input.id}}-{{$index}}" class="multi-select-option-label">{{option['label']}}</label></li>
				</ul>
				<div class="single-select-option" data-ng-repeat="option in options">
					<div class="single-select-wrap" data-ng-class="{'selected':option.value === selected.options[0].value}" data-ng-if="input.controlType !== 'RadioButton'" data-ng-click="updateSelection(option)" title="{{option['label']}}">
						<label for="{{input.id}}-cv-single-option-{{$index}}">{{option['label']}}<span data-ng-if="option.value === selected.options[0].value" class="glyphicon glyphicon-ok pull-right icon-ok" aria-hidden="true"></span></label>
					</div>
				</div>
			</div>
			<div class="record-info" data-ng-if="fetchedRecordCount !== totalRecordCount || applyingWhereCondition" >
				<!-- <div class="record-count">Showing {{filteredRecordCount}}  of {{totalRecordCount}}</div> -->
				<span data-ng-if="input.allowMultipleSelection && selected.options.length>0 && !applyingWhereCondition" class="pull-left"><a class="btn-link" data-ng-click="handleViewSelected($event)" ng-bind="viewSelected? '<fmt:message key="CustomReport.MultiSelect.HideSelected"/>':'<fmt:message key="CustomReport.MultiSelect.ViewSelected"/>'"></a></span>
				<span class="pull-right"><a class="btn-link" data-ng-click="getNextpage()"><fmt:message key="CustomReport.MultiSelect.LoadMore"/></a></span>
			</div>
		</div>
</fmt:bundle>