// Closure to isolate scope, as per best practices
//To do: Use localisation for DateRange dropdown option and units. Rename the unit in accordance with reportInputModal.js
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var reports = angular.module("reports");
	reports.directive("cvRptDateRangePicker", function() {
		return {
			restrict : 'AEC',
			templateUrl : customReports.contextPath +
					'/reportsplus/inputs/cvRptDateRangePicker/cvRptDateRangePicker.jsp',
			controller : 'cvRptDateRangePickerCtrl'
		};
	});

	reports
			.controller('cvRptDateRangePickerCtrl',
					[
							"$scope",
							"reportService",
							"customReportSvc",
							"$timeout",
							function($scope, reportService, customReportSvc, $timeout) {
								$scope.setChildScope($scope);
								$scope.showTimeRangeOptions = false;
								$scope.showCustomRelativeOptions = 'Relative';
								$scope.hideAllRelativeOptions = false;
								if ($scope.input.relativeOptions.length > 1 ||
										($scope.input.relativeOptions.length === 1 && $scope.input.relativeOptions[0] === "Custom")) {
									$scope.showCustomRelativeOptions = 'Custom';
									$scope.showTimeRangeOptions = true;
								}

								if ($scope.input.relativeOptions.length === 1 &&
										$scope.input.relativeOptions[0] === "Custom") {
									$scope.hideAllRelativeOptions = true;
								}

								$scope.showCustomDateOptions = $scope.input.relativeOptions.length > 1;
								$scope.getCurrentDate = function() {
									var d = new Date();
									if (!$scope.input.includeTime) {
										d.setHours(0, 0, 0, 0);
									}
									return d;
								}
								$scope.inputDate = {
									fromDate : $scope.getCurrentDate(),
									fromLabel : null,
									toDate : $scope.getCurrentDate(),
									toLabel : null
								}

								$scope.numericOptions = {
									format : "#",
									decimals : 0
								}

								$scope.dropdownIsOpen = false;
								$scope.relativeValues = [];

								$scope.customRelativeOptions = [];
								$scope.customRelativeUnits = [];

								$scope.customRelative = {
									relativeUnit : null,
									relativeOption : null,
									relativeValue : 1
								};

								$scope.fromOptions = {
									showWeeks : false,
									minDate : null,
									maxDate : new Date()
								};
								$scope.toOptions = {
									showWeeks : false,
									minDate : $scope.inputDate.fromDate,
									maxDate : new Date()

								};

								$scope.clearSelection = function() {
									$scope.input.value = '';
									$scope.inputDate.fromDate = $scope.getCurrentDate();
									$scope.inputDate.fromLabel = null;
									$scope.inputDate.toDate = $scope.getCurrentDate();
									$scope.inputDate.toLabel = null;
									$scope.resetSelectedValues();
								}

								$scope.relativeLabels = {
 									"Minutes" : localMsg.customReport.minutes,
									"Weeks" : localMsg.customReport.weeks,
									"Quarters" : localMsg.customReport.quarters,
									"Years" : localMsg.customReport.years,
									"Months" : localMsg.customReport.months,
									"Days" : localMsg.customReport.days,
									"Hours" : localMsg.customReport.hours
								};

								$scope.unitLabels = {
									"Previous" : localMsg.customReport.Previous,
									"Last" : localMsg.customReport.Last,
									"Next" : localMsg.customReport.Next
								};

								$scope.relativeOptions = {
									"Minutes" : "m",
									"Weeks" : "W",
									"Quarters" : "Q",
									"Years" : "Y",
									"Months" : "M",
									"Days" : "D",
									"Hours" : "H"
								};

								$scope.defaultValues = {
									"Minutes" : 10,
									"Weeks" : 4,
									"Quarters" : 1,
									"Years" : 1,
									"Months" : 3,
									"Days" : 7,
									"Hours" : 24
								};

								$scope.relativeUnitOptions = {
									"m" : "Minutes",
									"W" : "Weeks",
									"Y" : "Years",
									"M" : "Months",
									"D" : "Days",
									"H" : "Hours"
								};

								$scope.unitOptions = {
									"Previous" : "-R",
									"Last" : "-P",
									"Next" : "P"
								};

								$scope.formatDate = function(date) {
									return rpt.formatDateTime(moment(date).format('MMM D, YYYY hh:mm:ss A'));
								}

								$scope.initCustomRealtiveUnits = function(relativeOption) {
									if (!$scope.customRelative.relativeUnit && relativeOption) {
										$scope.customRelative.relativeUnit = relativeOption;
									}
									if ($scope.unitOptions[relativeOption]) {
										$scope.customRelativeUnits.push(relativeOption);
									}
								}

								$scope.initCustomRealtiveOptions = function(relativeOption) {
									if (!$scope.customRelative.relativeOption) {
										$scope.customRelative.relativeOption = relativeOption;
									}
									if ($scope.relativeOptions[relativeOption] && !$scope.customRelativeOptions.includes(relativeOption)) {
										$scope.customRelativeOptions.push(relativeOption);
									}
								}
								$scope.getrelativeOption = function(relativeUnit, relativeOption, value) {
									var str = $scope.unitOptions[relativeUnit];
									var labelStr = relativeUnit;
									var endstring = str == "-R" ? "R0D" : "P0D";
									if ([ "Hours", "Minutes" ].indexOf(relativeOption) !== -1) {
										str = str + "T";
									}
									str = str + value + $scope.relativeOptions[relativeOption];
									str = str + " " + endstring;
									labelStr = $scope.unitLabels[labelStr] + " " + value + " ";
									labelStr += value == 1 ? $scope.relSingularLabelOptions[$scope.relativeOptions[relativeOption]] : $scope.relativeLabels[relativeOption];

									return {
										value : str,
										label : labelStr
									};
								}

								$scope.relLabelOptions = {
									"m" : localMsg.customReport.Minutes,
									"W" : localMsg.customReport.Weeks,
									"Q" : localMsg.customReport.Quarters,
									"Y" : localMsg.customReport.Years,
									"M" : localMsg.customReport.Months,
									"D" : localMsg.customReport.Days,
									"H" : localMsg.customReport.Hours
								};

								$scope.relSingularLabelOptions = {
									"m" : localMsg.customReport.Minute,
									"W" : localMsg.customReport.Week,
									"H" : localMsg.customReport.Hour,
									"D" : localMsg.customReport.Day,
									"M" : localMsg.customReport.Month,
									"Q" : localMsg.customReport.Quarter,
									"Y" : localMsg.customReport.Year
								};

								$scope.buildRelativeOptions = function() {
									// build possible relative options from the selections and the custom relative options.
									for ( var i in $scope.input.relativeOptions) {
										var relativeUnit = $scope.input.relativeOptions[i];
										if(relativeUnit === 'Next'){
											$scope.fromOptions.maxDate = null;
											$scope.toOptions.maxDate = null;
										}
										$scope.initCustomRealtiveUnits(relativeUnit);
										if (Object.keys($scope.unitOptions).indexOf(relativeUnit) !== -1) {
											for ( var j in $scope.input.relativeUnits) {
												var relativeOption = $scope.input.relativeUnits[j];
												if(relativeUnit=="Previous"){
													if(relativeOption == "Hours" || relativeOption == "Minutes" ){
														continue;
													}
												}else if(relativeOption == "Quarters"){
													continue;
												}
												$scope.initCustomRealtiveOptions(relativeOption);

												var relative = $scope.getrelativeOption(relativeUnit,
														relativeOption,
														$scope.defaultValues[relativeOption]);

												$scope.relativeValues.push({
													value : relative.value,
													label : relative.label,
													selected : false
												});
											}
										}
									}

									// if relative options are selected over ride them
									if ($scope.input.possibleValues && $scope.input.possibleValueLabels &&
											$scope.input.possibleValues.length > 0 &&
											$scope.input.possibleValueLabels.length > 0) {
										var a = _.map($scope.input.possibleValues, function(val) {
											return {
												value : val,
												selected : false
											};
										});
										var createdRelativeLabel;
										var b = _.map($scope.input.possibleValues, function(val) {
											createdRelativeLabel = customReportSvc.getRelativeLabel(val);
											return {
												label : createdRelativeLabel
											};
										});
										$scope.relativeValues = _.merge(a, b);
									}

									if ($scope.input.relativeOptions.indexOf('Custom') !== -1) {
										$scope.relativeValues.push({
											value : 'custom',
											label : localMsg.customReport.Custom,
											selected : false
										});
									}
									$scope.changeCustomRelativeOptions($scope.customRelative.relativeUnit,$scope.customRelative.relativeOption);
									$scope.initialize();
								}

								$scope.initialize = function() {
									if ($scope.input.value) {

										var opt = _.find($scope.relativeValues, {
											'value' : $scope.input.value
										});
										if (opt) {
											opt.selected = true;
											$scope.inputLabel = opt.value !== 'custom' ? opt.label : $scope.inputLabel;
											if (opt.value !== 'custom') {
												$scope.showTimeRangeOptions = false;
											}
										} else {
											$scope.showTimeRangeOptions = true;
											opt = _.find($scope.relativeValues, {
												'value' : 'custom'
											});
											opt.selected = true;

											var isCustom = !($scope.input.value.startsWith('-P') || $scope.input.value
													.startsWith('P') || $scope.input.value.startsWith('-R')) ? true : false;
											if (isCustom) {
												$scope.showCustomRelativeOptions = "Custom";
												var x = $scope.input.value.split(' ');
												$scope.inputDate.fromDate = moment(x[0]).seconds(0);
												$scope.inputDate.toDate = moment(x[1]).seconds(0);
												$scope.showTimeRangeOptions = true;
												$scope.inputDate.fromLabel = $scope
														.formatDate($scope.inputDate.fromDate);
												$scope.inputDate.toLabel = $scope.formatDate($scope.inputDate.toDate);
												$scope.inputLabel = $scope.inputDate.fromLabel + ' ' +
														$scope.inputDate.toLabel;
											} else {
												$scope.showCustomRelativeOptions = "Relative";
												var times = $scope.input.value.split(" ");
												var timeStart = times[0]
												var timeEnd = times[1];

												//Checking index of P in available options ('P','-P','-R') so as to decide the relativeUnit
												switch(timeStart.indexOf("P")){
													case 1:
														$scope.customRelative.relativeUnit = "Last";
														break;
													case 0:
														$scope.customRelative.relativeUnit = "Next";
														break;
													case -1:
														$scope.customRelative.relativeUnit = "Previous";
														break;
												}
												var timeValue = $scope.customRelative.relativeUnit === "Next" ? timeEnd : timeStart;
												var startIndex = timeValue.indexOf("P") == 0 ? 1 : 2;
												var endIndex = 1;
												var isTimeUnit = timeValue.indexOf("T") !== -1 ? true : false;
												$scope.customRelative.relativeOption = timeValue
														.substring(timeValue.length - endIndex);
												$scope.customRelative.relativeOption = $scope.relativeUnitOptions[$scope.customRelative.relativeOption];
												if (isTimeUnit) {
													startIndex++;
													if ($scope.customRelative.relativeOption == "Months") {
														$scope.customRelative.relativeOption = "Minutes";
													}
												}
												$scope.customRelative.relativeValue = parseInt(timeValue
														.substring(startIndex, timeValue.length - endIndex));
												$scope.inputLabel = $scope.customRelative.relativeUnit + ' ' +
														$scope.customRelative.relativeValue + ' ' +
														$scope.customRelative.relativeOption;

											}

										}

									}

								}

								$scope.resetSelectedValues = function() {
									_.map($scope.relativeValues, function(val) {
										val.selected = false;
									});
								}

								$scope.updateTimeRangeValue = function(rValue) {
									$scope.resetSelectedValues();
									rValue.selected = true;
									if (rValue.value !== "custom") {
										$scope.valueSelected = true;
										$scope.showTimeRangeOptions = false;
										$scope.input.value = rValue.value;
										$scope.inputLabel = rValue.label;
										$scope.status.isopen = false;
										$scope.checkAndReloadDependents(true);
									} else {
										$scope.showTimeRangeOptions = true;
									}
								}

								$scope.customTimeRangeChanged = true;
								$scope.$watch('inputDate.fromDate', function() {
									$scope.customTimeRangeChanged = true;
									$scope.inputDate.fromLabel = $scope.formatDate($scope.inputDate.fromDate);
									$scope.toOptions.minDate = $scope.inputDate.fromDate;
								});

								$scope.$watch('inputDate.toDate', function() {
									$scope.customTimeRangeChanged = true;
									$scope.inputDate.toLabel = $scope.formatDate($scope.inputDate.toDate);
								});

								$scope.$watch('customRelative', function(customRelative) {
									$scope.customTimeRangeChanged = false;
								});

								$scope.applyCustomRange = function() {
									$scope.valueSelected = true;

									if ($scope.showCustomRelativeOptions === 'Custom') {

										if ($scope.inputDate.fromDate === null || $scope.inputDate.toDate === null) {
											customReportSvc.errorToast(localMsg.customReport.InvalidDate);
											return;
										}

										if ($scope.inputDate.fromDate > $scope.inputDate.toDate) {
											customReportSvc.errorToast(localMsg.customReport.InvalidDateRangeError);
											return;
										}

										$scope.input.value = $scope.inputDate.fromDate.toISOString().split('.')[0] +
												'Z' + " " + $scope.inputDate.toDate.toISOString().split('.')[0] + 'Z';
										$scope.inputLabel = $scope.inputDate.fromLabel + ' ' + $scope.inputDate.toLabel;
									} else {
										var relative = $scope.getrelativeOption($scope.customRelative.relativeUnit,
												$scope.customRelative.relativeOption,
												$scope.customRelative.relativeValue);
										$scope.input.value = relative.value;
										$scope.inputLabel = relative.label;
									}
									$scope.status.isopen = false;
									$scope.checkAndReloadDependents(true);

								}

								$scope.clearTimeRange = function() {
									$scope.inputDate.fromDate = null;
									$scope.inputDate.toDate = null;
								}

								$scope.hiddenLabelsForPrevious = ["Hours","Minutes"];
								$scope.removeRelativeUnits = function (relativeOption){
									if( $scope.hiddenLabelsForPrevious.includes(relativeOption) ) {
										return true;
									}
								}
								$scope.changeCustomRelativeOptions = function(relativeUnit,selectedRelativeOption){
									var reloadRequired = false;
									if(relativeUnit == "Previous"){
										_.remove($scope.customRelativeOptions,$scope.removeRelativeUnits);
										if($scope.hiddenLabelsForPrevious.includes(selectedRelativeOption)){
											reloadRequired = true;
										}
										if( $scope.input.relativeUnits.includes("Quarters") && !$scope.customRelativeOptions.includes("Quarters") ){
											var optionQuarterIndex = -1;
											$scope.customRelativeOptions.splice(optionQuarterIndex,0,"Quarters");
										}
									}else{
										_.remove($scope.customRelativeOptions,function(relOption){return relOption == "Quarters"});
										if(selectedRelativeOption == "Quarters"){
											reloadRequired = true;
										}
										for (var hiddenLabel of $scope.hiddenLabelsForPrevious){
											if( $scope.input.relativeUnits &&  $scope.input.relativeUnits.length > 0 &&  $scope.input.relativeUnits.includes(hiddenLabel) && !$scope.customRelativeOptions.includes(hiddenLabel)){
												$scope.customRelativeOptions.unshift(hiddenLabel);
											}
										}
									}
									if(reloadRequired){
										$scope.customRelative.relativeOption = $scope.customRelativeOptions[0];
									}
								}

								$scope.$watch('customRelative', function(customRelative) {
									$scope.customTimeRangeChanged = false;
								});

								$scope.buildRelativeOptions();
							} ]);

})();