<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
        <span class="ico ico-form-field"></span>
    </li>
    <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
        <span class="ico ico-code"></span>
    </li>
</ul>

<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>

<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'">
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
          <div class="form-group">
              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
              <div class="col-sm-8 noLftRghtPadding">
                  <input class="form-control input-sm"
                     data-ng-model="propData.title.text"
                       type="text" readonly="true"
                       placeholder="<fmt:message key='CustomReport.Properties.ComponentName'/>">
              </div>
          </div>                 
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
          <div class="form-group">
              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
              <div class="col-sm-8 noLftRghtPadding">
                  <input class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" 
                   data-ng-change="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">            
              </div>
              <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize
          </div>                           
		  <label><fmt:message key="CustomReport.Properties.ID"/>
            <input class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" 
                   data-ng-change="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
            <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize -->   
        </div>
    </div>
    </div>
    <!-- <pre style="white-space: pre-wrap;">{{propData.topologyProps}}</pre> -->
    <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
        <div class="fieldHeader"
            data-ng-click="collapsed['propData.topologyProps.nodes']=!collapsed['propData.topologyProps.nodes']" data-ng-init="collapsed['propData.topologyProps.nodes']=true">
            <label class="col-lg-9 noLftRghtPadding"> <span><fmt:message key="CustomReport.Properties.Topology.Nodes"/></span>
            </label> <span class="pull-right"> <span
                class="ico inner-panel-expand-icon"
                data-ng-class="{'ico ico-chevron-down':!collapsed['propData.topologyProps.nodes'], 'ico ico-chevron-right':collapsed['propData.topologyProps.nodes']}"></span>
            </span>
        </div>
        <div data-ng-class="{'collapsed' : collapsed['propData.topologyProps.nodes']}">
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <input class="form-control input-sm" type="text" placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>" readonly="true" data-ng-model="propData.topologyProps.nodes.dataSet.dataSetName">
                    </div>
                </div>
            </div>
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label
                        class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                        title='<fmt:message key="CustomReport.Properties.Topology.Nodes.Id"/>'><fmt:message
                            key="CustomReport.Properties.Topology.Nodes.Id" /> </label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <select class="form-control" id="nodesIdSelect" data-ng-model="propData.topologyProps.nodes.id" data-ng-change="updateChart(false)"
                            data-ng-options="field.name for field in nodesDS.fields track by field.name">
                        </select>
                    </div>
                </div>
            </div>
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label
                        class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                        title='<fmt:message key="CustomReport.Properties.Topology.Nodes.Label"/>'><fmt:message
                            key="CustomReport.Properties.Topology.Nodes.Label" />
                        </label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <select class="form-control" id="nodesLabelSelect" data-ng-model="propData.topologyProps.nodes.label" data-ng-change="updateChart(false)"
                            data-ng-options="field.name for field in nodesDS.fields track by field.name">
                        </select>
                    </div>
                </div>
            </div>
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label
                        class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                        title='<fmt:message key="CustomReport.Properties.Topology.Nodes.CustomLabel"/>'><fmt:message
                            key="CustomReport.Properties.Topology.Nodes.CustomLabel" />
                        </label>
                    <div class="col-sm-8 noLftRghtPadding" data-ng-class="{'input-group': !propData.topologyProps.nodes.labelExpr || propData.topologyProps.nodes.labelExpr.length < 20}">
                        <input data-ng-show="!propData.topologyProps.nodes.labelExpr || propData.topologyProps.nodes.labelExpr.length < 20" focus-on-show class="form-control input-sm" type="text"
                            data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}" data-ng-model="propData.topologyProps.nodes.labelExpr">
                        <textarea data-ng-show="propData.topologyProps.nodes.labelExpr.length >= 20" focus-on-show data-ng-model="propData.topologyProps.nodes.labelExpr" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"
                            rows="5"></textarea>
                        <span class="input-group-addon" data-ng-class="{expanded: propData.topologyProps.nodes.labelExpr.length >= 20}" id="basic-addon1" ng-click="insertTopologyVariable('nodes', 'labelExpr')">f(x)</span>
                    </div>
                </div>
            </div>
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label
                        class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                        title='<fmt:message key="CustomReport.Properties.Topology.Nodes.Tooltip"/>'><fmt:message
                            key="CustomReport.Properties.Topology.Nodes.Tooltip" />
                        </label>
                    <div class="col-sm-8 noLftRghtPadding" data-ng-class="{'input-group': !propData.topologyProps.nodes.tooltip || propData.topologyProps.nodes.tooltip.length < 20}">
                        <input data-ng-show="!propData.topologyProps.nodes.tooltip || propData.topologyProps.nodes.tooltip.length < 20" focus-on-show class="form-control input-sm" type="text"
                                data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}" data-ng-model="propData.topologyProps.nodes.tooltip">
                        <textarea data-ng-show="propData.topologyProps.nodes.tooltip.length >= 20" focus-on-show data-ng-model="propData.topologyProps.nodes.tooltip" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"
                                rows="5"></textarea>
                        <span class="input-group-addon" data-ng-class="{expanded: propData.topologyProps.nodes.tooltip.length >= 20}" id="basic-addon1" ng-click="insertTopologyVariable('nodes', 'tooltip')">f(x)</span>
                    </div>
                </div>
            </div>
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label
                        class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                        title='<fmt:message key="CustomReport.Properties.Topology.Nodes.Shape"/>'><fmt:message
                            key="CustomReport.Properties.Topology.Nodes.Shape" />
                        <!-- TODO: Localize --></label>
                    <div class="col-sm-8 noLftRghtPadding" data-ng-class="{'input-group': !propData.topologyProps.nodes.shape || propData.topologyProps.nodes.shape.length < 20}">
                        <input data-ng-show="!propData.topologyProps.nodes.shape || propData.topologyProps.nodes.shape.length < 20" focus-on-show class="form-control input-sm" type="text"
                            data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}" data-ng-model="propData.topologyProps.nodes.shape">
                        <textarea data-ng-show="propData.topologyProps.nodes.shape.length >= 20" focus-on-show data-ng-model="propData.topologyProps.nodes.shape" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"
                            rows="5"></textarea>
                        <span class="input-group-addon" data-ng-class="{expanded: propData.topologyProps.nodes.shape.length >= 20}" id="basic-addon1" ng-click="insertTopologyVariable('nodes', 'shape')">f(x)</span>
                    </div>
                </div>
            </div>
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label
                        class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                        title='<fmt:message key="CustomReport.Properties.Topology.Nodes.ImageUrl"/>'><fmt:message
                            key="CustomReport.Properties.Topology.Nodes.ImageUrl" />
                        </label>
                    <div class="col-sm-8 noLftRghtPadding" data-ng-class="{'input-group': !propData.topologyProps.nodes.image || propData.topologyProps.nodes.image.length < 20}">
                        <input data-ng-show="!propData.topologyProps.nodes.image || propData.topologyProps.nodes.image.length < 20" focus-on-show class="form-control input-sm" type="text" 
                                data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"  data-ng-model="propData.topologyProps.nodes.image">
                        <textarea data-ng-show="propData.topologyProps.nodes.image.length >= 20" focus-on-show data-ng-model="propData.topologyProps.nodes.image" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}" data-ng-model-options="{debounce: 500}"
                                rows="5"></textarea>
                        <span class="input-group-addon" data-ng-class="{expanded: propData.topologyProps.nodes.image.length >= 20}" id="basic-addon1" ng-click="insertTopologyVariable('nodes', 'image')">f(x)</span>
                    </div>
                </div>
            </div>
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label
                        class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                        title='<fmt:message key="CustomReport.Properties.Color"/>'><fmt:message
                            key="CustomReport.Properties.Color" />
                        </label>
                    <div class="col-sm-8 noLftRghtPadding" data-ng-class="{'input-group': !propData.topologyProps.nodes.color || propData.topologyProps.nodes.color.length < 20}">
                        <input data-ng-show="!propData.topologyProps.nodes.color || propData.topologyProps.nodes.color.length < 20" focus-on-show class="form-control input-sm" type="text"
                                data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"  data-ng-model="propData.topologyProps.nodes.color">
                        <textarea data-ng-show="propData.topologyProps.nodes.color.length >= 20" focus-on-show data-ng-model="propData.topologyProps.nodes.color" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"
                                rows="5"></textarea>
                        <span class="input-group-addon" data-ng-class="{expanded: propData.topologyProps.nodes.color.length >= 20}" id="basic-addon1" ng-click="insertTopologyVariable('nodes', 'color')">f(x)</span>
                    </div>
                </div>
            </div>
            <div class="row noLftRghtMargin">
                <div class="form-group">
                    <label
                        class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                        title='<fmt:message key="CustomReport.Properties.Topology.Nodes.Size"/>'><fmt:message
                            key="CustomReport.Properties.Topology.Nodes.Size" />
                        </label>
                    <div class="col-sm-8 noLftRghtPadding" data-ng-class="{'input-group': !propData.topologyProps.nodes.size || propData.topologyProps.nodes.size.length < 20}">
                        <input data-ng-show="!propData.topologyProps.nodes.size || propData.topologyProps.nodes.size.length < 20" focus-on-show class="form-control input-sm" type="text"
                                data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"  data-ng-model="propData.topologyProps.nodes.size">
                        <textarea data-ng-show="propData.topologyProps.nodes.size.length >= 20" focus-on-show data-ng-model="propData.topologyProps.nodes.size" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}" 
                                rows="5"></textarea>
                        <span class="input-group-addon" data-ng-class="{expanded: propData.topologyProps.nodes.size.length >= 20}" id="basic-addon1" ng-click="insertTopologyVariable('nodes', 'size')">f(x)</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
        <div class="fieldHeader"
            data-ng-click="collapsed['propData.topologyProps.edges']=!collapsed['propData.topologyProps.edges']" data-ng-init="collapsed['propData.topologyProps.edges']=true">
            <label class="col-lg-9 noLftRghtPadding"> <span><fmt:message key="CustomReport.Properties.Topology.Edges"/></span>
            </label> <span class="pull-right"> <span
                class="ico inner-panel-expand-icon"
                data-ng-class="{'ico ico-chevron-down':!collapsed['propData.topologyProps.edges'], 'ico ico-chevron-right':collapsed['propData.topologyProps.edges']}"></span>
            </span>
        </div>
        <div data-ng-class="{'collapsed' : collapsed['propData.topologyProps.edges']}">
            <div id="pointsToPlot">
                <div class="row noLftRghtMargin">
                    <div class="form-group">
                        <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
                        <div class="col-sm-8 noLftRghtPadding">
                            <input class="form-control input-sm" type="text" placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>" readonly="true" data-ng-model="propData.topologyProps.edges.dataSet.dataSetName">
                        </div>
                    </div>
                </div>
                <div class="row noLftRghtMargin">
                    <div class="form-group">
                        <label
                            class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                            title='<fmt:message key="CustomReport.Properties.Topology.Edges.From"/>'><fmt:message
                                key="CustomReport.Properties.Topology.Edges.From" /> <!-- TODO: Localize --></label>
                        <div class="col-sm-8 noLftRghtPadding">
                            <select class="form-control" id="edgesFromSelect" data-ng-model="propData.topologyProps.edges.from" data-ng-change="updateChart(false)"
                                data-ng-options="field.name for field in edgesDS.fields track by field.name">
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row noLftRghtMargin">
                    <div class="form-group">
                        <label
                            class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                            title='<fmt:message key="CustomReport.Properties.Topology.Edges.To"/>'><fmt:message
                                key="CustomReport.Properties.Topology.Edges.To" />
                            </label>
                        <div class="col-sm-8 noLftRghtPadding">
                            <select class="form-control" id="edgesToSelect" data-ng-model="propData.topologyProps.edges.to" data-ng-change="updateChart(false)"
                                data-ng-options="field.name for field in edgesDS.fields track by field.name">
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row noLftRghtMargin">
                    <div class="form-group">
                        <label
                            class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                            title='<fmt:message key="CustomReport.Properties.Topology.Edges.CustomLabel"/>'><fmt:message
                                key="CustomReport.Properties.Topology.Edges.CustomLabel" />
                            </label>
                        <div class="col-sm-8 noLftRghtPadding" data-ng-class="{'input-group': !propData.topologyProps.edges.labelExpr || propData.topologyProps.edges.labelExpr.length < 20}">
                            <input data-ng-show="!propData.topologyProps.edges.labelExpr || propData.topologyProps.edges.labelExpr.length < 20" focus-on-show class="form-control input-sm"
                                    type="text" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}" data-ng-model="propData.topologyProps.edges.labelExpr">
                            <textarea data-ng-show="propData.topologyProps.edges.labelExpr.length >= 20" focus-on-show data-ng-model="propData.topologyProps.edges.labelExpr" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"
                                    rows="5"></textarea>
                            <span class="input-group-addon" data-ng-class="{expanded: propData.topologyProps.edges.labelExpr.length >= 20}" id="basic-addon1" ng-click="insertTopologyVariable('edges', 'labelExpr')">f(x)</span>
                        </div>
                    </div>
                </div>
                <div class="row noLftRghtMargin">
                    <div class="form-group">
                        <label
                            class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                            title='<fmt:message key="CustomReport.Properties.Topology.Edges.Arrows"/>'><fmt:message
                                key="CustomReport.Properties.Topology.Edges.Arrows" />
                            <!-- TODO: Localize --></label>
                        <div class="col-sm-8 noLftRghtPadding" data-ng-class="{'input-group': !propData.topologyProps.edges.arrows || propData.topologyProps.edges.arrows.length < 20}">
                            <input data-ng-show="!propData.topologyProps.edges.arrows || propData.topologyProps.edges.arrows.length < 20" focus-on-show class="form-control input-sm"
                                    type="text" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}" data-ng-model="propData.topologyProps.edges.arrows">
                            <textarea data-ng-show="propData.topologyProps.edges.arrows.length >= 20" focus-on-show data-ng-model="propData.topologyProps.edges.arrows" data-ng-change="updateChart(false)" data-ng-model-options="{debounce: 500}"
                                    rows="5"></textarea>
                            <span class="input-group-addon" data-ng-class="{expanded: propData.topologyProps.edges.arrows.length >= 20}" id="basic-addon1" ng-click="insertTopologyVariable('edges', 'arrows')">f(x)</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>
</div>
<!-- End "General" group -->

<!-- Begin "Field" group -->
<div data-ng-show="selectedPropertyCategory==='fields'">
<!-- 		<div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
			<div class="fieldHeader"
				data-ng-click="collapsed['dimension'+$index]=!collapsed['dimension'+$index]">
				<label class="col-lg-9 noLftRghtPadding"> <span>{{dimension.column}}</span>
				</label> <span class="pull-right"> <span
					class="ico inner-panel-expand-icon"
					data-ng-class="{'ico ico-chevron-down':!collapsed['dimension'+$index], 'ico ico-chevron-right':collapsed['dimension'+$index]}"></span>
				</span>
			</div>
			<div data-ng-class="{'collapsed' : collapsed['propData.scatterProps.scatterX' + $index]}">
				<div id="pointsToPlot">
					<div class="row noLftRghtMargin">
						<div class="form-group">
							<label
								class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
								title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'><fmt:message
									key="CustomReport.Properties.MaxPoints" /> TODO: Localize</label> -->
							<!-- <div class="col-sm-8 noLftRghtPadding">
								<input id="maxPointTextbox" class="fieldPropValue form-control"
									data-ng-model="propData.topologyProps.nodes.field"
									data-ng-change="updateChart(false)" type="text">
							</div>
						</div>
					</div>
					<div class="row noLftRghtMargin">
						<div class="form-group">
							<label
								class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
								title='<fmt:message key="CustomReport.Properties.All"/>'><fmt:message
									key="CustomReport.Properties.All" /> -->
								<!-- TODO: Localize</label>
							<div class="col-sm-3 noLftRghtPadding">
								<input type="checkbox" cv-toggle-switch
									data-ng-model="propData.topologyProps.edges.field"
									id="includeall{{$index}}" data-ng-change="updateChart(false)">

							</div>
						</div>
					</div>
				</div>
			</div>
		</div>-->
	</div> 
<!-- End "Field" group -->

<!-- Begin "Custom Code" group -->
<div data-ng-show="selectedPropertyCategory==='customcode'">  
<!--     <div class="row noLftRghtMargin">
        <div class="col-xs-12"> -->
<!-- FIXME: Localize -->
            <!-- <label class="col-xs-12 noLftRghtPadding">
                <fmt:message key="CustomReport.Properties.PointExpression"/><br>
            </label>
            <span class="col-xs-12 noLftRghtPadding">
                <textarea  data-ng-model="propData.onClick" data-ng-change="redrawComponent(propData.id)"></textarea>
            </span>
        </div>

    </div> -->      
</div>
<!-- End "Custom Code" group -->
</fmt:bundle>