(function(){
	/* tag cloud directive to show colored words in different sizes based on their count, sum, avg etc */
	angular
		.module("reports")
		.directive('tagCloud', tagCloud);

	tagCloud.$inject = ['customReportSvc'];
	function tagCloud(customReportSvc) {
		var directive = {
			scope: {
	            tagcloudconfig : '=tagcloudconfig',
	            component : '=component',
	            filters : '=filters'
	        },
	        controller: ['$scope', '$element', '$attrs', '$transclude', 'customReportSvc', function($scope, $element, $attrs, $transclude, customReportSvc) {
				$scope.customReportSvc = customReportSvc;
			}],	        
	        restrict: 'EA',
	        template: '<div>Placeholder</div>',	        
	        replace: true,	        
	        link: link
		};
		return directive;
	}

	function link(scope, elm, attrs) {
		var selectedWords = [];
		var defaultColors = ["#00cee6", "#9b9bd7", "#6EDA55", "#fc7570", "#fbb755", "#218A8C"];
		// TODO: think of a better method then putting watches
		// redraw if words are getting updated
		scope.$watchCollection('tagcloudconfig.words', function() { 
			scope.drawTagCloud(); 
		}, true);

		// redraw if width is getting updated
	    scope.$watch('tagcloudconfig.width',function() { 
	    	scope.drawTagCloud(); 
	    }, true);     

	    // redraw if height is getting updated
	    scope.$watch('tagcloudconfig.height',function() { 
	    	scope.drawTagCloud(); 
	    }, true);

	    function getColors(i) {
	    	return defaultColors[i%defaultColors.length];
	    }

	    scope.drawTagCloud = function () {
			if (scope.tagcloudconfig) {
		         elm.html('');
		         // var fill = d3.scale.category20c();
		         var fill = getColors;
		         var width = $(elm).parents('.component').width();
		         var height = $(elm).parents('.component').height();
		         width = width<=0 ? 200 : width;
		         height = height<=0 ? 200 : height;
		         var hits = 0;
		         var maxratio = 0;
		         if (scope.tagcloudconfig.words && scope.tagcloudconfig.words.length > 0) {
		             angular.forEach(scope.tagcloudconfig.words, function(word) {
		                 hits += word[word.length - 1];
		             });
		             angular.forEach(scope.tagcloudconfig.words, function(word) {
		                 if (word[word.length - 1] / hits > maxratio)
		                     maxratio = word[word.length - 1] / hits;
		             });
		         }
		         // var totalCount = (scope.tagcloudconfig.words && scope.tagcloudconfig.words.length > 0 ? scope.tagcloudconfig.words : [0]).reduce(function(a,b) { return a[1] + b[1];}); //getting totalcount
		         // var average = totalCount / scope.tagcloudconfig.words.length;
		         var scale = d3.scale.linear().domain([0, maxratio]).range([0, 30]);
		         d3.layout.cloud().size([width, height - 160])
		             .words(scope.tagcloudconfig.words.map(function(word) {
		                 var len = word.length;
		                 return {
		                     text: word.slice(0, len - 1).reduce(function(a, b) {
		                         return b ? (a + "," + b) : a; }),
		                     size: 5 + scale(word[len - 1] / hits) + parseInt(scope.tagcloudconfig.fontScale)
		                 }
		             }))
		             .rotate(function() {
		                if(scope.tagcloudconfig.alignment === 'Random')
		                    return ~~(Math.random() * 2) * 90;
		                else if(scope.tagcloudconfig.alignment === 'Horizontal')
		                    return 0;
		                else if(scope.tagcloudconfig.alignment === 'Vertical')
		                    return 90; 
		             })
		             .font("sans-serif")		             
		             .fontSize(function(d) {
		                 return d.size; })
		             .on("end", draw)
		             .start();

		         function draw(words) {
		             d3.select(elm[0]).append("svg")
		                 .attr("width", width)
		                 .attr("height", (height>140?height-140:140))
		                 .append("g")
		                 .attr("transform", "translate(" + (width - 20) / 2 + "," + (height/2-50) + ")")
		                 .selectAll("text")
		                 .data(words)
		                 .enter().append("text")
		                 .style("cursor", "pointer")
		                 .style("font-size", function(d) {
		                     return d.size + "px"; })
		                 .style("font-family", "Impact, Haettenschweiler, 'Franklin Gothic Bold', Charcoal, 'Helvetica Inserat', 'Bitstream Vera Sans Bold', 'Arial Black', 'sans-serif'")                             
		                 .attr("fill", function(d,i) { return fill(i); } )
		                 .attr("text-anchor", "middle")
		                 .attr("transform", function(d) {
		                     return "translate(" + [d.x, d.y] + ")rotate(" + d.rotate + ")";
		                 })
		                 .text(function(d) {
		                     return d.text; 
		                 }).on("click", function(d) {		                 	
		                 	if ( selectedWords.indexOf(d.text)==-1)
		                 		selectedWords.push(d.text);
		                 	else
		                 		selectedWords.splice(selectedWords.indexOf(d.text), 1);
		                 	if (selectedWords.length == 0)
		                 		$(this).parents("svg").find("text").css("fill-opacity", "1");	
		                 	else {
		                 		$(this).parents("svg").find("text").each(function() {
		                 			if (selectedWords.indexOf($(this).text())==-1)
		                 				$(this).css("fill-opacity", "0.25");
		                 			else
		                 				$(this).css("fill-opacity", "1");
		                 		});                 	
		                 	}
		                 	scope.tagcloudconfig.onSelect(d.text);
		                 });
		         }
		         scope.applyFilters();
		   }
		};
        scope.applyFilters = function() {
        	var dataSetName = scope.component.dataSet.dataSetName;
        	var currentFilter;
        	if ($.isEmptyObject(scope.filters['viewer'][dataSetName])) {
        		return;
        	}
        	var dimensions = [];
        	angular.forEach(scope.component.dimensionDataField, function(dimension, index) {
        		dimensions.push(dimension.column);
        	});
        	currentFilter = scope.filters['viewer'][dataSetName];
            if (!$.isEmptyObject(currentFilter) && Object.keys(currentFilter).length > 0) {
                for(var filterParam in currentFilter) {
					if (dimensions.indexOf(filterParam)!== -1) {
	                    var filtersArr = currentFilter[filterParam]["include"];
	                    /*
	                    in case of custom groups in filtersArr 
	                    delete custom group and add groupName only
	                     */
	                    var tempFilters = [];
	                    angular.forEach(filtersArr, function(filterVal, index){
	                    	if (typeof filterVal === 'object' && filterVal.groupName) {
	                    		tempFilters.push(filterVal.groupName);											
	                    	} else {
	                    		tempFilters.push(filterVal);
	                    	}
	                    });
	                    filtersArr = tempFilters;
	                    if (!$.isEmptyObject(filtersArr)){
	                        $("li[comp="+ scope.component.id +"] svg").find("text").each(function() {
	                                if (filtersArr.indexOf($(this).text())==-1)
	                                    $(this).css("fill-opacity", "0.25");
	                                else
	                                    $(this).css("fill-opacity", "1");
	                        });
	                    }						
					}                	
                }
            }
        };
	}

	// function tagCloudCtrl($scope, $element, $attrs, $transclude, customReportSvc) {
	// 	$scope.customReportSvc = customReportSvc;
	// }
})();
