// Closure to isolate scope, as per best practices
(function() {
	// Get a reference to the reportsBuilder module
	var reports = angular.module("reports");

	reports.directive("cvTabs", function() {
		return {
			restrict : 'AE',
			templateUrl : customReports.contextPath + '/reportsplus/components/tabs/tabs.jsp',
			controller : 'tabsCtrl'
		};
	});

	reports.directive("cvTabComponent", function() {
		return {
			restrict : 'AE',
			templateUrl : customReports.contextPath + '/reportsplus/components/tabs/cvTabComponent.jsp',
			controller : [
					"$scope",
					"reportService",
					"$uibModal",
					"customReportSvc",
					function($scope, reportService, $uibModal, customReportSvc) {
						$scope.component = $scope.tab.component;
						$scope.tabData = {
							tabId : $scope.tab.id,
							compId : $scope.component.id
						};
					} ]
		};
	});

	reports.directive("cvRptTab", function() {
		return {
			restrict : 'AE',
			templateUrl : customReports.contextPath + '/reportsplus/components/tabs/tab.jsp',
			controller : [
					"$scope",
					"reportService",
					"$uibModal",
					"customReportSvc",
					function($scope, reportService, $uibModal, customReportSvc) {
						$scope.dropped = function(dragEl, dropEl, event) {
							var dest = document.getElementById(dropEl);
							var src = document.getElementById(dragEl);
							var drag = angular.element(src);
							var type = drag.data("type");
							var compType = drag.data("componenttype");
							var compDefaultTitle = drag.data("defaulttitle");
							var comp = {};
							comp.type = compType;
							comp.dataSet = {};
							comp.title = {
								text : ""
							};
							$scope.gridsterOpts.mobileBreakPoint = 300;
							comp = customReportSvc.getComponentDefintion(comp,
									type,
									$scope.reportComponents.length,
									$scope.gridsterOpts.rows,
									$scope.gridsterOpts.columns,
									true);
							if (!comp) {
								alert('Invalid Component type');
								return;
							}

							$scope.tab.component = comp;
							$scope.$apply();
						}

						$scope.deleteComponent = function(index, panelComponentIndex, $event) {
							console.log(index)
							$event.stopPropagation();
						}

						$scope.isDisabled = function(tab) {
							var disabled = false;
							if (tab.disableExpression) {
								var args = {
									expression : tab.disableExpression
								};
								disabled = rpt.evalExpression(args);
							}

							if (disabled && tab.id === $scope.requestParms["active." + $scope.component.id]) {
								$scope.setActiveTab(1);
							}

							$scope.tab.disabled = disabled;
						}
						if ($scope.reportMode === 'viewer') {
							customReportSvc.registerCallback("redrawAllComponents", function() {
								$scope.isDisabled($scope.tab);
							});

							$scope.isDisabled($scope.tab);
						}
					} ]

		};
	});

	reports.controller('tabsCtrl', [
			"$scope",
			"reportService",
			"$uibModal",
			"customReportSvc",
			"$timeout",
			function($scope, reportService, $uibModal, customReportSvc, $timeout) {
				$scope.$watch('component.defaultTab', function(defaultTab) {
					var settedTab = null;
					if ($scope.requestParms["active." + $scope.component.id]) {
						settedTab = $scope.requestParms["active." + $scope.component.id];
					} else if (defaultTab) {
						settedTab = defaultTab;
					}
					if (settedTab !== null) {
						var idx = $scope.component.tabs.map(function(tab) {
							return tab.id
						}).indexOf(settedTab)
						$scope.setActiveTab(idx + 1);
					}
				})

				$scope.addNewTab = function() {
					var index = $scope.component.tabs.length > 0 ? $scope.component.tabs.length : "";
					$scope.component.tabs.push({
						id : "Tab " + index + (new Date()).getTime(),
						title : {
							text : 'New Tab' + index
						},
						component : {
							type : "PANEL",
							id : "PanelComponent" + (new Date()).getTime(),
							panelComponents : [],
							hideHeader : true
						}
					});

					$scope.setActiveTab($scope.component.tabs.length);
				}

				$scope.setActiveTab = function(index) {
					$timeout(function() { // https://github.com/angular-ui/bootstrap/issues/5656#issuecomment-203513128
						$scope.active = index;
					}, 100);
				}

				$scope.deleteTab = function(tabId, index, e) {
					if ($scope.component.tabs.length > 0) {
						$scope.component.tabs.splice(index, 1);
					}
					e.preventDefault();
					e.stopPropagation();
				}

				$scope.calculateAndAdjustHeight = function() {
					$timeout(function() {
						var componentHeight = $($("li[comp=" + $scope.component.id + "]").find(".active")[1]).height();//$("li[comp=" + $scope.component.id + "]").find(".active").height();
						componentHeight = componentHeight + 60;
						var componentWidth = $("li[comp=" + $scope.component.id + "]").find(".component-body").width();
						var gridsterCurColWidth = $("#reportContentWrapper").length > 0 ? $("#reportContentWrapper")
								.width() / 12 : $scope.gridster.curColWidth;
						if ($scope.gridsterItem && $scope.gridsterItem.$element && componentWidth > 0 &&
								gridsterCurColWidth > 0) {
							if (!$scope.isFullScreen) {
								$scope.gridsterItem.sizeX = Math.ceil(componentWidth / gridsterCurColWidth);
							}
							$scope.gridsterItem.sizeY = Math.ceil(componentHeight / $scope.gridster.rowHeight);
						}
					}, 100);
				}

				$scope.isActive = function(tabId) {
					$scope.addParameterToUrl("active." + $scope.component.id, tabId);
					$scope.calculateAndAdjustHeight();
				}

				$scope.$on("justifyParentTabHeight", function(event, redraw) {
					$scope.calculateAndAdjustHeight();
				});

			} ]);

})();
