
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div id="{{component.id}}" class="full-height map-component">
		<div class="pivotOptions"
			data-ng-show="reportMode == 'builder' && component.type === 'MAP'">
			<fieldset class="axisColumnDrop ng-isolate-scope"
				data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
				x-lvl-drop-target="true" data-droptype="latitude"
				x-on-drop="dropped(dragEl, dropEl)"
				data-ng-show="component.inputType==='latitudelongitude'">
				<legend class="fieldsetLegend ng-binding">Drop Latitude
					Column</legend>
				<div class="chartColumns groupingCol"
					data-ng-class="{'hidden':component.latitude == undefined }">
					<label>({{component.latitude.name}})<span
						class="deleteColumn" data-ng-click="deleteColumn('latitude')">&times;</span></label>
				</div>
			</fieldset>

			<fieldset class="axisColumnDrop ng-isolate-scope"
				data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
				x-lvl-drop-target="true" data-droptype="longitude"
				x-on-drop="dropped(dragEl, dropEl)"
				data-ng-show="component.inputType==='latitudelongitude'">
				<legend class="fieldsetLegend ng-binding">Drop Longitude
					Column</legend>
				<div class="chartColumns groupingCol"
					data-ng-class="{'hidden':component.longitude == undefined}">
					<label>({{component.longitude.name}})<span
						class="deleteColumn" data-ng-click="deleteColumn('longitude')">&times;</span></label>
				</div>
			</fieldset>

			<fieldset class="axisColumnDrop ng-isolate-scope"
				data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
				x-lvl-drop-target="true" data-droptype="code"
				x-on-drop="dropped(dragEl, dropEl)"
				data-ng-show="component.inputType==='code'">
				<legend class="fieldsetLegend ng-binding">Drop Country Code</legend>
				<div class="chartColumns groupingCol"
					data-ng-class="{'hidden':component.code == undefined}">
					<label>({{component.code.name}})<span class="deleteColumn"
						data-ng-click="deleteColumn('code')">&times;</span></label>
				</div>
			</fieldset>

			<fieldset class="axisColumnDrop ng-isolate-scope"
				data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
				x-lvl-drop-target="true" data-droptype="drilldown"
				x-on-drop="dropped(dragEl, dropEl)"
				data-ng-show="component.inputType==='code'">
				<legend class="fieldsetLegend ng-binding">Drop State Code</legend>
				<div class="chartColumns groupingCol"
					data-ng-class="{'hidden':component.drilldown == undefined}">
					<label>({{component.drilldown.name}})<span
						class="deleteColumn" data-ng-click="deleteColumn('drilldown')">&times;</span></label>
				</div>
			</fieldset>
			<fieldset class="axisColumnDrop ng-isolate-scope"
				data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
				x-lvl-drop-target="true" data-droptype="piecolumn"
				x-on-drop="dropped(dragEl, dropEl)"
				data-ng-show="component.inputType==='code'">
				<legend class="fieldsetLegend ng-binding">Drop Drilldown
					Column</legend>
				<div class="chartColumns groupingCol"
					data-ng-class="{'hidden':component.pieColumn == undefined}">
					<label>({{component.pieColumn.name}})<span
						class="deleteColumn" data-ng-click="deleteColumn('pieColumn')">&times;</span></label>
				</div>
			</fieldset>
			<fieldset class="axisColumnDrop ng-isolate-scope"
				data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
				x-lvl-drop-target="true" x-on-drop="dropped(dragEl, dropEl)">
				<legend class="fieldsetLegend ng-binding">Drop Data Columns</legend>
				<div data-ng-repeat="column in component.columns"
					class="chartColumns groupingCol">
					<label> <select data-ng-model="column.aggrType"
						data-ng-change="$index>0 ? loadComponent() : return;"
						class="colNoBorder"
						data-ng-disabled="$index>0&&component.columns[0].aggrType==='None'">
							<option value="None" data-ng-show="!component.pieColumn && $index==0"><fmt:message
									key="CustomReport.None" /></option>
							<option value="Count"><fmt:message
									key="CustomReport.Count" /></option>
							<option value="CountDistinct"><fmt:message
									key="CustomReport.Distinct" /></option>
							<option data-ng-if="column.showNumberOps" value="Sum"><fmt:message
									key="CustomReport.Sum" /></option>
							<option data-ng-if="column.showNumberOps" value="Avg"><fmt:message
									key="CustomReport.Avg" /></option>
							<option data-ng-if="column.showNumberOps" value="Min"><fmt:message
									key="CustomReport.Min" /></option>
							<option data-ng-if="column.showNumberOps" value="Max"><fmt:message
									key="CustomReport.Max" /></option>
					</select> ({{column.id}})
					</label> <span class="deleteColumn" data-ng-click="deleteColumn($index)">&times;</span>
				</div>
			</fieldset>
		</div>
		<div class="clearFloat"></div>
		<div class="noChartDiv" data-ng-show="showNoDataDiv"
			data-ng-click="setActiveComponent()">
			<label data-ng-show="showNoDataDiv"><fmt:message
					key="CustomReport.NoDataAvailable" /></label>
		</div>
		<div id="cvmap_{{component.id}}" class="map"
			style="height: calc(100% - 53px)"
			data-ng-show="component.mapType === 'mapbox' && component.latitude && component.longitude"></div>
		<!-- 53px is for component title outerHeight -->
		<highchart config="mapConfig"
			data-ng-show="component.mapType === 'highmap' && ((component.code && component.columns && component.columns.length>0) || (component.latitude && component.longitude))"
			style="height: calc(100% - 53px)"></highchart>
		<!-- 53px is for component title outerHeight -->

	</div>
</fmt:bundle>