//Create a new mappie seriesType; supported only from 5.0.8. Tested in 6.0.2
//Refer https://www.highcharts.com/documentation/changelog#highmaps
//For demo: https://www.highcharts.com/maps/demo/map-pies
var initMapPieSeriesType = function() {
	if (Highcharts.version && parseFloat(Highcharts.version) >= 6) {
		Highcharts.seriesType('mappie', 'pie', {
			center : null, // Can't be array by default anymore
			clip : true, // For map navigation
			states : {
				hover : {
					halo : {
						size : 5
					}
				}
			},
			dataLabels : {
				enabled : false
			}
		}, {
			getCenter : function() {
				var options = this.options, chart = this.chart, slicingRoom = 2 * (options.slicedOffset || 0);
				if (!options.center) {
					options.center = [ null, null ]; // Do the default here instead
				}
				if (options.center.lat !== undefined) {
					options.center = [ options.center.lat, options.center.lon ];
				}
				// Handle dynamic size
				if (options.sizeFormatter) {
					options.size = options.sizeFormatter.call(this);
				}
				// Call parent function
				var result = Highcharts.seriesTypes.pie.prototype.getCenter.call(this);
				// Must correct for slicing room to get exact pixel pos
				result[0] -= slicingRoom;
				result[1] -= slicingRoom;
				return result;
			},
			translate : function(p) {
				this.options.center = this.userOptions.center;
				this.center = this.getCenter();
				return Highcharts.seriesTypes.pie.prototype.translate.call(this, p);
			}
		});
	}
};
// Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	app
			.directive("cvMapBox",
					[
							'customReportSvc',
							'$timeout',
							"dataSource",
							function(customReportSvc, $timeout, $dataSource) {
								return {
									restrict : "AEC",
									scope : false,
									link : function(scope, elem, attr) {
										// $timeout(function(){
										// 	scope.height = angular.element('#'+scope.component.id).height() - 50;
										// 	if (scope.reportMode === 'builder') {
										// 		scope.height-=30;
										// 	}
										// 	scope.height+="px";
										// });
									},
									templateUrl : customReports.contextPath +
											'/reportsplus/components/map/cvMapBox.jsp',
									controller : [
											'$scope',
											function($scope) {
												initMapPieSeriesType();
												var arr = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];

												var componentTitleHeight = 53;
												customReportSvc.registerCallback("redrawAllComponents", function(data) {
													$scope.loadComponent();
												}, $scope.component.id);

												if (!$scope.component.inputType) {
													$scope.component.inputType = 'latitudelongitude';
												}
											
												if($scope.component.ShowLabels === undefined && $scope.component.subType === 'mapbubble') {
													$scope.component.ShowLabels = true;
												}
												function getMapConfig() {
													var mapConfig = {
														options : {
															chart : {
																borderColor : "#c0c0c0",
															},
															exporting : {
																enabled : false
															},
															legend : {
																enabled : false
															},
															credits : {
																enabled : false
															},
															// colors : defaultMultiChartColors,
															plotOptions : {
																map : {
																	mapData : Highcharts.maps['custom/world'],
																	joinBy : [ 'name' ],
																	cursor : "move"
																},
																heatmap : {
																	colorIndex : 2,
																	animation : true,
																	cursor : "move"
																},
																mapbubble : {
																	colorIndex : 2,
																	color : 'rgba(124,181,236,0.5)',
																	marker : {
																        lineColor: '#7cb5ec',
																        lineWidth: 1
																     },
																	animation : true,
																	className : 'bubble-map',
																	cursor : "move",
																}
															},
															mapNavigation : {
																enabled : true,
																enableMouseWheelZoom : false,
																buttonOptions : {
																	verticalAlign : 'bottom'
																}
															},
															colorAxis : {
																min : 0,
																stops : [
																		[ 0, '#EFEFFF' ],
																		[ 0.5, '#5DFFEE' ],
																		[ 1, '#00cee6' ] ]
															},
															tooltip : {
																useHTML : true,
																formatter : null
															}
														},
														chartType : 'map',
														title : {
															text : ''
														},
														series : []
													}
													return mapConfig;
												}
												function evalExpression() {
													var argsObj = arguments[0];
													var varExpression = "";
													for ( var prop in argsObj) {
														window[prop] = argsObj[prop];
													}

													var retunVal = expression;

													if (typeof expression === "string" &&
															expression.substring(0, 1) === "=") {
														try {
															retunVal = eval(expression.substring(1));
														} catch (exception) {
															console.error(exception.message)
														}
													} else if (typeof expression === "string" &&
															expression.substring(0, 2) === ":=") {
														try {
															var expr = "(function() {" + expression.substring(2) +
																	" }) ();";
															retunVal = eval(expr);
														} catch (exception) {
															console.error(exception.message)
														}
													}
													return retunVal;
												}
												function convertHexToRgba(hex){
													 hex = hex.replace('#','');
													 var opacity = 0.5;
													 var r = parseInt(hex.substring(0,2), 16);
													 var g = parseInt(hex.substring(2,4), 16);
													 var b = parseInt(hex.substring(4,6), 16);
													 return 'rgba('+r+','+g+','+b+','+opacity+')';
													 
												}
												var geoJson = [];
												var seriesData = [];
												var mapBubbleSeries = {
													name : '',
													mapData : Highcharts.maps['custom/world'],
													enableMouseTracking : false,
													animation : true,
													color : '#00cee6',
													nullColor : '#d5d5d5',
													borderWidth : 1,
													borderColor : "#c0c0c0",
													dataLabels : {
														enabled : false,
														color : '#000000',
														formatter : function() {
															if (this.point.value) {
																return this.point.name;
															}
														},
														allowOverlap : true
													}
												};
												var showLabels = $scope.component.subType === 'mapbubble' ? $scope.component.ShowLabels : true;
												var isoverlapLabels = $scope.component.subType === 'mapbubble'? true : false;
												var mapSeries = {
													type : 'mappoint',
													name : '',
													joinBy : [ 'iso-a2', 'code' ],
													data : [],
													mapData : Highcharts.maps['custom/world'],
													minSize : 4,
													maxSize : '12%',
													dataLabels : {
														enabled : showLabels,
														allowOverlap : isoverlapLabels,
														color : '#000000',
														formatter : function() {
															if (this.point.value) {
																return this.point.name;
															}
														}
													},
													point : {
														events : {
															click : null
														}
													},
													nullColor : '#d5d5d5',
													borderWidth : 1,
													borderColor : "#c0c0c0"
												};

												$scope.getCountryMap = function(event, isGetMap) {
													$timeout(function() {
														if (event.target && event.target.nodeName === "tspan" &&
																$scope.component.titleExpression) {
															return;
														}
														if ($scope.component.inputType === 'latitudelongitude') {
															return;
														}
														if (!$.isEmptyObject($scope.component.drilldown)) {
															var country_code = (event.point.code || "").toLowerCase();
															if (!$scope.component.isDrillDown) {
																var mapKey = 'countries/' + country_code.toLowerCase() +
																		'/' + country_code.toLowerCase() + '-all';
																var mapDataURL = 'http://code.highcharts.com/mapdata/countries/' +
																		country_code + '/' + country_code + '-all.js';
																$
																		.getScript(mapDataURL)
																		.done(function(data) {
																			var newMapData = Highcharts.maps[mapKey]
																			$scope.mapConfig.series[0].mapData = newMapData;
																			$scope.mapConfig.series[0].joinBy = [
																					'postal-code',
																					'code' ];
																			if ($scope.mapConfig.series.length > 1) { // for bubble map
																				$scope.mapConfig.series[1].mapData = newMapData;
																			}
																			var column = $scope.component.code.column;
																			$scope.component.isDrillDown = true;
																			if (!isGetMap) {
																				$scope.addFilters(column,
																						event.point.code,
																						$scope.component,
																						true,
																						true,
																						undefined,
																						undefined,
																						"viewer",
																						"include",
																						true);
																			}
																			$scope.$apply();
																		});
															} else if (!isGetMap) {
																$scope.addFilters($scope.component.drilldown.column,
																		event.point.code,
																		$scope.component,
																		true,
																		true,
																		undefined,
																		undefined,
																		"viewer",
																		"include",
																		true);
															}
														} else if (!isGetMap) { // in case of normal selection
															$scope.addFilters($scope.component.code.column,
																	event.point.code,
																	$scope.component,
																	true,
																	true,
																	undefined,
																	undefined,
																	"viewer",
																	"include",
																	true);
														}
													});
												};
												$scope.loadComponent = function() {
													if ($scope.map) {
														$scope.map.off();
														$scope.map.remove();
														$scope.map = undefined;
													}
													if ($scope.map && typeof $scope.map.remove === 'function') {
														if (angular.element("#cvmap_" + $scope.component.id)
																.find('div.leaflet-map-pane').length > 0) {
															$scope.map.remove();
														}
														$scope.map = undefined;
													}

													if (($scope.component.inputType === 'latitudelongitude' && (!$scope.component.latitude || !$scope.component.longitude)) ||
															($scope.component.inputType === 'code' && (!$scope.component.code || $
																	.isEmptyObject($scope.component.columns))) ||
															($scope.component.pieColumn && ($
																	.isEmptyObject($scope.component.columns) || $scope.component.columns[0].aggrType === "None"))) {
														$scope.component.isComponentLoading = false;
														return;
													}

													if (!$scope.component.mapType) {
														$scope.component.mapType = 'mapbox';
													}

													if (!$scope.component.subType) {
														$scope.component.subType = 'mappoint';
													}

													$scope.showNoDataDiv = false;
													// show loading on top
													$scope.component.isComponentLoading = true;
													$scope.loadingButton();
													$scope.mapConfig = getMapConfig();
													
														var dataSetName = $scope.dataSet.dataSet.dataSetName;
														var dimensionDataField = [], measureDataField = [];
														var limit = 999999;
														var additionalDimensionProperties = {
															'numPointsToDisplay' : {
																'includeAll' : false,
																'maxPoints' : 15
															}
														};
														if ($scope.component.inputType === 'latitudelongitude') {
															if ($
																	.isEmptyObject($scope.component.latitude.numPointsToDisplay)) {
																$scope.component.latitude = $.extend({},
																		$scope.component.latitude,
																		additionalDimensionProperties);
																$scope.component.longitude = $.extend({},
																		$scope.component.longitude,
																		additionalDimensionProperties);
															}
															var latitudeColumn = {
																'column' : $scope.component.latitude.name,
																'dataField' : $scope.component.latitude.name,
																'numPointsToDisplay' : $scope.component.latitude.numPointsToDisplay,
																'sortOrder' : "NONE"
															};
															var longitudeColumn = {
																'column' : $scope.component.longitude.name,
																'dataField' : $scope.component.longitude.name,
																'numPointsToDisplay' : $scope.component.longitude.numPointsToDisplay,
																'sortOrder' : "NONE"
															};
															dimensionDataField.push(latitudeColumn);
															dimensionDataField.push(longitudeColumn);
															limit = latitudeColumn.numPointsToDisplay.includeAll ? limit
																	: latitudeColumn.numPointsToDisplay.maxPoints;
														} else if ($scope.component.inputType === 'code') {
															var newColumn;
															if (!$scope.component.isDrillDown ||
																	$.isEmptyObject($scope.component.drilldown)) {
																if ($
																		.isEmptyObject($scope.component.code.numPointsToDisplay)) {
																	$scope.component.code = $.extend({},
																			$scope.component.code,
																			additionalDimensionProperties);
																}
																var codeColumn = {
																	'column' : $scope.component.code.name,
																	'dataField' : $scope.component.code.name,
																	'numPointsToDisplay' : $scope.component.code.numPointsToDisplay,
																	'sortOrder' : "NONE"
																};
																newColumn = codeColumn;
																dimensionDataField.push(codeColumn);
															} else {
																if ($
																		.isEmptyObject($scope.component.drilldown.numPointsToDisplay)) {
																	$scope.component.drilldown = $.extend({},
																			$scope.component.drilldown,
																			additionalDimensionProperties);
																}
																var drilldownColumn = {
																	'column' : $scope.component.drilldown.name,
																	'dataField' : $scope.component.drilldown.name,
																	'numPointsToDisplay' : $scope.component.drilldown.numPointsToDisplay,
																	'sortOrder' : "NONE"
																};
																newColumn = drilldownColumn;
																dimensionDataField.push(drilldownColumn);
															}
															limit = newColumn.numPointsToDisplay.includeAll ? limit
																	: newColumn.numPointsToDisplay.maxPoints;

															if ($scope.component.pieColumn) {
																var pieColumn = $scope.applyInputsToCustomGroups([$scope.component.pieColumn]);
																dimensionDataField.push(pieColumn[0]);
															}
														}
														angular.forEach($scope.component.columns, function(column) {
															var columnInfo = {
																'column' : column.name,
																'dataField' : column.name,
																'aggrType' : column.aggrType || 'None'
															};
															measureDataField.push(columnInfo);
														});
														var columns = dimensionDataField;
														columns = columns.concat(measureDataField);
														var tableParams = {
															columns : customReportSvc
																	.getSelectedColumnsDefn($scope.dataSet.fields,
																			columns),
															offset : 0,
															limit : limit
														};
														$scope.component.dimensionDataField = dimensionDataField;
														$scope.component.measureDataField = measureDataField;
													if ($scope.dataSet.endpoint === 'DATACUBE') {
														$dataSource
																.getDataSource($scope.dataSet.endpoint)
																.getMapData({
																	dataSet : $scope.dataSet,
																	componentType : $scope.component.type,
																	measureDataField : measureDataField,
																	dimensionDataField : dimensionDataField,
																	sortOptions : $scope.component.pieColumn ? {
																		sortAxis : "YAxis",
																		direction : "desc"
																	} : undefined,
																	tableParams : tableParams,
																	isObjFormat : $scope.component.pieColumn ? true
																			: false,
																	constructGroupStructure : $scope.component.pieColumn ? true
																			: false,
																	doNotExclude : true, // as of now, multi selection in map component is not supported
																	filters : $scope.component.filters &&
																			$scope.component.filters['builder'] ? $scope.component.filters['builder'][dataSetName]
																			: {},
																	inputParams : customReportSvc
																			.applyInputsToDataSet($scope.dataSet,
																					$scope.page.inputs)
																},
																		function(response) {
																			//console.log(response);
																			onSuccessGetMapData(response);
																		});
													} else {
														$scope.getData().then(function(resultData) {
															onSuccessGetMapData(resultData);
														}, function(error) {
															console.log(error);
															$scope.component.isComponentLoading = false;
														});
													}
												}

												var onSuccessGetMapData = function(resultData) {
													var response = resultData.data || resultData;
													var records = $scope.component.pieColumn ? response.groups
															: response.records;
													var coordinates = [];
													$scope.pieValColorMap = {};
													$scope.customColorMap = {};
													if (!$.isEmptyObject($scope.component.seriesFormatting)) {
														angular.forEach($scope.component.seriesFormatting, function(
																eachSeries) {
															$scope.customColorMap[eachSeries.value] = eachSeries.color;
														});
													}

													var columns = [];
													if ($scope.dataSet.endpoint === 'DATACUBE') {
														if ($scope.component.inputType === 'code') {
															columns.push({
																'name' : $scope.component.code.name
															});
														} else if ($scope.component.inputType === 'latitudelongitude') {
															columns.push({
																'name' : $scope.component.latitude.name
															});
															columns.push({
																'name' : $scope.component.longitude.name
															});
														}
														angular.forEach($scope.component.columns, function(column) {
															columns.push(column);
														});
													} else {
														columns = response.columns;
													}
													var lat, long;
													var viewCoords = [];
													var dimensionIndex = 2;
													var isDataAvailable = false;
													mapSeries.data = [];
													geoJson = [];
													if (!$.isEmptyObject($scope.component.columns)) {
														var measureColName = $scope.component.columns[0].name;
														var measureColAggrType = $scope.component.columns[0].aggrType &&
																$scope.component.columns[0].aggrType.toLowerCase();
													}
													var isStrValFound = false;
													for (var i = 0; i < records.length; i++) {
														isDataAvailable = true;
														$scope.showNoDataDiv = false;
														if (!Array.isArray(records[i]) && !$scope.component.pieColumn) {
															records[i] = convertRecordsToArray(records[i]);
														}
														if ($scope.component.mapType === 'highmap') {
															var mapData = {};
															var row = {};
															if ($scope.component.pieColumn) {
																mapData = convertGroupRespToMapPieData(records[i],
																		measureColName,
																		measureColAggrType);
																row = $.extend({}, mapData);
															} else {
																var recordLength = records[i].length;
																if ($scope.component.inputType === 'latitudelongitude') {
																	row[$scope.component.latitude.name] = records[i][0];
																	row[$scope.component.longitude.name] = records[i][1];
																} else if ($scope.component.inputType === 'code') {
																	row[$scope.component.code.name] = records[i][0];
																	dimensionIndex = 1;
																}
																if (records[i].length > dimensionIndex) {
																	row[$scope.component.columns[recordLength -
																			dimensionIndex - 1].name] = records[i][dimensionIndex];
																	mapData.value = records[i][dimensionIndex];
																}
																// include rest of the data to show it on tooltip
																angular
																		.forEach(records[i].slice(dimensionIndex + 1),
																				function(colValue, index) {
																					var key = $scope.component.columns[index + 1].aggrType
																							.toLowerCase() +
																							"_" +
																							$scope.component.columns[index + 1].name;
																					row[key] = mapData[key] = colValue;
																				});
															}
															if ($scope.component.inputType === 'latitudelongitude') {
																mapData.lat = row[$scope.component.latitude.name];
																mapData.lon = row[$scope.component.longitude.name];
															} else if ($scope.component.inputType === 'code') {
																mapData.code = row[$scope.component.code.name] ||
																		($scope.component.drilldown && row[$scope.component.drilldown.name]);
															}
															mapData.z = mapData.value;
															if ($scope.component.titleExpression) {
																var args = {};
																args["expression"] = $scope.component.titleExpression;
																args["row"] = row;
																args["rowIndex"] = i;
																var title = evalExpression(args);
																mapData.dataLabels = {
																	'format' : null,
																	enabled : true
																};
																mapData.dataLabels.format = title;
															}
															if (!isStrValFound && mapData.value &&
																	typeof mapData.value === "string") {
																isStrValFound = true;
															}
															mapSeries.data.push(mapData);

														}

														else if ($scope.component.mapType === 'mapbox') {
															var resultRow = records[i];
															var row = {};
															var rowIndex = i;
															var coordinate = [];
															var title = "";
															for (var j = 0; j < columns.length; j++) {
																var col = columns[j];
																if (col.name === $scope.component.longitude.name) {
																	coordinate[0] = resultRow[j] + "";
																	if (i === 0) {
																		viewCoords[1] = resultRow[j] + "";
																	}
																}

																if (col.name === $scope.component.latitude.name) {
																	coordinate[1] = resultRow[j] + "";
																	if (i === 0) {
																		viewCoords[0] = resultRow[j] + "";
																	}
																}

																row[col.name] = resultRow[j];

																if (title) {
																	title = title + "<br>";
																}
																title = title + col.name + " : " + resultRow[j];

															}

															if ($scope.component.titleExpression) {
																var args = {};
																args["expression"] = $scope.component.titleExpression;
																args["row"] = row;
																args["rowIndex"] = rowIndex;
																title = evalExpression(args);
															}

															geoJson.push({
																"type" : "Feature",
																"geometry" : {
																	"type" : "Point",
																	"coordinates" : coordinate
																},
																"properties" : {
																	"title" : title,
																	"marker-color" : "#228b22"
																}
															});
														}
													}
													if ($scope.component.mapType === 'highmap') {
														mapSeries.type = $scope.component.subType;
														if ($scope.component.subType === 'heatmap' ||
																($scope.component.pieColumn && $scope.component.pieColumn.showAsPie)) {
															delete mapSeries.type;
															if (isStrValFound || $scope.component.pieColumn) {
																mapSeries.colorAxis = false;

															} else {
																mapSeries.colorAxis = undefined;
															}
														}
													}
													if ($scope.component.pieColumn) {
														$scope.component.currDataSeries = Object
																.keys($scope.pieValColorMap).map(function(eachVal) {
																	return {
																		value : eachVal
																	}
																});
													}
													if (isDataAvailable) {
														$scope.component.isComponentLoading = false;
														var mapId = 'cvmap_' + $scope.component.id;

														if ($scope.component.mapType === 'mapbox') {
															if (!$scope.map) {
																$scope.map = L.mapbox.map(mapId,
																		'commvault-maps.map-42bruajs');
															}
															$scope.map.setView(viewCoords, 7);
															$scope.map.markerLayer.setGeoJSON(geoJson);
															$scope.map.markerLayer.on('mouseover', function(e) {
																e.layer.openPopup();
															});
															$scope.map.markerLayer.on('mouseout', function(e) {
																e.layer.closePopup();
															});
														} else {
															var seriesCount = 0;
															$scope.map = undefined;
															$scope.mapConfig.series = [];
															if ($scope.component.subType === 'mapbubble') {
																$scope.mapConfig.series.push(mapBubbleSeries);
																seriesCount++;
															}
															$scope.mapConfig.series.push(mapSeries);
															if ($scope.component.disableInteractivity) {
																$scope.mapConfig.series[seriesCount].point.events.click = null;
															} else {
																$scope.mapConfig.series[seriesCount].point.events.click = $scope.getCountryMap;
															}
															if ($scope.component.isDrillDown &&
																	!$.isEmptyObject($scope.component.drilldown)) {
																/*
																 * enable drill down (replace the existing
																 * world map with the corresponding country
																 * map) for heatmap
																 */
																var code = $scope.page.body.filters.viewer[$scope.dataSet.dataSet.dataSetName][$scope.component.code.column].include[0];
																var event = {
																	'point' : {}
																};
																event.point.code = code;
																$scope.component.isDrillDown = false;
																$scope.getCountryMap(event, true);
																$scope.mapConfig.series[seriesCount].joinBy = [
																		"postal-code",
																		"code" ];
															} else {
																$scope.mapConfig.series[0].mapData = Highcharts.maps["custom/world"];
																$scope.mapConfig.series[seriesCount].mapData = Highcharts.maps["custom/world"];
																$scope.mapConfig.series[seriesCount].joinBy = [
																		'iso-a2',
																		'code' ];
															}
															$scope.mapConfig.options.tooltip.formatter = function() {
																var tooltipString = "";
																if ($scope.component.inputType === 'latitudelongitude') { // latitude longitude
																	tooltipString += "Latitude : " + this.point.lat +
																			"<br>";
																	tooltipString += "Longitude : " + this.point.lon +
																			"<br>";
																} else if ($scope.component.inputType === 'code') {
																	tooltipString += "Country Code : " +
																			this.point.code + "<br>";
																}
																if (this.point.value) {
																	tooltipString += $scope.component.columns[0].name +
																			" : " + this.point.value + "<br>";
																}
																if ($scope.component.columns.length > 1) {
																	var that = this;
																	angular
																			.forEach($scope.component.columns.slice(1),
																					function(column, index) {
																						var key = $scope.component.columns[index + 1].aggrType
																								.toLowerCase() +
																								"_" +
																								$scope.component.columns[index + 1].name;
																						tooltipString += column.aggrType +
																								"(" +
																								column.name +
																								") : " +
																								that.point[key] +
																								"<br>";
																					});
																}
																if ($scope.component.pieColumn && this.point.pieMap) {
																	var firstCol = $scope.component.columns[0];
																	tooltipString += "<div class='pull-right'>"
																	angular
																			.forEach(this.point.pieMap,
																					function(eachPie, key) {
																						tooltipString += key +
																								" : " +
																								eachPie[firstCol.name][firstCol.aggrType
																										.toLowerCase()] +
																								"<br/>";
																					});
																	tooltipString += "</div>";
																}
																return tooltipString;
															};
															if ($scope.component.tooltipFormatter) {
																$scope.mapConfig.options.tooltip.formatter = function() {
																	var args = {
																		"expression" : $scope.component.tooltipFormatter,
																		"point" : this.point
																	}
																	return evalExpression(args);
																};
															}
														}
														$timeout(function() {
															// merge overlapped bubbles and aggregate their values
															$scope.updateSeries();
														}, 500);
													} else {
														$scope.showNoDataDiv = true;
													}

													$scope.component.isComponentLoading = false;
													if ($scope.reportMode !== "viewer") {
														$scope.$apply();
													}
												}
												var convertRecordsToArray = function(record) {
													var component = $scope.component;
													var returnRecord = [];
													if (component.inputType === 'code') {
														if (component.isDrillDown &&
																!$.isEmptyObject(component.drilldown)) {
															returnRecord.push(record[component.drilldown.name]);
														} else {
															returnRecord.push(record[component.code.name]);
														}
													} else if (component.inputType === 'latitudelongitude') {
														returnRecord.push(record[component.latitude.name]);
														returnRecord.push(record[component.longitude.name]);
													}
													angular.forEach(component.columns, function(column) {
														returnRecord.push(record[column.name]);
													});
													return returnRecord;
												};
												var getPieColor = function(pieVal) {
													var colorToReturn;
													if (!$.isEmptyObject($scope.customColorMap)) {
														colorToReturn = $scope.customColorMap[pieVal];
													}
													if (!colorToReturn) {
														//if not found in custom color, pick it from default color list
														var colorCount = customReportSvc.defaultMultiChartColors.length;
														var index = Object.keys($scope.pieValColorMap).length;
														colorToReturn = customReportSvc.defaultMultiChartColors[index %
																colorCount];
													}
													return colorToReturn ? colorToReturn : "#000";
												}
												var convertGroupRespToMapPieData = function(eachGroup, measureColName,
														measureColAggrType) {
													var mapData = {};
													if (eachGroup !== null) {
														mapData[eachGroup.field] = eachGroup.value;
														mapData.value = eachGroup.aggregates[measureColName][measureColAggrType];
														angular.forEach(eachGroup.aggregates, function(obj, key) {
															angular.forEach(obj, function(aggrVal, aggrType) {
																mapData[aggrType + "_" + key] = aggrVal;
															});
														});
														var pieData = [];
														if (!$.isEmptyObject(eachGroup.items)) {
															mapData.pieMap = {};
															angular
																	.forEach(eachGroup.items,
																			function(eachItem, index) {
																				//pieData format is for pie on the map
																				var eachPie = {
																					name : eachItem.value,
																					y : eachItem.aggregates[measureColName][measureColAggrType]
																				};
																				pieData.push(eachPie);
																				//copy all the aggregats to mapData so that it is accessible for formatting
																				mapData.pieMap[eachPie.name] = $
																						.extend({}, eachItem.aggregates);
																				//push it to a map to know the possible values for the pieColumn
																				if (!$scope.pieValColorMap
																						.hasOwnProperty(eachPie.name)) {
																					$scope.pieValColorMap[eachPie.name] = getPieColor(eachPie.name);
																				}
																				mapData.pieMap[eachPie.name]._color = $scope.pieValColorMap[eachPie.name];
																				//color will be set to the maximum group's color
																				//first value will be maximum as it is sorted
																				if (index === 0) {
																					mapData.color = convertHexToRgba($scope.pieValColorMap[eachPie.name]);
																					mapData.marker = {
																								        lineColor: $scope.pieValColorMap[eachPie.name],
																								        lineWidth: 1
																								     }
																				}
																			});
														}
														mapData.pieData = pieData;
													}
													return mapData;
												};

												$scope.reloadComponent = function(refreshCache) {
													$scope.loadComponent();
												};

												$scope.$watch('component.inputType', function(newValue, oldValue) {
													if ($scope.component.isComponentLoading) {
														return;
													}
													$scope.component.isComponentLoading = true;
													if (newValue != oldValue) {
														$scope.component.latitude = undefined;
														$scope.component.longitude = undefined;
														$scope.component.code = undefined;
														$scope.component.pieColumn = undefined;
														if ($scope.component.inputType === 'code') {
															$scope.component.mapType = 'highmap';
															$scope.component.subType = 'mapbubble';
														} else if ($scope.component.inputType === 'latitudelongitude') {
															$scope.component.mapType = 'mapbox';
															$scope.component.subType = 'mappoint';
														}
													}
													$scope.loadComponent();
												});
												$scope.$watch('component.subType', function(newValue, oldValue) {
													if ($scope.component.isComponentLoading) {
														return;
													}
													$scope.component.isComponentLoading = true;
													if ($scope.component.subType === 'mapbubble' ||
															$scope.component.subType === 'heatmap') {
														$scope.component.mapType = 'highmap';
													if($scope.component.subType === 'mapbubble')
														$scope.component.ShowLabels = false;
													else
														$scope.component.ShowLabels = true;

													} else if ($scope.component.subType === 'mappoint') {
														$scope.component.mapType = 'mapbox';
													}
													$scope.loadComponent();
												});

												$scope.$watch('component.columns[0].aggrType', function(newValue,
														oldValue) {
													if ($scope.component.isComponentLoading) {
														return;
													}
													if ($scope.component.mapType === 'mapbox' && newValue &&
															newValue != 'None') {
														$scope.component.subType = 'mapbubble';
														$scope.component.mapType = 'highmap';
														angular.forEach($scope.component.columns, function(column) {
															if (column.aggrType && column.aggrType === 'None') {
																column.aggrType = 'Count';
															}
														});
													} else if (oldValue && oldValue != 'None' && newValue === 'None') {
														if ($scope.component.inputType === 'latitudelongitude') {
															$scope.component.subType = 'mappoint';
															$scope.component.mapType = 'mapbox';
														}
														angular.forEach($scope.component.columns, function(column) {
															column.aggrType = 'None';
														});
													}
													$scope.loadComponent();
												});

												$scope.dropped = function(dragEl, dropEl) {
													var source = document.getElementById(dragEl);
													if ($scope.reportMode == "viewer") {
														return;
													}

													if (!$scope.component.isSelected) {
														customReportSvc
																.errorToast('Select the component to add a column.');
														return;
													}

													var dest = document.getElementById(dropEl);
													var src = document.getElementById(dragEl);
													var drag = angular.element(src);
													var drop = angular.element(dest);
													var dropType = drop.data('droptype');

													if (drag.data("componenttype") != "COLUMN") { //check is needed because rearranging columns also triggered drop
														$scope.columnRearranged = true;
														return;
													}

													var columnName = drag.attr("data-name");
													var columnType = drag.attr("data-type");
													var origType = drag.attr("data-origtype");
													var dataField = drag.attr("data-datafield");
													var dataSetEntity = drag.data("datasetentity");
													var dataSetName = dataSetEntity.dataSetName;

													if (!$scope.component.dataSet ||
															!$scope.component.dataSet.dataSetName) {
														$scope.associateDataSetToComponent(dataSetEntity);
													} else if ($scope.component.dataSet.dataSetName != dataSetName) {
														alert("Mismatched data Sets");
														return;
													}

													var column = {
														column : columnName,
														name : columnName,
														dataField : dataField,
														type : columnType,
														id : dataField.replace(/\s/g, ""),
														showNumberOps : true,
														aggrType : $scope.component.pieColumn ? 'Count' : 'None',
														numPointsToDisplay : {
															'includeAll' : false,
															'maxPoints' : 15
														}
													};
													if (arr.indexOf(columnType) === -1) {
														column.showNumberOps = false;
													}

													if (drop.data('droptype') == "latitude") {
														$scope.component.latitude = column;
													} else if (drop.data('droptype') == "longitude") {
														$scope.component.longitude = column;
													} else if (drop.data('droptype') == "code") {
														$scope.component.code = column;
													} else if (drop.data('droptype') == "drilldown") {
														$scope.component.drilldown = column;
													} else if (drop.data('droptype') == "piecolumn") {
														$scope.component.pieColumn = column;
													} else {
														if ($scope.component.columns.length > 0) {
															if ($scope.component.columns[0].aggrType === 'None') {
																column.aggrType = 'None';
															} else {
																column.aggrType = 'Count';
															}
														}
														$scope.component.columns.push(column);
													}

													$scope.loadComponent();
													$scope.$apply();
												};

												$scope.deleteColumn = function(index) {
													if (index === 'longitude') {
														$scope.component.longitude = undefined;
													} else if (index === 'latitude') {
														$scope.component.latitude = undefined;
													} else if (index === 'code') {
														$scope.component.code = undefined;
													} else if (index === 'drilldown') {
														$scope.component.drilldown = undefined;
													} else if (index === 'pieColumn') {
														$scope.component.pieColumn = undefined;
													} else {
														$scope.component.columns.splice(index, 1);
													}

													$scope.loadComponent();
												}
												customReportSvc.registerCallback("refreshComponent", function(
														componentId) {
													if ($scope.component.id === componentId) {
														$scope.loadComponent();
													}
												}, $scope.component.id);

												$scope.$on('resize', function(sizes, gridster) {
													if (gridster && gridster.length > 1) {
														var componentResizedScope = angular.element(gridster[1])
																.scope();
														var component = componentResizedScope.$parent.component;
														var currentCompId = component.id;
														if ($scope.component.id == currentCompId) {
															if (component.mapType === 'highmap' && $scope.mapConfig) {
																$timeout(function() {
																	var chart = angular.element('li[comp=' +
																			currentCompId + '] .highcharts-container')
																			.parent().highcharts();
																	if ($scope.reportMode == 'builder') {
																		chart.options.chart.height = $("#" +
																				$scope.component.id).height() -
																				componentTitleHeight;
																	}
																	chart.reflow();
																}, 50);
															}
														}
													}
												});
												$scope.$watch('component.ShowLabels', function(newValue, oldValue) {
													if(newValue !== undefined && (newValue !== oldValue)) {
													   $timeout( function(){
														var chart = angular.element('li[comp=' + $scope.component.id+
																		'] .highcharts-container').parent()
																		.highcharts();
														if (chart && chart.series) {
															var options ;
															if($scope.component.subType === 'mapbubble') {
															  options = chart.series[1].options;
															  options.dataLabels.enabled = newValue;															  
															  options.dataLabels.allowOverlap = true;
															  chart.series[1].update(options);
															  $scope.mapConfig.series[1].dataLabels.enabled = newValue;
															  $scope.mapConfig.series[1].dataLabels.allowOverlap = true;
															} else {
																options = chart.series[0].options;
																options.dataLabels.enabled = newValue;															  
																options.dataLabels.allowOverlap = false;
																chart.series[0].update(options);
																$scope.mapConfig.series[0].dataLabels.enabled = true;
															    $scope.mapConfig.series[0].dataLabels.allowOverlap = false;
															}
															 
														chart.redraw();
													 }
													},250);
														
												}
											});
												$scope.$on('gridsterItemWidthChanged', function(event,
														isLeftPanelToggle, componentId) {
													if ($scope.mapConfig) {
														$timeout(function() {
															if (!isLeftPanelToggle &&
																	$scope.component.id == componentId &&
																	$scope.component.mapType === 'highmap') {
																var chart = angular.element('li[comp=' + componentId +
																		'] .highcharts-container').parent()
																		.highcharts();
																chart.options.chart.height = $("#" + componentId)
																		.height() -
																		componentTitleHeight;
																chart.reflow();
															} else if (isLeftPanelToggle &&
																	$scope.component.mapType === 'highmap') {
																chart.reflow();
															} else if ($scope.component.mapType === 'mapbox') {
																// $scope.map.zoomout(1);
															}
														}, 500);
													}
												});
												$scope.drawMapPie = function(chart) {
													var maxVal = chart.series[0].points[0].value;
													Highcharts
															.each(chart.series[0].points,
																	function(point) {
																		if (!point.code) {
																			return; // Skip points with no data, if any
																		}

																		var pieOffset = point.pieOffset || {}, centerLat = parseFloat(point["plotX"]), centerLon = parseFloat(point["plotY"]);
																		// Add the pie for this point
																		var sObj = {
																			type : 'mappie',
																			name : point.code,
																			zIndex : 6, // Keep pies above connector lines
																			sizeFormatter : function() {
																				var yAxis = this.chart.yAxis[0], zoomFactor = (yAxis.dataMax - yAxis.dataMin) /
																						(yAxis.max - yAxis.min);
																				var size = point.value / maxVal * 70;
																				return size < 20 ? 20 : size;
																			},

																			tooltip : {
																				pointFormatter : null
																			},
																			//colors : customReportSvc.defaultMultiChartColors,
																			data : point.pieData,
																			center : {
																				lat : centerLat + (pieOffset.lat || 0),
																				lon : centerLon + (pieOffset.lon || 0)
																			}
																		};
																		chart.addSeries(sObj, false);
																	});
												};
												// update map series in case of bubble map
												// check for overlapping bubbles and merge them into one
												// aggregate overlapped bubble values
												$scope.updateSeries = function() {
													if ($scope.mapConfig &&
															typeof $scope.mapConfig.getHighcharts === 'function') {
														var chart = $scope.mapConfig.getHighcharts();
														if (chart && chart.series) {
															if ($scope.component.pieColumn &&
																	$scope.component.pieColumn.showAsPie) {
																$scope.drawMapPie(chart);
																chart.redraw();
															} else if($scope.component.mergeOverlappingBubbles){
																var pointsToAdd = [];
																angular
																		.forEach(chart.series,
																				function(series) {
																					// check for bubbles
																					if (!series.symbol ||
																							series.symbol !== 'circle') {
																						return;
																					}
																					angular
																							.forEach(series.points,
																									function(thisPoint) {
																										// boolean checked flag to avoid going through same point again
																										if (!thisPoint.checked) {
																											var r1 = thisPoint.shapeArgs.r, x1 = thisPoint.shapeArgs.x, y1 = thisPoint.shapeArgs.y, chosenPoints = [], newLat = 0, newLon = 0;
																											thisPoint.checked = true;
																											angular
																													.forEach(series.points,
																															function(
																																	point) {
																																if (!point.checked) {
																																	var r2 = point.shapeArgs.r, x2 = point.shapeArgs.x, y2 = point.shapeArgs.y, distanceBetweenCenters = (Math
																																			.pow((x1 - x2),
																																					2) + Math
																																			.pow((y1 - y2),
																																					2)), sumOfRadii = Math
																																			.pow((r1 + r2),
																																					2), diffOfRadii = Math
																																			.pow((r1 - r2),
																																					2);
																																	if (distanceBetweenCenters === 0 ||
																																			(diffOfRadii <= distanceBetweenCenters && sumOfRadii >= distanceBetweenCenters) ||
																																			(distanceBetweenCenters < diffOfRadii)) { // one circle inside other circle
																																		point.checked = true;
																																		chosenPoints
																																				.push(point);
																																	}
																																}
																															});

																											var newPoint = thisPoint.options;
																											var aggrValues = {};
																											// in case of numeric value, sum of all the merged bubbles
																											// in case of string just append all the values in a comma separated string
																											angular
																													.forEach(chosenPoints,
																															function(
																																	point) {
																																angular
																																		.forEach(point.options,
																																				function(
																																						value,
																																						key) {
																																					if (key !== 'lat' &&
																																							key !== 'lon' &&
																																							key !== 'code' &&
																																							value) {
																																						if (typeof aggrValues[key] === 'undefined') {
																																							aggrValues[key] = [];
																																						}
																																						if (typeof value === 'number' &&
																																								Array
																																										.isArray(aggrValues[key])) {
																																							aggrValues[key] = value;
																																						} else if (typeof value === 'number') {
																																							aggrValues[key] += value;
																																						} else if (Array
																																								.isArray(aggrValues[key]) &&
																																								aggrValues[key]
																																										.indexOf(value) === -1) {
																																							aggrValues[key]
																																									.push(value);
																																						}
																																					}
																																				});
																															});
																											angular
																													.forEach(aggrValues,
																															function(
																																	value,
																																	key) {
																																if (typeof value !== 'undefined') {
																																	if (Array
																																			.isArray(value)) {
																																		newPoint[key] = value
																																				.join(',');
																																	} else {
																																		newPoint[key] = value;
																																	}
																																}
																															});
																											pointsToAdd
																													.push(newPoint);
																										}
																									});
																					series.setData(pointsToAdd);
																				});
																$scope.$apply();
															}
														}
													}
												};

											} ]
								}
							} ]);

})();
