<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

	<ul class="secondary-header secondary-background-color">
		<li class="sub-header" title="General"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}"
			data-ng-click="selectedPropertyCategory='general'"><span
			class="ico ico-cog"></span></li>
		<li class="sub-header" title="Fields"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}"
			data-ng-click="selectedPropertyCategory='fields'"><span
			class="ico ico-form-field"></span></li>
		<li class="sub-header" title="Custom Code"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}"
			data-ng-click="selectedPropertyCategory='customcode'"><span
			class="ico ico-code"></span></li>
		<li class="sub-header" title="Filters"
			data-ng-show="ds && ds.endpoint === 'DATACUBE'"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}"
			data-ng-click="selectedPropertyCategory='filters'"><span
			class="ico ico-funnel"></span></li>
	</ul>

	<div
		data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>

	<!-- Begin "General" group -->
	<div data-ng-show="selectedPropertyCategory==='general'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message
							key="CustomReport.Properties.Title" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm"
							data-ng-model="propData.title.text" type="text" readonly="true"
							placeholder="<fmt:message key='CustomReport.Properties.ChartName'/>">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message
							key="CustomReport.Properties.ID" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							data-ng-model="propData.id"
							data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
							data-ng-blur="validateComponentId()"
							data-ng-class="{'pattern-invalid': !propData.id}">
					</div>
					<span class="inline-validation-error" data-ng-show="!propData.id">*ID
						should contain characters,digits and underscore only.</span>
					<!-- localize
          </div>                           
		  <label><fmt:message key="CustomReport.Properties.ID"/>
            <input class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" 
                   data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
            <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize -->
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message
							key="CustomReport.Properties.DataSet" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
							readonly="true" data-ng-model="propData.dataSet.dataSetName">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.HideHeader"/>'><fmt:message
							key="CustomReport.Properties.HideHeader" /></label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.hideHeader" id="hideheader">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.HideBorder"/>'><fmt:message
							key="CustomReport.Properties.HideBorder" /></label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.hideborder" id="hideborder">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.SkipFilters.Tooltip"/>'><fmt:message
							key="CustomReport.Properties.SkipFilters" /></label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.skipAllFilters" id="skipFilters" data-ng-change="refreshComponent(propData.id)"">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
	        <div class="col-xs-12">
	            <div class="form-group">
	                <label
	                    class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
	                    title='<fmt:message key="CustomReport.Properties.HideLoadingAnimation"/>'><fmt:message
	                        key="CustomReport.Properties.HideLoadingAnimation" /></label>
	                <div class="col-sm-3 noLftRghtPadding">
	                    <input type="checkbox" cv-toggle-switch
	                        data-ng-model="propData.hideLoadingAnimation" id="hideloadinganimation">
	                </div>
	            </div>
	        </div>
	    </div>

		<!-- Begin "Look and Feel" group -->
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.ToolTip"/>'><fmt:message
							key="CustomReport.Properties.ToolTip" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							data-ng-model="propData.toolTip">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.IconHtml"/>'><fmt:message
							key="CustomReport.Properties.IconHtml" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<textarea data-ng-model="propData.iconHtml"></textarea>
					</div>

				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.IconPosition"/>'><fmt:message
							key="CustomReport.Properties.IconPosition" /> </label>
					<div class="col-sm-8 noLftRghtPadding">
						<select class="form-control input-sm"
							data-ng-model="propData.iconPosition">
							<option value="left"><fmt:message
													key="CustomReport.Properties.LegendPlacementLeft" /></option>
							<option value="right"><fmt:message
													key="CustomReport.Properties.LegendPlacementRight" /></option>
						</select>
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.BackgroundColor"/>'><fmt:message
							key="CustomReport.Properties.BackgroundColor" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm seriesColor" type="color"
							data-ng-model="propData.color.backgroundColor">
					</div>
				</div>
			</div>
		</div>
		<!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                      data-ng-model="propData.mobile.visible">
                      <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                      <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>
	</div>

	<!-- Begin "Field" group -->
	<div data-ng-show="selectedPropertyCategory==='fields'">
		<div class="row noLftRghtMargin secondary-header property-header"
			data-ng-click="collapsed['measure']=!collapsed['measure']">
			<div class="col-xs-12 noLftRghtPadding">
				<span class="ico"
					data-ng-class="{'ico-chevron-down':!collapsed['measure'], 'ico-chevron-right':collapsed['measure']}"></span>
				<span>Measure</span>
			</div>
		</div>
		<div
			data-ng-if="propData.measureDataField && propData.measureDataField.length!=0"
			data-ng-class="{'collapsed': collapsed['measure']}">
			<div data-ng-repeat="measure in propData.measureDataField">
				<div
					class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
					<div class="fieldHeader"
						data-ng-click="collapsed['measure'+$index]=!collapsed['measure'+$index]">
						<label class="col-lg-9 noLftRghtPadding" title=""> <span
							data-ng-if="measure.aggrType!='None'">{{measure.aggrType}}(</span>{{measure.column}}<span
							data-ng-if="measure.aggrType!='None'">)</span>
						</label> <span class="pull-right"> <span
							class="ico inner-panel-expand-icon"
							data-ng-class="{'ico-chevron-down':!collapsed['measure'+$index], 'ico-chevron-right':collapsed['measure'+$index]}"></span>
							<span class="ico inner-panel-expand-icon ico-trash2"
							title="Remove Measure" data-ng-click="deleteMeasure($index)"></span>
						</span>
					</div>
					<div data-ng-class="{'collapsed': collapsed['measure'+$index]}">
						
						<div class="row noLftRghtMargin">
							<div class="noLftRghtPadding col-xs-12">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.Fields.CardCaption"/>'><fmt:message
											key="CustomReport.Properties.Fields.CardCaption" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input class="form-control input-sm"
											data-ng-model="measure.displayText" type="text"
											placeholder="Caption">
									</div>
								</div>
							</div>
						</div>
						<div class="row noLftRghtMargin">
							<div class="noLftRghtPadding col-xs-12">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.Fields.CaptionColor"/>'><fmt:message
											key="CustomReport.Properties.Fields.CaptionColor" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input class="form-control input-sm seriesColor" type="color"
											data-ng-model="measure.color.captionColor">
									</div>
								</div>
							</div>
						</div>
						<div class="row noLftRghtMargin">
							<div class="noLftRghtPadding col-xs-12">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.Fields.CaptionPosition"/>'><fmt:message
											key="CustomReport.Properties.Fields.CaptionPosition" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<select class="form-control input-sm"
											data-ng-model="measure.captionPosition">
											<option value="left"><fmt:message
												key="CustomReport.Properties.LegendPlacementLeft" /></option>
											<option value="right"><fmt:message
												key="CustomReport.Properties.LegendPlacementRight" /></option>							
											<option value="top" default><fmt:message
													key="CustomReport.Properties.LegendPlacementTop" /></option>
											<option value="bottom"><fmt:message
													key="CustomReport.Properties.LegendPlacementBottom" /></option>
											
										</select>
									</div>
								</div>
							</div>
						</div>
						<div id="measureAggregate" class="row noLftRghtMargin">
							<div class="form-group">
								<label
									class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
									title='<fmt:message key="CustomReport.Properties.Aggregate"/>'>
									<fmt:message key="CustomReport.Properties.Aggregate" />
								</label>
								<div class="col-sm-8 noLftRghtPadding">
									<select class="fieldPropValue input-sm"
										data-ng-model="measure.aggrType"
										data-ng-change="updateChart()">
										<option
											data-ng-if="measure.showNumberOps && ds && ds.endpoint === 'DATACUBE'"
											value="None"><fmt:message key="CustomReport.None" /></option>
										<option value="Count"><fmt:message
												key="CustomReport.Count" /></option>
										<option value="CountDistinct"><fmt:message
												key="CustomReport.Distinct" /></option>
										<option value="Top"
											data-ng-show="ds && ds.endpoint === 'DATACUBE'">Top
											One</option>
										<option value="Bottom"
											data-ng-show="ds && ds.endpoint === 'DATACUBE'">Bottom
											One</option>
										<option data-ng-if="measure.showNumberOps" value="Sum"><fmt:message
												key="CustomReport.Sum" /></option>
										<option data-ng-if="measure.showNumberOps" value="Avg"><fmt:message
												key="CustomReport.Avg" /></option>
										<option data-ng-if="measure.showNumberOps" value="Min"><fmt:message
												key="CustomReport.Min" /></option>
										<option data-ng-if="measure.showNumberOps" value="Max"><fmt:message
												key="CustomReport.Max" /></option>
									</select>
								</div>
							</div>
						</div>
						<div class="row noLftRghtMargin">
							<div class="noLftRghtPadding col-xs-12">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.Fields.AggrColor"/>'><fmt:message
											key="CustomReport.Properties.Fields.AggrColor" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input class="form-control input-sm seriesColor" type="color"
											data-ng-model="measure.color.countColor">
									</div>
								</div>
							</div>
						</div>
						<div class="row noLftRghtMargin">
							<div class="noLftRghtPadding col-xs-12">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.Fields.CaptionAlignment"/>'><fmt:message
											key="CustomReport.Properties.Fields.CaptionAlignment" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<select class="form-control input-sm"
											data-ng-model="measure.alignment">
											<option value="left" default><fmt:message
													key="CustomReport.Properties.LegendPlacementLeft" /></option>
											<option value="right"><fmt:message
													key="CustomReport.Properties.LegendPlacementRight" /></option>
											<option value="center"><fmt:message
													key="CustomReport.Properties.Fields.CaptionAlignmentCenter" /></option>
										</select>
									</div>
								</div>
							</div>
						</div>
						
						
						
						<div class="row formatter-option noLftRghtMargin">
							<div class="col-xs-12 noLftRghtPadding">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.LabelConversion"/>'>
										<fmt:message key="CustomReport.Properties.Fields.Formatter" />
									</label>
									<div class="col-sm-5 noLftRghtPadding margin-top-5">
										<span class="pull-right"> <span
											class="label label-info cursor-pointer"
											data-ng-click="showFormatterOptions(measure,'cellExpression')">{{getFormatterType(measure.cellExpression)}}</span>
										</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div data-ng-if="propData.allColumns"
			data-ng-class="{'collapsed': collapsed['measure']}">
			<div
				class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
				<div class="fieldHeader"
					data-ng-click="collapsedAllColumn=!collapsedAllColumn">
					<label class="col-lg-9 noLftRghtPadding" title=""> <span>{{propData.allColumns.displayText}}</span>
					</label> <span class="pull-right"> <span
						class="ico inner-panel-expand-icon"
						data-ng-class="{'ico-chevron-down':!collapsedAllColumn, 'ico-chevron-right':collapsedAllColumn}"></span>
						<span class="ico inner-panel-expand-icon ico-trash2"
						title="Remove Measure" data-ng-click="deleteAllColumns()"></span>
					</span>
				</div>
				<div data-ng-class="{'collapsed': collapsedAllColumn}">
					<div class="row noLftRghtMargin">
						<div class="noLftRghtPadding col-xs-12">
							<div class="form-group">
								<label
									class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
									title='<fmt:message key="CustomReport.Properties.Fields.CardCaption"/>'><fmt:message
										key="CustomReport.Properties.Fields.CardCaption" /></label>
								<div class="col-sm-8 noLftRghtPadding">
									<input class="form-control input-sm"
										data-ng-model="propData.allColumns.displayText" type="text"
										placeholder="Caption">
								</div>
							</div>
						</div>
					</div>
					<div class="row noLftRghtMargin">
						<div class="noLftRghtPadding col-xs-12">
							<div class="form-group">
								<label
									class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
									title='<fmt:message key="CustomReport.Properties.Fields.CaptionColor"/>'><fmt:message
										key="CustomReport.Properties.Fields.CaptionColor" /></label>
								<div class="col-sm-8 noLftRghtPadding">
									<input class="form-control input-sm seriesColor" type="color"
										data-ng-model="propData.allColumns.color.captionColor">
								</div>
							</div>
						</div>
					</div>
					<div class="row noLftRghtMargin">
						<div class="noLftRghtPadding col-xs-12">
							<div class="form-group">
								<label
									class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
									title='<fmt:message key="CustomReport.Properties.Fields.CaptionPosition"/>'><fmt:message
										key="CustomReport.Properties.Fields.CaptionPosition" /></label>
								<div class="col-sm-8 noLftRghtPadding">
									<select class="form-control input-sm"
										data-ng-model="propData.allColumns.captionPosition">
										<option value="left"><fmt:message
												key="CustomReport.Properties.LegendPlacementLeft" /></option>
										<option value="right"><fmt:message
												key="CustomReport.Properties.LegendPlacementRight" /></option>
										<option value="top" default><fmt:message
												key="CustomReport.Properties.LegendPlacementTop" /></option>
										<option value="bottom"><fmt:message
												key="CustomReport.Properties.LegendPlacementBottom" /></option>
									</select>
								</div>
							</div>
						</div>
					</div>
					<div class="row noLftRghtMargin">
						<div class="noLftRghtPadding col-xs-12">
							<div class="form-group">
								<label
									class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
									title='<fmt:message key="CustomReport.Properties.Fields.AggrColor"/>'><fmt:message
										key="CustomReport.Properties.Fields.AggrColor" /></label>
								<div class="col-sm-8 noLftRghtPadding">
									<input class="form-control input-sm seriesColor" type="color"
										data-ng-model="propData.allColumns.color.countColor">
								</div>
							</div>
						</div>
					</div>
					
					<div class="row noLftRghtMargin">
						<div class="noLftRghtPadding col-xs-12">
							<div class="form-group">
								<label
									class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
									title='<fmt:message key="CustomReport.Properties.Fields.CaptionAlignment"/>'><fmt:message
										key="CustomReport.Properties.Fields.CaptionAlignment" /></label>

								<div class="col-sm-8 noLftRghtPadding">
									<select class="form-control input-sm"
										data-ng-model="propData.allColumns.alignment">
										<option value="left" default><fmt:message
												key="CustomReport.Properties.LegendPlacementLeft" /></option>
										<option value="right"><fmt:message
												key="CustomReport.Properties.LegendPlacementRight" /></option>
										<option value="center"><fmt:message
												key="CustomReport.Properties.Fields.CaptionAlignmentCenter" /></option>
									</select>
								</div>
							</div>
						</div>
					</div>

					
					<div class="row formatter-option noLftRghtMargin">
						<div class="col-xs-12 noLftRghtPadding">
							<div class="form-group">
								<label
									class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding"
									title='<fmt:message key="CustomReport.Properties.LabelConversion"/>'>
									<fmt:message key="CustomReport.Properties.Fields.Formatter" />
								</label>
								<div class="col-sm-5 noLftRghtPadding margin-top-5">
									<span class="pull-right"> <span
										class="label label-info cursor-pointer"
										data-ng-click="showFormatterOptions(propData.allColumns,'cellExpression')">{{getFormatterType(propData.allColumns.cellExpression)}}</span>
									</span>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
	<!-- End "General" group -->
	<!-- Begin "FormatOptons" group -->
	<div data-ng-show="selectedPropertyCategory==='customcode'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<label> <fmt:message
						key="CustomReport.Properties.PointExpression" /><br>
				</label> 
				<div class="pull-right">
		            <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(propData.onClick,'javascript','refreshComponent(propData.id)','propData.onClick')">
		                <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddExpression"/>
		            </button>                
		        </div> 				
			</div>

		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<label> Custom Html<br>
				</label> 
				<div class="pull-right">
		            <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(propData.hitsCustomHtml,'html','refreshComponent(propData.id)','propData.hitsCustomHtml')">
		                <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddHTML"/>
		            </button>                
		        </div> 				
			</div>

		</div>
	</div>
	<!-- Begin "Filters" group -->
	<div
		data-ng-show="ds && ds.endpoint === 'DATACUBE' && selectedPropertyCategory==='filters'">
		<cvfacet config="propData" type="'properties'" page="page"
			filters="propData.filters" filter-mode="'builder'"
			report-mode="reportMode"></cvfacet>
			
		<div class="row noLftRghtMargin">
	        <div class="col-xs-12">
	            <label class="col-xs-12 noLftRghtPadding">
	                <fmt:message key="CustomReport.Properties.CustomFilterQuery"/><br>                
	            </label>
	            <span class="col-xs-12 noLftRghtPadding">
	                <textarea  data-ng-model="propData.filters.customFilterQuery" data-ng-blur="refreshComponent(propData.id)"></textarea>
	            </span>
	        </div>
	    </div>     


	</div>

	<!-- <a id="resetButton" class="mainBtn" data-ng-click="resetDefault()">
    <fmt:message key="CustomReport.Properties.ResetToDefault"/>
</a> -->

</fmt:bundle>