(function() {
	'use strict';

	angular.module("reports").controller('hitsCtrl', hitsCtrl);

	hitsCtrl.$inject = [ '$scope', 'reportService', 'customReportSvc',
			'dataSource', '$timeout', '$sce' ];

	function hitsCtrl($scope, reportService, customReportSvc, $dataSource,
			$timeout, $sce) {
	   	/*
		 * TODO move it to some common place as it is not related to a
		 * particular component
		 */
        var exportType = customReportSvc.getParameterByName("exportType");
        var readme = customReportSvc.getParameterByName("readme");        
        var isExport = false;
        if (exportType || readme === "true")
            isExport = true;

		$scope.init = function() {

			if (typeof $scope.component.color === 'undefined'
					|| $scope.component.color.backgroundColor === 'undefined') {
				$scope.component.color = {};
				$scope.component.color.backgroundColor = "#ffffff";
			}
			if (typeof $scope.component.iconPosition === 'undefined') {
				$scope.component.iconPosition = "left";
			}
			if (typeof $scope.component.hideHeader === 'undefined') {
				$scope.component.hideHeader = true;
			}
			if ($scope.component.allColumns === true){
				$scope.component.allColumns = {};
				$scope.component.allColumns.captionPosition = "top";
				$scope.component.allColumns.alignment = "center";
				$scope.component.allColumns.color = {};
				$scope.component.allColumns.color.backgroundColor = "#ffffff";
			}
			// checking if report is having old card component structure
			if ($scope.component.captionPosition || $scope.component.alignment) {
				// copy existing proprties in measure field and delete existing
				// properties
				var propertiesToMove = [ "captionPosition", "color",
						"alignment", "displayText", "caption" ,"cellExpression"];
				var fieldToChange;
				if ($scope.component.measureDataField
						&& $scope.component.measureDataField.length === 1) {
					fieldToChange = $scope.component.measureDataField[0];
				} else {
					fieldToChange = $scope.component.allColumns;
				}
				angular.forEach(propertiesToMove, function(attr) {
					fieldToChange[attr] = $scope.component[attr];
					delete $scope.component[attr];
				});

			}
			if($scope.dataSet) {// For Upgrade case
				var datasetFieldsMap = [];			
				angular.forEach($scope.dataSet.fields, function(field) {
					datasetFieldsMap[field.name] = field;
				});
				if ($scope.component.measureDataField && $scope.component.measureDataField.length > 0) {
					angular.forEach($scope.component.measureDataField, function(field) {
						if(datasetFieldsMap.hasOwnProperty(field.column))
							field.type = datasetFieldsMap[field.column].type;
					});
				}
			}
			
		}

		$scope.init();
		$scope.getDefaultProperties = function(measure) {
			measure.captionPosition = 'top';
			measure.color = {
				'captionColor' : '#000',
				'countColor' : '#000',
			};
			measure.alignment = 'center';
		};
		$scope.showHits = function(isAutoRefresh) {
			if(!isAutoRefresh) {
				$scope.component.isComponentLoading = true;
				$scope.loadingButton();
			}				
			if ($scope.dataSet.endpoint === "DATACUBE") {
				let customFilterQuery = $scope.component.filters.customFilterQuery;
				if(customFilterQuery && customFilterQuery.substring(0, 2) === ":=") {
					if(!$scope.dataSetFields) {
						$scope.dataSetFields = $.map($scope.dataSet.fields,function(field) {
							return field.dataField;
						});
					}					
					customFilterQuery = rpt.evalExpression({
						expression: customFilterQuery,
						dataSetFields: $scope.dataSetFields
					});
	
				}
				let filters = {};
				if(!$.isEmptyObject($scope.component.filters)) {
					if(!$.isEmptyObject($scope.component.filters['builder']))
						filters = customReportSvc.getDeepCopy($scope.component.filters['builder'][$scope.dataSet.dataSet.dataSetName]);
					if(customFilterQuery)
						filters.customFilterQuery = customFilterQuery;
				}
				
				var options = {
					dataSet : $scope.dataSet,
					componentType : $scope.component.type,
					isAllColumns : $scope.component.allColumns,
					measureDataField : $scope.component.measureDataField,
					filters : filters,
					inputParams : customReportSvc.applyInputsToDataSet($scope.dataSet, $scope.page.inputs),
					skipAllFilters : $scope.component.skipAllFilters
				};
				if (!$scope.dataservice) {
					if ($scope.dataSet) {
						$scope.dataservice = $dataSource
								.getDataSource($scope.dataSet.endpoint);
					}
				}
				if ($scope.dataservice) {
					$scope.dataservice.getHitsPanelData(options, function(
							aggVals) {
						onSuccessGetHits(aggVals, isAutoRefresh);
					});
				}
			} else {
				$scope.getData(undefined, false, isAutoRefresh).then(function(data) {
					// onSuccessGetChartDataForDataSet(data);
					onSuccessGetHits(data.data.records[0][0], isAutoRefresh);
				}, function(error) {
					onError(error);
				});
			}
		};

		var onSuccessGetHits = function(aggVals, isAutoRefresh) {
			$scope.component.isComponentLoading = false;
			var row = {};
			// storing count in tempComponent as we don't need to save it 
			if(!isAutoRefresh || $.isEmptyObject($scope.tempComponent) || $.isEmptyObject($scope.tempComponent.columns)) {
				$scope.tempComponent = {
					'columns' : {}
				};
			} 
			

			// in case we are getting just the allColumns value, we are getting
			// an array
			if (typeof aggVals !== 'undefined' && Array.isArray(aggVals)) {
				var tempVal = aggVals[0];
				aggVals = {};
				aggVals['totalRecords'] = tempVal;
			} else if (typeof aggVals !== 'object') {
				var tempVal = aggVals;
				aggVals = {};
				// to support other datasets, we will get only single value
				// in case of allColumns assign it to totalRecords object and it
				// will get assigned appropriately later
				if ($scope.component.allColumns
						&& $.isEmptyObject($scope.component.allColumns)) {
					aggVals['totalRecords'] = tempVal;
				} else if ($scope.component.measureDataField
						&& $scope.component.measureDataField.length === 1) {
					aggVals[$scope.component.measureDataField[0].column] = tempVal;
				}
			} else if(typeof aggVals === 'object' && aggVals && Object.keys(aggVals).length === 1 && aggVals['totalRecords'] === 0 ) {
				angular.forEach($scope.component.measureDataField,function(val,index) {
					aggVals[val.column] = 0;
				});
				
			}

			var defaultExpression = "";
			$timeout(function() {
				angular
						.forEach(
								aggVals,
								function(val, column) {
									$scope.tempComponent.columns[column] = {};
									if (column !== 'totalRecords') {
										var measure = getMeasureFieldByName(
												column,
												$scope.component.measureDataField);
										measure.cellExpression = measure.cellExpression
												|| defaultExpression;
										$scope.defaultText = $scope
												.getDefaultDisplayText(measure);
										if (!measure.displayText) {
											measure.displayText = $scope.defaultText;
										}
										if (typeof val === 'object'
												&& val.buckets) {
											if(val.buckets[0] === undefined)
												val = "N/A";
											else
												val = val.buckets[0].val;
										}
										$scope.tempComponent.columns[column].totalCount = val === "N/A" ? "N/A" : customReportSvc.getFormattedValue(val,
														measure.cellExpression, undefined, undefined, undefined, measure, $scope.dataSet).toString();
									} else if ($scope.component.allColumns) {
										var allColumns = $scope.component.allColumns;
										allColumns.cellExpression = allColumns.cellExpression
												|| defaultExpression;
										$scope.defaultText = $scope
												.getDefaultDisplayText();
										if (!allColumns.displayText) {
											allColumns.displayText = $scope.defaultText;
										}
										$scope.tempComponent.columns[column].totalCount = customReportSvc
												.getFormattedValue(
														val,
														allColumns.cellExpression, undefined, undefined, undefined, column, $scope.dataSet)
												.toString();
									} else if (column === 'totalRecords') {
										$scope.tempComponent.columns[column].totalCount = customReportSvc
												.getFormattedValue(val,
														defaultExpression, undefined, undefined, undefined, column, $scope.dataSet)
												.toString();
									}
									if ($scope.tempComponent.columns[column]) {
										row[column] = $scope.tempComponent.columns[column].totalCount;
									}
								});
				if ($scope.component.hitsCustomHtml) {

					$scope.customHtml = $sce.trustAsHtml(customReportSvc.evalExpression(
							$scope.component.hitsCustomHtml, row));
				}

				if ($scope.component.onClick) {
					angular.element(
							'li[comp=' + $scope.component.id + '] .overlay')
							.attr(
									'href',
									customReportSvc.evalExpression(
											$scope.component.onClick, row,
											null, null, null));
				}
				if (!isExport) {
					resizeHitsPanel();
				}
				
				if (isExport){
					$scope.setAllComponentsIntialized($scope.component);
				}
				
			});
		};

		var getMeasureFieldByName = function(measureName, measureDataField) {
			var measure = undefined;
			angular.forEach(measureDataField, function(measureField, index) {
				if (measureField.column === measureName) {
					measure = measureField;
				}
			});
			return measure;
		}

		$scope.dropped = function(dragEl, dropEl) {
			// Because the handler jumps "outside" of angular, updates must be
			// made in an $applied scope

			var dest = document.getElementById(dropEl);
			var src = document.getElementById(dragEl);

			var drag = angular.element(src);
			var drop = angular.element(dest);
			var columnName = drag.attr("data-name");

			var dataSetEntity = drag.data("datasetentity");
			var dataSetName = dataSetEntity.dataSetName;
			if (!$scope.component.dataSet
					|| !$scope.component.dataSet.dataSetName) {
				$scope.associateDataSetToComponent(dataSetEntity);
			} else if ($scope.component.dataSet.dataSetName != dataSetName) {
				alert("Mismatched data Sets");
				return;
			}

			$scope.totalCount = 0;

			if (columnName == "allColumns") {
				$scope.component.allColumns = {};
				$scope.getDefaultProperties($scope.component.allColumns);
				$scope.component.allColumns.cellExpression = "";
			} else {
				var measure = {
					'column' : drag.attr("data-name"),
					 type : drag.attr("data-type")
				};
				var arr = [ 'Double', 'Float', 'Integer', 'Long', 'Short',
						'Decimal' ];
				if (arr.indexOf(drag.data('type')) != -1) {
					measure.showNumberOps = true;
					measure.aggrType = 'Sum';// default it to Sum for numeric
					// fields
				} else {
					measure.aggrType = 'CountDistinct';
				}
				$scope.getDefaultProperties(measure);
				if (typeof $scope.component.measureDataField === 'undefined') {
					$scope.component.measureDataField = [];
				}
				measure.cellExpression = "";
				$scope.component.measureDataField.push(measure);
			}
			$scope.$apply();
		};
		$scope.$watchCollection("component.displayText", function() {
			if ($scope.defaultText != $scope.component.displayText) {
				$scope.component.caption = $scope.component.displayText;
			}
		});
		customReportSvc
				.registerCallback(
						"updateChart",
						function() {
							if ($scope.component.measureDataField[0].aggrType === "Top"
									|| $scope.component.measureDataField[0].aggrType === "Bottom") {
								$scope.component.cellExpression = "";
							}
							$scope.showHits();
						}, $scope.component.id);

		$scope.$watchCollection("component.measureDataField", function() {
			if ($.isEmptyObject($scope.component.measureDataField)) {
				return;
			}
			$scope.showHits();
		});
		$scope.$watch("component.allColumns", function() {
			if ($scope.component.allColumns !== undefined) {
				$scope.showHits();
			}
		});

		customReportSvc.registerCallback("redrawAllComponents", function(data, isAutoRefresh) {
			$scope.showHits(isAutoRefresh);
		});

		customReportSvc.registerCallback("refreshComponent", function(
				componentId) {
			if ($scope.component.id === componentId) {
				$scope.showHits();
			}
		}, $scope.component.id);

		$scope.$on('resize', function() {
			resizeHitsPanel();
		});
		$scope.$on('gridsterItemWidthChanged', function() {
			var newSize = $("li[comp=" + $scope.component.id + "]").find(
					".component-body").height();
			$("li[comp=" + $scope.component.id + "]").find(".hits-count").css(
					"font-size", newSize + "%");
		});
		$scope.getDefaultDisplayText = function(measure) {
			if (!measure) {
				return localMsg.TotalNoOfResults;
			} else if (measure.aggrType) {
				return customReportSvc.getDispTextForAgg(measure.aggrType)
						+ " of " + measure.column;
			}
		};
		var resizeHitsPanel = function() {
			var newSize = $("li[comp=" + $scope.component.id + "]").find(
					".component-body").height();
			var noOfFields = (($scope.component.measureDataField || []).length || 1)
					+ ($scope.component.allColumns ? 1 : 0);
			if (noOfFields !== 1) {
				newSize = newSize / noOfFields + (newSize / (noOfFields * 2));
			}
			$("li[comp=" + $scope.component.id + "]").find(".hits-count,.title").css(
					"font-size", newSize + "%");
			
		}

		$scope.$on('LVL-DRAG-START', function() {
			$scope.isFieldDragging = true;
			$scope.$apply();
		});

		$scope.$on('LVL-DRAG-END', function() {
			$scope.isFieldDragging = false;
			$("li[comp=" + $scope.component.id + "] .overlay").removeClass(
					'lvl-over')
			$scope.$apply();
		});
	}
})();
