<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.ReportsPlusMessages">
<div class="dataset-modal" cv-draggable drag-handler=".modal-header" drag-parent=".modal-dialog" data-keyboard="false" data-backdrop="static">
	<div class="modal-header">
		<h3 class="modal-title" id="modal-title"><fmt:message key='CustomReport.ACReport.addReport'/></h3>
	</div>
	<div class="modal-body" id="modal-body">
		<form>
		 <div class="form-group">
		 	<label for="reportsList"><fmt:message key='CustomReport.Properties.RenamePageID'/></label>
		 	<input type="text" class="form-control" data-ng-model="titleText" ></input>
		 </div>
		 <div class="form-group">
		 	<label for="reportsList"><fmt:message key='CustomReport.QuickAnalysis.Type'/></label>
		 	<select class="form-control" data-ng-model="frameType"  data-ng-options="frame as frame for frame in frameTypes"></select>
		 </div>
		 <div class="form-group" data-ng-show="frameType === 'Report'">
		 	<label for="reportsList"><fmt:message key='CustomReport.Properties.SelectReport'/></label>
		 	<select class="form-control" data-ng-model="reportId" data-ng-change="getReportDefintions(reportId)" data-ng-options="report.userReportId as report.reportName for report in reportsList"></select>
		 </div>
		 <div class="form-group" data-ng-show="frameType === 'Report'">
		 	<label for="reportsList"><fmt:message key='CustomReport.Properties.SelectPage'/></label>
		 	<select class="form-control" data-ng-model="pageName" data-ng-change="updateComponents(pageName)" data-ng-options="page.value as page.label for page in pageList"></select>
		 </div>
		 <div class="form-group" data-ng-show="frameType === 'Report'">
		 	<label for="reportsList"><fmt:message key='CustomReport.Properties.SelectComponent'/></label>
		 	<select class="form-control" data-ng-model="componentId" data-ng-options="comp.value as comp.label for comp in componentsList"></select>
		 </div>
		 <div class="form-group" data-ng-show="frameType === 'Custom'">
		 	<label for="reportsList"><fmt:message key='CustomReport.Properties.ImageType.url'/></label>
		 	<input type="text" class="form-control" data-ng-model="url" ></input>
		 </div>

		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" type="button" ng-click="updateUrlAndClose()"><fmt:message key='CustomReport.Add'/></button>
		<button class="btn btn-warning" type="button" ng-click="$close()"><fmt:message key='CustomReport.Cancel'/></button>
	</div>
</div>
</fmt:bundle>