(function() {
	'use strict';

	angular.module("reports").controller('facetCtrl', facetCtrl).filter({'byRange' : [function(){
	  return function (arr, totalCnt) {
	      return arr.filter(function(item, index){
	          return index >= totalCnt ;
	      });
	  }
	}],
	'filterByGroups' : ["customReportSvc",function(customReportSvc){
	  return function (data, $scope, dataSetName, field) {
	  	if(field && data) {
	  		 const isCustomGroupAvailable = field.customGroupsAvailable && !$.isEmptyObject(field.groups);
			  if(isCustomGroupAvailable && field.formatter)
			   	return data;
		      if(isCustomGroupAvailable) {
		      	 return data.filter(item => {					   
		      	 	return (field.includeUngrouped && field.ungroupedLabel === item.val) || (field.groups.filter(group => {
		      	 		return group.groupName === item.val;
		      	 	}).length > 0);
		      	 });
		      } else if(field.formatter) {
		      	const dataSet = $scope.getDataSetByName(dataSetName);
		      	return data.filter(item => {
			      	const formattedVal = customReportSvc.getFormattedValue(item.val, field.formatter, undefined, undefined, undefined, field, dataSet);
			      	return (formattedVal && formattedVal !== item.val) ? true : false;
			    });
		      } else {
		      	return data;
		      }
		  }
	  	}

	}]
	});
	facetCtrl.$inject = ['$scope', '$rootScope', 'reportService', 'customReportSvc', 'dataSource', '$timeout','$uibModal','$location', '$sanitize'];

	function facetCtrl($scope, $rootScope, reportService, customReportSvc, $dataSource, $timeout, $uibModal,$location, $sanitize) {
		var integerDataTypes = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];
		var dateTypes = [ 'TimeStamp', 'Date' ];
		var panelTitleHeight = $scope.reportMode === 'viewer' ? ($scope.config.hideHeader ? 0 : 28) : 37,panelFooterHeight=30,
		panelHeaderHeight=40,filterTableHeaderHeight = 37,tilePadding = 14;


		var getDefaultAdvancedFilters = function(fieldName) {
			var advancedFilter = {
				'filters' : [],
				'logic' : 'and'
			};
			var filter1 = {
				'field' : fieldName,
				'operator' : 'eq',
				'value' : ''
			};
			var filter2 = {
				'field' : fieldName,
				'operator' : 'eq',
				'value' : ''
			};
			advancedFilter.filters.push(filter1);
			advancedFilter.filters.push(filter2);
			return advancedFilter;
		}

		$scope.assignAdditionalFieldProperties = function(field,fieldType) {
			if(integerDataTypes.indexOf(fieldType) !== -1)
				field.showNumberOps =  true;
			field.type = fieldType;
			field.filterType = 'basic';
			field.selectAll = false;
			field.isVisible = true;
			var advancedFilter = getDefaultAdvancedFilters(field.column);
			// adding current dimension field as measure field
			// TODO: avoid this for date type fields
			field.measureDataFields = [ getDefaultMeasureFieldProperties(field.column) ];
			field.advancedFilters.push(advancedFilter);
		}

		var getDefaultFieldProperties = function(fieldName,includeAllPoints) {
			var maxPoints = $scope.config.showOnlyBasicFilter ? 5 : 15;
			var field = {
				'displayName' : fieldName,
				'column' : fieldName,
				'numPointsToDisplay' : {
					'includeAll' : includeAllPoints ? true : false,
					'maxPoints' : maxPoints
				},
				'advancedFilters' : [],
				'selectAll' : false,
				'sort' : {
					sortField : 'Count_' + fieldName,
					sortDirection : 'desc'
				}
			};
			return field;
		};

		var getDefaultMeasureFieldProperties = function(fieldName) {
			var field = {
				'displayName' : fieldName,
				'column' : fieldName,
				'showNumberOps' : false,
				'aggrTypes' : [ 'Count' ]
			};
			return field;
		};

		$scope.getDataSetByName = function(dataSetName) {
			if ($.isEmptyObject($scope.dataSets) || (dataSetName || "").trim() === "") {
				return undefined;
			}
			var dataSet = undefined;
			angular.forEach($scope.dataSets, function(eachDataSet, index) {
				if (eachDataSet.dataSet.dataSetName === dataSetName) {
					dataSet = eachDataSet;
					return;
				}
			});
			if (dataSet) {
				return dataSet;
			} else {
				return undefined;
			}
		}

		$scope.applyBookmarkFilters = function () {
			function applyfilters(filterObj, dataSetName,type) {
				if (!$.isEmptyObject(filterObj))
                {
                    var dataSet = $scope.getDataSetByName(dataSetName);
                    if (dataSet && dataSet.endpoint === "DATACUBE") {
                        var options = {
	                        dataSet : dataSet,
	                        filters : filterObj,
	                        isExact : true,
	                        filterType: "component_"+type
	                    };
	                    $scope.$emit('addFilters', options);

                    } else {
                    	//TODO Add code to apply filters for other datasets
                    	/*$scope.config.filterField = dataSetUtility.getFieldDefintion(filterObj,dataSet);*/
                    }

                }
			}
			angular.forEach($scope.filters.viewer, function(filterObj, dataSetName) {
				applyfilters(filterObj, dataSetName,"viewer");
            });

            angular.forEach($scope.filters.builder, function(filterObj, dataSetName) {
				applyfilters(filterObj, dataSetName,"builder");
            });
		}

		$scope.addBookmarkFilters = function() {
			$scope.requestParams = customReportSvc.getDeepCopy($location.search());
			if($.isEmptyObject($scope.requestParams))
				$scope.requestParams = customReportSvc.getUrlParams();

			angular.forEach($scope.requestParams, function(paramVal,paramKey) {
				paramVal = decodeURIComponent(paramVal);
				if(typeof paramVal === 'string' && paramKey.indexOf(".filter.") !== -1) {
					let params = paramKey.split("."),
					selType = "",
					compId = params[0],
					fieldName, reportName;
					if(!$scope.config.useCompIdFromField && compId !== $scope.config.id)
						return true;
					if ((params || []).length === 3) {
						fieldName = params[2];
					} else if ((params || []).length === 4) {
						selType = params[2];
                        fieldName = params[3];
					} else if ((params || []).length === 5) {
						// If filters are applied across reports, component is prefixed with report name
						reportName = params[0];
						compId = params[1]
						selType = params[3];
						fieldName = params[4];
					}
					if(fieldName.indexOf("-") !== -1)
						fieldName = fieldName.split("-")[0];

					try {
						paramVal = JSON.parse(paramVal);
					} catch(exp) {
					}

					let dataSetName,dataSet,filterField,isCustomGroupAvailable,customGroup;
					angular.forEach($scope.config.filterDataField.viewer, function (filterFieldObj, dsName) {
                        angular.forEach(filterFieldObj.fields, function(field) {
                            if (field.column === fieldName) {
                            	filterField = field;
                                dataSetName = dsName;
                                isCustomGroupAvailable = filterField.customGroupsAvailable && !$.isEmptyObject(filterField.groups);
                                if(isCustomGroupAvailable) {
                                	let urlParams = customReportSvc.getUrlParams(),
									customInputs = customReportSvc.getCustomInputs(urlParams,$scope.page.inputs);

                                	customGroup = customReportSvc.getSelectedCustomGroupObject(field, paramVal, customInputs);
                                	if(customGroup)
                                		paramVal = customGroup;
                                }

                                 if(field.showEmptyValues && field.emptyValueLabel === paramVal) {
                                	paramVal = qb.rv.getQueryForEmptyVal();
                                }
                                return false;
                            }
                        });
                        if (dataSetName) {
                            return false;
                        }
                    });
					dataSet = $scope.getDataSetByName(dataSetName);
					let isDateRangeFilter = $scope.config.isDateRange(filterField,dataSetName) && !(isCustomGroupAvailable && selType === "include");
					//for advanced and daterange filters we don't need to change request parameter object

               		if(!(isDateRangeFilter || ($.isArray(paramVal) && selType === ""))) {
               			let paramName = compId + ".filter." + selType + "." + fieldName;
               			//delete original request param coming from url as it's indexed based key
	                   	if(paramName !== paramKey)
	                   		delete $scope.requestParams[paramKey];

	                    if (!$scope.requestParams[paramName]) {
	                        $scope.requestParams[paramName] = [];
	                    }
	                    if($.inArray((paramVal.groupName || paramVal),$scope.requestParams[paramName]) === -1)
	                   		 $scope.requestParams[paramName].push(paramVal.groupName || paramVal);

	                }

                    if($.isEmptyObject($scope.filters.viewer[dataSetName])) {
						 $scope.filters.viewer[dataSetName] = {
						 	fieldName : {}
						 };
					}
					if($.isEmptyObject($scope.filters.viewer[dataSetName][fieldName])) {
						$scope.filters.viewer[dataSetName][fieldName] = {
							include : [],
							exclude : []
						}
					}
					let currentFilterParam = $scope.filters.viewer[dataSetName][fieldName];

					if(isDateRangeFilter) {
						currentFilterParam['daterange'] = paramVal;
					} else if($.isArray(paramVal) && selType === "") {//Advanced
						let advancedFilters = [getDefaultAdvancedFilters(fieldName)];
						advancedFilters[0].filters[0].operator = paramVal[0].operator;
						advancedFilters[0].filters[0].value = paramVal[0].value;
						advancedFilters[0].filters[1].operator = paramVal[1].operator;
						advancedFilters[0].filters[1].value = paramVal[1].value;
						filterField.isAdvancedFilterApplied = true;
						filterField.advancedFilters = currentFilterParam["advancedFilters"] = advancedFilters;
					} else {
						const index = currentFilterParam[selType].findIndex(filterVal => {
							return ((filterVal.groupName || filterVal) === (paramVal.groupName || paramVal));
						});
						if(index === -1)
							currentFilterParam[selType].push(paramVal);
					}

				}
			});

			$scope.applyBookmarkFilters();
		}

		$scope.updateUrlWithSelFilters = function(field, selType, value, addMultiple, dataSetName) {
			if(selType)
				selType += ".";
			const compId = $scope.config.useCompIdFromField ? field.componentId : $scope.config.id;
			let name = compId + ".filter." + selType + field.column;

			if ($scope.config.filterAcrossReports && name.indexOf('.filter.') !== -1) {
				// In case filter is from another report, we need to match without the component id using the filter type and value combination
				Object.keys($scope.requestParams).forEach(key => {
					if (key.substring(key.indexOf('.') + 1) === name.substring(name.indexOf('.') + 1)) {
						if (value === '' || (Array.isArray($scope.requestParams[key]) && !_.isUndefined($scope.requestParams[key].find(val => val === value)))) {
							name = key;
							return;
						}
					}
				});
			}
			const emptyVal = qb.rv.getQueryForEmptyVal();
            if(emptyVal === value)
                value = field.emptyValueLabel;

			if (addMultiple) {
                if($.isEmptyObject($scope.requestParams[name]))
                	$scope.requestParams[name] = [];

                let valIndex = $scope.requestParams[name].indexOf(value);
                if(valIndex === -1) {
                    $scope.requestParams[name].push(value);
                } else {
                    $scope.requestParams[name].splice(valIndex,1);
                }
            } else {
                if (typeof value !== "undefined" && value !== ""){
                    $scope.requestParams[name] = value;
                } else {
                    delete $scope.requestParams[name];
                }
            }
            //we are pushing filters value of daternage and advanced  as is.
            //For basic filters(include/exclude)  we push array value with index based key.
           	let addValAsArray = selType === "",
           	addIndexBasedKeys = selType !== "",
            url = dataSetUtility.requestToUrl($scope.requestParams,addValAsArray,addIndexBasedKeys);
            if(customReports.appName === 'webconsole') {
                history.pushState($scope.requestParams, document.title, "?" + url);
            } else if ($scope.config.filterAcrossReports) {
                $rootScope.$broadcast('pushToUrlWithReportName', $scope.requestParams, undefined, undefined, url.split('&'), $scope.config.reportName);
            } else {
                $location.search(url);
            }
		}

		$scope.addAllColumnsToFilter = function() {
			var dataSetName = $scope.config.dataSet.dataSetName,
			isFilterFieldsAvailable = !$.isEmptyObject($scope.config.filterDataField) &&
			!$.isEmptyObject($scope.config.filterDataField[$scope.filterMode]) &&
			!$.isEmptyObject($scope.config.filterDataField[$scope.filterMode][dataSetName]) &&
			$scope.config.filterDataField[$scope.filterMode][dataSetName].fields &&
			$scope.config.filterDataField[$scope.filterMode][dataSetName].fields.length>0,
			dataSet = $scope.getDataSetByName(dataSetName),
			fieldObj,fields = [],columnsToDisplay,isFieldAlreadyAdded;
			if(isFilterFieldsAvailable)
				fields = $scope.filterDataField[$scope.filterMode][dataSetName].fields;
			 else {
				columnsToDisplay = $scope.config.columnsToDisplay;
				$scope.filterDataField[$scope.filterMode] = {};
				$scope.filterDataField[$scope.filterMode][dataSetName] = {
					'fields' : [],
					'groups' : []
				};
				if(columnsToDisplay) {
					var operator = "or",noOfColsToDisp = dataSet.length;
					if(columnsToDisplay.operator)
						operator = columnsToDisplay.operator.toLowerCase().trim();
					if(columnsToDisplay.noOfColumns)
						noOfColsToDisp = columnsToDisplay.noOfColumns;
				}
			}
			var remainingFields,fieldObj,isAddField;
			if($scope.allColumnsDropped || (!isFilterFieldsAvailable && columnsToDisplay && columnsToDisplay.columnProperties)) {
				remainingFields = $.map(dataSet.fields, function(field) {
					if(!$scope.allColumnsDropped) {
						var filteredProp = columnsToDisplay.columnProperties.filter(function(property) {
							return field[property.propertyName] === property.propertyValue;

						}).length;
						isAddField = operator === "or" ? filteredProp > 0 : filteredProp === columnsToDisplay.columnProperties.length;
					}

					if($scope.allColumnsDropped || (isAddField && fields.length < noOfColsToDisp)) {
						fieldObj = getDefaultFieldProperties(field.name,field.showComboBox);
						$scope.assignAdditionalFieldProperties(fieldObj,field.type);
						fields.push(fieldObj);
					} else
						return field;
				});

				if(!$scope.allColumnsDropped && fields.length < noOfColsToDisp) { //add remaining fields
					for(var i = 0; i < remainingFields.length; i++) {
					 	var field = remainingFields[i];
				 		fieldObj = getDefaultFieldProperties(field.name,field.showComboBox);
						$scope.assignAdditionalFieldProperties(fieldObj,field.type);
						fields.push(fieldObj);
						if(fields.length >= noOfColsToDisp)
							break;

					 }
				}
				$scope.filterDataField[$scope.filterMode][dataSetName].fields = fields;
				if($scope.allColumnsDropped)
					$scope.showFacet(true);

			}
		}

		$scope.init = function() {
			$scope.parentObj = {}; // will be helpful in case of directives (like ng-repeat) which creates isolated scopes
			$scope.parentObj.collapsed = {};
			if($.isEmptyObject($scope.dataSets))
				$scope.dataSets = [];

			if (!$.isEmptyObject($scope.page) && !$.isEmptyObject($scope.page.dataSets) &&
					!$.isEmptyObject($scope.page.dataSets.dataSet)) {
				$scope.dataSets = $scope.page.dataSets.dataSet;
			}
			if ($scope.type === 'component') {
				if (!$scope.config.filterDataField) {
					$scope.config.filterDataField = {
						"builder" : {},
						"viewer" : {}
					};
				}
				$scope.filterDataField = $scope.config.filterDataField;
				$scope.config.filterMode = $scope.filterMode;
				if (typeof $scope.config.applyOnSelect === 'undefined') {
					$scope.config.applyOnSelect = true;
				}


			} else {
				$scope.filterDataField = {};
			}
			$scope.dateRangeFields = {};
			if ($scope.config && !$scope.config.id) {
				// in case of page level filters id will be undefined assigning pageName as id and type as 'Page' no need to delete explicitly as page object is outside of
				// json structure and the following parameters will not get saved without mapping in .x
				$scope.config.id = $scope.config.pageName;
				$scope.config.type = 'Page';
			}

			$scope.exportType = customReportSvc.getParameterByName("exportType");
			if ($scope.exportType) {// Required for export to work
            			$scope.setAllComponentsIntialized($scope.config);
			}

			if ($scope.config.allColumns && $scope.config.dataSet)
				$scope.addAllColumnsToFilter();

		};
		$scope.init();


		var getOpOperand = function(expr, advFl, index) {
			var startsIndex = -1, operator = "eq", valueIndex = 0;
			if ((startsIndex = expr.indexOf("!=")) != -1) {
				operator = "neq";
				valueIndex = startsIndex + 2;
			} else if ((startsIndex = expr.indexOf(">=")) != -1) {
				operator = "geq";
				valueIndex = startsIndex + 2;
			} else if ((startsIndex = expr.indexOf(">")) != -1) {
				operator = "greater";
				valueIndex = startsIndex + 1;
			} else if ((startsIndex = expr.indexOf("<=")) != -1) {
				operator = "leq";
				valueIndex = startsIndex + 2;
			} else if ((startsIndex = expr.indexOf("<")) != -1) {
				operator = "less";
				valueIndex = startsIndex + 1;
			} else if ((startsIndex = expr.indexOf("contains:")) != -1) {
				operator = "contains";
				valueIndex = startsIndex + 9;
			} else if ((startsIndex = expr.indexOf("notcontains:")) != -1) {
				operator = "doesnotcontain";
				valueIndex = startsIndex + 12;
			} else if ((startsIndex = expr.indexOf("begins:")) != -1) {
				operator = "startswith";
				valueIndex = startsIndex + 7;
			} else if ((startsIndex = expr.indexOf("!begins:")) != -1) {
				operator = "doesnotstartswith";
				valueIndex = startsIndex + 7;
			} else if ((startsIndex = expr.indexOf("=")) != -1) {
				operator = "eq";
				valueIndex = startsIndex + 1;
			}
			advFl.filters[index].operator = operator;
			advFl.filters[index].value = expr.substring(valueIndex);
		};
		var getAdvancedFilters = function(fieldName, advancedFilters, dataSetName, dataSets) {
			var endpoint = "DATACUBE";
			angular.forEach(dataSets, function(dataSet) {
				if (dataSet.dataSet.dataSetName === dataSetName) {
					endpoint = dataSet.endpoint;
				}
			});
			if (endpoint !== "DATACUBE") {
				var filterStr = advancedFilters[0];
				filterStr = JSON.parse(filterStr)[0];
				advancedFilters = getDefaultAdvancedFilters(fieldName);
				if (filterStr.indexOf(" or ") != -1) {
					var expr = filterStr.split(" or ");
					advancedFilters.logic = "or";
					getOpOperand(expr[0], advancedFilters, 0);
					if (expr.length > 1) {
						getOpOperand(expr[1], advancedFilters, 1);
					}
				} else {
					var expr = filterStr.split(" and ");
					advancedFilters.logic = "and";
					getOpOperand(expr[0], advancedFilters, 0);
					if (expr.length > 1) {
						getOpOperand(expr[1], advancedFilters, 1);
					}
				}
				return [ advancedFilters ];
			}
			return advancedFilters;
		};
		// component specific properties can be initialized here as there will be only one directive per component
		$scope.initComponent = function(compInitialized) {
			$scope.requestparams = {};
			if (!$scope.config.orientation) {
				$scope.config.orientation = 'vertical';
			}

			if (!$scope.filterDataField) {
				return;
			}
			angular.forEach($scope.filterDataField[$scope.filterMode], function(dataSetObj, dataSetName) {
				angular.forEach(dataSetObj["fields"], function(fieldObj, i) {
					if(compInitialized && $scope.config.addFieldsDefinition) {
						let field = getDefaultFieldProperties(fieldObj.column,fieldObj.showComboBox);
						fieldObj = angular.extend(field,fieldObj);
						$scope.assignAdditionalFieldProperties(fieldObj,fieldObj.type);
						$scope.filterDataField[$scope.filterMode][dataSetName].fields[i] = fieldObj;
					}

					if(typeof fieldObj.isFliterApplied === 'undefined')// for the upgrade case
						fieldObj.isFliterApplied = true;

					if(typeof fieldObj.isVisible  === 'undefined') // for upgrade case
						fieldObj.isVisible = true;

					if(typeof fieldObj.showSearchBar  === 'undefined' && !$scope.config.isDateRange(fieldObj, dataSetName)) // for upgrade case
						fieldObj.showSearchBar = ($scope.type === 'component' && !$scope.config.showSearchBar) ? false : true;



					var fieldName = fieldObj.column;
					// adding new properties for existing filter panel fields
					// adding measureDataFields for exising fields
					// TODO: avoid this for date type fields
					if (!fieldObj.measureDataFields || $.isEmptyObject(fieldObj.measureDataFields)) {
						fieldObj.measureDataFields = [ getDefaultMeasureFieldProperties(fieldObj.column) ];
					}
					// adding sorting object for existing field
					if (!fieldObj.sort || $.isEmptyObject(fieldObj.sort)) {
						fieldObj.sort = {
							sortField : 'Count_' + fieldName,
							sortDirection : 'desc'
						};
					}

					var filters = $scope.filters[$scope.filterMode][dataSetName];
					if (filters && !$.isEmptyObject(filters[fieldName])) {
						if (!$.isEmptyObject(filters[fieldName].advancedFilters)) {
							fieldObj.advancedFilters = getAdvancedFilters(fieldName,
									filters[fieldName].advancedFilters,
									dataSetName,
									$scope.dataSets);// filters[fieldName].advancedFilters;
							fieldObj.filterType = 'advanced';
						} else {
							var advancedFilter = getDefaultAdvancedFilters(fieldName);
							fieldObj.advancedFilters = [ advancedFilter ];
							if(fieldObj.filterType === undefined)
								fieldObj.filterType = 'basic';
						}
						if (!fieldObj.selectAll) {
							if (!$.isEmptyObject(filters[fieldName].exclude)) {
								fieldObj.selectAll = true;
							} else {
								fieldObj.selectAll = false;
							}
						}
					} else if ($.isEmptyObject(fieldObj.advancedFilters)) {
						var advancedFilter = getDefaultAdvancedFilters(fieldName);
						fieldObj.advancedFilters = [ advancedFilter ];
						if(fieldObj.filterType === undefined)
							fieldObj.filterType = 'basic';
					}
					if (filters && filters[fieldName] && filters[fieldName].daterange) {
						$scope.config.isDateRange(fieldObj, dataSetName, filters[fieldName].daterange);
					}
					if(compInitialized && !$.isEmptyObject($scope.filters) && !$.isEmptyObject($scope.filters[$scope.filterMode]) && !$.isEmptyObject($scope.filters[$scope.filterMode][dataSetName])
						&& !$.isEmptyObject($scope.filters[$scope.filterMode][dataSetName][fieldObj.column])) {
						angular.forEach($scope.filters[$scope.filterMode][dataSetName][fieldObj.column], function(filterValue,filterType) {
							if(!$.isEmptyObject(filterValue)) {
								$scope.setFilterMap(filterValue,fieldObj,dataSetObj,filterType==="advancedFilters",filterType,dataSetName,0);
							}
						});
					}
				});
			});

			if($scope.reportMode === 'viewer' && compInitialized && $scope.config.processUrlParamaters)
				$scope.addBookmarkFilters();

		};

		/**
		 * initialize properties in case component is getting used in properties.
		 *
		 * @return {[type]} [description]
		 */
		$scope.initProperties = function() {

			$scope.filterDataField = {};
			$scope.filterDataField[$scope.filterMode] = {};
			angular.forEach($scope.filters['builder'], function(fieldObj, dataSetName) {
				var filters = $scope.filterDataField[$scope.filterMode][dataSetName] = {
					'fields' : []
				};
				angular.forEach(fieldObj, function(filterObj, fieldName) {
					var dataSet = $scope.getDataSetByName(dataSetName);
					var field = getDefaultFieldProperties(fieldName);
					field.measureDataFields = [ getDefaultFieldProperties(fieldName) ];
					field.measureDataFields[0].aggrTypes = [ 'Count' ];
					var type = '';
					angular.forEach(dataSet.fields, function(fieldObj, index) {
						if (fieldObj.dataField === field.column) {
							type = fieldObj.type;
							return;
						}
					});
					if (integerDataTypes.indexOf(type) !== -1) {
						field.measureDataFields[0].showNumberOps = true;
						field.showNumberOps = true;
					}
					if (!$.isEmptyObject(filterObj.advancedFilters)) {
						field.filterType = 'advanced';
						field.advancedFilters = filterObj.advancedFilters;
						field.isAdvancedFilterApplied = true;
					} else {
						if(field.filterType === undefined)
							field.filterType = 'basic';
						var advancedFilter = getDefaultAdvancedFilters(fieldName);
						field.advancedFilters.push(advancedFilter);
					}
					field.selectAll = false;
					if (fieldObj && fieldObj[fieldName] && fieldObj[fieldName].daterange) {
						$scope.config.isDateRange(field, dataSetName, fieldObj[fieldName].daterange);
					}
					filters['fields'].push(field);
				});
			});
		};

			$scope.isSelectedVal = function(facet, field, dataSetName) {
			var currentFilterMode;
			var currentFilter;
			var currentParamFilter;
			var isSelected = true;
			let facetValue = facet.val;
			if(field.showEmptyValues & facetValue === field.emptyValueLabel) {
				facetValue = qb.rv.getQueryForEmptyVal();
			} 
			var isSelectAll = (field.customGroupsAvailable && !$.isEmptyObject(field.groups)) ? false : field.selectAll;
			if ($.isEmptyObject($scope.filters)) {
				isSelected = isSelectAll ? true : false;
			} else if ($.isEmptyObject(currentFilterMode = $scope.filters[$scope.filterMode])) {
				isSelected = isSelectAll ? true : false;
			} else if ($.isEmptyObject(currentFilter = currentFilterMode[dataSetName])) {
				isSelected = isSelectAll ? true : false;
			} else if ($.isEmptyObject(currentParamFilter = currentFilter[field.column])) {
				isSelected = isSelectAll ? true : false;
			} else if (!isSelectAll && ($.isEmptyObject(currentParamFilter["exclude"]))) { // including values
				if ($.isEmptyObject(currentParamFilter["include"]) ||
						currentParamFilter["include"].indexOf(facetValue) === -1) {
					isSelected = false;
				}
				if (field.customGroupsAvailable && !$.isEmptyObject(field.groups)) {
					if(currentParamFilter["include"].indexOf(facetValue) === -1)
						isSelected = $scope.checkIfCustomGroupSelected(facet, field, "include", currentParamFilter);
				}
			} else if (isSelectAll || (!$.isEmptyObject(currentParamFilter["exclude"]))) { //excluding values so everything will be selected by default
				if ($.isEmptyObject(currentParamFilter["exclude"]) ||
						currentParamFilter["exclude"].indexOf(facetValue) !== -1) {
					isSelected = false;
				}
				if (!$.isEmptyObject(currentParamFilter["exclude"])) {
					field.selectAll = true;
				} else {
					isSelected = true;
				}
				if (field.customGroupsAvailable && !$.isEmptyObject(field.groups)) {
					isSelected = $scope.checkIfCustomGroupSelected(facet, field, "exclude", currentParamFilter);
				}
			}

			if (!isSelectAll && $scope.getDataSetByName(dataSetName).endpoint != "DATACUBE") {
				var cfilters = $scope.$parent.$parent.$parent.requestParms[$scope.config.id+".filter."+field.column]
				if(cfilters && JSON.parse(cfilters).indexOf(facetValue) !== -1){
					isSelected = true;
				}
			}
			facet.isSelected = isSelected;
			return isSelected;
		};

		$scope.getBarWidth = function(itemCount, maxCount) {
			if (itemCount === 0 || maxCount === 0) {
				return "0";
			}
			var width = itemCount / maxCount * 100;
			return width <= 1 ? "1px" : width + "%";
		}
		$scope.config.refreshFilterPanelHeader = function(dataSetName,fieldName,headerDisplayName,measure,aggrType) {
			var fields = $scope.tempDatasetObj[dataSetName][fieldName];
			angular.forEach(fields,function (val,i) {
				if(val.measure === measure && val.aggrType === aggrType) {
					val.displayName = headerDisplayName;
					return;
				}
			});

		}
		$scope.showFacet = function(isLoadProperties, fieldToShow, fieldsDataset,doNotGetData, isAutoRefresh) {
			var filterMode = $scope.filterMode;
			if (isLoadProperties && $scope.type === 'component') {
				$scope.initComponent();
			} else if (isLoadProperties) {
				$scope.initProperties();
			}
			if ($.isEmptyObject($scope.filterDataField) || $.isEmptyObject($scope.filterDataField[filterMode])) {
				return;
			}
			if ($scope.type === 'component' && !isAutoRefresh) {
				$scope.config.isComponentLoading = true;
				$scope.$emit('loadingButton', $scope.config);
			}

			if(!fieldToShow && !doNotGetData && !isAutoRefresh)
				$scope.data = {};
			if(!$scope.tempDatasetObj)
				$scope.tempDatasetObj = {};


			 var isAsync = false;
			angular.forEach($scope.filterDataField[filterMode], function(fieldObj, dataSetName) {
				var dataSet = $scope.getDataSetByName(dataSetName);

				if (dataSet) {
					$scope.config.isDataCubeDataSet = dataSet.endpoint === "DATACUBE";
					if(typeof $scope.tempDatasetObj[dataSetName] === 'undefined')
						$scope.tempDatasetObj[dataSetName] = {};
					angular.forEach(fieldObj.fields, function(field, index1) {
						if($scope.config.showOnlyBasicFilter
							&& $scope.config.collapseAllFacets && $scope.config.orientation === "horizontal" &&
							(integerDataTypes.indexOf(field.type)) === -1) {
							if(!field.numPointsToDisplay.includeAll)
								field.numPointsToDisplay.includeAll = true;
							//for collpased filter setting max points to 15 to have scroll bar. So that on load other values will get loaded.
							if(field.numPointsToDisplay.maxPoints < 15)
								field.numPointsToDisplay.maxPoints  = 15;

						}

						if(!fieldToShow || (fieldToShow.column === field.column && fieldsDataset === dataSetName)) {
							var maxPoints;
							if($scope.tempDatasetObj[dataSetName][field.column] && $scope.tempDatasetObj[dataSetName][field.column].maxPoints)
								maxPoints = $scope.tempDatasetObj[dataSetName][field.column].maxPoints;
							$scope.tempDatasetObj[dataSetName][field.column] = [];
							angular.forEach(field.measureDataFields, function(measureDataField, index2) {
								if (!measureDataField.aggrDisplayNames) {
									measureDataField.aggrDisplayNames = [];
								}

								angular.forEach(measureDataField.aggrTypes, function(aggrType, index3) {
									var tempObj = {};
									tempObj["measure"] = measureDataField.column;
									tempObj["aggrType"] = aggrType;

									if (measureDataField.aggrDisplayNames.length <= index3) {
										measureDataField.aggrDisplayNames
												.push(measureDataField.column + '_' + aggrType);
									}
									tempObj["displayName"] = measureDataField.aggrDisplayNames[index3];
									$scope.tempDatasetObj[dataSetName][field.column].push(tempObj);
								});

							});

							$scope.tempDatasetObj[dataSetName][field.column].inputBtnType = field.showRadioButtons ? "radio" : "checkbox";
							var selValCnt = 0;
							if($scope.filters[$scope.filterMode] && $scope.filters[$scope.filterMode][dataSetName] && $scope.filters[$scope.filterMode][dataSetName][field.column])
							 	selValCnt = $scope.filters[$scope.filterMode][dataSetName][field.column]["include"].length;
							$scope.tempDatasetObj[dataSetName][field.column].maxPoints = maxPoints && (selValCnt > field.numPointsToDisplay.maxPoints) ? maxPoints : field.numPointsToDisplay.maxPoints;
							let isCustomGroupAvialable =  field.customGroupsAvailable && !$.isEmptyObject(field.groups);
							//need to get the data if maxpoints are more than availabe values
							if(!isCustomGroupAvialable && doNotGetData && $scope.tempDatasetObj[dataSetName][field.column].maxPoints > $scope.data[dataSetName][field.column].length)
								doNotGetData = false;
						}
						const groups = field.groups;
						if(field.customGroupsAvailable && !$.isEmptyObject(groups)) {
							angular.forEach(groups, group => {
								if(group.groupValues.substring(0,1) === "=") {
									try {
										group.groupValues = eval(group.groupValues.substring(1));
									} catch(e) {
										//do nothing
									}	
									if(typeof group.groupValues === "number")
										group.groupValues = group.groupValues + "";
								}
							});

                        }

					});
					if(!doNotGetData) {
						if (dataSet.endpoint !== "DATACUBE") {
							if(typeof $scope.data[dataSetName] === 'undefined')
								$scope.data[dataSetName] = {};//Every column will remaain as a member under data[dataSetName].
							//Construct it before it getting used.
							$scope.config.dataSet = dataSet;
							$scope.component = $scope.config;
							if ($scope.config.dataSet.dataSet != undefined) {
								$scope.component.dataSet.dataSetName = $scope.config.dataSet.dataSet.dataSetName;
							}
							getFacetDataForOtherDataSources(undefined, dataSetName, 0, fieldToShow, fieldsDataset, isAutoRefresh);
						} else {
							var visibleFilterFields = $.grep(fieldObj.fields, function( field ) {
	  													return fieldToShow ? (fieldToShow.column === field.column) && (fieldsDataset === dataSetName) : (field.isVisible !== false);
	  												}),
							inputParams = ($.isEmptyObject($scope.page) || $.isEmptyObject($scope.page.inputs)) ? [] : customReportSvc.applyInputsToDataSet(dataSet, $scope.page.inputs);
							var options = {
								dataSet : dataSet,
								filterDataField : visibleFilterFields,
								groups : fieldObj.groups,
								filters : $scope.filters[$scope.filterMode][dataSetName],
								isPageBuilder : $scope.type === 'pageProperties' ? true : false,
								isFlat : true,
								isAvoidFQ: true,
								inputParams : inputParams,
								customFilterQuery : $scope.config.customFilterQuery ? $scope.config.customFilterQuery : {}
							};
							if (!$scope.dataservice) {
								if (dataSet) {
									$scope.dataservice = $dataSource.getDataSource(dataSet.endpoint);
								}
							}
							if ($scope.dataservice) {
								isAsync = true;
								angular.forEach(options.filterDataField, function(field, index) {
									if(field.showComboBox)
										field.numPointsToDisplay.includeAll = true;
										var isCustomGroups = field.customGroupsAvailable;
										//delete daterange element which doesn't have custom groups applied. 
										//because in that case only daterange picker will be shown which doesn't need to get any data from solr
										if($scope.config.isDateRange(field, dataSetName) && !isCustomGroups) {
											options.filterDataField.splice(index, 1);
										}
								});
								if(Array.isArray(options.filterDataField) && options.filterDataField.length > 0) {
									$scope.dataservice.getFacetData(options, function(data) {
										onSuccessGetFacet(data, dataSetName);
										if ($scope.type === 'component') {
											$scope.calculateGridsterSize();
										}
									});
								} else if ($scope.type === 'component') {									
									$scope.config.isComponentLoading = false;
								}
								
							}
						}
					}


				}

			});
			// in case all the filter panel datasets are already deleted
			// remove the loading bar
			if ($scope.type === 'component' && !isAsync) {
				$scope.config.isComponentLoading = false;
			}
		};

		function setNumBuckets(dataSetName, field, resp) {
			//we should not save number of buckets. so storing it in tempDataSetObj.
			$scope.tempDatasetObj[dataSetName][field.column]["numBuckets"] = resp[field.column]["numBuckets"] - resp[field.column]["buckets"].filter(function(facet){return facet.val === ""}).length;
			if(field.numBuckets !== undefined) //For upgrade cases
				delete field.numBuckets;
		}

		var onSuccessGetFacet = function(resp, dataSetName) {
			if ($scope.type === 'component') {
				$scope.config.isComponentLoading = false;
			}
			$timeout(function() {
				if(typeof $scope.data[dataSetName] === 'undefined')
					$scope.data[dataSetName] = {};
				angular.forEach($scope.filterDataField[$scope.filterMode][dataSetName].fields, function(field, index) {
					if (!field.dimensionColumnHeader) {
						field.dimensionColumnHeader = field.column;
					}
					if (!$.isEmptyObject(resp[field.column])) {
						$scope.data[dataSetName][field.column] = mergeSelected(field,
								resp[field.column]["buckets"],
								dataSetName);
						if ($scope.data[dataSetName][field.column].length > 0) {
							var aggrVals = Object.keys($scope.data[dataSetName][field.column][0]).slice(1);
							angular.forEach(aggrVals, function(aggr, i) {
								if(field["max_" + aggr]) //upgrade cases
									delete field["max_" + aggr];
								$scope.tempDatasetObj[dataSetName][field.column]["max_" + aggr] = $scope.data[dataSetName][field.column][0][aggr];
							});
							angular.forEach($scope.data[dataSetName][field.column], function(val, indx) {
								angular.forEach(aggrVals, function(aggr, i) {
									if (val[aggr] > $scope.tempDatasetObj[dataSetName][field.column]["max_" + aggr]) {
										$scope.tempDatasetObj[dataSetName][field.column]["max_" + aggr] = val[aggr];
									}
								})

							});
						}
						setNumBuckets(dataSetName, field, resp);
						if(field.showComboBox && $scope.tempDatasetObj[dataSetName][field.column].numBuckets === ($scope.tempDatasetObj[dataSetName][field.column].maxPoints + 1)) {
							$scope.tempDatasetObj[dataSetName][field.column].maxPoints = $scope.tempDatasetObj[dataSetName][field.column].numBuckets;
						}

					}
					if ($scope.config.isDateRange(field, dataSetName)) {
						customReportSvc.triggerCallback("relativeRangeUpdated", $scope.config.id);
					}
				});

			});
		};
		var getOperatorFromTextOp = function(textOp) {
			var operator = "";
			switch (textOp) {
			case "neq":
				operator = "!=";
				break;
			case "greater":
				operator = ">";
				break;
			case "less":
				operator = "<";
				break;
			case "leq":
				operator = "<=";
				break;
			case "geq":
				operator = ">=";
				break;
			case "contains":
				operator = "contains:";
				break;
			case "doesnotcontain":
				operator = "notcontains:";
				break;
			case "startswith":
				operator = "begins:";
				break;
			case "doesnotstartswith:":
				operator = "!begins:";
				break;
			default://eq
				operator = "=";
			}
			return operator;
		};
		var formatUrlParamforAdvFilter = function(advancedFilter) {
			if (advancedFilter.filters[0].value.length == 0) {
				return "";
			}
			var value_2 = advancedFilter.filters[1].value;
			return "[\"" +
					getOperatorFromTextOp(advancedFilter.filters[0].operator) +
					advancedFilter.filters[0].value +
					(value_2.length > 0 ? " " + advancedFilter.logic + " " +
							getOperatorFromTextOp(advancedFilter.filters[1].operator) + value_2 : "") + "\"]";
			//dont add the condition and second field if second is empty.
		}
		var getFacetDataForOtherDataSources = function(resp, dataSetName, iter, fieldToShow, fieldsDataset, isAutoRefresh) {
			//Caller and receiver, To Support multiple column fields

			if (iter > 0 && resp) {
				//Massaging
				if(resp.data != undefined && resp.data.columns != undefined && resp.data.columns.length >0){
				//Not adding this exception accessing undefined attributes below
					resp[resp.data.columns[0].name] = {};
					resp[resp.data.columns[0].name].numBuckets = resp.data.records.length;
					resp[resp.data.columns[0].name].buckets = [];
					for (var i = 0; i < resp.data.records.length; i++) {
						resp[resp.data.columns[0].name].buckets[i] = {};
						resp[resp.data.columns[0].name].buckets[i].val = resp.data.records[i][0];
						resp[resp.data.columns[0].name].buckets[i].count = resp.data.records[i][1];
					}
				}

				//Massaging

				if ($scope.type === 'component') {
					$scope.config.isComponentLoading = false;
				}
				$timeout(function() {
					angular.forEach($scope.filterDataField[$scope.filterMode][dataSetName].fields, function(field,
							index) {
						if (!field.dimensionColumnHeader) {
							field.dimensionColumnHeader = field.column;
						}
						if (!$.isEmptyObject(resp[field.column])) {

							$scope.data[dataSetName][field.column] = mergeSelected(field,
									resp[field.column]["buckets"],
									dataSetName);
							setNumBuckets(dataSetName, field, resp)

						}
					});
				});
			}

			if (iter < $scope.filterDataField.viewer[dataSetName].fields.length) {
				var filterField = $scope.filterDataField.viewer[dataSetName].fields[iter];
				var isDoFacetCall = fieldToShow ? (fieldToShow.column === filterField.column && fieldsDataset === dataSetName) : filterField.isVisible !== false;
				if(isDoFacetCall) {
					$scope.component.dimensionDataField = [];
					$scope.component.measureDataField = [];
					$scope.component.dimensionDataField[0] = filterField;
					$scope.component.measureDataField[0] = filterField;

					$scope.component.measureDataField[0].aggrType = "count";
					$scope.component.isGroupBy = true;

					$scope.component.sorting = [];
					var sorting = {};//Expected in getData URL builder

					var sortObj = $scope.component.measureDataField[0].sort;
					if (sortObj !== undefined) {
						sorting["sortAxis"] = sortObj.sortField === "index" ? "XAxis" : "YAxis";
						sorting["direction"] = sortObj.sortDirection;
					} else {
						sorting["sortAxis"] = "YAxis";
						sorting["direction"] = "Desc";
					}

					$scope.component.sorting.push(sorting);

					$scope.getData(undefined, false, isAutoRefresh).then(function(data) {
						getFacetDataForOtherDataSources(data, dataSetName, iter + 1, fieldToShow, fieldsDataset, isAutoRefresh);
						if ($scope.type === 'component') {
							$scope.calculateGridsterSize();
						}
					});
				} else {
					getFacetDataForOtherDataSources(undefined, dataSetName, iter + 1,fieldToShow, fieldsDataset, isAutoRefresh);
				}

			}

		};
		var mergeSelected = function(field, data, dataSetName) {
			if(field.customGroupsAvailable && !$.isEmptyObject(field.groups) && !field.formatter) {
				//in case of groups, order the result data according to group definition order
				let reorderedData = [];
				field.groups.forEach(group => {
					const dataVal = data.find(value => value.val === group.groupName);
					if(dataVal)
						reorderedData.push(dataVal);
				});
				data = reorderedData;
			}
			let returnData = data;
			if (!field.selectAll) {
				var selectedValues = customReportSvc.getDeepCopy(getFilteredValues(field, dataSetName));

				var filterValues = [];
				var otherValues = [];
				angular.forEach(selectedValues, function(val, index) {
					var isObj = typeof val === "object";
					val = isObj ? val.groupName : val.toString();
					const emptyValue = qb.rv.getQueryForEmptyVal();
					
					if(field.showEmptyValues && val.toString() === emptyValue) {
						val = field.emptyValueLabel;
					} 

					selectedValues[index] = val;
					filterValues.push({
						'val' : val,
						'count' : 0
					});
				});
				var searchIndex;
				angular.forEach(data, function(record, index) {
					if ((searchIndex = selectedValues.indexOf(record.val.toString())) != -1) {
						$.extend(filterValues[searchIndex], record);
						filterValues[searchIndex].isSelected = true;
					} else {
						otherValues.push(record);
					}


				});
				returnData = filterValues.concat(otherValues);
			} 

			if(field.showEmptyValues) {
				//remove actual empty("" or 0) value as we have empty label value added 
				const emptyValIndex = returnData.findIndex(record => {
					return record.val === "" || record.val === null || record.val === 0;
				});
				if(emptyValIndex !== -1)
					returnData.splice(emptyValIndex,1);
					
				const emptyLabelValIndex = returnData.findIndex(record => {
					return record.val === field.emptyValueLabel;
				});

				if(emptyLabelValIndex !== -1) {
					const emptyValRecord = returnData[emptyLabelValIndex];
					returnData.splice(emptyLabelValIndex,1);
					returnData = [emptyValRecord,...returnData];
				}
			}
				
			return returnData;	
		}

		var getFilteredValues = function(field, dataSetName) {
			var currentFilterMode, currentFilter, currentParamFilter;

			if ($scope.getDataSetByName(dataSetName).endpoint != "DATACUBE") {
				if (!$.isEmptyObject($scope.filters[$scope.filterMode]) &&
						!$.isEmptyObject($scope.filters[$scope.filterMode][dataSetName]) &&
						!$.isEmptyObject($scope.filters[$scope.filterMode][dataSetName][field.column])) {
					//If a filter is set and unset, the requestparam would be empty but selection will remain.
					$scope.filters[$scope.filterMode][dataSetName][field.column]["exclude"] = [];
					$scope.filters[$scope.filterMode][dataSetName][field.column]["include"] = [];
				}
				if (field.isAdvancedFilterApplied == true) {
					return [];
				}
				var requestParams = customReportSvc.getUrlParams();
				var value, filters = {}, selectionType = "include";
				var advOp = [ "!=", ">=", ">", "<=", "<", "contains:", "notcontains:", "begins:", "!begins:", "=" ];
				for (var key in requestParams) {
					if (key.indexOf(".filter.") != -1) {
						value = requestParams[key];
						if (value.indexOf("!=") != -1) {
							value = value.replace(/!=/g, '');//Replace all !=
							selectionType = "exclude";
						} else {
							selectionType = "include";
						}
						var col = decodeURIComponent(key.substring(key.indexOf(".filter.") + 8, key.length));
						if (col === field.column) {
							var values = JSON.parse(value);
							var index = values.length - 1;
							while (index >= 0) {
								angular.forEach(advOp, function(elt) {
									if (values[index].toString().startsWith(elt)) {//Database type data set will have integers
										values.splice(index, 1);//Remove if it contains adv operator

									}
								});

								index -= 1;
							}
							if ($.isEmptyObject(currentFilterMode = $scope.filters[$scope.filterMode])) {
								$scope.filters[$scope.filterMode] = [];
								currentFilterMode = $scope.filters[$scope.filterMode];
							}
							if ($.isEmptyObject(currentFilter = currentFilterMode[dataSetName])) {
								currentFilterMode[dataSetName] = [];
								currentFilter = currentFilterMode[dataSetName];
							}
							if ($.isEmptyObject(currentParamFilter = currentFilter[field.column])) {
								currentFilter[field.column] = [];
								currentParamFilter = currentFilter[field.column];
							}
							if (selectionType == "exclude") {

								currentParamFilter["exclude"] = values;
							} else if (selectionType == "include") {
								currentParamFilter["include"] = values;
							}
						}
					}
				}
			}
			if ($.isEmptyObject(currentFilterMode = $scope.filters[$scope.filterMode])) {
				return [];
			} else if ($.isEmptyObject(currentFilter = currentFilterMode[dataSetName])) {
				return [];
			} else if ($.isEmptyObject(currentParamFilter = currentFilter[field.column])) {
				return [];
			} else if ($.isEmptyObject(currentParamFilter.include)) {
				return [];
			} else {
				return currentParamFilter.include;
			}

		}
		/**
		 * do facet search for searchFields value
		 *
		 * @param {string}
		 *            dataSetName current datasetname
		 * @param {Object}
		 *            field field object
		 * @return
		 */
		$scope.doFacetSearch = function(dataSetName, field, searchFields,inputElm) {
			var dataSet = $scope.getDataSetByName(dataSetName);
			var field1 = $.extend(true, {}, field);
			if($scope.config.showOnlyBasicFilter) {
				$("li[comp=" + $scope.config.id + "]").css("overflow", "visible");
				field1.numPointsToDisplay = {
							maxPoints : 10 //To get only top 10 suggestions
						}
			}

			var filters = {};
			if (searchFields) {
				searchFields = searchFields;
				var advancedFilter = customReportSvc.getDefaultAdvancedFilter(field.column, searchFields);
				advancedFilter.filters[0].operator = 'contains';
				filters[field.column] = {
					'advancedFilters' : []
				};
				filters[field.column].advancedFilters.push(advancedFilter);
			}
			var fields = [ field1 ];
			if (dataSet) {
				var inputParams = ($.isEmptyObject($scope.page) || $.isEmptyObject($scope.page.inputs)) ? [] : customReportSvc.applyInputsToDataSet(dataSet, $scope.page.inputs),
				options = {
					dataSet : dataSet,
					filterDataField : fields,
					groups : undefined,
					filters : filters,
					isPageBuilder : false,
					isFlat : true,
					isAvoidFQ : false,
					inputParams : inputParams
				};
				if (!$scope.dataservice) {
					if (dataSet) {
						$scope.dataservice = $dataSource.getDataSource(dataSet.endpoint);
					}
				}
				if ($scope.dataservice) {
					$scope.dataservice.getFacetData(options, function(data) {
							if($scope.config.showOnlyBasicFilter) {
								$scope.suggestionList = {};
								$scope.suggestionList[dataSetName] = {};
								$scope.suggestionList[dataSetName][field.column] = data[field.column].buckets;
								$(inputElm).focus();
							}
							else
								$scope.data[dataSetName][field.column] =data[field.column].buckets;// transformData(field,data.data.records);

					});
				}
			}
		};

		$scope.addSelectedItemTofilter =  function (dataSetName,field,facetField) {
			if(field.selectAll)
				return;
			var isfacetAlreadyAdded = $scope.data[dataSetName][field.column].filter(function(facet) { return facet.val === facetField.val}).length !== 0 ;
			if(!isfacetAlreadyAdded)
				$scope.data[dataSetName][field.column].push(facetField);
			var isfacetValSelected = false;
			if ($scope.filters[$scope.filterMode] && $scope.filters[$scope.filterMode][dataSetName] && $scope.filters[$scope.filterMode][dataSetName][field.column])
			 isfacetValSelected = $scope.filters[$scope.filterMode][dataSetName][field.column]["include"].filter(function(facet) { return facet === facetField.val}).length !== 0;
			if(!isfacetValSelected) {
				$scope.applyFacetFilter(facetField, field, false, undefined, dataSetName);
				if(field.showComboBox)
					$scope.tempDatasetObj[dataSetName][field.column].maxPoints += 1;
			}
			$scope.suggestionList = {};
			if(!$scope.showFacetModal)
				$("li[comp=" + $scope.config.id + "]").css("overflow", "hidden");
		}



		$scope.calculateGridsterSize = function(isShowField) {
			if($scope.config.showOnlyBasicFilter)
				return;
			$timeout(function() {
				if ($scope.config.collapseAllFacets) {
					if ($scope.config.orientation === 'vertical') {
						angular.element("li[comp=" + $scope.config.id + "]").find(".panel").css("width", "100%");
					}
					adjustFilterPanelHeight();
				} else {
					$scope.changeOrientaion();
					var componentScope = angular.element("li[comp=" + $scope.config.id + "]").scope();
					var numberOfSearchBars, numberOfPanels, searchBarHieght =  $("li[comp=" + $scope.config.id + "] .facet-panes .searchBarElm").outerHeight(true) || 0;
					if($scope.config.showOnlyBasicFilter) {
						searchBarHieght = $("li[comp=" + $scope.config.id + "] .facet-panes .autoSuggestElm").outerHeight(true) || 0;
						panelFooterHeight = 0;
						filterTableHeaderHeight = 0;
					}

					numberOfSearchBars =  $("li[comp=" + $scope.config.id + "] .facet-panes .searchBarElm").length + $("li[comp=" + $scope.config.id + "] .facet-panes .autoSuggestElm").length;

					numberOfPanels = $("li[comp=" + $scope.config.id + "] .facet-panes .panel").length;
					if (componentScope.gridsterItem && componentScope.gridsterItem.$element) {
						//Below logic is to increase/decrease panel height/width when fields get added/deleted. Mostly for the viewer page when we use show/hide field option
						if(isShowField !== undefined) {
							var currentPanelCnt = isShowField ?  (numberOfPanels - 1) : (numberOfPanels + 1);
							if ($scope.config.orientation === 'horizontal') {
								var eachFieldWidth = Math.ceil(componentScope.gridsterItem.sizeX/currentPanelCnt);
								componentScope.gridsterItem.sizeX += isShowField ? 	eachFieldWidth : -eachFieldWidth;
							} else {
								var eachFieldHeight = Math.ceil(componentScope.gridsterItem.sizeY / currentPanelCnt) ;
								componentScope.gridsterItem.sizeY += isShowField ? eachFieldHeight : -eachFieldHeight;
							}
						}
						var currentTileHeight = componentScope.gridsterItem.sizeY * componentScope.gridster.rowHeight -
								tilePadding; // 14 is for padding
						var currentTileWidth = componentScope.gridsterItem.sizeX * componentScope.gridster.curColWidth -
								tilePadding; // 14 is for padding
						currentTileHeight -= panelTitleHeight;

						currentTileHeight -= $scope.config.applyOnSelect ? 0 : 29;
						var newWidth,headerFooterHeight = filterTableHeaderHeight + panelHeaderHeight + panelFooterHeight;

						if ($scope.config.orientation === 'horizontal') {
							currentTileHeight -= headerFooterHeight;
							newWidth = currentTileWidth / numberOfPanels;
							numberOfPanels = 1;
						} else {
							currentTileHeight -= (( headerFooterHeight * numberOfPanels) + (numberOfSearchBars*searchBarHieght));
						}
						var newHeight = currentTileHeight / numberOfPanels;

						$("li[comp=" + $scope.config.id + "] .facet-panel .facet-panes .facet-table-body:visible")
								.each(function() {
									var isSearchBarEnabled = false,
									$panelElm = $(this).closest('.panel'),
									height = newHeight,$dateRangeElm,isPanelFooterShown;
									if ($scope.config.orientation === 'horizontal') {
										$panelElm.css('width', newWidth + "px");
										isSearchBarEnabled = ($(".searchBarElm",$panelElm).length + $(".autoSuggestElm",$panelElm).length) > 0;
									}
									$dateRangeElm = $(".date-range-element:visible",$panelElm);
									if($dateRangeElm.length > 0) {
										$dateRangeElm.closest('.panel-body').css("height","50px");
										height -= 50;
									}
									isPanelFooterShown = $(".panel-footer:visible",$panelElm).length > 0;
									if(!isPanelFooterShown)
										height += panelFooterHeight;
									$(this).css('height', isSearchBarEnabled ? height- searchBarHieght : height  + "px");
								});
						$("li[comp=" + $scope.config.id + "] .facet-panel .facet-panes .panel-body:visible").each(function() {
							var $panelElm = $(this).closest('.panel'),
							isCustomGroupElm = $(".facet-table-body:visible",$panelElm).length > 0;
							if ($(this).hasClass('advanced-filtering')) {
								$(this).css('height', newHeight + filterTableHeaderHeight + "px");
							} else if(!isCustomGroupElm) {
								$(this).css('height', newHeight + filterTableHeaderHeight + panelFooterHeight + "px");
							}
							if ($scope.config.orientation === 'horizontal') {
								$(this).closest('.panel').css('width', newWidth + "px");
							}
						});
						$scope.$apply();
					}

				}
			});
		};

		$scope.changeOrientaion = function() {

			if ($scope.config.orientation === 'vertical') {
				angular.element("li[comp=" + $scope.config.id + "]").find(".panel").css("width", "100%");

			} else {
				var componentScope = angular.element("li[comp=" + $scope.config.id + "]").scope();
				if (componentScope.gridsterItem && componentScope.gridsterItem.$element) {
					var curGridsterColWidth = componentScope.gridster.curColWidth;
					var numberOfPanels = $("li[comp=" + $scope.config.id + "] .facet-panel .panel-body").length +
							$("li[comp=" + $scope.config.id + "] .facet-panel .facet-table-body").length;
					var panelColSize = componentScope.gridsterItem.sizeX / numberOfPanels;
					angular.element("li[comp=" + $scope.config.id + "]").find(".panel").css("width",
							panelColSize * curGridsterColWidth - 10);
				}
			}
		};



		$scope.getFormattedValue = function(value, field, dataSetName) {
			value = $sanitize(value);
			var dataSet = $scope.getDataSetByName(dataSetName);
			return field.formatter ? customReportSvc.getFormattedValue(value, field.formatter, undefined, undefined, undefined, field, dataSet) : value;
		}
		$scope.formatNumberToString = function(val) {
			return cvFormatters.formatNumberToString(val);
		}
		$scope.setAdvancedFilterOptions = function(field,dataSet,options,advancedFilterIdx) {
			if(!advancedFilterIdx)
				advancedFilterIdx = 0;
			var advancedFilter = field.advancedFilters[advancedFilterIdx];
			if (dataSet.endpoint !== "DATACUBE") {
				options.filterVal = formatUrlParamforAdvFilter(advancedFilter);
			} else {

				options.filterVal = advancedFilter;
			}
			options.selectionType = "advancedFilters";
			options.isMultiple = false;
			options.isExact = true;
			options.isAdvanced = true;
			field.isAdvancedFilterApplied = true;

		}

		$scope.setFilterOptions = function(facet,field,dataSet,isAdvanced,selectionType,dataSetName,advancedFilterIdx,options) {

			var isCustomGroups = field.customGroupsAvailable && !$.isEmptyObject(field.groups);
			if (!isAdvanced) {
				field.isAdvancedFilterApplied = false;
				if (!$scope.config.isDateRange(field, dataSetName) || (isCustomGroups && facet)) {
					field.isFliterApplied = true;
					var value = (facet.val !== undefined) ? facet.val : facet;
					options.filterVal = dataSet.endpoint !== "DATACUBE" && selectionType == "exclude" ? "!=" + value
							: value;
					if (isCustomGroups) {
						let urlParams = customReportSvc.getUrlParams(),
						customInputs = customReportSvc.getCustomInputs(urlParams,$scope.page.inputs),
						selectedGroup = customReportSvc.getSelectedCustomGroupObject(field, value,customInputs);
						if(selectedGroup)
						{
							options.filterVal = selectedGroup;
							if(options.selectedGroups)
								options.selectedGroups.push(selectedGroup);
						}
					}
				} else {
					field.isFliterApplied = true;
					options.isMultiple = false;
					var absoluteValue = $scope.dateRangeFields[field.column].dateRange.absolute;
					var relativeValue = $scope.dateRangeFields[field.column].dateRange.relative;
					var value = absoluteValue && absoluteValue.from ? absoluteValue : relativeValue;
					options.filterVal = value;
				}


			} else {
				$scope.setAdvancedFilterOptions(field,dataSet,options,advancedFilterIdx);


			}
		}

		$scope.setFilterMap = function(facet,field,dataSet,isAdvanced,selectionType,dataSetName,advancedFilterIdx) {
			if($.isEmptyObject($scope.facetFieldMap))
						$scope.facetFieldMap = {};
			if($.isEmptyObject($scope.facetFieldMap[field.column]))
				$scope.facetFieldMap[field.column] = {
					filterVals : []
				};
			var filterField = $scope.facetFieldMap[field.column],
			isCustomGroups = field.customGroupsAvailable && !$.isEmptyObject(field.groups);
			if(filterField["selType"] !== undefined && filterField["selType"] !== selectionType) //if selection type changes then will need to clear existing values
				filterField["filterVals"] = [];
			filterField["selType"] = selectionType;
			filterField["isMultiple"] = true;

			var options = {};
			$scope.setFilterOptions(facet,field,dataSet,isAdvanced,selectionType,dataSetName,advancedFilterIdx,options);
			var facetValue =  options.filterVal;
			if($.isArray(facetValue))
				filterField["filterVals"] =facetValue ? facetValue : [];
			else if((!$scope.config.isDateRange(field, dataSetName) || (isCustomGroups && facet))  &&
			$.inArray(facetValue,filterField["filterVals"]) !== -1)
				filterField["filterVals"].splice(filterField["filterVals"].indexOf(facetValue),1);
			else if($scope.config.isDateRange(field, dataSetName) && !isCustomGroups) {
				filterField["filterVals"] = facetValue;
				filterField["isMultiple"] = false;
			} else {
				filterField["filterVals"].push(facetValue);
			}
		}

		$scope.addFilterParamsToUrl = function(facetValue,field,dataSetName,selectionType,isAdvanced,isMultiple) {
			let isCustomGroupAvialable = typeof facetValue === 'object' && facetValue.hasOwnProperty('groupName');
			if(isCustomGroupAvialable)
				facetValue = facetValue.groupName;
			if (isAdvanced || ($scope.config.isDateRange(field, dataSetName) && !isCustomGroupAvialable))
				selectionType = "";
			if(isAdvanced) {
				facetValue = [{
					operator : facetValue.filters[0].operator,
					value : facetValue.filters[0].value
				},{
					operator : facetValue.filters[1].operator,
					value : facetValue.filters[1].value
				}];
			}
			$scope.updateUrlWithSelFilters(field, selectionType , facetValue, isMultiple, dataSetName);
		}

		$scope.applyFacetFilter = function(facet, field, isAdvanced, advancedFilterIdx, dataSetName, isApplyAllFilter) {
			if (field && field.dateRange && field.customGroupsAvailable && !$.isEmptyObject(field.groups) && field.selectAll) {
				$("li[comp=" + $scope.config.id + "] #filter-modal input[type=daterange]").val("");
				return;
			}
			var dataSet = $scope.getDataSetByName(dataSetName);
			var self = this;

			if(field.showEmptyValues && facet.val === field.emptyValueLabel) {
				facet = qb.rv.getQueryForEmptyVal();
			}
			
			if(field && field.showComboBox && facet.isSelected && $scope.tempDatasetObj[dataSetName][field.column].maxPoints > field.numPointsToDisplay.maxPoints)
				$scope.tempDatasetObj[dataSetName][field.column].maxPoints -= 1;
			if($scope.config.applyOnSelect === false && isApplyAllFilter) { //when apply on select is fale then we apply all the filters on Apply btn click only
				function isValPresentInFilters(val,options,field,dataSetName) {
					return !$.isEmptyObject($scope.filters.viewer) && !$.isEmptyObject($scope.filters.viewer[dataSetName]) &&
									!$.isEmptyObject($scope.filters.viewer[dataSetName][field.column]) &&
									!$.isEmptyObject($scope.filters.viewer[dataSetName][field.column][options.selectionType]) &&
									($.inArray(val,$scope.filters.viewer[dataSetName][field.column][options.selectionType]) !== -1 ||
										val === $scope.filters.viewer[dataSetName][field.column][options.selectionType]);
				}

				angular.forEach($scope.filterDataField[$scope.filterMode][dataSetName].fields, function(field) {

					var options = {
							'filterParam' : field.column,
							'filterVal' : [],
							'component' : $scope.config,
							'isMultiple' : true,
							'isExact' : true,
							'selectedGroups' : [],
							'isAdvanced' : false,
							'filterMode' : $scope.filterMode,
							'selectionType' : "include",
							'isGlobal' : $scope.type === 'component' || $scope.type === 'pageProperties' ? true : false,
							'dataSet' : dataSet,
							'isShowRadioButtons' : field.customGroupsAvailable,
							'isDoFacetCall' : false
						};
						if(!$.isEmptyObject($scope.facetFieldMap) && !$.isEmptyObject($scope.facetFieldMap[field.column])) {
							var facetInfo = $scope.facetFieldMap[field.column];
							if(facetInfo.filterVals !== []) {
								options.filterVal = facetInfo.filterVals;
								if(field.customGroupsAvailable && !$.isEmptyObject(field.groups))
									options.selectedGroups = facetInfo.filterVals;
								options.selectionType = facetInfo.selType;
								options.isMultiple = facetInfo.isMultiple;
							}

						}

						if(field.filterType === "advanced")
							self.setAdvancedFilterOptions(field,dataSet,options,0);

						if($scope.reportMode === 'viewer' && $scope.config.processUrlParamaters)  {
							if($.isArray(options.filterVal)) {
								angular.forEach(options.filterVal,function(val) {
									if(!isValPresentInFilters(val,options,field,dataSetName))
										$scope.addFilterParamsToUrl(val,field,dataSetName,options.selectionType,options.isAdvanced,options.isMultiple);
								});

							} else if(!isValPresentInFilters(options.filterVal,options,field,dataSetName))
								$scope.addFilterParamsToUrl(options.filterVal,field,dataSetName,options.selectionType,options.isAdvanced,options.isMultiple);
						}

						$scope.$emit('addFilters', options);

				});



				var options = {
					'filterVal' : [],
					'component' : $scope.config,
					'isDoFacetCall' : true,
					'isExact' : true,
					'filterMode' : $scope.filterMode,
					'isGlobal' : $scope.type === 'component' || $scope.type === 'pageProperties' ? true : false,
					'dataSet' : dataSet
				}

				$scope.$emit('addFilters', options);

			} else {

				var selectionType = "include";
				if ((!$scope.config.isDateRange(field, dataSetName) || (field.customGroupsAvailable && !$.isEmptyObject(field.groups))) && !field.showRadioButtons) {
					selectionType = field.selectAll ? "exclude" : "include";
				}
				if(field.showRadioButtons && selectionType === "include" && !$.isEmptyObject($scope.filters[$scope.filterMode])
				&& !$.isEmptyObject($scope.filters[$scope.filterMode][dataSetName]) && !$.isEmptyObject($scope.filters[$scope.filterMode][dataSetName][field.column]))//clearing other filters in case of radio button
					$scope.filters[$scope.filterMode][dataSetName][field.column][selectionType] = [];

				var options ={};
				if($scope.config.applyOnSelect !== false) {
					options = {
						'filterParam' : field.column,
						'filterVal' : "",
						'component' : $scope.config,
						'isMultiple' : !field.showRadioButtons,
						'isExact' : true,
						'selectedGroups' : [],
						'isAdvanced' : false,
						'filterMode' : $scope.filterMode,
						'selectionType' : selectionType,
						'isGlobal' : $scope.type === 'component' || $scope.type === 'pageProperties' ? true : false,
						'dataSet' : dataSet,
						'isShowRadioButtons' : field.showRadioButtons,
						'isDoFacetCall' : true
					};
					$scope.setFilterOptions(facet,field,dataSet,isAdvanced,selectionType,dataSetName,advancedFilterIdx,options);
					if($scope.reportMode === 'viewer' && $scope.config.processUrlParamaters)
						$scope.addFilterParamsToUrl(options.filterVal,field,dataSetName,selectionType,options.isAdvanced,options.isMultiple);

					if ($scope.type === 'component') {
						$scope.$emit('addFilters', options);
					} else {
						$rootScope.$broadcast('addFilters', options);
					}
				} else {
					$scope.setFilterMap(facet,field,dataSet,isAdvanced,selectionType,dataSetName,advancedFilterIdx);
				}
				// if ($scope.type === 'properties' || $scope.type === 'pageProperties') {
				// 	$scope.showFacet(false);
				// }
			}

		};
		$scope.resetFiledFilterObject = function (field, options , dataSetName) {
			field.advancedFilters[0] = getDefaultAdvancedFilters(field.column);
			if ($scope.config.isDateRange(field, dataSetName)) {
				$scope.dateRangeFields[field.column].dateRange = {
					'absolute' : {}
				};
				options.component = {};
				angular.copy($scope.config, options.component);
				options.component.filters = $scope.config.filters; // filters should get reflected to original object
				if(!field.customGroupsAvailable)
					options.component.type = 'DATE_RANGE';
			}
		};
		$scope.clearUrlParams = function(field,dataSetName,selectionType) {
			let isCustomGroupAvialable = field.customGroupsAvailable && !$.isEmptyObject(field.groups);
			//if custom group is present for daterange then we need to clear url twice 1) comp.filter.field(for date range picker value)
			// 2) comp.filter.include.field (for custom group value)

			if($scope.config.isDateRange(field, dataSetName) && isCustomGroupAvialable)
				$scope.updateUrlWithSelFilters(field, "" , "" , false, dataSetName);
			if (field.isAdvancedFilterApplied || ($scope.config.isDateRange(field, dataSetName) && !isCustomGroupAvialable))
					selectionType = "";
			$scope.updateUrlWithSelFilters(field, selectionType , "" , false, dataSetName);
		}

		$scope.clearComponentFilters = function(field, dataSetName, noRedraw, isDelete, clearAllFilters,event) {
			if(event)
				event.stopPropagation();
			var self = this;
			var dataSet = $scope.getDataSetByName(dataSetName);
			var options = {
				'filterMode' : $scope.filterMode,
				'dimension' : field,
				'component' : $scope.config,
				'dataSet' : dataSet,
				'type' : $scope.type,
				'noRedraw' : noRedraw,
				'isDelete' : isDelete,
				'selectionType' : field && field.selectAll === true ? 'exclude' : 'include'

			};

			if($scope.config.applyOnSelect === false && clearAllFilters) {
				angular.forEach($scope.filterDataField[$scope.filterMode][dataSetName].fields, function(field) {
					options.selectionType = field && field.selectAll === true ? 'exclude' : 'include';
					if($scope.reportMode === 'viewer' && $scope.config.processUrlParamaters)
						$scope.clearUrlParams(field,dataSetName,options.selectionType);
					self.resetFiledFilterObject(field, options , dataSetName);
					field.isAdvancedFilterApplied = false;
					field.isFliterApplied = false;//we are clearing the filter here
					var filterField = $scope.filters[$scope.filterMode][dataSetName][field.column];
					if(filterField)
						filterField.isfieldDroppedInFilterComp = true;
				});
				options['isClearAllFilters'] = true;
				$scope.facetFieldMap= {};
			} else {
				if($scope.facetFieldMap && $scope.facetFieldMap[field.column])
					delete $scope.facetFieldMap[field.column];
				self.resetFiledFilterObject(field, options , dataSetName);
				field.isFliterApplied = false;
				if(field.showComboBox)
					$scope.tempDatasetObj[dataSetName][field.column].maxPoints = field.numPointsToDisplay.maxPoints;

				if($scope.reportMode === 'viewer' && $scope.config.processUrlParamaters)
					$scope.clearUrlParams(field,dataSetName,options.selectionType);
			}
			if ($scope.type === 'component') {
				$("li[comp=" + $scope.config.id + "] .dateRangeInput ").val("");
			} else {
				$("#field_" + field.column + "_" + $scope.type + " .dateRangeInput ").val("");
			}
			if (dataSet.endpoint !== "DATACUBE") {
				$scope.dataSet = undefined;
			}
			if ($scope.type === 'component') {
				$scope.$emit('clearComponentFilters', options);
			} else {
				$rootScope.$broadcast('clearComponentFilters', options);
			}
		}

		$scope.getIncludeGroupValues = function(field,dataSetName,isCustomGroupAvialable,includeVals) {
			if(isCustomGroupAvialable && field.formatter)
				return includeVals;
			if(isCustomGroupAvialable) {
				return includeVals.filter(includeVal => {
					const group = field.groups.find(group => {
						return group.groupName === includeVal.groupName;
					});
					return group !== undefined;
				});
			} else if(field.formatter) {
				const dataSet = $scope.getDataSetByName(dataSetName);
				return includeVals.filter(includeVal => {
					if(!$.isEmptyObject(includeVal) && !includeVal.groupName)
						return (customReportSvc.getFormattedValue(includeVal, field.formatter, undefined, undefined, undefined, field, dataSet) !== undefined);
					else
						return false;
				});
			} else
				return includeVals;
		}

		$scope.getExcludeGroupValues = function(field,dataSetName,isCustomGroupAvialable,excludeVals) {
			if(isCustomGroupAvialable && field.formatter)
				return excludeVals;
			if(isCustomGroupAvialable) {
				return excludeVals.filter(excludeVal => {
					const group = field.groups.find(group => {
						return group.groupName === excludeVal.groupName;
					});
					return group !== undefined;
				});
			} else if(field.formatter) {
				const dataSet = $scope.getDataSetByName(dataSetName);
				return excludeVals.filter(excludeVal => {
					return (customReportSvc.getFormattedValue(excludeVal, field.formatter, undefined, undefined, undefined, field, dataSet) !== undefined);

				});
			} else
				return excludeVals;
		}


		$scope.showFilterClearOption = function(field, dataSetName) {
			var filterMode = $scope.filterMode;
			var component = $scope.config;
			var type = $scope.type;
			var dataSet = $scope.getDataSetByName(dataSetName);
			if (!dataSet) {
				return false;
			}
			var currentFilterMode;
			var currentFilter;
			var currentParamFilter;
			var isGlobal = typeof type === "string" && (type === "pageProperties" || type === 'component') ? true
					: false;
			if ($.isEmptyObject($scope.filters) || $.isEmptyObject(currentFilterMode = $scope.filters[filterMode])) {
				return false;
			}
			if ($.isEmptyObject(currentFilter = currentFilterMode[dataSet.dataSet.dataSetName])) {
				return false;
			} else if (isGlobal && !field) {
				var showClear = false;
				var fields = $scope.filterDataField[$scope.filterMode][dataSetName].fields;
                angular.forEach(fields,function(filterField) {
                	currentParamFilter = currentFilter[filterField.column];
                	if(!$.isEmptyObject(currentParamFilter) && ($scope.config.applyOnSelect === false || currentParamFilter.isChartInteractivityFilter)) {
                		if(!$.isEmptyObject(currentParamFilter["include"]) ||
                			!$.isEmptyObject(currentParamFilter["exclude"]) || filterField.isAdvancedFilterApplied || !$.isEmptyObject(currentParamFilter["daterange"])) {
                        	showClear =  true;
                    	}
                	}

                });
                return showClear;
            } else if ($.isEmptyObject(currentParamFilter = currentFilter[field.column]) &&
					($.isEmptyObject(currentParamFilter = currentFilter["tuples_" + component.id]) || $
							.isEmptyObject(currentParamFilter["include"]))) {
				return false;
			} else if ($.isEmptyObject(currentParamFilter["include"]) &&
					$.isEmptyObject(currentParamFilter["exclude"]) && !field.isAdvancedFilterApplied &&
					(!currentParamFilter["daterange"] || $.isEmptyObject(currentParamFilter["daterange"]))) {
				return false;
			} else {
				if($scope.config.useCompIdFromField) {
					let includeVals = angular.copy(currentParamFilter["include"]),
					excludeVals = angular.copy(currentParamFilter["exclude"]);
					const isCustomGroupAvialable = field.customGroupsAvailable && !$.isEmptyObject(field.groups);
					includeVals = $scope.getIncludeGroupValues(field,dataSetName,isCustomGroupAvialable,includeVals);
					excludeVals = $scope.getExcludeGroupValues(field,dataSetName,isCustomGroupAvialable,excludeVals);
					if($.isEmptyObject(includeVals) && $.isEmptyObject(excludeVals) && !currentParamFilter["daterange"])
						return false;
				}

				return true;
			}
		};

		$scope.showDropMessage = function() {
			var isShowDropMessage = false;
			if ($scope.type === 'component') {
				if (!$scope.isFieldDragging &&
						(!$scope.filterDataField || $.isEmptyObject($scope.filterDataField[$scope.filterMode]))) {
					isShowDropMessage = true;
				}
			} else {
				if (!$scope.isFieldDragging && ($scope.type !== 'component' && $.isEmptyObject($scope.filters))) {
					isShowDropMessage = true;
				} else {
					var filters = "";
					if (!$scope.isFieldDragging &&
							(!$scope.filters || $.isEmptyObject(filters = $scope.filters["builder"]))) {
						isShowDropMessage = true;
					} else if ($scope.filters && !$.isEmptyObject(filters = $scope.filters["builder"])) {
						var dataSetName = Object.keys(filters)[0] || "";
						if (!$scope.isFieldDragging && $.isEmptyObject(filters[dataSetName])) {
							isShowDropMessage = true;
						}
					}
				}
			}
			return isShowDropMessage;
		};


		var adjustFilterPanelHeight = function() {
			if ($scope.type !== 'component' || $scope.config.showOnlyBasicFilter) {
				return;
			}
			var panelBodyHeight = 34, componentScope = angular.element("li[comp=" + $scope.config.id + "]").scope(),
			$facetPanels = $("li[comp=" + $scope.config.id + "] .facet-panes .panel");
			if ($facetPanels.length !== 0) {
				if (!$scope.config.collapseAllFacets) {
					panelBodyHeight = $($facetPanels[0]).height();
				}
				if ($scope.config.orientation === 'horizontal') {
					componentScope.gridsterItem.sizeY = Math.ceil((panelBodyHeight + panelTitleHeight) /
							componentScope.gridster.rowHeight);
				} else {
					componentScope.gridsterItem.sizeY = Math
							.ceil((panelBodyHeight * $facetPanels.length + panelTitleHeight) /
									componentScope.gridster.rowHeight);
				}
				if ($scope.config.collapseAllFacets) {
					var numberOfFields = $("li[comp=" + $scope.config.id + "] .facet-panel .facet-panes .panel").length;
					var borderSize = 1;
					if ($scope.config.orientation === 'vertical') {
						borderSize = numberOfFields;
					}
					var currentComponentHeight = componentScope.gridsterItem.sizeY * componentScope.gridster.rowHeight -
							panelTitleHeight - tilePadding - borderSize;

					var currentTileWidth = componentScope.gridsterItem.sizeX * componentScope.gridster.curColWidth -
							tilePadding; // 14 is for padding
					var eachFieldWidth = currentTileWidth / numberOfFields;
					var eachFieldHeight = currentComponentHeight / numberOfFields;
					$("li[comp=" + $scope.config.id + "] .facet-panel .facet-panes .panel").each(function() {

						if ($scope.config.orientation === 'horizontal') {
							$(this).css('width', eachFieldWidth + "px");
							$('.filter-panel-heading', $(this)).css('height', currentComponentHeight + "px");
						} else {
							$('.filter-panel-heading', $(this)).css('height', eachFieldHeight + "px");

						}
					});

				}
			}
			if (!$scope.config.collapseAllFacets) {
				$scope.calculateGridsterSize();
			}
		}

		$scope.$on('resize',function(sizes, gridster) {
			$scope.calculateGridsterSize();
		});

		$scope.$watch('config.applyOnSelect', function(newValue,oldValue) {
			if(newValue !== undefined && (newValue !== oldValue))
				$scope.calculateGridsterSize();

		});
		$scope.$watch('config.collapseAllFacets', function(newValue,oldValue) {
			if(newValue !== undefined && (newValue !== oldValue))
				$timeout(adjustFilterPanelHeight, 10);

		});

		$scope.$on("refreshFilters", function() {
			$scope.showFacet(false);
		});

		$scope.applyFacetFilterListener = $scope.$on('applyFacetFilter', (event, facet, field, isAdvanced, advancedFilterIdx, dataSetName, isApplyAllFilter) => {
			if ($scope.config.filterAcrossReports && !_.isUndefined($scope.config.reportName) && $scope.config.type === 'FACET') {
				$scope.applyFacetFilter(facet, field, isAdvanced, advancedFilterIdx, dataSetName, isApplyAllFilter);
			}
		});



		$scope.showFacetInModal = function(fieldObj, field, dataSetName, index,$event) {
			$event.stopPropagation();
			$scope.dataSetName = dataSetName;
			$scope.field = field;
			$scope.fieldObj = fieldObj;
			$scope.fieldIndex = index - 1;
			$("li[comp=" + $scope.config.id + "]").css("overflow", "visible");
			$("li[comp=" + $scope.config.id + "]").css("z-index", "6");
			$timeout(function() {
				var top,componentScope = angular.element("li[comp=" + $scope.config.id + "]").scope(),
				panelTitleHeight = $scope.reportMode === 'viewer' && $scope.config.hideHeader ? 5  : 37,
				filterPanelTop = $("li[comp=" + $scope.config.id + "]").position().top,
				$facetPanels = $("li[comp=" + $scope.config.id + "] .facet-panes .panel:visible"),
				$filterModal = $("li[comp=" + $scope.config.id + "] #filter-modal"),
				filterModalHeight,windowHeight = $(window).height();
				$scope.showFacetModal = true;
				$filterModal.addClass("visibilityStyle");
				filterModalHeight = $filterModal.height();
				$filterModal.removeClass("visibilityStyle");
				if($scope.config.orientation === 'horizontal')
					top = $($facetPanels[$scope.fieldIndex]).position().top + $(".panel-heading",$facetPanels[$scope.fieldIndex]).outerHeight() + 3;//adding 3 pixels just to add some space between modal and panel header
				else
					top = componentScope.gridsterItem.sizeY * componentScope.gridster.rowHeight - 8;
				if ((top + filterModalHeight + filterPanelTop) > windowHeight) {
					top = -(filterModalHeight + 6);
				}


				$filterModal.css("top", top);
				if ($scope.config.orientation === 'horizontal') {

					$filterModal.css("left", $($facetPanels[$scope.fieldIndex]).position().left);
				} else {
					$filterModal.css("left", 0);
				}
			});



		}
		$scope.deleteFilterField = function(fieldObj, $index, dataSetName) {
			$scope.clearComponentFilters(fieldObj.fields[$index], dataSetName, false, true);
			fieldObj.fields.splice($index, 1);
			$scope.config.allColumns = false;
			$scope.field = undefined;
		}

		$scope.showFilterClear = function(field, dataSetName) {
			var dataSet = $scope.getDataSetByName(dataSetName);
			var options = {
				'filterMode' : $scope.filterMode,
				'dimension' : field,
				'component' : $scope.config,
				'dataSet' : dataSet,
				'type' : $scope.type
			};
			if ($scope.type === 'component') {
				$scope.$broadcast('showFilterClear', options);
			} else {
				$rootScope.$broadcast('showFilterClear', options);
			}
		}

		$scope.checkIfCustomGroupSelected = function(facet, fields, selectionType, currentParamFilter) {
			var isFound = false;
			angular.forEach(currentParamFilter[selectionType], function(filterVal, index) {
				if (typeof filterVal === 'object' && (filterVal.groupName || "") === facet.val) {
					isFound = true;
					return;
				}
			});
			return selectionType === "exclude" ? !isFound : isFound;
		}
		$scope.getFilteredValue = function(field, dataSetName) {
			if (!$.isEmptyObject($scope.filters[$scope.filterMode]) && $scope.filters[$scope.filterMode][dataSetName] !== undefined &&
					$scope.filters[$scope.filterMode][dataSetName][field.column] !== undefined) {
				let includeVals = angular.copy($scope.filters[$scope.filterMode][dataSetName][field.column]["include"]),
				excludeVals = angular.copy($scope.filters[$scope.filterMode][dataSetName][field.column]["exclude"]);
				const isCustomGroupAvialable = field.customGroupsAvailable && !$.isEmptyObject(field.groups);
				if($scope.config.useCompIdFromField) {
					includeVals = $scope.getIncludeGroupValues(field,dataSetName,isCustomGroupAvialable,includeVals);
					excludeVals = $scope.getExcludeGroupValues(field,dataSetName,isCustomGroupAvialable,excludeVals);
				}
				let includeVal = typeof includeVals[0] === "object" ? includeVals[0].groupName : includeVals[0],
				excludeVal = typeof excludeVals[0] === "object" ? excludeVals[0].groupName : excludeVals[0],
				isDaterangeApplied = $scope.dateRangeFields[field.column] && ($scope.dateRangeFields[field.column].dateRange.relative ||
				$scope.dateRangeFields[field.column].dateRange.absolute) && $scope.dateRangeFields[field.column].dateRange.dispVal;

				if (field.formatter) {
					const dataSet = $scope.getDataSetByName(dataSetName);
					includeVal = customReportSvc.getFormattedValue(includeVal, field.formatter, undefined, undefined, undefined, field, dataSet);
				}
				if(field.showEmptyValues) {
					const emptyVal = qb.rv.getQueryForEmptyVal();
					if(emptyVal === includeVal)
						includeVal =  field.emptyValueLabel;
					else if(emptyVal === excludeVal)
						excludeVal = field.emptyValueLabel;
				}
				if (includeVals.length === 0) {
					if (excludeVals.length === 0)
						return isDaterangeApplied ? $scope.dateRangeFields[field.column].dateRange.dispVal : field.displayName;

					var eValCnt = excludeVals.length - 1;
					return "Exclude: "+ excludeVal + (eValCnt > 0 ? ("+" + eValCnt) : "");
				}
				var iValCnt = includeVals.length - 1;
				if(isDaterangeApplied)
					iValCnt++;
				return includeVal + (iValCnt > 0 ?  ("+" + iValCnt) : "");
			}
			return field.displayName;
		}

		/*
		 * to check if a field is date type, and in case of date type field make a (deep) copy in dateFieldObj
		 * and update the daterange filter as well.
		 */
		$scope.config.isDateRange = function(field, dataSetName, dateRangeObj) {
			let isDate;
			if (field && field.type) {
				if (dateTypes.indexOf(field.type) == -1) {
					return false;
				} else
					isDate = true;

			}
			var dataSet = $scope.getDataSetByName(dataSetName);
			if ($.isEmptyObject(dataSet) || $.isEmptyObject(field)) {
				return false;
			}
			if(dataSet.fields.length > 0) {
				angular.forEach(dataSet.fields, function(field1, index) {
					if (field.column === field1.dataField) {
						field.type = field1.type;
						if (dateTypes.indexOf(field1.type) != -1) {
							isDate = true;
							return;
						}
					}
				});
			}

			if (isDate) {
				var copyField = $scope.getFieldCopy(field, dataSetName);
				if (typeof dateRangeObj !== "undefined" && !$.isEmptyObject(dateRangeObj)) {

					copyField.dateRange = {"dispVal" :  copyField.dateRange.dispVal};

					if (typeof dateRangeObj === 'object') {
						copyField.dateRange.absolute = _.clone(dateRangeObj);
					} else {
						copyField.dateRange.relative = dateRangeObj;
					}
				}
				return true;
			}
			return false;
		}

		$scope.getFieldCopy = function(field, dataSetName) {
			if ($.isEmptyObject($scope.dateRangeFields)) {
				$scope.dateRangeFields = {};
			}
			if ($.isEmptyObject($scope.dateRangeFields[field.column])) {
				$scope.dateRangeFields[field.column] = {};
				angular.copy(field, $scope.dateRangeFields[field.column]);
				$scope.dateRangeFields[field.column].id = $scope.config.id;
				$scope.dateRangeFields[field.column].dateRange = {
					'absolute' : {}
				};
				customReportSvc.registerCallback("dateRangeUpdated", function(callBackInfo) {
					if (!$.isEmptyObject($scope.dateRangeFields[field.column])) {
						$scope.dateRangeFields[field.column].dateRange = callBackInfo;
							$scope.applyFacetFilter(undefined,
								$scope.dateRangeFields[field.column],
									false,
									undefined,
									dataSetName);
					}
				}, $scope.config.id + "_" + field.column);
			}
			$scope.dateRangeFields[field.column].selectAll = field.selectAll;
			return $scope.dateRangeFields[field.column];
		}

		$scope.dropped = function(dragEl, dropEl) {
			//if we drop filter panel first without having any dataset then on drop of first field we need to set dataset object
			if (!$.isEmptyObject($scope.page) && !$.isEmptyObject($scope.page.dataSets) &&
					!$.isEmptyObject($scope.page.dataSets.dataSet)) {
				$scope.dataSets = $scope.page.dataSets.dataSet;
			}
			// Because the handler jumps "outside" of angular, updates must be
			// made in an $applied scope
			var config = $scope.config;
			var filterMode = $scope.filterMode;
			var type = $scope.type;

			var dest = document.getElementById(dropEl);
			var src = document.getElementById(dragEl);

			var drag = angular.element(src);
			var drop = angular.element(dest);
			var columnName = drag.attr("data-name");

			var dataSetEntity = drag.data("datasetentity");
		    if (columnName === "allColumns") {
				$scope.config.allColumns = true;
				if(!$.isEmptyObject($scope.config.dataSet) && $scope.config.dataSet !== dataSetEntity) {
					alert("Mismatched data Sets");
						return;
				}
				$scope.config.dataSet = dataSetEntity;
				$scope.allColumnsDropped =  true;
				$scope.addAllColumnsToFilter();
			} else {

				var dataSetName = dataSetEntity.dataSetName;
				if (type !== 'pageProperties') {
					if (!getDataSetFromFilters(dataSetEntity)) {
						alert("Mismatched data Sets");
						return;
					}
				}
				if ($.isEmptyObject($scope.filterDataField)) {
					$scope.filterDataField = {
						'builder' : {},
						'viewer' : {}
					};
				}
				if ($.isEmptyObject($scope.filterDataField[filterMode])) {
					$scope.filterDataField[filterMode] = {};
					$scope.filterDataField[filterMode][dataSetName] = {
						'fields' : [],
						'groups' : []
					};
				}
				if ($.isEmptyObject($scope.filterDataField[filterMode][dataSetName])) {
					$scope.filterDataField[filterMode][dataSetName] = {
						'fields' : [],
						'groups' : []
					};
				}
				var fields = $scope.filterDataField[filterMode][dataSetName]['fields'];
				var field = getDefaultFieldProperties(drag.attr("data-name"));
				var duplicate = false;
				angular.forEach(fields,function (facetField,index) {
					if(field.column === facetField.column) {
						duplicate = true;
						alert("Duplicate fields are not allowed.");
						return;
					}

				});

				if(!duplicate) {
					var fieldType = drag.data('type');
					$scope.assignAdditionalFieldProperties(field,fieldType);

					fields.push(field);
					if ($scope.type !== 'component') {
						var filters = "";
						if (!$scope.filters['builder'] || !(filters = $scope.filters['builder'][dataSetName])) {
							$scope.filters['builder'] = {};
							filters = $scope.filters['builder'][dataSetName] = {};
						}
						if (!filters[field.column]) {
							filters[field.column] = {
								'include' : [],
								'exclude' : [],
								'advancedFilters' : []
							};
						}
					}

					$scope.showFacet(true);
					$scope.$apply();
				}

			}



		};
		// to change sorting
		$scope.applySorting = function(field, measure, aggrType) {
			// if sorting is already applied for the current measure field
			// then flip the order
			var sortField = "";
			if (measure) {
				sortField = aggrType + "_" + measure;
			} else {
				sortField = 'index';
			}
			if (field.sort.sortField === sortField) {
				if (field.sort.sortDirection === 'asc') {
					field.sort.sortDirection = 'desc';
				} else {
					field.sort.sortDirection = 'asc';
				}
			} else {
				field.sort = {
					"sortField" : sortField,
					"sortDirection" : 'desc'
				};
			}
			$scope.showFacet(false);
		};
		$scope.$on('updateComponentFields', function(e, dataSet) {
			var filters = undefined, isComponent = false, isRefreshRequired = false;
			if ($scope.type === 'component') {
				filters = $scope.config.filterDataField['viewer'];
				isComponent = true;
			} else {
				filters = $scope.filters['builder'];
			}
			angular.forEach(filters, function(filterObj, dataSetName) {
				// check for the name of the dataset. Data Set name might have
				// changed, so check with old dataset name.
				if (dataSet.dataSet.originalDataSetName === dataSetName) {
					//delete filter fields which are not present in new edited dataset fields
					var found;
					angular.forEach(filters[dataSetName].fields, function(filterField,index) {
						 found = false;
						 angular.forEach(dataSet.fields, function(datasetField) {
							if(datasetField.name === filterField.column)
								found = true;
						});
						if (found === false)
							delete filters[dataSetName].fields[index];

					});
					// rename previous dataset to newly edited dataset
					filters[dataSet.dataSet.dataSetName] = customReportSvc.getDeepCopy(filters[dataSetName]);
					if(dataSet.dataSet.dataSetName !== dataSetName)
						delete filters[dataSetName];
				}
			});
			$scope.showFacet(true);
		});

		var getDataSetFromFilters = function(dataSetEntity) {
			var filters = "";
			if (!$scope.filters || $.isEmptyObject(filters = $scope.filters['builder'])) {
				return true;
			}
			var dataSetName = Object.keys(filters)[0] || "";
			if (dataSetName === dataSetEntity.dataSetName) {
				return true;
			}
			return false;
		};

		customReportSvc.registerCallback("refreshComponent", function(configId) {
			if ($scope.config.id === configId) {
				$scope.showFacet(false);
			}
		}, 'filter_' + $scope.config.id); // passing unique source id to avoid storing multiple callbacks

		if ($scope.type === 'component') {
			 customReportSvc.registerCallback("redrawAllComponents", function(data, isAutoRefresh) {
				if (data && data.id === $scope.config.id) {
					return false;
				}
				$scope.showFacet(true, undefined, undefined, undefined, isAutoRefresh);
			});

			customReportSvc.registerCallback("redrawComponent", function(data) {
				if (data && data.id === $scope.config.id) {
					return false;
				}
				$scope.showFacet(undefined,undefined,undefined,true);
			});

			 $scope.$watch('config.orientation', function(newValue, oldValue) {
				if (newValue != oldValue) {
					$scope.calculateGridsterSize();
				}
			});

		}

		$scope.$on('LVL-DRAG-START', function() {
			$scope.isFieldDragging = true;
			$scope.$apply();
		});

		$scope.$on('LVL-DRAG-END', function() {
			$scope.isFieldDragging = false;
			$("li[comp=" + $scope.config.id + "] .overlay").removeClass('lvl-over')
			$scope.$apply();
		});

		// clear component fitlers before deleting the component
		$scope.$on('clearAppliedFilters', function(event, componentId) {
			if (componentId === $scope.config.id) {
				if ($scope.type === 'component') {
					if (!$scope.filterDataField) {
						return;
					}
					angular.forEach($scope.filterDataField[$scope.filterMode], function(dataSetObj, dataSetName) {
						angular.forEach(dataSetObj["fields"], function(fieldObj, index) {
							if (index == dataSetObj["fields"].length - 1) {
								$scope.clearComponentFilters(fieldObj, dataSetName, false);
							} else {
								$scope.clearComponentFilters(fieldObj, dataSetName, true);
							}
						})
					});
				}
			}
		});

		angular.element("html").on("click", function(e) {
			let target = angular.element(e.target);
			if (target.is(":visible") && $scope.showFacetModal ===  true
				&& !(target.closest("#filter-modal, .daterangepicker").length)) {
				$("li[comp=" + $scope.config.id + "]").css("overflow", "hidden");
				$("li[comp=" + $scope.config.id + "]").css("z-index", "5");
				$scope.showFacetModal = false;
				delete $scope.field;
				$scope.$apply();
			} else {
				if (angular.element(e.target).closest("#fieldMenu" + $scope.config.id  + ".reportColums_container").length > 0)
					return false;

				angular.element("li[comp=" + $scope.config.id + "] .reportColums_container").slideUp();
				if(angular.element(e.target).closest("li[comp=" + $scope.config.id + "]").length === 0 && !$scope.showFacetModal)
					$("li[comp=" + $scope.config.id + "]").css("overflow", "hidden");
			}

		});


		$scope.$on('$destroy', () => {
			angular.element("html").off("click");
			if (typeof $scope.applyFacetFilterListener === 'function') {
				$scope.applyFacetFilterListener();
			}
		});

		$scope.config.isEnableFieldVisibilityOption = function() {
			var fieldCount = 0;
			if($scope.filterDataField)
				angular.forEach($scope.filterDataField[$scope.filterMode], function(filterFields) {
					fieldCount += filterFields.fields.length;
				});

			return (fieldCount > 1)
		}

		$scope.config.showOrHideFieldsMenu = function($event) {
			var fieldMenu = $('#fieldMenu' + $scope.config.id);
			fieldMenu.toggle();
			$event.stopPropagation();
		}

		$scope.config.showOrHideFilterField = function(dataSetName,field) {
			if(!field.isVisible) {
				var visibleFieldsCnt = 0;
				angular.forEach($scope.filterDataField[$scope.filterMode], function(fieldsObj, dataSetName) {
					angular.forEach(fieldsObj.fields,function(fieldObj) {
						if(fieldObj.isVisible)
							visibleFieldsCnt ++;
					});
				});

				if(visibleFieldsCnt === 0) { //do not allow to hide last field
					field.isVisible = true;
					return;
				}

				//if filter has been applied for the field then below code is to remove it before hiding the field
				if($scope.filters[$scope.filterMode][dataSetName] && $scope.filters[$scope.filterMode][dataSetName][field.column])
					$scope.clearComponentFilters(field,dataSetName);
			} else {
				$scope.showFacet(false, field, dataSetName);
			}

			$scope.calculateGridsterSize(field.isVisible);
		}



		$scope.getModelValForInput = function(field, facet,dataSetName) {
			return field.showRadioButtons ? 'true' : $scope.isSelectedVal(facet, field, dataSetName);
		}

		$scope.openFieldSetting = function(field,dataSetName,event) {
			event.stopPropagation();
			var modalInstance = $uibModal.open({
	           templateUrl:  customReportSvc.getContextPath() +"/reportsplus/modal/views/fieldSettingModal.jsp",
	           controller: "fieldSettingCtrl",
	           resolve: {
	           		field : function() {
	           			return customReportSvc.getDeepCopy(field);
	           		}
	           }
	        });

			modalInstance.result.then(function (modifiedField) {
				if(modifiedField.showRadioButtons && field.showRadioButtons !== modifiedField.showRadioButtons) {
					$scope.clearComponentFilters(field, dataSetName, false, true);
				}
				var index = $scope.filterDataField[$scope.filterMode][dataSetName].fields.indexOf(field);
				$scope.filterDataField[$scope.filterMode][dataSetName].fields[index] = modifiedField;
				$scope.showFacet();

		   });

		}
		$scope.config.openFilterSettingModal = function() {
			 var modalInstance = $uibModal.open({
	           templateUrl:  customReportSvc.getContextPath() +"/reportsplus/modal/views/columnSettingModal.jsp",
	           controller: "columnSettingCtrl",
	           windowClass: 'colSettingModalWindow reportModal',
	           resolve: {
	           		columns : function() {
	           			var dataSetName = $scope.config.dataSet.dataSetName,
						dataSet = $scope.getDataSetByName(dataSetName),
	           			dsFields = dataSet.fields,fields=[];
	           			angular.forEach($scope.filterDataField[$scope.filterMode][dataSetName].fields,function(field) {
	           				fields.push({
	           							 	dataField : field.column,
	           							  	displayName : field.displayName,
	           							  	visible : field.isVisible
	           							});

	           			});
	           			return fields;
	           		},
	           		dataSet : function() {
	           			return $scope.getDataSetByName($scope.config.dataSet.dataSetName);
	           		},
	           		Title : function() {
	           			return localMsg["FilterSettings"];
	           		}
	           }
	        });

			modalInstance.result.then(function (selectedFields) {
				var dataSetName = $scope.config.dataSet.dataSetName,
				filterFields = $scope.filterDataField[$scope.filterMode][dataSetName].fields;
				angular.forEach(filterFields,function(field,index) {
		      		var isFieldPresent = selectedFields.filter(function(selField) {
						return selField.dataField === field.column;
					}).length > 0;
					if(!isFieldPresent) {
						field.isVisible = false;
						if($scope.filters[$scope.filterMode][dataSetName] && $scope.filters[$scope.filterMode][dataSetName][field.column])
							$scope.clearComponentFilters(field,dataSetName);
					}
					else
						field.isVisible = true;

		      	});
				var fieldsToBeAdded = selectedFields.filter(function(selField) {
					return filterFields.filter(function(field) {
						return selField.dataField === field.column;
					}).length === 0;
				});
				if(fieldsToBeAdded.length > 0) {
					angular.forEach(fieldsToBeAdded,function(field) {
						var fieldObj = getDefaultFieldProperties(field.name);
						$scope.assignAdditionalFieldProperties(fieldObj,field.type)
						filterFields.push(fieldObj);
					});
					$scope.showFacet();
				}
		   });

		}


		$scope.config.showNoResultMsg = function() {
			return angular.element("li[comp=" + $scope.config.id + "] .fieldList").children().length === 0;
		}

		customReportSvc.registerCallback("addMeasureToFilterPanel", function(data) {
			var selectedField = data.selectedMeasureField;
			var field = data.field;
			var measure = getDefaultFieldProperties(selectedField.dataField);
			measure.aggrTypes = [ 'Count' ];

			if (integerDataTypes.indexOf(selectedField.type) !== -1) {
				measure.showNumberOps = true;
			}
			if (!field.measureDataFields || field.measureDataFields.length == 0) {
				field.measureDataFields = [];
			}
			field.measureDataFields.push(measure);
			$scope.showFacet(false);
		}, $scope.config.id); // passing unique source id to avoid storing
								// multiple callbacks
		$scope.initComponent(true);
		$scope.showFacet(true);
		$scope.showCalender = function (e) {
			var dateRangePicker = $(".dateRangeInput",e.currentTarget.parentElement);
			dateRangePicker.data("daterangepicker").show();
		};
	}
})();
