<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.ReportsPlusMessages">

	<fmt:message key="CriticalStatus" var="criticalStatus" />
	<fmt:message key="WarningStatus" var="warningStatus" />
	<fmt:message key="GoodStatus" var="goodStatus" />
	<fmt:message key="InfoStatus" var="infoStatus" />

	<div id="alarmsDialog" data-ng-class="{ 'webconsole-alert-dialog' : isWebConsole, 'adminconsole-alert-dialog': !isWebConsole  }" cv-modal-draggable>
		<div class="modal-header">
			<h3 class="modal-title">{{alertTitlePrefix}}</h3>
		</div>

		<div class="alarms-dialog-wrapper" data-ng-if="isColumnInfoLoading">
			<div class="row">
				<div class="col-sm-12">
					<fmt:message key="CustomReport.Loading" />
				</div>
			</div>
		</div>
		<div class="alarms-dialog-wrapper" data-ng-if="!isColumnInfoLoading">
			<div class="form-group row">
				<label for="alarmName" class="col-sm-3 col-form-label">
					<fmt:message key="AlertName" /></label>
				<div class="col-sm-9">
					<input type="text" class="form-control-plaintext full-width input-control" id="alarmName" data-ng-model="alarm.alarmName">
				</div>
			</div>
			<div class="row">
				<div class="col-sm-12">
					<fmt:message key="SendNotificationWith" />
					<span id="alertSeverity">
						<select id="allOrAnySelect" class="auto-width" data-ng-model="alarm.severity" data-ng-options="value.id as value.label for value in alertSeverityOptions"></select>
						<fmt:message key="StatusText" /></span>

					<span id="allOrAnyDiv" class="" data-ng-if="!isTileAlert">
						<select id="allOrAnySelect" class="auto-width" data-ng-model="alarm.isOrValue" ng-disabled="conditions.length < 2"
						 data-ng-class="{'enabled':conditions.length > 1 , 'disabled':conditions.length < 2}" data-ng-options="value.id as value.label for value in isOrOptions"></select>
						<fmt:message key="SendNotificationRestText" />
					</span>
				</div>
			</div>

			<div id="general-opts-div" class="row">
				<div class="col-sm-12">
					<div id="gen-paramName" class="alarmReportName"></div>
					<ul id="gen-alarmOpts">
						<li data-ng-if="isTileAlert" class="editable-alarm gen-alarm-row">
							<div id="paramsDiv">
								<label>{{tileData.tileName}}'s status is</label>
								<select id="statusSelect" class="auto-width" data-ng-model="conditions[0].value" ng-init="!editCriteriaSet ? conditions[0].value = '4' : true">
									<option value="4">${criticalStatus}</option>
									<option value="3">${warningStatus}</option>
									<option value="2">${goodStatus}</option>
								</select>
							</div>

						</li>

						<li data-ng-if="!isTileAlert" class="editable-alarm gen-alarm-row  padding-left-none" data-ng-repeat="condition in conditions">
							<div id="paramsDiv" class="row">
								<div class="col-sm-4">
									<select class="gen-columnSelect full-width" data-ng-model="condition.columnName" data-ng-options="column.name as column.title for column in alarmColList"
									data-ng-change="setValueOption(condition,column)"></select>
								</div>
								<div data-ng-class="{'col-sm-3' : condition.type == 'Time' || condition.type == 'TimeStamp' , 'col-sm-4' : condition.type != 'Time' && condition.type != 'TimeStamp' }">
									<select id="gen-opSelect" class="opSelect gen-opSelect full-width" data-ng-model="condition.operator"
									data-ng-options="value.id as value.label for value in condition.valueOptions" data-ng-change="checkIfApplicable(condition,column)"></select>
								</div>
								<div data-ng-class="{'col-sm-2' : condition.type == 'Time' || condition.type == 'TimeStamp' , 'col-sm-3' : condition.type != 'Time' && condition.type != 'TimeStamp' }">
									<input type="text" class="input-control full-width" data-ng-model="condition.value" required
									data-ng-class="{'errorField':condition.invalid, 'col-date-type':condition.type == 'Time' || condition.type == 'TimeStamp'}"
									data-ng-disabled="condition.notapplicable" placeholder="{{condition.placeholdertext}}">
								</div>

								<div data-ng-if="condition.type == 'Time' || condition.type == 'TimeStamp'" class="col-sm-2">
									<select  id="gen-opSelect" class="opSelect gen-opSelect full-width input-control"
									data-ng-model="condition.relativeTimeValue" data-ng-options="obj.id as obj.label for obj in relativeOptions"></select>
								</div>

								<div class="col-sm-1">
									<button class="removeCondition" title="<fmt:message key='remove' />" data-ng-click="removeCondition($index)"
									data-ng-disabled="conditions.length < 2" data-ng-class="{'enabled':conditions.length > 1 , 'disabled':conditions.length < 2}"><span>&times;</span></button>
								</div>
							</div>
						</li>
					</ul>
				</div>
			</div>
			<div class="form-group row">
				<div class="col-sm-12">
					<button data-ng-if="!isTileAlert" title='<fmt:message key="add_new_condition" />' class="addNewCondition"
					 data-ng-click="addCondition()">
						<fmt:message key="AddCondition" /></button>
					<button class="testCriteria" title='<fmt:message key="Test_Criteria" />' data-ng-click="testCriteria()">
						<fmt:message key="Test_Criteria" /></button>
				</div>
			</div>

			<div id="alarmErr" class="alarmErr" data-ng-bind="alarm.error"></div>
			<div class="clearFloat"></div>

			</div>

			<uib-accordion close-others="false">
				<div id="notifications-accordion" uib-accordion-group is-open="accordions.notifications.isOpen">
					<uib-accordion-heading>
	                    <i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': accordions.notifications.isOpen, 'glyphicon-chevron-right' : !accordions.notifications.isOpen}"></i>
	                    <span class="title-val"><fmt:message key="label.accordion.notification" /></span>
	                </uib-accordion-heading>
					<div class="notificationType form-group row" data-ng-hide="isPublicMetricsCloud">
						<ul class="notes col-sm-12">
							<li data-ng-repeat="notification in notifications"><input id="{{notification.domId}}" type="checkbox"
								 checklist-model="alarm.notificationsSelected" checklist-value="notification.id"><label for="{{notification.domId}}" class="notification-label">{{notification.label}}</label></li>
						</ul>
					</div>

					<div data-ng-show="alarm.notificationsSelected.indexOf('EMAIL') != -1">
						<div class="form-group row">
							<label for="emailTo" class="col-sm-3 col-form-label">
								<fmt:message key="Recipients" /></label>
							<div class="col-sm-9">
								<span class="email_suggestion full-width" data-max-suggestion="5" data-margin-left="0" data-suggestion-width="100%">
									<input type="text" class="form-control-plaintext full-width input-control" id="emailTo" placeholder="<fmt:message key='alert.email_place_holder' />"
									 data-ng-model="alarm.email" data-ng-class="{'errorField':alarm.invalidEmail}">
								</span>
							</div>
						</div>
						<div class="form-group row">
							<label for="emailCc" class="col-sm-3 col-form-label">
								<fmt:message key="CcRecipients" /></label>
							<div class="col-sm-9">
								<span class="email_suggestion full-width" data-max-suggestion="3" data-margin-left="0" data-suggestion-width="100%">
									<input type="text" class="form-control-plaintext full-width input-control" id="emailCc" placeholder="<fmt:message key='alert.email_place_holder' />"
									 data-ng-model="alarm.emailCc" data-ng-class="{'errorField':alarm.invalidEmailCc}">
								</span>
							</div>
						</div>
						<div class="form-group row">
							<label for="emailBcc" class="col-sm-3 col-form-label">
								<fmt:message key="BccRecipients" /></label>
							<div class="col-sm-9">
								<span class="email_suggestion full-width" data-max-suggestion="2" data-margin-left="0" data-suggestion-width="100%">
									<input type="text" class="form-control-plaintext full-width input-control" id="emailBcc" placeholder="<fmt:message key='alert.email_place_holder' />"
									 data-ng-model="alarm.emailBcc" data-ng-class="{'errorField':alarm.invalidEmailBcc}">
								 </span>
							</div>
						</div>
					</div>

					<!-- Email Body -->
					<div class="form-group row" data-ng-show="alarm.notificationsSelected.indexOf('EMAIL') != -1 || alarm.notificationsSelected.indexOf('LIVEFEEDS') != -1">
						<label for="emailBody" class="col-sm-3 col-form-label">
							<fmt:message key="EmailBody" /></label>
						<div class="col-sm-9">
							<textarea id="emailBody" class="gen-Custom-SNMP-template form-control-plaintext full-width input-control" rows="2"
							 data-ng-model="alarm.emailHeader"></textarea>
						</div>
					</div>

					<!--customiseSNMPTrap-->
					<div class="form-group row" data-ng-show="alarm.notificationsSelected.indexOf('SNMP') != -1 || alarm.notificationsSelected.indexOf('APPLOG') != -1 || alarm.notificationsSelected.indexOf('SCOM') != -1">
						<label for="customSNMPTrap" class="col-sm-3 col-form-label">
							<fmt:message key="Description" /></label>
						<div class="col-sm-9">
							<textarea id="customSNMPTrap" class="gen-Custom-SNMP-template form-control-plaintext full-width input-control"
							 rows="4" data-ng-model="alarm.templateDescriptionSNMP"></textarea>
						</div>
						<span class="col-sm-9 col-sm-offset-3">
							<fmt:message key="Alarms_SNMP_Note" /></span>
					</div>

					<div id="alarmErr" class="alarmErr" data-ng-bind="accordions.notifications.error"></div>
					<div class="clearFloat"></div>
				</div>


				<div id="schedules-accordion" uib-accordion-group is-open="accordions.schedules.isOpen">
					<uib-accordion-heading >
	                    <i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': accordions.schedules.isOpen, 'glyphicon-chevron-right' : !accordions.schedules.isOpen}"></i>
	                    <span class="title-val"><fmt:message key="label.accordion.schedule" /></span>
	                </uib-accordion-heading>

	                <div class="form-group row" data-ng-show="alarm.loadingScheduleDetails">
						<div class="col-sm-12"><fmt:message key="Loading_Schedule_Details" /></div>
					</div>
					<div class="form-group row" data-ng-show="!alarm.loadingScheduleDetails">
						<label class="col-sm-3 col-form-label"><fmt:message key="Time" /></label>
						<div class="col-sm-9">
							<div id="timeElement" class="cvTimepicker ui-front" title="">
								<input type="hidden" id="timeValue" name="timeValue" value="28800">
								<select class="hourDD" data-ng-model="alarm.hour">
									<option value="1">1</option>
									<option value="2">2</option>
									<option value="3">3</option>
									<option value="4">4</option>
									<option value="5">5</option>
									<option value="6">6</option>
									<option value="7">7</option>
									<option value="8">8</option>
									<option value="9">9</option>
									<option value="10">10</option>
									<option value="11">11</option>
									<option value="12">12</option>
								</select>
								<span class="separator">:</span>
								<input type="text" class="minuteDD minuteText" data-ng-model="alarm.minute" data-ng-click="openMinutesDropdown()"
									maxlength="2" data-ng-class="{'errorField':alarm.invalidMinutes}" />
								<select class="minuteDD" data-ng-model="alarm.minute">
									<option value="00">00</option>
									<option value="05">05</option>
									<option value="10">10</option>
									<option value="15">15</option>
									<option value="20">20</option>
									<option value="25">25</option>
									<option value="30">30</option>
									<option value="35">35</option>
									<option value="40">40</option>
									<option value="45">45</option>
									<option value="50">50</option>
									<option value="50">55</option>
								</select>
								<select class="AMDD" data-ng-model="alarm.ampm">
									<option value="0">
										<fmt:message key="am" />
									</option>
									<option value="12">
										<fmt:message key="pm" />
									</option>
								</select>
							</div>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label">
							<fmt:message key="timezone" /></label>
						<div class="col-sm-9">
							<select id="timezone" data-ng-model="alarm.timezone" data-ng-show="alarm.timezone >0" class="full-width">
								<option data-ng-repeat="tz in timezones" value="{{tz.tzId}}" title="{{tz.timezoneDisplayName}}">
									{{tz.timezoneDisplayName}}
								</option>
								<%-- <c:forEach items="${CommServTimeZones.timezones}" var="timezone">
									<option value="${timezone.tzId}" title="${timezone.timezoneDisplayName}">${timezone.timezoneDisplayName}</option>
								</c:forEach> --%>
							</select>
							<span data-ng-show="alarm.timezone == 0">{{CS_TIMEZONE_STR}}</span>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label"><fmt:message key="Frequency" /></label>
						<div class="col-sm-9">
							<select id="alarmFreqOptionSelect" class="full-width" data-ng-model="alarm.freqType" data-ng-options="value.id as value.label for value in alertFreqOptions"
							data-ng-change="changeAlarmFreq()"></select>
						</div>
					</div>
					<div class="row">
						<div id="weeklyElements" data-ng-show="alarm.freqType == 'WEEKLY'" class="col-sm-12">
							<ol id="daysToRunList" class="clearfix">
								<li data-ng-repeat="weekday in weekdays"><input type="checkbox" checklist-model="alarm.weekDays" checklist-value="weekday.id" name="{{weekday.id}}" id="{{weekday.id}}">
									<label for="{{weekday.id}}" class="notification-label">{{weekday.label}}</label></li>
							</ol>
						</div>
						<div id="monthlyElements" data-ng-show="alarm.freqType == 'MONTHLY'">
							<div class="form-group col-sm-12">
								<input type="radio" id="dateSelector" name="monthSelection" value="dateSelector" data-ng-model="alarm.monthSelector">
								<label for="dateSelector" class="notification-label">
									<fmt:message key="on_day" /></label>
								<input id="dateSpinner" name="dateValue" type="number" min="1" max="31" data-ng-model="alarm.dayOfMonth"
								data-ng-class="{'errorField':alarm.invalidDay}" class="input-control">
							</div>
							<div class="col-sm-12">
								<input type="radio" id="daySelector" name="monthSelection" value="daySelector" data-ng-model="alarm.monthSelector">
								<label for="daySelector" class="notification-label">
									<fmt:message key="on_the" /></label>
								<select name="weekOfMonth" id="weekOfMonth" data-ng-model="alarm.weekOfMonth" data-ng-class="{'disabledaySelector':(alarm.monthSelector !== 'daySelector')}">
									<option value="First">
										<fmt:message key="First" />
									</option>
									<option value="Last">
										<fmt:message key="Last" />
									</option>
									<option value="Second">
										<fmt:message key="Second" />
									</option>
									<option value="Third">
										<fmt:message key="Third" />
									</option>
									<option value="Fourth">
										<fmt:message key="Fourth" />
									</option>
								</select>
								<select name="dayOfWeek" id="dayOfWeek" data-ng-model="alarm.dayOfWeek" data-ng-class="{'disabledaySelector':(alarm.monthSelector !== 'daySelector')}">
									<option value="Weekday">
										<fmt:message key="Weekday" />
									</option>
									<option value="Weekend_Day">
										<fmt:message key="Weekend" />
									</option>
									<option value="Monday">
										<fmt:message key="monday" />
									</option>
									<option value="Tuesday">
										<fmt:message key="tuesday" />
									</option>
									<option value="Wednesday">
										<fmt:message key="wednesday" />
									</option>
									<option value="Thursday">
										<fmt:message key="thursday" />
									</option>
									<option value="Friday">
										<fmt:message key="friday" />
									</option>
									<option value="Saturday">
										<fmt:message key="saturday" />
									</option>
									<option value="Sunday">
										<fmt:message key="sunday" />
									</option>
								</select>
							</div>
						</div>
						<div id="repeatNHoursElements" class="repeatNHoursElements col-sm-12" data-ng-show="alarm.freqType == 'DAILY'">
							<input class="repeatEveryNHours" type="checkbox" data-ng-model="alarm.repeatEveryNHours" name="repeatEveryNHours"
							 id="repeatEveryNHours">
							<label for="repeatEveryNHours" class="notification-label">
								<fmt:message key="schedule.label.repeatEvery" /></label>
							<span data-ng-class="{'disabled':!alarm.repeatEveryNHours}">
								<input id="everyNHoursSpinner" name="everyNHoursSpinner" type="number" value="8" min="0" max="24" data-ng-model="alarm.everyNHoursSpinner"
								 data-ng-disabled="!alarm.repeatEveryNHours" data-ng-class="{'errorField':invalidRepeatMinutes}" class="input-control">
								<span>
									<fmt:message key="schedule.label.hours" /></span>
								<input id="everyNMinsSpinner" name="everyNMinsSpinner" type="number" value="0" min="0" max="59" data-ng-model="alarm.everyNMinsSpinner"
								 data-ng-disabled="!alarm.repeatEveryNHours" data-ng-class="{'errorField':invalidRepeatHours}" class="input-control">
								<span>
									<fmt:message key="schedule.label.minutes" /></span>
								<span>
									<fmt:message key="schedule.label.until" /></span>
								<span id="timeElementUntil" data-ng-class="{'disableRepeatNHoursElement':!alarm.repeatEveryNHours}">
									<span id="activeEndTimeDisplay"></span>
									<input type="hidden" id="activeEndTime" name="activeEndTime" value="86100" />
									<select class="hourDD" data-ng-model="alarm.endTimeHour" data-ng-disabled="!alarm.repeatEveryNHours"
									 data-ng-class="{'disableRepeatNHoursElement':!alarm.repeatEveryNHours}">
										<option value="1">1</option>
										<option value="2">2</option>
										<option value="3">3</option>
										<option value="4">4</option>
										<option value="5">5</option>
										<option value="6">6</option>
										<option value="7">7</option>
										<option value="8">8</option>
										<option value="9">9</option>
										<option value="10">10</option>
										<option value="11">11</option>
										<option value="12">12</option>
									</select>
									<span class="separator">:</span>
									<input type="text" class="minuteDD minuteText" data-ng-model="alarm.endTimeMinute" maxlength="2"
									 data-ng-disabled="!alarm.repeatEveryNHours" data-ng-class="{'errorField':alarm.invalidEndTimeMinutes, 'disableRepeatNHoursElement':!alarm.repeatEveryNHours}" />
									<select class="minuteDD" data-ng-model="alarm.endTimeMinute" data-ng-disabled="!alarm.repeatEveryNHours"
									 data-ng-class="{'disableRepeatNHoursElement':!alarm.repeatEveryNHours}">
										<option value="00">00</option>
										<option value="05">05</option>
										<option value="10">10</option>
										<option value="15">15</option>
										<option value="20">20</option>
										<option value="25">25</option>
										<option value="30">30</option>
										<option value="35">35</option>
										<option value="40">40</option>
										<option value="45">45</option>
										<option value="50">50</option>
										<option value="50">55</option>
									</select>

									<select class="AMDD" data-ng-model="alarm.endTimeAMPM" data-ng-disabled="!alarm.repeatEveryNHours" data-ng-class="{'disableRepeatNHoursElement':!alarm.repeatEveryNHours}">
										<option value="0">
											<fmt:message key="am" />
										</option>
										<option value="12">
											<fmt:message key="pm" />
										</option>
									</select>
								</span>
							</span>
						</div>
					</div>

					<div id="alarmErr" class="alarmErr padding-top-10" data-ng-bind="accordions.schedules.error"></div>
					<div class="clearFloat"></div>

	            </div>


			</uib-accordion>



			<div class="button-container" data-ng-class="{'modal-footer': isWebConsole, 'ac-footer': !isWebConsole,}">
					<a data-ng-show="!editCriteriaSet && isWebConsole" class="pull-left" ng-href="${pageContext.request.contextPath}/reports/reports.jsp?report=alarmsSettings">Manage
						Alerts</a>
				<a data-ng-disabled="alarm.loadingScheduleDetails" class="btn btn-primary pull-right" data-ng-class="{'wc-alert-btn-save btn-sm': isWebConsole}"
				 id="dialogbutton-save" data-ng-click="addAlarm(alarmForm)" data-ng-disabled="isColumnInfoLoading">
					<fmt:message key="CustomReport.Save" /></a>
				<a class="btn btn-default pull-right" data-ng-class="{'btn-sm': isWebConsole}" id="dialogbutton-cancel"
				 data-ng-click="$close()">
					<fmt:message key="CustomReport.Cancel" /></a>
				<div class="clear-float"></div>
			</div>



		<form name="testAlertCriteria" action="${pageContext.request.contextPath}/reports/testAlert.do" method="POST" target="_blank">
			<input type="hidden" name="testurl" />
			<input type="hidden" name="testCriteria" />
			<input type="hidden" name="gridId" />
			<input type="hidden" name="reportName" />
		</form>

	</div>

	<script nonce="${sessionScope.cspNonce}" type="text/javascript">
		var localMsg = localMsg || {};
		localMsg.criticalStatus = "${criticalStatus}";
		localMsg.warningStatus = "${warningStatus}";
		localMsg.goodStatus = "${goodStatus}";
		localMsg.infoStatus = "${infoStatus}";
	</script>

</fmt:bundle>