// Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	// Controller for "Add Data Set" modal

	app
			.controller("addDataSetModalCtrl",
					[
							"$scope",
							"customReportSvc",
							"reportService",
							"dataSource",
							"$window",
							function($scope, customReportSvc, reportService, $dataSource, $window) {
								/* connectors list mapping */

								$scope.policyInfo = {};
								$scope.policyInfo.selectedPolicy = {};
								$scope.policyInfo.selectedTemplates = [];
								$scope.policyInfo.selectedSavedSearch = {};
								$scope.policyInfo.policyMap = {};
								$scope.policyInfo.selectedSearchQuery = {};
								$scope.policyInfo.selectedSearchQuery.adHocQueryInfo = {};
								$scope.policyInfo.selectedSearchQuery.timeQuery = "";
								$scope.sharedDataSets;
								$scope.sharedDsList = [];

								if(System == undefined || System.additionalSettings == undefined || System.additionalSettings.Console == undefined || System.additionalSettings.Console.enableQueryForLMDataSet == undefined || System.additionalSettings.Console.enableQueryForLMDataSet == false)
								{
									$scope.lmDataSources = [ {
										type : "POLICY",
										dispName : "Policies"
									} ];
								}
								else
								{
									$scope.lmDataSources = [ {
										type : "POLICY",
										dispName : "Policies"
									}, {
										type : "SAVED_SEARCH",
										dispName : "Saved searches"
									}, {
										type : "QUERY",
										dispName : "Search query"
									} ];
								}

								$scope.showPreviewTable = false;
								$scope.unregisteredDataSourceSelected = false;
								$scope.rawDataLoading = false;
								$scope.endPointChanged = false;
								$scope.reportMode = "preview";
								$scope.endpoint = "DATABASE";
								$scope.previewRows = [ {
									value : '',
									label : 'All'
								}, {
									value : 5,
									label : '5'
								}, {
									value : 10,
									label : 10
								}, {
									value : 50,
									label : 50
								}, {
									value : 100,
									label : 100
								} ];
								$scope.updateEndpoint = function(endpoint) {
									// copy the dataset name from other endpoint dataset
									$scope.getEndpointLabel(endpoint);
									if ($scope.dataSet) {
										$scope.endpointDataSet[endpoint].dataSet.dataSetName = $scope.dataSet.dataSet.dataSetName;
									}
									$scope.endpoint = endpoint;
									$scope.dataSet = $scope.endpointDataSet[$scope.endpoint];
									$scope.dataSet.previewRowSize = 5;
									$scope.dataSet.preview = true;
									$scope.endPointChanged = !$scope.endPointChanged;
									$scope.currentTab = 'query';
									//TODO: for now we are calling the api everytime endpoint change (need to put a check here to avoid this)
									if (endpoint === "DATACUBE") {
										$scope.updateDataSourceTypes();
									} else if (endpoint === "MONITORING_POLICY") {
										if ($scope.mode === "Edit") {
											if ($scope.dataSet.lmDataSet.dataSetType) {
												$scope.dataSet.selectedLMSourceType = {};
												$scope.dataSet.selectedLMSourceType.type = $scope.dataSet.lmDataSet.dataSetType;
												$scope.updateLMDataSets();

												if ($scope.dataSet.selectedLMSourceType.type == "QUERY") {

													if ($scope.dataSet.lmDataSet.adHocQueryInfo) {
														$scope.policyInfo.selectedSearchQuery.adHocQueryInfo = $scope.dataSet.lmDataSet.adHocQueryInfo;
														$scope.policyInfo.selectedSearchQuery.searchParams = $scope.dataSet.lmDataSet.adHocQueryUrl;
													} else if ($scope.dataSet.lmDataSet.adHocQueryUrl) {
														$scope.policyInfo.selectedSearchQuery.searchParams = $scope.dataSet.lmDataSet.adHocQueryUrl;
														$scope.policyInfo.selectedSearchQuery.adHocQueryInfo = lmUtils.functions
																.getAdHocQueryInfo($scope.dataSet.lmDataSet.adHocQueryUrl,
																		$scope.dataSet.fields);
													}
												}
												else if($scope.dataSet.selectedLMSourceType.type == "POLICY"){
													if ($scope.dataSet.lmDataSet.adHocQueryInfo)
														$scope.policyInfo.selectedSearchQuery.adHocQueryInfo = $scope.dataSet.lmDataSet.adHocQueryInfo;
												}
											}
										}
									} else if (endpoint === "DATASET" || endpoint === "SCRIPT") {
										$scope.joinDataSets = [];
										angular.forEach($scope.dataSets, function(dataSet) {
											$scope.joinDataSets.push(dataSet.dataSet);
										});
									} else if (endpoint === 'SHARED') {
										$scope.getDataSets();
									}
								};

								$scope.getDataSets = function() {
									if (!$scope.datasets) {
										customReportSvc.mask("queryView", true, "Loading Datasets..."); // TODO: localize
										reportService.getAllDataSets(false).then(function(data) {
											$scope.sharedDataSets = data.data.dataSet;
											$scope.sharedDsList = [];
											angular.forEach($scope.sharedDataSets, function(ds, index) {
												var sds = ds.dataSet;
												sds.dataSetGuid = ds.guid;
												delete sds['dataSetId'];
												$scope.sharedDsList.push(sds);
											});
											customReportSvc.unMask("queryView", true);
										}, function(error) {
											customReportSvc.unMask("queryView", true);
											customReportSvc.errorToast(error.data);
										});
									}
								};

								$scope.updateDSparameters = function(dataset) {
									angular.forEach($scope.sharedDataSets, function(ds, index) {
										if (dataset.dataSetGuid === ds.guid) {
											if (ds.GetOperation.parameters && ds.GetOperation.parameters.length > 0) {
												$scope.dataSet.GetOperation.parameters = ds.GetOperation.parameters;
												console.log($scope.dataSet);
											}
										}
									});
								}

								/**
								 * Update the list of datasourcetypes
								 */
								$scope.updateDataSourceTypes = function() {
									function onSuccess(list) {
										$scope.listOfDS = list;
										$scope.dataSourceTypes = Object.keys(list);
										$scope.dCubeDataSets = [];
										$scope.dataSet.handlers = [];
									}
									var listOfDS = angular.fromJson($window.sessionStorage
											.getItem('cv.reports.dcubeConnectorsList'));
									if (!listOfDS) {
										customReportSvc.mask("queryView", true, "Loading SourceTypes..."); // TODO: localize
										reportService.fetchDataSourceTypes().then(function(dsTypes) {
											if (dsTypes.data && !$.isEmptyObject(dsTypes.data)) {
												$window.sessionStorage.setItem('cv.reports.dcubeConnectorsList',
														angular.toJson(dsTypes.data));
												onSuccess(dsTypes.data);
											}
											customReportSvc.unMask("queryView", true);
										},
												function(error) {
													customReportSvc.unMask("queryView", true);
													customReportSvc.errorToast(error.data);
												});
									} else {
										onSuccess(listOfDS);
									}
								}; // end method updateDataSourceTypes

								/**
								 * Update the list of LM data set
								 */
								$scope.updateLMDataSets = function() {
									if ($scope.dataSet.selectedLMSourceType.type === "POLICY") {
										$scope.policyInfo.selectedSavedSearch = {};
										$scope.getUserPolicies();
									} else if ($scope.dataSet.selectedLMSourceType.type === "SAVED_SEARCH") {
										$scope.policyInfo.selectedPolicy = {};
										$scope.getUserSavedSearches();
									}
								};

								/**
								 * Update the list of data cube data set
								 */
								$scope.updateDCubeDataSets = function(isOnSelect) {
									$scope.dsType = $scope.dataSet.dCubeDataSet.dsType;
									if (!$scope.dsType) {
										return;
									}
									// Update loading status
									$scope.loadingDataSources = true;
									customReportSvc.mask("queryView", true, "Loading Datasets..."); // TODO: localize
									$scope.dCubeDataSets = [];
									$scope.dataSet.handlers = [];
									$scope.dCubeDataSetsMap = {};
									var errCallback = function(error) {
										console.log(error);
										$scope.loadingDataSources = false;
									};
									var successCallback = function(resp) {
										customReportSvc.unMask("queryView", true);
										$scope.loadingDataSources = false;
										var dsMap = {}, hList = [];
										if (resp.data.error) {
											console.log(dataSets.data.error);
											return;
										}
										if (resp.data.federatedSearchInfos) {
											hList = resp.data.federatedSearchInfos;
										} else {
											hList = resp.data.handlerInfos;
										}
										if ($scope.dsType === 'federated') {
											var entityObj = customReportSvc
													.getSelectedCommcellEntity($scope.page.inputs);
											if (entityObj.hasOwnProperty("entityTypeId")) {
												hList = hList || [];
												hList.push({
													'dataSourceId' : -1,
													'entityTypeId' : entityObj.entityTypeId,
													'entityId' : entityObj.entityId,
													'handlerId' : -1,
													'dataSourceName' : 'System Defined Federated',
													'handlerName' : 'default'
												});
											}
										}

										angular.forEach(hList, function(hObj, index) {
											if (!dsMap[hObj.dataSourceId]) {
												dsMap[hObj.dataSourceId] = {
													"dsId" : hObj.dataSourceId,
													"dsName" : hObj.dataSourceName
												};
												if ($scope.dsType !== "federated") {
													dsMap[hObj.dataSourceId].handlers = [];
												}
											}
											if ($scope.dsType === "federated" && dsMap[hObj.dataSourceId].dsId == -1) {
												dsMap[hObj.dataSourceId]["dsHandler"] = {
													"entityId" : hObj.entityId,
													"entityTypeId" : hObj.entityTypeId,
													"handlerName" : hObj.handlerName,
													"handlerId" : hObj.handlerId
												};
											} else if ($scope.dsType === "federated") {
												dsMap[hObj.dataSourceId]["dsHandler"] = {
													"handlerId" : hObj.federateSearchId,
													"handlerName" : hObj.federateSearchName
												};
											} else {
												dsMap[hObj.dataSourceId].handlers.push({
													"handlerId" : hObj.handlerId,
													"handlerName" : hObj.handlerName
												});
											}
										});
										if (!$.isEmptyObject(dsMap)) {
											//Hack : maintaining array and map as array is needed for ng-options and map for quick lookup;
											$scope.dCubeDataSetsMap = dsMap;
											$scope.dCubeDataSets = $.map(dsMap, function(v, i) {
												return [ v ]
											});

											if (isOnSelect) {
												//select first data source by default
												var firstObj = $scope.dCubeDataSets[0];
												$scope.dataSet.dCubeDataSet = {
													"dsType" : $scope.dsType,
													"dsName" : firstObj.dsName,
													"dsId" : firstObj.dsId,
													"dsHandler" : firstObj.dsHandler ? firstObj.dsHandler
															: firstObj.handlers[0]
												};
												$scope.dataSet.dataSet.dataSetName = $scope.dataSet.dCubeDataSet.dsName +
														"_" + $scope.dataSet.dCubeDataSet.dsHandler.handlerName;
											} else {
												//edit case, pre-populate using find; otherwise combo will not show the selected item
												var dsId = $scope.dataSet.dCubeDataSet.dsId;
												var handlerId = $.isEmptyObject($scope.dataSet.dCubeDataSet.dsHandler) ? 0
														: $scope.dataSet.dCubeDataSet.dsHandler.handlerId;
												if ($scope.dataSet.dCubeDataSet.dsType === "federated") {
													$scope.dataSet.dCubeDataSet.dsHandler = $scope.dCubeDataSetsMap[dsId].dsHandler;
												} else {
													angular.forEach($scope.dCubeDataSetsMap[dsId].handlers, function(
															handler, index) {
														if (handler.handlerId == handlerId) {
															$scope.dataSet.dCubeDataSet.dsHandler = handler;
															return;
														}
													});
												}

											}
										}
									};
									if ($scope.dsType === "federated") {
										return reportService.fetchFederatedDataSources().then(successCallback,
												errCallback);

									} else {
										return reportService.fetchDataSetsForType($scope.dsType).then(successCallback,
												errCallback);
									}
								}; // end method updateDCubeDataSets
								/**
								 * set data set name and default handler for selected data set
								 */
								$scope.onDataSetChange = function() {
									if ($scope.dataSet.dCubeDataSet && $scope.dataSet.dCubeDataSet.dsId) {
										var dsId = $scope.dataSet.dCubeDataSet.dsId;
										$scope.dataSet.dCubeDataSet.dsName = $scope.dCubeDataSetsMap[dsId].dsName;
										if ($scope.dataSet.dCubeDataSet.dsType === "federated") {
											$scope.dataSet.dCubeDataSet.dsHandler = $scope.dCubeDataSetsMap[dsId].dsHandler;
											$scope.dataSet.dataSet.dataSetName = $scope.dataSet.dCubeDataSet.dsName;
										} else {
											//select first handler by default
											$scope.dataSet.dCubeDataSet.dsHandler = $scope.dCubeDataSetsMap[dsId].handlers[0];
											$scope.dataSet.dataSet.dataSetName = $scope.dataSet.dCubeDataSet.dsName +
													"_" + $scope.dataSet.dCubeDataSet.dsHandler.handlerName;
										}
									}
								};

								$scope.onHandlerChange = function() {
									if ($scope.dataSet.dCubeDataSet.dsHandler
											&& $scope.dataSet.dCubeDataSet.dsHandler.handlerName) {
										$scope.dataSet.dataSet.dataSetName = $scope.dataSet.dCubeDataSet.dsName
												+ "_"
												+ $scope.dataSet.dCubeDataSet.dsHandler.handlerName;
									}
								};
								var generatedGuid = customReportSvc.generateUUID();
								$scope.defaultDatabaseDataSet = {
									allColumns : false,
									dataSet : {
										dataSetName : "",
										dataSetGuid : generatedGuid
									}, // as suggested by chris , setting the guid for the data set in the gui will fix the mr 147800.
									guid : generatedGuid,
									endpoint : "DATABASE",
									databaseName : "CommServ",
									fields : [],
									GetOperation : {
										sqlText : "",
										parameters : [],
										timeout : 5,
										rDataSetQuery : "",
										rPlotQuery : "",
										rDataSets : []
									},
									queryPlan : {
										offline : isCloudSurvey,
										versions : [ "ALL" ],
										retentionDays : 1,
										dynamicCollection : false,
										frequency : 60,
										direct : false
									},
									computedColumns : {
										scriptName : "R",
										script : "",
										columnList : []
									}
								};

								$scope.defaultSharedDataSet = {
									allColumns : false,
									dataSet : {
										dataSetName : "",
										dataSetGuid : generatedGuid
									}, // as suggested by chris , setting the guid for the data set in the gui will fix the mr 147800.
									guid : generatedGuid,
									endpoint : "SHARED",
									databaseName : "CommServ",
									fields : [],
									GetOperation : {
										sqlText : "",
										parameters : [],
										timeout : 5,
										rDataSetQuery : "",
										rPlotQuery : "",
										rDataSets : []
									},
									queryPlan : {
										offline : false,
										versions : [ "ALL" ],
										retentionDays : 1,
										dynamicCollection : false,
										frequency : 60,
										direct : true
									},
									computedColumns : {
										scriptName : "R",
										script : "",
										columnList : []
									}
								};

								$scope.defaultDataSetEndpoint = {
									allColumns : false,
									dataSet : {
										dataSetName : "",
										dataSetGuid : generatedGuid
									}, // as suggested by chris , setting the guid for the data set in the gui will fix the mr 147800.
									guid : generatedGuid,
									endpoint : "DATASET",
									databaseName : "CommServ",
									fields : [],
									dataSources : [ {
										connectionType : "COMMCELL",
										commCell : {
											commCellName : "$LocalCommCell$"
										}
									} ],
									GetOperation : {
										sqlText : "",
										parameters : [],
										timeout : 5,
										postQueryFilter : true,
										rDataSetQuery : "",
										rPlotQuery : "",
										rDataSets : []
									},
									queryPlan : {
										offline : false,
										versions : [ "ALL" ],
										retentionDays : 1,
										dynamicCollection : false,
										frequency : 60,
										direct : true
									},
									dataSets : []
								};

								$scope.defaultScriptEndpoint = {
									allColumns : false,
									dataSet : {
										dataSetName : "",
										dataSetGuid : generatedGuid
									}, // as suggested by chris , setting the guid for the data set in the gui will fix the mr 147800.
									guid : generatedGuid,
									endpoint : "SCRIPT",
									databaseName : "CommServ",
									fields : [],
									dataSources : [ {
										connectionType : "COMMCELL",
										commCell : {
											commCellName : "$LocalCommCell$"
										}
									} ],
									GetOperation : {
										sqlText : "",
										parameters : [],
										timeout : 5,
										rDataSetQuery : "",
										rPlotQuery : "",
										rDataSets : []
									},
									queryPlan : {
										offline : false,
										versions : [ "ALL" ],
										retentionDays : 1,
										dynamicCollection : false,
										frequency : 60,
										direct : true
									},
									dataSets : []
								};

								$scope.joinDataSets = [];
								$scope.dataSetDropdownSettings = {
									displayProp : 'dataSetName',
									checkBoxes : true,
									showCheckAll : false,
									showUncheckAll : false
								};

								$scope.defaultHTTPDataSet = {
									allColumns : false,
									dataSet : {
										dataSetName : "",
										dataSetGuid : generatedGuid
									}, // as suggested by chris , setting the guid for the data set in the gui will fix the mr 147800.
									guid : generatedGuid,
									endpoint : "HTTP",
									fields : [],
									GetOperation : {
										headers : [ {
											name : "Accept",
											value : "application/xml"
										} ],
										httpContent : "",
										httpContentType : "application/xml; charset=UTF-8",
										method : "GET",
										parameters : [],
										restApi : "",
										rowExpression : "",
										timeout : 5,
										urlParameters : [],
										postQueryFilter : true,
										rDataSetQuery : "",
										rPlotQuery : "",
										rDataSets : []
									},
									headers : [ {
										name : "Accept",
										value : "application/xml"
									} ],
									queryPlan : {
										offline : false,
										versions : [ "ALL" ],
										retentionDays : 1,
										dynamicCollection : false,
										frequency : 60,
										direct : true
									},
									urlParameters : [],
									computedColumns : {

										scriptName : "R",
										script : "",
										columnList : []

									}

								}

								// default values for datacube
								//TODO: to put correct default values for datacubeset
								$scope.defaultDatacubeDataSet = {
									allColumns : false,
									dCubeDataSet : {
										dsId : 0,
										dsName : '',
										dsType : '',
										dsHandler : {
											handlerId : 0,
											handlerName : ''
										}
									},
									dataSet : {
										dataSetName : "",
										originalDataSetName : "",
										dataSetGuid : generatedGuid
									}, // as suggested by chris , setting the guid for the data set in the gui will fix the mr 147800.
									guid : generatedGuid,
									endpoint : "DATACUBE",
									fields : [],
									GetOperation : {
										sqlText : "",
										parameters : [],
										timeout : 5,
										rDataSetQuery : "",
										rPlotQuery : "",
										rDataSets : []
									},
									queryPlan : {
										offline : false,
										versions : [ "ALL" ],
										retentionDays : 1
									},
									computedColumns : {
										scriptName : "R",
										script : "",
										columnList : []
									}
								};

								$scope.defaultLMDataSet = {
									allColumns : false,
									dataSet : {
										dataSetName : "",
										originalDataSetName : "",
										dataSetGuid : generatedGuid
									}, // as suggested by chris , setting the guid for the data set in the gui will fix the mr 147800.
									guid : generatedGuid,
									endpoint : "MONITORING_POLICY",
									fields : [],
									GetOperation : {
										sqlText : "",
										parameters : [],
										timeout : 5,
										rDataSetQuery : "",
										rPlotQuery : "",
										rDataSets : []
									},
									queryPlan : {
										offline : false,
										versions : [ "ALL" ],
										retentionDays : 1
									},
									computedColumns : {
										scriptName : "R",
										script : "",
										columnList : []
									}
								};

								$scope.defaultRDataSet = {
									endpoint : "R",
									dataSet : {
										dataSetName : "",
										originalDataSetName : "",
										dataSetGuid : generatedGuid
									},
									dataSetGuid : generatedGuid,
									allColumns : false,
									fields : [],
									GetOperation : {
										sqlText : "",
										parameters : [],
										timeout : 5,
										rDataSetQuery : "",
										rPlotQuery : "",
										rDataSets : [],
										rDataSetListInfo : {}
									},
									queryPlan : {
										offline : false,
										versions : [ "ALL" ],
										retentionDays : 1
									},
									computedColumns : {
										scriptName : "R",
										script : "",
										columnList : []
									}
								};
					            $scope.defaultPYTHON3DataSet  = {
					                endpoint: "PYTHON3",
					                dataSet: {
					                    dataSetName: "",
					                    originalDataSetName: "",
					                    dataSetGuid: generatedGuid
					                },
					                dataSetGuid: generatedGuid,
					                allColumns: false,
					                fields: [],
					                GetOperation: {
					                    sqlText: "",
					                    parameters: [],
					                    timeout: 5,
					                    rDataSetQuery: "",
					                    rPlotQuery: "",
					                    rDataSets: [],
					                    rDataSetListInfo: {}
					                },
					                queryPlan: {
					                    offline: false,
					                    versions: ["ALL"],
					                    retentionDays: 1
					                },
					                computedColumns: {
					                    scriptName: "PYTHON3",
					                    script: "",
					                    columnList: []
					                }
					            };

								if (!$scope.dataSet) {
									$scope.dataSet = $scope.defaultDatabaseDataSet;
								}

								$scope.endpointDataSet = {};
								$scope.endpointDataSet.DATABASE = angular.copy($scope.defaultDatabaseDataSet);
								$scope.endpointDataSet.HTTP = angular.copy($scope.defaultHTTPDataSet);
								$scope.endpointDataSet.DATACUBE = angular.copy($scope.defaultDatacubeDataSet);
								$scope.endpointDataSet.MONITORING_POLICY = angular.copy($scope.defaultLMDataSet);
								$scope.endpointDataSet.DATASET = angular.copy($scope.defaultDataSetEndpoint);
								$scope.endpointDataSet.SCRIPT = angular.copy($scope.defaultScriptEndpoint);
								$scope.endpointDataSet.R = angular.copy($scope.defaultRDataSet);
								$scope.endpointDataSet.SHARED = angular.copy($scope.defaultSharedDataSet);
                				$scope.endpointDataSet.PYTHON3 = angular.copy($scope.defaultPYTHON3DataSet);

								$scope.endPointLabelMap = {
									"DATABASE" : "Database",
									"DATACUBE" : "Data Cube",
									"MONITORING_POLICY" : "Monitoring Policy",
									"DATASET" : "Join Dataset",
									"SCRIPT" : "Script",
									"HTTP" : "HTTP",
									"SHARED" : "Shared",
									"R" : "R Script",
									"PYTHON3": "Python 3 Script"
								}
								$scope.getEndpointLabel = function(endpoint) {
									$scope.endPointLabel = $scope.endPointLabelMap[endpoint];
								}

								$scope.userPolicyList = [];
								$scope.monitoringPolicies = [];
								$scope.userTemplates = [];
								$scope.userSavedSearches = [];
								$scope.paramterizedPolicies = [];

								$scope.getDataSetGuid = function(){
									return $scope.dataSet.shared ? $scope.dataSet.guid : $scope.customReport.guid+":"+$scope.dataSet.guid;
								}

								$scope.copyRestApiUrlToClipboard = function() {
									var el = document.createElement('textarea');
									el.value = $scope.getDataSetGuid();
									document.body.appendChild(el);
									el.select();
									document.execCommand('copy');
									document.body.removeChild(el);
									cvUtil.toast(cvUtil.cvLocalize('Copied_To_ClipBoard'), 1000, null, false);
								};

								$scope.updateDropDownWithParameterizedPolicies = function() {
									$scope.userPolicyList = [];
									$scope.updateParameterizedPolicies();
									$scope.userPolicyList = $scope.paramterizedPolicies.concat($scope.monitoringPolicies);
								}

								$scope.updateParameterizedPolicies = function() {
									$scope.paramterizedPolicies = [];
									if($scope.dataSet.GetOperation && $scope.dataSet.GetOperation.parameters && $scope.dataSet.GetOperation.parameters.length > 0){
										angular
										.forEach($scope.dataSet.GetOperation.parameters,function(currentParam){
											var currGenericPolicy = {monitoringPolicyName:"@" + currentParam.name , monitoringPolicyid:new Date().getTime(),monitoringTypes:[]};
											$scope.paramterizedPolicies.push(currGenericPolicy);
											if ($scope.policyInfo.selectedPolicy &&
													$scope.policyInfo.selectedPolicy.monitoringPolicyName === "@" + currentParam.name) {
												$scope.policyInfo.selectedPolicy = currGenericPolicy;
											}
										});

									}
								}

								$scope.getUserTemplates = function() {
									$scope.loadingDataSources = true;
									customReportSvc.mask("queryView", true, "Loading templates...");
									reportService
											.getUserAssociatedLMTemplates()
											.then(function(data) {
												if (data && data.data) {
													$scope.userTemplates = data.data || [];
												} else {
													$scope.userTemplates = [];
												}
												customReportSvc.unMask("queryView", true);
											},
													function(error) {
														$scope.loadingDataSources = false;
													});
								};

								$scope.getUserPolicies = function() {
									$scope.loadingDataSources = true;
									customReportSvc.mask("queryView", true, "Loading policies...");
									reportService
											.getUserAssociatedLMPolicies()
											.then(function(data) {
												if (data && data.data && data.data.monitoringPolicies) {
													$scope.monitoringPolicies = data.data.monitoringPolicies || [];
													angular
															.forEach($scope.monitoringPolicies,
																	function(userPolicy) {
																		if ($scope.policyInfo.selectedPolicy &&
																				userPolicy.monitoringPolicyName === $scope.policyInfo.selectedPolicy.monitoringPolicyName) {
																			$scope.policyInfo.selectedPolicy = userPolicy;
																		}
																	});
												} else {
													$scope.monitoringPolicies = [];
												}

												$scope.updateParameterizedPolicies();
												$scope.userPolicyList = $scope.paramterizedPolicies.concat($scope.monitoringPolicies);
												customReportSvc.unMask("queryView", true);
											},
													function(error) {
														$scope.loadingDataSources = false;
													});
								};

								$scope.getUserSavedSearches = function() {
									$scope.loadingDataSources = true;
									customReportSvc.mask("queryView", true, "Loading searches...");
									reportService
											.getUserAssociatedLMSavedSearches()
											.then(function(data) {
												if (data && data.data && data.data.searchInfoList) {
													$scope.userSavedSearches = data.data.searchInfoList || [];

													if ($scope.mode === "Edit") {
														var searchInfo = $scope.dataSet.lmDataSet.searchInfo;
														if (searchInfo) {
															var savedSearchName = searchInfo.searchName;
															for (var index = 0; index < $scope.userSavedSearches.length; index++) {
																var curSearch = $scope.userSavedSearches[index];
																if (curSearch.searchName == savedSearchName) {
																	$scope.policyInfo.selectedSavedSearch.searchId = curSearch.searchId;
																	break;
																}
															}
														}
													}
												} else {
													$scope.userSavedSearches = [];
												}
												customReportSvc.unMask("queryView", true);
											},
													function(error) {
														$scope.loadingDataSources = false;
													});
								};

								// unregistered data source definition
								$scope.unregisteredDataSource = {
									"dataSource" : {
										"dataSourceId" : 0,
										"dataSourceName" : "Other HTTP",
										"GUID" : "76FBAA2A-586F-11E5-B529-1577C0F9A297"
									},
									"connectionType" : "HTTP",
									"endpoint" : "HTTP",
								};
								$scope.unregisteredDataSourceSelected = false;

								if ($scope.mode === "Edit") {
									if ($scope.dataSet) {
										if (typeof $scope.dataSet.endpoint !== "string") {
											$scope.dataSet.endpoint = "DATABASE";
										}

										$scope.endpointDataSet[$scope.dataSet.endpoint] = angular.copy($scope.dataSet);
										$scope.updateEndpoint($scope.dataSet.endpoint);

										if ($scope.endpoint === "HTTP" &&
												typeof $scope.dataSet.dataSources === "object" &&
												typeof $scope.dataSet.dataSources[0].dataSource === "object" &&
												$scope.dataSet.dataSources[0].dataSource.dataSourceName === "Other HTTP") {
											$scope.unregisteredDataSource = $scope.dataSet.dataSources[0];
											$scope.$parent.unregisteredDataSourceSelected = true;
										}

										if ($scope.endpoint === 'DATACUBE') {
											var dsId = $scope.dataSet.dCubeDataSet.dsId;
											var handlerId = $.isEmptyObject($scope.dataSet.dCubeDataSet.dsHandler) ? 0
													: $scope.dataSet.dCubeDataSet.dsHandler.handlerId;
											$scope.updateDCubeDataSets().then(function() {
												//No action right now
											});
										}

										if ($scope.endpoint === "MONITORING_POLICY") {
											$scope.dataSet.selectedLMSourceType = {};
											$scope.dataSet.selectedLMSourceType.type = $scope.dataSet.lmDataSet.dataSetType ? $scope.dataSet.lmDataSet.dataSetType
													: "POLICY";

											if ($scope.dataSet.selectedLMSourceType.type === "POLICY") {
												$scope.dataSet.selectedLMSourceType.dispName = "Policies";
												var activePolicy = $scope.dataSet.lmDataSet.monitoringPolicies[0];
												if (activePolicy) {
													$scope.policyInfo.selectedPolicy = {
														"monitoringPolicyid" : activePolicy.policyId,
														"monitoringPolicyName" : activePolicy.policyName
													};
													//$scope.policyInfo.policyMap[activePolicy.policyId] = $scope.dataSet.fields;
												}

												if($scope.dataSet.lmDataSet.monitoringTemplates && $scope.dataSet.lmDataSet.monitoringTemplates.length>0){
													var selectedTemplates = $scope.dataSet.lmDataSet.monitoringTemplates;
													$scope.policyInfo.selectedTemplates = [];
													for(var index=0;index<selectedTemplates.length;index++){
														$scope.policyInfo.selectedTemplates.push(selectedTemplates[index].templateName);
													}
												}

												if ($scope.dataSet.lmDataSet.adHocQueryInfo)
													$scope.policyInfo.selectedSearchQuery.adHocQueryInfo = $scope.dataSet.lmDataSet.adHocQueryInfo;
											} else if ($scope.dataSet.selectedLMSourceType.type === "SAVED_SEARCH") {
												$scope.dataSet.selectedLMSourceType.dispName = "Saved searches";
												var searchInfo = $scope.dataSet.lmDataSet.searchInfo;
												if (searchInfo) {
													$scope.policyInfo.selectedSavedSearch = {
														"searchId" : searchInfo.searchId,
														"searchName" : searchInfo.searchName
													};
												}
											}
										}

										if (!$scope.dataSet.fields) {
											$scope.dataSet.fields = [];
										}

										if (!$scope.dataSet.GetOperation.timeout) {
											$scope.dataSet.GetOperation.timeout = 5;
										}

										if ($scope.dataSet.queryPlan && !$scope.dataSet.queryPlan.retentionDays) {
											$scope.dataSet.queryPlan.retentionDays = 1;
										}
									}
								} else {
									$scope.updateEndpoint("DATABASE"); // set default endpoint
								}

								/** Currently selected tab; "query" or "fields" or "filters" or "parameters" */
								$scope.currentTab = "query";
								$scope.component = {
									type : "TABLE",
									pageOffSet : 0,
									pageSize : 5,
									dataSet : $scope.dataSet.dataSet,
									id : "PreviewTable",
									columns : [],
									allColumns : true,
									title : {
										text : ""
									}

								};

								// if metrics is installed is derived from the context scoped Java parameter,
								// this will be used to show or hide Advanced Section as it is specific to Offline data collection.
								$scope.enableOfflineMode = (isMetricsInstalled === "true");

								reportService.getSystemVariables().then(function(data) {
									$scope.systemVariables = data.data;
								});

								/**
								 * Select a certain tab
								 *
								 * @param tab
								 *            Newly selected tab descriptor
								 */
								$scope.setCurrentTab = function(tab) {
									$scope.currentTab = tab;
								}; // end method setTab

								/**
								 * Whether or not the given tab is selected
								 *
								 * @param tab
								 *            Tab to check
								 * @return Whether or not <code>tab</code> is selected
								 */
								$scope.isCurrentTab = function(tab) {
									return $scope.currentTab === tab;
								}; // end method isSelected

								// check if data set name is valid
								$scope.checkDataSetName = function() {
									var error = "";

									if (!isNaN($scope.dataSet.dataSet.dataSetName)) {
										error = "Data set name cannot be a number";
									}

									if ($scope.dataSet.dataSet.dataSetName.indexOf("%") > -1) {
										error = "Data set name cannot contain % symbol";
									}

									var dataSets = $scope.dataSets;
									if (dataSets !== undefined && dataSets.length > 0) {

										// check if a dataset with same name alrady exists in the report
										for (var i = 0; i < dataSets.length; ++i) {

											// skip check if dataset is same as one being edited
											if ($scope.mode === "Edit" && dataSets[i].selected) {
												continue;
											}

											if (dataSets[i].dataSet.dataSetName === $scope.dataSet.dataSet.dataSetName) {
												error = "Data set[" +
														customReportSvc.escapeHtml($scope.dataSet.dataSet.dataSetName) +
														"] already exists.";
												break;
											}
										}
									}
									return error;
								};

								$scope.validateFieldsInfo = function() {
									var fieldNames = [];
									var error = "";
									if (!$scope.dataSet.allColumns) {

										for (var i = 0; i < $scope.dataSet.fields.length; i++) {
											var field = $scope.dataSet.fields[i];
											if (field.name === "") {
												error = "A Field Name is required for each Field Source.";
											}
											if (fieldNames.indexOf(field.name) === -1) {
												fieldNames.push(field.name);
											} else {
												error = "Each Field Name must be unique in the Data Set.";
											}

											if (error !== "") {
												return error;
											}
										}
									}
								};

								$scope.validateTimeout = function() {
									var error = "";
									if (!$scope.dataSet.GetOperation.timeout) {
										error = "Invalid timeout value. You must enter a number from 1 to 100";
									}
									return error;
								}

								$scope.previewData = function(refresh) {
									var isError = false;
									if (!$scope.dataSet.dataSet.dataSetName) {
										customReportSvc.errorToast("Data Set Name is required.");
										isError = true;
									} else {
										var errorStr = $scope.checkDataSetName();
										if (errorStr) {
											customReportSvc.errorToast(errorStr, 30000);
											isError = true;
										}
									}

									if ($scope.dataSet.endpoint == "R") {
										/*if ($.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo)) {
											customReportSvc.errorToast("Please select data sets");
											isError = true;
										}*/

										if($.isEmptyObject($scope.dataSet.GetOperation.rDataSetQuery) || $scope.dataSet.GetOperation.rDataSetQuery.trim().length <= 0){
											customReportSvc.errorToast("Please input data set query");
											isError = true;
										}
									}

									if (($scope.dataSet.endpoint !== "SHARED" && $scope.dataSet.endpoint !== "DATACUBE" && $scope.dataSet.endpoint !== "MONITORING_POLICY" && $scope.dataSet.endpoint !== "R") &&
											($scope.dataSet.dataSources && $scope.dataSet.dataSources.length === 0)) {
										customReportSvc.errorToast("Please select data sources.");
										isError = true;
									}

									// validate all required fields for database endpoint
									if ($scope.dataSet.endpoint === "DATABASE") {
										if (!$scope.dataSet.databaseName || $scope.dataSet.databaseName === "") {
											customReportSvc.errorToast("Please select database.");
											isError = true;
										}

										if (!$scope.dataSet.GetOperation.sqlText ||
												$scope.dataSet.GetOperation.sqlText === "") {
											customReportSvc.errorToast("Please select table or view or enter query.");
											isError = true;
										}
									}
									// validate all required fields for http endpoint
									else if ($scope.dataSet.endpoint === "HTTP") {

										if (($scope.unregisteredDataSourceSelected && !$scope.unregisteredDataSource.connectionURL) ||
												(!$scope.unregisteredDataSourceSelected && !$scope.dataSet.GetOperation.restApi)) {
											customReportSvc.errorToast("Please input the URL of REST API.");
											isError = true;
										}
									}

									if ($scope.dataSet.endpoint === 'MONITORING_POLICY') {
										var errorResp = $scope.validateLMEndpointParamsSpecified();

										if (errorResp["isError"]) {
											isError = true;
											customReportSvc.errorToast(errorResp["errorMsg"]);
										}
									}

									if (isError) {
										return;
									}

									if ($scope.dataSet.endpoint === 'DATACUBE') {
										$scope.getFieldsInformationForDataCube(false, true);
									} else {
										$scope.performPrePreviewSteps(refresh);
										if ($scope.dataSet.endpoint === 'MONITORING_POLICY') {
											$scope.dataSet.fields = [];
											$scope.updateValuesInLMDataSet();
										}

										$scope.getFieldsInformation();
										$scope.isQueryModified();
										if($scope.previewScope){
											$scope.previewScope.reloadComponent();
										}
									}
								};

								$scope.performPrePreviewSteps = function(refresh) {
									$scope.showPreviewTable = true;
									$scope.rawDataLoading = true;
									$scope.rawData = [];
									if (refresh) {
										$scope.clearAndResetCacheId();
									}

									if (!$scope.previewScope) {
										$scope.previewScope = angular.element("#" + $scope.component.id).scope();
									}

									$scope.component.columns = [];
								};

								$scope.onPolicyFieldSuccessForPreviewData = function(refresh) {
									$scope.performPrePreviewSteps(refresh);
									$scope.updateValuesInLMDataSet();
									$scope.previewScope.reloadComponent();
								}

								$scope.onPolicyFieldErrorForPreviewData = function() {
									$scope.updateValuesInLMDataSet();
									$scope.previewScope.reloadComponent();
								}

								$scope.addSystemTagForMonitoringEndpoint = function(selectedLMSourceType, policyInfo) {
									var systemTag = "LM_REPORT";

									if (selectedLMSourceType === "POLICY") {
										var mpTypes = policyInfo.selectedPolicy.monitoringTypes;

										if (mpTypes.length >= 1) {
											if (mpTypes[0] === "SYSTEM_MONITORING") {
												systemTag = "SM_REPORT";
											}
										}
									} else if (selectedLMSourceType === "SAVED_SEARCH") {
										if (policyInfo.selectedSavedSearch &&
												policyInfo.selectedSavedSearch.appType === "SYSTEM_MONITORING") {
											systemTag = "SM_REPORT";
										}
									}
									/*
									 * else if(selectedLMSourceType === "QUERY") { systemTag = adHocQueryTag; }
									 */

									$scope.addSystemTag(systemTag);
								};

								$scope.validateLMEndpointParamsSpecified = function() {
									var resp = {};
									var isError = false;
									var errorMsg = "";

									if (!$scope.dataSet.selectedLMSourceType) {
										errorMsg = "Please select source type.";
										isError = true;
									} else if ($scope.dataSet.selectedLMSourceType.type === "POLICY" &&
											(!$scope.policyInfo.selectedPolicy || $
													.isEmptyObject($scope.policyInfo.selectedPolicy))) {
										errorMsg = "Please select monitoring policy.";
										isError = true;
									} else if ($scope.dataSet.selectedLMSourceType.type === "SAVED_SEARCH" &&
											(!$scope.policyInfo.selectedSavedSearch || $
													.isEmptyObject($scope.policyInfo.selectedSavedSearch))) {
										errorMsg = "Please select saved search.";
										isError = true;
									}
									resp["isError"] = isError;
									resp["errorMsg"] = errorMsg;
									return resp;
								};

								$scope.updateValuesInLMDataSet = function() {
									$scope.dataSet.lmDataSet = {};
									$scope.dataSet.lmDataSet.dataSetType = $scope.dataSet.selectedLMSourceType.type;
									if ($scope.dataSet.selectedLMSourceType.type === "POLICY") {
										$scope.dataSet.lmDataSet.monitoringPolicies = [];
										$scope.dataSet.lmDataSet.monitoringPolicies.push({
											"policyId" : $scope.policyInfo.selectedPolicy.monitoringPolicyid,
											"policyName" : $scope.policyInfo.selectedPolicy.monitoringPolicyName
										});

										if($scope.policyInfo.selectedPolicy && $scope.policyInfo.selectedPolicy.monitoringTypes && $scope.policyInfo.selectedPolicy.monitoringTypes[0] == 'GLOBAL_MONITORING')
										{
										if($scope.policyInfo.selectedTemplates && $scope.policyInfo.selectedTemplates.length > 0){
											$scope.dataSet.lmDataSet.monitoringTemplates = [];
											var selectedTemplates = $scope.policyInfo.selectedTemplates;
											for(var index=0;index < selectedTemplates.length ; index++){
												$scope.dataSet.lmDataSet.monitoringTemplates.push({
														templateName : selectedTemplates[index]
												});
											}
										}
										}
										$scope.dataSet.lmDataSet.adHocQueryInfo = $scope.policyInfo.selectedSearchQuery.adHocQueryInfo;
									} else if ($scope.dataSet.selectedLMSourceType.type === "SAVED_SEARCH") {
										var searchInfo = {
											"searchId" : $scope.policyInfo.selectedSavedSearch.searchId,
											"searchName" : $scope.policyInfo.selectedSavedSearch.searchName,
											"dataSetInfo" : $scope.policyInfo.selectedSavedSearch.dataSetInfo
										};
										$scope.dataSet.lmDataSet.searchInfo = searchInfo;
										//$scope.dataSet.lmDataSet.dataSetInfo = $scope.policyInfo.selectedSavedSearch.dataSetInfo;
									} else {
										$scope.dataSet.lmDataSet.adHocQueryUrl = $scope.policyInfo.selectedSearchQuery.searchParams;
										$scope.dataSet.lmDataSet.adHocQueryInfo = $scope.policyInfo.selectedSearchQuery.adHocQueryInfo;
									}
									$scope.addSystemTagForMonitoringEndpoint($scope.dataSet.selectedLMSourceType.type,
											$scope.policyInfo);
								}

								$scope.processRowExpression = function(rowExpression) {
									if (!$scope.dataSet.GetOperation.rowExpression &&
											typeof rowExpression === "string" && $scope.dataSet.endpoint === "HTTP") {
										$scope.dataSet.GetOperation.rowExpression = rowExpression;
									}
								}
								$scope.rawData = [];
								$scope.processRawData = function(rawData) {
									$scope.rawData = [];
									var dataSource;
									for (dataSource in rawData) {
										if (rawData.hasOwnProperty(dataSource)) {
											$scope.rawData.push({
												dataSource : dataSource,
												data : rawData[dataSource]
											});
										}
									}
									$scope.rawDataLoading = false;

								}

								$scope.getFieldsInformation = function(close) {
									$scope.getFieldsForDataSet($scope.dataSet).then(function(data) {
										customReportSvc.unMask("addDataSetModal", true);
										var response = data.data;
										$scope.processFields(response.columns)
										if ($scope.dataSet.endpoint === "HTTP") {
											if (typeof response.rowExpression === "string") {
												$scope.processRowExpression(response.rowExpression)
											}
										}

										if (close) {
											$scope.closeWindow = true;
											$scope.closeDataSet($scope.dataSet);
										}
									}, function(error) {
										// Update loading status
										customReportSvc.unMask("addDataSetModal", true);
										customReportSvc.errorToast(error.data.errorMessage);
										if (close) {
											$scope.closeWindow = true;
											$scope.closeDataSet($scope.dataSet);
										}
										return;
									});
								}

								$scope.getFieldsInformationForDataCube = function(close, refresh) {
									customReportSvc.mask("addDataSetModal", true, "Retrieving fields information...");
									reportService.getFieldsForDCubeDataSet($scope.dataSet.dCubeDataSet).then(function(
											data) {
										customReportSvc.unMask("addDataSetModal", true);
										$scope.performPrePreviewSteps(refresh);
										$scope.dataSet.fields = customReportSvc
												.getFieldsForCustomReport((data.data.schemaFields || []));
										$dataSource.getDataSource($scope.dataSet.endpoint).init($scope.dataSet);
										if (close) {
											$scope.closeWindow = true;
											$scope.closeDataSet($scope.dataSet);
										} else {
											//preview
											if ($scope.previewScope) {
												$scope.previewScope.reloadComponent();
											}
										}
									},
											function(error) {
												customReportSvc.unMask("addDataSetModal", true);
												customReportSvc.errorToast(error.data);
												return;
											});
									// adding more components
									$scope.addMoreComponents();
								}

								$scope.processFields = function(columns) {
									$scope.oldFields = $scope.dataSet && $scope.dataSet.fields || [];

									if ($.isEmptyObject(columns) == false && columns.length > 0) {
										var newFields = [];
										for (var k = 0; k < columns.length; k++) {
											let dataField = columns[k].dataField;
											let name = columns[k].name;
											//metrics columns have formatter defined in angular brackets. Removing the angular brackets  in  name field to by pass the sanitization filter when you for specific fields
											if(dataField && dataField.indexOf("<") !== -1 && dataField.indexOf(">") !== -1){
												name = dataField.substring(0,dataField.indexOf("<"));
											}

											let field = {
													name : name,
													dataField : typeof dataField !== "undefined" ? dataField : columns[k].name,
													type : columns[k].type
											};

											newFields.push(field);
										}

										if ($scope.oldFields && $scope.oldFields.length > 0) {
											for (var i = 0; i < $scope.oldFields.length; i++) {
												var oldField = $scope.oldFields[i];
												var oldFieldFound = false;
												for (var j = 0; j < newFields.length; j++) {
													var newField = newFields[j];
													if (oldField.name.toLowerCase() === 'sys_rowid' &&
															oldField.name === newField.name) {
														oldField.type = newField.type;
														oldFieldFound = true;
														break;
													}

													if (oldField.dataField === '' ||
															oldField.dataField === newField.dataField) {
														oldField.type = newField.type;
														oldFieldFound = true;
														break;
													}
												}

												if (!oldFieldFound) {
													$scope.oldFields.splice(i, 1);
													i--;
												}
											}

											var currFields = [];
											// check if there fields from the old query are changed , then remove the fields from the fields definition.
											for (var i = 0; i < newFields.length; i++) {
												var newField = newFields[i];
												var oldFieldFound = false;
												var currIndex = 0;
												for (var j = 0; j < $scope.oldFields.length; j++) {
													var oldField = $scope.oldFields[j];

													if (oldField.name.toLowerCase() === 'sys_rowid' &&
															oldField.name === newField.name) {
														oldField.type = newField.type;
														oldFieldFound = true;
														break;
													}

													if (newField.dataField === oldField.dataField) {
														oldField.type = newField.type;
														oldFieldFound = true;
														currIndex = j;
														break;
													}
												}

												if (!oldFieldFound) {
													currFields.push(newField);
												}
											}

											$scope.oldFields = $scope.oldFields.concat(currFields);
										} else {
											$scope.oldFields = newFields;
										}
										$scope.dataSet.fields = $scope.oldFields;
										customReportSvc.unMask("fieldsView", true);
									} else {
										customReportSvc.unMask("fieldsView", true);
									}
									//customReportSvc.triggerCallback("activeDataSetsCallbacks", $scope.dataSet);

								};
								$scope.rowExpressionChanged = function() {
									if ($scope.dataSet.GetOperation.originalRowExpression !== $scope.dataSet.GetOperation.rowExpression) {
										$scope.clearAndResetCacheId();
										$scope.dataSet.fields = [];
										$scope.dataSet.GetOperation.originalRowExpression = $scope.dataSet.GetOperation.rowExpression
									}
								}

								$scope.isQueryModified = function() {
									if ($scope.dataSet.originalQuery !== $scope.dataSet.GetOperation.sqlText) {
										$scope.clearAndResetCacheId();
										$scope.dataSet.fields = [];
										$scope.dataSet.originalQuery = $scope.dataSet.GetOperation.sqlText;
									}
								};

								$scope.saveAndDeploy = function(){
									$scope.dsScope.autoDeploy = true; // this will be used in shared dataset  scope for auto deployment.
									$scope.addDataSet();
								}

								$scope.addDataSet = function() {
									if (!$scope.dataSet.dataSet.dataSetName) {
										customReportSvc.errorToast("Data Set Name is required.");
										return;
									} else {
										var errorStr = $scope.checkDataSetName();
										if (errorStr) {
											customReportSvc.errorToast(errorStr, 30000);
											return;
										}
									}
				                    //TODO: rdataset and plot need to change
				                    if ($scope.dataSet.endpoint == "PYTHON3") {
				                        if ($.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo)) {
				                            customReportSvc.errorToast("Please select data sets");
				                            isError = true;
				                        }
									}

									if ($scope.dataSet.endpoint == "R") {
										/*if ($.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo)) {
											customReportSvc.errorToast("Please select data sets");
											isError = true;
										}*/

										var isDataSetQuerySet = false, isPlotQuerySet = false;
										if($.isEmptyObject($scope.dataSet.GetOperation.rDataSetQuery) == false && $scope.dataSet.GetOperation.rDataSetQuery.trim().length > 0){
											isDataSetQuerySet = true;
										}

										if($.isEmptyObject($scope.dataSet.GetOperation.rPlotQuery) == false && $scope.dataSet.GetOperation.rPlotQuery.trim().length > 0){
											isPlotQuerySet = true;
										}

										if (isDataSetQuerySet == false && isPlotQuerySet == false) {
											customReportSvc.errorToast("Please input data set query (or) plot query");
											return;
										}
									}

									errorStr = $scope.validateFieldsInfo();
									if (errorStr) {
										customReportSvc.errorToast(errorStr, 30000);
										return;
									}

									errorStr = $scope.validateTimeout();
									if (errorStr) {
										customReportSvc.errorToast(errorStr, 30000);
										return;
									}
									if ($scope.dataSet.endpoint === 'DATACUBE') {
										if (!$scope.dataSet.dCubeDataSet.dsHandler ||
												!$scope.dataSet.dCubeDataSet.dsHandler.handlerId ||
												$scope.dataSet.dCubeDataSet.dsHandler.handlerId == 0) {
											customReportSvc.errorToast("Handler is required.");
											return;
										}
										$scope.dataSet.fields = [];
									} else if ($scope.dataSet.endpoint === 'MONITORING_POLICY') {

										var errorResp = $scope.validateLMEndpointParamsSpecified();

										if (errorResp["isError"]) {
											customReportSvc.errorToast(errorResp["errorMsg"]);
											return;
										}
										$scope.onPolicySuccess();
										//$scope.dataSet.fields = [];
									}

									if ($scope.dataSet.endpoint === 'DATABASE' && $scope.dataSet.queryPlan) {

										if ($scope.dataSet.queryPlan.direct && $scope.dataSet.queryPlan.frequency < 1) {
											customReportSvc
													.errorToast("Collection frequency cannot be less than a minute.");
											return;
										}

										if (!$scope.dataSet.queryPlan.direct && $scope.dataSet.queryPlan.frequency < 15) {
											customReportSvc
													.errorToast("Collection frequency cannot be less than 15 minutes.");
											return;
										}

									}

									if ($scope.dataSet.fields.length === 0 || $scope.dataSet.endpoint === "R" || $scope.dataSet.endpoint === "PYTHON3") {
										if ($scope.dataSet.endpoint === 'DATACUBE') {
											$scope.getFieldsInformationForDataCube(true);
										}/*
											 * else if ($scope.dataSet.endpoint === 'MONITORING_POLICY') {
											 * $scope.processPolicyFieldRequest($scope.onPolicySuccess); }
											 */else if ($scope.dataSet.endpoint !== "DATABASE" ||
												$scope.dataSet.GetOperation.sqlText) {
											// fields are not present for the query. Do an auto preview
											$scope.getFieldsInformation(true)
										}
									} else {
										$scope.closeDataSet($scope.dataSet);
									}

								};

								$scope.onPolicySuccess = function() {
									$scope.updateValuesInLMDataSet();
									$scope.dataSet.selectedLMSourceType = {};
								}

								$scope.fetchFieldsForSelectedSavedSearch = function(successCallBack, refresh) {
									var searchId = $scope.policyInfo.selectedSavedSearch.searchId;

									if (!searchId) {
										customReportSvc.errorToast("Please select search.");
										return;
									}

									customReportSvc.mask("addDataSetModal", true, "Retrieving fields information...");

									reportService.getFieldsForLMSavedSearch(searchId).then(function(data) {
										customReportSvc.unMask("addDataSetModal", true);
										$scope.dataSet.fields = customReportSvc
												.prepareLMFieldsForReport((data.data.displayNames || []));
										successCallBack(refresh);
									})

								}

								$scope.fetchFieldsForSelectedPolicy = function(successCallBack, refresh) {
									var policyId = $scope.policyInfo.selectedPolicy.monitoringPolicyid;

									if (!policyId) {
										customReportSvc.errorToast("Please select policy.");
										return;
									}

									var fieldInfo = $scope.policyInfo.policyMap[policyId];
									if (fieldInfo) {
										$scope.dataSet.fields = $scope.policyInfo.policyMap[policyId];
										successCallBack(refresh);
									} else {
										customReportSvc.mask("addDataSetModal",
												true,
												"Retrieving fields information...");
										reportService.getFieldsForLMDataSet(policyId).then(function(data) {
											customReportSvc.unMask("addDataSetModal", true);
											$scope.dataSet.fields = customReportSvc
													.prepareLMFieldsForReport((data.data.displayNames || []));
											$scope.policyInfo.policyMap[policyId] = $scope.dataSet.fields;
											successCallBack(refresh);
										},
												function(error) {
													customReportSvc.errorToast(error.data);
													return;
												});
									}
								}

								$scope.processPolicyFieldRequest = function(successCallBack, refresh) {

									if (!$scope.dataSet.selectedLMSourceType) {
										customReportSvc.errorToast("Please select source type.");
										return;
									}

									if ($scope.dataSet.selectedLMSourceType.type === "POLICY") {
										$scope.fetchFieldsForSelectedPolicy(successCallBack, refresh);
									} else if ($scope.dataSet.selectedLMSourceType.type === "SAVED_SEARCH") {
										$scope.fetchFieldsForSelectedSavedSearch(successCallBack, refresh);
									}
								}

								$scope.dismissDataSet = function() {
									$scope.clearAndResetCacheId();
									$scope.reportMode = "builder";
									$scope.$dismiss('cancel');
								}

								$scope.closeDataSet = function(dataSet) {
									if (dataSet) {
										dataSet.previewRowSize = undefined; // resetting the preview row size.
									}
									$scope.clearAndResetCacheId();// clear and rest the cache id.
									$scope.reportMode = "builder";
									$scope.$close(dataSet);
								};

							} ]); // end controller addDataSetModalCtrl

	// Controller for query view of "Add Data Set" modal
	app.controller("queryViewCtrl", [
			"$scope",
			"$uibModal",
			"reportService",
			"customReportSvc",
			function($scope, $modal, reportService, customReportSvc) {

				$scope.isQuerychanged = function(data) {
					$scope.selectedTableOrView = data;
					$scope.dataSet.fields = [];
				};

				$scope.changeDatabase = function(db) {
					$scope.dataSet.databaseName = db;
					$scope.tablesAndViewsLoaded = false;
					$scope.tablesAndViews.tables = [];
					$scope.tablesAndViews.views = [];
				}

				/** List of data source nodes */
				$scope.dataSourceNodes = {
					DATABASE : [],
					HTTP : [],
					DATACUBE : []
				};

				/** List of selected data source nodes */
				$scope.selectedDataSourceNodes = {
					DATABASE : [],
					HTTP : [],
					DATACUBE : []
				}; // used when editing;

				/** Flag indicating if the list of databases is being loaded */
				$scope.loadingDataSources = false;

				// when the selected data sources changes, update databases, and tables-and-views list
				// use the input endpoint parameter instead of $scope.endpoint since controller logic
				// can change the selection for an endpoint that is not yet set
				$scope.dataSourceChanged = function(selections, endpoint) {
					if ($scope.loadingDataSources) {
						return;
					}

					handleUnregisteredDataSourceSelection(selections, endpoint);

					$scope.endpointDataSet[endpoint].dataSources = $scope.getSelectedDataSources(selections);

					if (endpoint === "DATABASE") {

						$scope.dbsLoadedForCurrentDSSelection = false;
					}
				};

				var handleUnregisteredDataSourceSelection = function(selections, endpoint) {
					if (endpoint === "HTTP") {
						if (typeof selections !== "object") {
							$scope.$parent.unregisteredDataSourceSelected = false;
						} else if (!$scope.$parent.unregisteredDataSourceSelected) {
							// if one of the data source selected is 'unregistered', remove all other datasources from selection
							if (typeof selections === "object") {
								for (var i = 0; i < selections.length; i++) {
									if (typeof selections[i].rawData === "object" &&
											selections[i].rawData.dataSource.dataSourceName === "Other HTTP") {
										$scope.$parent.unregisteredDataSourceSelected = true;
										break;
									}
								}

								if ($scope.$parent.unregisteredDataSourceSelected) {
									// clear selection from the tree node
									for (var j = 0; j < selections.length; j++) {
										if (j !== i) {
											deselectDataSourceNode(selections[j]);
										}
									}

									// remove elements from left and right of 'unregistered' node
									// we will loose binding if we initalize "selections" with a fresh array
									selections.splice(0, i);
									selections.splice(1, selections.length - 1)
								}
							}
						} else { // $scope.$parent.unregisteredDataSourceSelected is true
							// remove unregistered data source when selection changes
							for (var i = 0; i < selections.length; i++) {
								if (typeof selections[i].rawData === "object" &&
										selections[i].rawData.dataSource.dataSourceName === "Other HTTP") {
									deselectDataSourceNode(selections[i]);
									selections.splice(i, 1);
									$scope.$parent.unregisteredDataSourceSelected = false;
									break;
								}
							}
						}
					}
				}

				var deselectDataSourceNode = function(dsNode) {
					dsNode._hsmeta.selected = false;
					if (typeof dsNode.children === "object") {
						for (var i = 0; i < dsNode.children.length; i++) {
							deselectDataSourceNode(dsNode.children[i]);
						}
					}
				}

				/**
				 * Flag indicating if the list of databases is already loaded for the current selection of the
				 * data sources and dbs.
				 */
				$scope.dbsLoadedForCurrentDSSelection = false;
				$scope.updateDataBasesOnclick = function() {
					if (!$scope.dbsLoadedForCurrentDSSelection) {
						$scope.updateDatabases();
					}
				}

				/**
				 * Flag indicating if the list of databases is already loaded for the current selection of the
				 * data sources and database.
				 */
				$scope.tablesAndViewsLoaded = false;
				$scope.updateTablesAndViewOnclick = function(event) {
					if (!$scope.tablesAndViewsLoaded) {
						if ($scope.databases.length > 0) {
							$scope.updateTablesAndViews();
						}
					}
				}

				$scope.updateTableAndViewsFlag = function() {
					$scope.tablesAndViewsLoaded = false;
				}

				/** List of database objects */
				$scope.databases = [];

				if ($scope.dataSet.databaseName) {
					$scope.databases.push($scope.dataSet.databaseName);
				}

				/** Flag indicating if the list of databases is being loaded */
				$scope.loadingDatabases = false;
				/** List of table and view objects */
				$scope.tablesAndViews = {
					"tables" : [],
					"views" : []
				};
				/** Flag indicating if the list of tables and views is being loaded */
				$scope.loadingTablesAndViews = false;
				/** Whether to show tables or views */
				$scope.tablesOrViews = "tables";
				/** Currently selected database */
				$scope.selectedTableOrView = null;

				$scope.getPrevRdataSet = function(dataSetGuiId) {
					if($.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo) == true || $.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo.rDataSets))
						return undefined;

					var curDataSet;
					for (var i = 0; i < $scope.dataSet.GetOperation.rDataSetListInfo.rDataSets.length; i++) {
						curDataSet = $scope.dataSet.GetOperation.rDataSetListInfo.rDataSets[i];
						if (curDataSet.dataSet.dataSetGuid == dataSetGuiId) {
							return curDataSet;
						}
					}//for;

					return undefined;
				}//func

				$scope.isColumnIncluded = function(fields, field) {

					if ($.isEmptyObject(fields) == true || fields.length <= 0)
						return true;

					for (var i = 0; i < fields.length; i++) {
						if (fields[i].name == field.name)
							return true;
					}

					return false;
				}

				$scope.rDataSets;

				$scope.updateSourceDataSetTab = function() {
					var rDataSet;
					$scope.rDataSets = "";
					for (var i = 0; i < $scope.dataSet.GetOperation.rDataSetListInfo.rDataSets.length; i++) {

						rDataSet = $scope.dataSet.GetOperation.rDataSetListInfo.rDataSets[i];

						if (i != 0) {
							$scope.rDataSets += ",";
						}

						$scope.rDataSets += rDataSet.dataSet.dataSetName;

						if (rDataSet.includeAllColumns == false) {
							$scope.rDataSets += "(";
							$scope.rDataSets += rDataSet.fields.length;
							$scope.rDataSets += ")";
						}

					}
				}

				$scope.initRDataSets = function() {

					if($.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo) || $.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo.rDataSets) || $scope.dataSet.GetOperation.rDataSetListInfo.rDataSets.length<=0){
						$scope.rDataSets = "Click to associate Data Sets";
						return;
					}

					$scope.updateSourceDataSetTab();
				}

				$scope.showDataSet = function() {
					var modalInstance = $modal.open({
						templateUrl : customReports.contextPath + "/reportsplus/addDataSetModal/rDataSet.jsp",
						size : "lg",
						controller : 'rDataSetCtrl',
						backdrop : 'static',
						scope : $scope
					});

					modalInstance.result.then(function(operation) {
						//$scope.rDataSets = selectedItem;
						$scope.updateSourceDataSetTab();
					}, function() {
						//$scope.rDataSets = "";
					});
				}

				/**
				 * Update the list of data sources
				 */
				$scope.updateDataSources = function() {

					// Update loading status
					$scope.loadingDataSources = true;

					// Request the list of data sources
					reportService.fetchDataSources().then(function(dataSources) {
						// Store data sources in scope
						$scope.dataSourceNodes = $scope.getTreeFormat(dataSources.data.dataSource);
						// Update loading status
						$scope.loadingDataSources = false;
					}, function(error) {
						// Update loading status
						$scope.loadingDataSources = false;
					});
				}; // end method updateDataSources

				/**
				 * Update the list of databases
				 */
				$scope.updateDatabases = function() {
					var dataSet = $scope.endpointDataSet["DATABASE"];

					$scope.databases = [];
					$scope.tablesAndViews.tables = [];
					$scope.tablesAndViews.views = [];

					// Make sure at least one data source is selected before attempting request
					if (typeof dataSet.dataSources === "object" && dataSet.dataSources.length > 0) {

						// Update loading status
						$scope.loadingDatabases = true;

						/*
						 * if($scope.dataSet.databaseName) $scope.databases.push($scope.dataSet.databaseName);
						 */
						customReportSvc.mask("queryView", true, "Loading Databases...");
						// Request the list of databases from the data sources
						reportService.fetchDatabases(dataSet.dataSources).then(function(databases) {
							// Store databases in scope
							$scope.databases = databases.data.values;
							customReportSvc.unMask("queryView", true);
							// Update loading status
							$scope.loadingDatabases = false;

							//set this to load when the call returns success. So that it will not be retried for the same selection of the data sources.
							$scope.dbsLoadedForCurrentDSSelection = true;

							//when the database list is changed set the tablesAndViews flag to false. So that on click of tables and views we can reload the tables and views for the current selection of the datasources and databases.
							$scope.tablesAndViewsLoaded = false;
						}, function(error) {
							// Leave empty list of databases in scope
							customReportSvc.unMask("queryView", true);
							// Update loading status
							$scope.loadingDatabases = false;
						});
					}
				}; // end method updateDatabases

				$scope.getTreeNode = function(rootNode, ds) {

					if (ds.connectionType === "HTTP" && ds.dataSource.dataSourceName === "Other HTTP") {
						return rootNode.UNREGISTERED;
					}

					var parentNode = rootNode[ds.connectionType];

					if (parentNode) {
						// Return parent node itself for below special cases
						if (ds.connectionType === "COMMCELL" && ds.commCell.commCellName === "$ALL$") {
							return parentNode;
						} else if (ds.connectionType !== "COMMCELL" && ds.dataSource.dataSourceName === "$ALL$") {
							return parentNode;
						} else if (ds.connectionType === "METRICS") {
							return parentNode;
						}

						if (parentNode.children) {
							if (ds.commCell && ds.commCell.commCellName === "$LocalCommCell$") {
								for (var i = 0; i < parentNode.children.length; i++) {
									var child = parentNode.children[i];
									if (child.rawData.masterCommCell) {
										return child;
									}
								}
							} else {
								for (var i = 0; i < parentNode.children.length; i++) {
									var child = parentNode.children[i];
									if (child.rawData.dataSource.dataSourceName === ds.dataSource.dataSourceName) {
										return child;
									}
								}
							}
						}
					}

					return null;
				};

				$scope.getTreeFormat = function(dataSources) {

					// root level node
					var rootNode = {
						"DATABASE" : {},
						"HTTP" : {},
						"DATACUBE" : {},
						"MONITORING_POLICY" : {},
						"DATASET" : {},
						"SCRIPT" : {},
						"SHARED" : {},
						"R" : {},
						"PYTHON3": {}
					};
					var parent;
					// first level nodes (one node per connection type)
					var connectionNodes = {
						"COMMCELL" : {
							id : 1,
							name : "CommCells",
							children : []
						},
						"METRICS" : {
							id : 2,
							name : "Metrics",
							children : []
						},
						"SQLSERVER" : {
							id : 4,
							name : "SQL Server",
							children : []
						},
						"ORACLE" : {
							id : 5,
							name : "Oracle",
							children : []
						},
						"MYSQL" : {
							id : 6,
							name : "MySQL",
							children : []
						},
						"HTTP" : {
							id : 9,
							name : "HTTP",
							children : []
						},
						"GENERIC" : {
							id : 12,
							name : "GENERIC",
							children : []
						}
					};

					if (dataSources === null || dataSources === []) {
						return rootNode;
					}

					// insert nodes corresponding to fetched data sources under first level nodes
					angular.forEach(dataSources,
							function(ds) {

								// guess and add endpoint to data source if it is not present
								if (typeof ds.endpoint !== "string") {
									ds.endpoint = (ds.connectionType === "METRICS" ? "DATABASE" : ds.connectionType);
									if (!rootNode[ds.connectionType] && ds.connectionType !== "METRICS") {
										rootNode[ds.connectionType] = {};
									}
									if (!connectionNodes[ds.connectionType]) {
										var lastId = connectionNodes[Object.keys(connectionNodes)[Object
												.keys(connectionNodes).length - 1]].id;
										connectionNodes[ds.connectionType] = {
											id : ++lastId,
											name : ds.connectionType,
											children : []
										};
									}
								}

								if (typeof rootNode[ds.endpoint][ds.connectionType] !== "object") {
									rootNode[ds.endpoint][ds.connectionType] = angular
											.copy(connectionNodes[ds.connectionType]);

									// set additional properties required to construct data source object from selection
									rootNode[ds.endpoint][ds.connectionType].type = ds.connectionType;
									rootNode[ds.endpoint][ds.connectionType].endpoint = ds.endpoint;
								}

								parent = rootNode[ds.endpoint][ds.connectionType];

								// construct tree node for data source
								var node = {
									id : 0,
									name : (ds.masterCommCell ? "Local (" + ds.dataSource.dataSourceName + ")"
											: ds.dataSource.dataSourceName),
									parent : parent,
									rawData : ds
								};

								// if data source is master commcell, move it ahead of all its sibling data sources
								if (ds.masterCommCell) {
									parent.children.splice(0, 0, node);
								} else {
									parent.children.push(node);
								}
							});

					// add a node to specify unregistered data source
					rootNode.HTTP.UNREGISTERED = {
						id : 0,
						name : "Other HTTP",
						rawData : $scope.unregisteredDataSource
					};

					// before returning the root node, update selected-nodes from selected-datasources for both endpoints
					for ( var endpoint in $scope.endpointDataSet) {
						var selection = [];
						angular.forEach($scope.endpointDataSet[endpoint].dataSources, function(ds) {
							var node = $scope.getTreeNode(rootNode[endpoint], ds);
							if (node) {
								selection.push(node);
							} else if (ds.dataSource) {
								// assuming that the datasource selected before for this report does not exist any more on this set up,
								// we have to provide a way to delete the datasource. so adding a dummy node, so that user can delete it.
								node = {
									id : 0,
									name : ds.dataSource.dataSourceName,
									rawData : ds
								};
								selection.push(node);
							}
						});

						// add local commcell node if no node is selected
						if (selection.length === 0) {
							var node = $scope.getTreeNode(rootNode[endpoint], {
								connectionType : "COMMCELL",
								commCell : {
									commCellName : "$LocalCommCell$"
								}
							});

							if (node) {
								selection.push(node);
							}
						}

						$scope.selectedDataSourceNodes[endpoint] = selection;
					}

					return rootNode;
				};

				$scope.getSelectedDataSources = function(selection) {
					var sources = [];
					angular.forEach(selection, function(item) {

						// id is zero for individual data source,
						// non-zero if all data sources under connection-type are selected
						if (item.id === 0) {
							if (item.rawData.masterCommCell) {
								item.rawData.commCell.commCellName = "$LocalCommCell$";
								var endPoint = item.rawData.endpoint;
								// For local CommCell DB data source, remove CommCell specific information to enable
								// reusability of report across different CommCell environments.
								if (endPoint !== "MONITORING_POLICY" || endPoint !== "DATACUBE") {
									item.rawData = {
										connectionType : "COMMCELL",
										commCell : {
											commCellName : "$LocalCommCell$"
										}
									};

									if (endPoint === "HTTP") {
										item.rawData.endpoint = "HTTP";
									}
								}
							}

							sources.push(item.rawData);
						} else {
							var all = {
								connectionType : item.type,
								endpoint : item.endpoint,
								commCell : (item.type === "COMMCELL" ? {
									commCellName : "$ALL$"
								} : undefined),
								dataSource : (item.type !== "COMMCELL" ? {
									dataSourceName : "$ALL$"
								} : undefined)
							};
							sources.push(all);
						}
					});

					return sources;
				};

				/**
				 * Update the list of tables and views
				 */
				$scope.updateTablesAndViews = function() {
					var dataSet = $scope.endpointDataSet["DATABASE"];
					$scope.tablesAndViews.tables = [];
					$scope.tablesAndViews.views = [];

					// Make sure a database is selected before attempting request
					if (typeof dataSet.dataSources === "object" && dataSet.dataSources.length > 0) {
						// Update loading status
						$scope.loadingTablesAndViews = true;
						if ($scope.dataSet.databaseName) {
							if ($scope.dataSet.databaseName.toLowerCase() == "commserv") {
								$scope.$parent.$parent.enableOfflineMode = true;
							} else {
								$scope.$parent.$parent.enableOfflineMode = false;
							}
						}

						var ds = dataSet.dataSources[0];
						if (dataSet.databaseName) {
							customReportSvc.mask("queryView", true, "Loading Tables & views...");
							// Request the list of tables and views from the databases
							reportService.fetchTablesAndViews(dataSet.dataSources, dataSet.databaseName).then(function(
									tablesAndViews) {
								// Store tables and views in scope
								$scope.tablesAndViews = tablesAndViews.data;

								// set this flag to true so that we dont retry to load the tables and views on the click for changing the tables and views.
								$scope.tablesAndViewsLoaded = true;
								customReportSvc.unMask("queryView", true);
								// Update loading status
								$scope.loadingTablesAndViews = false;
							},
									function() {
										// Leave empty list of tables and views in scope
										customReportSvc.unMask("queryView", true);
										// Update loading status
										$scope.loadingTablesAndViews = false;
									});
						}
					}
				}; // end method updateTablesAndViews

				$scope.$watch("selectedTableOrView", function() {
					if ($scope.selectedTableOrView) {
						$scope.dataSet.GetOperation.sqlText = "SELECT * FROM " + $scope.selectedTableOrView;
					}
				});

				/*
				 * $scope.dataSetNameChanged = function(dataSet) { // fire the call backs only if the name is
				 * changed and only after the name change is completed if (dataSet.dataSet.originalDataSetName
				 * !== dataSet.dataSet.dataSetName) { customReportSvc.triggerCallback("dataSetNameChanged",
				 * dataSet); }
				 *
				 * dataSet.dataSet.originalDataSetName = dataSet.dataSet.dataSetName; };
				 */

				$scope.addHeader = function() {
					if ($scope.dataSet.GetOperation.headers === undefined) {
						$scope.dataSet.GetOperation.headers = [ {
							name : "Accept",
							value : "application/xml"
						} ];
					}

					var headers = $scope.dataSet.GetOperation.headers;

					// header[0] belongs to accept-type
					if (headers.length > 1 && headers[headers.length - 1].name === "") {
						return;
					}

					headers.push({
						name : '',
						value : ''
					});
				};

				$scope.removeHeader = function(index) {
					if ($scope.dataSet.GetOperation.headers === undefined) {
						return;
					}

					var headers = $scope.dataSet.GetOperation.headers;

					if (headers[index] === undefined) {
						return;
					}

					headers.splice(index, 1);
				};

				$scope.addUrlParameter = function() {
					if ($scope.dataSet.GetOperation.urlParameters === undefined) {
						$scope.dataSet.GetOperation.urlParameters = [];
					}

					var urlParameters = $scope.dataSet.GetOperation.urlParameters;

					if (urlParameters.length > 0 && urlParameters[urlParameters.length - 1].name === "") {
						return;
					}

					urlParameters.push({
						name : '',
						value : ''
					});
				};

				$scope.removeUrlParameter = function(index) {
					if ($scope.dataSet.GetOperation.urlParameters === undefined) {
						return;
					}

					var urlParameters = $scope.dataSet.GetOperation.urlParameters;

					if (urlParameters[index] === undefined) {
						return;
					}

					urlParameters.splice(index, 1);
				};

				$scope.openAceEditor = function(editorContent,editorMode,callback,dataVariable) {
					$scope.openAceEditorWindow(editorContent,editorMode,dataVariable,$scope,function(modifiedContent) {
						callback();
					});
				}

				$scope.showChildren = true;

				// Get data sources from service
				$scope.updateDataSources();

			} ]); // end controller queryViewCtrl

	// Controller for fields view of "Add Data Set" modal
	app.controller("fieldsViewCtrl", [
			"$scope",
			"$timeout",
			"customReportSvc",
			function($scope, $timeout, customReportSvc) {

				$scope.fieldTypes = [
						"String",
						"Boolean",
						"Date",
						"Double",
						"Float",
						"Integer",
						"Long",
						"Short",
						"Time",
						"TimeStamp",
						"Decimal" ];
				/** Currently active row */
				$scope.currentFieldIndex = 0;

				$scope.setCurrentField = function(index) {
					$scope.currentFieldIndex = index;
				};

				/**
				 * Add a field to the list of fields to modify
				 */
				$scope.addField = function() {
					if ($scope.dataSet.fields === undefined) {
						$scope.dataSet.fields = [];
					}

					var fields = $scope.dataSet.fields;

					if (fields.length > 0 && fields[fields.length - 1].name === "") {
						return;
					}

					if ($scope.dataSet.endpoint === "HTTP") {
						fields.push({
							name : "",
							dataField : "",
							type : ""
						});
					} else {
						fields.push({
							name : "",
							dataField : ""
						});
					}

					$scope.setCurrentField($scope.dataSet.fields.length - 1);
				};

				/**
				 * When ever the field name changes its reference name has to be updated across all
				 * components.
				 */
				$scope.fieldNameChanged = function() {
					var field = $scope.dataSet.fields[$scope.currentFieldIndex];
					if (field.originalName && field.name !== field.originalName) {
						//Field Name has changed from the original and its reference needs to be updated across all components
						$scope.clearAndResetCacheId(); // reset the cache id so that new cache table gets created with the new field names.
					}
				};

				/**
				 * Whether or not the given field is selected
				 *
				 * @param field
				 *            Index of field to check
				 * @return Whether or not <code>field</code> is selected
				 */
				$scope.isCurrentField = function(index) {
					return $scope.currentFieldIndex === index;
				};

				/**
				 * Delete the currently selected field
				 */
				$scope.deleteCurrentField = function() {
					if ($scope.currentFieldIndex >= 0) {
						$scope.dataSet.fields.splice($scope.currentFieldIndex, 1);
						if ($scope.currentFieldIndex > $scope.dataSet.fields.length - 1) {
							$scope.currentFieldIndex = $scope.dataSet.fields.length - 1;
						}
					}
				}; // end method deleteCurrentField

				/**
				 * Moves the currently selected field up
				 *
				 * @param direction
				 *            Either "up" or "down"
				 */
				$scope.moveField = function(direction) {
					var index = $scope.currentFieldIndex;
					if (index < 0) {
						return;
					}

					if (direction.toLowerCase() === "up") {
						if (index > 0) {
							var temp = $scope.dataSet.fields[index];
							$scope.dataSet.fields[index] = $scope.dataSet.fields[index - 1];
							$scope.dataSet.fields[index - 1] = temp;
							$scope.setCurrentField(index - 1);
						}
					} else {
						if (index < $scope.dataSet.fields.length - 1) {
							var temp = $scope.dataSet.fields[index];
							$scope.dataSet.fields[index] = $scope.dataSet.fields[index + 1];
							$scope.dataSet.fields[index + 1] = temp;
							$scope.setCurrentField(index + 1);
						}
					}
				}; // end method moveField

			} ]); // end controller fieldsViewCtrl

	// Controller for parameters view of "Add Data Set" modal
	app.controller("parametersViewCtrl", [
			"$scope",
			"customReportSvc",
			"$uibModal",
			function($scope, customReportSvc, $modal) {

				/** Parameters available to modify */
				$scope.parameters = $scope.dataSet.GetOperation.parameters;

				$scope.$watch("endPointChanged", function(endPointChanged) {
					$scope.parameters = $scope.dataSet.GetOperation.parameters;
				});

				/** Currently active row */
				$scope.currentParameter = null;

				/**
				 * Parameter types.
				 */
				$scope.parameterTypes = [
						"Boolean",
						"Date",
						"DateRange",
						"Decimal",
						"Integer",
						"String",
						"Time",
						"TimeStamp" ];

				/**
				 * Add a parameter to the list of parameters to modify
				 */
				$scope.addParameter = function() {

					if ($scope.parameters.length > 0 && $scope.parameters[$scope.parameters.length - 1].name === "") {
						return;
					}

					var param = {
						name : "",
						dataType : "String",
						listType : false
					};
					$scope.parameters.push(param);
					$scope.setCurrentParameter(param);
				}; // end method addParameter

				/**
				 * Select a certain parameter
				 *
				 * @param selected
				 *            Newly selected parameter index
				 */
				$scope.setCurrentParameter = function(parameter) {
					$scope.currentParameter = parameter;
				}; // end method setTab

				/**
				 * Whether or not the given parameter is selected
				 *
				 * @param parameter
				 *            Index of parameter to check
				 * @return Whether or not <code>parameter</code> is selected
				 */
				$scope.isCurrentParameter = function(parameter) {
					return $scope.currentParameter === parameter;
				}; // end method isSelected

				/**
				 * Delete the currently selected parameter
				 */
				$scope.deleteCurrentParameter = function() {
					$scope.currentParameterIndex = $scope.parameters.indexOf($scope.currentParameter);
					$scope.parameters.splice($scope.currentParameterIndex, 1);
					if ($scope.currentParameterIndex < $scope.parameters.length) {
						$scope.currentParameterIndex++;
					}
					$scope.setCurrentParameter($scope.parameters[$scope.currentParameterIndex - 1]);
				}; // end method deleteCurrentParameter

				/**
				 * Moves the currently selected parameter up
				 *
				 * @param direction
				 *            Either "up" or "down"
				 */
				$scope.moveParameter = function(direction) {
					var index = $scope.parameters.indexOf($scope.currentParameter);
					if (direction.toLowerCase() === "up") {
						if (index !== 0) {
							$scope.parameters[index] = $scope.parameters[index - 1];
							$scope.parameters[index - 1] = $scope.currentParameter;
						}
					} else {
						if (index !== $scope.parameters.length - 1) {
							$scope.parameters[index] = $scope.parameters[index + 1];
							$scope.parameters[index + 1] = $scope.currentParameter;
						}
					}
				}; // end method moveParameter

				$scope.showInsertVariable = function(parameter) {
					$scope.setCurrentParameter(parameter);
					var modalInstance = $modal.open({
						templateUrl : "reportVariables/insertVariable.jsp",
						controller : "insertVariableCtrl",
						backdrop : 'static',
						keyboard : false,
						resolve : {
							page : function() {
								return $scope.page;
							},
							component : function() {
							},
							modalParams : function() {
								return {
									entityToAdd : "parameter"
								};
							}
						}
					});

					modalInstance.result.then(function(response) {
						if (response !== undefined) {
							var values = [];
							values.push("=" + response[0].parent.entity.label + "." + response[0].label);
							parameter.values = values;
						}

					});
				};

			} ]); // end controller parametersViewCtrl

	app.controller("advancedViewCtrl", [ "$scope", "customReportSvc", function($scope, customReportSvc) {
		$scope.queryPlan = $scope.dataSet.queryPlan;

		/* $scope.allVersions = $scope.queryPlan.versions[0] === "ALL" ? true : false; */

		/*
		 * $scope.checkAll = function(allVersions) { if(allVersions){ $scope.queryPlan.versions = ["ALL"];
		 * }else{ $scope.queryPlan.versions = []; } };
		 */

		/*
		 * $scope.valueChanged = function(value){ if($scope.queryPlan.versions.length === 1 &&
		 * $scope.queryPlan.versions[0] === "ALL"){ $scope.queryPlan.versions[0] = value; } $scope.allVersions =
		 * false; }
		 */

		$scope.dataSet.enableQueryFilter = false;
		$scope.showFilterOptions = (showFilterOptions == "true");
		if ($scope.dataSet.GetOperation.filterClause) {
			$scope.dataSet.enableQueryFilter = true;
			if (!$scope.dataSet.GetOperation.postQueryFilter) {
				$scope.dataSet.GetOperation.postQueryFilter = false;
				$scope.showFilterOptions = true;
			}
		} else {
			$scope.dataSet.GetOperation.postQueryFilter = true;
		}

		$scope.enableQuery = function() {
			if (!$scope.dataSet.enableQueryFilter) {
				$scope.dataSet.GetOperation.filterClause = "";
			}
		}

		//reset fields on offline value change so that the fields are refreshed.
		$scope.resetfields = function() {
			$scope.dataSet.fields = [];
			$scope.clearAndResetCacheId();
		};

		$scope.$watch('queryPlan.dynamicCollection', function(value) {
			if (value && !$scope.queryPlan.frequency) {
				$scope.queryPlan.frequency = 60;
			}
		});

		$scope.enableDirectCollection = function() {
			if ($scope.queryPlan.direct) {
				$scope.queryPlan.dynamicCollection = $scope.queryPlan.direct;
			}
		}

		$scope.$watchCollection("queryPlan.versions", function(newValue, oldValue) {
			if (newValue) {
				if (newValue.length > 1 && newValue[0] === "ALL") {
					$scope.queryPlan.versions.splice($scope.queryPlan.versions.indexOf("ALL"), 1);
				} else if (newValue.length > 1 && newValue.indexOf("ALL") === newValue.length - 1) {
					$scope.queryPlan.versions = [ "ALL" ];
				}
			}

		});

		// default versions for Offline Collections.
		$scope.offLineVersions = [ {
			"value" : "ALL",
			"name" : "ALL"
		}, {
			"value" : "VERSION_9",
			"name" : "Version 9"
		}, {
			"value" : "VERSION_10",
			"name" : "Version 10"
		}, {
			"value" : "VERSION_11",
			"name" : "Version 11"
		} ];
		/*
		 * customReportSvc.registerCallback("activeDataSetsCallbacks", function(activeDataSet) {
		 * $scope.queryPlan = activeDataSet.queryPlan; });
		 */

	} ]);
})();
