/*************************************************************************************************************
 * To add email suggestion to input fields with multiple email ids. eg: Reports Schedule/Alarms dialog.
 * Include this file , and customreports/css/shareReport.css, cvUtil.js is also a dependecy
 * 
 * Usage:
 * 
 * <span class="email_suggestion" data-margin-left="5px" data-suggestion-width="100%" data-max-suggestion="5">
 * 
 * <input type="text" autocomplete="off">
 * 
 * </span>
 * 
 * Details:
 * 
 * data-margin-left : Adds margin-left of the suggestion box, to make it fit for the input field
 * 
 * data-suggestion-width: overrides the width of the suggestion box. Default value is set in CSS of class
 * .email_suggestion_list_container
 * 
 * data-max-suggestion: Max length of the suggestion. Default value set in, emailSuggestion.suggestionLimit
 * 
 ************************************************************************************************************/

var emailSuggestion = {};

emailSuggestion.suggestionLimit = 8;
emailSuggestion.queryLimit = 100;
emailSuggestion.cacheId = cvUtil.generateUUID();
emailSuggestion.regexForCommaColonSpace = /[\s,;]+/;
emailSuggestion.keyActions = {
  ENTER: 0,
  RIGHT: 1,
  LEFT: 2,
  DOWN: 3,
  UP: 4
};
emailSuggestion.sessionStorageKeys = {
  USERS_WITH_EMAIL: "usersWithEmail"
};

emailSuggestion.usersWithEmail = "";
emailSuggestion.loadingBar = {};
emailSuggestion.loadingBar.class = "email_suggestion_loading_item";

if ( cvUtil.getContextPath().indexOf('webconsole') != -1 ) {
	emailSuggestion.loadingIconLoc = '/common/img/jobProgress.gif';
} else {
	emailSuggestion.loadingIconLoc = '/common/img/ajax-loader.gif';
}

emailSuggestion.loadingBar.html =
  "<span class='" +
  emailSuggestion.loadingBar.class +
  "'><img class='loader_gif' src='" +
  cvUtil.getContextPath() + emailSuggestion.loadingIconLoc + "'><span>";

emailSuggestion.usersDataSetUrl =
  "/api/cr/reportsplusengine/datasets/47d3afa6-1222-42ae-ad76-e767f5a481a9/data?orderby=%5BType%5DDesc%2C%5Bname%5DAsc&isExport=false&cacheId=" +
  emailSuggestion.cacheId + //Uses Security API Built in Custom Report
  "&where=%5Bemail%5D%20%3D%20_exprString%20(%22!%3D%22%22%22%22%22%2C%22contains%22)" + //No blank emails
  "&limit=" +
  emailSuggestion.queryLimit;

emailSuggestion.initializeEmailSuggestion = function() {
  try {
    var usersAndGroups = window.sessionStorage.getItem(
      emailSuggestion.sessionStorageKeys.USERS_WITH_EMAIL
    );
    if (usersAndGroups == undefined) {
      cvUtil.loadPageWithGET(
        cvUtil.getContextPath() + emailSuggestion.usersDataSetUrl,
        "",
        function(data) {
          try {
            var finalData = emailSuggestion.convertDataSetDataToRequiredFormat(
              data
            );
            window.sessionStorage.setItem(
              emailSuggestion.sessionStorageKeys.USERS_WITH_EMAIL,
              JSON.stringify(finalData)
            ); //not loading data to window object
          } catch (e) {
            console.error(
              "Failed adding usersWithEmail to session object. Adding blank object"
            );
            window.sessionStorage.setItem(
              emailSuggestion.sessionStorageKeys.USERS_WITH_EMAIL,
              ""
            );
          }
        },
        function() {
          console.error("Error getting data from Security API");
        }
      );
    }
    var emailSuggestionInput = $(".email_suggestion :input");
    var emailSuggestionDiv = $(".email_suggestion");

    $(".email_suggestion").find(".email_suggestion_list_container").remove();

    $(".email_suggestion").append(
      '<span class="email_suggestion_list_container"></span>'
    );

    $(".email_suggestion").each(function() {
      $(this)
        .find(".email_suggestion_list_container")
        .hide();
      var marginLeft = $(this).attr("data-margin-left");
      if (marginLeft) {
        $(this)
          .find(".email_suggestion_list_container")
          .css("margin-left", marginLeft);
        $(this)
          .find(".email_suggestion_list_container")
          .append(emailSuggestion.loadingBar.html);
      }
      var suggestionWidth = $(this).attr("data-suggestion-width");
      if (suggestionWidth) {
        $(this)
          .find(".email_suggestion_list_container")
          .css("width", suggestionWidth);
      }
    });

    emailSuggestionInput.focusin(function() {
      var container = $(this).siblings(".email_suggestion_list_container");
      emailSuggestion.updateEmailSuggestionContainer(container, "");
    });

	/**
	 * Hiding container on click outside of input field
	 */
    $(window).click(function() {
      var container = $(".email_suggestion_list_container");
      var exec = setTimeout(function() {
        container.hide();
      }, 200);
    });

    emailSuggestionInput.click(function(event) {
      event.stopPropagation();
	});

	/**
	 * END: Hiding container on click outside of input field
	 */

    emailSuggestionInput.keyup(function(e) {
      var container = $(this).siblings(".email_suggestion_list_container");
      if (e.keyCode == 40) {
        //Move Down
        emailSuggestion.arrowControlEmailSuggestion(
          container,
          emailSuggestion.keyActions.DOWN
        );
      } else if (e.keyCode == 38) {
        //Move Up
        emailSuggestion.arrowControlEmailSuggestion(
          container,
          emailSuggestion.keyActions.UP
        );
      } else if (e.keyCode == 13) {
        //enter key
        emailSuggestion.arrowControlEmailSuggestion(
          container,
          emailSuggestion.keyActions.ENTER
        );
      } else if (e.keyCode == 27) {
        //Esc
        container.hide();
      } else if (e.keyCode == 37 || e.keyCode == 39) {
        //left , right
        //no action
      } else {
        var value = emailSuggestion.getTypingEmailValue($(this).val());
        emailSuggestion.updateEmailSuggestionContainer(container, value);
      }
    });

    emailSuggestionDiv.on("click", ".email_suggestion_list_item", function() {
      var emailVal = $(this).attr("data-email");
      var inputField = $(this)
        .closest(".email_suggestion")
        .find(":input");
      emailSuggestion.fillEmailValue(inputField, emailVal);
      var container = $(this).closest(".email_suggestion_list_container");
      emailSuggestion.updateEmailSuggestionContainer(container, "");
    });

    emailSuggestionDiv.on(
      "mouseover",
      ".email_suggestion_list_item",
      function() {
        $(".email_suggestion_list_item").removeClass("selected_item");
        $(this).addClass("selected_item");
      }
    );
  } catch (e) {
    console.error("Error initializing email suggestion");
    console.error(e);
  }
};

emailSuggestion.getTypingEmailValue = function(value) {
  if (value.match(emailSuggestion.regexForCommaColonSpace)) {
    if (value.match(emailSuggestion.regexForCommaColonSpace).index == 0) {
      return "";
    }
  }
  var lists = value.split(emailSuggestion.regexForCommaColonSpace);
  var current = lists[lists.length - 1];
  return current;
};

emailSuggestion.fillEmailValue = function(inputField, value) {
  var existingVal = inputField.val();
  var newVal = "";
  var lists = existingVal.split(emailSuggestion.regexForCommaColonSpace);

  value = value + ",";
  if (existingVal.length == 0) {
    newVal = existingVal + value;
  } else if (
    existingVal[existingVal.length - 1].match(
      emailSuggestion.regexForCommaColonSpace
    )
  ) {
    //if no typing is done after previous email
    newVal = existingVal + value;
  } else {
    var list = existingVal.split(emailSuggestion.regexForCommaColonSpace);
    list[list.length - 1] = value;
    newVal = list.join(",");
  }
  var inputFieldSelector = $(inputField);
  inputFieldSelector.focus();
  inputFieldSelector.val(newVal);
  inputFieldSelector.trigger('input'); // Use for Chrome/Firefox/Edge
  inputFieldSelector.trigger('change'); // Use for Chrome/Firefox/Edge + IE11
};

emailSuggestion.getAdditionalDataFromDataset = function(
  container,
  searchString,
  finalListLength
) {
  var searchAddition =
    '&where=%5Bnameemail%5D%20%3D%20_exprString%20(%22' +
    encodeURIComponent(searchString) +
    '%22%2C%22contains%22)';
  container.append(emailSuggestion.loadingBar.html);
  container.show();
  cvUtil.loadPageWithGET(
    cvUtil.getContextPath() + emailSuggestion.usersDataSetUrl + searchAddition,
    "",
    function(data) {
      container.find("." + emailSuggestion.loadingBar.class).hide();
      var finalData = emailSuggestion.convertDataSetDataToRequiredFormat(data);

      //Adding non duplicate objects to emailSuggestion.usersWithEmail
      var mergedArray = emailSuggestion.usersWithEmail;
      for (var i = 0; i < finalData.length; i++) {
        var alreadyExists = false;
        for (var j = 0; j < emailSuggestion.usersWithEmail.length; j++) {
          if (emailSuggestion.usersWithEmail[j].searchText == finalData[i].searchText) {
            alreadyExists = true;
            break;
          }
        }
        if (!alreadyExists) {
          mergedArray.push(finalData[i]);
        }
      }
      emailSuggestion.usersWithEmail = mergedArray;

      var currentSearchvalue = emailSuggestion.getTypingEmailValue(
        container.siblings(":input").val()
      ); //Giving only the current value. (May have changed in the time)
      emailSuggestion.updateEmailSuggestionContainer(
        container,
        currentSearchvalue,
        true
      ); //Updating search suggestion
    },
    function() {
      console.error("Error getting data from Security API");
      $(".email_suggestion_list_container").hide(); //hiding suggestions
    }
  );
};

emailSuggestion.updateEmailSuggestionContainer = function(
  container,
  searchString,
  noAdditionalLoadAgain
) {
  var showContainer = true;
  var loadFromDataset = false;
  var finalList = 0;
  container.html("");
  if (!searchString) {
    searchString = "";
  }
  searchString = searchString.toLowerCase();

  if (!emailSuggestion.usersWithEmail) {
    var list = window.sessionStorage.getItem(
      emailSuggestion.sessionStorageKeys.USERS_WITH_EMAIL
    );
    if (list) {
      emailSuggestion.usersWithEmail = JSON.parse(list);
    }
  }

  if (emailSuggestion.usersWithEmail && searchString) {
    finalList = emailSuggestion.usersWithEmail.filter(function(el) {
      return (
        el.searchText.toLowerCase().indexOf(searchString) > -1
      );
    });

    var totalLength = emailSuggestion.suggestionLimit;

    var maxSuggestionLimit = container
      .closest(".email_suggestion")
      .attr("data-max-suggestion");
    if (maxSuggestionLimit) {
      totalLength = parseInt(maxSuggestionLimit);
      if (isNaN(totalLength)) {
        totalLength = emailSuggestion.suggestionLimit;
      }
    }

    if (finalList.length == 0) {
      showContainer = false;
    }

    finalList = finalList.slice(0, totalLength);
    finalList.forEach(function(item) {
      var content = item.name + " &lt;" + item.email;
      var itemHtml =
        '<span class="email_suggestion_list_item" title="' +
        content +
        '" data-email="' +
        item.email +
        '">';
      if (item.type == 2) {
        itemHtml += "<strong>" + content + "&gt;</strong>";
      } else {
        itemHtml += content + "&gt;";
      }
      itemHtml += "</span>";
      container.append(itemHtml);
    });

    if (finalList.length < totalLength) {
      loadFromDataset = true;
    }
  } else {
    showContainer = false;
  }

  if (showContainer) {
    container.show();
  } else {
    container.hide();
  }

  //After Complete Rendering
  if (!noAdditionalLoadAgain) {
    if (loadFromDataset) {
      emailSuggestion.getAdditionalDataFromDataset(
        container,
        searchString,
        finalList.length
      );
    }
  }
};

emailSuggestion.convertDataSetDataToRequiredFormat = function(data) {
  //Convert to array of {"name":"","email":"","type":2 OR 1}    2 For usergroup, 1 for user
  var jsonData = JSON.parse(data)["records"];
  var finalData = new Array();

  for (var i = 0; i < jsonData.length; i++) {
	var fullName = jsonData[i][7];
	var name = jsonData[i][3];
	if (fullName) {
		name = fullName;
	}
    var indData = {
      name: name,
      type: jsonData[i][4],
      email: jsonData[i][5],
      searchText : jsonData[i][6]
    };
    finalData.push(indData);
  }
  return finalData;
};

emailSuggestion.arrowControlEmailSuggestion = function(container, action) {
  var selectedDiv = $(container).find(".selected_item");
  if (action == emailSuggestion.keyActions.ENTER) {
    if (selectedDiv.length > 0) {
      selectedDiv.click();
    }
  } else if (action == emailSuggestion.keyActions.DOWN) {
    if (selectedDiv.length <= 0) {
      container
        .find(".email_suggestion_list_item")
        .first()
        .addClass("selected_item");
    } else {
      selectedDiv.removeClass("selected_item");
      selectedDiv.next(".email_suggestion_list_item").addClass("selected_item");
    }
  } else if (action == emailSuggestion.keyActions.UP) {
    if (selectedDiv.length <= 0) {
      container
        .find(".email_suggestion_list_item")
        .first()
        .addClass("selected_item");
    } else {
      selectedDiv.removeClass("selected_item");
      selectedDiv.prev(".email_suggestion_list_item").addClass("selected_item");
    }
  }
};

$(document).ready(function() {
  emailSuggestion.initializeEmailSuggestion();
});
