<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>	
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.sp0365.title.changePlanAsso" bundle="office365"/>
	</h1>
</div>
<div class="wrapper-view bootstrap-wrapper">
    <form name="changePlanAssociationForm" class="form-horizontal bootstrap-wrapper" id="change-plan-association-form" data-cv-submit="o365SPChangePlanAssociationCtrl.updateAssociation()" novalidate autocomplete="off">
		<div class="modal-body">
            <p class="{{o365SPChangePlanAssociationCtrl.errorMsg.type}} serverMessage" data-ng-bind="o365SPChangePlanAssociationCtrl.errorMsg.message"></p>
            
			<!-- select exchange plan -->
			<div class="form-group row" >
                <div>
                    <label class="col-xs-12 col-md-4 col-lg-4"
                        for="o365SPChangePlanAssociation_isteven-select_#1"><cv:msg key="label.sp0365.office365Plan" bundle="office365" /></label>
                    <div class="col-xs-12 col-md-8 col-lg-8">
                        <div class="create-new-button-wrapper">
                            <div class="input-group">
                                <isteven-multi-select 
                                    id="o365SPChangePlanAssociation_isteven-select_#1" 
                                    class="half-width"
                                    input-model="o365SPChangePlanAssociationCtrl.office365PlanList"
                                    output-model="o365SPChangePlanAssociationCtrl.selectedPlanList"
                                    button-label="planName"
                                    item-label="planName"
                                    selection-mode="single"
                                    helper-elements="filter"
                                    directive-id="office365PlanList_inline"
                                    max-labels="1"
                                    tick-property="selected"
                                    translation="o365SPChangePlanAssociationCtrl.localLang">
                                </isteven-multi-select>

                                <span class="input-group-btn" data-ng-if="o365SPChangePlanAssociationCtrl.createPlanCapablity">
                                    <button id="o365SPChangePlanAssoCreateNewPlanInline"
                                        type="button"
                                        class="icon-style cv-material-button browse"
                                        data-ng-click="o365SPChangePlanAssociationCtrl.createO365PlanInline()">
                                        <div class="cv-material-button-icon cursor-pointer">
                                            <span class="k-icon k-i-plus create-new-button"></span>
                                        </div><div class="cv-material-button-tooltip"><cv:msg key="label.createNew" bundle="exchange" /></div>
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="o365SPChangePlanAssociation_button_#1" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="o365SPChangePlanAssociationCtrl.cancel()"><cv:msg key="action.cancel" bundle="exchange"/></button>
			<button id="o365SPChangePlanAssociation_button_#2" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="exchange"/></button>
		</div>
    </form>
</div>