<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.infrastructurePane" bundle="exchange" />	</h1>
</div>
<div class="setup-content">
	<div class="bootstrap-wrapper form-horizontal">
		<form name="editInfrastructureSettingsForm"	data-cv-submit="editInfraSettingsCtrl.saveInfo()" novalidate autocomplete="off" class="form-horizontal">
			<div class="panel-body" data-ng-if="!editInfraSettingsCtrl.infraStructureSettings.isInfrastructureConfigured">
				<div class="form-group row">
					<label class="col-xs-12 col-md-4"><cv:msg
							key="label.accessNodes" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-8">
						<isteven-multi-select
								input-model="editInfraSettingsCtrl.proxyServers"
								output-model="editInfraSettingsCtrl.selectedProxyList"
								button-label="clientName"
								item-label="clientName"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								id="accessNodes"
								name="accessNodes"
								helper-elements="all reset filter"
								max-labels="2"
								translation="editInfraSettingsCtrl.localLang"
								on-select-none="editInfraSettingsCtrl.processAccessNodeSelection()"
								on-select-all="editInfraSettingsCtrl.processAccessNodeSelection()"
								on-reset="editInfraSettingsCtrl.processAccessNodeSelection()"
								on-item-click="editInfraSettingsCtrl.processAccessNodeSelection()"
								group-property="msGroup">
						</isteven-multi-select>
					</label>
					<div class="help-block"
								data-ng-show="editInfraSettingsCtrl.accessNodeRequired">
							<cv:msg key="label.selectAccessNode" bundle="office365" />
					</div>
					</div>
				</div>
				<div class="form-group row" ng-if="editInfraSettingsCtrl.selectedProxyList.length > 1 || editInfraSettingsCtrl.isClientGroupSelected || editInfraSettingsCtrl.hasJobResultsDirectoryConfigured">
					<label class="col-xs-12 col-md-4"><cv:msg key="label.jobResultsDirectory" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-8">
						<input type="text" id="jobResultsDirectory" name="jobResultsDirectory"
								data-ng-required="editInfraSettingsCtrl.selectedProxyList.length > 0 || editInfraSettingsCtrl.isClientGroupSelected"
								data-ng-pattern="editInfraSettingsCtrl.REGEX.WINDOWS_NETWORK_PATH"
								data-ng-model="editInfraSettingsCtrl.infraStructureSettings.jobResulsDir.path" />
						<div class="help-block"
								data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.jobResultsDirectory) &&  !editInfrastructureSettingsForm.jobResultsDirectory.$error.pattern">
							<cv:msg key="error.noJobResultsDirectory" bundle="exchange" />
						</div>
						<div class="help-block"
							data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.jobResultsDirectory) &&  editInfrastructureSettingsForm.jobResultsDirectory.$error.pattern ">
							<cv:msg key="error.invalidNetworkPath" bundle="exchange" />
						</div>
					</div>
				</div>
				<div  ng-if="(editInfraSettingsCtrl.selectedProxyList.length > 1 || editInfraSettingsCtrl.isClientGroupSelected || editInfraSettingsCtrl.hasJobResultsDirectoryConfigured)">
					<div class="form-group row plain-accordion">
						<div class="cv-accordion-header">
							<span class="cv-accordion-text"><cv:msg key="label.sharePathAccount" bundle="exchange" /></span>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-xs-12 col-md-4"><cv:msg key="label.userName" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-8">
							<input type="text" name="localAccessAccountName" id="localAccessAccountName"  data-ng-model="editInfraSettingsCtrl.infraStructureSettings.serviceAccountTypeSystem.userAccount.userName" data-ng-required="editInfraSettingsCtrl.selectedProxyList.length > 0 || editInfraSettingsCtrl.isClientGroupSelected"/>
							<div class="help-block"
								data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.localAccessAccountName)">
								<cv:msg key="error.userName" bundle="exchange" />
							</div>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-xs-12 col-lg-4" for="password"><cv:msg key="label.password" bundle="exchange" /></label>
						<div class="col-xs-12 col-lg-8">
							<input type="password" name="password" id="password" data-ng-model="editInfraSettingsCtrl.infraStructureSettings.serviceAccountTypeSystem.userAccount.password" data-ng-required="editInfraSettingsCtrl.passwordRequired"/>
							<div class="help-block"
								data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.password)">
								<cv:msg key="error.password" bundle="exchange" />
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-xs-12 col-lg-4" for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="exchange" /></label>
						<div class="col-xs-12 col-lg-8">
							<input type="password" name="confirmPassword" id="confirmPassword"
								data-ng-model="editInfraSettingsCtrl.infraStructureSettings.serviceAccountTypeSystem.userAccount.confirmPassword"
								data-cv-equals="{{editInfraSettingsCtrl.infraStructureSettings.serviceAccountTypeSystem.userAccount.password}}"
								data-ng-required="editInfraSettingsCtrl.passwordRequired" />
							<div class="help-block"
								data-ng-show="editInfrastructureSettingsForm.confirmPassword.$error.cvEquals && cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.confirmPassword)">
								<cv:msg key="error.mismatchedPassword" bundle="exchange" />
							</div>
							<div class="help-block"
								data-ng-show="!editInfrastructureSettingsForm.confirmPassword.$error.cvEquals && cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.confirmPassword)">
								<cv:msg key="error.noConfirmPassword" bundle="exchange" />
							</div>
						</div>
					</div>
					<div class="form-group margin-top-10 margin-left-10 margin-right-10">    
						<div class="col-xs-12 col-md-12">
							<!--Progress stepper--START-->
							<cv-progress-stepper
								data-ng-if="editInfraSettingsCtrl.showStepper"
								input-model="editInfraSettingsCtrl.progressStepperModel"> 
							</cv-progress-stepper>
							<!--Progress stepper--END-->
							<div class="margin-left-10 margin-right-10">
								<div class="row" data-ng-if="editInfraSettingsCtrl.moveJobResultsDirectoryError.length">
									<div class="help-block margin-top-20"> 
										<label data-ng-bind="editInfraSettingsCtrl.moveJobResultsDirectoryError"></label> 
									</div>
								</div>

								<div data-ng-if="editInfraSettingsCtrl.showJobResultsOverride" class="row margin-top-20 italic text-align-left">
									<cv:msg key="confirm.jobResultsOverride" bundle="office365" />
									<a class="margin-left-5" data-ng-click="editInfraSettingsCtrl.overrideJobResultsStep(true)">
										<cv:msg key="button.yes" bundle="messages"></cv:msg>
									</a>
									<a class="margin-left-5" data-ng-click="editInfraSettingsCtrl.overrideJobResultsStep(false)">
										<cv:msg key="button.no" bundle="messages"></cv:msg>
									</a>
								</div>
								<div data-ng-if="editInfraSettingsCtrl.showJobResultsWarning" class="row plain-accordion float-left margin-top-10">
									<div class="cv-accordion-header input-group">
										<span class="padding-15 k-icon k-i-warning red-font fa-2x"></span>
										<div class="cv-accordion-header text-align-left">
											<cv:msg key="warning.jobResultsOverride" bundle="office365" />
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>


			<div class="form-group margin-top-10 margin-bottom-10 margin-left-10 margin-right-10">
				<div class="col-xs-12 col-md-12">
					<div class="help-block margin-top-20" data-ng-if="editInfraSettingsCtrl.errorMsg.length">
						<label data-ng-bind="editInfraSettingsCtrl.errorMsg"></label> 
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-default cvBusyOnAjax" data-ng-disabled="editInfraSettingsCtrl.savingInfo || !editInfraSettingsCtrl.enableCloseButton"
					data-ng-click="editInfraSettingsCtrl.closeModal()" data-ng-if="editInfraSettingsCtrl.showCloseButton">
					<cv:msg key="label.close" bundle="messagesJs" />
				</button>
				<button type="button" class="btn btn-default cvBusyOnAjax" data-ng-disabled="editInfraSettingsCtrl.savingInfo"
					data-ng-click="editInfraSettingsCtrl.cancel()" data-ng-if="!editInfraSettingsCtrl.showCloseButton" >
					<cv:msg key="action.cancel" bundle="profiles" />
				</button>
				<button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="editInfraSettingsCtrl.savingInfo" data-ng-if="!editInfraSettingsCtrl.showCloseButton">
					<cv:msg key="action.save" bundle="profiles" />
				</button>
			</div>
		</form>
	</div>
</div>
