<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1><cv:msg key="label.sharepointConnectionSettings" bundle="office365" /></h1>
	</div>
	<form name="editInfrastructureSettingsForm"	data-cv-submit="editSPConnectSettingsCtrl.saveInfo()" novalidate autocomplete="off" class="form-horizontal">
		<div class="modal-body">
			<div class="form-group" data-ng-if="editSPConnectSettingsCtrl.infraStructureSettings.isUserMailboxPresent || editSPConnectSettingsCtrl.infraStructureSettings.isJournalMailboxPresent">
				<h4 class="col-xs-12 col-md-12" ng-bind="editSPConnectSettingsCtrl.heading1"></h4>
			</div>
			<div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="region"><cv:msg key="label.office365.cloudregion" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<select id="region" name="region" data-ng-model="editSPConnectSettingsCtrl.infraStructureSettings.cloudRegion">
							<option value="DEFAULT" selected="selected"><cv:msg	key="label.defaultRegion" bundle="exchange" /></option>
							<option value="GERMANY"><cv:msg key="label.germany" bundle="exchange" /></option>
							<option value="CHINA"><cv:msg key="label.china" bundle="exchange" /></option>
							<option value="US_GOVERNMENT"><cv:msg key="label.usgovt" bundle="exchange" /></option>
						</select>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="tenantURL"><cv:msg key="label.tenantURL" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" id="tenantURL" name="tenantURL" data-ng-model="editSPConnectSettingsCtrl.infraStructureSettings.tenantURL" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="applicationId"><cv:msg key="label.applicationId" bundle="exchange"></cv:msg></label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" id="applicationId" name="applicationId" data-ng-model="editSPConnectSettingsCtrl.infraStructureSettings.azureDetails.azureAppId" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="secretAccessKey"><cv:msg key="label.secretAccessKey" bundle="exchange"></cv:msg></label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" id="secretAccessKey"
							autocomplete="new-password" name="secretAccessKey"
							placeholder="<cv:msg key="label.leaveAzureSecretKeyBlank" bundle="exchange"></cv:msg>"
							data-ng-model="editSPConnectSettingsCtrl.infraStructureSettings.azureDetails.azureAppKeyValue" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="tenantName"><cv:msg key="label.azureDirectoryID" bundle="messages"></cv:msg></label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" id="tenantName" name="tenantName" data-ng-model="editSPConnectSettingsCtrl.infraStructureSettings.azureDetails.azureDirectoryId" />
					</div>
				</div>
			</div>
			<cv-plain-accordion accordion-label="label.serviceAccounts">
				<div class="group" ng-if="editSPConnectSettingsCtrl.infraStructureSettings.serviceAccountsList.length !== 0">
					<div>
						<cv-kendo-grid data-cv-grid-options="editSPConnectSettingsCtrl.gridOptions"></cv-kendo-grid>
					</div>
				</div>
				<div class="form-group" ng-if="editSPConnectSettingsCtrl.infraStructureSettings.serviceAccountsList.length === 0">
					<span class="col-xs-12 col-lg-12"><cv:msg key="label.youHaveNotAddedAnyServiceAccountsYet" bundle="exchange" /></span>
				</div>
			</cv-plain-accordion>
		</div>
		<div class="modal-footer">
			<button id="editSPConnectSettings_button_#1540" type="button" class="btn btn-default cvBusyOnAjax" 
				data-ng-click="editSPConnectSettingsCtrl.cancel()">
				<cv:msg key="action.cancel" bundle="exchange" />
			</button>
			<button id="editSPConnectSettings_button_#2390" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<cv:msg key="action.save" bundle="exchange" />
			</button>
		</div>
	</form>
</div>