<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>

<div class="row">
	<div class="col-md-6">
		<!--General --START-->
		<cv-tile-component data-title='<cv:msg key="header.general" bundle="exchange" />' loader="clientConfigurationCtrl.infrastructureSettingsLoaded">
			<ul class="list-style-secondary">
				<!--Cloud Region-->	
				<li class="group" data-ng-if="!clientConfigurationCtrl.isMSRegionEdit">
					<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.office365.cloudregion" bundle="exchange"/></span>
					<span class="pageDetailColumn width-60-percentage">
						<span data-ng-bind="clientConfigurationCtrl.msCloudRegion"></span>
						<span class="float-right tile-content-link"  data-ng-if="clientConfigurationCtrl.cloudAppUIAttributes.showRegion">
							<a data-ng-click="clientConfigurationCtrl.editMSCloudRegion(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>
				<li class="group"  data-ng-if="clientConfigurationCtrl.isMSRegionEdit">
					<span class="pageDetailColumn margin-top-10 width-40-percentage"><cv:msg key="label.office365.cloudregion" bundle="exchange"/></span>
					<span class="pageDetailColumn inline-editor width-60-percentage">
						<isteven-multi-select id="createOffice365App_isteven-multi-select_#1167" 
							input-model="clientConfigurationCtrl.msCloudRegionsList"
							output-model="clientConfigurationCtrl.selectedRegionList"
							button-label="region"
							item-label="region"
							directive-id="'cloudRegions'"
							selection-mode="single"
							helper-elements="filter"
							max-labels="1"
							tick-property="selected"
							translation="clientConfigurationCtrl.localLang">
						</isteven-multi-select>
						
						<span class="inline-editor-buttons">
							<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="clientConfigurationCtrl.updateMSCloudRegion()"><span class="k-icon k-i-check"></span></a>
							<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="clientConfigurationCtrl.editMSCloudRegion(false)"><span class="k-icon k-i-x"></span></a>
						</span>
					</span>
				</li>
				<!--Cloud Region-->	
				<!--Global Admin Account ... On Edit ..open small-window dialog-->
				<li class="group">
					<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.globalAdministrator" help-text="help.globalAdmin"/></span>
					<span class="pageDetailColumn width-60-percentage" data-ng-if="clientConfigurationCtrl.hasGlobalAdminAccount">
						<span data-ng-bind="clientConfigurationCtrl.globalAdministrator"></span>						
						<span class="float-right tile-content-link" >
							<a data-ng-click="clientConfigurationCtrl.editInfraStructureSettings(clientConfigurationCtrl.editModes.EDIT_GLOBAL_ADMINISTRATOR)"><cv:msg key="label.edit" bundle="clients" /></a>
							<a class="margin-left-10" data-ng-click="clientConfigurationCtrl._confirmDeleteGlobalAdmin()"><cv:msg key="label.delete" bundle="ediscovery" /></a>		
						</span>
					</span>					
					<!--Add new Global Administrator-->
					<span class="pageDetailColumn width-60-percentage" data-ng-if="!clientConfigurationCtrl.hasGlobalAdminAccount">
						<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>				
						<span class="float-right tile-content-link" >
							<a data-ng-click="clientConfigurationCtrl.editInfraStructureSettings(clientConfigurationCtrl.editModes.EDIT_GLOBAL_ADMINISTRATOR, true)">
								<cv:msg key="label.add" bundle="office365" />
							</a>
						</span>
					</span>
				</li>
				
				
				<!--Modern authentication-->	
				<li class="group" data-ng-if="clientConfigurationCtrl.cloudAppUIAttributes.showModernAuth">
					<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.useModernAuthentication" help-text="label.modernAuthWarning"/></span>
					<span class="pageDetailColumn width-60-percentage">
						<toggle-control status="true"></toggle-control>
					</span>
				</li>
				<!--Modern authentication-->				
			</ul>
		</cv-tile-component>
		<!--General --END-->

		<!--Connections --START-->		 
		<cv-tile-component data-title={{clientConfigurationCtrl.connectionTileLabel}} loader="clientConfigurationCtrl.infrastructureSettingsLoaded">
            <ul class="list-style-secondary margin-top-15">
                <li class="group no-padding" data-ng-if="clientConfigurationCtrl.showBothAzureServiceAccTabs && clientConfigurationCtrl.azureAppsGridOptions && clientConfigurationCtrl.serviceAccountGridOptions">
                    <cv-tabset-component control='clientConfigurationCtrl.tabControls' element="cvtile">
                        <cv-tab tabname='<cv:msg key="label.azureApps" bundle="office365" />' data-ng-selected="clientConfigurationCtrl.onConnectionTabSelectionChange()">
                            <cv-kendo-grid data-cv-grid-options="clientConfigurationCtrl.azureAppsGridOptions"></cv-kendo-grid>
                        </cv-tab>
                        <cv-tab tabname='<cv:msg key="label.office365ServiceAccts" bundle="exchange" />' data-ng-selected="clientConfigurationCtrl.onConnectionTabSelectionChange()">
                            <cv-kendo-grid data-cv-grid-options="clientConfigurationCtrl.serviceAccountGridOptions"></cv-kendo-grid>
                        </cv-tab>
                    </cv-tabset-component>
                </li>
                <li class="group" data-ng-if="!clientConfigurationCtrl.showBothAzureServiceAccTabs && clientConfigurationCtrl.azureAppsGridOptions">
                    <cv-kendo-grid data-cv-grid-options="clientConfigurationCtrl.azureAppsGridOptions"></cv-kendo-grid>
                </li>
            </ul>
            
			<div class="page-details-box-links margin-top-30">
                <a href="" data-ng-click="clientConfigurationCtrl._azureAppsCheckReadiness()">
					<cv:msg key="action.verifyConnection" bundle="office365" />
				</a>
                <a href="" data-ng-click="clientConfigurationCtrl._addEditAzureApp()"  data-ng-if="clientConfigurationCtrl.cloudAppUIAttributes.hasMultipleAzureApp || !clientConfigurationCtrl.hasAzureAppsConfigured">
					<cv:msg key="dialog.azureapp.title" bundle="office365" />
				</a> 
				<a href="" data-ng-click="clientConfigurationCtrl.addEditServiceAccount()"  data-ng-if="clientConfigurationCtrl.cloudAppUIAttributes.needServiceAccounts">
					<cv:msg key="label.addServiceAccount" bundle="exchange" />
				</a>
            </div>
        </cv-tile-component>
		<!--Connections --END-->

		<div data-ng-if="clientConfigurationCtrl.appConsts.showOnBoardingMessage">
			<cv-on-boarding-warning-msg backupset-id="clientConfigurationCtrl.backupsetId" is-tile-view="true" client-id="clientConfigurationCtrl.clientId"></cv-on-boarding-warning-msg>
		</div>
	</div>
	<div class="col-md-6">
		<!--Infrastructure --START-->
		<cv-tile-component data-title='<cv:msg key="configuration.label.infrastructure.tile" bundle="office365" />'	loader="clientConfigurationCtrl.infrastructureSettingsLoaded && clientConfigurationCtrl.isPlanInfoRetrieved">
			<ul class="list-style-secondary">
				<!--Start --Infrastructure pool set-->
				<div data-ng-if="clientConfigurationCtrl.isInfrastructurePoolConfiguredOnPlan || clientConfigurationCtrl.isOffice365SaaSTenant">
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.o365.serverPlan" bundle="office365"/></span>
						<span class="pageDetailColumn width-60-percentage"><span
									data-ng-bind="clientConfigurationCtrl.planName"></span>
						</span>
					</li>
					<div class="text-muted pageDetailColumn float-right tile-content-link pageDetailColumn width-60-percentage">
							<cv:msg key="label.infrastructureInheritedFromPlan" bundle="exchange" />
					</div>
				</div>
				<!--End --Infrastructure pool set--Tenant-->
			
				<!--Start--Infrastructure MSP-->
				<div data-ng-if="(!clientConfigurationCtrl.isInfrastructurePoolConfiguredOnPlan 
					|| clientConfigurationCtrl.isReadOnlyInfrastructure) && !clientConfigurationCtrl.isOffice365SaaSTenant">
					<!--CLIENT PLAN--START-->
					<li class="group" data-ng-if="clientConfigurationCtrl.showPlan">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.o365.serverPlan" bundle="office365"/></span>
						<span class="pageDetailColumn width-60-percentage">
						<a data-ng-click="clientConfigurationCtrl.gotoPlanDetails()"><span data-ng-bind="clientConfigurationCtrl.planName"></span></a>
							<span class="float-right tile-content-link" data-ng-if="!clientConfigurationCtrl.isReadOnlyInfrastructure">
								<a data-ng-click="clientConfigurationCtrl.editClientPlan(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<li class="group"  data-ng-if="!clientConfigurationCtrl.showPlan">
						<span class="pageDetailColumn margin-top-10 width-40-percentage"><cv:msg key="label.o365.serverPlan" bundle="office365"/></span>
						<span class="pageDetailColumn inline-editor width-60-percentage">
							<cv-plan-summary-dropdown
								data-ng-if="clientConfigurationCtrl.plansLoaded"
								class="full-width"
								input-model="clientConfigurationCtrl.serverPlanList"
								output-model="clientConfigurationCtrl.selectedPlanList"
								button-label="'planName'"
								item-label="'planName'"
								tick-property="'selected'"
								selection-mode="'single'"
								directive-id="'plans'"
								max-labels="1"
								helper-elements="'filter'"
								translation="clientConfigurationCtrl.localLang"
								disable-property="'disabled'"
								on-item-clicked="clientConfigurationCtrl.processServerPlanSelection()">
							</cv-plan-summary-dropdown>
							
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="clientConfigurationCtrl.updateClientPlan()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="clientConfigurationCtrl.editClientPlan(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>
					<!--CLIENT PLAN--END-->

					<!--BACKUP STREAMS--START-->
					<li class="group" data-ng-if="clientConfigurationCtrl.showBackupStreams">
						<span class="pageDetailColumn pageDetailColumn width-40-percentage"><cv:msg key="label.maxStream" bundle="exchange" /></span>
						<span class="pageDetailColumn pageDetailColumn width-60-percentage"><span data-ng-bind="clientConfigurationCtrl.maxBackupStreams"></span>
							<span class="float-right tile-content-link" data-ng-if="!clientConfigurationCtrl.isReadOnlyInfrastructure">
								<a data-ng-click="clientConfigurationCtrl.editBackupStreams(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<li class="group"  data-ng-if="!clientConfigurationCtrl.showBackupStreams">
						<span class="pageDetailColumn margin-top-10 pageDetailColumn width-40-percentage"><cv:msg key="label.maxStream" bundle="exchange"/></span>
						<span class="pageDetailColumn inline-editor pageDetailColumn width-60-percentage">
							<div class="inline-editor-input">
								<input class="full-width" 
									type="number" 
									min="1" 
									step="1"
									id="maxStream"
									required
									data-ng-model="clientConfigurationCtrl.newBackupStreams"/>
							</div>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="clientConfigurationCtrl.updateBackupStreams()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="clientConfigurationCtrl.editBackupStreams(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
						<div class="help-block margin-top-10"
								data-ng-show="!clientConfigurationCtrl.isMaxStreamsInputValid">
							<cv:msg key="help.validstreams" bundle="office365" />
						</div>
					</li>
					<!--BACKUP STREAMS--END-->

					
					<!--INDEX SERVER--START-->
					<li class="group">
						<cv-help-text class="pageDetailColumn pageDetailColumn width-40-percentage" help-label="label.indexServer" help-text="info.indexServer"/>
						<span class="pageDetailColumn pageDetailColumn width-60-percentage"><span data-ng-bind="clientConfigurationCtrl.selectedIndexServer.clientName"></span>
							<span class="float-right tile-content-link" data-ng-if="!clientConfigurationCtrl.isReadOnlyInfrastructure">
								<a data-ng-click="clientConfigurationCtrl.editIndexServer()">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<!--INDEX Server --END-->
					
					<!--ACCESS NODE-->
					<li class="group">				
						<cv-help-text class="pageDetailColumn width-40-percentage" help-label="label.accessNodes" help-text="help.office365Accessnodes"/>
						<span class="pageDetailColumn width-60-percentage">
							<span class="float-right tile-content-link" data-ng-if="!clientConfigurationCtrl.isReadOnlyInfrastructure">
								<a data-ng-click="clientConfigurationCtrl.editInfraStructureSettings(clientConfigurationCtrl.editModes.EDIT_ACCESS_NODES)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
							<label data-ng-bind="clientConfigurationCtrl.allAccessNodes"></label>	
							<span data-ng-if="clientConfigurationCtrl.hasLocalSystemAccount">
								<br>
								<span class="restore-help-text"
									data-toggle="tooltip" title="{{clientConfigurationCtrl._getAccountToAccessSharedPath(true)}}">
									<i class="fa fa-user margin-right-10"></i>
									<label data-ng-bind="clientConfigurationCtrl._getAccountToAccessSharedPath(false)"></label>
								</span>
							</span>
														
							<span data-ng-if="clientConfigurationCtrl.hasJobResultsDirectory()">
								<br>
								<span class="restore-help-text margin-top-5"
									data-toggle="tooltip" title="{{clientConfigurationCtrl._getJobResultsPath(true)}}">
									<i class="fa fa-folder margin-right-10"></i>
									<label data-ng-bind="clientConfigurationCtrl._getJobResultsPath(false)"></label>
								</span>
							</span>																							
						</span>
					</li>
					<li class="group" data-ng-if="clientConfigurationCtrl.associationsLoaded">
						<span class="pageDetailColumn width-40-percentage">
							<cv:msg key="label.clientReadiness" bundle="clients" />
						</span>
						<span data-ng-if="clientConfigurationCtrl.readinessStatus" class="pageDetailColumn client-readiness width-60-percentage">
							<span data-ng-bind="clientConfigurationCtrl.readinessStatus">
							</span>
							<span data-ng-if="clientConfigurationCtrl.clientReadinessLastCheckedText" class="parenthetical-text last-checked"
								data-ng-bind="clientConfigurationCtrl.clientReadinessLastCheckedText">
							</span>
							<a class="float-right tile-content-link" data-ng-click="clientConfigurationCtrl.onClickShowDetailedReport()"
								uib-tooltip="<cv:msg key='label.showDetailedClientReadinessReport' bundle='clients' />"
								tooltip-placement="top">
								<cv:msg key='label.showDetails' bundle='clients' /></a>
							<img class="loader" ng-if="clientConfigurationCtrl.checkReadinessLoading"
								src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
						</span>
						<span data-ng-if="!clientConfigurationCtrl.readinessStatus" class="pageDetailColumn">
							<cv:msg key="label.notAvailable" bundle="servers" />
						</span>
					</li>
				</div>
				<!--End --Infrastructure MSP-->							
			</ul>				
		</cv-tile-component>
		<!--Infrastructure --END-->

		<!--Activity Control --START-->
		<cv-activity-control-component data-ac-params="clientConfigurationCtrl.backupset.acParams"></cv-activity-control-component>
		<!--Activity Control --END-->

		<!--Security --START-->
		<cv-security-component entity-type='clientConfigurationCtrl.backupset.entityType'
								generic-entity = 'clientConfigurationCtrl.backupset.genericEntity'
								associations='clientConfigurationCtrl.backupset.formattedSecurityAssociations'
								associations-loaded="clientConfigurationCtrl.backupset.associationsLoaded"
								show-owners='true'>
		</cv-security-component>
		<!--Security --END-->
				
	</div>
</div>

