<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
</script>

<div>
	<div class="row">
		<div class="col-md-6">
			<cv-tile-component data-title='<cv:msg key="header.general" bundle="exchange" />' >
			<ul class="list-style-secondary">

				<!--SharePoint Tenant URL-->
				<li class="group" data-ng-if="sharepointClassicAppSettingsCtrl.showAzureTenantURL && sharepointClassicAppSettingsCtrl.infraStructureSettings.tenantURL">
					<span class="pageDetailColumn width-40-percentage"> <span><cv:msg key="label.tenantURL" bundle="sharepoint"/></span></span>
					<span class="pageDetailColumn width-60-percentage">
						<span class="margin-right-5" title="{{sharepointClassicAppSettingsCtrl.infraStructureSettings.tenantURL}}" data-ng-bind="sharepointClassicAppSettingsCtrl.infraStructureSettings.tenantURL"></span>
						<span class="float-right tile-content-link" >
							<a data-ng-click="sharepointClassicAppSettingsCtrl.editAzureTenantURL(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>
				<li class="group"  data-ng-if="!sharepointClassicAppSettingsCtrl.showAzureTenantURL">
					<span class="pageDetailColumn width-40-percentage margin-top-10"><cv:msg key="label.tenantURL" bundle="sharepoint"/></span>
					<span class="pageDetailColumn width-60-percentage inline-editor">
						<div class="inline-editor-input">
							<input class="full-width"  type="text" id="sharePointTenantAdminUrl" name="sharePointTenantAdminUrl"
								data-ng-model="sharepointClassicAppSettingsCtrl.inputTenantURL"
								placeholder='<cv:msg key="placeholder.tenantAdminSiteURL" bundle="office365"/>'
								required autofocus />
						</div>
						<span class="inline-editor-buttons">
							<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="sharepointClassicAppSettingsCtrl.updateAzureTenantURL()"><span class="k-icon k-i-check"></span></a>
							<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="sharepointClassicAppSettingsCtrl.editAzureTenantURL(false)"><span class="k-icon k-i-x"></span></a>
						</span>
					</span>
					<div class="help-block margin-top-10"
						data-ng-show="!sharepointClassicAppSettingsCtrl.isAzureTenantURLValid">
						<cv:msg key="error.tenantAdminSiteURL" bundle="clients" />
					</div>
				</li>

				<!--Modern authentication-->
				<li class="group">
					<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.useModernAuthentication" help-text="help.modernAuth"/></span>
					<span class="pageDetailColumn width-60-percentage">
						<toggle-control status="sharepointClassicAppSettingsCtrl.infraStructureSettings.isModernAuthEnabled" data-ng-click="sharepointClassicAppSettingsCtrl.modernAuthToggled()" title='<cv:msg key="label.useModernAuthentication" bundle="office365"/>'></toggle-control>
					</span>
				</li>
				<!--Modern authentication-->

			</ul>
			</cv-tile-component>


			<cv-tile-component data-title='<cv:msg key="label.sharepointConnectionSettings" bundle="office365" />' loader="sharepointClassicAppSettingsCtrl.infraStructureSettings" >

				<ul class="list-style-secondary">
					<li class="group">
						<cv-tabset-component control='sharepointClassicAppSettingsCtrl.tabControls' element="cvtile" >
							<cv-tab tabname='<cv:msg key="label.azureApps" bundle="office365" />'  
							hide-On="!(sharepointClassicAppSettingsCtrl.SPAzureAppsGridOptions && sharepointClassicAppSettingsCtrl.infraStructureSettings.isModernAuthEnabled)">
								<cv-kendo-grid data-cv-grid-options="sharepointClassicAppSettingsCtrl.SPAzureAppsGridOptions"></cv-kendo-grid>
							</cv-tab>
							<cv-tab tabname='<cv:msg key="label.office365ServiceAccts" bundle="exchange" />'>
								<cv-kendo-grid data-cv-grid-options="sharepointClassicAppSettingsCtrl.SPAzureServiceAccountsGridOptions"></cv-kendo-grid>
							</cv-tab>
						</cv-tabset-component>
					<li>
				</ul>
			</cv-tile-component>
		</div>
		<div class="col-md-6">
			<cv-tile-component data-title='<cv:msg key="label.infrastructurePane" bundle="exchange"/>' loader="sharepointClassicAppSettingsCtrl.backupSetDetails">
							
				<ul class="list-style-secondary">
					<!--PLAN-->
						<li class="group" data-ng-if="sharepointClassicAppSettingsCtrl.isSaaSConfigSet && sharepointClassicAppSettingsCtrl.showPlan">
							<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
							<span class="pageDetailColumn width-60-percentage">
								<span data-ng-bind="sharepointClassicAppSettingsCtrl.planName"></span>
								<span class="float-right tile-content-link" data-ng-if="!sharepointClassicAppSettingsCtrl.isOffice365SaaSTenant">
									<a data-ng-click="sharepointClassicAppSettingsCtrl.editServerPlan(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
							</span>
						</li>
						<li class="group"  data-ng-if="!sharepointClassicAppSettingsCtrl.showPlan">
							<span class="pageDetailColumn width-40-percentage margin-top-10"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<cv-plan-summary-dropdown
									class="full-width"
									input-model="sharepointClassicAppSettingsCtrl.serverPlanList"
									output-model="sharepointClassicAppSettingsCtrl.selectedPlanList"
									button-label="'planName'"
									item-label="'planName'"
									tick-property="'selected'"
									selection-mode="'single'"
									directive-id="'plans'"
									max-labels="1"
									helper-elements="'filter'"
									translation="sharepointClassicAppSettingsCtrl.localLang"
									disable-property="'disabled'">
								</cv-plan-summary-dropdown>

								<span class="inline-editor-buttons">
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="sharepointClassicAppSettingsCtrl.updateServerPlan()"><span class="k-icon k-i-check"></span></a>
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="sharepointClassicAppSettingsCtrl.editServerPlan(false)"><span class="k-icon k-i-x"></span></a>
								</span>
							</span>
						</li>
					<!--PLAN-->

					<!--ACCESS NODE-->
					<div data-ng-if="!sharepointClassicAppSettingsCtrl.isOffice365SaaSTenant">
						<li class="group">
							<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.backupClientAccNode" bundle="capps"/></span>
							<span class="pageDetailColumn width-60-percentage"><span data-ng-bind="sharepointClassicAppSettingsCtrl.sharePointClientName"></span>							
						</li>						
					</div>
					<!--ACCESS NODE-->

					<!--Azure Storage ... -->
					<li class="group" data-ng-if="!sharepointClassicAppSettingsCtrl.isOffice365SaaSTenant">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.azureStorageAccount" bundle="office365" /></span>
						<span class="pageDetailColumn width-60-percentage" data-ng-if="sharepointClassicAppSettingsCtrl.infraStructureSettings.azureStorageAccountDetails.userAccount.userName">
							<span data-ng-bind="sharepointClassicAppSettingsCtrl.infraStructureSettings.azureStorageAccountDetails.userAccount.userName"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="sharepointClassicAppSettingsCtrl.openAddEditServiceAccountModal(sharepointClassicAppSettingsCtrl.infraStructureSettings.azureStorageAccountDetails,sharepointClassicAppSettingsCtrl.exchangeConstants.ExchangeAccountTypes.SHAREPOINT_AZURE_STORAGE)"><cv:msg key="label.edit" bundle="clients" /></a>
								<a class="margin-left-10" data-ng-click="sharepointClassicAppSettingsCtrl.deleteAccountConfirmation(sharepointClassicAppSettingsCtrl.infraStructureSettings.azureStorageAccountDetails)"><cv:msg key="label.delete" bundle="ediscovery" /></a>
							</span>
						</span>
						<!--Add new Storage account-->
						<span class="pageDetailColumn width-60-percentage" data-ng-if="!sharepointClassicAppSettingsCtrl.infraStructureSettings.azureStorageAccountDetails.userAccount.userName">
							<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>			
							<a class="float-right tile-content-link" 
								data-ng-click="sharepointClassicAppSettingsCtrl.openAddEditServiceAccountModal('',sharepointClassicAppSettingsCtrl.exchangeConstants.ExchangeAccountTypes.SHAREPOINT_AZURE_STORAGE)"><cv:msg key="label.add" bundle="exchange" /></a>
						</span>
					</li>
					<!--Azure Storage ... -->

					<!--  Check Readiness -->
					<li class="group" data-ng-if="sharepointClassicAppSettingsCtrl.associationsLoaded && !sharepointClassicAppSettingsCtrl.isOffice365SaaSTenant">
						<span class="pageDetailColumn width-40-percentage">
							<cv:msg key="label.clientReadiness" bundle="clients" />
						</span>
						<span class="pageDetailColumn width-60-percentage client-readiness">
							<span data-ng-if="sharepointClassicAppSettingsCtrl.readinessStatus" >
								<span data-ng-bind="sharepointClassicAppSettingsCtrl.readinessStatus"></span>
								<span data-ng-if="sharepointClassicAppSettingsCtrl.clientReadinessLastCheckedText" class="parenthetical-text last-checked" data-ng-bind="sharepointClassicAppSettingsCtrl.clientReadinessLastCheckedText"></span>
							</span>
							<span data-ng-if="!sharepointClassicAppSettingsCtrl.readinessStatus">
								<cv:msg key="label.notAvailable" bundle="servers" />
							</span>	
							<span class="float-right tile-content-link" >
								<a data-ng-click="sharepointClassicAppSettingsCtrl.onClickShowDetailedReport()" uib-tooltip="<cv:msg key='label.showDetailedClientReadinessReport' bundle='clients' />" tooltip-placement="top"><cv:msg key='label.showDetails' bundle='clients' /></a>
							</span>
						</span>
					</li>
					<!--  End Check Readiness -->
				</ul>
			</cv-tile-component>			
				<cv-security-component
					directive-id='sharepointBackupsetSeurityDirective'
					entity-type='sharepointClassicAppSettingsCtrl.entityType'
					generic-entity = 'sharepointClassicAppSettingsCtrl.backupSetEntity'
					associations='sharepointClassicAppSettingsCtrl.formattedSecurityAssociations'
					associations-loaded='sharepointClassicAppSettingsCtrl.associationsLoaded'
					show-owners='true'>
				</cv-security-component>
		</div>
	</div>
</div>
