<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="row margin-top-10">
    <div class="col-md-6">
        <cv-tile-component data-title='<cv:msg key="label.userDetails" bundle="office365" />' loader="office365OneDriveUserDetailsCtrl.userDetails">
            <ul class="list-style__row group" data-ng-if="office365OneDriveUserDetailsCtrl.hasUserData">
                <li class="group">
                    <span class="pageDetailColumn width-40-percentage"><cv:msg key="column.displayName" bundle="office365" /> </span>
                    <span class="pageDetailColumn width-60-percentage" data-ng-bind="office365OneDriveUserDetailsCtrl.userDetails.userAccountInfo.displayName"></span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn width-40-percentage"><cv:msg key="column.email" bundle="office365" /> </span>
                    <span class="pageDetailColumn width-60-percentage" data-ng-bind="office365OneDriveUserDetailsCtrl.userDetails.userAccountInfo.smtpAddress"></span>
                </li> 

                 <li class="group">
                    <span class="pageDetailColumn width-40-percentage"><cv:msg key="column.size" bundle="office365" /> </span>
                    <span class="pageDetailColumn width-60-percentage" 
                        data-ng-bind="office365OneDriveUserDetailsCtrl.userDetails.formattedAccountSize"
                        data-ng-class= "office365OneDriveUserDetailsCtrl.hasLastBackupSize ? '' : 'italic'">
                    </span>
                </li>
                <li class="group" ng-if="office365OneDriveUserDetailsCtrl.userDetails.createdDate">
                    <span class="pageDetailColumn width-40-percentage"><cv:msg key="label.addedToContentOn" bundle="exchange" /></span>
                    <span class="pageDetailColumn width-60-percentage" data-ng-bind="office365OneDriveUserDetailsCtrl.userDetails.createdDate"></span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn width-40-percentage"><cv:msg key="info.lastbackuptime" bundle="office365" /> </span>
                    <span class="pageDetailColumn width-60-percentage" 
                        data-ng-bind="office365OneDriveUserDetailsCtrl.userDetails.formattedLastBackupJobRunTime"
                        data-ng-class= "office365OneDriveUserDetailsCtrl.hasLastBackupTime ? '' : 'italic'">
                    </span>
                </li> 

                <li class="group">
                    <span class="pageDetailColumn width-40-percentage"><cv:msg key="column.numberOfItems" bundle="office365" /> </span>
                    <span class="pageDetailColumn width-60-percentage" 
                        data-ng-class= "office365OneDriveUserDetailsCtrl.hasNumberOfItems ? '' : 'italic'"
                        data-ng-bind="office365OneDriveUserDetailsCtrl.formattedNumberOfItems">
                    </span>
                </li> 

                <li class="group">
                    <span class="pageDetailColumn width-40-percentage"><cv:msg key="label.office365Plan" bundle="office365" /> </span>
                    <span class="pageDetailColumn width-60-percentage" 
                        data-ng-class= "office365OneDriveUserDetailsCtrl.hasPlan ? '' : 'italic'" 
                        data-ng-bind="office365OneDriveUserDetailsCtrl.formattedPlanName">
                    </span>
               </li>             
            </ul>                  
        </cv-tile-component>
    </div>
    <div class="col-md-6" data-ng-if="office365OneDriveUserDetailsCtrl.hasUserData">
        <cv-backup-history entity="office365OneDriveUserDetailsCtrl.backupEntity" 
        show-legend="'true'" params="office365OneDriveUserDetailsCtrl.historyParams"  on-restore="office365OneDriveUserDetailsCtrl.performRestore(job, fromTimeStr, toTimeStr)" ng-if="office365OneDriveUserDetailsCtrl.backupEntity"></cv-backup-history>
    </div>
    <div class="col-md-6" data-ng-if="!office365OneDriveUserDetailsCtrl.hasLastBackupTime">
        <cv-tile-component data-title="{{::office365OneDriveUserDetailsCtrl.calendarTitle}}" data-help-text="{{::office365V2UserDetailsCtrl.params.helpInfo}}">
            <div>
                <span class="server-message" ng-bind-html="'<cv:msg key="No_backups_available" bundle="browse"/>'"></span>
            </div>
            </cv-tile-component>
    </div>
</div>
