<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.events"></cv:cvMessages>
</script>

<div class="row">
	<div class="col-md-6">
		<!--General --START-->
		<cv-tile-component data-title='<cv:msg key="header.general" bundle="exchange" />' loader="office365OneDriveSettingsCtrl.infrastructureSettingsLoaded">
			<ul class="list-style-secondary">
				<!--Cloud Region-->	
				<li class="group">
					<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.office365.cloudregion" bundle="exchange"/></span>
					<span class="pageDetailColumn width-60-percentage" data-ng-bind="office365OneDriveSettingsCtrl.msCloudRegion"></span>
				</li>
				<!--Cloud Region-->	
				<!--Global Admin Account ... On Edit ..open small-window dialog-->
				<li class="group">
					<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.globalAdministrator" help-text="help.globalAdmin"/></span>
					<span class="pageDetailColumn width-60-percentage" data-ng-if="office365OneDriveSettingsCtrl.hasGlobalAdminAccount">
						<span data-ng-bind="office365OneDriveSettingsCtrl.globalAdministrator"></span>						
						<span class="float-right tile-content-link" >
							<a data-ng-click="office365OneDriveSettingsCtrl.editInfraStructureSettings(office365OneDriveSettingsCtrl.editModes.EDIT_GLOBAL_ADMINISTRATOR)"><cv:msg key="label.edit" bundle="clients" /></a>
							<a class="margin-left-10" data-ng-click="office365OneDriveSettingsCtrl._confirmDeleteGlobalAdmin()"><cv:msg key="label.delete" bundle="ediscovery" /></a>		
						</span>
					</span>					
					<!--Add new Global Administrator-->
					<span class="pageDetailColumn width-60-percentage" data-ng-if="!office365OneDriveSettingsCtrl.hasGlobalAdminAccount">
						<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>				
						<span class="float-right tile-content-link" >
							<a data-ng-click="office365OneDriveSettingsCtrl.editInfraStructureSettings(office365OneDriveSettingsCtrl.editModes.EDIT_GLOBAL_ADMINISTRATOR, true)">
								<cv:msg key="label.add" bundle="office365" />
							</a>
						</span>
					</span>
				</li>
				<!--AZURE Directory--START-->
				<!-- <li class="group" data-ng-if="office365OneDriveSettingsCtrl.showAzureDirectoryId">
					<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.azureDirectoryID" bundle="exchange" /></span>
					<span class="pageDetailColumn width-60-percentage"><span data-ng-bind="office365OneDriveSettingsCtrl.azureDirectoryId"></span>
						<span class="float-right tile-content-link" >
							<a data-ng-click="office365OneDriveSettingsCtrl.editAzureDirectoryId(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>
				<li class="group"  data-ng-if="!office365OneDriveSettingsCtrl.showAzureDirectoryId">
					<span class="pageDetailColumn margin-top-10 width-40-percentage"><cv:msg key="label.azureDirectoryID" bundle="exchange"/></span>
					<span class="pageDetailColumn inline-editor width-60-percentage">
						<div class="inline-editor-input">
							<input class="full-width" 
								type="text" 
								id="azureDirectoryId"
								required
								data-ng-model="office365OneDriveSettingsCtrl.newAzureDirectoryId"/>
						</div>
						<span class="inline-editor-buttons">
							<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="office365OneDriveSettingsCtrl.updateAzureDirectoryID()"><span class="k-icon k-i-check"></span></a>
							<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="office365OneDriveSettingsCtrl.editAzureDirectoryId(false)"><span class="k-icon k-i-x"></span></a>
						</span>
					</span>
					<div class="help-block margin-top-10"
						data-ng-show="!office365OneDriveSettingsCtrl.isAzureDirectoryValid">
						<cv:msg key="error.valid.azure.directory" bundle="office365" />
					</div>
				</li> -->
				<!--Azure Directory--END-->
				<!--Discovery Domain--START-->
				<div data-ng-if="office365OneDriveSettingsCtrl.showFilterDiscoveryDomain">
					<li class="group" data-ng-if="office365OneDriveSettingsCtrl.showDiscoveryDomain">
						<span class="pageDetailColumn pageDetailColumn width-40-percentage">
							<cv-help-text help-label="label.onedrive.discovery.domain" help-text="help.onedrive.discovery.domain"/>						
							<span class="optional-text"><cv:msg key="label.optional" bundle="office365" /></span>
						</span>
						<span class="pageDetailColumn width-60-percentage" data-ng-if="office365OneDriveSettingsCtrl.discoveryDomain.length">
							<span data-ng-bind="office365OneDriveSettingsCtrl.discoveryDomain"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="office365OneDriveSettingsCtrl.editDiscoveryDomain(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
								<a class="margin-left-10" data-ng-click="office365OneDriveSettingsCtrl._confirmDeleteDiscoveryDomain()"><cv:msg key="label.delete" bundle="ediscovery" /></a>		
							</span>
						</span>					
						<!--Add new Domain-->
						<span class="pageDetailColumn width-60-percentage" data-ng-if="!office365OneDriveSettingsCtrl.discoveryDomain.length">
							<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>				
							<span class="float-right tile-content-link" >
								<a data-ng-click="office365OneDriveSettingsCtrl.editDiscoveryDomain(true)">
									<cv:msg key="label.add" bundle="office365" />
								</a>
							</span>
						</span>

					</li>
					<li class="group"  data-ng-if="!office365OneDriveSettingsCtrl.showDiscoveryDomain">
						<span class="pageDetailColumn margin-top-10 width-40-percentage"><cv:msg key="label.onedrive.discovery.domain" bundle="office365"/></span>
						<span class="pageDetailColumn inline-editor width-60-percentage">
							<div class="inline-editor-input">
								<input class="full-width" 
									type="text" 
									id="discoveryDomain"
									required
									data-ng-model="office365OneDriveSettingsCtrl.newDiscoveryDomain"/>
							</div>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="office365OneDriveSettingsCtrl.updateDiscoveryDomain(false)"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="office365OneDriveSettingsCtrl.editDiscoveryDomain(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
						<div class="help-block margin-top-10"
							data-ng-show="!office365OneDriveSettingsCtrl.isDiscoveryDomainValid">
							<cv:msg key="error.valid.discovery.domain" bundle="office365" />
						</div>
					</li>
				</div>
				<!--Discovery Domain--END-->
				<!--Modern authentication-->	
				<li class="group">
					<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.useModernAuthentication" help-text="help.modernAuth"/></span>
					<span class="pageDetailColumn width-60-percentage">
						<toggle-control status="true" data-ng-click="office365OneDriveSettingsCtrl.showModernAuthInfo()"></toggle-control>
					</span>
				</li>
				<!--Modern authentication-->				
			</ul>
		</cv-tile-component>
		<!--General --END-->

		<!--Connections --START-->		
		<cv-tile-component data-title='<cv:msg key="configuration.label.onedrive.connection.tile" bundle="office365" />' loader="office365OneDriveSettingsCtrl.infrastructureSettingsLoaded">
			<div class="page-details-box-links margin-top-30">
				<a data-ng-if="office365OneDriveSettingsCtrl.hasAzureAppsConfigured" data-ng-click="office365OneDriveSettingsCtrl._azureAppsCheckReadiness()">
					<cv:msg key="action.verifyConnection" bundle="office365" /> </a>
				<a data-ng-click="office365OneDriveSettingsCtrl._addAzureApp()">
					<cv:msg key="dialog.azureapp.title" bundle="office365" /> </a>
			</div>
			<ul class="list-style-secondary margin-top-15">
				<li class="group o365-app-grid">
					<cv-kendo-grid data-cv-grid-options="office365OneDriveSettingsCtrl.azureAppsGridOptions"></cv-kendo-grid>		
				</li>
			</ul>			
		</cv-tile-component>
		<!--Connections --END-->

		<cv-on-boarding-warning-msg backupset-id="office365OneDriveSettingsCtrl.backupsetId" client-id="office365OneDriveSettingsCtrl.clientId" is-tile-view="true"></cv-on-boarding-warning-msg>

	</div>
	<div class="col-md-6">
		<!--Infrastructure --START-->
		<cv-tile-component data-title='<cv:msg key="configuration.label.infrastructure.tile" bundle="office365" />'	loader="office365OneDriveSettingsCtrl.infrastructureSettingsLoaded">
			<ul class="list-style-secondary">
				<!--Start --Infrastructure pool set-->
				<div data-ng-if="office365OneDriveSettingsCtrl.isInfrastructurePoolConfiguredOnPlan || office365OneDriveSettingsCtrl.isOffice365SaaSTenant">
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.o365.serverPlan" bundle="office365"/></span>
						<span class="pageDetailColumn width-60-percentage"><span
									data-ng-bind="office365OneDriveSettingsCtrl.planName"></span>
						</span>
					</li>
					<div class="text-muted pageDetailColumn float-right tile-content-link pageDetailColumn width-60-percentage">
							<cv:msg key="label.infrastructureInheritedFromPlan" bundle="exchange" />
					</div>
				</div>
				<!--End --Infrastructure pool set--Tenant-->
			
				<!--Start--Infrastructure MSP-->
				<div data-ng-if="(!office365OneDriveSettingsCtrl.isInfrastructurePoolConfiguredOnPlan 
					|| office365OneDriveSettingsCtrl.isReadOnlyInfrastructure) && !office365OneDriveSettingsCtrl.isOffice365SaaSTenant">
					<!--CLIENT PLAN--START-->
					<li class="group" data-ng-if="office365OneDriveSettingsCtrl.showPlan">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.o365.serverPlan" bundle="office365"/></span>
						<span class="pageDetailColumn width-60-percentage">
						<a data-ng-click="office365OneDriveSettingsCtrl.gotoPlanDetails()"><span data-ng-bind="office365OneDriveSettingsCtrl.planName"></span></a>
							<span class="float-right tile-content-link" data-ng-if="!office365OneDriveSettingsCtrl.isReadOnlyInfrastructure">
								<a data-ng-click="office365OneDriveSettingsCtrl.editClientPlan(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<li class="group"  data-ng-if="!office365OneDriveSettingsCtrl.showPlan">
						<span class="pageDetailColumn margin-top-10 width-40-percentage"><cv:msg key="label.o365.serverPlan" bundle="office365"/></span>
						<span class="pageDetailColumn inline-editor width-60-percentage">
							<cv-plan-summary-dropdown
								data-ng-if="office365OneDriveSettingsCtrl.plansLoaded"
								class="full-width"
								input-model="office365OneDriveSettingsCtrl.serverPlanList"
								output-model="office365OneDriveSettingsCtrl.selectedPlanList"
								button-label="'planName'"
								item-label="'planName'"
								tick-property="'selected'"
								selection-mode="'single'"
								directive-id="'plans'"
								max-labels="1"
								helper-elements="'filter'"
								translation="office365OneDriveSettingsCtrl.localLang"
								disable-property="'disabled'"
								on-item-clicked="office365OneDriveSettingsCtrl.processServerPlanSelection()">
							</cv-plan-summary-dropdown>
							
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="office365OneDriveSettingsCtrl.updateClientPlan()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="office365OneDriveSettingsCtrl.editClientPlan(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>
					<!--CLIENT PLAN--END-->

					<!--BACKUP STREAMS--START-->
					<li class="group" data-ng-if="office365OneDriveSettingsCtrl.showBackupStreams">
						<span class="pageDetailColumn pageDetailColumn width-40-percentage"><cv:msg key="label.maxStream" bundle="exchange" /></span>
						<span class="pageDetailColumn pageDetailColumn width-60-percentage"><span data-ng-bind="office365OneDriveSettingsCtrl.maxBackupStreams"></span>
							<span class="float-right tile-content-link" data-ng-if="!office365OneDriveSettingsCtrl.isReadOnlyInfrastructure">
								<a data-ng-click="office365OneDriveSettingsCtrl.editBackupStreams(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<li class="group"  data-ng-if="!office365OneDriveSettingsCtrl.showBackupStreams">
						<span class="pageDetailColumn margin-top-10 pageDetailColumn width-40-percentage"><cv:msg key="label.maxStream" bundle="exchange"/></span>
						<span class="pageDetailColumn inline-editor pageDetailColumn width-60-percentage">
							<div class="inline-editor-input">
								<input class="full-width" 
									type="number" 
									min="1" 
									step="1"
									id="maxStream"
									required
									data-ng-model="office365OneDriveSettingsCtrl.newBackupStreams"/>
							</div>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="office365OneDriveSettingsCtrl.updateBackupStreams()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="office365OneDriveSettingsCtrl.editBackupStreams(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
						<div class="help-block margin-top-10"
								data-ng-show="!office365OneDriveSettingsCtrl.isMaxStreamsInputValid">
							<cv:msg key="help.validstreams" bundle="office365" />
						</div>
					</li>
					<!--BACKUP STREAMS--END-->

					
					<!--INDEX SERVER--START-->
					<li class="group">
						<cv-help-text class="pageDetailColumn pageDetailColumn width-40-percentage" help-label="label.indexServer" help-text="info.indexServer"/>
						<span class="pageDetailColumn pageDetailColumn width-60-percentage"><span data-ng-bind="office365OneDriveSettingsCtrl.selectedIndexServer.clientName"></span>
							<span class="float-right tile-content-link" data-ng-if="!office365OneDriveSettingsCtrl.isReadOnlyInfrastructure">
								<a data-ng-click="office365OneDriveSettingsCtrl.editIndexServer()">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<!--INDEX Server --END-->
					
						<!--ACCESS NODE-->
					<li class="group">				
						<cv-help-text class="pageDetailColumn width-40-percentage" help-label="label.accessNodes" help-text="help.office365Accessnodes"/>
						<span class="pageDetailColumn width-60-percentage">
							<span class="float-right tile-content-link" data-ng-if="!office365OneDriveSettingsCtrl.isReadOnlyInfrastructure">
								<a data-ng-click="office365OneDriveSettingsCtrl.editInfraStructureSettings(office365OneDriveSettingsCtrl.editModes.EDIT_ACCESS_NODES)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
							<label data-ng-bind="office365OneDriveSettingsCtrl.allAccessNodes"></label>	
							<span data-ng-if="office365OneDriveSettingsCtrl.hasLocalSystemAccount">
								<br>
								<span class="restore-help-text"
									data-toggle="tooltip" title="{{office365OneDriveSettingsCtrl._getAccountToAccessSharedPath(true)}}">
									<i class="fa fa-user margin-right-10"></i>
									<label data-ng-bind="office365OneDriveSettingsCtrl._getAccountToAccessSharedPath(false)"></label>
								</span>
							</span>
														
							<span data-ng-if="office365OneDriveSettingsCtrl.hasJobResultsDirectory()">
								<br>
								<span class="restore-help-text margin-top-5"
									data-toggle="tooltip" title="{{office365OneDriveSettingsCtrl._getJobResultsPath(true)}}">
									<i class="fa fa-folder margin-right-10"></i>
									<label data-ng-bind="office365OneDriveSettingsCtrl._getJobResultsPath(false)"></label>
								</span>
							</span>																							
						</span>
					</li>
					<li class="group" data-ng-if="office365OneDriveSettingsCtrl.associationsLoaded">
						<span class="pageDetailColumn width-40-percentage">
							<cv:msg key="label.clientReadiness" bundle="clients" />
						</span>
						<span data-ng-if="office365OneDriveSettingsCtrl.readinessStatus" class="pageDetailColumn client-readiness width-60-percentage">
							<span data-ng-bind="office365OneDriveSettingsCtrl.readinessStatus">
							</span>
							<span data-ng-if="office365OneDriveSettingsCtrl.clientReadinessLastCheckedText" class="parenthetical-text last-checked"
								data-ng-bind="office365OneDriveSettingsCtrl.clientReadinessLastCheckedText">
							</span>
							<a class="float-right tile-content-link" data-ng-click="office365OneDriveSettingsCtrl.onClickShowDetailedReport()"
								uib-tooltip="<cv:msg key='label.showDetailedClientReadinessReport' bundle='clients' />"
								tooltip-placement="top">
								<cv:msg key='label.showDetails' bundle='clients' /></a>
							<img class="loader" ng-if="office365OneDriveSettingsCtrl.checkReadinessLoading"
								src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
						</span>
						<span data-ng-if="!office365OneDriveSettingsCtrl.readinessStatus" class="pageDetailColumn">
							<cv:msg key="label.notAvailable" bundle="servers" />
						</span>
					</li>
				</div>
				<!--End --Infrastructure MSP-->							
			</ul>				
		</cv-tile-component>
		<!--Infrastructure --END-->

		<!--Activity Control --START-->
		<cv-activity-control-component data-ac-params="office365OneDriveSettingsCtrl.backupset.acParams"></cv-activity-control-component>
		<!--Activity Control --END-->

		<!--Security --START-->
		<cv-security-component entity-type='office365OneDriveSettingsCtrl.backupset.entityType'
								generic-entity = 'office365OneDriveSettingsCtrl.backupset.genericEntity'
								associations='office365OneDriveSettingsCtrl.backupset.formattedSecurityAssociations'
								associations-loaded="office365OneDriveSettingsCtrl.backupset.associationsLoaded"
								show-owners='true'>
		</cv-security-component>
		<!--Security --END-->			
	</div>
</div>

