<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>

<form
	class="bootstrap-wrapper form-horizontal"
	data-cv-submit="oneDriveInfraStructureSettingsCtrl.saveInfo()"
	name="editInfrastructureSettingsForm"
	id="editInfrastructureSettingsForm"
	novalidate
	cv-hide-api
	autocomplete="off"
>
	<div class="modal-header">
		<h1 data-ng-bind="oneDriveInfraStructureSettingsCtrl.title"></h1>
	</div>
	<div class="modal-body no-padding">	
		<!--Edit Global Administrator -- Start -->
		<div
			data-ng-if="oneDriveInfraStructureSettingsCtrl.editMode === oneDriveInfraStructureSettingsCtrl.infrastructureEditModes.EDIT_GLOBAL_ADMINISTRATOR">
			<div class="form-group margin-left-10 margin-right-10 margin-top-10">
				<cv-help-text class="col-xs-12 col-lg-4 margin-top-10" help-label="label.globalAdministrator" help-text="help.globalAdmin"/>
				<div class="col-xs-12 col-lg-8">
					<input type="email" id="globalAdministrator" name="globalAdministrator" required
						data-ng-model="oneDriveInfraStructureSettingsCtrl.globalAdministratorServiceAccount.AdminSmtpAddress"
						data-ng-required="oneDriveInfraStructureSettingsCtrl.addNewGlobalAdministrator"
						placeholder='<cv:msg key="label.emailAddressPlaceholder" bundle="exchange"></cv:msg>' />
					<div class="help-block"
						data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.globalAdministrator)">
						<cv:msg key="error.noEmail" bundle="exchange" />
					</div>
				</div>
			</div>
	
			<div class="form-group margin-left-10 margin-right-10">
				<label class="col-xs-12 col-lg-4" for="password">
					<cv:msg key="label.password" bundle="exchange" /></label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" name="password" id="password"
					data-ng-model="oneDriveInfraStructureSettingsCtrl.globalAdministratorServiceAccount.userAccount.password"
						placeholder='{{!oneDriveInfraStructureSettingsCtrl.addNewGlobalAdministrator?"<cv:msg
				key="label.passwordKeep" bundle="settings" />":""}}' 
					data-ng-required="oneDriveInfraStructureSettingsCtrl.addNewGlobalAdministrator" />
					<div class="help-block"
						data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.password)">
						<cv:msg key="error.noPassword" bundle="exchange" />
					</div>
				</div>
			</div>
	
			<div class="form-group margin-left-10 margin-right-10">
				<label class="col-xs-12 col-lg-4" for="confirmPassword">
					<cv:msg key="label.confirmPassword" bundle="exchange" /></label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" name="confirmPassword" id="confirmPassword"
						data-ng-model="oneDriveInfraStructureSettingsCtrl.globalAdministratorServiceAccount.userAccount.confirmPassword"
						placeholder='{{!oneDriveInfraStructureSettingsCtrl.addNewGlobalAdministrator?"<cv:msg key="label.passwordKeep" bundle="settings" />":""}}'
						data-cv-equals="{{oneDriveInfraStructureSettingsCtrl.globalAdministratorServiceAccount.userAccount.password}}"
						data-ng-required="oneDriveInfraStructureSettingsCtrl.addNewGlobalAdministrator" />
					<div class="help-block"
						data-ng-show="editInfrastructureSettingsForm.confirmPassword.$error.required && cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.confirmPassword)">
						<cv:msg key="error.noConfirmPassword" bundle="exchange" />
					</div>
					<div class="help-block"
						data-ng-show="!editInfrastructureSettingsForm.confirmPassword.$error.required && editInfrastructureSettingsForm.confirmPassword.$error.cvEquals && cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.confirmPassword)">
						<cv:msg key="error.mismatchedPassword" bundle="exchange" />
					</div>
				</div>
			</div>
		</div>
		<!--Edit Global Administrator -- End -->

		<!--Edit Access Nodes and LSA -- START -->
		<div data-ng-if="oneDriveInfraStructureSettingsCtrl.editMode ===  oneDriveInfraStructureSettingsCtrl.infrastructureEditModes.EDIT_ACCESS_NODES"> 
			<div class="form-group margin-left-10 margin-right-10 margin-top-10">
				<label class="col-xs-12 col-md-4"><cv:msg
						key="label.accessNodes" bundle="exchange" /></label>
				<div class="col-xs-12 col-md-8">
					<isteven-multi-select
						input-model="oneDriveInfraStructureSettingsCtrl.office365AccessNodesList"
						output-model="oneDriveInfraStructureSettingsCtrl.selectedAccessNodesList"
						button-label="displayName"
						item-label="displayName"
						tick-property="selected"
						class="isteven-multi-select user-group-select"
						id="accessNodes"
						name="accessNodes"
						helper-elements="reset filter"
						max-labels="3"
						translation="oneDriveInfraStructureSettingsCtrl.localLang"
						on-reset="oneDriveInfraStructureSettingsCtrl.processAccessNodeSelection()"
						on-item-click="oneDriveInfraStructureSettingsCtrl.processAccessNodeSelection()"
						group-property="msGroup">
					</isteven-multi-select>
					<span data-ng-if="editInfrastructureSettingsForm.$submitted" class="help-block"
						data-ng-show="!oneDriveInfraStructureSettingsCtrl.selectedAccessNodesList.length">
					<cv:msg key="error.selectNodes" bundle="exchange" />
					</span>
				</div>
			</div>
			<div data-ng-if="oneDriveInfraStructureSettingsCtrl.selectedAccessNodesList.length > 1 || 
							oneDriveInfraStructureSettingsCtrl.jobResulsDirectory.path || 
							oneDriveInfraStructureSettingsCtrl.isClientGroupSelected ||
							oneDriveInfraStructureSettingsCtrl.requiresJobResultsDirectory">		
				<div class="form-group margin-left-10 margin-right-10">
					<label class="col-xs-12 col-md-4"><cv:msg key="label.jobResultsDirectory" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-8">
						<input type="text" id="jobResultsDirectory" name="jobResultsDirectory" required
								data-ng-pattern="oneDriveInfraStructureSettingsCtrl.REGEX.WINDOWS_NETWORK_PATH"
								data-ng-model="oneDriveInfraStructureSettingsCtrl.jobResulsDirectory.path" />
						<div class="help-block"
								data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.jobResultsDirectory) &&  !editInfrastructureSettingsForm.jobResultsDirectory.$error.pattern">
							<cv:msg key="error.noJobResultsDirectory" bundle="exchange" />
						</div>
						<div class="help-block"
							data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.jobResultsDirectory) &&  editInfrastructureSettingsForm.jobResultsDirectory.$error.pattern ">
							<cv:msg key="error.invalidNetworkPath" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="plain-accordion margin-top-10">
					<div class="cv-accordion-header">
						<span class="cv-accordion-text"><cv:msg key="label.sharePathAccount" bundle="exchange" /></span>
					</div>
				</div>
				<div class="form-group margin-top-10 margin-left-10 margin-right-10">
					<label class="col-xs-12 col-md-4"><cv:msg key="label.userName" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-8">
						<input type="text" name="username" id="username" required
						data-ng-model="oneDriveInfraStructureSettingsCtrl.localSystemAdministratorServiceAccount.userAccount.userName"/>
						<div class="help-block"
							data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.username)">
							<cv:msg key="error.userName" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="form-group margin-left-10 margin-right-10">
					<label class="col-xs-12 col-lg-4" for="password"><cv:msg key="label.password" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" name="password" id="password" 
						placeholder='{{!oneDriveInfraStructureSettingsCtrl.requirePassword?"<cv:msg key="label.passwordKeep" bundle="settings" />":""}}'
						data-ng-model="oneDriveInfraStructureSettingsCtrl.localSystemAdministratorServiceAccount.userAccount.password" 
						data-ng-required="oneDriveInfraStructureSettingsCtrl.requirePassword"/>
						<div class="help-block"
							data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.password)">
							<cv:msg key="error.password" bundle="exchange" />
						</div>                            
					</div>
				</div>
				<div class="form-group margin-left-10 margin-right-10">
					<label class="col-xs-12 col-lg-4" for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" name="confirmPassword" id="confirmPassword"
							placeholder='{{!oneDriveInfraStructureSettingsCtrl.requirePassword?"<cv:msg key="label.passwordKeep" bundle="settings" />":""}}'
							data-ng-model="oneDriveInfraStructureSettingsCtrl.localSystemAdministratorServiceAccount.userAccount.confirmPassword"
							data-cv-equals="{{oneDriveInfraStructureSettingsCtrl.localSystemAdministratorServiceAccount.userAccount.password}}"
							data-ng-required="oneDriveInfraStructureSettingsCtrl.requirePassword" />
						<div class="help-block"
							data-ng-show="editInfrastructureSettingsForm.confirmPassword.$error.cvEquals && cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.confirmPassword)">
							<cv:msg key="error.mismatchedPassword" bundle="exchange" />
						</div>
						<div class="help-block"
							data-ng-show="!editInfrastructureSettingsForm.confirmPassword.$error.cvEquals && cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.confirmPassword)">
							<cv:msg key="error.noConfirmPassword" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="form-group margin-top-10 margin-bottom-10 margin-left-10 margin-right-10">    
					<div class="col-xs-12 col-md-12">
						<!--Progress stepper--START-->
						<cv-progress-stepper
							data-ng-if="oneDriveInfraStructureSettingsCtrl.showStepper"
							input-model="oneDriveInfraStructureSettingsCtrl.progressStepperModel" 
							progress="oneDriveInfraStructureSettingsCtrl.progress">
						</cv-progress-stepper>
						<!--Progress stepper--END-->
						<div class="margin-left-20 margin-right-20">
							<div class="row" data-ng-if="oneDriveInfraStructureSettingsCtrl.moveJobResultsDirectoryError.length">
								<div class="help-block margin-top-20"> 
									<label data-ng-bind="oneDriveInfraStructureSettingsCtrl.moveJobResultsDirectoryError"></label> 
								</div>
							</div>

							<div data-ng-if="oneDriveInfraStructureSettingsCtrl.showJobResultsOverride" class="row margin-top-20 italic text-align-left">
								<cv:msg key="confirm.jobResultsOverride" bundle="office365" />
								<a class="margin-left-5" data-ng-click="oneDriveInfraStructureSettingsCtrl.overrideJobResultsStep(true)">
									<cv:msg key="button.yes" bundle="messages"></cv:msg>
								</a>
								<a class="margin-left-5" data-ng-click="oneDriveInfraStructureSettingsCtrl.overrideJobResultsStep(false)">
									<cv:msg key="button.no" bundle="messages"></cv:msg>
								</a>
							</div>
							<div data-ng-if="oneDriveInfraStructureSettingsCtrl.showJobResultsWarning" class="row plain-accordion float-left margin-top-10">
								<div class="cv-accordion-header input-group">
									<span class="padding-15 k-icon k-i-warning red-font fa-2x"></span>
									<div class="cv-accordion-header text-align-left">
										<cv:msg key="warning.jobResultsOverride" bundle="office365" />
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--Edit Access Nodes and LSA -- END -->

		<!--Edit Azure App -- OneDrive Classic -- START -->
		<div data-ng-if="oneDriveInfraStructureSettingsCtrl.editMode ===  oneDriveInfraStructureSettingsCtrl.infrastructureEditModes.ADD_APP_CLASSIC_MODE"> 
			<!--Client ID -->
			<div class="form-group">
				<label class="col-xs-12 col-md-4" for="odClientId"><cv:msg key="label.onedrive.clientId" bundle="capps" /></label>
				<div class="col-xs-12 col-md-8">
					<input type="text" id="odClientId" name="odClientId" required data-ng-model="oneDriveInfraStructureSettingsCtrl.oneDriveClassicAppObj.clientId" required />
					<span class="help-block" data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.odClientId)"><cv:msg key="error.onedrive.clientId" bundle="capps" /></span>							
				</div>
			</div>
			
			<!--Client Secret -->
			<div class="form-group">
				<label class="col-xs-12 col-md-4" for="clientSecret"><cv:msg key="label.onedrive.clientSecret" bundle="capps" /></label>
				<div class="col-xs-12 col-md-8">
					<input type="password" id="clientSecret" name="clientSecret" required data-ng-model="oneDriveInfraStructureSettingsCtrl.oneDriveClassicAppObj.clientSecret" required />
					<span class="help-block" data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.clientSecret)"><cv:msg key="error.onedrive.clientSecret" bundle="capps" /></span>
				</div>
			</div>
		</div>
		<!--Edit Azure App -- OneDrive Classic -- END -->

		
	</div>

	<div class="modal-footer margin-top-30">
		<button id="closeBtn" type="button" class="btn btn-default cvBusyOnAjax"
			data-ng-if="oneDriveInfraStructureSettingsCtrl.showCloseButton"
			data-ng-disabled="!oneDriveInfraStructureSettingsCtrl.enableCloseButton"
			data-ng-click="oneDriveInfraStructureSettingsCtrl._closeModal()">
			<cv:msg key="label.close" bundle="messagesJs" />
		</button>
		<button id="cancelBtn" type="button" class="btn btn-default cvBusyOnAjax" 
			data-ng-if="!oneDriveInfraStructureSettingsCtrl.showCloseButton"
			data-ng-click="oneDriveInfraStructureSettingsCtrl.cancel()">
			<cv:msg key="action.cancel" bundle="profiles" />
		</button>
		<button id="submitBtn" type="submit" class="btn btn-primary cvBusyOnAjax"
			data-ng-if="!oneDriveInfraStructureSettingsCtrl.showCloseButton">
			<cv:msg key="action.save" bundle="profiles" />
		</button>
	</div>
</form>

