<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="setup-content database-plan-content" data-ng-controller="office365PushInstallController as office365pushCtrl">
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1>
			<span>{{office365pushCtrl.dialogTitle}}<cv-help-component data-help-text="{{office365pushCtrl.dialogTitleHelpText}}"></cv-help-component></span>
		</h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="col-md-12">
			<div class="{{office365pushCtrl.serverMessage.type}} serverMessage">{{office365pushCtrl.serverMessage.message}}</div>
		</div>
		<form class="form-horizontal" data-cv-submit="office365pushCtrl.installSoftware()" novalidate name="addOffice365PackageForm" autocomplete="off">
			<div class="panel panel-default">
				<!-- The ruling radio buttons. Further page depends on these buttons -->
				<!-- // Radio for Custom and default // -->
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="office365InstallModeDefault"><cv:msg key="label.office365.installMode" bundle="office365"/></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="col-xs-12 col-md-4 col-lg-4">
							<label for="office365InstallModeDefault">
								<input id="office365InstallModeDefault" name="office365InstallMode" value="DEFAULT" class="" type="radio" data-ng-model="office365pushCtrl.office365InstallMode"/>
								<span class="block-indent"><cv:msg key="label.office365InstallMode.default" bundle="office365"/></span>
							</label>
						</div>
						<div class="col-xs-12 col-md-4 col-lg-4">
							<label for="office365InstallModeCustom">
								<input id="office365InstallModeCustom" name="office365InstallMode" value="CUSTOM" class="" type="radio" data-ng-model="office365pushCtrl.office365InstallMode"/>
								<span class="block-indent"><cv:msg key="label.office365InstallMode.custom" bundle="office365"/></span>
							</label>
						</div>
					</div>
				</div>
				<br/>
				<!-- // End of Radio for Custom and default // -->
				<!-- // default section starts // -->
				<uib-accordion close-others="true" class="text-left">
					 <div uib-accordion-group is-open="office365pushCtrl.office365defaultModeOpenState" >
						 <uib-accordion-heading>
					        <cv:msg key="label.office365.defaultInstallation" bundle="office365" /><i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': office365pushCtrl.office365defaultModeOpenState, 'glyphicon-chevron-right': !office365pushCtrl.office365defaultModeOpenState}"></i>
					      </uib-accordion-heading>
					      <!-- Hostname -->
					      <div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="office365PackHostName"><cv:msg key="label.hostName" bundle="serversJs"/></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<textarea name="office365PackHostName" placeholder="<cv:msg key='info.hostNamePlaceholder' bundle='serversJs'/>" id="office365PackHostName"
										data-ng-model="office365pushCtrl.model.office365clientInfo.hostName" required
										data-ng-class="{'has-error': cv.addOffice365PackageForm.needsAttention(addOffice365PackageForm.office365PackHostName)}"></textarea>
									<span class="cv-help-block" data-ng-show="cv.addOffice365PackageForm.needsAttention(addOffice365PackageForm.office365PackHostName) || showError">
										<cv:msg key="error.hostName" bundle="serversJs" /></span>
								</div>
							</div>
						  <!-- End Hostname -->
						  <!-- Username -->
						   <div class="form-group">
						   		<label class="col-xs-12 col-md-4 col-lg-4" for="office365PackUsername"><cv:msg key="label.userName" bundle="serversJs" />
									<cv-help-component help-text="{{office365pushCtrl.usernameHelpText}}"></cv-help-component>
								</label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input id="office365PackUsername" type="text" name="office365PackUsername" data-ng-model="office365pushCtrl.model.office365clientInfo.userName"
											required autoCompleteType="disable" autocomplete="off" placeholder="{{office365pushCtrl.usernameHelpText}}"/>
									<span class="cv-help-block" data-ng-show="cv.addOffice365PackageForm.needsAttention(addOffice365PackageForm.office365PackUsername) || showError">
										<cv:msg key="error.userName" bundle="servers" />
									</span>
								</div>
						   </div>
						   <!-- Username end-->
							<!-- Password -->
							 <div class="form-group">
							 	<label class="col-xs-12 col-md-4 col-lg-4" for="office365Password"><cv:msg key="label.password" bundle="servers" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input id="office365Password" type="password" name="office365Password" data-ng-model="office365pushCtrl.model.office365clientInfo.password"
										   required autoCompleteType="disable" autocomplete="off"/>
									<span class="cv-help-block" data-ng-show="cv.addOffice365PackageForm.needsAttention(addOffice365PackageForm.office365Password) || showError">
										<cv:msg key="error.password" bundle="servers" />
									</span>
								</div>
							 </div>
							<!-- Password End -->
					</div>
				</uib-accordion>
				<!-- // default section ends // -->
				<!-- // custom section starts // -->
				<div data-ng-show="office365pushCtrl.office365InstallMode === 'CUSTOM'">
					<uib-accordion close-others="true" class="text-left">
						<div uib-accordion-group is-open="office365pushCtrl.office365customModeOpenState" >
							<uib-accordion-heading>
					        <cv:msg key="label.office365.customInstallation" bundle="office365" /><i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': office365pushCtrl.office365customModeOpenState, 'glyphicon-chevron-right': !office365pushCtrl.office365customModeOpenState}"></i>
					      	</uib-accordion-heading>
					      	 <!-- Hostname -->
					      	<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="advIndexPackHostName"><cv:msg key="label.hostName" bundle="serversJs"/></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<textarea name="advIndexPackHostName" placeholder="<cv:msg key='info.hostNamePlaceholder' bundle='serversJs'/>"
											  id="advIndexPackHostName" data-ng-model="office365pushCtrl.model.advIndexClientInfo.hostName"
											  data-ng-required="office365pushCtrl.office365InstallMode === 'CUSTOM'"
											  data-ng-class="{'has-error': cv.addOffice365PackageForm.needsAttention(addOffice365PackageForm.advIndexPackHostName)}"></textarea>
									<span class="cv-help-block" data-ng-show="cv.addOffice365PackageForm.needsAttention(addOffice365PackageForm.advIndexPackHostName) || showError"><cv:msg key="error.hostName" bundle="serversJs" /></span>
								</div>
					      	</div>
					      	<!-- Hostname end -->
					      	<!-- Username -->
					      	<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="advIndexPackUsername"><cv:msg key="label.userName" bundle="serversJs" />
									<cv-help-component help-text="{{office365pushCtrl.usernameHelpText}}"></cv-help-component>
								</label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input id="advIndexPackUsername" type="text" name="advIndexPackUsername" data-ng-model="office365pushCtrl.model.advIndexClientInfo.userName"
											data-ng-required="office365pushCtrl.office365InstallMode === 'CUSTOM'"
											autoCompleteType="disable" autocomplete="off" placeholder="{{office365pushCtrl.usernameHelpText}}"/>
									<span class="cv-help-block" data-ng-show="cv.addOffice365PackageForm.needsAttention(addOffice365PackageForm.advIndexPackUsername) || showError">
											<cv:msg key="error.userName" bundle="servers" />
									</span>
								</div>
							</div>
					      	<!-- Username end -->
					      	<!-- Password -->
					      	<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="advIndexPackPassword"><cv:msg key="label.password" bundle="servers" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="password" id="advIndexPackPassword" name="advIndexPackPassword" data-ng-model="office365pushCtrl.model.advIndexClientInfo.password"
											data-ng-required="office365pushCtrl.office365InstallMode === 'CUSTOM'" autoCompleteType="disable" autocomplete="off"/>
									<span class="cv-help-block" data-ng-show="cv.addOffice365PackageForm.needsAttention(addOffice365PackageForm.advIndexPackPassword) || showError">
											<cv:msg key="error.password" bundle="servers" />
									</span>
								</div>
							</div>
					      	<!-- Password end -->
						</div>
					</uib-accordion>
				</div>
				<!-- // custom section ends // -->
			</div>
			<div class="button-container">
				<button id="office365PushInstall_button_#1049" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="office365pushCtrl.cancel()"><cv:msg key="Cancel" /></button> 
				<button id="office365PushInstall_button_#1469" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					<span><cv:msg key="label.install" bundle="servers"/></span>
				</button>
			</div>
		</form>
	</div>
</div>
