<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>

<script type="text/ng-template" id="customPopupTemplate.html">
	<a class="custodianSuggestText">
		<span ng-bind-html="match.label | uibTypeaheadHighlight:query" class="crop"></span> 
	</a>
 </script>

<form
	class="bootstrap-wrapper"
	data-cv-submit="office365RestoreOptionsCtrl._validateInputsForRestoreJob()"
	name="office365RestoreOptionsForm"
	id="office365RestoreOptionsForm"
	novalidate
	autocomplete="off"
>
	<div class="modal-header">
		<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<!--End --Modal Header-->
	<!--User fixed height-->
	<div class="modal-body-fixed no-padding">		
       
        <div class="form-group row margin-top-10 margin-left-5 margin-right-5">
            <label class="col-xs-12 col-md-4" for="restoreDestination"><cv:msg
                    key="label.restoreoptions.restoreRestination" bundle="office365" /></label>
			<div class="col-xs-12 col-md-8" data-ng-disabled="office365RestoreOptionsCtrl.disableRestoreDestination">
                <isteven-multi-select
                    id="restoreDestinationSummaryDropdown"
                    name="restoreDestinationSummaryDropdown"
                    class="isteven-multi-select user-group-select isteven-summary-dropdown"
                    html-template="true"
                    input-model="office365RestoreOptionsCtrl.restoreDestinationList"
                    output-model="office365RestoreOptionsCtrl.selectedRestoreDestination"
                    item-label="template"
                    selection-mode="single"
                    disable-property="disabled"
                    button-label="destination"
                    max-labels="1"
                    helper-elements="filter"
                    tick-property="selected"           
                    on-item-click="office365RestoreOptionsCtrl.processRestoreDestinationSelectionChange()"
                    translation="office365RestoreOptionsCtrl.localLang ">
                </isteven-multi-select>             	               
            </div>
        </div>
		<cv-on-boarding-warning-msg backupset-id="office365RestoreOptionsCtrl.restoreOptions.entity.backupsetId" is-tile-view="false" client-id="office365RestoreOptionsCtrl.sourceClientId" extra-classes="'margin-right-20 margin-left-20'"></cv-on-boarding-warning-msg>

        <!--Restore to User Account/Site/Web/Server--START-->
        <div class="plain-accordion margin-top-10">
            <div class="cv-accordion-header">
                <span class="cv-accordion-text" data-ng-bind="office365RestoreOptionsCtrl.restoreAccountMachineLabel"></span>
                <span class="availableTime-timelabel margin-top-0"><i class="k-icon k-i-information margin-right-5"></i>
                    <label data-ng-bind="office365RestoreOptionsCtrl.restoreAccountMachineHelpText"></label>                   
                </span>
            </div>
        </div>
        
        <!--Machine Browse and Selection --START-->
        <!--Destination member server client--START-->
        <div class="margin-left-5 margin-right-5 padding-left-15 padding-right-15" data-ng-if="office365RestoreOptionsCtrl.restoreToFileLocation">
            <div class="form-group row margin-top-10">
                <label class="col-xs-12 col-md-4 margin-top-10" for="restoreDestination"><cv:msg
                        key="label.restoreoptions.destinationServer" bundle="office365" /></label>
                <div class="col-xs-12 col-md-8">                                         
                    <isteven-multi-select
                        id="office365AccessNodesDropdown"
                        name="office365AccessNodesDropdown"
                        class="isteven-multi-select user-group-select isteven-summary-dropdown"
                        input-model="office365RestoreOptionsCtrl.office365AccessNodesList"
                        output-model="office365RestoreOptionsCtrl.selectedoffice365AccessNodesList"
                        item-label="clientName"
                        selection-mode="single"
                        button-label="clientName"
                        max-labels="1"
                        helper-elements="filter"
                        tick-property="selected"           
                        on-item-click="office365RestoreOptionsCtrl._processOneDriveAccessNodeSelectionChange()"
                        translation="office365RestoreOptionsCtrl.localLang ">
                    </isteven-multi-select>         	               
                </div>
            </div>

            <!--Machine Browse --START-->
            <div class="form-group row margin-top-10 margin-bottom-10">             
                <label class="col-xs-12 col-md-4 margin-top-10" for="restoreDestination"><cv:msg
                    key="label.restoreoptions.machinePath" bundle="office365" /></label>

                <div class="col-xs-12 col-md-8" data-ng-disabled="!office365RestoreOptionsCtrl._enableMachineBrowse()">                	                           
                    <div data-ng-if="office365RestoreOptionsCtrl.isOneDrive" class="input-group">
                        <input type="text"
                            placeholder='<cv:msg key="placeholder.browse.destinationPath" bundle="office365" />' 
                            data-ng-model="office365RestoreOptionsCtrl.destinationMachinePath">
                        <span class="input-group-btn">
                            <button type="button" id="office365_machineBrowse_btn" class="icon-style cv-material-button browse" data-ng-click="office365RestoreOptionsCtrl._performMachineBrowseOperation()"> 
                                <div class="cv-material-button-icon cursor-pointer">
                                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
                                </div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
                            </button>
                        </span>
                    </div>                        

                    <div data-ng-if="office365RestoreOptionsCtrl.isExchange" class="input-group">
						<div data-ng-if="!office365RestoreOptionsCtrl.isPSTRestore">
							<input
								type="text"
								placeholder='<cv:msg key="placeholder.browse.destinationPath" bundle="office365" />' 
								data-ng-model="office365RestoreOptionsCtrl.destinationMachinePath">
						</div>
						<div data-ng-if="office365RestoreOptionsCtrl.isPSTRestore">
							<input
								id="PSTDestinationPath"
								name="PSTDestinationPath"
								type="text"
								data-ng-pattern="office365RestoreOptionsCtrl.pstDestinationPathRegex"
								placeholder='<cv:msg key="placeholder.browse.destinationPath" bundle="office365" />' 
								data-ng-model="office365RestoreOptionsCtrl.destinationMachinePath">
						</div>
						<span class="input-group-btn">
							<button
								type="button"
								id="office365_machineBrowse_btn"
								class="icon-style cv-material-button browse"
								data-ng-click="office365RestoreOptionsCtrl._performMachineBrowseOperation()"> 
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
										<path d="M0 0h24v24H0z" fill="none"/>
										<path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/>
									</svg>
								</div>
								<div class="cv-material-button-tooltip">
									<cv:msg key="Browse" bundle="storage" />
								</div>
							</button>
						</span>
					</div>

					<div data-ng-if="office365RestoreOptionsCtrl.isExchange && office365RestoreOptionsCtrl.isPSTRestore"
						class="help-block"
						data-ng-show="cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.PSTDestinationPath)">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.selectValidPST" bundle="exchange"></cv:msg>
					</div>
                </div>
            </div>

			<!-- FileType Selection (Exchange) START-->
			<div data-ng-if="office365RestoreOptionsCtrl.isExchange" class="form-group row margin-top-10 margin-bottom-10">
				<label class="col-xs-12 col-md-4 margin-top-10" for="exchangeRestoreFileTypeDropdown">
					<cv:msg key="label.restoreoptions.restoreFileType" bundle="office365" />
				</label>
				<div class="col-xs-12 col-md-8">
					<isteven-multi-select
						id="exchangeRestoreFileTypeDropdown"
						name="exchangeRestoreFileTypeDropdown"
						class="isteven-multi-select"
						input-model="office365RestoreOptionsCtrl.exchangeRestoreFileTypeList"
						output-model="office365RestoreOptionsCtrl.selectedExchangeRestoreFileTypeList"
						item-label="fileType"
						selection-mode="single"
						button-label="fileType"
						max-labels="1"
						helper-elements="filter"
						tick-property="selected"
						on-item-click="office365RestoreOptionsCtrl._processExchangeRestoreFileTypeSelectionChange()"
						translation="office365RestoreOptionsCtrl.localLang ">
					</isteven-multi-select>
				</div>
			</div>
			<!-- FileType Selection (Exchange) END-->
        </div>
        <!--Machine Browse --END-->
        <!--Destination member server client--END-->
        <!--Machine Browse and Selection --END-->

        <div data-ng-if="!office365RestoreOptionsCtrl.restoreToFileLocation" 
            class="margin-left-5 margin-right-5 padding-left-15 padding-right-15">
            <!-- Restore inplace --out-of-place options --START-->
            <div class="margin-top-10">              
                <cv-radio-group 
                    is-vertical="true" 
                    radio-model="office365RestoreOptionsCtrl.restoreToOriginalLocationRadioVal" 
                    radio-obj="office365RestoreOptionsCtrl.restoreLocationOptions" 
                    on-click="office365RestoreOptionsCtrl._restoreToOriginalLocationRadioValChange(data)">
                </cv-radio-group>
            </div>
            <!-- Restore inplace --out-of-place options --END-->

            <!--OneDrive--START-->
            <!--OneDrive User Account--START-->
            <div class="form-group row margin-top-10 margin-left-10" data-ng-if="!office365RestoreOptionsCtrl.restoreToOriginalLocation && office365RestoreOptionsCtrl.restoreToOneDrive">
				<span class="col-xs-12 col-md-4 margin-top-15">
					<i class="k-icon k-i-user margin-right-5"></i>
					<cv-help-text help-label="label.restoreoptions.userAccount" help-text="help.restoreoptions.typeahead.selectuser" />
				</span>
                
                <div class="col-xs-12 col-md-8"> 
                    <div class="input-group">
                        <input type="text"
                            id="userAccountInput"
                            name="userAccountInput"
                            required
                            placeholder='<cv:msg key="placeholder.typebrowse.user" bundle="office365" />' 
                            ng-change="office365RestoreOptionsCtrl.onUserEmailInputChange($viewValue)" 
                            ng-model="office365RestoreOptionsCtrl.selectedOneDriveUser"
                            typeahead-template-url="customPopupTemplate.html"
                            uib-typeahead="userEmailList.email for userEmailList in office365RestoreOptionsCtrl.userEmailList | limitTo:10">

                        <span class="input-group-btn">
                            <button type="button" id="userBrowse_btn" class="icon-style cv-material-button browse" data-ng-click="office365RestoreOptionsCtrl._performUserBrowseOperation()"> 
                                <div class="cv-material-button-icon cursor-pointer">
                                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
                                </div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
                            </button>
                        </span>   
                    </div>
                    <div class="help-block"
                        data-ng-show="cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.userAccountInput)">
                        <cv:msg key="error.valid.onedrive.user" bundle="office365" />
                    </div>                 
                </div>
            </div>
            <!--OneDrive User Account--END-->

            <!--OneDrive Folder--START-->
            <div class="form-group row margin-top-10 margin-left-10" data-ng-if="!office365RestoreOptionsCtrl.restoreToOriginalLocation && office365RestoreOptionsCtrl.restoreToOneDrive">
				<span class="col-xs-12 col-md-4 margin-top-10">
					<i class="fa fa-folder margin-right-5"></i>
					<cv-help-text help-label="label.restoreoptions.oneDriveFolder" help-text="help.restoreoptions.folder.onedrive" />
				</span>
                <div class="col-xs-12 col-md-8"> 

                    <div class="input-group">
                        <label data-ng-bind="office365RestoreOptionsCtrl.selectedOneDriveFolder"></label>
                        <span class="input-group-btn"
                              data-ng-disabled="!office365RestoreOptionsCtrl.selectedOneDriveUser.length">
                            <button type="button" id="browse_folder" class="icon-style cv-material-button browse"
                                data-ng-click="office365RestoreOptionsCtrl._performFolderBrowseOperation()"> 
                                <div class="cv-material-button-icon cursor-pointer">
                                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
                                </div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>                               
                            </button>
                        </span>
                    </div>
                    <div class="help-block"
                        data-ng-show="cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.createFolderInput)">
                        <cv:msg key="error.newfolder.name" bundle="office365" />
                    </div>              
                    <!--New Folder Input--END-->                
                </div>
            </div>
            <!--OneDrive Folder--END-->
            <!--OneDrive--END-->

			<!--Exhange--START-->
			<!--Exchange User Account--START-->
			<div class="form-group row margin-top-10 margin-left-10" data-ng-if="!office365RestoreOptionsCtrl.restoreToOriginalLocation && office365RestoreOptionsCtrl.restoreToExchangeOnline"> 
				<span class="col-xs-12 col-md-4 margin-top-15">
					<i class="k-icon k-i-inbox margin-right-5"></i>
					<cv-help-text help-label="label.mailbox" help-text="help.restoreoptions.typeahead.selectmailbox" />
				</span>

				<div class="col-xs-12 col-md-8"> 
					<div class="input-group">
						<input
							type="text"
							id="userAccountInput"
							name="userAccountInput"
							required
							placeholder='<cv:msg key="label.emailAddressPlaceholder" bundle="exchange" />'
							ng-change="office365RestoreOptionsCtrl.onUserEmailInputChange($viewValue)" 
							ng-model="office365RestoreOptionsCtrl.selectedExchangeUser.smtpAdrress"
							typeahead-template-url="customPopupTemplate.html"
							uib-typeahead="userEmailList.smtpAdrress for userEmailList in office365RestoreOptionsCtrl.userEmailList | limitTo:10"
							typeahead-on-select="office365RestoreOptionsCtrl.onSelectExchangeUser($item, $model, $label)"
						/>

						<span class="input-group-btn">
							<button type="button" id="userBrowse_btn" class="icon-style cv-material-button browse" data-ng-click="office365RestoreOptionsCtrl._performUserBrowseOperation()"> 
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
								</div>
								<div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
							</button>
						</span>
					</div>
					<div class="help-block"
						data-ng-show="cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.userAccountInput)">
						<cv:msg key="error.valid.exchange.user" bundle="office365" />
					</div>
				</div>
			</div>
			<!--Exchange User Account--END-->

			<!--Exchange Folder--START-->
			<div class="form-group row margin-top-10 margin-left-10" data-ng-if="!office365RestoreOptionsCtrl.restoreToOriginalLocation && office365RestoreOptionsCtrl.restoreToExchangeOnline">
				<label class="col-xs-12 col-md-4" for="restoreDestination">
					<i class="fa fa-folder margin-right-5"></i>
					<cv:msg key="label.restoreoptions.oneDriveFolder" bundle="office365" />
				</label>

				<div class="col-xs-12 col-md-8"> 
					<div class="input-group">
						<input
							type="text"
							id="exchangeFolderInput"
							name="exchangeFolderInput"
							ng-model="office365RestoreOptionsCtrl.selectedExchangeFolder"
							required
							placeholder='<cv:msg key="label.folder" bundle="exchange" />'
						/>

						<span class="input-group-btn"
			data-ng-disabled="!office365RestoreOptionsCtrl.selectedExchangeUser.smtpAdrress.length">
							<button type="button" id="browse_folder" class="icon-style cv-material-button browse"
												data-ng-click="office365RestoreOptionsCtrl._performFolderBrowseOperation()"> 
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
								</div>
								<div class="cv-material-button-tooltip">
									<cv:msg key="Browse" bundle="storage" />
								</div>
							</button>
						</span>
					</div>
				</div>
			</div>
			<!--Exchange Folder--END-->
			<!--Exhange--END-->
        </div>
        <!--Restore to User Account/Site/Web/Server --END-->

         <!--Restore flags/options --START-->
        <div class="plain-accordion margin-top-10" data-ng-if="!office365RestoreOptionsCtrl.restoreToFileLocation">
            <cv-plain-accordion accordion-label="{{office365RestoreOptionsCtrl.fileLevelRestoreOptionsLabel}}">			
				<div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">                   
                    <div class="form-group row margin-top-10">
						<span data-ng-if="office365RestoreOptionsCtrl.restoreToOneDrive" >
							<cv-help-text class="col-xs-12 col-md-4 margin-top-5" help-label="label.restore.file.exists" help-text="help.restore.file.exists" />
						</span>
						<span data-ng-if="office365RestoreOptionsCtrl.restoreToExchangeOnline" >
							<cv-help-text class="col-xs-12 col-md-4 margin-top-5" help-label="label.restore.message.exists" help-text="help.restore.message.exists" />
						</span>
                        <div class="col-xs-12 col-md-8">                                         
                            <cv-radio-group 
                                is-vertical="true" 
                                radio-model="office365RestoreOptionsCtrl.fileRestoreOptionSelected" 
                                radio-obj="office365RestoreOptionsCtrl.fileRestoreOptions" 
                                on-click="office365RestoreOptionsCtrl._fileRestoreOptionChange(data)">
                            </cv-radio-group>	               
                        </div>                 
                    </div>              
                    <!--Overwrite data--END-->
				</div>
			</cv-plain-accordion>
        </div>
        
        <!--Restore flags/options options --END-->

        <!--Advanced options --START-->
        <div data-ng-if="office365RestoreOptionsCtrl.hasAdvancedOptions" class="plain-accordion">
            <cv-plain-accordion accordion-label="header.restoreoptions.advancedOptions">			
				<div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">
					<div data-ng-if="office365RestoreOptionsCtrl.isOneDrive">
						<!--Destination pseudo client (OneDrive) --START-->
						<div class="form-group row margin-top-10" data-ng-if="!office365RestoreOptionsCtrl.restoreToFileLocation">
							<label class="col-xs-12 col-md-4" for="restoreDestination"><cv:msg
									key="label.restore.office365app" bundle="office365" /></label>
							<div class="col-xs-12 col-md-8" data-ng-disabled="!office365RestoreOptionsCtrl.isOffice365OneDriveIntegration">                                         
								<isteven-multi-select
									id="office365PseudoClientsDropdown"
									name="office365PseudoClientsDropdown"
									class="isteven-multi-select user-group-select isteven-summary-dropdown"
									input-model="office365RestoreOptionsCtrl.office365PseudoClientAppsList"
									output-model="office365RestoreOptionsCtrl.selectedOffice365PseudoClientAppsList"
									item-label="clientName"
									selection-mode="single"
									button-label="clientName"
									max-labels="1"
									helper-elements="filter"
									tick-property="selected"           
									on-item-click="office365RestoreOptionsCtrl.processOneDrivePseudoClientSelectionChange()"
									translation="office365RestoreOptionsCtrl.localLang ">
								</isteven-multi-select>         	               
							</div>
						</div>
						<!--Destination pseudo client (OneDrive) --END-->

						<!--Not required for now
						<cv-checkbox 
							checkbox-label="office365RestoreOptionsCtrl.retainFolderHierarchyLabel" 
							checkbox-name="retainFolderHierarchyChk" 
							checkbox-id="retainFolderHierarchyChk"
							check-click="office365RestoreOptionsCtrl._retainFolderHierarchyChange(data)"
							checkbox-model="office365RestoreOptionsCtrl.retainFolderHierarchyModel">
						</cv-checkbox>
						-->

						<cv-checkbox 
							checkbox-label="office365RestoreOptionsCtrl.skipPermissionsLabel"
							checkbox-name="skipPermissionsChk" 
							checkbox-id="skipPermissionsChk"
							check-click="office365RestoreOptionsCtrl._skipPermissionsRestoreChange(data)"
							checkbox-model="office365RestoreOptionsCtrl.skipPermissionsRestoreModel">
						</cv-checkbox>
					</div>

					<div data-ng-if="office365RestoreOptionsCtrl.isExchange">
						<!--Exchange Destination Host--START-->
						<div class="form-group row margin-top-10" data-ng-if="!office365RestoreOptionsCtrl.restoreToFileLocation && !office365RestoreOptionsCtrl.restoreToOriginalLocation">
							<label class="col-xs-12 col-md-4" for="exchangeDestinationHost">
								<i class="fa fa-desktop margin-right-5"></i>
								<cv:msg key="label.destHost" bundle="exchange"></cv:msg>
							</label>

							<div class="col-xs-12 col-md-8"> 
								<isteven-multi-select
									id="exchangeDestinationHost"
									name="exchangeDestinationHost"
									class="isteven-accordion-height isteven-multi-select"
									input-model="office365RestoreOptionsCtrl.exchangeDestinationHostList"
									output-model="office365RestoreOptionsCtrl.selectedExchangeDestinationHostList"
									item-label="clientName"
									selection-mode="single"
									disable-property="disabled"
									button-label="clientName"
									max-labels="1"
									helper-elements="filter"
									tick-property="selected"
									on-item-click="office365RestoreOptionsCtrl.processExchangeDestinationHostSelectionChange()"
									translation="office365RestoreOptionsCtrl.localLang ">
								</isteven-multi-select>
							</div>
						</div>
						<!--Exchange Destination Host--END-->

						<!-- Exchange (Mailbox Restore) advanced options --START-->
						<div data-ng-if="!office365RestoreOptionsCtrl.restoreToFileLocation">
							<div
								class="form-group row margin-top-10"
								data-ng-if="office365RestoreOptionsCtrl.showRestoreAsStubs()">
								<div class="col-xs-12">
									<input
										id="restoreAsStubs"
										name="restoreAsStubs"
										type="checkbox"
										data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.restoreAsStubs" />
									<label for="restoreAsStubs">
										<cv:msg key="label.restoreAsStubs" bundle="restore"></cv:msg>
									</label>
								</div>
							</div>
							<div
								class="form-group row"
								data-uib-collapse="!office365RestoreOptionsCtrl.exchangeAdvancedOptions.restoreAsStubs">
								<div class="form-group col-xs-12">
										<input
											id="leaveMsgBody"
											name="leaveMsgBody"
											type="checkbox"
											data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.leaveMessageBody" />
										<label for="leaveMsgBody">
											<cv:msg key="label.leaveMsgBody" bundle="restore"></cv:msg>
										</label>
								</div>
								<div class="form-group">
									<div
										class="col-xs-6"
										data-ng-disabled="!office365RestoreOptionsCtrl.exchangeAdvancedOptions.leaveMessageBody">
											<input
												id="truncateBody"
												name="truncateBody"
												type="checkbox"
												data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.truncateBody" />
											<label for="truncateBody">
												<cv:msg key="label.truncateBody" bundle="restore"></cv:msg>
											</label>
									</div>

									<div class="col-xs-6">
										<input type="number" id="truncateBodyToBytes"
											name="truncateBodyToBytes"
											data-ng-disabled="!office365RestoreOptionsCtrl.exchangeAdvancedOptions.truncateBody"
											data-ng-required="office365RestoreOptionsCtrl.exchangeAdvancedOptions.leaveMessageBody && office365RestoreOptionsCtrl.exchangeAdvancedOptions.truncateBody"
											min="0"
											data-ng-class="{'has-error' : cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.truncateBodyToBytes)}"
											data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.truncateBodyToBytes" />
										<span class="help">
												<cv:msg key="label.bytes" bundle="exchange"/>
										</span>
										<div class="help-block"
											data-ng-show="cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.truncateBodyToBytes)">
											<i class="ion-alert-circled"></i><cv:msg key="error.validBytes" bundle="exchange"/>
										</div>
									</div>
								</div>

								<div class="form-group">
									<label class="col-xs-6">
										<cv:msg key="label.msgsOlderThan" bundle="restore"/></label>
									<div class="col-xs-6">
										<input type="number" id="msgsOlderThan"
											name="msgsOlderThan" min="0"
											data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.collectMsgsDaysAfter" />
										<cv:msg key="label.days" bundle="exchange"/>
										<div class="help-block"
											data-ng-show="cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.msgsOlderThan)">
											<i class="ion-alert-circled"></i><cv:msg key="error.validDays" bundle="exchange"/>
										</div>
									</div>
								</div>
								<div class="form-group">
										<label class="col-xs-6">
											<cv:msg key="label.msgsLargerThan" bundle="restore"/></label>
										<div class="col-xs-6">
											<input type="number" id="msgsLargerThan"
												name="msgsLargerThan" min="0"
												data-ng-class="{'has-error' : cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.msgsLargerThan)}"
												data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.collectMsgsLargerThan" />
											<cv:msg key="labelKB" bundle="messagesJs"/>
											<div class="help-block"
												data-ng-show="cv.office365RestoreOptionsForm.needsAttention(office365RestoreOptionsForm.msgsLargerThan)">
												<i class="ion-alert-circled"></i><cv:msg key="error.validKB" bundle="exchange"/>
											</div>
										</div>
								</div>
								<div class="form-group">
									<div class="col-xs-12">
										<input id="collectMsgWithAttach" name="collectMsgWithAttach"
											type="checkbox"
											data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.collectMsgWithAttach" />
										<label for="collectMsgWithAttach">
											<cv:msg key="label.msgsWithAttachments" bundle="restore"></cv:msg>
										</label>
									</div>
								</div>
							</div>
						</div>
						<!-- Exchange (Mailbox Restore) advanced options --END-->

						<!-- Exchange (File Location Restore) advanced options --START-->
						<div data-ng-if="office365RestoreOptionsCtrl.restoreToFileLocation && office365RestoreOptionsCtrl.isPSTRestore">
							<div class="form-group">
								<div class="col-xs-5">
									<input
										id="limitPst"
										name="limitPst"
										type="checkbox"
										data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.limitPSTSize" />
									<label for="limitPst">
										<cv:msg key="label.limitPSTSizeTo" bundle="exchange"></cv:msg>
									</label>
								</div>
								<div class="col-xs-7">
									<input
										id="limitPstTo"
										data-ng-disabled="!office365RestoreOptionsCtrl.exchangeAdvancedOptions.limitPSTSize"
										name="limitPstTo"
										type="number"
										data-ng-model="office365RestoreOptionsCtrl.exchangeAdvancedOptions.limitPSTSizeAmount" />
									<cv:msg key="labelMB" bundle="messagesJs"></cv:msg>
								</div>
							</div>
						</div>
						<!-- Exchange (File Location Restore) advanced options --END-->
					</div>
				</div>
			</cv-plain-accordion>
        </div>
        
        <!--Advanced options --END-->

         <!--Selected items --START-->
         <div data-ng-if="office365RestoreOptionsCtrl.showSelectedItemsGrid" class="plain-accordion">
             <cv-plain-accordion accordion-label="restore.options.items.to.restore">
                 <div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">
                     <cv-kendo-grid
                         data-cv-grid-options="office365RestoreOptionsCtrl.selectedItemsGridOptions">
                     </cv-kendo-grid>
                 </div>
             </cv-plain-accordion>
         </div>
         <!--Selected items --END-->
       
	</div>
	<!--End --Modal Body-->
	<div class="modal-footer">
        <button id="cancel" class="btn btn-default" type="button" data-ng-click="office365RestoreOptionsCtrl.cancel()"> 
             <cv:msg key="label.close" bundle="messagesJs" />
        </button>
        <button id="submit" class="btn btn-primary cvBusyOnAjax" type="submit">
            <cv:msg key="Submit" bundle="messages" />
        </button>
    </div>		
	<!--End --Modal Footer-->
</form>
