<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<form
	class="bootstrap-wrapper"
	data-cv-submit="office365OOPBrowseCtrl.saveChanges()"
	name="office365OOPBrowseForm"
	id="office365OOPBrowseForm"
	novalidate
	cv-hide-api
	autocomplete="off"
>
	<div class="modal-header">
		<h1 data-ng-bind="office365OOPBrowseCtrl.pageTitle"></h1>
	</div>
	<!--End --Modal Header-->
	<div class="modal-body-fixed">		
		<p data-ng-if="office365OOPBrowseCtrl.serverErrorMessage" 
			class="help-block margin-top-5" 
			data-ng-bind="office365OOPBrowseCtrl.errorMessage">
		</p>
       
        <div data-ng-show="!office365OOPBrowseCtrl.loaded" class="margin-top-20 horz-center grid-data-spinner">
            <img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
		</div> 
		
		<!--Cache info--START-->
		<div class="no-margin" data-ng-if="!office365OOPBrowseCtrl.isFolderBrowse && office365OOPBrowseCtrl.loaded && !office365OOPBrowseCtrl.isDynamics365App">
			<div class="plain-accordion">
				<div class="cv-accordion-header">
					<span class="cv-accordion-text" data-ng-bind="office365OOPBrowseCtrl.associationGridTitle"></span>
					<span class="restore-help-text"><i class="k-icon k-i-hyperlink-open margin-right-5"></i>
						<a data-ng-bind="office365OOPBrowseCtrl.cacheInfoLabel"
							data-ng-click="office365OOPBrowseCtrl._loadDiscoverCacheDetailsDialog()">
						</a>
						<a class="margin-left-5"
							data-ng-click="office365OOPBrowseCtrl._loadDiscoverCacheDetailsDialog()">
							<b>
								<span data-ng-bind="office365OOPBrowseCtrl.lastDiscoverCacheUpdateTime"></span>
							</b>
						</a>                      
					</span>
				</div>                  
			</div>
		</div>
		<!--Cache info--END-->
		
		<!--MS Teams -- Sub selection --Info--START-->
		<div class="plain-accordion" data-ng-if="office365OOPBrowseCtrl.isMSTeamsApp && office365OOPBrowseCtrl.loaded && office365OOPBrowseCtrl.showMSTeamsSubEntitySelectionInfoText">
			<div class="cv-accordion-header">
				<span class="margin-right-10">
					<svg version="1.1" id="cv_cc" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					viewBox="0 0 432.4 432.4" style="enable-background:new 0 0 432.4 432.4;" height="20px" width="20px" xml:space="preserve">
						<path style="fill:#0B2E44;" d="M216.529,93.2c-61.2,0-111.2,50-111.2,111.2c0,32,14,62.8,37.6,83.6c17.6,17.6,16,55.2,15.6,55.6
							c0,2,0.4,3.6,2,5.2c1.2,1.2,3.2,2,4.8,2h102c2,0,3.6-0.8,4.8-2c1.2-1.2,2-3.2,2-5.2c0-0.4-2-38,15.6-55.6
							c0.4-0.4,0.8-0.8,1.2-1.2c23.2-21.2,36.8-51.2,36.8-82.4C327.729,143.2,277.729,93.2,216.529,93.2z M280.529,277.6
							c-0.4,0.4-1.2,1.2-1.2,1.6c-15.6,16.8-18.4,44.4-18.8,57.6h-88.4c-0.4-13.2-3.2-42-20-59.2c-21.2-18.4-33.6-45.2-33.6-73.6
							c0-54,43.6-97.6,97.6-97.6s97.6,43.6,97.6,97.6C313.729,232.4,301.729,259.2,280.529,277.6z"/>
						<path style="fill:#0B2E44;" d="M216.129,121.6c-3.6,0-6.8,3.2-6.8,6.8c0,3.6,3.2,6.8,6.8,6.8c40.4,0,72.8,32.8,72.8,72.8
							c0,3.6,3.2,6.8,6.8,6.8c3.6,0,6.8-3.2,6.8-6.8C302.929,160.4,264.129,121.6,216.129,121.6z"/>
						<path style="fill:#0B2E44;" d="M260.529,358.4h-88.8c-9.2,0-16.8,7.6-16.8,16.8s7.6,16.8,16.8,16.8h88.4
							c9.6-0.4,17.2-7.6,17.2-16.8C277.329,366,269.729,358.4,260.529,358.4z M260.529,378h-88.8c-1.6,0-3.2-1.2-3.2-3.2
							s1.2-3.2,3.2-3.2h88.4c1.6,0,3.2,1.2,3.2,3.2S262.129,378,260.529,378z"/>
						<path style="fill:#0B2E44;" d="M247.329,398.8h-62.4c-9.2,0-16.8,7.6-16.8,16.8s7.6,16.8,16.8,16.8h62.4
							c9.2,0,16.8-7.6,16.8-16.8C264.129,406,256.529,398.8,247.329,398.8z M247.329,418.4h-62.4c-1.6,0-3.2-1.2-3.2-3.2
							s1.2-3.2,3.2-3.2h62.4c1.6,0,3.2,1.2,3.2,3.2S248.929,418.4,247.329,418.4z"/>
						<path style="fill:#0B2E44;" d="M216.129,60c4,0,6.8-3.2,6.8-6.8V6.8c0-3.6-3.2-6.8-6.8-6.8c-3.6,0-6.8,3.2-6.8,6.8v46.4
							C209.329,56.8,212.529,60,216.129,60z"/>
						<path style="fill:#0B2E44;" d="M329.329,34.4c-3.2-2.4-7.2-1.2-9.2,1.6l-25.6,38.4c-2.4,3.2-1.6,7.6,1.6,9.6
							c1.2,0.8,2.4,1.2,3.6,1.2c2.4,0,4.4-1.2,5.6-3.2l25.6-38.4C333.329,40.8,332.529,36.4,329.329,34.4z"/>
						<path style="fill:#0B2E44;" d="M134.929,83.6c1.2,0,2.4-0.4,3.6-1.2c3.2-2,4-6.4,2-9.6l-24.8-38.8c-2-3.2-6.4-4-9.6-2
							s-4,6.4-2,9.6l24.8,38.8C130.529,82.8,132.529,83.6,134.929,83.6z"/>
						<path style="fill:#0B2E44;" d="M86.529,126l-40.4-22c-3.2-1.6-7.6-0.4-9.2,2.8c-2,3.2-0.8,7.6,2.8,9.2l40.4,22
							c1.2,0.4,2,0.8,3.2,0.8c2.4,0,4.8-1.2,6-3.6C90.929,132,89.729,127.6,86.529,126z"/>
						<path style="fill:#0B2E44;" d="M395.729,106.8c-1.6-3.2-6-4.4-9.2-2.8l-40.8,22c-3.2,1.6-4.4,6-2.8,9.2c1.2,2.4,3.6,3.6,6,3.6
							c1.2,0,2.4-0.4,3.2-0.8l40.8-22C396.129,114.4,397.329,110,395.729,106.8z"/>
					</svg>
				</span>
				<span class="cv-accordion-text" data-ng-bind-html="office365OOPBrowseCtrl.msTeamsSubEntitySelectionInfoText"></span>
			</div>                  
		</div>
		<!--MS Teams -- Sub selection --Info--END-->

        <div class="form-group margin-left-5 margin-right-5" data-ng-show="office365OOPBrowseCtrl.loaded" data-ng-if="!office365OOPBrowseCtrl.isFolderBrowse" >
            <cv-kendo-grid data-cv-grid-options="office365OOPBrowseCtrl.userGridOptions"></cv-kendo-grid>
		</div>
		
		<div class="form-group margin-left-5 margin-right-5" data-ng-show="office365OOPBrowseCtrl.loaded" data-ng-if="office365OOPBrowseCtrl.isFolderBrowse">         
			<cv-kendo-tree data-cv-tree-options="office365OOPBrowseCtrl.treeOptions"></cv-kendo-tree>			
        </div>                       
	</div>
	<!--End --Modal Body-->
	<div class="modal-footer">
		<!--Create New Folder-->
		<button id="new_folder" 
			class="btn btn-default cvBusyOnAjax" 
			type="button"
			data-ng-if="office365OOPBrowseCtrl.isFolderBrowse && office365OOPBrowseCtrl.loaded && !office365OOPBrowseCtrl.isMSTeamsApp"
			data-ng-click="office365OOPBrowseCtrl.createNewFolder()">
				<cv:msg key="label.create.new.folder.tree" bundle="office365" />
		</button>
        <button id="office365OOPBrowseForm_btn_cancel" class="btn btn-default" type="button" data-ng-click="office365OOPBrowseCtrl.cancel()"> 
             <cv:msg key="label.close" bundle="messagesJs" />
        </button>
        <button id="office365OOPBrowseForm_btn_submit" data-ng-if="office365OOPBrowseCtrl.loaded" class="btn btn-primary cvBusyOnAjax" type="submit"> 
			<cv:msg key="label.restore.select.user" bundle="office365" />
		</button>
    </div>		
	<!--End --Modal Footer-->
</form>
