<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<form data-cv-submit name="cvOffice365ConnectionsForm" class="form-horizontal"
	novalidate>
	<!-- Global Admin Login --Start -->
	<div data-ng-show="!$ctrl.isGlobalLogin && $ctrl.azureAppModel.azureAppId.length === 0">
		<!-- Region Selection --Start -->
		<div class="form-group margin-top-20">
			<label class="col-xs-12 col-md-3" for="region">
				<cv:msg key="label.office365.cloudregion" bundle="exchange" /></label>
			<div class="col-xs-12 col-md-9">
				<isteven-multi-select 
					id="createOffice365Connection_isteven-multi-select_#1167"
					input-model="$ctrl.cloudRegionList"
					output-model="$ctrl.selectedCloudRegionList"
					button-label="region"
					item-label="region"
					directive-id="'cloudRegions'"
					selection-mode="single"
					helper-elements="filter"
					max-labels="1"
					on-item-click="$ctrl.processCloudRegionSelection()"
					tick-property="selected"
					translation="$ctrl.localLang">
				</isteven-multi-select>
			</div>
		</div>
		<!-- Region Selection --End -->
		<div class="form-group">
			<cv-help-text class="margin-top-10 col-xs-12 col-md-3" help-label="label.globalAdministrator"
				help-text="help.globalAdmin" />
			<div class="col-xs-12 col-md-9">
				<input type="email" id="globalUserName" name="globalUserName" required
					data-ng-model="$ctrl.azureAppCreationModel.adminCredential.userName"
					placeholder='<cv:msg key="label.gadmin.example" bundle="office365"/>' />
				<div class="help-block"
					data-ng-show="cv.cvOffice365ConnectionsForm.needsAttention(cvOffice365ConnectionsForm.globalUserName)">
					<cv:msg key="error.globalAppUsernameError" bundle="exchange" />
				</div>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-3" for="globalPassword">
				<cv:msg key="label.password" bundle="exchange"></cv:msg>
			</label>
			<div class="col-xs-12 col-md-9">
				<input type="password" id="globalPassword" name="globalPassword" required
					data-ng-model="$ctrl.azureAppCreationModel.adminCredential.password"
					placeholder='<cv:msg key="label.password" bundle="exchange"/>' />
				<div class="help-block"
					data-ng-show="cv.cvOffice365ConnectionsForm.needsAttention(cvOffice365ConnectionsForm.globalPassword)">
					<cv:msg key="error.password" bundle="exchange" />
				</div>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-3" for=""></label>
			<div class="col-xs-12 col-md-9 margin-top-10">
				<span class="input-group-btn">
					<button id="createOffice365Connection_button_#6055" class="btn btn-default" type="button"
						data-ng-disabled="$ctrl.azureAppCreationInProgress || (!$ctrl.azureAppCreationModel.adminCredential.userName || !$ctrl.azureAppCreationModel.adminCredential.password)"
						data-ng-click="$ctrl.createAzureADApp()">
						<cv:msg key="label.createApp" bundle="exchange" />
						<i data-ng-if="$ctrl.azureAppCreationInProgress"
							class="fa fa-spinner fa-spin"></i>
					</button>
				</span>
				<div class="help-block margin-top-5"
					data-ng-show="$ctrl.globalLoginFailure"
					ng-bind="$ctrl.appCreationErrorResponse"></div>
			</div>
		</div>
	</div>
	<!-- Global Admin Login --End -->
</form>

<!-- Azure AD App Details --Global Admin --Start -->
<div data-ng-if="$ctrl.azureAppModel.azureAppId.length > 0">
	<div class="form-group">
		<cv-help-text class="margin-top-10 col-xs-12 col-md-3" help-label="label.globalAdministrator"
			help-text="help.globalAdmin" />
		<div class="col-xs-12 col-md-9">
			<div class="row margin-top-10 margin-left-0">
				<span id="globalAdminUsername" name="globalAdminUsername" class="float-left"
					ng-bind="$ctrl.azureAppCreationModel.adminCredential.userName"></span>
			</div>
		</div>
	</div>
	<div class="form-group">
		<label class="margin-top-10 col-xs-12 col-md-3" for="globalAppId">
			<cv:msg key="label.azureAppDetails" bundle="exchange" /></label>
		<div class="col-xs-12 col-md-9">
			<div class="row margin-top-10 margin-left-0">
				<span id="globalAppId" name="globalAppId" class="float-left"
					ng-bind="$ctrl.azureAppModel.azureAppId"></span>
			</div>
			<table class="table table-striped margin-top-10">
				<tbody>
					<!-- App Created --Start -->
					<tr>
						<td class="restore-help-text ">
							<cv:msg key="label.appCreatedSuccess" bundle="exchange" />
						</td>
						<td class="text-align-center">
							<i class="k-icon k-i-check green-font"></i>
						</td>
					</tr>
					<!-- App Created --End -->

					<!-- Modern Auth Step --Start -->
					<tr data-ng-if="$ctrl.appType === $ctrl.APP_TYPE.EXCHANGE_ONLINE">
						<td class="restore-help-text ">
							<div data-ng-if="!$ctrl.azureAppModel.isModernAuthEnabled">
								<cv:msg key="label.modernAuthDisabled" bundle="office365"/>
							</div>
							<div data-ng-if="$ctrl.azureAppModel.isModernAuthEnabled">
								<cv:msg key="label.modernAuthEnabled" bundle="office365"/>
							</div>
						</td>
						<td class="text-align-center">
							<i class="k-icon k-i-check green-font"></i>
						</td>
					</tr>
					<!-- Modern Auth Step --End -->

					<!-- Exchange Online Service Account --Start -->
					<tr data-ng-if="$ctrl.appType === $ctrl.APP_TYPE.EXCHANGE_ONLINE">
						<td class="restore-help-text">
							<cv:msg key="label.creatingServiceAccount" bundle="exchange" />
							<br>
							<div class="red-font"
								data-ng-show="$ctrl.exchangeServiceAccountFailed"
								data-ng-bind="$ctrl.exchangeServiceAccountError">
							</div>
						</td>
						<td class="text-align-center">
							<div data-ng-if="$ctrl.exchangeServiceAccountFailed">
								<button id="createOffice365Connection_button_#1645" class="btn btn-link btn-xs"
									type="button"
									data-ng-click="$ctrl.createExchangeOnlineServiceAccount()">
									<cv:msg key="label.retryServiceAccountCreation" bundle="exchange" />
								</button>
								<br>
								<cv:msg key="label.or" bundle="office365" />
								<br>
								<button id="createOffice365Connection_button_#1649" class="btn btn-link btn-xs"
									type="button"
									data-ng-click="$ctrl.configureExchangeServiceAccountManually()">
									<cv:msg key="label.addO365ServiceAccountManually" bundle="exchange" />
								</button>
							</div>
							<div data-ng-if="!$ctrl.exchangeServiceAccountFailed">
								<i data-ng-class="$ctrl.exchangeServiceAccountCreationInProgress ? 'fa fa-spinner fa-spin' : 'k-icon k-i-check green-font'"></i>
							</div>
						</td>
					</tr>
					<!-- Exchange Online Service Account --End -->

					<!-- Sync Azure AD App --Start -->
					<tr>
						<td class="restore-help-text ">
							<div data-ng-if="!$ctrl.startAzureAppSync">
								<cv:msg key="label.azureSync" bundle="exchange" />
							</div>
							<div data-ng-if="$ctrl.startAzureAppSync">
								<cv:msg key="label.azureSync" bundle="exchange" />
							</div>
							<div class="orange-font" data-ng-if="$ctrl.azureADAppSyncFailure">
								<br>
								<cv:msg key="label.syncFailureNote" bundle="exchange" />
							</div>
						</td>
						<td class="text-align-center">
							<div data-ng-if="!$ctrl.azureADAppSyncFailure">
								<i data-ng-class="($ctrl.startAzureAppSync && (!$ctrl.azureADAppSyncFailure || $ctrl.isAzureAppAuthorized)) && $ctrl.isAzureAppSynced ? 'k-icon k-i-check green-font' : (!$ctrl.startAzureAppSync ? 'k-icon k-i-clock' : 'fa fa-spinner fa-spin')"></i>
							</div>
							<div data-ng-if="$ctrl.azureADAppSyncFailure">
								<i class="k-icon k-i-info"></i>
							</div>
						</td>
					</tr>
					<!-- Sync Azure AD App --End -->

					<!-- Authorize Azure AD App --Start -->
					<tr>
						<td class="restore-help-text ">
							<div data-ng-if="!$ctrl.isAzureAppAuthorized">
								<cv:msg key="label.appPermissions" bundle="exchange" />
							</div>
							<div data-ng-if="$ctrl.isAzureAppAuthorized">
								<cv:msg key="label.permissionsGranted" bundle="exchange" />
							</div>
						</td>
						<td class="text-align-center">
							<div
								data-ng-if="!$ctrl.isAzureAppSynced && !$ctrl.isAzureAppAuthorized && !$ctrl.azureADAppSyncFailure">
								<i class="k-icon k-i-clock"></i>
							</div>
							<div
								data-ng-if="$ctrl.isAzureAppSynced && $ctrl.isAzureAppAuthorized && !$ctrl.azureADAppSyncFailure">
								<i class="k-icon k-i-check green-font"></i>
							</div>
							<div data-ng-if="$ctrl.azureADAppSyncFailure">
								<button id="createOffice365Connection_button_#1651" class="btn btn-link btn-xs"
									type="button"
									data-ng-click="$ctrl.loginToMicrosoftAzure()">
									<cv:msg key="label.authorizeApp" bundle="exchange" />
								</button>
							</div>
							<div
								data-ng-if="$ctrl.isAzureAppSynced && !$ctrl.isAzureAppAuthorized">
								<button id="createOffice365Connection_button_#1651" class="btn btn-link btn-xs"
									type="button"
									data-ng-click="$ctrl.loginToMicrosoftAzure()">
									<cv:msg key="label.authorizeApp" bundle="exchange" />
								</button>
							</div>
						</td>
					</tr>
					<!-- Authorize Azure AD App --End -->
				</tbody>
			</table>
		</div>
	</div>
</div>
<!-- Azure AD App Details --Global Admin --End -->