<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<form data-cv-submit="addServiceAccountCtrl.add()" cv-hide-api
	name="addServiceAccoutForm" class="form-horizontal bootstrap-wrapper"
	novalidate>
	<div class="modal-header">
		<h1 class="modal-title" data-ng-bind="addServiceAccountCtrl.title"></h1>		
	</div>
	<div class="modal-body no-padding">

		<!--Modern Authentication Toggle (Moved out of modal)-->
		<div class="form-group row margin-top-20 margin-left-20 text-left" 
			data-ng-if="addServiceAccountCtrl.mode !== addServiceAccountCtrl.office365AppType.SHAREPOINT  && !addServiceAccountCtrl.isLocalSystemAcount && false">
			<cv-toggle
				on-click="addServiceAccountCtrl._updateModernAuthFlag(data)"
				toggle-name="modernAuthToggle" 
				toggle-label="label.useModernAuthentication" 				
				value="addServiceAccountCtrl.useModernAuthentication"
				help-text="'help.modernAuth'" 
				help-direction="right"
				toggle-model="addServiceAccountCtrl.useModernAuthentication">
			</cv-toggle>
		</div>
		<!--Modern Authentication Toggle (Moved out of modal)-->

		<div data-ng-if="(addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.AZURE_AD || addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.MST_AZURE_AD) && !addServiceAccountCtrl.isLocalSystemAcount">

			<div class="plain-accordion">
				<div class="cv-accordion-header">
					<span class="cv-accordion-text"><cv:msg key="header.azureAdApplication" bundle="office365"/></span>			
				</div>                  
			</div>
			<div class="margin-left-20 margin-right-10">
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="applicationId"> <cv:msg
							key="label.applicationId" bundle="exchange"></cv:msg>
					</label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" id="applicationId" name="applicationId"
							data-ng-required="true"
							placeholder='<cv:msg key="placeholder.azureAppId" bundle="office365"/>'
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.azureApp.azureAppId" />
						<div class="help-block"
								data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.applicationId)">
							<cv:msg key="label.appIdRequired" bundle="exchange" />
						</div>
					</div>		
				</div>

				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="secretAccessKey"> <cv:msg
							key="label.azureAppSecret" bundle="office365"></cv:msg>
					</label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" id="secretAccessKey" name="secretAccessKey"
							data-ng-required="true"
							placeholder='{{addServiceAccountCtrl.isServiceAccountEdit?"<cv:msg key="label.passwordKeep" bundle="settings" />":"<cv:msg key="placeholder.azureAppSecret" bundle="office365" />"}}'
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.azureApp.azureAppKeyValue" />
						<div class="help-block"
								data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.secretAccessKey)">
							<cv:msg key="label.appSecretRequired" bundle="exchange" />
						</div>
					</div>		
				</div>

				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="tenantName"> <cv:msg
							key="label.azureDirectoryID" bundle="exchange"></cv:msg>
					</label>
					<div class="col-xs-12 col-lg-8">
						<div>
							<input type="text" id="tenantName" name="tenantName"
								placeholder='<cv:msg key="label.help.azureDirectoryID" bundle="exchange"/>'
								data-ng-required="true"
								data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.azureApp.azureDirectoryId" />
						</div>
						<div class="help-block"
								data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.tenantName)">
							<cv:msg key="label.azureTenantIdRequired" bundle="exchange" />
						</div>
					</div>
				</div>				 
			</div>
			<!--Redirect URI helpText for MS Teams and D365 -->
				<div class="plain-accordion margin-top-20" data-ng-if="addServiceAccountCtrl.isCloudAppsV2Config">
					<div class="cv-accordion-header">
						<span class="margin-right-10">
							<svg version="1.1" id="cv_cc" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
							viewBox="0 0 432.4 432.4" style="enable-background:new 0 0 432.4 432.4;" height="20px" width="20px" xml:space="preserve">
								<path style="fill:#0B2E44;" d="M216.529,93.2c-61.2,0-111.2,50-111.2,111.2c0,32,14,62.8,37.6,83.6c17.6,17.6,16,55.2,15.6,55.6
									c0,2,0.4,3.6,2,5.2c1.2,1.2,3.2,2,4.8,2h102c2,0,3.6-0.8,4.8-2c1.2-1.2,2-3.2,2-5.2c0-0.4-2-38,15.6-55.6
									c0.4-0.4,0.8-0.8,1.2-1.2c23.2-21.2,36.8-51.2,36.8-82.4C327.729,143.2,277.729,93.2,216.529,93.2z M280.529,277.6
									c-0.4,0.4-1.2,1.2-1.2,1.6c-15.6,16.8-18.4,44.4-18.8,57.6h-88.4c-0.4-13.2-3.2-42-20-59.2c-21.2-18.4-33.6-45.2-33.6-73.6
									c0-54,43.6-97.6,97.6-97.6s97.6,43.6,97.6,97.6C313.729,232.4,301.729,259.2,280.529,277.6z"/>
								<path style="fill:#0B2E44;" d="M216.129,121.6c-3.6,0-6.8,3.2-6.8,6.8c0,3.6,3.2,6.8,6.8,6.8c40.4,0,72.8,32.8,72.8,72.8
									c0,3.6,3.2,6.8,6.8,6.8c3.6,0,6.8-3.2,6.8-6.8C302.929,160.4,264.129,121.6,216.129,121.6z"/>
								<path style="fill:#0B2E44;" d="M260.529,358.4h-88.8c-9.2,0-16.8,7.6-16.8,16.8s7.6,16.8,16.8,16.8h88.4
									c9.6-0.4,17.2-7.6,17.2-16.8C277.329,366,269.729,358.4,260.529,358.4z M260.529,378h-88.8c-1.6,0-3.2-1.2-3.2-3.2
									s1.2-3.2,3.2-3.2h88.4c1.6,0,3.2,1.2,3.2,3.2S262.129,378,260.529,378z"/>
								<path style="fill:#0B2E44;" d="M247.329,398.8h-62.4c-9.2,0-16.8,7.6-16.8,16.8s7.6,16.8,16.8,16.8h62.4
									c9.2,0,16.8-7.6,16.8-16.8C264.129,406,256.529,398.8,247.329,398.8z M247.329,418.4h-62.4c-1.6,0-3.2-1.2-3.2-3.2
									s1.2-3.2,3.2-3.2h62.4c1.6,0,3.2,1.2,3.2,3.2S248.929,418.4,247.329,418.4z"/>
								<path style="fill:#0B2E44;" d="M216.129,60c4,0,6.8-3.2,6.8-6.8V6.8c0-3.6-3.2-6.8-6.8-6.8c-3.6,0-6.8,3.2-6.8,6.8v46.4
									C209.329,56.8,212.529,60,216.129,60z"/>
								<path style="fill:#0B2E44;" d="M329.329,34.4c-3.2-2.4-7.2-1.2-9.2,1.6l-25.6,38.4c-2.4,3.2-1.6,7.6,1.6,9.6
									c1.2,0.8,2.4,1.2,3.6,1.2c2.4,0,4.4-1.2,5.6-3.2l25.6-38.4C333.329,40.8,332.529,36.4,329.329,34.4z"/>
								<path style="fill:#0B2E44;" d="M134.929,83.6c1.2,0,2.4-0.4,3.6-1.2c3.2-2,4-6.4,2-9.6l-24.8-38.8c-2-3.2-6.4-4-9.6-2
									s-4,6.4-2,9.6l24.8,38.8C130.529,82.8,132.529,83.6,134.929,83.6z"/>
								<path style="fill:#0B2E44;" d="M86.529,126l-40.4-22c-3.2-1.6-7.6-0.4-9.2,2.8c-2,3.2-0.8,7.6,2.8,9.2l40.4,22
									c1.2,0.4,2,0.8,3.2,0.8c2.4,0,4.8-1.2,6-3.6C90.929,132,89.729,127.6,86.529,126z"/>
								<path style="fill:#0B2E44;" d="M395.729,106.8c-1.6-3.2-6-4.4-9.2-2.8l-40.8,22c-3.2,1.6-4.4,6-2.8,9.2c1.2,2.4,3.6,3.6,6,3.6
									c1.2,0,2.4-0.4,3.2-0.8l40.8-22C396.129,114.4,397.329,110,395.729,106.8z"/>
							</svg>
						</span>
						<span data-ng-if="addServiceAccountCtrl.subMode !== addServiceAccountCtrl.subModes.MST_AZURE_AD" class="cv-accordion-text" data-ng-bind-html="addServiceAccountCtrl.azureAppRedirectUriHelpText"></span>
						<span data-ng-if="addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.MST_AZURE_AD" class="cv-accordion-text" data-ng-bind-html="addServiceAccountCtrl.mst_azureAppRedirectUriHelpText"></span>
					</div>                  
				</div>				
				<!--Redirect URI helpText for MS Teams and D365 -->	
		</div>
		
		<!--Exchange Service Account -- Start-->		
		<div class="margin-top-10" 
			data-ng-if="addServiceAccountCtrl.mode !== addServiceAccountCtrl.office365AppType.SHAREPOINT && addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.EXCHANGE_ONLINE && !addServiceAccountCtrl.isLocalSystemAcount">
			<div class="plain-accordion">
				<div class="cv-accordion-header" ng-if="addServiceAccountCtrl.mode === addServiceAccountCtrl.office365AppType.EXCHANGE">
					<span class="cv-accordion-text"><cv:msg key="header.exchangeonlinesvc" bundle="office365" /></span>			
				</div>                  
				<div class="cv-accordion-header" ng-if="addServiceAccountCtrl.mode !== addServiceAccountCtrl.office365AppType.EXCHANGE">
					<span class="cv-accordion-text"><cv:msg key="headser.serviceAccountDetails" bundle="office365" /></span>			
				</div>                  
			</div>
			<div class="margin-left-20 margin-right-10">
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="exchangeAdminSmtpAddress"><cv:msg
							key="label.emailAddress" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="email" id="exchangeAdminSmtpAddress"
							name="exchangeAdminSmtpAddress"
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.exchangeServiceAccount.exchangeAdminSmtpAddress"
							placeholder='<cv:msg key="label.emailAddressPlaceholder" bundle="exchange"/>'
							data-ng-required="addServiceAccountCtrl.mode === addServiceAccountCtrl.office365AppType.EXCHANGE" />
						<div class="help-block"
								data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.exchangeAdminSmtpAddress)">
							<cv:msg key="error.noEmail" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="password"><cv:msg
							key="label.password" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" name="password" id="password"
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.exchangeServiceAccount.userAccount.password"
							placeholder='{{addServiceAccountCtrl.isServiceAccountEdit?"<cv:msg
						key="label.passwordKeep" bundle="settings" />":""}}'
							data-ng-required="!addServiceAccountCtrl.isServiceAccountEdit" />
						<div class="help-block"
								data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.password)">
							<cv:msg key="error.noPassword" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="confirmPassword"><cv:msg
							key="label.confirmPassword" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" name="confirmPassword" id="confirmPassword"
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.exchangeServiceAccount.userAccount.confirmPassword"
							data-cv-equals="{{addServiceAccountCtrl.office365ServiceAccounts.exchangeServiceAccount.userAccount.password}}"
							data-ng-required="!addServiceAccountCtrl.isServiceAccountEdit" />
						<div class="help-block"
							data-ng-show="addServiceAccoutForm.confirmPassword.$error.required && cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.confirmPassword)">
							<cv:msg key="error.noConfirmPassword" bundle="exchange" />
						</div>
						<div class="help-block"
								data-ng-show="!addServiceAccoutForm.confirmPassword.$error.required && addServiceAccoutForm.confirmPassword.$error.cvEquals && cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.confirmPassword)">
							<cv:msg key="error.mismatchedPassword" bundle="exchange" />
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--Exchange Service Account--End-->

		<!--SharePoint Service Accounts-Start-->
		<div data-ng-if="addServiceAccountCtrl.mode === addServiceAccountCtrl.office365AppType.SHAREPOINT && !addServiceAccountCtrl.isLocalSystemAcount">
			<!--SharePoint SiteUrl (Moved out of modal)-->
			<div data-ng-if="false" class="margin-left-10 margin-right-10 margin-top-20 form-group">
				<label class="col-xs-12 col-lg-3" for="sharePointTenantAdminUrl">
					<cv:msg key="label.sharepoint.siteUrl" bundle="office365" /></label>
				<div class="col-xs-12 col-lg-9">
					<input type="text" id="sharePointTenantAdminUrl" name="sharePointTenantAdminUrl"
						data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.sharePointTenantAdminUrl"
						placeholder='<cv:msg key="placeholder.tenantAdminSiteURL" bundle="office365"/>'
						data-ng-required="addServiceAccountCtrl.mode === addServiceAccountCtrl.office365AppType.SHAREPOINT"
						required autofocus />
					<div class="help-block"
							data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.sharePointTenantAdminUrl)">
						<cv:msg key="error.tenantAdminSiteURL" bundle="clients" />
					</div>
				</div>
			</div>
			<!--SharePoint SiteUrl (Moved out of modal)-->

			<div data-ng-if="addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.SHAREPOINT_ONLINE" class="plain-accordion margin-top-10">
				<div class="cv-accordion-header">
					<span class="cv-accordion-text"><cv:msg key="label.sharePointServiceAccount" bundle="office365"/></span>			
				</div>                  
			</div>
			<div data-ng-if="addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.SHAREPOINT_ONLINE" class="margin-left-20 margin-right-10">
				<div class="form-group">
					<cv-help-text class="col-xs-12 col-lg-3 margin-top-10" help-label="label.username" help-text="help.sharePointAdminUser"/>
					<div class="col-xs-12 col-lg-9">
						<input type="email" id="sharePointAdminUsername"
							name="sharePointAdminUsername"				
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.sharePointServiceAccount.userAccount.userName"
							placeholder='<cv:msg key="label.emailAddressPlaceholder" bundle="exchange"/>'
							required autofocus />
						<div class="help-block"
								data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.sharePointAdminUsername)">
							<cv:msg key="error.sharePointAdminUser" bundle="office365" />
						</div>
					</div>
				</div>
												
				<div class="form-group">
					<label class="col-xs-12 col-lg-3" for="password"><cv:msg
							key="label.password" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-9">
						<input type="password" name="password" id="password"
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.sharePointServiceAccount.userAccount.password"
							placeholder='{{addServiceAccountCtrl.isServiceAccountEdit?"<cv:msg key="label.passwordKeep" bundle="settings" />":""}}'
							data-ng-required="!addServiceAccountCtrl.isServiceAccountEdit" />
						<div class="help-block"
								data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.password)">
							<cv:msg key="error.noPassword" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-3" for="confirmPassword"><cv:msg
							key="label.confirmPassword" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-9">
						<input type="password" name="confirmPassword" id="confirmPassword"
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.sharePointServiceAccount.userAccount.confirmPassword"
							data-cv-equals="{{addServiceAccountCtrl.office365ServiceAccounts.sharePointServiceAccount.userAccount.password}}"
							data-ng-required="!addServiceAccountCtrl.isServiceAccountEdit" />
						<div class="help-block"
							data-ng-show="addServiceAccoutForm.confirmPassword.$error.required && cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.confirmPassword)">
							<cv:msg key="error.noConfirmPassword" bundle="exchange" />
						</div>
						<div class="help-block"
								data-ng-show="!addServiceAccoutForm.confirmPassword.$error.required && addServiceAccoutForm.confirmPassword.$error.cvEquals && cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.confirmPassword)">
							<cv:msg key="error.mismatchedPassword" bundle="exchange" />
						</div>
					</div>
				</div>
			</div>
			
			<!--Azure Storage Account-->
			<div data-ng-if="addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.SHAREPOINT_AZURE_STORAGE" class="plain-accordion margin-top-10">
				<div class="cv-accordion-header">
					<span class="cv-accordion-text"><cv:msg key="label.azureStorageAccount" bundle="office365"/></span>			
				</div>                  
			</div>
			<div data-ng-if="addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.SHAREPOINT_AZURE_STORAGE" class="margin-left-20 margin-right-10">
				<div class="form-group">
					<cv-help-text class="col-xs-12 col-lg-3 margin-top-10" help-label="label.username" help-text="help.sharepointAzureStorageUser"/>
					<div class="col-xs-12 col-lg-9">
						<input type="text" id="azureUserAccount"
							name="azureUserAccount"
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.azureStorageServiceAccount.userAccount.userName"
							data-ng-required="addServiceAccountCtrl.office365ServiceAccounts.azureStorageServiceAccount.userAccount.password" />
						<div class="help-block"
							data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.azureUserAccount)">
							<cv:msg key="error.sharepointAzureStorageUser" bundle="office365" />
						</div>
					</div>
				</div>
												
				<div class="form-group">
					<label class="col-xs-12 col-lg-3" for="azurePassword"><cv:msg
							key="label.key" bundle="office365" /></label>
					<div class="col-xs-12 col-lg-9">
						<input type="password" name="azurePassword" id="azurePassword"
							data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.azureStorageServiceAccount.userAccount.password"
							placeholder='{{addServiceAccountCtrl.isServiceAccountEdit?"<cv:msg key="label.passwordKeep" bundle="settings" />":""}}'
							data-ng-required="addServiceAccountCtrl.office365ServiceAccounts.azureStorageServiceAccount.userAccount.userName && !addServiceAccountCtrl.isServiceAccountEdit" />
						<div class="help-block"
								data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.azurePassword)">
							<cv:msg key="error.sharePointAzureStorageKey" bundle="office365" />
						</div>
					</div>
				</div>
			</div>								
		</div>
		<!--SharePoint Service Accounts-End-->

		<!--Local System Account-Start-->
		<div class="margin-left-20 margin-right-10" data-ng-if="addServiceAccountCtrl.isLocalSystemAcount && addServiceAccountCtrl.subMode === addServiceAccountCtrl.subModes.SYSTEM_ACCOUNT">
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="localSystemAccountUser"><cv:msg
						key="label.username" bundle="office365" /></label>
				<div class="col-xs-12 col-lg-8">
					<input type="text" id="localSystemAccountUser"
						name="localSystemAccountUser"
						data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.localSystemAdministratorServiceAccount.userAccount.userName"
						placeholder='<cv:msg key="label.helptextDomain" bundle="serversJs"/>\<cv:msg key="label.helpTextUsername" bundle="serversJs"/>'
						data-ng-required="addServiceAccountCtrl.isLocalSystemAcount" />
						<div class="help-block"
							data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.localSystemAccountUser)">
						<cv:msg key="error.noUserName" bundle="exchange" />
					</div>
				</div>
			</div>				
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="password"><cv:msg
						key="label.password" bundle="exchange" /></label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" name="password" id="password"
						data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.localSystemAdministratorServiceAccount.userAccount.password"
						placeholder='{{addServiceAccountCtrl.isServiceAccountEdit?"<cv:msg
					key="label.passwordKeep" bundle="settings" />":""}}'
						data-ng-required="!addServiceAccountCtrl.isServiceAccountEdit" />
					<div class="help-block"
						data-ng-show="cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.password)">
						<cv:msg key="error.noPassword" bundle="exchange" />
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="confirmPassword"><cv:msg
						key="label.confirmPassword" bundle="exchange" /></label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" name="confirmPassword" id="confirmPassword"
						data-ng-model="addServiceAccountCtrl.office365ServiceAccounts.localSystemAdministratorServiceAccount.userAccount.confirmPassword"
						data-cv-equals="{{addServiceAccountCtrl.office365ServiceAccounts.localSystemAdministratorServiceAccount.userAccount.password}}"
						data-ng-required="!addServiceAccountCtrl.isServiceAccountEdit" />
					<div class="help-block"
						data-ng-show="addServiceAccoutForm.confirmPassword.$error.required && cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.confirmPassword)">
						<cv:msg key="error.noConfirmPassword" bundle="exchange" />
					</div>
					<div class="help-block"
						data-ng-show="!addServiceAccoutForm.confirmPassword.$error.required && addServiceAccoutForm.confirmPassword.$error.cvEquals && cv.addServiceAccoutForm.needsAttention(addServiceAccoutForm.confirmPassword)">
						<cv:msg key="error.mismatchedPassword" bundle="exchange" />
					</div>
				</div>
			</div>
		</div>
		<!--Local System Account-End-->
	</div>
	<div class="modal-footer">
		<button id="addServiceAccountForOffice365_button_#2842" class="btn btn-default" type="button" 
			data-ng-click="addServiceAccountCtrl.cancel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="addServiceAccountForOffice365_button_#2284" class="btn btn-primary" type="submit" 
			ng-show="!addServiceAccountCtrl.isServiceAccountEdit">
			<cv:msg key="Add" bundle="messages" />
		</button>
		<button id="addServiceAccountForOffice365_button_#3338" class="btn btn-primary" type="submit" 
			ng-show="addServiceAccountCtrl.isServiceAccountEdit">
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
</form>
