<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages> //generic error
	<cv:cvMessages bundle="localization.notesDatabase"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages> //needed for job info display
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages> //also needed for displaying the toast message
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages> //needed for job details and error display
</script>
<div class="setup-title">
	<h1><cv:msg key="label.restoreOpts" bundle="restore" /></h1>
</div>
<div class="bootstrap-wrapper">
	<div class="col-md-12">
		<div class="{{notesDbRestoreOptionsCtrl.serverMessage.type}} serverMessage">{{notesDbRestoreOptionsCtrl.serverMessage.message}}</div>
	</div>
	<form class="form-horizontal" data-cv-submit="notesDbRestoreOptionsCtrl.doRestore()" novalidate name="notesDbRestoreForm" autocomplete="off">
		<div class="panel panel-default">
			<div class="panel-body">
				<!-- Destination client -->
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="destinationClient"><cv:msg key="notesDb.restore.destination.client.name" bundle="notesDatabase"/>
						<cv-help-component help-text="<cv:msg key="notesDb.restore.destination.client.help" bundle="notesDatabase"/>"></cv-help-component>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						 <select id="destinationClient" name="destinationClient"  data-ng-model="notesDbRestoreOptionsCtrl.model.destinationClient"
			   					 data-ng-options="ce as ce.clientName for ce in notesDbRestoreOptionsCtrl.destinationServerList | orderBy:'clientName'"
			   					 data-ng-change="notesDbRestoreOptionsCtrl.getInstancesForClients(notesDbRestoreOptionsCtrl.model.destinationClient.clientId)" required>
							<option value=""><cv:msg key="label.notesDb.restore.select.destination.client" bundle="notesDatabase"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.notesDbRestoreForm.needsAttention(notesDbRestoreForm.destinationClient)"><cv:msg key="error.notesDb.restore.destination.client.empty" bundle="notesDatabase"/></span>
					</div>
				</div>
				<!-- End of destination client -->
				<!-- Destination Instance(partition) -->
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="destinationInstance"><cv:msg key="notesDb.restore.destination.partition" bundle="notesDatabase"/>
						<cv-help-component help-text="<cv:msg key="notesDb.restore.destination.partition.help" bundle="notesDatabase"/>"></cv-help-component>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<!-- If same destination as current SC is selected, instances DropDown is disabled. -->
						 <select id="destinationInstance" name="destinationInstance"  data-ng-model="notesDbRestoreOptionsCtrl.model.destinationInstance"
			   					 data-ng-options="ins as ins.instanceName | extractNotesDbDominoPath for ins in notesDbRestoreOptionsCtrl.destinationInstanceList"
			   					 data-ng-disabled="notesDbRestoreOptionsCtrl.entity.clientId === notesDbRestoreOptionsCtrl.model.destinationClient.clientId"
			   					 data-ng-required="notesDbRestoreOptionsCtrl.entity.clientId !== notesDbRestoreOptionsCtrl.model.destinationClient.clientId">
							<option value=""><cv:msg key="label.notesDb.restore.select.destination.instance" bundle="notesDatabase"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.notesDbRestoreForm.needsAttention(notesDbRestoreForm.destinationInstance)">
							<cv:msg key="error.notesDb.restore.destination.instance.empty" bundle="notesDatabase"/>
						</span>
					</div>
				</div>
				<!-- End of destination Instance -->
				<!-- Restore to original folder : when selected, enable the browse section below-->
				<div class="form-group">
                    <div class="col-xs-12">
                        <input id="inplace" name="inplace"  type="checkbox" data-ng-model="notesDbRestoreOptionsCtrl.model.restoreToOriginalPath" />
                        <label  for="inplace"><cv:msg key="label.restoreToOriginal" bundle="restore"/></label>
                    </div>
                </div>
				<!-- End of Restore to original folder -->
				<!-- Browse destination path : when the restore to same folder is selected, this section will be disabled-->
				<div class="form-group">
                    <label class="col-xs-12 col-md-5 col-lg-5" for="restoreDestinationPath"><cv:msg key="label.destPath" bundle="snapArray"/></label>
                    <div class="col-xs-12 col-md-7 col-lg-7">
                         <div class="input-group" data-ng-disabled="!notesDbRestoreOptionsCtrl.model.destinationClient || notesDbRestoreOptionsCtrl.model.restoreToOriginalPath">
                                 <input type="text" id="restoreDestinationPath" name="restoreDestinationPath"
                                     data-ng-model="notesDbRestoreOptionsCtrl.model.destinationPath"
                                     data-ng-required="!notesDbRestoreOptionsCtrl.model.restoreToOriginalPath" />
                                 <span class="input-group-btn">
                                       <button id="notesDbRestoreOptions_button_#4284" class="btn btn-default" type="button" 
                                           data-ng-click="notesDbRestoreOptionsCtrl.openDestinationFolder()"><cv:msg key="label.browse" bundle="restore"/>
                                       </button>
                                 </span>
                         </div>
                         <span class="help-block" data-ng-show="cv.notesDbRestoreForm.needsAttention(notesDbRestoreForm.restoreDestinationPath)">
                             <cv:msg key="error.pathRequired" bundle="restore"/>
                         </span>
                    </div>
                </div>
				<!-- End of Browse destination path-->
				<!-- Header for 'options': -->
				<br>
				<h4><cv:msg key="label.restore.options" bundle="notesDatabase"/></h4>
				<!-- End of Header for 'options': -->
				<!-- Unconditional Overwrite-->
				<div class="form-group">
                    <div class="col-xs-12">
                        <input id="unconditionalOverwrite" name="unconditionalOverwrite"  type="checkbox" data-ng-model="notesDbRestoreOptionsCtrl.model.unconditionalOverwrite" />
                        <label  for="unconditionalOverwrite"><cv:msg key="label.restore.unconditionalOverwrite" bundle="notesDatabase"/></label>
                    </div>
                </div>
				<!-- End of Unconditional Overwrite -->
				<!-- Change DB InstanceId-->
				<div class="form-group">
                    <div class="col-xs-12" data-ng-disabled="notesDbRestoreOptionsCtrl.model.doNotReplayTransactionLogs">
                        <input id="changeDbInstanceId" name="changeDbInstanceId"  type="checkbox"
                        	   data-ng-model="notesDbRestoreOptionsCtrl.model.changeDbInstanceId"
                        	   data-ng-change="notesDbRestoreOptionsCtrl.computeOptionsSelections()"/>
                        <label  for="changeDbInstanceId"><cv:msg key="label.restore.changeDbInstanceId" bundle="notesDatabase"/></label>
                    </div>
                </div>
				<!-- End of Change DB InstanceId -->
				<!-- Change db replicaId-->
				<div class="form-group">
                    <div class="col-xs-12" data-ng-disabled="notesDbRestoreOptionsCtrl.model.doNotReplayTransactionLogs">
                        <input id="changeDbReplicaId" name="changeDbReplicaId"  type="checkbox"
                        	   data-ng-model="notesDbRestoreOptionsCtrl.model.changeDbReplicaId"
                        	   data-ng-change="notesDbRestoreOptionsCtrl.computeOptionsSelections()"/>
                        <label  for="changeDbReplicaId"><cv:msg key="label.restore.changeDbReplicaId" bundle="notesDatabase"/></label>
                    </div>
                </div>
				<!-- End of Change db replicaId- -->
				<!-- Change db instanceId (Necessary)-->
				<div class="form-group">
                    <div class="col-xs-12" data-ng-disabled="notesDbRestoreOptionsCtrl.model.doNotReplayTransactionLogs">
                        <input id="changeDbInstanceIdIfNecessary" name="changeDbInstanceIdIfNecessary"  type="checkbox"
                        	data-ng-model="notesDbRestoreOptionsCtrl.model.changeDbInstanceIdIfNecessary"
                        	data-ng-change="notesDbRestoreOptionsCtrl.computeOptionsSelections()"/>
                        <label for="changeDbInstanceIdIfNecessary"><cv:msg key="label.restore.changeDbInstanceIdIfNecessary" bundle="notesDatabase"/>
                        	<cv-help-component help-text="<cv:msg key="notesDb.restore.changeDbInstanceIdIfNecessary.help" bundle="notesDatabase"/>"></cv-help-component>
                        </label>
                    </div>
                </div>
				<!-- End of Change db instanceId (Necessary)-->
				<!-- transactionLogs-->
				<div class="form-group">
                    <div class="col-xs-12">
                        <input id="doNotReplayTransactionLogs" name="doNotReplayTransactionLogs"  type="checkbox"
                        	data-ng-model="notesDbRestoreOptionsCtrl.model.doNotReplayTransactionLogs"
                        	data-ng-change="notesDbRestoreOptionsCtrl.computeOptionsSelections()"/>
                        <label  for="doNotReplayTransactionLogs"><cv:msg key="label.restore.doNotReplayTransactionLogs" bundle="notesDatabase"/></label>
                    </div>
                </div>
				<!-- End of transactionLogs -->
			</div>
		</div>
		<div class="modal-footer">
			<button id="notesDbRestoreOptions_button_#6386" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="notesDbRestoreOptionsCtrl.cancelModal()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="notesDbRestoreOptions_button_#3675" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="label.button.restore" bundle="notesDatabase"/></button> 
		</div>
	</form>
</div>
