<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.notesDatabase"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="action.createPartition" bundle="notesDatabase"/> </h1>
</div>
<div class="panel">
	<form name="addPartitionForm" data-cv-submit="notesdbAddPartition.addPartition()" novalidate autocomplete="off">
		<div class="panel-body">
			<div class="form-group" data-ng-if="notesdbAddPartition.selectExistingPartition">
				<cv-grid cv-grid-options="notesdbAddPartition.gridOptions"></cv-grid>
			</div>
			<div class="form-group" data-ng-if="!notesdbAddPartition.selectExistingPartition">
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="partitionName">
						<cv:msg key="label.notesdb.partitionName" bundle="notesDatabase"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="partitionName" name="partitionName"  data-ng-model="notesdbAddPartition.partitionEntity.instanceName" required/>
						<span class="help-block" data-ng-show="cv.addPartitionForm.needsAttention(addPartitionForm.partitionName);" >
							<cv:msg key="error.partitionName" bundle="notesDatabase"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="dominoDataDirectory">
						<cv:msg key="notesdb.domino.data.directory" bundle="notesDatabase"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="dominoDataDirectory" name="dominoDataDirectory"  data-ng-model="notesdbAddPartition.instInfo.dominoDataDirectory" required/>
						<span class="help-block" data-ng-show="cv.addPartitionForm.needsAttention(addPartitionForm.dominoDataDirectory);" >
							<cv:msg key="error.dominoDataDirectory" bundle="notesDatabase"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="dominoBinaryDirectory">
						<cv:msg key="label.notesdb.dominoBinaryDirectory" bundle="notesDatabase"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="dominoBinaryDirectory" name="dominoBinaryDirectory"  data-ng-model="notesdbAddPartition.instInfo.dominoBinaryDirectory" required/>
						<span class="help-block" data-ng-show="cv.addPartitionForm.needsAttention(addPartitionForm.dominoBinaryDirectory);" >
							<cv:msg key="error.dominoBinaryDirectory" bundle="notesDatabase"/>
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!notesdbAddPartition.pushInstallMode">
					<label class="col-xs-12 col-lg-5" for="dominoUserName">
						<cv:msg key="label.notesdb.dominoUserName" bundle="notesDatabase"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="dominoUserName" name="dominoUserName"  data-ng-model="notesdbAddPartition.instInfo.dominoUserName" required/>
						<span class="help-block" data-ng-show="cv.addPartitionForm.needsAttention(addPartitionForm.dominoUserName);" >
							<cv:msg key="error.dominoUserName" bundle="notesDatabase"/>
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!notesdbAddPartition.pushInstallMode">
					<label class="col-xs-12 col-lg-5" for="storagePolicy">
						<cv:msg key="header.storagePolicy" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<select id="storagePolicy" name="storagePolicy"
							data-ng-options="sp as sp.storagePolicyName for sp in notesdbAddPartition.storagePolicyList | orderBy: 'storagePolicyName' track by sp.storagePolicyId"
							data-ng-model="notesdbAddPartition.instInfo.storagePolicy"
							data-ng-required="true">
						</select>
						<span class="help-block" data-ng-show="cv.addPartitionForm.needsAttention(addPartitionForm.storagePolicy);" >
							<cv:msg key="error.selectStoragePolicy" bundle="clients"/>
						</span>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="notesDbNewPartition_button_#2423" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="notesdbAddPartition.closeDialogBox()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="notesDbNewPartition_button_#5353" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Add" bundle="messages"/></button> 
		</div>
	</form>
</div>