<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.users"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<!-- <h1 class="page-title">
	<span data-ng-bind="agentDetails.idaEntity.appName"	data-ng-show="serverMessage.message==''"></span>
	<span data-ng-bind="serverMessage.message"></span>
</h1> -->
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="agentDetails.idaEntity.appName" data-ng-show="serverMessage.message==''"></h1>
		<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<span data-ng-if="agentDetails"><a class="page-action-item" href="" data-ng-href="{{getRestoreHistoryUrl()}}"><cv:msg key="label.RestoreHistory" bundle="clients" /></a></span>
		<span data-ng-if="agentDetails"><a class="page-action-item" href="" data-ng-href="{{getBackupHistoryUrl()}}"><cv:msg key="label.BackupHistory" bundle="clients" /></a></span>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="sharepointDetails-heading_clientGeneral-clients" title='<cv:msg key="heading.clientGeneral" bundle="clients" />' data-loader="agentDetails">
			<ul class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.clientName" bundle="clients" /></span>
					<span class="pageDetailColumn" data-ng-bind="agentDetails.idaEntity.clientName"></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="header.installDate" bundle="clients" /></span>
					<span class="pageDetailColumn" data-ng-bind="(agentDetails && agentDetails.AgentProperties.installDate*1000 | date:'medium')"></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="header.Version" bundle="clients" /></span>
					<span class="pageDetailColumn" data-ng-bind="agentDetails.AgentProperties.agentVersion"></span></li>
			</ul>
		</cv-tile-component>
		<cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded="associationsLoaded">
		</cv-security-component>
	</div>
	<div class="col-md-6">
		<!-- Begin activity control -->
		<cv-activity-control-component data-ac-params="acParams">
		</cv-activity-control-component>
		<!-- End Activity control -->
    <cv-analytics-plan-component  data-ng-show="isAnalyticsEnabled" datasource-type="sharePointDataSourceType" client-guid="CSGUID" client-id="genericEntity.clientId" enable-data-analysis="enableDataAnalysis" ></cv-analytics-plan-component>
	<cv-client-plan-component data-ng-if="agentDetails.idaEntity.clientId" client-id="agentDetails.idaEntity.clientId" plan-id="agentDetails.planId"
			plan-entity="agentDetails.planEntity" app-id="agentDetails.idaEntity.applicationId"></cv-client-plan-component>
   </div>
</div>
<span data-ng-if="childList">
	<cv-grid cv-grid-options="gridOptions"></cv-grid>
</span>
<div class="page-details-list maxdiv" data-ng-if="instanceSupported && childList.length==0">
	<div class="extra-spacing"><cv:msg key="label.noInstances" bundle="clients"/></div>
</div>
