<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
</script>
<div class="bootstrap-wrapper">
	<form name="restoreForm" class="form-horizontal" novalidate data-cv-submit="configRepliFsGroupTarget.doFsLiveSync()" autocomplete="off">
		<div class="panel panel-default setup-panel">
			<div class="panel-heading">
				<div class="panel-title">
					<cv:msg key="label.selectTarget" bundle="vmsJs"></cv:msg>
				</div>
			</div>
			<div class="panel-body">
				<div class="row">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
						<!--      <form class="form-horizontal" data-ng-submit="doFsLiveSync()">   -->
						<span class="{{configRepliFsGroupTarget.serverMessage.type}}"
							data-ng-bind="configRepliFsGroupTarget.serverMessage.message"></span>
						<div class="form-group">
							<label for="destinationServer"
								class="restorePathLabel col-xs-12 col-md-4"><cv:msg
									key="label.destClient" bundle="oracle" /></label>
							<div class="col-xs-12 col-md-8">
								<select id="destinationServer" name="destinationServer"
									data-ng-required="true"
									data-ng-model="configRepliFsGroupTarget.restoreData.globalOptions.destinationServer"
									data-ng-options="ds as ds.clientName for ds in configRepliFsGroupTarget.restoreData.globalOptions.destinationServerList | orderBy:'clientName' track by (ds.clientName|lowercase)"
									data-ng-change="configRepliFsGroupTarget.destinationServerChanged()">
									<option value=""><cv:msg
											key="placeholder.selectDestinationHost" bundle="restoreJs" /></option>
								</select> <span class="help-block"
									data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationServer)">
									<cv:msg key="error.destinationServer" bundle="restore" />
								</span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4"><cv:msg
									key="label.copyName" bundle="restore"></cv:msg></label>
							<div class="col-xs-12 col-md-8">
								<isteven-multi-select id="selectFsTarget_isteven-multi-select_#6417" 
								    data-input-model="configRepliFsGroupTarget.backupsources"
									data-output-model="configRepliFsGroupTarget.policy"
									data-tick-property="checked"
									data-item-label="storagePolicyName"
									class="isteven-multi-select user-group-select"
									data-button-label="storagePolicyName"
									data-helper-elements="filter"
									on-item-click="configRepliFsGroupTarget.storagePolicyClick(data)"
									data-selection-mode="single" translation="configRepliFsGroupTarget.localLang"></isteven-multi-select>
								<div class="help-block" data-ng-if="configRepliFsGroupTarget.copyPrecedenceWarning">
									<cv:msg key="error.copyPrecedence" bundle="restore" />
								</div>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4"><cv:msg key="label.noOfStreams" bundle="oracle"></cv:msg></label>
							<div class="col-xs-12 col-md-8">
                				<input type="number" min="2" max="1000" required data-ng-model="configRepliFsGroupTarget.noOfStreams">
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4"><cv:msg
									key="label.schedule" bundle="profiles"></cv:msg></label>
							<div class="col-xs-12 col-md-8">
								<input type="text"
								    data-ng-disabled="true"
									data-ng-model="configRepliFsGroupTarget.schedule"
									readonly>
							</div>
						</div>
<!-- START : for non block level -->
						<div data-ng-disabled="!configRepliFsGroupTarget.restoreToOriginalFolderEnabled" data-ng-if="!configRepliFsGroupTarget.subclientIsBlockLevelBackup">
							<input name="inplace" id="inplace" type="checkbox"
								data-ng-model="configRepliFsGroupTarget.restoreData.globalOptions.restoreToOriginalPath"
								data-ng-change="configRepliFsGroupTarget.loadTaskModule()">
							<label for="inplace" class="overwriteLabel"><cv:msg
									key="label.restoreToDestination" bundle="restore" /></label>
						</div>
					<div data-ng-if="!configRepliFsGroupTarget.subclientIsBlockLevelBackup" data-uib-collapse="configRepliFsGroupTarget.restoreData.globalOptions.restoreToOriginalPath">
						<div class="form-group"  >
							<label class="col-xs-12 col-md-4"><cv:msg
									key="label.destPath" bundle="snapArray" /></label>
							<div class="col-xs-12 col-md-8">
								<div class="input-group">
									<input type="text" name="restorePath" id="restorePath"
										data-ng-model="configRepliFsGroupTarget.selectedPath"
										data-ng-disabled="configRepliFsGroupTarget.restoreData.globalOptions.restoreToOriginalPath"
										data-ng-required="!configRepliFsGroupTarget.restoreData.globalOptions.restoreToOriginalPath">
									<span class="input-group-btn">
										<button id="selectFsTarget_button_#3624" class="btn btn-default" 
											data-ng-click="configRepliFsGroupTarget.openSelectDestinationFolder(configRepliFsGroupTarget.restoreData.subClientEntity, null)"
											data-ng-disabled="configRepliFsGroupTarget.restoreData.globalOptions.destinationServer.clientName == null "
											type="button">
											<cv:msg key="label.browse" bundle="restore" />
										</button>
									</span>
								</div>
								<!-- /input-group -->
								<div class="help-block"
									data-ng-show="configRepliFsGroupTarget.isRestoreDestinationPathNeeded() && cv.restoreForm.needsAttention(restoreForm.restorePath)">
									<cv:msg key="error.pathRequired" bundle="restore" />
								</div>
							</div>
						</div>
						<div class="credentials">
							<span class="border-title"><cv:msg key="label.impersonate"
									bundle="restore" /></span>
							<div class="form-group">
								<label class="col-xs-12 col-md-4"><cv:msg
										key="label.username" bundle="restore" /> </label>
								<div class="col-xs-12 col-md-8">
									<input type="text" name="impersonateUserName"
										data-ng-model="configRepliFsGroupTarget.restoreData.globalOptions.impersonateUserName"
										data-ng-required="configRepliFsGroupTarget.isUserImpersonationNeeded()" /> <span
										class="help-block"
										data-ng-show="configRepliFsGroupTarget.isUserImpersonationNeeded() && cv.restoreForm.needsAttention(restoreForm.impersonateUserName)">
										<cv:msg key="error.userNameRequired" bundle="restore" />
									</span>
								</div>
								<label class="col-xs-12 col-md-4"><cv:msg
										key="label.password" bundle="restore" /> </label>
								<div class="col-xs-12 col-md-8">
									<input type="password" name="impersonatePassword"
										data-ng-model="configRepliFsGroupTarget.restoreData.globalOptions.impersonatePassword"
										data-ng-required="configRepliFsGroupTarget.isUserImpersonationNeeded()" /> <span
										class="help-block"
										data-ng-show="configRepliFsGroupTarget.isUserImpersonationNeeded() && cv.restoreForm.needsAttention(restoreForm.impersonatePassword)">
										<cv:msg key="error.uncPasswordRequired" bundle="restore" />
									</span>
								</div>
							</div>
						</div>
					</div>
					<!-- Advanced Options -->
					<div data-ng-if="!configRepliFsGroupTarget.subclientIsBlockLevelBackup" class="form-header cursor-pointer push-down"
						data-ng-click="configRepliFsGroupTarget.model.options = !configRepliFsGroupTarget.model.options">
						<cv:msg key="label.advanced.options" bundle="restore" />
						<i class="pull-right"
							data-ng-class="{'ion-chevron-down': configRepliFsGroupTarget.model.options, 'ion-chevron-right': !configRepliFsGroupTarget.model.options}"></i>
					</div>
					<div data-uib-collapse="!configRepliFsGroupTarget.model.options">
						<div class="form-group">
							<div class="col-xs-12 pull-right" style="clear: both;" >
								<input name="restoreAcls" id="restoreAcls" type="checkbox"
									data-ng-model="configRepliFsGroupTarget.restoreData.globalOptions.restoreAcls">
								<label for="restoreAcls" class="restoreAclsLabel"><cv:msg
									key="label.restoreDataAcls" bundle="restore" /></label>
								<div class="col-xs-12 col-md-8 pull-right" style="clear: both;" data-ng-if="!configRepliFsGroupTarget.disablevalidateOnly" >
								<input name="validateOnly" id="validateOnly" type="checkbox"
									data-ng-model="configRepliFsGroupTarget.restoreData.globalOptions.validateOnly">
								<label for="validateOnly" class="validateOnlyLabel"><cv:msg
									key="label.validateOnly" bundle="restore" /></label>
								</div>
							</div>
						</div>
						<div class="form-group">
							<div class="col-xs-12 pull-right" style="clear: both;">
								<input name="overwrite" id="overwrite" type="checkbox"
									data-ng-model="configRepliFsGroupTarget.restoreData.globalOptions.overwrite">
								<label for="overwrite" class="overwriteLabel"><cv:msg
									key="warning.overwrite" bundle="restore" /></label>
							</div>
						</div>
					</div>
<!-- END : for non block level -->
<!-- START : for block level -->
<div class="form-group" data-ng-if="configRepliFsGroupTarget.subclientIsBlockLevelBackup">
							<label class="col-xs-12 col-md-4"><cv:msg
									key="label.destPath" bundle="snapArray" /></label>
			<div class="form-group col-xs-12 col-md-8" >
				<span data-ng-repeat="item in configRepliFsGroupTarget.fsReplicationGroup.sourceItemsToRestore">
					<!-- <label  for="restorePath-{{$index}}">{{item.path}}</label> -->
					<div class="input-group">
						<span class="input-group-addon" style="background-color: transparent; border: none;">{{item.path}}</span>
						<input
							data-ng-required="true"
							type="text"
							name="restorePath-{{$index}}"
							id="restorePath-{{$index}}"
							data-ng-model="item.selectedPath"
							 />
						<span class="input-group-btn">
							<button id="selectFsTarget_button_#6900" class="btn btn-default" 
								data-ng-click="configRepliFsGroupTarget.openSelectDestinationFolder(configRepliFsGroupTarget.restoreData.subClientEntity, item)"
								type="button">
								<cv:msg key="label.browse" bundle="restore" />
							</button>
						</span>
					</div>
					<span class="help-block"
									data-ng-show="cv.restoreForm.needsAttention(restoreForm['restorePath-' + $index])">
									<cv:msg key="label.browse" bundle="restore" />
								</span>
				</span>
			</div>
<!-- END : for block level -->
					</div>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button id="selectFsTarget_button_#5597" class="btn btn-default" type="button" 
				data-ng-click="$state.go('configureReplicationGroup.selectFsContent')">
				<cv:msg key="Back" bundle="messages"></cv:msg>
			</button>
			<button id="selectFsTarget_button_#0908" class="btn btn-primary" type="submit" data-ng-if="replicationGroup.task"> 
				<cv:msg key="Save" bundle="messages"></cv:msg>
			</button>
			<button id="selectFsTarget_button_#4570" class="btn btn-primary" type="submit" data-ng-if="!replicationGroup.task" data-ng-disabled="!configRepliFsGroupTarget.fsReplicationGroup"> 
				<cv:msg key="Submit" bundle="messages"></cv:msg>
			</button>
		</div>
	</form>
</div>
