<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
		<h1 data-ng-bind="mountTypeLabel"></h1>
</div>
<fmt:bundle basename="localization.blrJs">
<div class="bootstrap-wrapper modal-margin margin-top-10">

	<div class="text-center"
			data-ng-show="!mountModalData.showModal">
			<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
	</div>
<form name="createMountForm" novalidate autocomplete="off" id="createMountForm"
data-cv-submit="saveData(this)" class="form-horizontal">
		<div  data-ng-show="mountModalData.showModal">

				<div class="form-group margin-bottom-10" id="divServerMessage">
					<span class="{{serverMessage.type}} serverMessage"
					data-ng-bind="serverMessage.message"></span>
				</div>
				<br>
				<div class="form-group">
				     <div class="col-xs-12 col-md-5 col-lg-5" >
				     <cv:msg key="label.destinationClient" bundle="blrJs"/></div>
				     <div class="col-xs-12 col-md-7 col-lg-7">
							<span data-ng-bind="mountModalData.destinationName" ></span>
				     </div>
				 </div>
				<div class="form-group">
						<div class="col-lg-12">
							<span class="help-block" data-ng-show="!mountModalData.destinationClient">
										<i class="ion-alert-circled" ></i>
										<cv:msg key="error.noBLRPackageFoundOnDestinationClient" bundle="fs" />
									</span>
						</div>
				</div>
				<!-- Display selected volumes and Browse Button - GRID : START -->
				<div class="form-group">
					<div class="col-xs-12 col-md-8 padding-top-5" >
					</div>
				</div>
				<div class="editReplicationPair" >
					<cv-kendo-grid id="gridMountModal" data-cv-grid-options="gridOptionsMountModal"></cv-kendo-grid>
				</div>
						<div class="form-group">
						<div class="col-xs-12 col-md-8 padding-top-5" >
						<span class="help-block"
							data-ng-show="mountModalData.atleastOnePathSelected != null && !mountModalData.atleastOnePathSelected">
							<i class="ion-alert-circled" ></i>
							<cv:msg key="error.selectAtleastOnePath" bundle="blrJs" />
						</span>
						</div>
						</div>
				<!-- Display selected volumes and Browse Button - GRID : END -->
				 <div class="form-group" data-ng-show="mountModalData.mountType==='test'">
					<label class="col-xs-12 col-md-5 col-lg-5" for="days"><cv:msg key="label.expiryTime" bundle="blrJs"/></label>
					<div class="col-xs-12 col-md-3 col-lg-3">
						<input type="number" data-ng-model="mountModalData.days" min="0" max="30"  data-ng-maxlength="2"  id="days" name="days" required ng-class="{'has-error': cv.createMountForm.needsAttention(createMountForm.days)}"/> <label class="inline-label" for="days"><cv:msg key="label.days" bundle="blrJs"/></label>
					</div>
					<div class="col-xs-12 col-md-4 col-lg-4">
						<input type="number" data-ng-model="mountModalData.hours" min="0" max="23"  data-ng-maxlength="2"  id="hours" name="hours" required ng-class="{'has-error': cv.createMountForm.needsAttention(createMountForm.hours)}" /> <label class="inline-label" for="hours"><cv:msg key="label.hours" bundle="blrJs"/></label>
					</div>
					<div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
						<span class="help-block" ng-show="createMountForm.days.$invalid && cv.createMountForm.needsAttention(createMountForm.days)">
									<fmt:message key="error.expiryDays.invalid" />
						</span>
						<span class="help-block" ng-show="createMountForm.hours.$invalid && cv.createMountForm.needsAttention(createMountForm.hours)">
									<fmt:message key="error.expiryHours.invalid" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="recoveryType"><cv:msg key="header.recoveryType" bundle="blrJs"/></label>
				    <div class="col-xs-12 col-md-7 col-lg-7 ">
				        <select  name="recoveryType" id="recoveryType" data-ng-model="mountModalData.recoveryType" data-ng-change="setOptions()">
								<option value="latest" title="<fmt:message key="label.latestPointInTime" />"><fmt:message key="label.latestPointInTime"  /></option>
								<option value="GRAPH" data-ng-if="(mountModalData.rpsMap !== null)"><fmt:message key="label.selectFromGraph" /></option>
								<option  value="SNAP"  title="<fmt:message key="label.snapshotTime" />" data-ng-if="SNAP"><fmt:message key="label.snapshotTime" /></option>
								<option value="CRASH"  title="<fmt:message key="label.crashConsistentRPT" />" data-ng-if="CRASH"><fmt:message key="label.crashConsistentRPT" /></option>
								<option value="APP"    title="<fmt:message key="label.appConsistentRPT" />" data-ng-if="APP"><fmt:message key="label.appConsistentRPT" /></option>
				        </select>
					</div>
				</div>
				<div class="form-group" data-ng-hide="(mountModalData.recoveryType=='latest')||(mountModalData.recoveryType=='GRAPH')">
					<label class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.selectRestorePoint" bundle="blrJs"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7 ">
				        <select id="snapshotTimeDetailDate" data-ng-options="((timeStamp*1000)|date:'medium') for timeStamp in SNAP" data-ng-model="mountModalData.selectedSnapRP" data-ng-if="mountModalData.recoveryType=='SNAP'" data-ng-change="mountModalData.selectPointOnGraph(mountModalData.selectedSnapRP)"></select>
				        <select id="crashConsistentRPTDetailDate" data-ng-options="((timeStamp*1000)|date:'medium') for timeStamp in CRASH" data-ng-model="mountModalData.selectedCrashRP" data-ng-if="mountModalData.recoveryType=='CRASH'" data-ng-change="mountModalData.selectPointOnGraph(mountModalData.selectedCrashRP)"></select>
				        <select id="appConsistentRPTDetailDate" data-ng-options="((timeStamp*1000)|date:'medium') for timeStamp in  APP" data-ng-model="mountModalData.selectedAppRP"  data-ng-if="mountModalData.recoveryType=='APP'" data-ng-change="mountModalData.selectPointOnGraph(mountModalData.selectedAppRP)"></select>
					</div>
				</div>
				<!--  Graph START -->
				<div class="form-group" ng-if="mountModalData.errMsg">
					<div class="col-xs-12 col-md-8 padding-top-10">
						<span class="help-block"
							>
							<i class="ion-alert-circled" ></i>
							{{mountModalData.errMsg}}
						</span>
					</div>
				</div>
				<cv-blr-rp-graph boot-modal-data="mountModalData" blr-chart-config="blrChartConfig"></cv-blr-rp-graph>
				<!--  Graph END -->
		<!-- data-ng-disabled="(!mountModalData.atleastOnePathSelected)" -->
		<div class="modal-footer">
			<fmt:bundle basename="localization.messages">
				<button id="liveSyncIOFSToFSCreateMountModal_button_#9624" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
				<button id="liveSyncIOFSToFSCreateMountModal_button_#0369"  type="submit" class="btn btn-primary cvBusyOnAjax"
				data-ng-disabled="(!mountModalData.destinationClient)"
				><cv:msg key="Save" /></button>
			</fmt:bundle>
		</div>
		</div>
	</form>
</div>
</fmt:bundle>