<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>

<div data-ng-controller="restoreController">
	<div class="setup-title">
		<h1>
			<cv:msg key="label.restoreOpts" bundle="restore"/>
		</h1>
	</div>

	<div class="setup-content">
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<form class="bootstrap-wrapper" name="fsVolumeRestore" id="fsVolumeRestore" novalidate data-cv-submit="fsVolumeLevelRestore()">
			<!-- Destination client -->
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="destinationServer">
					<cv:msg key="label.destinationClient" bundle="restore"/>
				</label>
				<div class="col-xs-12 col-sm-7" data-ng-if="showdestinationClient">
					<isteven-multi-select
						input-model="restoreData.globalOptions.destinationServerList"
						output-model="destinationServer"
						button-label="name"
						item-label="name"
						tick-property="selected"
						selection-mode="single"
						class="isteven-multi-select"
						id="destinationServer"
						name="destinationServer"
						directive-id="destinationServer"
						search-property="name"
						max-height="400px"
						on-item-click="destinationServerChanged(destinationServer[0])"
						group-property="header"
						helper-elements="filter"
						translation="destinationClientLocalLang">
					</isteven-multi-select>
					<span class="help-block" data-ng-show="destinationClientRequired">
						<cv:msg key="error.destinationServer" bundle="restore"/>
					</span>
				</div>
			</div>

			<!-- Restore to original source mount point -->
			<div class="form-group">
				<div class="col-xs-12">
					<input name="restoreToOriginalMountPoint" id="restoreToOriginalMountPoint" type= "checkbox" data-ng-model="restoreData.globalOptions.restoreToOriginalPath"/>
					<label for="restoreToOriginalMountPoint">
						<cv:msg key="label.restoreToOriginalMountPoint" bundle="restore"/>
					</label>
				</div>
			</div>

			<!-- Grid for source volume and destination volume -->
			<div class="form-group">
				<div class="padding-left-10 padding-right-10">
					<cv-kendo-grid ng-if="!restoreData.globalOptions.restoreToOriginalPath && fsVolumeLevelRestoreGridOptions" data-cv-grid-options="fsVolumeLevelRestoreGridOptions"></cv-kendo-grid>
				</div>
			</div>

			<!-- Restore -->
			<div class="button-container">
				<button id="cancel" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()">
					<cv:msg key="Cancel" bundle="messages"/>
				</button>
				<button id="restore" type="submit" class="btn btn-primary cvBusyOnAjax">
					<cv:msg key="Submit" bundle="messages"/>
				</button>
			</div>
		</form>
	</div>
</div>