<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<div  data-ng-controller="fsEditCommonCollectionController">	
		<div  data-ng-controller="fsModifyCollectionContentController">
			<div class="setup-title">
				<h1 ng-hide="{{mode=='edit'}}"><fmt:message key="action.addCollection" /></h1>
				<h1 ng-show="{{mode=='edit'}}"><fmt:message key="pageHeader.editContent" /></h1>
			</div>
			<div class="global-options remove-border-padding" ng-hide="{{mode=='edit'}}">	
						<label for="name"><fmt:message key="label.name" />
							<input type="text" id="name" name="name" data-ng-model="collectionInfo.name" required
								data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.name)}" />
							<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.name)"><fmt:message key="error.name" /></span>
						</label>
					</div>
			<input id="includeSystemState" type="checkbox" ng-model="includeSystemState" checked>
			<label for="includeSystemState">Backup System State</label>
			<br>
			<span style="margin-left:20px;"></span>
			<input id="onlyOnFullBackup" type="checkbox" ng-model="onlyOnFullBackup" ng-disabled="!includeSystemState">
			<label for="onlyOnFullBackup">Only on Full Backup</label>
			<div class="includedPaths">
				<ul class="float-right clearfix">
					<li ng-click="browseClient()" class="float-left">Folder </li>
					<li ng-click="showAddPathDialog()" class="float-left">Add </li>
					<li ng-click="deletePaths()" class="float-left clearfix">Delete </li>
				</ul>
				<ul class="list-style__row clearfix">
					<li clearfix>Content To Backup</li>
				</ul>
				<ul class="list-style__row clearfix" data-ng-repeat="contentItem in contentEntityList">
					<li>
							<input id="content{{$index}}" type="checkbox" ng-model="contentItem.selected">
							<label for="content{{$index}}">{{contentItem.label}}</label>
						</li>
				</ul>
			</div>	
			<br>
			<div ng-hide="{{mode=='edit'}}" class="global-options remove-border-padding">
						
						<label for="storage" class="select-label"><fmt:message key="label.storage" />
							<select id="storage" name="storage" data-ng-model="collectionInfo.selectedLibrary"
									data-ng-options="lib.id as lib.label for lib in collectionInfo.libraries" required
									data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.storage)}">
							</select>
						</label>
						
						<br>
						<label for="retention" class="select-label"><fmt:message key="label.retentionPeriod" />
							<select id="retention" name="retention" data-ng-model="collectionInfo.retentionPeriod"
									data-ng-options="retKey as retVal for (retKey , retVal) in collectionInfo.retentionPeriodOptions" required
									data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.retention)}">							
							</select>
						</label>
						
					</div>
					
					<br>
						
			<div class="button-container">
						<fmt:bundle basename="localization.messages">
					  		<button id="fsCollectionModal_button_#7761" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancelAddCollection()"><fmt:message key="Cancel" /></button> 
							<button id="fsCollectionModal_button_#9234" type="submit" class="btn btn-primary" ng-click="OK()" ><fmt:message key="OK" /></button> 
					  	</fmt:bundle>
					</div>
		</div>
	</div>
	</fmt:bundle>
	