<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.job"></cv:cvMessages>
</script>
<fmt:setBundle basename="localization.collections" var="collections"/>
<fmt:setBundle basename="localization.servers" var="servers"/>
<fmt:setBundle basename="localization.schedule" var="schedule"/>
<!-- !!! Need to create scss class for page-details-box-links -->
<h1 class="page-title">
	<span class="name">
		<span data-ng-bind="details.subClientEntity.subclientName" ></span>
		<span data-ng-show="!details.subClientEntity.subclientName"><fmt:message key="label.loadingCollection" bundle="${collections}" /></span>
	</span>
</h1>
<div class="detailsBar cols-5" ng-if="vmBackupInfo">
	<a href="#vms?collectionId={{collectionId}}&collectionName={{details.subClientEntity.subclientName}}&status=1&serverName={{details.subClientEntity.clientName}}&serverId={{details.subClientEntity.clientId}}">
		<div class="detailsProps"><div class="detailsPropsInner">
			<span class="detail-results protected">{{getCount(vmBackupInfo.vmProtectedCount)}}</span>
			<span class=""><fmt:message key="label.protected" bundle="${servers}"/></span>
		</div></div>
	</a>
	<a href="#vms?collectionId={{collectionId}}&collectionName={{details.subClientEntity.subclientName}}&status=2&serverName={{details.subClientEntity.clientName}}&serverId={{details.subClientEntity.clientId}}">
		<div class="detailsProps"><div class="detailsPropsInner">
			<span class="detail-results notProtected">{{getCount(vmBackupInfo.vmNotProtectedCount)}}</span>
			<span class=""><fmt:message key="label.notProtected" bundle="${servers}"/></span>
		</div></div>
	</a>
	<a href="#vms?collectionId={{collectionId}}&collectionName={{details.subClientEntity.subclientName}}&status=3&serverName={{details.subClientEntity.clientName}}&serverId={{details.subClientEntity.clientId}}">
		<div class="detailsProps"><div class="detailsPropsInner">
			<span class="detail-results pending">{{getCount(vmBackupInfo.vmPendingCount)}}</span>
			<span class=""><fmt:message key="label.pending" bundle="${servers}"/></span>
		</div></div>
	</a>
	<a href="#vms?collectionId={{collectionId}}&collectionName={{details.subClientEntity.subclientName}}&status=4&serverName={{details.subClientEntity.clientName}}&serverId={{details.subClientEntity.clientId}}">
		<div class="detailsProps"><div class="detailsPropsInner">
			<span class="detail-results backedUpWithError">{{getCount(vmBackupInfo.vmBackedUpWithErrorCount)}}</span>
			<span class=""><fmt:message key="label.backedup.error" bundle="${servers}"/></span>
		</div></div>
	</a>
	<a href="#vms?collectionId={{collectionId}}&collectionName={{details.subClientEntity.subclientName}}&status=0&serverName={{details.subClientEntity.clientName}}&serverId={{details.subClientEntity.clientId}}">
		<div class="detailsProps"><div class="detailsPropsInner">
			<span class="detail-results neverBackedUp">{{getCount(vmBackupInfo.vmTotalCount)}}</span>
			<span class=""><fmt:message key="label.total" bundle="${servers}"/></span>
		</div></div>
	</a>
</div>
<div class="group">
	<div class="page-details-left">
		<div class="page-details-box maxdiv">
			<div class="page-details group">
				<span class="name"><fmt:message key="label.summary"
						bundle="${servers}" /></span>
				<ul class="list-style-secondary">
					<li class="group"><span class="detail-results"><fmt:message key="label.lastbackup.time" bundle="${collections}" /></span>
						 <span class="detail-results">{{formatted.lastBackupTime}}</span></li>
					<li class="group"><span class="detail-results"><fmt:message key="label.lastbackup.size" bundle="${collections}" /></span>
						 <span class="detail-results">{{formatted.lastBackupSize}}</span></li>
					<li class="group"><span class="detail-results"><fmt:message key="label.totalbackup.size" bundle="${collections}" /></span>
						 <span class="detail-results">{{formatted.totalBackupSize}}</span></li>
					<li class="group"><span class="detail-results"><fmt:message key="label.nextbackup.time" bundle="${collections}" /></span>
						 <span class="detail-results">{{formatted.nextBackupTime}}</span></li>
				</ul>
			</div>
		</div>
		<div class="page-details-box maxdiv">
			<div class="page-details group">
				<span class="name"><fmt:message key="label.backup" bundle="${collections}" /></span>
				<!-- <div class="page-details-box-links multiLinks">-->
					<ul class="serverBackupTile">
						<li>
							<span class="page-details-box-links multiLinks">
								<ul>
									<li ng-if="showBackup['backup']" class="restoreli" ng-click="showBackupOptions()"><a href=""><fmt:message key="action.backupNow" bundle="${collections}" /></a>
									</li>
									<li> <a href="#jobs?collectionId={{collectionId}}&collectionName={{details.subClientEntity.subclientName}}&jobType=Backup"><fmt:message
										key="action.jobs" bundle="${servers}" /></a> </li>
								</ul>
							</span>
						</li>
						<li ng-if="showBackup['backup']">
							<p class="info-place-holder"><fmt:message key="info.nobackup" bundle="${collections}"/></p>
						</li>
						<li ng-if="backupJobs.length">
							<cv-job jobs='backupJobs' show-backup='showBackup'></cv-job>
						</li>
				</ul>
			</div>
		</div>
		<div class="page-details-box maxdiv">
			<div class="page-details group">
				<span class="name"><fmt:message key="header.content" bundle="${collections}"/></span>
				<ul data-ng-repeat="ce in contentList" class="schedules-list list-style__row group viewContentList"><!-- !!! Should not use schedules-list style! -->
					<li>{{ce.label}}</li>
				</ul>
				<ul data-ng-repeat="ce in excludeList" class="schedules-list list-style__row group viewContentList"><!-- !!! Should not use schedules-list style! -->
					<li>{{ce.label}}</li>
				</ul>
				<ul data-ng-repeat="ce in includeList" class="schedules-list list-style__row group viewContentList"><!-- !!! Should not use schedules-list style! -->
					<li>{{ce.label}}</li>
				</ul>
				<div class="page-details-box-links">
					<a href=""
						data-ng-click="openModifyCollectionDialog(details.subClientEntity)"><fmt:message key="action.manage" bundle="${collections}" />
					</a>
				</div>
			</div>
		</div>
	</div>
	<div class="page-details-right">
		<div class="page-details-box maxdiv">
			<div class="page-details group">
				<span class="name"><fmt:message key="label.restore" bundle="${collections}" /></span>
				<div class="page-details-box-links multiLinks">
					<ul>
						<li><a href="#/browse/fs/{{collectionId}}/%5C"><fmt:message key="label.restore" bundle="${collections}" /></a></li>
						<li><a href="#jobs?collectionId={{collectionId}}&collectionName={{details.subClientEntity.subclientName}}&jobType=Restore"><fmt:message key="action.jobs" bundle="${servers}" /></a></li>
					</ul>
				</div>
				<div class="serverBackupTile">
					<ul ng-if="restoreJobs.length">
						<li>
							<cv-job jobs='restoreJobs'></cv-job>
						</li>
					</ul>
					<span ng-if="!restoreJobs.length">
							<p class="info-place-holder"><fmt:message key="info.norestore" bundle="${collections}"/></p>
					</span>
				</div>
			</div>
		</div>
				<div class="page-details-box maxdiv">
			<div class="page-details group" data-ng-controller=allShowScheduleListController data-ng-init="init()" >
				<span class="name"><fmt:message key="header.schedules" bundle="${schedule}"/></span>
				<span ng-show="!data.scheduleIdentifierList.length">
					<p class="info-place-holder"><fmt:message key="info.nobackup" bundle="${collections}"/></p>
				</span>
				<ul class="schedules-list list-style__row group">
					<li data-ng-repeat="scheduleIdent in data.scheduleIdentifierList" >
						<a data-ng-controller="showSheduleDialogController" href=""
							data-ng-click="showSchedules(details.subClientEntity, scheduleIdent.name)">{{scheduleIdent.name}}</a>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a data-ng-controller="showSheduleDialogController" href=""
						data-ng-click="showSchedules(details.subClientEntity)"><fmt:message key="action.manageSchedules"	bundle="${schedule}" />
					</a>
				</div>
			</div>
		</div>
		<div class="page-details-box maxdiv">
			<div class="page-details group">
				<span class="name"><fmt:message key="label.alerts" bundle="${servers}"/></span>
					<span ng-if="noAlerts">
						<p class="info-place-holder"><fmt:message key="label.noalerts" bundle="${servers}"/></p>
					</span>
					<ul class="list-style__row group" data-ng-repeat="alert in alerts">
						<li class="alertli"><a href="#alertDetails/{{alert.alert.id}}">{{alert.alert.name}}</a></li>
					</ul>
				<div class="server-message {{serverMessage.type}}" ng-if="'{{serverMessage.type}}' == 'error'" data-ng-bind="serverMessage.message"></div>
			</div>
		</div>
	</div>
</div>
