<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div>
	<div class="form-horizontal bootstrap-wrapper plan-level-sla">
		<form data-cv-submit="savePlanSLA()" autocomplete="off">
			<div class="setup-title">
				<h1><cv:msg key="label.editSLA" bundle="profiles"/></h1>
			</div>
			<div class="panel-body">
	 			<div class="form-group col-xs-12 col-lg-12">
					<label for="usePlanSLA">
						<input type="radio" id="usePlanSLA" name="usePlanSLA" data-ng-model="planSLAInfo.level" value="PLAN_DEFAULT_SLA"></input>
						<span><cv:msg key="label.usePlanSLA" bundle="profiles"/></span>
						<span data-ng-if="planSLAInfo.defaultPlanSLA > 0"class="plan-sla-days light-text-color" ><cv:msg key="label.planSLADays" bundle="profiles" params="{{planSLAInfo.defaultPlanSLA}}" /></span>
					</label>
				</div>
				<div class="form-group col-xs-12 col-lg-12">
					<label for="slaPeriod">
						<input type="radio" id="slaPeriod" name="slaPeriod" data-ng-model="planSLAInfo.level" value="SLA_FOR_LAST_N_DAYS"></input><cv:msg key="label.slaPeriod" bundle="profiles"/>
					</label>
					<select data-ng-model="planSLAInfo.slaDays" id ="slaDays" data-ng-disabled="planSLAInfo.level != 'SLA_FOR_LAST_N_DAYS'" class="sla-period">
						<option data-ng-value="1">{{slaDaysList.days1}}</option>
						<option data-ng-value="2">{{slaDaysList.days2}}</option>
						<option data-ng-value="3">{{slaDaysList.days3}}</option>
						<option data-ng-value="5">{{slaDaysList.days5}}</option>
						<option data-ng-value="7">{{slaDaysList.days7}}</option>
						<option data-ng-value="14">{{slaDaysList.days14}}</option>
						<option data-ng-value="21">{{slaDaysList.days21}}</option>
						<option data-ng-value="30" selected>{{slaDaysList.days30}}</option>
						<option data-ng-value="90">{{slaDaysList.days90}}</option>
					</select>
				</div>
				<div class="form-group col-xs-12 col-lg-12 multi-options">
					<label class="" for="excludeFromSLA">
						<input type="radio" id="excludeFromSLA" name="excludeFromSLA" data-ng-model="planSLAInfo.level" value="EXCLUDE_SLA"></input><cv:msg key="label.excludeFromSLA" bundle="profiles"/>
					</label>
					<div data-ng-if="planSLAInfo.level=='EXCLUDE_SLA'">
						<div class="btn-group include-delay" uib-dropdown >
							<a href class="uib-dropdown-toggle optional-text link delay-text" uib-dropdown-toggle >
								{{planSLAInfo.delayInterval > 0? uiActivateDelayString : uiEnabledDelayString }}
								<span data-ng-if="planSLAInfo.delayInterval > 0" data-ng-bind="(planSLAInfo.delayInterval*1000 | date : 'MMM dd, yyyy')"></span>
							</a>
							<ul id="delayInterval" uib-dropdown-menu class="dropdown-menu activity-control-dropdown cv-dropdown-style-2" role="menu">
								<div class="part-scroll">
									<li data-ng-repeat="data in includeEnableList" class="mo-padding">
										<a href="" ng-click="updateDelayIntervel(data)" data-ng-bind="data.label"></a>
									</li>
								</div>
							</ul>
							<div class="input-group calendar-wrapper date-picker">
								<input type ="text" id="customDateId" name="customDateName"
									class="date-box hide" data-datetime-picker="MM-dd-yyyy"
									data-ng-model="custom.cdate"
									data-datepicker-options="custom.dateOptions"
									data-enable-time="false"
									data-show-weeks="false"
									data-when-closed="closingDatePicker(arg)"
									data-is-open="custom.isDatePickerOpen" />
							</div>
						</div>
					</div>
				</div>
				<div class="form-group col-xs-12 col-lg-12" data-ng-if="planSLAInfo.level=='EXCLUDE_SLA'">
					<div class="reason-sec">
						<span class="col-xs-12 col-lg-4"><cv:msg key="label.excludeReason" bundle="profiles"/></span>
					       <div class="col-xs-12 col-lg-8">
					    	<textarea id="slaDescription" name="slaDescription" class="full-width" data-ng-model="planSLAInfo.slaDescription" ></textarea>
					    </div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button id="planSLA_button_#5374" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="settings" /></button>
				<button id="planSLA_button_#6105" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="settings" /></button>
			</div>
		</form>
	</div>
</div>