<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<h1><cv:msg key="label.options" bundle="profiles"/></h1>
<div class="serverMessage" data-ng-class="retentionPoliciesServerMessage.type" data-ng-bind="retentionPoliciesServerMessage.message"></div>
<div class="row">
	<div class="col-md-12">
		<cv-tile-component data-ac-id="label_networkResources-profiles" data-title='<cv:msg key="label.networkResources" bundle="profiles"/>'>
			<div data-ng-if="::disableLaptopPlanOptions" class="extra-top-padding text-center subtext medium-size">
				<span><cv:msg key="label.overrideOptionsHelpText.notAllowed.short" bundle="profiles"/></span>
			</div>
			<!--  // throttle send start // -->
			<div class="cv-modal-wrapper margin-top-bottom" data-ng-disabled="::disableLaptopPlanOptions">
				<label for="maxLANBandwidth" class="cv-label line-height28"><cv:msg key="label.maxLANBandwidth" bundle="profiles"/></label>
				<div class="cv-inline-wrapper">
					<div>
						<input type="checkbox" data-ng-model="throttle.send" id="throttleSend" name="throttleSend">
						<label for="throttleSend" class="inline-label no-margin"><cv:msg key="label.infinite" bundle="profiles"/></label>
						<input data-ng-disabled="throttle.send" data-ng-class="{disabled: throttle.send}" name="maxLANBandwidth" id="maxLANBandwidth" type="number" min="1" data-ng-model="globalTemplate.networkResources.maxLANBandwidth" id="lan" />
						<label data-ng-disabled="throttle.send" for="maxLANBandwidth" class="inline-label no-margin"><cv:msg key="label.kbps" bundle="profiles"/></label>
					</div>
				</div>
			</div>
			<!--  // throttle send end // -->
			<!--  // throttle receive start // -->
			<div class="cv-modal-wrapper margin-top-bottom" data-ng-disabled="::disableLaptopPlanOptions">
				<label for="wan" class="cv-label line-height28"><cv:msg key="label.maxWANBandwidth" bundle="profiles"/></label>
				<div class="cv-inline-wrapper">
					<div>
						<input type="checkbox" data-ng-model="throttle.receive" id="throttleReceive" name="throttleReceive">
						<label for="throttleReceive" class="inline-label no-margin"><cv:msg key="label.infinite" bundle="profiles"/></label>
						<input data-ng-disabled="throttle.receive" data-ng-class="{disabled: throttle.receive}" name="maxWANBandwidth" type="number" min="1" data-ng-model="globalTemplate.networkResources.maxWANBandwidth" id="wan" />
						<label data-ng-disabled="throttle.receive" for="wan" class="inline-label no-margin"><cv:msg key="label.kbps" bundle="profiles"/></label>
					</div>
				</div>
			</div>
			<!--  // throttle receive end // -->
		</cv-tile-component>
		<cv-tile-component data-ac-id="label_alerts-profiles" data-title='<cv:msg key="label.alerts" bundle="profiles"/>' min-height="true">
			<div class="cv-wizard-wrapper">
				<div class="cv-inline-wizard-wrapper">
					<label class="cv-inline-checkbox large" data-ng-repeat="alert in alertList">
						<input type="checkbox" id="alert-{{alert.alertId}}" data-ng-model="alert.selected" />
						<label for="alert-{{alert.alertId}}" class="cv-checkbox-label">{{alert.alertName}}</label>
					</label>
				</div>
			</div>
		</cv-tile-component>
	</div>
	<div class="col-xs-12" data-ng-if="createLaptopPlan && !disableLaptopPlanOptions" data-ng-disabled="::disableLaptopPlanOptions">
		<div class="page-details-box maxdiv">
			<div class="page-details group">
				<cv-derive-settings data-sealed="globalTemplate.sealed" data-model="globalTemplate.deriveSettingsInputModel"
						data-tooltip-class="cv-text">
					<cv-derive-select data-name="SubclientPolicyWin" data-class="cv-modal-wrapper margin-top-bottom"
							data-label-class="cv-label line-height28" data-select-class="cv-inline-wrapper">
						<cv:msg key="label.folderToBackup" bundle="profiles" />
					</cv-derive-select>
					<cv-derive-select data-name="SubclientPolicyLin" data-group-with="SubclientPolicyWin"></cv-derive-select>
					<cv-derive-select data-name="SubclientPolicyMac" data-group-with="SubclientPolicyWin"></cv-derive-select>
					<cv-derive-select data-name="StoragePolicy" data-class="cv-modal-wrapper margin-top-bottom"
							data-label-class="cv-label line-height28" data-select-class="cv-inline-wrapper">
						<span><cv:msg key="label.storagePool" bundle="profiles" /></span><%--
						<span class="subtext medium-size"><cv:msg key="label.retentionDays" bundle="collections" /></span>--%>
					</cv-derive-select>
					<cv-derive-select data-name="SchedulePolicy" data-class="cv-modal-wrapper margin-top-bottom"
							data-label-class="cv-label line-height28" data-select-class="cv-inline-wrapper">
						<cv:msg key="label.rpo" bundle="profiles" />
					</cv-derive-select>

					<cv-derive-select data-name="SubclientRetentionWin" data-class="cv-modal-wrapper margin-top-bottom"
							data-label-class="cv-label line-height28" data-select-class="cv-inline-wrapper">
						<cv:msg key="label.retention" bundle="profiles" />
					</cv-derive-select>
					<cv-derive-select data-name="SubclientRetentionLin" data-group-with="SubclientRetentionWin"></cv-derive-select>
					<cv-derive-select data-name="SubclientRetentionMac" data-group-with="SubclientRetentionWin"></cv-derive-select>
				</cv-derive-settings>
			</div>
		</div>
	</div>
</div>
<div class="button-container">
	<button id="retentionPoliciesProfile_button_#5812" type="button" data-ng-click="goPreviousStep()"
		class="btn btn-default cvBusyOnAjax"><cv:msg key="action.previous" bundle="profiles"/></button>
	<button id="retentionPoliciesProfile_button_#6236" type="button" data-ng-click="saveRetentionPoliciesTab()"
		class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.next" bundle="profiles"/></button>
 	<!-- <button id="submitForCreatePlan" data-ng-if="createLaptopPlan" type="button" data-ng-click="saveRetentionPoliciesTab()"
		class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.finish" bundle="profiles"/></button> -->
</div>