<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1><cv:msg key="label.releaseLicense" bundle="servers"/></h1>
	</div>
	<div class="setup-content">
		<div data-ng-if="!isResponse">
			<form name="releaseLicenseForm" novalidate cv-submit="releaseLicense()" autocomplete="off">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
				<div class="dlo-modal-wrapper">
					<div class="setup-wrapper">
						<div data-ng-if="availableLicenses.length != 0">
							
							<div class="dlo-inline-wrapper">
								<label class="multiple-checkbox-group auto-width-checkbox padding-left" data-ng-repeat="licenseInfo in availableLicenses">
									<input type="checkbox" name="{{licenseInfo.license.licenseType}}" value="{{licenseInfo}}" id="{{licenseInfo.license.licenseType}}" data-ng-model="licenseInfo.license.checked" />
									<label class="checkbox-label" for="{{licenseInfo.license.licenseType}}">{{licenseInfo.license.licenseName}}</label>
								</label>
							</div>
						</div>
						<div data-ng-if="availableLicenses.length == 0">
							<p><cv:msg key="error.noAvailableLicense" /></p>
						</div>
					</div>
				</div>
				<div class="button-container">
					<button id="releaseLicenseModal_button_#2290" type="button" class="btn btn-default" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
					<button id="releaseLicenseModal_button_#5232" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK"/></button> 
				</div>
			</form>
		</div>
		<div data-ng-if="isResponse">
			<p data-ng-bind-html="responseContent"></p>
			<div class="button-container">
				<button id="releaseLicenseModal_button_#7342" type="submit" class="btn btn-primary" data-ng-disabled="" data-ng-click="close()"><cv:msg key="OK" /></button> 
			</div>
		</div>
</div>