<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.devicesJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1><cv:msg key="action.addDevice" bundle="devicesJs"/></h1>
	</div>
	<div class="setup-content">
		<div data-ng-if="!isResponse">
			<form name="pushInstallSoftwareForLaptopForm" novalidate data-cv-submit="installSoftware()" autocomplete="off">
				<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="osTypeWINDOWS"><cv:msg key="label.osType" bundle="serversJs"/></label>
						<div class="cv-inline-wrapper">
							<cv-radio-group  class="cv-inline-wrapper" radio-name="osType" radio-model="model.clientInfo.osType" radio-obj="osTypeObj"></cv-radio-group>
						</div>
					</div>
					<div class="cv-modal-wrapper add-device-hostname">
						<label class="cv-label" for="hostName"><cv:msg key="label.hostName" bundle="serversJs"/></label>
						<div class="cv-inline-wrapper">
							<textarea name="hostName" placeholder="<cv:msg key='info.hostNamePlaceholder' bundle='serversJs'/>" id="hostName" data-ng-model="model.clientInfo.hostName" required data-ng-class="{'has-error': cv.pushInstallSoftwareForLaptopForm.needsAttention(pushInstallSoftwareForLaptopForm.hostName)}"></textarea>
							<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForLaptopForm.needsAttention(pushInstallSoftwareForLaptopForm.hostName) || showError"><cv:msg key="error.hostName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="fakeUserName"><cv:msg key="label.userName" bundle="servers" /></label>
						<div class="cv-inline-wrapper">
							<input type="text" name="fakeUserName" id="fakeUserName" data-ng-model="model.clientInfo.userName" required autoCompleteType="disable" autocomplete="off" placeholder="Example: domain\username"/>
							<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForLaptopForm.needsAttention(pushInstallSoftwareForLaptopForm.fakeUserName) || showError"><cv:msg key="error.userName" bundle="servers" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="fakePassword"><cv:msg key="label.password" bundle="servers" /></label>
						<div class="cv-inline-wrapper">
							<input type="password" name="fakePassword" id="fakePassword" data-ng-model="model.clientInfo.password"  required autoCompleteType="disable" autocomplete="off"/>
							<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForLaptopForm.needsAttention(pushInstallSoftwareForLaptopForm.fakePassword) || showError"><cv:msg key="error.password" bundle="servers" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="users" /></label>
						<div class="cv-inline-wrapper">
							<input type="password" name="confirmPassword" id="confirmPassword" data-ng-model="model.clientInfo.confirmPassword"  data-cv-equals="{{model.clientInfo.password}}" required autoCompleteType="disable" autocomplete="off"/>
							<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForLaptopForm.needsAttention(pushInstallSoftwareForLaptopForm.confirmPassword) || showError"><cv:msg key="error.password" bundle="servers" /></span>
							<span class="cv-help-block" data-ng-show="!pushInstallSoftwareForLaptopForm.confirmPassword.$error.required && !cv.pushInstallSoftwareForLaptopForm.confirmPassword.$error.cvEquals && cv.pushInstallSoftwareForLaptopForm.needsAttention(pushInstallSoftwareForLaptopForm.confirmPassword)">
							<cv:msg key="error.mismatchedPassword" bundle="users" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<p class="small-info-text text-left"><cv:msg key="info.loginCredentials" bundle="serversJs" /></p>
					</div>
					<div class="cv-modal-wrapper">
						<p class="info-text text-center interactive-install-link">
							<cv:msg key="info.interactiveInstallation" bundle="serversJs" />
							<a href="/webconsole/summary/addComputer.do" target="_blank"><cv:msg key="label.here" bundle="messagesJs" /></a>
						</p>
					</div>
					<div class="button-container">
						<button id="pushInstallSoftwareForLaptopDialog_button_#0638" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
						<button id="pushInstallSoftwareForLaptopDialog_button_#6695" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="label.install" bundle="servers"/></button> 
					</div>
				</form>
			</div>
			<div data-ng-if="isResponse">
				<p><cv:msg key="label.redirect" bundle="serversJs"/> <a data-ng-click="redirectToJobs(jobId)">{{jobId}}</a></p>
				<div class="button-container">
					<button id="pushInstallSoftwareForLaptopDialog_button_#2429" type="submit" class="btn btn-primary" data-ng-disabled="" data-ng-click="close()"><cv:msg key="OK" /></button> 
				</div>
			</div>
	</div>
</div>