<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1><cv:msg key="label.pushInstallSoftware" bundle="servers"/></h1>
	</div>
	<div class="setup-content">
		<div data-ng-if="!isAuthenticated && !isResponse">
			<form name="pushInstallSoftwareForm" novalidate cv-submit="pushInstallMA()" autocomplete="off" class="push-install-software-form">
				<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
					<div class="dlo-modal-wrapper">
						<label class="dlo-label" for="clientName"><cv:msg key="label.clientName" bundle="serversJs"/></label>
						<div class="dlo-inline-wrapper">
							<input type="text" name="clientName" data-ng-model="model.clientInfo.clientName" data-ng-class="{'has-error': cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.clientName)}" required />
							<span class="dlo-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.clientName) || showError"><cv:msg key="error.clientName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="dlo-modal-wrapper">
						<label class="dlo-label" for="hostName"><cv:msg key="label.hostName" bundle="serversJs"/></label>
						<div class="dlo-inline-wrapper">
							<input type="text" name="hostName" data-ng-model="model.clientInfo.hostName" data-ng-class="{'has-error': cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.hostName)}" />
							<span class="dlo-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.hostName) || showError"><cv:msg key="error.hostName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="dlo-modal-wrapper">
						<label class="dlo-label" for="vsUserName"><cv:msg key="label.userName" bundle="servers" /></label>
						<div class="dlo-inline-wrapper">
							<input type="text" name="vsUserName" data-ng-model="model.clientInfo.vsUserName" required autoCompleteType="disable" autocomplete="off"/>
							<span class="dlo-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.vsUserName) || showError"><cv:msg key="error.userName" bundle="servers" /></span>
						</div>
					</div>
					<div class="dlo-modal-wrapper">
						<label class="dlo-label" for="vsPassword"><cv:msg key="label.password" bundle="servers" /></label>
						<div class="dlo-inline-wrapper">
							<input type="password" name="vsPassword" data-ng-model="model.clientInfo.vsPassword"  required autoCompleteType="disable" autocomplete="off"/>
							<span class="dlo-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.vsPassword) || showError"><cv:msg key="error.password" bundle="servers" /></span>
						</div>
					</div>
					<div class="button-container">
						<button id="pushInstallDialog_button_#5826" type="button" class="btn btn-default" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
						<button id="pushInstallDialog_button_#4945" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save"/></button> 
					</div>
				</form>
			</div>
			<div data-ng-if="isAuthenticated && !isResponse">
				<div class="dlo-modal-wrapper">
					<label class="dlo-label"><cv:msg key="label.selectRole" bundle="serversJs" /> {{model.clientInfo.clientName}}</label>
					<div class="dlo-inline-wrapper">
						<label class="multiple-checkbox-group padding-left" data-ng-repeat="role in roles">
							<input type="checkbox" name="{{role}}" value="{{role}}" id="{{role}}" />
							<!-- TODO: localize role -->
							<label class="checkbox-label" for="{{role}}">{{role}}</label>
						</label>
					</div>
				</div>
				<div class="button-container">
					<button id="pushInstallDialog_button_#5583" type="button" class="btn btn-default" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
					<button id="pushInstallDialog_button_#1571" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK"/></button> 
				</div>
			</div>
			<div data-ng-if="isAuthenticated && isResponse">
				<p data-ng-bind-html="responseContent"></p>
				<div class="button-container">
					<button id="pushInstallDialog_button_#9548" type="submit" class="btn btn-primary" data-ng-disabled="" data-ng-click="close()"><cv:msg key="OK" /></button> 
				</div>
			</div>
	</div>
</div>