<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>

	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.users"></cv:cvMessages>
		<cv:cvMessages bundle="localization.security"></cv:cvMessages>
	</script>

	<div class="setup-title">
		<h1>{{title}}</h1>
	</div>
	<div class="modal-body padding-bottom-0">
		<div class="form-group title">
			<div class="row margin-0">
				<div class="btn col col-md-6 col-xs-6 radio-tile radio-tile-left" ng-class="{'selected-tile': authenticationChoice == 1}" ng-click="authenticationChoice=1">
					<cv:msg key="label.ldap" bundle="users"/>
				</div>
				<div class="btn col col-md-6 col-xs-6 radio-tile radio-tile-right" ng-class="{'selected-tile': authenticationChoice == 2}" ng-click="authenticationChoice=2">
					<cv:msg key="label.saml" bundle="users"/>
				</div>
			</div>
		</div>
		<div>
			<span>
				<i class="glyphicon glyphicon-info-sign tile-tooltip display-inline no-left-padding"></i>
				<span ng-if="authenticationChoice == 1"><cv:msg  key="info.ADTabInfo" bundle="security"/></span>
				<span ng-if="authenticationChoice == 2"><cv:msg key="info.SAMLTabInfo" bundle="security"/></span>
			</span>
		</div>

	</div>

	<div class="setup-content remove-top-padding" data-ng-show="authenticationChoice == 1">

		<div>
		<p class="{{nameServerWindowMessage.type}} serverMessage">{{nameServerWindowMessage.message}}</p>
			<p class="{{domainExistedMessage.type}} serverMessage">{{domainExistedMessage.message}}</p>


		<form data-cv-submit ="configureAsAD()" novalidate autocomplete="off" name ="addNameServerForm">
			<cv-add-name-server/>
			<div class="button-container">
				<button id="manageDomain_button_#6449" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="users" /></button>
				<button id="manageDomain_button_#4581" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="users" /></button>
			</div>
		</form>
		</div>
	</div>
	<div data-ng-show="authenticationChoice == 2">
		<ng-include src="getThirdPartyAppPath()"></ng-include>
	</div>
</div>