<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.settings">
<!-- Adding the following hardcoded breadcrumb to show when the user is an admin on the commcell level, but hasn't completed the core setup yet. -->
<!-- This allows the user to go back to the getting started page since there will be no nav -->
<!-- !! This is planned to be fixed in SP7 !! -->
<div class="nav-breadcrumbs group ng-scope" data-ng-if="showBreadcrumbs"
	style="display: inline-block !Important">
	<div>
		<span class="group">
			<ul class="nav-breadcrumbs__list ng-scope">
				<li><a data-ng-href="#gettingStarted">{{'label.gettingStarted' | cvLoc}}</a></li>
			</ul>
		</span>
	</div>
</div>
<h1 class="page-title">
	<span class="name">
		<fmt:message key="pageHeader.license" />
	</span>
</h1>
<div class="row">
	<div class="col-lg-6 col-md-9 col-sm-12">
	<div class="{{licenseMessage.type}} serverMessage">{{licenseMessage.message}}</div>
	<cv-tile-component data-title='<fmt:message key="label.licenseDetails" />' loader="license" data-ng-if="license.length !== 0">
		<div class="page-details-box-links">
			<a href="" data-ng-click="showApplyLicenseDialog()">
				<span data-ng-if="license.licenseMode !== 'EVALUATION'"><fmt:message key="action.updateLicense"/></span>
			</a>
		</div>
		<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.commcellId" /></span>
					<span class="pageDetailColumn">{{license.commcellHex}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.commServeIPAddress" /></span>
					<span class="pageDetailColumn">{{license.licenseInfo.csHostNameOrAddress}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.licenseIPAddress" /></span>
					<span class="pageDetailColumn">{{license.licenseInfo.licenseIpAddress}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.edition" /></span>
					<span class="pageDetailColumn">{{license.licenseInfo.oemName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.licenseMode" /></span>
					<span class="pageDetailColumn" data-ng-class="{'error':license.licenseMode === 'EVALUATION'}">{{license.licenseMode}}  <a href=""   title="<fmt:message key='action.applyLicense' />" data-ng-click="showApplyLicenseDialog()" data-ng-if="license.licenseMode === 'EVALUATION'"><fmt:message key="action.applyLicense"/></a> </span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.serialNumber" /></span>
					<span class="pageDetailColumn">{{license.licenseInfo.serialNo}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.registrationCode" /></span>
					<span class="pageDetailColumn">{{license.licenseInfo.regCode}}</span>
				</li>
				<li data-ng-show="license.licenseInfo.expiryDate" class="group">
					<span class="pageDetailColumn"><fmt:message key="label.expiryDate" /></span>
					<strong class="pageDetailColumn">{{license.licenseInfo.expiryDate*1000 | date}}</strong>
				</li>
				<%-- <li class="group">
					<span class="pageDetailColumn" data-ng-show='!license.isRegistered'><fmt:message key="label.notRegistered" /></span>
					<span class="pageDetailColumn" data-ng-show='license.isRegistered'><fmt:message key="label.registered" /></span>
					<span class="pageDetailColumn add-bottom-margin">
						<a data-ng-click='registerLicense()' data-ng-if='!license.isRegistered' title='<fmt:message key="action.register" />'><fmt:message key="action.register" /></a>
					</span>
				</li> --%>
				<li class="group">&nbsp;</li><!-- Spacing -->
				<li class="group" data-ng-if="license.licenseMode === 'EVALUATION' && license.licenseInfo.expiryDate">
					<span class="pageDetailColumn full-width">
						<fmt:message key="info.evalLicenseExpiry" /> {{license.licenseInfo.expiryDate*1000 | date:'MMM d, y' }}
					</span>
				</li>
				<li class="group" data-ng-if="license.licenseMode === 'EVALUATION' && license.licenseInfo.expiryDate===0">
					<span class="pageDetailColumn full-width">
						<fmt:message key="label.licenseExpired" />
					</span>
				</li>

				<li class="group" data-ng-if="license.licenseMode === 'PRODUCTION' && license.licenseInfo.expiryDate && showLicenseWarning">
					<span class="pageDetailColumn full-width">
						<fmt:message key="info.permanentLicenseExpiry" /> {{license.licenseInfo.expiryDate*1000 | date:'MMM d, y' }}
					</span>

				</li>
				<li class="group" data-ng-if="license.licenseMode === 'PRODUCTION' && license.licenseInfo.expiryDate && isLicenseExpired">
					<span class="pageDetailColumn full-width">
						<fmt:message key="label.permanentlicenseExpired" />
					</span>
				</li>

				<li class="group">
					<span class="pageDetailColumn full-width">
						<fmt:message key="info.additionalLicense" /> <a target="_blank" href="https://ma.commvault.com/Support/ProductRegistration"><fmt:message key="info.registrationForm" /></a>
					</span>
				</li>
			</ul>
	</cv-tile-component>
	</div>
	<div class="col-lg-6 col-md-9 col-sm-12">
		<!--<cv-tile-component data-title='<fmt:message key="pageHeader.registration" />'>
			<div class="page-details-box-links">
				<a href="" data-ng-click="registerLicense()" data-ng-if="!hideForm"><fmt:message key="action.register" /></a>
			</div>
			<ul class="list-style-secondary">
				<li class="group">
					{{registerCloudMessage.message}}
				</li>
				<li class="group">
					<span class="subtext-unspaced medium-size">
						<span class="glyphicon glyphicon-info-sign"></span> <fmt:message key="info.registrationInfo" />
					</span>
				</li>
			</ul>
		</cv-tile-component> -->
		<cv-tile-component data-ac-id="tile-license-usage" data-title='<fmt:message key="pageHeader.usage" />'>

			<ul class="list-style-secondary">
				<li class="group" >
					<cv:msg key="label.licenseUsage" bundle="settings" /> <a data-ng-href="{{usageReportUrl}}" target="_blank" data-ng-bind="usageLabel"></a>
				</li>

				<li class="group">
					<span class="subtext-unspaced medium-size">
						<span class="glyphicon glyphicon-info-sign"></span> <fmt:message key="info.licenseUsageInfo" />
					</span>
				</li>
			</ul>
		</cv-tile-component>
	</div>
</div>
</fmt:bundle>