<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<h1><cv:msg key="label.general" bundle="profiles" /></h1>
<div class="serverMessage" data-ng-class="generalSetupMessage.type" data-ng-bind="generalSetupMessage.message"></div>
<div class="cv-modal-wrapper">
	<!-- // name // -->
	<div class="setup-wrapper">
		<label for="planName" class="cv-label cv-no-padding"><cv:msg key="label.profileName" bundle="profiles" /></label>
		<div class="cv-inline-wrapper">
			<input id="planName" type="text" name="profileName" data-ng-model="globalTemplate.name" data-autoselect="{{autoSelect}}" autofocus/>
		</div>
	</div>
	<div data-ng-if="::disableLaptopPlanOptions" class="extra-top-padding text-center subtext medium-size">
		<span><cv:msg key="label.overrideOptionsHelpText.notAllowed.short" bundle="profiles"/></span>
	</div>
	<!-- // check boxes // -->
	<div class="setup-wrapper extra-top-padding" data-ng-disabled="::disableLaptopPlanOptions">
		<label class="cv-label cv-no-padding"><cv:msg key="label.allowedFeatures" bundle="profiles" /></label>
		<div class="cv-inline-wrapper padding-left" >
			<label class="multiple-checkbox-group" data-ng-repeat="feature in globalTemplate.features">
				<input id="{{feature.id}}" type="checkbox" data-ng-model="feature.selected" checked data-ng-change="showFeatures(feature)"/>
				<label class="checkbox-label" for="{{feature.id}}" data-ng-bind="feature.name"></label>
			</label>
		</div>
	</div>
</div>
<br/>
<br/>
<div class="bootstrap-wrapper form-horizontal">
<div class="row ng-scope" data-ng-if="!disableLaptopPlanOptions">
	<div class="col-md-12">
	<cv-tile-component data-ac-id="label_edgeDrive-profiles" data-title='<cv:msg key="label.edgeDrive" bundle="profiles"/>' min-height="false" data-ng-if="showEdgeSetting">
			<div class="component-container">
				<div class="serverMessage" data-ng-class="edgeDriveInfoMessage.type" data-ng-bind="edgeDriveInfoMessage.message"></div>
					<div class="content-wrapper">
						<label for="newEdgeDrive" class="radio-label" data-ng-show="agentList.length > 0" >
							<input data-ng-hide="!maList || maList.length == 0" id="newEdgeDrive" type="radio" name="newEdgeDrive" value="newEdgeDrive"
									data-ng-model="edgeDrive" data-ng-change="newEdgeDriveChange()"/><cv:msg key="label.newEdgeDrive" bundle="profiles"/>
                        </label>
                        <label for="existingEdgeDrive" class="radio-label" data-ng-show="maList.length > 0">
                        	<input data-ng-hide="!agentList || agentList.length == 0" id="existingEdgeDrive" type="radio" name="exsitingEdgeDrive" value="exsitingEdgeDrive"
                        		data-ng-model="edgeDrive" data-ng-change="existingEdgeDriveChange()"/><cv:msg key="label.existingEdgeDrive" bundle="profiles"/>
                        </label>
                    </div>
            </div>
			<!--// Existing Edge Drive //-->
			<div class="form-group" data-ng-if="edgeDrive == 'exsitingEdgeDrive' && maList.length > 0"  class="margin-bottom-5">
				<label class="col-xs-12 col-lg-4" for="mediaAgent"><cv:msg key="label.indexServer" bundle="profiles" /></label>
				<div class="col-xs-12 col-lg-7"><select id="mediaAgent" name="mediaAgent" data-ng-model="globalTemplate.edgeDrive"
														data-ng-options="agent.clientName for agent in maList track by agent.clientId">
													<option value=""><cv:msg key="placeholder.selectIndexServer" bundle="profiles"/></option>
												</select></div>
			</div>
			<!--// Existing Edge Drive end //-->
			<!-- Create a new Edge Drive -->
			<form name="edgeSettingsForm" data-ng-if="edgeDrive == 'newEdgeDrive' && agentList.length > 0 " novalidate>
			<div class="form-group" data-ng-if="edgeDrive == 'newEdgeDrive' && agentList.length > 0"  class="margin-bottom-5">
				<label class="col-xs-12 col-lg-4" for="client"><cv:msg key="label.client" bundle="profiles" /></label>
				<div class="col-xs-12 col-lg-7">
					<select id="client" name="client" data-ng-model="globalTemplate.edgeDrive.mediaAgent" data-ng-options="agent.clientName for agent in agentList track by agent.clientId" data-ng-change="getOsType(globalTemplate.edgeDrive.mediaAgent.clientId, true)">
							<option value=""><cv:msg key="placeholder.selectNode" bundle="profiles"/></option>
					</select></div>
			</div>
				
			<div data-ng-if="edgeDrive == 'newEdgeDrive'" class="form-group">
				<label class="col-xs-12 col-lg-4" for="mountPath"><cv:msg key="label.indexDirectory"  bundle="profiles" /></label>
				<div class="col-xs-12 col-lg-7">
					<div class="input-group">
						<input type="text" class="indexServerPath" name="mountPath" id="mountPath" data-ng-disabled="!globalTemplate.edgeDrive.mediaAgent"
								data-ng-class="{disabled: !globalTemplate.edgeDrive.mediaAgent}"
								data-ng-model="globalTemplate.edgeDrive.mountPath" required data-ng-pattern='pathPattern'/>
						<span class="input-group-btn">
							<button id="generalSetup_button_#6532" type="button" data-ng-click="browse()" class="btn btn-default browse-btn float-right margin-0"><cv:msg key="Browse" bundle="storage"/></button> 
						</span>
					</div>
				</div>
			</div>
			</form>
			<div class="cv-modal-wrapper padding-top-bottom inline-label less-margin">
				<div class="cv-inline-wrapper float-none">
					<input type="checkbox" data-ng-model="model.auditDriveActivities" id="auditDriveActivities" name="auditDriveActivities">
					<label for="auditDriveActivities" class="inline-label right-margin"><cv:msg key="label.auditDriveActivities" bundle="profiles"/></label>
					<input type="checkbox" data-ng-model="model.enableNotificationsForShares" id="enableNotificationsForShares" name="enableNotificationsForShares">
					<label for="enableNotificationsForShares" class="inline-label no-margin"><cv:msg key="label.enableNotificationsForShares" bundle="profiles"/></label>
				</div>
			</div>
			<jsp:include page="edgeDriveQuota.jsp"></jsp:include>
		</cv-tile-component>
		<cv-tile-component data-ac-id="label_archivingRules-profiles" data-ng-if="showArchiving" data-title='<cv:msg key="label.archivingRules" bundle="profiles"/>'  min-height="true" >
			<span data-ng-show="!globalTemplate.archivingRules.enableArchivingWithRules"><p class="info-place-holder"><cv:msg key="error.archivingRulesNotEnabled" bundle="profiles" /> </p></span>
			<ul data-ng-if="globalTemplate.archivingRules.enableArchivingWithRules" class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.startCleanDisk" bundle="profiles" /></span>
					 <span class="pageDetailColumn">{{globalTemplate.archivingRules.startCleaningIfLessThan}}<cv:msg key="label.free" bundle="profiles" /></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.stopCleanDisk" bundle="profiles" /></span>
					 <span class="pageDetailColumn">{{globalTemplate.archivingRules.stopCleaningIfupto}}<cv:msg key="label.free" bundle="profiles" /></span></li>
			</ul>
			<div class="page-details-box-links multiLinks">
				<a href="" data-ng-click="addAchivingRules()"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>
	</div>
</div>
</div><!-- // close bootstrap wrapper // -->
<div data-ng-if="showPlanSetup" class="button-container">
	<button id="generalSetup_button_#0022" type="button" data-ng-disabled="disableNextOnGeneralTab" data-ng-click="saveGeneralTab()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.next" bundle="profiles" /></button> 
</div>
